varying vec2 v_texture;

#ifdef VERTEX_SHADER
attribute vec4 a_vertex;
attribute vec2 a_texture;

uniform mat4 u_mvpMatrix;

void main()
{
    v_texture = a_texture;
	gl_Position = u_mvpMatrix * a_vertex;
}
#endif // VERTEX_SHADER

/****************************************
 *  FRAGMENT SHADER
 ****************************************/
#ifdef FRAGMENT_SHADER

uniform sampler2D		u_tex0;
uniform sampler2D		u_tex1;

uniform float u_fMix;

void main()
{
	vec4 day = texture2D(u_tex0, v_texture);
	vec4 night = texture2D(u_tex1, v_texture);

	gl_FragColor = mix(night, day, u_fMix);
	//gl_FragColor = day * max(u_fMix,1.0);
	//float b = (u_fMix > 1 ) ? 1 : 0;
	//gl_FragColor = vec4(u_fMix,0,b,1);
}
#endif // FRAGMENT_SHADER
