varying vec2 v_texture;
varying vec2 v_texture1;
varying vec3 v_normal;
#ifndef DISABLE_SHADOW_MAPPING
varying mediump vec4 v_shadowCoordsStatic;
varying mediump vec4 v_shadowCoordsDynamic;
#endif


varying vec3 v_vWorldPosition;
uniform mat4 u_worldMatrix;


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////					   VERTEX SHADER						/////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
#ifdef VERTEX_SHADER

uniform mat4 u_mvpMatrix;
uniform mat4 u_mvMatrix;
#ifndef DISABLE_SHADOW_MAPPING
uniform mat4 u_lightMatrixStatic;
#ifdef SHADOW_DUAL
uniform mat4 u_lightMatrixDynamic;
#endif
#endif

attribute vec4 a_vertex;
attribute vec3 a_normal;
attribute vec4 a_colour;
attribute vec2 a_texture;
attribute vec2 a_texture1;

void main()
{
    // Transform object-space normals to eye-space
    vec4 vNormal = u_mvMatrix * vec4(a_normal, 0.0);

    // Pass everything off to the fragment shader
    gl_Position = u_mvpMatrix * a_vertex;
    v_normal	= normalize(vNormal.xyz);
	v_texture	= vec2(a_texture.x, 1.0-a_texture.y); // #MSC:TODO - Fix this in mesh, why is it even inverted?!
	v_texture1  = vec2(a_texture1.x, 1.0-a_texture1.y);
#ifndef DISABLE_SHADOW_MAPPING
	v_shadowCoordsStatic = u_lightMatrixStatic * a_vertex;
#ifdef SHADOW_DUAL
	v_shadowCoordsDynamic = u_lightMatrixDynamic * a_vertex;
#endif
#endif

	v_vWorldPosition = (u_worldMatrix * a_vertex).xyz;
}
#endif // VERTEX_SHADER

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////					  FRAGMENT SHADER						/////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
#ifdef FRAGMENT_SHADER

uniform sampler2D u_texCrowd0;
uniform sampler2D u_texSeat1;
#ifdef SPLIT_ALPHA
uniform sampler2D u_texCrowdAlpha2;
#endif
uniform vec3 u_LightDir;
uniform vec3 u_AmbientMat;
uniform vec3 u_LightColour;

#ifndef DISABLE_SHADOW_MAPPING
  #ifdef GLES
    #ifdef GL_EXT_shadow_samplers
      #define SHADOWSAMPLER sampler2DShadow
      #define SHADOW2DPROJ(a,b) shadow2DProjEXT(a,b)
    #else
      #define SHADOWSAMPLER sampler2D
      #define SHADOW2DPROJ(a,b) clamp((b.w * texture2DProj(a, b).x - b.z) * 1000000.0 + 1.0, 0.0, 1.0)
    #endif
  #else
    #define SHADOWSAMPLER sampler2DShadow
    #define SHADOW2DPROJ(a,b) shadow2DProj(a,b).r
  #endif
  uniform lowp SHADOWSAMPLER u_texShadowMap5;
#endif

#ifdef NUM_POINTLIGHTS
  uniform vec4 u_PointLights[10];// XYZ position, W intensity
  uniform float u_NumPointLights;
  float GetLightContribution(int index)
  {
	  float distance = length(u_PointLights[index].xyz - v_vWorldPosition);
	  float distpercent = distance / u_PointLights[index].w;
	  distpercent *= distpercent;
	  return clamp(1.0 - distpercent, 0.0, 1.0);
  }
#endif

void main()
{
#ifndef DISABLE_SHADOW_MAPPING
	float fShadow = SHADOW2DPROJ( u_texShadowMap5, v_shadowCoordsStatic );
#ifdef SHADOW_DUAL
	vec4 vShadowCoords2 = v_shadowCoordsDynamic;
	vShadowCoords2.x = max(0.501, vShadowCoords2.x);
	float fShadow2 = SHADOW2DPROJ( u_texShadowMap5, vShadowCoords2 );
	fShadow = min(fShadow, fShadow2);
#endif
#endif

#ifdef SPLIT_ALPHA
	vec4 vTexCrowd = vec4(texture2D(u_texCrowd0, v_texture).rgb, texture2D(u_texCrowdAlpha2, v_texture).a);
	vec4 vTexDiffuse = mix(texture2D(u_texSeat1, v_texture1), vTexCrowd, vTexCrowd.a);
	//vec4 vTexDiffuse = mix(texture2D(u_texSeat1, v_texture1), texture2D(u_texCrowd0, v_texture), texture2D(u_texCrowdAlpha2, v_texture1).a);
#else
	vec4 vTexDiffuse = mix(texture2D(u_texSeat1, v_texture1), texture2D(u_texCrowd0, v_texture), texture2D(u_texCrowd0, v_texture).a);
#endif
	
    // Compute the lighting in eye-space
	float fLightMult  = max( 0.0, dot( v_normal, u_LightDir ) );

#ifdef NUM_POINTLIGHTS
	float light = 0.0;
	for (int i = 0; i < NUM_POINTLIGHTS; i++)
	{
		light += GetLightContribution(i);
	}
	light = clamp(light, 0.0, 1.0);
#ifndef DISABLE_SHADOW_MAPPING
	if (light > fShadow)
	{
		fShadow = 1.0; // max(fShadow, light);
	}
#endif
#endif


#ifndef DISABLE_SHADOW_MAPPING
	fLightMult *= fShadow;
#endif

#ifdef NUM_POINTLIGHTS
	fLightMult = max(fLightMult, light);
#endif
    
    // Combine lighting with the material properties
	vec3 vLightMult = u_LightColour * fLightMult;
	#ifdef NUM_POINTLIGHTS
		vLightMult += light;
		vLightMult = clamp(vLightMult, 0.0, 0.8);
	#endif
	vec3 vAmbient = vTexDiffuse.rgb * u_AmbientMat;
    gl_FragColor  = vec4(vAmbient + vTexDiffuse.rgb * vLightMult, vTexDiffuse.a);
	//vec4 vDebug = vec4(fShadow, 0.0, vTexDiffuse.a, vTexDiffuse.a);
	//gl_FragColor = vDebug;
}
#endif
