varying vec2 v_texture;
#ifndef DISABLE_SHADOW_MAPPING
varying mediump vec4 v_shadowCoordsStatic;
varying mediump vec4 v_shadowCoordsDynamic;
#endif
varying vec2 v_texPitch;
varying vec3 v_vWorldPosition;

#ifdef VERTEX_SHADER
uniform mat4 u_mvpMatrix;
#ifndef DISABLE_SHADOW_MAPPING
uniform mat4 u_lightMatrixStatic;
#ifdef SHADOW_DUAL
uniform mat4 u_lightMatrixDynamic;
#endif
#endif

uniform mat4 u_worldMatrix;

attribute vec4 a_vertex;
attribute vec2 a_texture;
attribute vec2 a_texture1;

void main()
{
    v_texture = a_texture1;
	v_texPitch = a_texture;
#ifndef DISABLE_SHADOW_MAPPING
	v_shadowCoordsStatic = u_lightMatrixStatic * a_vertex;
#ifdef SHADOW_DUAL
	v_shadowCoordsDynamic = u_lightMatrixDynamic * a_vertex;
#endif
#endif

	v_vWorldPosition = (u_worldMatrix * a_vertex).xyz;

	gl_Position = u_mvpMatrix * a_vertex;
}
#endif // VERTEX_SHADER

/****************************************
 *  FRAGMENT SHADER
 ****************************************/
#ifdef FRAGMENT_SHADER

#ifndef DISABLE_SHADOW_MAPPING
  #ifdef GLES
    #ifdef GL_EXT_shadow_samplers
      #define SHADOWSAMPLER sampler2DShadow
      #define SHADOW2DPROJ(a,b) shadow2DProjEXT(a,b)
    #else
      #define SHADOWSAMPLER sampler2D
      #define SHADOW2DPROJ(a,b) clamp((b.w * texture2DProj(a, b).x - b.z) * 1000000.0 + 1.0, 0.0, 1.0)
    #endif
  #else
    #define SHADOWSAMPLER sampler2DShadow
	#define SHADOW2DPROJ(a,b) shadow2DProj(a,b).r
 #endif
  uniform lowp SHADOWSAMPLER u_texShadowMap5;
#endif

uniform sampler2D		u_tex0;
uniform sampler2D		u_tex1;
uniform sampler2D		u_tex2;
uniform sampler2D		u_tex3;
uniform sampler2D		u_tex4;

uniform vec3 u_LightColourPreMultiplied; // MSC: This has NdL multiplied in to it since we know light direction and normal = 0,1,0
uniform vec3 u_AmbientMat;



#ifdef NUM_POINTLIGHTS
uniform vec4 u_PointLights[10];// XYZ position, W intensity
uniform float u_NumPointLights;
float GetLightContribution(int index)
{
	float distance = length(u_PointLights[index].xyz - v_vWorldPosition);
	float distpercent = (distance / u_PointLights[index].w);
	distpercent *= distpercent;
	return clamp(1.0 - distpercent, 0.0, 1.0);
}
#endif


void main()
{
#ifndef DISABLE_SHADOW_MAPPING
	float fShadow = SHADOW2DPROJ(u_texShadowMap5, v_shadowCoordsStatic);
#ifdef SHADOW_DUAL
	vec4 vShadowCoords2 = v_shadowCoordsDynamic;
	vShadowCoords2.x = max(0.502, vShadowCoords2.x);
	float fShadow2 = SHADOW2DPROJ(u_texShadowMap5, vShadowCoords2);
	fShadow = min(fShadow, fShadow2);
#endif
#endif

	vec4 pitchMap = texture2D(u_tex4, v_texPitch);

	vec4 vDiffuse;
	vDiffuse = texture2D(u_tex0, v_texture)  * pitchMap.r;
	vDiffuse += texture2D(u_tex1, v_texture) * pitchMap.g;
	vDiffuse += texture2D(u_tex2, v_texture) * pitchMap.b;
	vDiffuse += texture2D(u_tex3, v_texture) * 0.5 * pitchMap.a;
	vDiffuse.a = 1.0;

#ifdef NUM_POINTLIGHTS
	float light = 0.0;
	for (int i = 0; i < NUM_POINTLIGHTS; i++)
	{
		light += GetLightContribution(i);
	}
	light = clamp(light, 0.0, 1.1- u_AmbientMat.b);
#ifndef DISABLE_SHADOW_MAPPING
	// MSC: This kinda gives us the ability to fade the floodlights on
	if (light > fShadow * fShadow)
	{
		fShadow = 1.0;
	}
#endif
	vec3 vLightColour = max(u_LightColourPreMultiplied, light);
#else
	vec3 vLightColour = u_LightColourPreMultiplied;
#endif

	//vec3 vLightColour = clamp(u_LightColourPreMultiplied + light, 0.0, 0.8);

	vec3 vAmbient = vDiffuse.rgb * u_AmbientMat;

#ifndef DISABLE_SHADOW_MAPPING
	gl_FragColor = vec4(vAmbient + (vDiffuse.rgb * fShadow * vLightColour) , 1.0);
#else
	gl_FragColor = vec4(vAmbient + (vDiffuse.rgb * vLightColour), 1.0);
#endif
}
#endif // FRAGMENT_SHADER
