// DOF
varying vec2 v_vTex;

#ifdef VERTEX_SHADER

attribute vec4 a_vertex;

void main()
{
    gl_Position = vec4( a_vertex.x, -a_vertex.y, 0.0, 1.0 );
    v_vTex		= vec2( a_vertex.z, a_vertex.w );
}

#endif // VERTEX_SHADER

#ifdef FRAGMENT_SHADER

uniform sampler2D u_tex0;					// Sharp
uniform sampler2D u_tex1;					// Blurred
uniform sampler2D u_tex2;					// Depth

uniform float u_fRange;
uniform float u_fFocus;


const float zFar = 1000.0;
const float zNear = 1.0;


void main()
{
    vec4 vBlurColour  = texture2D(u_tex1, v_vTex);
#ifdef DOFFULLBLUR
	gl_FragColor = vBlurColour;
#else
	vec4 vSharpColour = texture2D(u_tex0, v_vTex);

	float fDepth = 2.0 * texture2D(u_tex2, v_vTex).r - 1.0;
	float fDepthLinear = 2.0 * zNear * zFar / (zFar + zNear - fDepth * (zFar - zNear));

	float fAbs = abs(fDepthLinear - u_fFocus);
	float fNorm = clamp(fAbs/u_fRange,0.0,1.0);
	float fMix = fNorm * fNorm;// * fNorm * fNorm * fNorm;

	vec4 vMixedColour = mix(vSharpColour, vBlurColour, fMix);

#ifdef DOFDEBUG
	if( fNorm < 1.0 )
	{
		float grey = dot(vMixedColour.rgb, vec3(0.299, 0.587, 0.114)) * (1.0-fMix);
		vMixedColour.r = vMixedColour.g = vMixedColour.b = grey;
	}
	if( fNorm < 0.01 )
	{
		vMixedColour = vec4(0,1,0,1);
	}
	else if( fNorm > 0.98 && fNorm < 1.0 )
	{
		vMixedColour = vec4(1,0,0,1);
	}
#endif
	gl_FragColor = vMixedColour;
#endif // DOF_FULLBLUR

}

#endif
