varying vec2 v_vTexM;
varying vec2 v_vTexB0;
varying vec2 v_vTexF0;
varying vec2 v_vTexB1;
varying vec2 v_vTexF1;
varying vec2 v_vTexB2;
varying vec2 v_vTexF2;

#ifdef VERTEX_SHADER

uniform vec2 u_vStepSize;

attribute vec4 a_vertex;
//attribute vec2 a_texture;
uniform mat4 u_mvpMatrix;
void main()
{
    gl_Position  = vec4( a_vertex.x, -a_vertex.y, 0.0, 1.0 );
	//gl_Position     = u_mvpMatrix * a_vertex;

    v_vTexM  = vec2( a_vertex.z, a_vertex.w );
	//v_vTexM  = a_texture;
    v_vTexB0 = v_vTexM - u_vStepSize;
    v_vTexF0 = v_vTexM + u_vStepSize;
    v_vTexB1 = v_vTexM - u_vStepSize * 2.0;
    v_vTexF1 = v_vTexM + u_vStepSize * 2.0;
    v_vTexB2 = v_vTexM - u_vStepSize * 3.0;
    v_vTexF2 = v_vTexM + u_vStepSize * 3.0;
}

#endif // VERTEX_SHADER

#ifdef FRAGMENT_SHADER

uniform sampler2D u_tex0;

void main()
{
    vec4 vSampleM  = texture2D( u_tex0, v_vTexM );
    vec4 vSampleB0 = texture2D( u_tex0, v_vTexB0 );
    vec4 vSampleF0 = texture2D( u_tex0, v_vTexF0 );
    vec4 vSampleB1 = texture2D( u_tex0, v_vTexB1 );
    vec4 vSampleF1 = texture2D( u_tex0, v_vTexF1 );
    vec4 vSampleB2 = texture2D( u_tex0, v_vTexB2 );
    vec4 vSampleF2 = texture2D( u_tex0, v_vTexF2 );

    gl_FragColor = 0.1752 * vSampleM + 
                   0.1658 * ( vSampleB0 + vSampleF0 ) + 
                   0.1403 * ( vSampleB1 + vSampleF1 ) + 
                   0.1063 * ( vSampleB2 + vSampleF2 );
}
#endif
