varying vec2   v_texture;

#ifdef VERTEX_SHADER
attribute highp vec3  a_vertex;
attribute vec2 a_texture;
uniform highp mat4  u_mvpMatrix;		// model view projection transformation

void main()
	{
	gl_Position = u_mvpMatrix * vec4(a_vertex, 1.0);
	v_texture = a_texture;
	}
#endif

#ifdef FRAGMENT_SHADER

uniform sampler2D   u_tex0;

void main()
	{
	if (texture2D(u_tex0, v_texture).a < 0.7) 
		{
		discard;
		}
	
	gl_FragColor.r = 1.0-gl_FragCoord.z;
	}
#endif
