(defun atp-load (/ setenv-path f d p)
 (defun setenv-path (p f / s)
   (setq s (vl-string-right-trim ";" (getenv "ACAD")))
   (or(wcmatch(strcase s)(strcase(strcat "*" p "\\" f "*")))
      (setenv "ACAD" (strcat s ";" p "\\" f)))
   (wcmatch(strcase(getenv "ACAD"))(strcase(strcat "*" p "\\" f "*")))
   )
  (vl-load-com)
  (and
    (or(setq f (findfile "ATP.VLX"))
       (alert "\n:    AcadTopoPlan"))
    (setq d (vl-string-right-trim "\\" (car(fnsplitl f))))
    (setq atp-directory-program d)
    (or(setenv-path d "Hatch")
       (alert(strcat "\n:     \n" d "\\Hatch")))
    (or(setenv-path d "Fonts")
       (alert(strcat "\n:     \n" d "\\Fonts")))
    (if(and(setq p (getvar "TRUSTEDPATHS"))
	   (setq p (vl-string-right-trim ";" p)))
      (progn
	(or(wcmatch(strcase p)(strcase(strcat  "*" d "*")))
	   (setvar "TRUSTEDPATHS" (strcat p ";" d)))
	(or(wcmatch(strcase(getvar "TRUSTEDPATHS"))(strcase(strcat  "*" d "*")))
	   (alert(strcat "\n:     \n" d)))
	)
      t)
    (cond
      ((and(wcmatch(strcase(vlax-product-key)) "*\\AUTODESK*")
	   (vl-string-search "86" (getenv "PROCESSOR_ARCHITECTURE")1))
       (cond
	 ((wcmatch (vlax-product-key) "*\\R17*")
	  (if(not(member "OpenDCL.17.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.17.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R18*")
	  (if(not(member "OpenDCL.18.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.18.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R19*")
	  (if(not(member "OpenDCL.19.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.19.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R20*")
	  (if(not(member "OpenDCL.20.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.20.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R21*")
	  (if(not(member "OpenDCL.21.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.21.arx"))))
	 ))
      ((and(wcmatch(strcase(vlax-product-key)) "*\\AUTODESK*")
	   (vl-string-search "64" (getenv "PROCESSOR_ARCHITECTURE")1))
       (cond
	 ((wcmatch (vlax-product-key) "*\\R17*")
	  (if(not(member "OpenDCL.x64.17.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.x64.17.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R18*")
	  (if(not(member "OpenDCL.x64.18.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.x64.18.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R19*")
	  (if(not(member "OpenDCL.x64.19.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.x64.19.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R20*")
	  (if(not(member "OpenDCL.x64.20.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.x64.20.arx"))))
	 ((wcmatch (vlax-product-key) "*\\R21*")
	  (if(not(member "OpenDCL.x64.21.arx" (arx)))(arxload(strcat d "\\System\\Odcl\\OpenDCL.x64.21.arx"))))
	 ))
      (t (alert "\n:    OpenDCL\n : AutoCAD 2007-2017"))
      )
    (or(=(type dcl_getprojects) 'EXRXSUBR)
       (alert "\n:    OpenDCL"))
    (setvar "ACADLSPASDOC" 1)
    (or(load f)t)
    (or(=(type atp-load-program) 'SUBR)
       (alert "\n:    AcadTopoPlan"))
    (atp-load-program)
    )
  (princ)
  )
  (atp-load)

