//  +--------------------------------------------------------------------+
//  |                   ****  CONFIDENTIAL MATERIAL  ****                |
//  |      (C) Copyright 1994-2019 by DotSoft. All rights reserved.      |
//  +--------------------------------------------------------------------+
//  |  The information contained herein is confidential, proprietary to  |
//  |  DotSoft.  You may NOT use any part of the information in this     |
//  |  file for any purpose other than in conjunction with DotSoft       |
//  |  products.                                                         |
//  +--------------------------------------------------------------------+

// #######################################################################
//                            ANNOTOOL.DCL
// #######################################################################

//  +--------------------------------------------------------------------+
//                           Annotation Surrounding
//  +--------------------------------------------------------------------+

annosurr : dialog {
  label = "ToolPac Annotation Surrounding";
  : row {
    : column {
      : boxed_column {
        label = "Type";
        : radio_button {
          key = "typrec";
          label = "Basic Rectangle";
        }
        : radio_button {
          key = "typsqr";
          label = "Squared Shadow";
        }
        : radio_button {
          key = "typrnd";
          label = "Rounded Shadow";
        }
        : radio_button {
          key = "typcir";
          label = "Circular";
        }
        : radio_button {
          key = "typell";
          label = "Elliptical";
        }
      }
      : boxed_column {
        label = "Preview";
        : image_button {
          key = "sample";
          color = black;
          height = 6;
          aspect_ratio = 1.0;
          is_tab_stop = false;
        }
      }
      : boxed_row {
        label = "Grouping";
        : toggle {
          key = "grpobj";
          label = "Bind Geometry";
        }
      }
      
    }     
    : column {
      : boxed_column {
        label = "Geometry";
        : edit_box {
          key = "buffer";
          label = "Buffer Distance:";
          width = 19;
          edit_width = 19;
        }
        : edit_box {
          key = "polwid";
          label = "Polyline Width:";
          width = 19;
          edit_width = 19;
        }
        : edit_box {
          key = "filrad";
          label = "Fillet Radius:";
          width = 19;
          edit_width = 19;
        }
        : row {
          : edit_box {
            key = "uscval";
            label = "Color:";
          }
          : button {
            key = "uscsel";
            label = "Select ...";
          }
        }
        : row {
          : edit_box {
            key = "uslval";
            label = "Layer:";
          }
          : button {
            key = "uslsel";
            label = "Select ...";
          }
        }
        : row {
          : text {
            key = "aspect";
            label = "Aspect";
          }
          : edit_box {
            key = "horasp";
            label = "Horz:";
            width = 5;
            edit_width = 5;
          }
          : edit_box {
            key = "verasp";
            label = "Vert:";
            width = 5;
            edit_width = 5;
          }
        }
      }
      : boxed_column {
        label = "Interior";
        : toggle {
          key = "filint";
          label = "Fill Interior";
        }
        : row {
          : edit_box {
            key = "ufcval";
            label = "Color:";
          }
          : button {
            key = "ufcsel";
            label = "Select ...";
          }
        }
        : row {
          : edit_box {
            key = "uflval";
            label = "Layer:";
          }
          : button {
            key = "uflsel";
            label = "Select ...";
          }
        }
      }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                         Incremental Copy
//  +--------------------------------------------------------------------+

annoincc : dialog {
  label = "Incremental Copy";
  : boxed_column {
    label = "Parameters";
    : row {
      : column {
        : text {
          label = "Prefix:";
          alignment = right;
        }
        : text {
          label = "Suffix:";
          alignment = right;
        }
        : text {
          label = "Increment:";
          alignment = right;
        }
      }
      : column {
        : edit_box {
          key = "prefix";
          width = 12;
          fixed_width = true;
        }
        : edit_box {
          key = "suffix";
          width = 12;
          fixed_width = true;
        }
        : edit_box {
          key = "incval";
          width = 12;
          fixed_width = true;
        }
      }
    }
    : toggle {
      key = "rotprt";
      label = "Prompt for Rotation";
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                             Annotation Masking
//  +--------------------------------------------------------------------+

annomask : dialog {
  label = "ToolPac Annotation Masking";
  : row {
    : column {
      : boxed_column {
        label = "Mask Type";
        : radio_button {
          key = "typ2ds";
          label = "2D Solid";
        }
        : radio_button {
          key = "typ3df";
          label = "3D Face";
        }
        : radio_button {
          key = "typmsk";
          label = "MaskImg";
        }
        : radio_button {
          key = "typtrm";
          label = "Trim";
        }
        : radio_button {
          key = "typwip";
          label = "Wipeout";
        }
      }
    }     
    : column {
      : boxed_column {
        label = "Options";
        : edit_box {
          key = "buffer";
          label = "Buffer Distance:";
          width = 19;
          edit_width = 19;
        }
        : edit_box {
          key = "3dfelv";
          label = "3DFace Elevation:";
          width = 19;
          edit_width = 19;
        }
        : row {
          : edit_box {
            key = "uscval";
            label = "Color:";
          }
          : button {
            key = "uscsel";
            label = "Select ...";
          }
        }
        : row {
          : edit_box {
            key = "uslval";
            label = "Layer:";
          }
          : button {
            key = "uslsel";
            label = "Select ...";
          }
        }
      }
      : boxed_column {
        label = "Binding";
        : toggle {
          key = "grpobj";
          label = "Bind Geometry as Anonymous Group";
        }
      }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                           Leroy Style Creation
//  +--------------------------------------------------------------------+

leroysty : dialog {
  label = "ToolPac Leroy Style Creation";
  : row {
    : boxed_column {
      label = "Scale";
      : list_box {
        width = 10;
        height = 13;
        key = "scllst";
      }
      : edit_box {
        key = "usescl";
        width = 10;
      }
      
    }
    : boxed_column {
      label = "Leroy";
      : list_box {
        width = 10;
        height = 15;
        key = "sizlst";
      }
    }
    : boxed_column {
      label = "Font";
      : row {
        : column {
          : text {
            label = "Name:";
            alignment = right;
          }
          : text {
            label = "Width:";
            alignment = right;
          }
          : text {
            label = "Oblique:";
            alignment = right;
          }
        }
        : column {
          : edit_box {
            key = "usefnt";
            width = 25;
          }
          : edit_box {
            key = "usewid";
            width = 5;
          }
          : edit_box {
            key = "useobl";
            width = 5;
          }
        }
      }
      spacer_1;
      spacer_1;
      spacer_1;
      spacer_1;
      spacer_1;
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                            BLOKTOOL.DCL
// #######################################################################

//  +--------------------------------------------------------------------+
//                   Block & Attribute Export
//  +--------------------------------------------------------------------+

BlkDatExp : dialog {
  label = "ToolPac Block/Attribute Data Export";
  : row {
    : boxed_column {
      label = "Option Fields";
      : list_box {
        width = 32;
        height = 20;
        key = "optlst";
        fixed_width = true;
        multiple_select = true;
      }
      : row {
        : button {
          key = "selall";
          label = "Select All";
          mnemonic = "S";
        }
        : button {
          key = "clrall";
          label = "Clear All";
          mnemonic = "C";
        }
      }
      : button {
        key = "addlst";
        label = "Add To List >>";
        mnemonic = "A";
      }
    }
    : boxed_column {
      label = "Output Fields";
      : list_box {
        width = 32;
        height = 22;
        key = "outlst";
        fixed_width = true;
        multiple_select = true;
      }
      : button {
        key = "remlst";
        label = "<< Remove From List";
        mnemonic = "R";
      }
    }
  }
  : row {
    : toggle {
      key = "outhdr";
      label = "Output Column Headings";
    }
    : toggle {
      key = "outquo";
      label = "Use Quotation Marks";
    }
  }
  : edit_box {
    label = "Output File: ";
    key = "outfil";
    width = 55;
    edit_width = 55;
    fixed_width = true;
  }
  ok_cancel;
}

//  +--------------------------------------------------------------------+
//                         Block Attribute Explode
//  +--------------------------------------------------------------------+

blkattex : dialog {
  label = "ToolPac Block Attribute Explode";
  : row {
    : boxed_column {
      label = "Create On Layer";
      : radio_button {
        key = "plcorg";
        label = "Original";
      }
      : radio_button {
        key = "plcins";
        label = "Inserted";
      }
      : radio_button {
        key = "plccur";
        label = "Current";
      }
    }
    : boxed_column {
      label = "Existing Attributes";
      : radio_button {
        key = "attkep";
        label = "Keep";
      }
      : radio_button {
        key = "attemp";
        label = "Empty";
      }
      : radio_button {
        key = "attrem";
        label = "Remove";
      }
    }
  }
  : boxed_column {
    label = "Other Options";
    : toggle {
      key = "attrec";
      label = "Attach EED Recall Tags";
    }
    : toggle {
      key = "prcinv";
      label = "Process Invisible Attibutes";
    }
    : toggle {
      key = "retpar";
      label = "Retain Parent Block";
    }
  }
  ok_cancel;
}

//  +--------------------------------------------------------------------+
//                              Block Catalog
//  +--------------------------------------------------------------------+

blkcatgen : dialog {
  label = "ToolPac Block Catalog Generator";
  : row {
    : boxed_column {
      label = "Process Files";
      : list_box {
        width = 65;
        height = 18;
        key = "fillst";
        fixed_width = true;
      }
    }
    : column {
      : boxed_column {
        label = "Process";
        : button {
          key = "accept";
          label = "OK";
        }
        : button {
          key = "cancel";
          label = "Cancel";
          is_cancel = true;
        }
        : button {
          key = "help";
          label = "Help";
        }
      }
      : boxed_column {
        label = "List";
        : button {
          key = "clrlst";
          label = "Clear List";
        }
        : button {
          key = "addfil";
          label = "Add Files...";
        }
        : button {
          key = "addfol";
          label = "Add Folder...";
        }
        : button {
          key = "addsdb";
          label = "Add Database...";
        }
      }
      : boxed_column {
        label = "Layout";
        : popup_list {
          list = "2 Cols, 3 Rows (6)\n3 Cols, 4 Rows (12)\n4 Cols, 6 Rows (24)\n6 Cols, 9 Rows (54)\n9 Cols, 12 Rows (108)";
          key = "perpag";
          edit_width = 19;
          popup_height = 6;
        }
        : edit_box {
          key = "buffer";
          label = "Buffer: ";
          edit_width = 7;
          width = 7;
        }
        : edit_box {
          key = "txtsiz";
          label = "Text Size: ";
          edit_width = 7;
          width = 7;
        }
        : radio_button {
          key = "usenam";
          label = "File Name Only";
        }
        : radio_button {
          key = "useful";
          label = "Full Name/Path";
        }
        : toggle {
          key = "labdat";
          label = "Date/Time/Sheet";
        }
      }
    }
  }
}

//  +--------------------------------------------------------------------+
//                   Attribute Value Find/Replace Dialog
//  +--------------------------------------------------------------------+

attvalrp : dialog {
  label = "ToolPac Block Attribute Find + Replace";
  : boxed_column {
    label = "Select Fields to Process";
    : list_box {
      height = 18;
      key = "attlst";
      multiple_select = true;
    }
    : row {
      : button {
        key = "selall";
        label = "Select All";
        mnemonic = "S";
      }
      : button {
        key = "clrall";
        label = "Clear All";
        mnemonic = "A";
      }
    }
  }
  : boxed_column {
    label = "Parameters";
    : edit_box {
      key = "fnd";
      label = "Find:";
      width = 30;
      edit_width = 30;
      fixed_width = true;
    }
    : edit_box {
      key = "rep";
      label = "Repl:";
      width = 30;
      edit_width = 30;
      fixed_width = true;
    }
    : toggle {
      key = "all";
      label = "Replace All Values";
    }
    : toggle {
      key = "whl";
      label = "Match Whole String Only";
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                  Populate Selected Attribute with Property
//  +--------------------------------------------------------------------+

attfillval : dialog {
  label = "ToolPac Attribute Value Fill";
  : row {
    : boxed_column {
      label = "Attribute Fields";
      : list_box {
        width = 32;
        height = 16;
        key = "attlst";
        fixed_width = true;
      }
    }
    : boxed_column {
      label = "Fill Options";
      : list_box {
        width = 32;
        height = 16;
        key = "optlst";
        fixed_width = true;
      }
    }
  }
  : popup_list {
    label = "Decimals:";
    list = "0\n1\n2\n3\n4\n5\n6\n7\n8";
    key = "decplc";
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                         Copy Multiple w/Fuzz Distance
//  +--------------------------------------------------------------------+

attcpymu : dialog {
  label = "ToolPac Attribute Copy Multiple";
  : boxed_column {
    label = "Fields to Process";
    : list_box {
      height = 16;
      key = "srcatt";
      multiple_select = true;
    }
    : row {
      : button {
        key = "selall";
        label = "Select All";
        mnemonic = "S";
      }
      : button {
        key = "clrall";
        label = "Clear All";
        mnemonic = "A";
      }
    }
  }
  : boxed_column {
    label = "Target Blocks";
    : list_box {
      height = 6;
      key = "tarblk";
      multiple_select = true;
    }
    : edit_box {
      key = "fuzdis";
      label = "Search Radius:";
      width = 10;
      edit_width = 10;
      fixed_width = true;
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                               DIMTOOL.DCL
// #######################################################################

//  ----------------------------------------------------------------------
//                             Ordinate Update
//  ----------------------------------------------------------------------

ordupd : dialog {
  label = "ToolPac Ordinate Update";
  : boxed_column {
    label = "X Axis";
    : column {
      : edit_box {
        key = "xpre";
        label = "Prefix:";
        edit_width = 10;
      }
      : edit_box {
        key = "xsuf";
        label = "Suffix:";
        edit_width = 10;
      }
    }
  }
  : boxed_column {
    label = "Y Axis";
    : column {
      : edit_box {
        key = "ypre";
        label = "Prefix:";
        edit_width = 10;
      }
      : edit_box {
        key = "ysuf";
        label = "Suffix:";
        edit_width = 10;
      }
    }
  }

  : boxed_column {
    label = "Other Settings";
    : popup_list {
      label = "Precision:";
      list = "0\n1\n2\n3\n4\n5\n6\n7\n8";
      key = "ndec";
      edit_width = 3;
      popup_height = 9;
    }
    : toggle {
      key = "morg";
      label = "Move Defpoint";
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                              DRAWTOOL.DCL
// #######################################################################

//  +--------------------------------------------------------------------+
//                    Area/Perimeter Labeling Dialog
//  +--------------------------------------------------------------------+

labarea : dialog {
  label = "";
  key = "title";
  : row {
    label = "Options";
    : column {
      : text {
        label = "Justification: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Height Value: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Rotation Angle: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Decimal Places: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Value Operator: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Value Factor: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Label Prefix: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
      : text {
        label = "Label Suffix: ";
        alignment = right;
        width = 16;
        fixed_width = true;
      }
    }
    : column {
      : popup_list {
        list = "Left\nCenter\nRight\nMiddle";
        key = "jst";
        //edit_width = 12;
        popup_height = 8;
        width = 16;
        fixed_width = true;
      }
      : edit_box {
        key = "hgt";
        width = 16;
        fixed_width = true;
      }
      : edit_box {
        key = "rot";
        width = 16;
        fixed_width = true;
      }
      : popup_list {
        list = "0\n1\n2\n3\n4\n5\n6\n7\n8";
        key = "dec";
        //edit_width = 12;
        popup_height = 8;
        width = 16;
        fixed_width = true;
      }
      : popup_list {
        list = "None\n+\n-\n*\n\/";
        key = "vop";
        //edit_width = 12;
        popup_height = 5;
        width = 16;
        fixed_width = true;
      }
      : edit_box {
        key = "vfc";
        width = 16;
        fixed_width = true;
      }
      : edit_box {
        key = "pre";
        width = 16;
        fixed_width = true;
      }
      : edit_box {
        key = "suf";
        width = 16;
        fixed_width = true;
      }
      : spacer { width = 20; }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                       Draw Label Incrementing Dialog
//  +--------------------------------------------------------------------+

labincvl : dialog {
  label = "ToolPac Draw Incrementing Labels";
  : row {
    : boxed_column {
      label = "Symbol";
      : radio_button {
        key = "symnon";
        label = "None";
      }
      : radio_button {
        key = "symund";
      label = "Underline";
      }
      : radio_button {
        key = "symcir";
        label = "Circle";
      }
      : radio_button {
        key = "sympol";
        label = "Polygon";
      }
      : edit_box {
        key = "figrad";
        label = "Radius:";
      }
      : edit_box {
        key = "figsid";
        label = "Sides:";
      }
    }
    : column {
      : boxed_column {
        label = "Parameters";
        : edit_box {
          key = "newval";
          label = "Start Value:";
        }
        : edit_box {
          key = "txtsiz";
          label = "Text Size:";
        }
        : edit_box {
          key = "prefix";
          label = "Prefix:";
        }
        : edit_box {
          key = "suffix";
          label = "Suffix:";
        }
      }
      : boxed_row {
        label = "Options";
        : toggle {
          key = "grpgeo";
          label = "Group";
        }
        : toggle {
          key = "rotpmt";
          label = "Rotate";
        }
      }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                         Label Slope Settings Dialog
//  +--------------------------------------------------------------------+

labslope : dialog {
  label = "ToolPac Label Slope Settings";
  : row {
    : boxed_column {
      label = "Method";
      : radio_button {
        key = "labgrd";
        label = "Grade";
      }
      : radio_button {
        key = "labrat";
        label = "Ratio";
      }
      : radio_button {
        key = "labdeg";
        label = "Degree";
      }
    }
    : boxed_column {
      : text {
        label = "Decimals";
      }
      : popup_list {
        list = "0\n1\n2\n3\n4\n5\n6\n7\n8";
        key = "labdec";
      }
      spacer_1;
      spacer_1;
      spacer_1;
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                              LAYOTOOL.DCL
// #######################################################################

//  +--------------------------------------------------------------------+
//                              Layout Merge
//  +--------------------------------------------------------------------+

layoutmrg : dialog {
  label = "ToolPac Layout Merge";
  : row {
    : boxed_column {
      label = "Source Layouts";
      : list_box {
        width = 32;
        height = 18;
        key = "srclst";
        fixed_width = true;
        multiple_select = true;
      }
    }
    : boxed_column {
      label = "Target Layout";
      : list_box {
        width = 32;
        height = 18;
        key = "tarlst";
        fixed_width = true;
      }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                              Layout File
//  +--------------------------------------------------------------------+

lyosavfil : dialog {
  label = "ToolPac Layout Save to DWG";
  : row {
    : boxed_column {
      label = "Source Layouts";
      : list_box {
        width = 50;
        height = 14;
        key = "srclst";
        fixed_width = true;
        multiple_select = true;
      }
    }
    : boxed_column {
      label = "Save As";
      : radio_button {
        key = "savr12";
        label = "R12 DXF";
      }
      : radio_button {
        key = "savr13";
        label = "R13 DWG";
      }
      : radio_button {
        key = "savr14";
        label = "R14 DWG";
      }
      : radio_button {
        key = "sava00";
        label = "2000 DWG";
      }
      : radio_button {
        key = "sava04";
        label = "2004 DWG";
      }
      : radio_button {
        key = "sava07";
        label = "2007 DWG";
      }
      : radio_button {
        key = "sava10";
        label = "2010 DWG";
      }
      : radio_button {
        key = "sava13";
        label = "2013 DWG";
      }
      spacer;
      spacer;
      spacer;
      spacer;
    }
  }
  : boxed_column {
    label = "Options";
    : toggle {
      key = "opteov";
      label = "Erase Model Space Geometry Outside Viewports";
    }
    : toggle {
      key = "optpur";
      label = "Purge Extensively Before Drawing Creation";
    }
    : toggle {
      key = "optbnd";
      label = "Bind Insert Exploded All Xref's Before Export";
    }
    : toggle {
      key = "optfrz";
      label = "Erase All Off/Frozen Geometry Before Export";
    }
    : toggle {
      key = "optprj";
      label = "Trim To Viewports and Project To Model Space";
    }
  }
  : boxed_row {
    label = "Output Path";
    : edit_box {
      label = "";
      key = "outpth";
      width = 54;
      is_enabled = false;
    }
    : button {
      key = "selpth";
      label = "Select...";
      width = 10;
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                              LAYRTOOL.DCL
// #######################################################################

//  ----------------------------------------------------------------------
//                        Layer Block Contents
//  ----------------------------------------------------------------------

layblock : dialog {
  label = "ToolPac Layer Block Multiple";
  : column {
    : boxed_column {
      label = "Layers";
      : list_box {
         label = "Process Layers";
         width = 48;
         height = 14;
         key = "laytab";
         fixed_width = true;
         multiple_select = true;
      }
      : edit_box {
        label = "Select:";
        key = "selpat";
      }
      : row {
        : button {
           key = "selall";
           label = "Select All";
        }
        : button {
           key = "clrall";
           label = "Clear All";
        }
      }
    }
    : boxed_column {
      label = "Parameters";
      : edit_box {
        key = "inspnt";
        label = "Base Point:";
      }
      : toggle {
        key = "insres";
        label = "Insert Generated Blocks";
      }
      : toggle {
        key = "retexi";
        label = "Retain Existing Geometry";
      }
    }
  }
  : row {
    : button {
      key = "accept";
      label = "OK";
      width = 16;
    }
    : button {
      key = "cancel";
      label = "Cancel";
      width = 16;
      is_cancel = true;
    }
    : button {
      key = "help";
      label = "Help";
      width = 16;
    }
  }
}

// #######################################################################
//                               OBJTOOL.DCL
// #######################################################################

//  +--------------------------------------------------------------------+
//                         Document Link Editor Dialog
//  +--------------------------------------------------------------------+

linkedit : dialog {
  label = "ToolPac Document Link Editor";
  : boxed_column {
    label = "List Control";
    : list_box {
      height = 25;
      key = "datlst";
    }
    : row {
      : edit_box {
        key = "itmfld";
        width = 60;
        fixed_width = true;
      }
      : button {
        key = "filsel";
        label = "Select";
        width = 6;
      }
    }
    : row {
      : button {
        key = "update";
        label = "Update";
        width = 9;
        mnemonic = "U";
      }
      : button {
        key = "add";
        label = "Add";
        width = 9;
        mnemonic = "A";
      }
      : button {
        key = "del";
        label = "Delete";
        width = 9;
        mnemonic = "D";
      }
      : button {
        key = "sort";
        label = "Sort";
        width = 9;
        mnemonic = "S";
      }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                         Association Editor Dialog
//  +--------------------------------------------------------------------+

conedit : dialog {
  label = "ToolPac Extension/Application Association";
  : boxed_column {
    label = "List Control";
    : row {
      : edit_box {
        key = "extfld";
        width = 3;
        fixed_width = true;
      }
      : edit_box {
        key = "appfld";
        width = 65;
        fixed_width = true;
      }
      : button {
        key = "extdia";
        label = "Select...";
        width = 10;
        fixed_width = true;
      }
    }
    : list_box {
      tabs = "10";
      height = 25;
      key = "extlst";
    }
    : row {
      : button {
        key = "update";
        label = "Update";
        width = 9;
        mnemonic = "U";
      }
      : button {
        key = "add";
        label = "Add";
        width = 9;
        mnemonic = "A";
      }
      : button {
        key = "del";
        label = "Delete";
        width = 9;
        mnemonic = "D";
      }
      : button {
        key = "sort";
        label = "Sort";
        width = 9;
        mnemonic = "S";
      }
    }
  }
  ok_cancel_help;
}

//  +--------------------------------------------------------------------+
//                         ZOrder Layer Assign Dialog
//  +--------------------------------------------------------------------+

objzolay : dialog {
  label = "ToolPac Z-Order Assign to Layers";
  : boxed_column {
    label = "Process Layers";
    : row {
      : radio_button {
        key = "srtlay";
        label = "Sort by Layer";
      }
      : radio_button {
        key = "srtlev";
        label = "Sort by Level";
      }
    }    
    : row {
      : text {
        label = "Level";
        width = 6;
        fixed_width = true;
      }
      : text {
        label = "Layer Name";
        width = 71;
        fixed_width = true;
      }
    }
    : list_box {
      width = 77;
      tabs = "7";
      height = 26;
      key = "table";
      fixed_width = true;
      allow_accept = true;
      multiple_select = true;
    }
    : edit_box {
      label = "Select:";
      key = "selpat";
      mnemonic = "e";
    }
    : row {
      : button {
        key = "selall";
        label = "Select All";
        mnemonic = "S";
      }
      : button {
        key = "clrall";
        label = "Clear All";
        mnemonic = "C";
      }
    }
  }
  : boxed_row {
    label = "Level Assign";
    : edit_box {
      label = "Level:";
      key = "level";
      mnemonic = "L";
    }
    : button {
      key = "assign";
      label = "Assign";
      mnemonic = "A";
      width = 10;
    }
    : button {
      key = "unassign";
      label = "UnAssign";
      mnemonic = "U";
      width = 10;
    }
  }
  : toggle {
    key = "ovrpre";
    label = "Overwrite Pre-Assigned Objects";
  }
  : row {
    : button {
      key = "accept";
      label = "OK";
      width = 10;
      mnemonic = "O";
      is_default = true;
    }
    : button {
      key = "cancel";
      label = "Cancel";
      is_cancel = true;
      width = 10;
      mnemonic = "C";
    }
    : button {
      key = "scandwg";
      label = "Scan DWG";
      width = 10;
      mnemonic = "S";
    }
    : button {
      key = "import";
      label = "Import ...";
      width = 10;
      mnemonic = "I";
    }
    : button {
      key = "export";
      label = "Export ...";
      width = 10;
      mnemonic = "E";
    }
    : button {
      key = "help";
      label = "Help";
      width = 10;
      mnemonic = "H";
    }
  }
}

//  +--------------------------------------------------------------------+
//                         XData Editor Dialog
//  +--------------------------------------------------------------------+

xdatedit : dialog {
  label = "ToolPac Object XData Editor";
  : boxed_column {
    label = "List Control";
    : row {
      : edit_box {
        key = "namfld";
        width = 3;
        fixed_width = true;
      }
      : edit_box {
        key = "valfld";
        width = 65;
        fixed_width = true;
      }
      : button {
        key = "namdia";
        label = "Select...";
        width = 10;
        fixed_width = true;
      }
    }
    : list_box {
      tabs = "10";
      height = 25;
      key = "namlst";
    }
    : row {
      : button {
        key = "update";
        label = "Update";
        width = 9;
        mnemonic = "U";
      }
      : button {
        key = "add";
        label = "Add";
        width = 9;
        mnemonic = "A";
      }
      : button {
        key = "del";
        label = "Delete";
        width = 9;
        mnemonic = "D";
      }
      : button {
        key = "sort";
        label = "Sort";
        width = 9;
        mnemonic = "S";
      }
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                              SYMBLMAN.DCL
// #######################################################################

// ---------------------- Main Browser Dialog

symblman : dialog {
  label = "ToolPac Symbol Manager";
  key = "title";
  : row {
    : button {
      key = "insert";
      label = "Block Insert <";
      mnemonic = "B";
      width = 15;
      fixed_width = true;
    }
    : button {
      key = "attach";
      label = "XRef Attach <";
      mnemonic = "X";
      width = 15;
      fixed_width = true;
    }
    : popup_list {
      key = "datlst";
      label = "Database:";
      width = 100;
      popup_height = 10;
    }
    : button {
      key = "newsdb";
      label = "New...";
      width = 6;
      mnemonic = "N";
      fixed_width = true;
    }
    : button {
      key = "savsdb";
      label = "Save";
      width = 6;
      mnemonic = "S";
      fixed_width = true;
    }
  }
  : row {
    : column {
      : boxed_column {
        label = "Selections";
        : text {
          label = "Groups:";
        }
        : popup_list {
          key = "grppop";
          popup_height = 10;
        }
        : text {
          label = "Items:";
        }
        : list_box {
          key = "itmlst";
          height = 28;
        }
        : button {
          label = "Graphic Select...";
          key = "grasel";
          mnemonic = "G";
        }
      }
      : row {
        : boxed_column {
          label = "Program Options";
          : toggle {
            label = "Repeat";
            key = "repmod";
          }
          : toggle {
            label = "Redefine";
            key = "dwgred";
          }
          : toggle {
            label = "Group";
            key = "grpobj";
          }
        }
        : boxed_column {
          label = "List By:";
          : radio_button {
            key = "lstnam";
            label = "Name";
          }
          : radio_button {
            key = "lstdes";
            label = "Desc";
          }
        }
      }
    }
    : column {
      : boxed_column {
        label = "Item Specifications";
        : row {
          : column {
            : text {
              label = "Block:";
              alignment = right;
            }
            : text {
              label = "Slide:";
              alignment = right;
            }
            : text {
              label = "Desc:";
              alignment = right;
            }
          }
          : column {
            : edit_box {
              key = "blkfil";
              width = 90;
            }
            : edit_box {
              key = "blksld";
              width = 90;
            }
            : edit_box {
              key = "blkdes";
              width = 90;
            }
          }
          : column {
            : button {
              label = "Select...";
              key = "blksel";
              width = 10;
              fixed_width = true;
            }
            : button {
              label = "Select...";
              key = "sldsel";
              width = 10;
              fixed_width = true;
            }
            : text {
              label = "";
            }
          }
        }
        spacer;
        : row {
          : column {
            : text {
              label = "Group:";
              alignment = right;
            }
            : text {
              label = "Layer:";
              alignment = right;
            }
            : text {
              label = "Before:";
              alignment = right;
            }
            : text {
              label = "After:";
              alignment = right;
            }
          }
          : column {
            : edit_box {
              key = "blkgrp";
              width = 55;
            }
            : edit_box {
              key = "inslay";
              width = 55;
            }
            : edit_box {
              key = "runbef";
              width = 55;
            }
            : edit_box {
              key = "runaft";
              width = 55;
            }
          }
          : column {
            : button {
              label = "Select...";
              key = "grpsel";
              width = 10;
              fixed_width = true;
            }
            : button {
              label = "Select...";
              key = "laysel";
              width = 10;
              fixed_width = true;
            }
            spacer_0;
            : text {
              label = "(lsp/vba)";
              alignment = left;
            }
            spacer_0;
            : text {
              label = "(lsp/vba)";
              alignment = left;
            }
            spacer_0;
          }
          : column {
            : text {
              label = "Elev:";
              alignment = right;
            }
            : text {
              label = "Thick:";
              alignment = right;
            }
            : text {
              label = "Color:";
              alignment = right;
            }
            : text {
              label = "Osnap:";
              alignment = right;
            }
          }
          : column {
            : edit_box {
              key = "inselv";
              width = 10;
              edit_width = 10;
              fixed_width = true;
            }
            : edit_box {
              key = "insthk";
              width = 10;
              edit_width = 10;
              fixed_width = true;
            }
            : edit_box {
              key = "inscol";
              width = 10;
              edit_width = 10;
              fixed_width = true;
            }
            : edit_box {
              key = "osnval";
              width = 10;
              edit_width = 10;
              fixed_width = true;
            }
          }
          : column {
            spacer_1;
            spacer_1;
            spacer_1;
            spacer_1;
            : button {
              label = "Set...";
              key = "colsel";
              width = 6;
              fixed_width = true;
            }
            : button {
              label = "Set...";
              key = "osnset";
              width = 6;
              fixed_width = true;
            }
          }
        }
        : row {
          : boxed_column {
            label = "Preview";
            : image_button {
              key = "symbol";
              color = black;
              height = 23;
              aspect_ratio = 1.3;
              is_tab_stop = false;
            }
          }
          : column {
            : row {
              : boxed_column {
                label = "Scales";
                : edit_box {
                  label = "X:";
                  key = "xscale";
                }
                : edit_box {
                  label = "Y:";
                  key = "yscale";
                }
                : edit_box {
                  label = "Z:";
                  key = "zscale";
                }
                : edit_box {
                  label = "R:";
                  key = "rotate";
                }
                : toggle {
                  label = "Drag Rotate";
                  key = "drgrot";
                }
              }
              : boxed_column {
                label = "Masking";
                : radio_button {
                  label = "None";
                  key = "msknon";
                }
                : radio_button {
                  label = "Trim";
                  key = "msktrm";
                }
                : radio_button {
                  label = "2DSolid";
                  key = "msksol";
                }
                : radio_button {
                  label = "Wipeout";
                  key = "mskwip";
                }
                : radio_button {
                  label = "MaskImg";
                  key = "mskimg";
                }
              }
            }
            : boxed_column {
              label = "Item Options";
              : toggle {
                label = "Ortho During Insert";
                key = "ortins";
              }
              : toggle {
                label = "Insert Exploded";
                key = "insexp";
              }
              : toggle {
                label = "Attribute Prompt";
                key = "attpmt";
              }
              : toggle {
                label = "Horizontal Attributes";
                key = "atthor";
              }
            }
          }
        }
        : row {
          : button {
            label = "Update";
            key = "itmupd";
            mnemonic = "U";
          }
          : button {
            label = "Add";
            key = "itmadd";
            mnemonic = "A";
          }
          : button {
            label = "New";
            key = "itmnew";
            mnemonic = "N";
          }
          : button {
            label = "Default";
            key = "itmdef";
          }
        }
        spacer;
      }
    }
  }
  : row {
    : button {
      label = "Add Multiple...";
      key = "addmul";
      width = 20;
    }
    : button {
      label = "Add Directory...";
      key = "adddir";
      width = 20;
    }
    : button {
      label = "Delete Records...";
      key = "itmdel";
      mnemonic = "D";
      width = 20;
    }
    : button {
      label = "Delete Group...";
      key = "grpdel";
      mnemonic = "p";
      width = 20;
    }
    : button {
      label = "Find/Replace...";
      key = "fndrep";
      mnemonic = "F";
      width = 20;
    }
  }
  : row {
    : button {
      key = "accept";
      label = "OK";
      allow_accept = true;
      is_default = true;
      width = 16;
    }
    : button {
      key = "cancel";
      label = "Cancel";
      is_cancel = true;
      width = 16;
    }
    : button {
      key = "impcsv";
      label = "Import...";
      mnemonic = "I";
      width = 16;
    }
    : button {
      key = "mercsv";
      label = "Merge...";
      mnemonic = "M";
      width = 16;
    }
    : button {
      key = "expcsv";
      label = "Export...";
      mnemonic = "E";
      width = 16;
    }
    : button {
      key = "help";
      label = "Help";
      mnemonic = "H";
      width = 16;
    }
  }
}

// ---------------------- Export Child Dialog

export : dialog {
  label = "Export Symbol Data";
  : boxed_column {
    label = "Group Names";
    : list_box {
      height = 10;
      key = "srclst";
      multiple_select = true;
    }
    : row {
      : button {
        key = "selall";
        label = "Select All";
        width = 12;
      }
      : button {
        key = "clrall";
        label = "Clear All";
        width = 12;
      }
    }
  }
  : boxed_row {
    label = "Target File";
    : edit_box {
      key = "tarfil";
      width = 30;
      edit_width = 30;
      fixed_width = true;
      edit_limit = 256;
    }
    : button {
      key = "tarsel";
      label = "Select...";
      width = 12;
      fixed_width = true;
    }
  }
  : row {
    : button {
      key = "write";
      label = "Export";
      width = 8;
      is_default = true;
    }
    : button {
      key = "cancel";
      label = "Exit";
      is_cancel = true;
      width = 8;
    }
    : button {
      key = "help";
      label = "Help";
      mnemonic = "H";
      width = 16;
    }
  }
}

// ---------------------- Multiple Block Select Child Dialog

blkmulti : dialog {
  label = "";
  key = "title";
  : row {
    : boxed_column {
      label = "Selections";
      : text {
        label = "Databases:";
      }
      : popup_list {
        key = "datlst";
        popup_height = 10;
        width = 31;
      }
      : text {
        label = "Groups:";
      }
      : popup_list {
        key = "grppop";
        popup_height = 10;
        width = 31;
      }
      : text {
        label = "Items:";
      }
      : list_box {
        key = "itmlst";
        height = 36;
        width = 31;
      }
      : button {
        label = "Details Dialog ...";
        key = "detsel";
        mnemonic = "D";
      }
    }
    : boxed_column {
      label = "Symbols";
      : row {
        : column {
          : image_button {
            key = "G1";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T1";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G2";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T2";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G3";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T3";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G4";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T4";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G5";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T5";
            alignment = centered;
          }
        }
      }
      : row {
        : column {
          : image_button {
            key = "G6";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T6";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G7";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T7";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G8";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T8";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G9";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T9";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G10";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T10";
            alignment = centered;
          }
        }
      }
      : row {
        : column {
          : image_button {
            key = "G11";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T11";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G12";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T12";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G13";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T13";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G14";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T14";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G15";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T15";
            alignment = centered;
          }
        }
      }
      : row {
        : column {
          : image_button {
            key = "G16";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T16";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G17";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T17";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G18";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T18";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G19";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T19";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G20";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T20";
            alignment = centered;
          }
        }
      }
      : row {
        : column {
          : image_button {
            key = "G21";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T21";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G22";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T22";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G23";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T23";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G24";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T24";
            alignment = centered;
          }
        }
        : column {
          : image_button {
            key = "G25";
            color = black;
            height = 7.5;
            aspect_ratio = 1.4;
          }
          : text {
            key = "T25";
            alignment = centered;
          }
        }
      }
    }
  }
  : row {
    : button {
      key = "accept";
      label = "OK";
      is_cancel = true;
      width = 12;
    }
    : button {
      key = "cancel";
      label = "Cancel";
      is_cancel = true;
      width = 12;
    }
    : button {
      key = "prev";
      label = "Previous";
      mnemonic = "P";
      width = 12;
    }
    : button {
      key = "next";
      label = "Next";
      mnemonic = "N";
      width = 12;
    }
    : button {
      key = "help";
      label = "Help";
      mnemonic = "H";
      width = 12;
    }
  }
}

// ---------------------- Find & Replace Child Dialog

fndrep : dialog {
  label = "Find and Replace Data";
  key = "title";
  : boxed_row {
    label = "Process Fields";
    : column {
      : toggle {
        label = "Block Name";
        key = "frblock";
        width = 12;
      }
      : toggle {
        label = "Slide Name";
        key = "frslide";
        width = 12;
      }
      : toggle {
        label = "Description";
        key = "frdesc";
        width = 12;
      }
      : toggle {
        label = "Group";
        key = "frgroup";
        width = 12;
      }
      : toggle {
        label = "Layer";
        key = "frlayer";
        width = 12;
      }
      : toggle {
        label = "Color";
        key = "frcolor";
        width = 12;
      }
      : toggle {
        label = "Elev";
        key = "frelev";
        width = 12;
      }
    }
    : column {
      : toggle {
        label = "Thick";
        key = "frthick";
        width = 12;
      }
      : toggle {
        label = "X-Scale";
        key = "frxscale";
        width = 12;
      }
      : toggle {
        label = "Y-Scale";
        key = "fryscale";
        width = 12;
      }
      : toggle {
        label = "Z-Scale";
        key = "frzscale";
        width = 12;
      }
      : toggle {
        label = "Rotation";
        key = "frrotate";
        width = 12;
      }
      : toggle {
        label = "Exploded";
        key = "frexplode";
        width = 12;
      }
      : toggle {
        label = "AttPrompt";
        key = "frattpmt";
        width = 12;
      }
    }
    : column {
      : toggle {
        label = "Before";
        key = "frrunbef";
        width = 12;
      }
      : toggle {
        label = "After";
        key = "frrunaft";
        width = 12;
      }
      : toggle {
        label = "Osnap";
        key = "frosnval";
        width = 12;
      }
      : toggle {
        label = "Ortho";
        key = "frortins";
        width = 12;
      }
      : toggle {
        label = "Mask";
        key = "frmskmth";
        width = 12;
      }
      : toggle {
        label = "AttHorz";
        key = "fratthor";
        width = 12;
      }
      : text {
        label = "";
      }
    }
  }
  : boxed_column {
    label = "Parameters";
    : edit_box {
      key = "fnd";
      label = "Find:";
    }
    : edit_box {
      key = "rep";
      label = "Repl:";
    }
    : toggle {
      key = "whl";
      label = "Match Whole String Only";
    }
  }
  : row {
    : button {
      key = "process";
      label = "Process";
      width = 8;
      is_default = true;
    }
    : button {
      key = "cancel";
      label = "Cancel";
      is_cancel = true;
      width = 8;
    }
    : button {
      key = "help";
      label = "Help";
      mnemonic = "H";
      width = 8;
    }
  }
}

// ---------------------- Delete Multi Child Dialog

delmulti : dialog {
  label = "Delete Records";
  : list_box {
    height = 30;
    key = "dellst";
    width = 32;
    fixed_width = true;
    multiple_select = true;
  }
  : row {
    : button {
      key = "process";
      label = "Process";
      width = 8;
      isaccept = true;
    }
    : button {
      key = "cancel";
      label = "Cancel";
      is_cancel = true;
      width = 8;
    }
    : button {
      key = "help";
      label = "Help";
      mnemonic = "H";
      width = 8;
    }
  }
}

// ----------------------  Get Multi/Dir Group Name Child Dialog

maddgroup : dialog {
  label = "Specify Group Name";
  : boxed_column {
    : list_box {
      height = 28;
      key = "mgrplst";
      width = 47;
      fixed_width = true;
    }
    : edit_box {
      label = "Value:";
      key = "mgrpval";
      width = 45;
      edit_width = 45;
      fixed_width = true;
    }
    : toggle {
      label = "Use Directory Name";
      key = "musedir";
    }
  }
  ok_cancel_help;
}

// ---------------------- Lose Changes Dialog

losechg : dialog {
  label = "Symbol Manager Alert";
  : text {
  }
  : text {
    label = "Notice: Closing the database now will discard";
    alignment = centered;
  }
  : text {
    label = "all changes to Symbol Manager Defintions";
    alignment = centered;
  }
  : text {
    label = "made in this execution.";
    alignment = centered;
  }
  : text {
  }
  : row {
    : button {
      key = "msave";
      label = "Save Changes";
    }
    : button {
      key = "mdiscard";
      label = "Discard Changes";
      is_default = true;
    }
  }
}

// ---------------------- Make Symbol Slides Dialog

symblsld : dialog {
  label = "Make Symbol Slides";
  : row {
    : boxed_column {
      label = "PreProcess";
      : radio_button {
        key = "prenon";
        label = "None";
      }
      : radio_button {
        key = "preshd";
        label = "Shade";
      }
      : radio_button {
        key = "prehid";
        label = "Hide";
      }
    }
    : boxed_column {
      label = "Selection";
      : radio_button {
        key = "selsng";
        label = "Single";
      }
      : radio_button {
        key = "selmul";
        label = "Multiple";
      }
      : radio_button {
        key = "seldir";
        label = "Directory";
      }
    }
  }
  : boxed_column {
    label = "Other Options";
    : toggle {
      label = "Generate Insertion Point Marker";
      key = "genmrk";
    }
    : toggle {
      label = "Fill Attributes with Tag Names";
      key = "filatt";
    }
  }
  ok_cancel_help;
}

// ---------------------- Set Osnaps Dialog

setosnap : dialog {
  label = "Symbol Osnaps";
  : boxed_row {
    label = "Settings";
    : column {
      : toggle {
        label = "Endpoint";
        mnemonic = "E";
        key = "end";
      }
      : toggle {
        label = "Midpoint";
        mnemonic = "M";
        key = "mid";
      }
      : toggle {
        label = "Center";
        mnemonic = "C";
        key = "cen";
      }
      : toggle {
        label = "Node";
        mnemonic = "d";
        key = "nod";
      }
      : toggle {
        label = "Quadrant";
        mnemonic = "Q";
        key = "qua";
      }
      : toggle {
        label = "Intersection";
        mnemonic = "I";
        key = "int";
      }
    }
    : column {
      : toggle {
        label = "Insertion";
        mnemonic = "S";
        key = "ins";
      }
      : toggle {
        label = "Perpendicular";
        mnemonic = "P";
        key = "per";
      }
      : toggle {
        label = "Tangent";
        mnemonic = "T";
        key = "tan";
      }
      : toggle {
        label = "Nearest";
        mnemonic = "r";
        key = "nea";
      }
      : toggle {
        label = "Apparent Int";
        mnemonic = "A";
        key = "app";
      }
      : toggle {
        label = "Quick";
        mnemonic = "u";
        key = "qui";
      }
    }
  }
  ok_cancel_help;
}

// #######################################################################
//                              SUPPORT.DCL
// #######################################################################

// ---------------------- Table Select Single

tablsngtn : dialog {
  label = "";
  key = "title";
  : list_box {
    width = 40;
    height = 40;
    key = "table";
    allow_accept = true;
    fixed_width = true;
  }
  ok_cancel;
}

tablsngtw : dialog {
  label = "";
  key = "title";
  : list_box {
    width = 90;
    height = 40;
    key = "table";
    allow_accept = true;
    fixed_width = true;
  }
  ok_cancel;
}

// ---------------------- Table Select Multiple

tablmultn : dialog {
  label = "";
  key = "title";  
  : list_box {
    width = 40;
    height = 27;
    key = "table";
    fixed_width = true;
    allow_accept = true;
    multiple_select = true;
  }
  : edit_box {
    label = "Select:";
    key = "selpat";
    mnemonic = "e";
  }
  : row {
    : button {
       key = "selall";
       label = "Select All";
       mnemonic = "S";
    }
    : button {
       key = "clrall";
       label = "Clear All";
       mnemonic = "C";
    }
  }
  ok_cancel;
}

tablmultw : dialog {
  label = "";
  key = "title";  
  : list_box {
    width = 90;
    height = 27;
    key = "table";
    fixed_width = true;
    allow_accept = true;
    multiple_select = true;
  }
  : edit_box {
    label = "Select:";
    key = "selpat";
    mnemonic = "e";
  }
  : row {
    : button {
       key = "selall";
       label = "Select All";
       mnemonic = "S";
    }
    : button {
       key = "clrall";
       label = "Clear All";
       mnemonic = "C";
    }
  }
  ok_cancel;
}

// ---------------------- Table Select Block

tablblk : dialog {
  label = "Select Block";
  : boxed_row {
    label = "Current Blocks";
    : list_box {
      height = 20;
      key = "table";
      allow_accept = true;
    }
  }
  : boxed_row {
    label = "External Drawing";
    : edit_box {
      key = "filnam";
      label = "File:";
      width = 40;
      edit_width = 40;
    }
    : button {
      key = "filsel";
      label = "Select...";
      width = 9;
    }
  }
  ok_cancel;
}
