; +--------------------------------------------------------------------+
; |                   ****  CONFIDENTIAL MATERIAL  ****                |
; |      (C) Copyright 1994-2019 by DotSoft. All rights reserved.      |
; +--------------------------------------------------------------------+
; |  The information contained herein is confidential, proprietary to  |
; |  DotSoft.  You may NOT use any part of the information in this     |
; |  file for any purpose other than in conjunction with DotSoft       |
; |  products.                                                         |
; +--------------------------------------------------------------------+

(vl-load-com)

; ###########################################################################
;                                   SUPPORT
; ###########################################################################

;----------------------------------------------------------------
;             'Stay on Top of File' functionality
;----------------------------------------------------------------

;
; --- Establish Program Location
;
(setq loc (findfile "TOOLPAC.LSP"))
(setq ctr (strlen loc))
(while (/= done T)
  (setq chk (substr loc ctr 1))
  (if (or (= chk "/")(= chk "\\"))
    (progn
      (setq dstpdir (strcase (substr loc 1 ctr)))
      (setq done T)
    )
    (setq ctr (1- ctr))
  )
)

;----------------------------------------------------------------
;                      List Support Functions
;----------------------------------------------------------------

(defun dstp_lstsort (zlst znum zrev)
  (if (= zrev nil)
    (setq zlst (vl-sort zlst (function (lambda (ze1 ze2)(< (nth znum ze1)(nth znum ze2))))))
    (setq zlst (vl-sort zlst (function (lambda (ze1 ze2)(> (nth znum ze1)(nth znum ze2))))))
  )
)

;----------------------------------------------------------------
;                      Misc Support Routines
;----------------------------------------------------------------

(defun dstp_prcseg ()
  (if (/= (abs zbul) 0.0)
    (progn
      (setq cang (angle zopt zcpt))
      (setq clen (distance zopt zcpt))
      (setq iang (* (atan zbul) 4.0))
      (setq mid2 (polar zopt cang (/ clen 2.0)))
      (setq rad2 (/ clen (* 2.0 (sin (/ iang 2.0)))))
      (setq larc (* iang rad2))
      (setq ord (- rad2 (* rad2 (- 1 (cos (/ iang 2.0))))))
      (setq zcen (polar mid2 (+ cang (/ pi 2.0)) ord))
      (setq rad2 (abs rad2))
      (setq sang (angle zcen zopt))
      (setq eang (angle zcen zcpt))
      (setq segs (fix (* (/ larc clen) 10.0)))
      (setq inc (/ (abs iang) segs))
      (setq uang sang)
      (repeat segs
        (if (> uang 6.28319)
          (setq uang (- uang 6.28319))
        )
        (setq ipnt (polar zcen uang rad2))
        (if (> (distance ipnt zopt) 0.01)
          (setq zlst (append zlst (list ipnt)))
        )
        (if (< zbul 0.0)
          (setq uang (- uang inc))
          (setq uang (+ uang inc))
        )
      )
    )
  )
  (setq zlst (append zlst (list zcpt)))
)

(defun dstp_clockwise (zpts)
  (setq zar 0.0)
  (foreach zpt zpts
    (if (/= zlp nil)
      (progn
        (setq zxf (- (car zpt)(car zlp)))
        (setq zyf (+ (cadr zpt)(cadr zlp)))
        (setq zar (+ zar (/ (* zxf zyf) 2.0)))
      )
    )
    (setq zlp zpt)
  )
  (if (< zar 0.0)
    (setq zre nil)
    (setq zre T)
  )
)

(defun dstp_datetime (zinp)
  (setq zdat nil)
  (setq ztim nil)
  (cond
    ((= (type zinp) 'STR) ; like CDATE
      (setq zmm (substr zinp 5 2))
      (setq zdd (substr zinp 7 2))
      (setq zyy (substr zinp 1 4))
      (setq zdat (strcat zmm "-" zdd "-" zyy))
      (setq zhr (substr zinp 10 2))
      (setq zmn (substr zinp 12 2))
      (if (<= 12 (atoi zhr))
        (setq zpost "pm")
        (setq zpost "am")
      )
      (if (= (atoi zhr) 0)
        (setq zhr "12")
        (if (< 12 (atoi zhr))
          (setq zhr (rtos (- (atoi zhr) 12) 2 0))
        )
      )
      (setq ztim (strcat zhr ":" zmn zpost))
    )
    ((= (type zinp) 'LIST) ; from vl-sysdatetime
      (setq zmm (itoa (nth 1 zinp)))
      (setq zdd (itoa (nth 3 zinp)))
      (setq zyy (itoa (nth 0 zinp)))
      (setq zdat (strcat zmm "-" zdd "-" zyy))
      (setq zhr (itoa (nth 4 zinp)))
      (setq zmn (itoa (nth 5 zinp)))
      (if (< (strlen zmn) 2)
        (setq zmn (strcat "0" zmn))
      )
      (if (<= 12 (atoi zhr))
        (setq zpost "pm")
        (setq zpost "am")
      )
      (if (= (atoi zhr) 0)
        (setq zhr "12")
        (if (< 12 (atoi zhr))
          (setq zhr (rtos (- (atoi zhr) 12) 2 0))
        )
      )
      (setq ztim (strcat zhr ":" zmn zpost))
    )
  )
  (list zdat ztim)
)

(defun dstp_dcllst (zlst zstr / zitm zres ztmp zuct)
  (setq zuct 1)
  (setq zres nil)
  (while (setq zitm (read zstr))
    (setq zitm (nth zitm zlst))
    (setq zres (cons zitm zres))
    (while (and (/= " " (substr zstr zuct 1))
      (/= "" (substr zstr zuct 1)))
      (setq zuct (1+ zuct))
    )
    (setq zstr (substr zstr zuct))
  )
  (setq ztmp (reverse zres))
)

(defun dstp_dclall (zlst / zinc zlat ztmp)
  (setq zinc 0)
  (setq zlat "")
  (repeat (length zlst)
    (setq zlat (strcat zlat (rtos zinc 2 0) " "))
    (setq zinc (1+ zinc))
  )
  (setq ztmp zlat)
)

(defun dstp_fexist (zfil)
  (if (/= zfil nil)
    (findfile zfil)
  )
)

(defun dstp_groupinfo ( / zdes zdic zg70 zg71 zhds zlst zmst ztmp)
  (setq zlst nil)
  (setq zdic (dictsearch (namedobjdict) "ACAD_GROUP"))
  (foreach zitm zdic
    (if (= (car zitm) 3)
      (setq zlst (cons (cdr zitm) zlst))
    )
  )
  (setq zmst nil)
  (foreach zgrp zlst
    (setq zhds nil)
    (setq ztmp (dictsearch (cdar zdic) zgrp))
    (if (/= ztmp nil)
      (progn
        (setq zdes (cdr (assoc 300 ztmp)))
        (setq zg70 (cdr (assoc 70 ztmp)))
        (setq zg71 (cdr (assoc 71 ztmp)))
        (foreach zitm ztmp
          (if (= (car zitm) 340)
            (setq zhds (cons (cdr zitm) zhds))
          )
        )
        (setq zmst (cons (list zgrp zdes zg70 zg71 zhds) zmst))
      )
    )
  )
  (setq ztmp zmst)
)

(defun dstp_ucspush ()
  (if (= (getvar "BLOCKEDITOR") 0)
    (progn
      (setq oldelev (getvar "ELEVATION"))
      (setq ucsfollow (getvar "UCSFOLLOW"))
      (setvar "UCSFOLLOW" 0)
      (command "_.UCS" "_W")
      (setvar "ELEVATION" oldelev)
    )
  )
)

(defun dstp_ucspop ()
  (if (= (getvar "BLOCKEDITOR") 0)
    (progn
      (command "_.UCS" "_P")
      (setvar "UCSFOLLOW" ucsfollow)
    )
  )
)

(defun dstp_prompt (zstr)
  (princ (strcat "\n" zstr "\r" zstr))
)
;
; --- remove objects from selection set that are in locked layers
;
(defun dstp_ssremlok (zset / zchk zcnt zent zhnd zkep zlay zrem ztmp ztot)
  (setq zcnt 0)
  (setq zrem 0)
  (setq zkep (ssadd))
  (setq ztot (sslength zset))
  (while (< zcnt ztot)
    (setq zhnd (ssname zset zcnt))
    (setq zent (entget zhnd))
    (setq zlay (cdr (assoc 8 zent)))
    (setq zchk (cdr (assoc 70 (tblsearch "LAYER" zlay))))
    (if (= zchk 4)
      (setq zrem (1+ zrem))
      (setq zkep (ssadd zhnd zkep))
    )
    (setq zcnt (1+ zcnt))
  )
  (setq ztmp (list zkep zrem))
)
;
; --- obtain objects elevation
;
(defun dstp_getelev (zhnd)
  (setq zelv nil)
  (setq zent (entget zhnd))
  (setq zobj (cdr (assoc 0 zent)))
  (cond
    ((= zobj "AECC_CONTOUR")
      (setq zelv (cdr (assoc 40 zent)))
    )
    ((= zobj "LWPOLYLINE")
      (setq zelv (cdr (assoc 38 zent)))
    )
    ((= zobj "3DFACE")
      (setq telv 0.0)
      (setq telv (+ telv (caddr (cdr (assoc 10 zent)))))
      (setq telv (+ telv (caddr (cdr (assoc 11 zent)))))
      (setq telv (+ telv (caddr (cdr (assoc 12 zent)))))
      (setq telv (+ telv (caddr (cdr (assoc 13 zent)))))
      (setq zelv (/ telv 4.0))
    )
    (t
      (setq zelv (caddr (cdr (assoc 10 zent))))
    )
  )
  (setq ztmp zelv)
)
;
; --- set objects elevation
;
(defun dstp_setelv (zhnd zelv)
  (setq zent (entget zhnd))
  (if (= (cdr (assoc 0 zent)) "LINE")
    (progn
      (setq z10 (cdr (assoc 10 zent)))
      (setq z11 (cdr (assoc 11 zent)))
      (setq n11 (list (nth 0 z11)(nth 1 z11)(nth 2 z10)))
      (setq zent (subst (cons 11 n11)(assoc 11 zent) zent))
      (entmod zent)
    )
  )
  (if (= (cdr (assoc 0 zent)) "LWPOLYLINE")
    (if (= (cdr (assoc 38 zent)) nil)
      (setq zold 0.0)
      (setq zold (cdr (assoc 38 zent)))
    )
    (setq zold (caddr (cdr (assoc 10 zent))))
  )
  (if (= zold nil)(setq zold 0.0))
  (setq edif (- zelv zold))
  (if (/= edif 0.0)
    (command "_.MOVE" zhnd "" "0,0,0" (strcat "@0,0," (rtos edif 2 8)))
  )
)
;
; --- draw temporary X marker
;
(defun dstp_marker (zcp)
  (if (= (length zcp) 2)
    (setq zcp (list (car zcp)(cadr zcp) 0.0))
  )
  (setq zsiz (/ (getvar "VIEWSIZE") 50.0))
  (grdraw (polar zcp 0.785398 zsiz) (polar zcp 3.92699 zsiz) -1)
  (grdraw (polar zcp 2.35619 zsiz) (polar zcp 5.49779 zsiz) -1)
  (grdraw (list (car zcp)(cadr zcp)(- (caddr zcp) zsiz)) (list (car zcp)(cadr zcp)(+ (caddr zcp) zsiz)) -1)
)
;
; --- draw temporary arrow marker
;
(defun dstp_arrow (zp1 zdr)
  (setq zsiz (/ (getvar "VIEWSIZE") 15.0))
  (setq zp2 (polar zp1 zdr (/ zsiz 2.0)))
  (grdraw zp1 zp2 -1)
  (grdraw zp2 (polar zp2 (+ (angle zp2 zp1) 5.89) (/ zsiz 4.0)) -1)
  (grdraw zp2 (polar zp2 (+ (angle zp2 zp1) 6.67) (/ zsiz 4.0)) -1)
  ;
  (setq zds (/ (getvar "VIEWSIZE") 300.0))
  (grdraw (polar zp1 0.00000 zds) (polar zp1 1.47080 zds) -1)
  (grdraw (polar zp1 1.47080 zds) (polar zp1 3.14159 zds) -1)
  (grdraw (polar zp1 3.14159 zds) (polar zp1 4.71238 zds) -1)
  (grdraw (polar zp1 4.71238 zds) (polar zp1 0.00000 zds) -1)
)
;
; --- save current properties
;
(defun dstp_savprop ()
  (setq dstp_clayer (getvar "CLAYER"))
  (setq dstp_cecolor (getvar "CECOLOR"))
  (setvar "CECOLOR" "BYLAYER")
  (setq dstp_celtype (getvar "CELTYPE"))
  (setvar "CELTYPE" "BYLAYER")
  (setq dstp_thickness (getvar "THICKNESS"))
  (setvar "THICKNESS" 0)
  (setq dstp_plinewid (getvar "PLINEWID"))
  (setvar "PLINEWID" 0)
  (setq dstp_filletrad (getvar "FILLETRAD"))
  (setvar "FILLETRAD" 0)
  (setq dstp_celtscale (getvar "CELTSCALE"))
  (setvar "CELTSCALE" 1.0)
)
;
; --- set current properties to object
;
(defun dstp_prop2obj (zhnd)
  (setq zent (entget zhnd))
  (setvar "CLAYER" (cdr (assoc 8 zent)))
  (if (/= (assoc 62 zent) nil)
    (setvar "CECOLOR" (dstp_col2str (cdr (assoc 62 zent))))
  )
  (if (/= (assoc 6 zent) nil)
    (setvar "CELTYPE" (cdr (assoc 6 zent)))
  )
  (if (/= (assoc 39 zent) nil)
    (setvar "THICKNESS" (cdr (assoc 39 zent)))
  )
  (if (/= (assoc 48 zent) nil)
    (setvar "CELTSCALE" (cdr (assoc 48 zent)))
  )
  (if (= (cdr (assoc 0 zent)) "LWPOLYLINE")
    (if (= (cdr (assoc 38 zent)) nil)
      (setq zelv 0.0)
      (setq zelv (cdr (assoc 38 zent)))
    )
    (setq zelv (caddr (cdr (assoc 10 zent))))
  )
  (if (/= zelv nil)
    (setvar "ELEVATION" zelv)
  )
)
;
; --- restore properties
;
(defun dstp_resprop ()
  (setvar "CELTSCALE" dstp_celtscale)
  (setvar "FILLETRAD" dstp_filletrad)
  (setvar "PLINEWID" dstp_plinewid)
  (setvar "THICKNESS" dstp_thickness)
  (setvar "CELTYPE" dstp_celtype)
  (setvar "CECOLOR" dstp_cecolor)
  (setvar "CLAYER" dstp_clayer)
)
;
; --- check table for locked layers
;
(defun dstp_lockstat ()
  (setq zstat nil)
  (setq zchk (tblnext "LAYER" T))
  (while (/= zchk nil)
    (if (= (boole 1 (cdr (assoc 70 zchk)) 4) 4)
      (setq zstat T)
    )
    (setq zchk (tblnext "LAYER"))
    (if (= zstat T)
      (setq zchk nil)
    )
  )
  (setq ztmp zstat)
)

(defun dstp_wipeoutchk ()
  (if (/= (findfile "acwipeout.arx") nil)
    (if (= (member "acwipeout.arx" (arx)) nil)
      (progn
        (arxload "acwipeout")
        (setq ztmp T)
      )
      (setq ztmp T)
    )
    (setq ztmp T)
  )
  (setq zret ztmp)
)

;----------------------------------------------------------------
;                     String Support Routines
;----------------------------------------------------------------

(defun dstp_left (inp len)
  (if (>= (strlen inp) len)
    (setq new (substr inp 1 len))
    (setq new inp)
  )
)

(defun dstp_sigfmt (zinp zmax)
  (setq zdon nil)
  (setq zstr (rtos zinp 2 zmax))
  (if (dstp_instr zstr ".")
    (setq zstr (strcat zstr "0000000000000000"))
    (setq zstr (strcat zstr ".0000000000000000"))
  )
  (setq zpos (strlen zstr))
  (while (= zdon nil)
    (if (/= (substr zstr zpos 1) "0")
      (setq zeps zpos zdon T)
    )
    (setq zpos (1- zpos))
  )
  (if (> zeps 0)
    (progn
      (setq zret (substr zstr 1 zeps))
      (if (= (substr zret (strlen zret) 1) ".")
        (setq zret (substr zret 1 (- (strlen zret) 1)))
      )
    )
  )
  (setq ztmp zret)
)

(defun dstp_ltrim (zinp)
  (vl-string-left-trim " " zinp)
)

(defun dstp_rtrim (zinp)
  (vl-string-right-trim " " zinp)
)
;
; --- determine if string 2 exists in string 1
;
(defun dstp_instr (s1 s2)
  (setq zres (vl-string-search s2 s1)) 
  (if (/= zres nil)
    (setq zret T)
    (setq zret nil)
  )
)
;
; --- substitute search string with new string
;
(defun dstp_subtext (s1 s2 s3)
  (setq c1 (strlen s2))
  (if (> c1 0)
    (progn
      (setq c0 1)
      (setq s4 "")
      (while (<= c0 (strlen s1))
        (if (= (strcase s2) (strcase (substr s1 c0 c1)))
          (setq s4 (strcat s4 s3) c0 (+ c0 c1))
          (setq s4 (strcat s4 (substr s1 c0 1)) c0 (1+ c0))
        )
      )
    )
    (setq s4 s1)
  )
  (setq ztmp s4)
)
;
; --- low level string split
;
(defun dstp_strsplit (zstr zdel)
  (setq lpos 0)
  (setq nlst nil)
  (while (/= (setq zpos (vl-string-search zdel zstr lpos)) nil)
    (setq nlst (cons (substr zstr (+ lpos 1) (- zpos lpos)) nlst))
    (setq lpos (+ zpos 1))
  )
  (if (< lpos (strlen zstr))
    (setq nlst (cons (substr zstr (+ lpos 1) (- (strlen zstr) lpos)) nlst))
  )
  (reverse nlst)
)
;
; --- convert a parm delimited string to a list
;
(defun dstp_pdf2lst (zstr zdel)
  (if (dstp_instr zstr (chr 34))  ; comma within quotes
    (progn
      (setq zinc 1)
      (setq zquo 0)
      (setq znew "")
      (repeat (strlen zstr)
        (setq zchr (substr zstr zinc 1))
        (if (= zchr (chr 34))
          (if (= zquo 0)
            (setq zquo 1)
            (setq zquo 0)
          )
        )
        (if (= zchr ",")
          (if (= zquo 1)
            (setq zchr "~")
          )
        )
        (setq znew (strcat znew zchr))
        (setq zinc (1+ zinc))
      )
      (setq znew (dstp_subtext znew "\"~\"" "~"))
      (setq zlst (dstp_strsplit znew "~"))
      (setq znew nil)
      (foreach zitm zlst
        (setq zitm (dstp_subtext zitm "~" ","))
        (setq znew (cons zitm znew))
      )
      (setq zlst (reverse znew))
    )
    (setq zlst (dstp_strsplit zstr zdel))
  )
  (setq ztmp zlst)
)

;----------------------------------------------------------------
;                      Text Support Routines
;----------------------------------------------------------------

(defun dstp_fixedhgt ()
  (setq zcur (getvar "TEXTSTYLE"))
  (setq zdat (tblsearch "STYLE" zcur))
  (setq zchk (cdr (assoc 40 zdat)))
  (if (> zchk 0.0)
    (setq zres zchk)
    (setq zres 0.0)
  )
)
;
(defun dstp_textsize ()
  (setq zcur (getvar "TEXTSTYLE"))
  (setq zdat (tblsearch "STYLE" zcur))
  (setq zchk (cdr (assoc 40 zdat)))
  (if (> zchk 0.0)
    (setq zres zchk)
    (setq zres (getvar "TEXTSIZE"))
  )
)
;
(defun dstp_maketext (zjst zins zhgt zrot zstr)
  (setq zins (trans zins 1 0))u
  (if (= zhgt 0.0)
    (progn
      (setq zcur (getvar "TEXTSTYLE"))
      (setq zdat (tblsearch "STYLE" zcur))
      (setq zchk (cdr (assoc 40 zdat)))
      (if (> zchk 0.0)
        (setq zhgt zchk)
        (setq zhgt (getvar "TEXTSIZE"))
      )
    )
  )
  (cond
    ((= zjst "L")(setq z72 0)(setq z73 0))
    ((= zjst "C")(setq z72 1)(setq z73 0))
    ((= zjst "R")(setq z72 2)(setq z73 0))
    ((= zjst "M")(setq z72 4)(setq z73 0))
    ((= zjst "TL")(setq z72 0)(setq z73 3))
    ((= zjst "TC")(setq z72 1)(setq z73 3))
    ((= zjst "TR")(setq z72 2)(setq z73 3))
    ((= zjst "ML")(setq z72 0)(setq z73 2))
    ((= zjst "MC")(setq z72 1)(setq z73 2))
    ((= zjst "MR")(setq z72 2)(setq z73 2))
    ((= zjst "BL")(setq z72 0)(setq z73 1))
    ((= zjst "BC")(setq z72 1)(setq z73 1))
    ((= zjst "BR")(setq z72 2)(setq z73 1))
    (t nil)
  )
  (setq znew '((0 . "TEXT")))
  (setq znew (append znew (list (list 10 0.0 0.0 0.0))))
  (setq znew (append znew (list (list 11 (nth 0 zins) (nth 1 zins) (nth 2 zins)))))
  (setq znew (append znew (list (cons 40 zhgt))))
  (setq znew (append znew (list (cons 50 (dstp_dtr zrot)))))
  (setq znew (append znew (list (cons 72 z72))))
  (setq znew (append znew (list (cons 73 z73))))
  (setq znew (append znew (list (cons 7 (getvar "TEXTSTYLE")))))
  (setq znew (append znew (list (cons 1 zstr))))
  (entmake znew)
)

(defun dstp_textrect (tent)              ; ll-lr-ur-ul
  (setq p0 (cdr (assoc 10 tent))
    ang (cdr (assoc 50 tent))
    sinrot (sin ang)
    cosrot (cos ang)
    t1 (car (textbox tent))
    t2 (cadr (textbox tent))
    p1 (list (+ (car p0)
       (- (* (car t1) cosrot) (* (cadr t1) sinrot)))
       (+ (cadr p0)
       (+ (* (car t1) sinrot) (* (cadr t1) cosrot))))
    p2 (list (+ (car p0)
       (- (* (car t2) cosrot) (* (cadr t1) sinrot)))
       (+ (cadr p0)
       (+ (* (car t2) sinrot) (* (cadr t1) cosrot))))
    p3 (list (+ (car p0)
       (- (* (car t2) cosrot) (* (cadr t2) sinrot)))
       (+ (cadr p0)
       (+ (* (car t2) sinrot) (* (cadr t2) cosrot))))
    p4 (list (+ (car p0)
       (- (* (car t1) cosrot) (* (cadr t2) sinrot)))
       (+ (cadr p0)
       (+ (* (car t1) sinrot) (* (cadr t2) cosrot))))
  )
  (list p1 p2 p3 p4)
)

;
; --- Support routine to calculate ll-lr-ur-ul of mtext object
;
(defun mtxttool_rectang (zent)
  (setq z10 (cdr (assoc 10 zent))) ; inspt
  (setq z11 (cdr (assoc 11 zent))) ; x-axis
  (setq zwd (cdr (assoc 42 zent))) ; width
  (setq zht (cdr (assoc 43 zent))) ; height
  (setq z71 (cdr (assoc 71 zent))) ; attach
  (setq zar (angle (list 0.0 0.0) z11))
  (setq zal (angle z11 (list 0.0 0.0)))
  (setq zad (- zar (/ pi 2.0)))
  (setq zau (+ zar (/ pi 2.0)))
  (cond
    ((= z71 1)
      (setq zp4 z10)
    )
    ((= z71 2)
      (setq zp4 (polar z10 zal (/ zwd 2.0)))
    )
    ((= z71 3)
      (setq zp4 (polar z10 zal zwd))
    )
    ((= z71 4)
      (setq zp4 (polar z10 zau (/ zht 2.0)))
    )
    ((= z71 5)
      (setq zpt (polar z10 zau (/ zht 2.0)))
      (setq zp4 (polar zpt zal (/ zwd 2.0)))
    )
    ((= z71 6)
      (setq zpt (polar z10 zau (/ zht 2.0)))
      (setq zp4 (polar zpt zal zwd))
    )
    ((= z71 7)
      (setq zp4 (polar z10 zau zht))
    )
    ((= z71 8)
      (setq zpt (polar z10 zau zht))
      (setq zp4 (polar zpt zal (/ zwd 2.0)))
    )
    ((= z71 9)
      (setq zpt (polar z10 zau zht))
      (setq zp4 (polar zpt zal zwd))
    )
    (t nil)
  )
  (setq zp3 (polar zp4 zar zwd))
  (setq zp2 (polar zp3 zad zht))
  (setq zp1 (polar zp2 zal zwd))
  (setq ztmp (list zp1 zp2 zp3 zp4))
)

;----------------------------------------------------------------
;             List Processing Support Routines
;----------------------------------------------------------------

;
; --- remove duplicates from list
;
(defun dstp_dupremove (zlst)
  (setq znew nil)
  (foreach zitm zlst
    (if (not (member zitm znew))
      (setq znew (cons zitm znew))
    )
  )
  (reverse znew)
)
;
; --- remove an element from a list
;
(defun dstp_remove (zrec zlst)
  (vl-remove zrec zlst)
)
;
; --- convert a selection set to a list
;
(defun dstp_ss2lst (zset)
  (if (/= zset nil)
    (progn
      (setq zlst nil)
      (setq zcnt 0)
      (setq ztot (sslength zset))
      (while (< zcnt ztot)
        (setq zhnd (ssname zset zcnt))
        (setq zlst (append zlst (list zhnd)))
        (setq zcnt (1+ zcnt))
      )
    )
    (setq zlst nil)
  )
  (setq ztmp zlst)
)

;----------------------------------------------------------------
;                     Conversion Support Routines
;----------------------------------------------------------------

(defun dstp_2dpoint (inp)
  (setq ret (list (car inp) (cadr inp)))
)

(defun dstp_str2col (inp)
  (cond
    ((= (strcase inp) "RED")(setq ret 1))
    ((= (strcase inp) "YELLOW")(setq ret 2))
    ((= (strcase inp) "GREEN")(setq ret 3))
    ((= (strcase inp) "CYAN")(setq ret 4))
    ((= (strcase inp) "BLUE")(setq ret 5))
    ((= (strcase inp) "MAGENTA")(setq ret 6))
    ((= (strcase inp) "WHITE")(setq ret 7))
    ((= (strcase inp) "BYLAYER")(setq ret 256))
    ((= (strcase inp) "BYBLOCK")(setq ret 0))
    ((and (>= (atoi inp) 0)(<= (atoi inp) 256))(setq ret (atoi inp)))
    (t nil)
  )
)

(defun dstp_col2str (inp)
  (cond
    ((= inp nil)(setq ret "BYLAYER"))
    ((= inp 256)(setq ret "BYLAYER"))
    ((= inp 0)(setq ret "BYBLOCK"))
    ((and (> inp 0)(< inp 256))(setq ret (itoa inp)))
    (t nil)
  )
)

(defun dstp_dtr (a)(* pi (/ a 180.0)))
(defun dstp_rtd (a)(* (/ a pi) 180.0))

(defun dstp_dms2dd (dms)
  (setq d (atoi (rtos dms 2 8)))
  (setq ms (* (- dms d) 100.0))
  (setq m (atoi (rtos ms 2 8)))
  (setq s (* (- ms m) 100.0))
  (setq dms (+ d (/ m 60.0) (/ s 3600.0)))
)

;----------------------------------------------------------------
;                   File/Path Support Routines
;----------------------------------------------------------------

(defun dstp_getfiles (ztit zdef zext zflg)
  (if (or (= zdef nil)(= zdef ""))
    (setq zdef (dstp_folder))
  )
  (setq ztmp (getfiled ztit zdef zext zflg))
  (if (/= ztmp nil)
    (progn
      (setq zfnd nil)
      (setq zpos (strlen ztmp))
      (while (> zpos 0)
        (setq zchr (substr ztmp zpos 1))
        (if (and (= zfnd nil)(= zchr (chr 92)))
          (setq zfnd zpos zpos 0)
        )
        (setq zpos (1- zpos))
      )
      (if (/= zpos nil)
        (setq dstp_lastfold (dstp_left ztmp zfnd))
      )
    )
  )
  (eval ztmp)
)

(defun dstp_getfilex (ztit zdef zext)
  (setq fn (dstp_getfilem ztit zdef zext))
  (if (/= fn "")
    (progn
      (setq nlst nil)
      (setq fh (open fn "r"))
      (setq ct (atoi (read-line fh)))
      (repeat ct
        (setq add (read-line fh))
        (setq nlst (cons add nlst))
      )
      (close fh)
      (vl-file-delete fn)
      (setq nlst (acad_strlsort nlst))
    )
  )
)

(defun dstp_dwgname ()
  (strcase (last (dstp_pdf2lst (car (dstp_pdf2lst (getvar "DWGNAME") ".")) "\\")))
)

(defun GetFileNameWithoutExtension (fulnam)
  (strcat (vl-filename-directory fulnam) "\\" (vl-filename-base fulnam))
)

; --------------------------------------------------------------------------
;                     BLDLST  (Build Symbol Lists)
; --------------------------------------------------------------------------

(defun dstp_bldlst (ztblnam)
  (setq zlst nil)
  (if (= ztblnam "XREF")
    (setq zitm (tblnext "BLOCK" T))
    (setq zitm (tblnext ztblnam T))
  )
  (while (/= zitm nil)
    (setq zfail nil)
    (setq znme (cdr (assoc 2 zitm)))
    (if (= znme "")
      (setq zfail T)
    )
    (if (= ztblnam "XREF")
      (progn
        (if (= (substr znme 1 1) "*")(setq zfail T))       ; is anonymous block
        (if (= (assoc 1 zitm) nil)(setq zfail T))          ; has no xref pointer
      )
    )
    (if (= ztblnam "BLOCK")
      (progn
        (if (= (substr znme 1 1) "$")(setq zfail T))                  ; is paper/model space
        (if (= (substr znme 1 1) "*")(setq zfail T))                  ; is anonymous block
        (if (= (substr znme 1 4) "AVE_")(setq zfail T))               ; is render block
        (if (= (logand (cdr (assoc 70 zitm)) 32) 32)(setq zfail T))   ; is xref attached
        (if (dstp_instr znme "|")(setq zfail T))                      ; is xref dependant
      )
    )
    (if (= zfail nil)
      (setq zlst (append zlst (list (strcase znme))))
    )
    (if (= ztblnam "XREF")
      (setq zitm (tblnext "BLOCK"))
      (setq zitm (tblnext ztblnam))
    )
  )
  zlst
)

; --------------------------------------------------------------------------
;                 TABLESEL  (Select Table Item From List)
; --------------------------------------------------------------------------

(defun dstp_tablesel (ztit zlst zopt zini)
  (if (/= zlst nil)
    (if (> (length zlst) 0)
      (progn
        (defun support_lstcon (op)
          (if (= op 0)
            (set_tile "table" "")
            (progn
              (setq zsel "")
              (setq inc 0)
              (repeat (length zlst)
                (setq zsel (strcat zsel (rtos inc 2 0) " "))
                (setq inc (1+ inc))
              )
              (set_tile "table" zsel)
            )
          )
        )
        (defun support_lstmat (ms)
          (setq inc 0)
          (setq ms (strcase ms))
          (repeat (length zlst)
            (setq chk (nth inc zlst))
            (if (= (wcmatch chk ms) T)
              (progn
                (setq zsel (strcat zsel (rtos inc 2 0) " "))
              )
            )
            (setq inc (1+ inc))
          )
          (set_tile "table" zsel)
          (set_tile "selpat" "")
        )
        (setq sln 0)
        (foreach itm zlst
          (setq chk (strlen itm))
          (if (> chk sln)
            (setq sln chk)
          )
        )
        (setq noresp nil)
        (setq zsel "")
        (if (= zopt "s")
          (if (< sln 40)
            (setq dlg "tablsngtn")
            (setq dlg "tablsngtw")
          )
        )
        (if (= zopt "m")
          (if (< sln 40)
            (setq dlg "tablmultn")
            (setq dlg "tablmultw")
          )
        )
        ;
        (setq tab_id (load_dialog "toolpac.dcl"))
        (if (not (new_dialog dlg tab_id)) (exit))
        (set_tile "title" ztit)
        (start_list "table")
        (mapcar 'add_list zlst)
        (end_list)
        (if (= zopt "s")
          (set_tile "table" zini)
        )
        (if (and (= zopt "m")(= zini "T"))
          (support_lstcon 1)
        )
        ;
        (action_tile "table" "(setq zsel $value)")
        (action_tile "cancel" "(setq noresp 1)")
        (action_tile "selpat" "(support_lstmat $value)")
        (action_tile "selall" "(support_lstcon 1)")
        (action_tile "clrall" "(support_lstcon 0)")
        ;
        (if (equal (start_dialog) 1)
          (progn
            (if (= zopt "s")
              (progn
                (setq resp nil)
                (setq tabitm (atoi zsel))
                (setq resp (nth tabitm zlst))
              )
            )
            (if (= zopt "m")
              (progn
                (setq uct 1)
                (setq resp nil)
                (while (setq tabitm (read zsel))
                  (setq respitm (nth tabitm zlst))
                  (setq resp (append resp (list respitm)))
                  (while (and (/= " " (substr zsel uct 1))
                    (/= "" (substr zsel uct 1)))
                    (setq uct (1+ uct))
                  )
                  (setq zsel (substr zsel uct))
                )
              )
            )
            (setq zlst nil)
            (setq zsel nil)
          )
        )
        (unload_dialog tab_id)
        (setq tmp resp)
      )
    )
  )
)

;----------------------------------------------------------------
;                      Get Polyline Data
;----------------------------------------------------------------

(defun dstp_getpline (ihnd)
  (setq zhnd ihnd)
  (setq zent (entget zhnd))
  (setq zobj (cdr (assoc 0 zent)))
  (setq dstp_plhdr nil)
  (setq dstp_pldat nil)
  (cond
    ((= zobj "POLYLINE")
      (if (= (boole 1 (cdr (assoc 70 zent)) 8) 8)
        (setq zplt "3D" zelv 0.0)
        (setq zplt "2D" zelv (nth 3 (assoc 10 zent)))
      )
      (setq zvtx nil)
      (while (/= "SEQEND" (cdr (assoc 0 zvtx)))
        (setq zhnd (entnext zhnd))
        (setq zvtx (entget zhnd))
        (if (= (cdr (assoc 0 zvtx)) "VERTEX")
          (progn
            (setq g10 (cdr (assoc 10 zvtx)))
            (setq g40 (cdr (assoc 40 zvtx)))
            (setq g41 (cdr (assoc 41 zvtx)))
            (setq g42 (cdr (assoc 42 zvtx)))
            (setq g70 (cdr (assoc 70 zvtx)))
            (setq rec (list g10 g40 g41 g42 g70))
            (setq dstp_pldat (append dstp_pldat (list rec)))
          )
        )
      )
    )
    ((= zobj "LWPOLYLINE")
      (setq l10 nil)
      (setq zplt "LW")
      (if (= (cdr (assoc 38 zent)) nil)
        (setq zelv 0.0)
        (setq zelv (cdr (assoc 38 zent)))
      )
      (foreach zlin zent
        (cond
          ((= (car zlin) 40)(setq g40 (cdr zlin)))
          ((= (car zlin) 41)(setq g41 (cdr zlin)))
          ((= (car zlin) 42)(setq g42 (cdr zlin)))
          ((= (car zlin) 10)
            (setq g10 (list (nth 1 zlin) (nth 2 zlin) zelv))
            (if (/= l10 nil)
              (progn
                (setq rec (list l10 g40 g41 g42 0))
                (setq dstp_pldat (append dstp_pldat (list rec)))
              )
            )
            (setq l10 g10)
          )
        )
      )
      (setq rec (list l10 g40 g41 g42 0))
      (setq dstp_pldat (append dstp_pldat (list rec)))
    )
    (t nil)
  )
  (if (/= dstp_pldat nil)
    (progn
      (setq dstp_plhdr (append dstp_plhdr (list zplt)))                    ; type LW,2D,3D
      (setq dstp_plhdr (append dstp_plhdr (list (cdr (assoc 70 zent)))))   ; group 70
      (setq dstp_plhdr (append dstp_plhdr (list (cdr (assoc 8 zent)))))    ; layer
      (setq dstp_plhdr (append dstp_plhdr (list (cdr (assoc 62 zent)))))   ; color
      (setq dstp_plhdr (append dstp_plhdr (list (cdr (assoc 6 zent)))))    ; linetype
      (setq dstp_plhdr (append dstp_plhdr (list (cdr (assoc 48 zent)))))   ; ltpscale
      (setq dstp_plhdr (append dstp_plhdr (list (cdr (assoc 39 zent)))))   ; thickness
      (setq dstp_plhdr (append dstp_plhdr (list zelv)))                    ; elevation
    )
  )
  (list dstp_plhdr dstp_pldat)
)

;----------------------------------------------------------------
;                     Make Polyline from Data
;----------------------------------------------------------------

; (setq dstp_plhdr (list "LW" g70 g8 g62 g6 g48 g39 g38))

(defun dstp_makepline ()
  (dstp_savprop)
  (setq plt (nth 0 dstp_plhdr))
  (cond
    ((or (= plt "2D")(= plt "3D"))
      (setq zent (quote ((0 . "POLYLINE"))))
      (if (= plt "2D")
        (setq zent (append zent (list (cons 10 (list 0.0 0.0 (nth 7 dstp_plhdr))))))
        (setq zent (append zent (list (cons 10 (list 0.0 0.0 0.0)))))
      )
      (setq zent (append zent (list (cons 70 (nth 1 dstp_plhdr)))))
      (setq zent (append zent (list (cons 8 (nth 2 dstp_plhdr)))))
      (if (/= (nth 3 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 62 (nth 3 dstp_plhdr)))))
      )
      (if (/= (nth 4 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 6 (nth 4 dstp_plhdr)))))
      )
      (if (/= (nth 5 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 48 (nth 5 dstp_plhdr)))))
      )
      (if (/= (nth 6 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 39 (nth 6 dstp_plhdr)))))
        (setq zent (append zent (list (cons 39 0.00))))
      )
      (entmake zent)
      ;
      (foreach rec dstp_pldat
        (setq add nil)
        (setq add (quote ((0 . "VERTEX"))))
        (setq add (append add (list (cons 10 (nth 0 rec)))))
        (setq add (append add (list (cons 40 (nth 1 rec)))))
        (setq add (append add (list (cons 41 (nth 2 rec)))))
        (setq add (append add (list (cons 42 (nth 3 rec)))))
        (setq add (append add (list (cons 70 (nth 4 rec)))))
        (setq add (append add (list (cons 8 (nth 2 dstp_plhdr)))))
        (if (/= (nth 3 dstp_plhdr) nil)
          (setq add (append add (list (cons 62 (nth 3 dstp_plhdr)))))
        )
        (if (/= (nth 4 dstp_plhdr) nil)
          (setq add (append add (list (cons 6 (nth 4 dstp_plhdr)))))
        )
        (entmake add)
      )
      (setq add (quote ((0 . "SEQEND"))))
      (setq add (append add (list (cons 8 (nth 2 dstp_plhdr)))))
      (entmake add)
      (setq zent nil)
      (setq add nil)
      (princ)
    )
    ((= plt "LW")
      (setq zent (quote ((0 . "LWPOLYLINE"))))
      (setq zent (append zent (list (cons 100 "AcDbEntity"))))
      (if (/= (nth 2 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 8 (nth 2 dstp_plhdr)))))
      )
      (setq zent (append zent (list (cons 100 "AcDbPolyline"))))
      (setq zent (append zent (list (cons 90 (length dstp_pldat)))))
      (setq zent (append zent (list (cons 70 (nth 1 dstp_plhdr)))))
      (if (/= (nth 3 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 62 (nth 3 dstp_plhdr)))))
      )
      (if (/= (nth 4 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 6 (nth 4 dstp_plhdr)))))
      )
      (if (/= (nth 5 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 48 (nth 5 dstp_plhdr)))))
      )
      (if (/= (nth 6 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 39 (nth 6 dstp_plhdr)))))
      )
      (if (/= (nth 7 dstp_plhdr) nil)
        (setq zent (append zent (list (cons 38 (nth 7 dstp_plhdr)))))
      )
      ;
      (foreach rec dstp_pldat
        (setq zent (append zent (list (cons 10 (list (nth 0 (nth 0 rec)) (nth 1 (nth 0 rec)))))))
        (setq zent (append zent (list (cons 40 (nth 1 rec)))))
        (setq zent (append zent (list (cons 41 (nth 2 rec)))))
        (setq zent (append zent (list (cons 42 (nth 3 rec)))))
      )
      (entmake zent)
      (setq zent nil)
      (princ)
    )
    (t nil)
  )
  (setq dstp_plhdr nil)
  (setq dstp_pldat nil)
  (dstp_resprop)
)

;----------------------------------------------------------------
;                        Object to List Routines
;----------------------------------------------------------------

(defun dstp_obj2lst (ihnd)
  (setq zhnd ihnd)
  (setq zlst nil)
  (setq zent (entget zhnd))
  (setq zobj (cdr (assoc 0 zent)))
  (cond
    ((= zobj "ARC")
      (setq zcen (list (nth 1 (assoc 10 zent)) (nth 2 (assoc 10 zent))))
      (setq zrad (cdr (assoc 40 zent)))
      (setq sang (cdr (assoc 50 zent)))
      (setq eang (cdr (assoc 51 zent)))
      (if (> eang sang)
        (setq iang (- eang sang))
        (setq iang (+ (- 6.28319 sang) eang))
      )
      (setq larc (* iang zrad))
      (setq apt1 (polar zcen sang zrad))
      (setq apt2 (polar zcen eang zrad))
      (setq clen (distance apt1 apt2))
      (setq segs (fix (* (/ larc clen) 10)))
      (setq inc (/ (abs iang) segs))
      (setq uang sang)
      (repeat (+ segs 1)
        (setq ipnt (polar zcen uang zrad))
        (setq zlst (append zlst (list ipnt)))
        (setq uang (+ uang inc))
      )
    )
    ((= zobj "CIRCLE")
      (setq zcen (list (nth 1 (assoc 10 zent)) (nth 2 (assoc 10 zent))))
      (setq zrad (cdr (assoc 40 zent)))
      (setq larc (* PI (* zrad 2.0)))
      (setq segs (fix (* (/ larc zrad) 10)))
      (setq inc (/ 6.28319 segs))
      (setq uang 0.0)
      (repeat segs
        (setq ipnt (polar zcen uang zrad))
        (setq zlst (append zlst (list ipnt)))
        (setq uang (+ uang inc))
      )
      (setq zlst (append zlst (list (nth 0 zlst))))
    )
    ((= zobj "ELLIPSE")
      (setq zaxo (vlax-ename->vla-object ihnd))
      (setq zbeg (vlax-curve-getStartParam zaxo))
      (setq zend (vlax-curve-getEndParam zaxo))
      (setq zinc (/ (- zend zbeg) 50.0))
      (setq zval zbeg)
      (while (< zval zend)
        (setq zpt (vlax-curve-getPointAtParam zaxo zval))
        (setq zlst (append zlst (list zpt)))
        (setq zval (+ zval zinc))
      )
      (setq zpt (vlax-curve-getPointAtParam zaxo zend))
      (setq zlst (append zlst (list zpt)))
      (setq sang (cdr (assoc 41 ent)))
      (setq eang (cdr (assoc 42 ent)))
      (if (and (= sang 0.0)(= eang (* pi 2.0)))
        (setq zlst (append zlst (list (car zlst))))
      )
    )
    ((= zobj "INSERT")
      (setq zpt (list (nth 1 (assoc 10 zent)) (nth 2 (assoc 10 zent))))
      (setq zlst (append zlst (list zpt)))
    )
    ((= zobj "LINE")
      (setq zpt1 (list (nth 1 (assoc 10 zent)) (nth 2 (assoc 10 zent))))
      (setq zpt2 (list (nth 1 (assoc 11 zent)) (nth 2 (assoc 11 zent))))
      (setq zlst (append zlst (list zpt1 zpt2)))
    )
    ((= zobj "LWPOLYLINE")
      (setq zbul 0.0)
      (foreach zlin zent
        (cond
          ((= (car zlin) 42)
            (setq zbul (cdr zlin))
          )
          ((= (car zlin) 10)
            (setq zcpt (cdr zlin))
            (if (not (equal zcpt zold 0.001))
              (dstp_prcseg)
            )
            (setq zold zcpt)
          )
          (if (/= zcpt nil)
            (setq zopt zcpt)
          )
          (t nil)
        )
      )
      (if (= (boole 1 (cdr (assoc 70 zent)) 1) 1)
        (progn
          (setq zcpt (car zlst))
          (if (not (equal zcpt zold 0.001))
            (dstp_prcseg)
          )
        )
      )
    )
    ((= zobj "MLINE")
      (foreach zlin zent
        (if (= (car zlin) 11)
          (progn
            (setq zpt (list (cadr zlin)(caddr zlin)))
            (setq zlst (append zlst (list zpt)))
          )
        )
      )
      (if (= (boole 1 (cdr (assoc 71 zent)) 2) 2) ; is closed?
        (setq zlst (append zlst (list (car zlst))))
      )
    )
    ((= zobj "POINT")
      (setq zpt (list (nth 1 (assoc 10 zent)) (nth 2 (assoc 10 zent)) (nth 3 (assoc 10 zent))))
      (setq zlst (append zlst (list zpt)))
    )
    ((= zobj "POLYLINE")
      (setq zdun nil)
      (setq zbul 0.0)
      (setq znhd zhnd)
      (while (/= zdun T)
        (setq znhd (entnext znhd))
        (setq zvtx (entget znhd))
        (if (= (cdr (assoc 0 zvtx)) "VERTEX")
          (progn
            (setq zcpt (cdr (assoc 10 zvtx)))
            (if (not (equal zcpt zold 0.001))
              (dstp_prcseg)
            )
            (setq zold zcpt)
            (setq zbul (cdr (assoc 42 zvtx)))
            (setq zopt zcpt)
          )
        )
        (if (= (cdr (assoc 0 zvtx)) "SEQEND")
          (setq zdun T)
        )
      )
      (if (= (boole 1 (cdr (assoc 70 zent)) 1) 1)
        (progn
          (setq zcpt (car zlst))
          (if (not (equal zcpt zold 0.001))
            (dstp_prcseg)
          )
        )
      )
    )
    ((= zobj "SPLINE")
      (setq zaxo (vlax-ename->vla-object ihnd))
      (setq zbeg (vlax-curve-getStartParam zaxo))
      (setq zend (vlax-curve-getEndParam zaxo))
      (setq zinc (/ (- zend zbeg) 100.0))
      (setq zval zbeg)
      (while (< zval zend)
        (setq zpt (vlax-curve-getPointAtParam zaxo zval))
        (setq zlst (append zlst (list zpt)))
        (setq zval (+ zval zinc))
      )
    )
    ((= zobj "TEXT")
      (setq zpt (list (nth 1 (assoc 10 zent)) (nth 2 (assoc 10 zent)) (nth 3 (assoc 10 zent))))
      (setq zlst (append zlst (list zpt)))
    )
    (t nil)
  )
  (setq ztmp zlst)
)

; --------------------------------------------------------------------------
;                      Float an object based on handle
; --------------------------------------------------------------------------

(defun dstp_dofloat (zhnd)
  (if (/= zhnd nil)
    (cond
      ((= dstp_floatmeth 1)                          ; copy
        (setvar "HIGHLIGHT" 0)
        (command "_.COPY" zhnd "" "0,0,0" "0,0,0")
        (entdel zhnd)
        (setvar "HIGHLIGHT" 1)
      )
      ((= dstp_floatmeth 2)                          ; draworder
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.DRAWORDER" zhnd "" "_F")
        (setvar "CMDECHO" cmdecho)
      )
      ((= dstp_floatmeth 3)                          ; entmake
        (setq zent (entget zhnd '("*")))
        (setq zobj (cdr (assoc 0 zent)))
        (setq zlst nil)
        (cond
          ((= zobj "INSERT")
            (setq zlst (list zent))
            (setq ztmp (assoc 66 zent))
            (if (= ztmp nil)
              (setq zafl nil)
              (progn
                (if (/= (cdr ztmp) nil)
                  (setq zafl T)
                )
              )
            )
            (if (= zafl T)
              (progn
                (setq znhd zhnd)
                (setq zdne nil)
                (while (/= zdne T)
                  (setq znhd (entnext znhd))
                  (setq znen (entget znhd))
                  (setq zlst (append zlst (list znen)))
                  (if (= "SEQEND" (cdr (assoc 0 znen)))
                    (setq zdne T)
                  )
                )
              )
            )
            (entdel zhnd)
            (foreach zitm zlst
              (entmake zitm)
            )
          )
          ((or (= zobj "IMAGE")(= zobj "WIPEOUT"))
            (setq tmp nil)
            (foreach rec zent
              (if (= (car rec) 13)
                (setq rec (list 13 (cadr rec) (caddr rec)))
              )
              (if (= (car rec) 14)
                (setq rec (list 14 (cadr rec) (caddr rec)))
              )
              (setq tmp (cons rec tmp))
            )
            (setq zent (reverse tmp))
            (entdel zhnd)
            (entmake zent)
          )
          ((= zobj "HATCH")
            (setq tmp nil)
            (foreach rec zent
              (if (= (car rec) 10)
                (setq rec (list 10 (cadr rec) (caddr rec)))
              )
              (if (= (car rec) 11)
                (setq rec (list 11 (cadr rec) (caddr rec)))
              )
              (setq tmp (cons rec tmp))
            )
            (setq zent (reverse tmp))
            (entdel zhnd)
            (entmake zent)
          )
          ((= zobj "POLYLINE")
            (setq zlst (list zent))
            (setq znhd zhnd)
            (setq zdne nil)
            (while (/= zdne T)
              (setq znhd (entnext znhd))
              (setq znen (entget znhd))
              (setq zlst (cons znen zlst))
              (if (= "SEQEND" (cdr (assoc 0 znen)))
                (setq zdne T)
              )
            )
            (setq zlst (reverse zlst))
            (entdel zhnd)
            (foreach zitm zlst
              (entmake zitm)
            )
          )
          ((= zobj "DIMENSION")
            (command "_.COPY" zhnd "" "0,0,0" "0,0,0")
            (entdel zhnd)
          )
          ((= (substr zobj 1 3) "AEC")
            (command "_.COPY" zhnd "" "0,0,0" "0,0,0")
            (entdel zhnd)
          )
          (t
            (entdel zhnd)
            (entmake zent)
          )
        )
        (setq zent nil)
      )
      (t nil)
    )
  )
)

; --------------------------------------------------------------------------
;             ATTLST  (Build Attribute Tag List from SelSet)
; --------------------------------------------------------------------------

(defun dstp_attlst (zset)
  (if zset
    (progn
      (princ "\nDS>")
      (setq zlst nil)
      (setq znum (sslength zset) zitm 0)
      (while (< zitm znum)
        (princ (strcat "\rDS> Evaluating Object " (rtos (1+ zitm) 2 0) " of " (rtos znum 2 0)))
        (setq zbhd (ssname zset zitm))
        (setq zben (entget zbhd))
        (setq znhd zbhd)
        (setq znen zben)
        (while (/= "SEQEND" (cdr (assoc 0 znen)))
          (setq znhd (entnext znhd))
          (setq znen (entget znhd))
          (if (= (cdr (assoc 0 znen)) "ATTRIB")
            (progn
              (setq ztag (strcase (cdr (assoc 2 znen))))
              (if (not (member ztag zlst))
                (setq zlst (append zlst (list ztag)))
              )
            )
          )
        )
        (setq zitm (1+ zitm))
      )
      (princ (strcat ", Done." (chr 13)))
      (setq tmp zlst)
    )
  )
)

; --------------------------------------------------------------------------
;         ATTDEF  (Build Attribute Defintion List from Block Name)
; --------------------------------------------------------------------------

(defun dstp_attdef (znam)
  (setq zblk (tblsearch "BLOCK" znam))
  (if (/= zblk nil)
    (progn
      (setq zhnd (cdr (assoc -2 zblk)))
      (setq zlst nil)
      (setq zdone nil)
      (while (/= zdone T)
        (setq zent (entget zhnd))
        (if (= (cdr (assoc 0 zent)) "ATTDEF")
          (setq zlst (append zlst (list (cdr (assoc 2 zent)))))
        )
        (if (= (setq zhnd (entnext (cdr (assoc -1 zent)))) nil)
          (setq zdone T)
        )
        (setq ztmp zlst)
      )
    )
    (setq ztmp nil)
  )
)

; --------------------------------------------------------------------------
;                      ToolPac Variable Storage
; --------------------------------------------------------------------------

(defun dstp_regstore (zgrp zvar zval / ztmp)
  (if (/= zval nil)
    (if (= (type zval) 'STR)
      (progn
        (setq ztmp (strcat "HKEY_CURRENT_USER\\Software\\DotSoft\\ToolPac\\" zgrp))
        (vl-registry-write ztmp zvar zval)
      )
    )
  )
)

(defun dstp_regfetch (zgrp zvar zdef / zkey zret ztmp zval)
  (setq zval zdef)
  (setq zkey (strcat "HKEY_CURRENT_USER\\Software\\DotSoft\\ToolPac\\" zgrp))
  (setq ztmp (vl-registry-read zkey zvar))
  (if (/= ztmp nil)
    (cond
      ((= (type ztmp) 'STR)
        (if (/= ztmp "")
          (setq zval ztmp)
        )
      )
      ((= (type ztmp) 'INT)
        (setq zval (itoa ztmp))
      )
    )
  )
  (setq zret zval)
)

; ###########################################################################
;                                  ANNOTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                          Annotation Masking Options
; --------------------------------------------------------------------------

(defun c:AnnMskAdd ( / $value add axo bhn ble blk buf chk cmdecho cnt col
                       cset dcl_id disx disy done doproc elv ent fac g60
                       g66 grp highlight hnd img itm lay lst maxpt maxx
                       maxy minpt minx miny mth nam new num obj old oly
                       orthomode osmode p1 p2 p3 p4 p5 p6 p7 p8 par pro
                       rec res scl siz sol sset tag tgl tmp tot tp uly
                       val wid)
  (defun annomask_dogray ()
    (mode_tile "3dfelv" 0)
    (mode_tile "uscval" 0)
    (mode_tile "uscsel" 0)
    (mode_tile "uslval" 0)
    (mode_tile "uslsel" 0)
    (mode_tile "grpobj" 0)
    (cond
      ((= mth "2")
        (mode_tile "3dfelv" 1)
        (set_tile "typ2ds" "1")
      )
      ((= mth "3")
        (set_tile "typ3ds" "1")
      )
      ((= mth "M")
        (mode_tile "3dfelv" 1)
        (mode_tile "uscval" 1)
        (mode_tile "uscsel" 1)
        (set_tile "typmsk" "1")
      )
      ((= mth "T")
        (mode_tile "3dfelv" 1)
        (mode_tile "uscval" 1)
        (mode_tile "uscsel" 1)
        (mode_tile "uslval" 1)
        (mode_tile "uslsel" 1)
        (mode_tile "grpobj" 1)
        (set_tile "typtrm" "1")
      )
      ((= mth "W")
        (mode_tile "3dfelv" 1)
        (mode_tile "uscval" 1)
        (mode_tile "uscsel" 1)
        (set_tile "typwip" "1")
      )
    )
  )
  (defun annomask_selcol ()
    (setq old (dstp_str2col col))
    (setq chk (acad_colordlg old T))
    (if (/= chk nil)
      (progn
        (setq col (dstp_col2str chk))
        (set_tile "uscval" col)
      )
    )
  )
  (defun annomask_sellay ()
    (setq chk (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
    (if (/= chk "")
      (progn
        (setq lay chk)
        (set_tile "uslval" lay)
      )
    )
  )
  (setq sset (ssget "_I" '((-4 . "<OR")(0 . "ATTDEF")(0 . "DIMENSION")(0 . "INSERT")(0 . "MTEXT")(0 . "TEXT")(0 . "TOLERANCE")(-4 . "OR>"))))
  (if (= sset nil)
    (progn
      (princ "\nDS> Select Annotation Objects to Process ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "ATTDEF")(0 . "DIMENSION")(0 . "INSERT")(0 . "MTEXT")(0 . "TEXT")(0 . "TOLERANCE")(-4 . "OR>"))))
    )
  )
  (if (/= (dstp_isvalid) nil)
    (progn
      (if sset
          (progn
            (setvar "SORTENTS" 127)
            (setq chk (dstp_ssremlok sset))
            (if (> (cadr chk) 0)
              (progn
                (setq sset (car chk))
                (sssetfirst sset nil)
                (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
              )
            )
            (setq mth (dstp_regfetch "Mask" "Method" "M"))
            (setq buf (atof (dstp_regfetch "Mask" "Buffer" (rtos (* (dstp_textsize) 0.25) 2 4))))
            (setq elv (atof (dstp_regfetch "Mask" "Elevation" (rtos (getvar "ELEVATION") 2 4))))
            (setq col (dstp_regfetch "Mask" "Color" (getvar "CECOLOR")))
            (setq lay (dstp_regfetch "Mask" "Layer" "OLAYER"))
            (setq grp (dstp_regfetch "Mask" "Group" "1"))
            (setq dcl_id (load_dialog "toolpac.dcl"))
            (if (not (new_dialog "annomask" dcl_id)) (exit))
            (if (/= (dstp_wipeoutchk) T)
              (mode_tile "typwip" 1)
            )
            (annomask_dogray)
            (set_tile "buffer" (rtos buf 2 4))
            (set_tile "3dfelv" (rtos elv 2 4))
            (set_tile "uscval" col)
            (set_tile "uslval" lay)
            (set_tile "grpobj" grp)
            ;
            (action_tile "typ2ds" "(setq mth \"2\")(annomask_dogray)")
            (action_tile "typ3df" "(setq mth \"3\")(annomask_dogray)")
            (action_tile "typmsk" "(setq mth \"M\")(annomask_dogray)")
            (action_tile "typtrm" "(setq mth \"T\")(annomask_dogray)")
            (action_tile "typwip" "(setq mth \"W\")(annomask_dogray)")
            (action_tile "buffer" "(setq buf (atof $value))")
            (action_tile "3dfelv" "(setq elv (atof $value))")
            (action_tile "uscval" "(setq col $value)")
            (action_tile "uscsel" "(annomask_selcol)")
            (action_tile "uslval" "(setq lay $value)")
            (action_tile "uslsel" "(annomask_sellay)")
            (action_tile "grpobj" "(setq grp $value)")
            ;
            (action_tile "accept" "(setq doproc T)(done_dialog 0)")
            (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
            (action_tile "help" "(dstp_showhelp \"AnnMskAdd.htm\")")
            (start_dialog)
            (unload_dialog dcl_id)
            (if (= doproc T)
              (progn
                (dstp_regstore "Mask" "Method" mth)
                (dstp_regstore "Mask" "Buffer" (rtos buf 2 4))
                (dstp_regstore "Mask" "Elevation" (rtos elv 2 4))
                (dstp_regstore "Mask" "Color" col)
                (dstp_regstore "Mask" "Layer" lay)
                (dstp_regstore "Mask" "Group" grp)
                (if (= mth "3")
                  (if (= (getvar "HIDEPRECISION") 0)
                    (setvar "HIDEPRECISION" 1)
                  )
                )
                (setq lst nil)
                (setq tgl nil)
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> PreProcessing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq obj (cdr (assoc 0 ent)))
                  (cond
                    ((= obj "DIMENSION")
                      (setq nam (cdr (assoc 2 ent)))
                      (setq blk (tblsearch "BLOCK" nam))
                      (setq bhn (cdr (assoc -2 blk)))
                      (setq done nil)
                      (while (/= done T)
                        (setq ble (entget bhn))
                        (if (= (cdr (assoc 0 ble)) "MTEXT")
                          (progn
                            (setq chk (mtxttool_rectang ble))
                            (setq lst (cons (list bhn hnd (nth 0 chk)(nth 1 chk)(nth 2 chk)(nth 3 chk)) lst))
                            (setq done T)
                          )
                        )
                        (if (= (setq bhn (entnext (cdr (assoc -1 ble)))) nil)
                          (setq done T)
                        )
                      )
                    )
                    ((= obj "INSERT")
                      (setq g66 (cdr (assoc 66 ent)))
                      (if (= g66 1)
                        (progn
                          (setq bhn hnd)
                          (setq ble ent)
                          (while (/= "SEQEND" (cdr (assoc 0 ble)))
                            (setq bhn (entnext bhn))
                            (setq ble (entget bhn))
                            (if (= (cdr (assoc 0 ble)) "ATTRIB")
                              (if (/= (dstp_rtrim (cdr (assoc 1 ble))) "")
                                (progn
                                  (setq tag (strcase (cdr (assoc 2 ble))))
                                  (if (not (member tag tgl))
                                    (setq tgl (cons tag tgl))
                                  )
                                  (setq chk (dstp_textrect ble))
                                  (setq lst (cons (list bhn hnd (nth 0 chk)(nth 1 chk)(nth 2 chk)(nth 3 chk)) lst))
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    ((= obj "MTEXT")
                      (setq chk (mtxttool_rectang ent))
                      (setq lst (cons (list hnd hnd (nth 0 chk)(nth 1 chk)(nth 2 chk)(nth 3 chk)) lst))
                    )
                    ((= obj "TEXT")
                      (setq chk (dstp_textrect ent))
                      (setq lst (cons (list hnd hnd (nth 0 chk)(nth 1 chk)(nth 2 chk)(nth 3 chk)) lst))
                    )
                    (t
                      (setq axo (vlax-ename->vla-object hnd))
                      (vla-getboundingbox axo 'minpt 'maxpt)
                      (setq minpt (vlax-safearray->list minpt))
                      (setq maxpt (vlax-safearray->list maxpt))
                      (setq minpt (dstp_2dpoint minpt))
                      (setq maxpt (dstp_2dpoint maxpt))
                      (setq p1 (list (car minpt)(cadr minpt)))
                      (setq p2 (list (car maxpt)(cadr minpt)))
                      (setq p3 (list (car maxpt)(cadr maxpt)))
                      (setq p4 (list (car minpt)(cadr maxpt)))
                      (setq lst (cons (list hnd hnd p1 p2 p3 p4) lst))
                    )
                  )
                  (setq itm (1+ itm))
                )
                (princ ", Done.\r")
                (if (/= tgl nil)
                  (progn
                    (setq res (dstp_tablesel "Process Tags" (acad_strlsort tgl) "m" "T"))
                    (if (/= res nil)
                      (if (< (length res)(length tgl))
                        (progn
                          (setq new nil)
                          (foreach itm lst
                            (setq add T)
                            (setq hnd (car itm))
                            (setq ent (entget hnd))
                            (setq obj (cdr (assoc 0 ent)))
                            (if (= obj "ATTRIB")
                              (progn
                                (setq tag (strcase (cdr (assoc 2 ent))))
                                (if (not (member tag res))
                                  (setq add nil)
                                )
                              )
                            )
                            (if (= add T)
                              (setq new (cons itm new))
                            )
                          )
                          (setq lst new)
                          (setq new nil)
                        )
                      )
                    )
                  )
                )
                (if (/= lst nil)
                  (progn
                    (setq cmdecho (getvar "CMDECHO"))
                    (setq osmode (getvar "OSMODE"))
                    (setvar "OSMODE" 0)
                    (setq orthomode (getvar "ORTHOMODE"))
                    (setvar "ORTHOMODE" 0)
                    (setq cmdecho (getvar "CMDECHO"))
                    (setvar "CMDECHO" 0)
                    (command "_.UNDO" "_G")
                    (dstp_ucspush)
                    (princ "\nDS>")
                    (setq pro nil)
                    (setq lst (reverse lst))
                    (setq tot (length lst) cnt 0)
                    (foreach itm lst
                      (princ (strcat "\rDS> Processing Object " (itoa (1+ cnt)) " of " (itoa tot)))
                      (setq hnd (car itm))
                      (setq ent (entget hnd))
                      (setq oly (cdr (assoc 8 ent)))
                      (cond
                        ((= lay "OLAYER")
                          (setq uly oly)
                        )
                        ((= lay "CLAYER")
                          (setq uly (getvar "CLAYER"))
                        )
                        (t
                          (setq uly lay)
                        )
                      )
                      (setq par (cadr itm))
                      (setq p1 (nth 2 itm))
                      (setq p2 (nth 3 itm))
                      (setq p3 (nth 4 itm))
                      (setq p4 (nth 5 itm))
                      (if (and (> (distance p1 p2) 0.0)(> (distance p1 p4) 0.0))
                        (progn
                          (setq tp (polar p1 (angle p4 p1) buf))
                          (setq p5 (polar tp (angle p2 p1) buf))
                          (setq tp (polar p2 (angle p3 p2) buf))
                          (setq p6 (polar tp (angle p1 p2) buf))
                          (setq tp (polar p3 (angle p2 p3) buf))
                          (setq p7 (polar tp (angle p4 p3) buf))
                          (setq tp (polar p4 (angle p1 p4) buf))
                          (setq p8 (polar tp (angle p3 p4) buf))
                          (cond
                            ((= mth "T") ; trim
                              (setq cset (ssget "_WP" (list p5 p6 p7 p8)))
                              (if (/= cset nil)
                                (progn
                                  (ssdel hnd cset)
                                  (command "_.ERASE" cset "")
                                )
                              )
                              (command "_.PLINE" p5 p6 p7 p8 "_C")
                              (setq rec (entlast))
                              (command "_.TRIM" rec "" "_F" p1 p2 p3 p4 p1 "" "")
                              (entdel rec)
                            )
                            ((= mth "2") ; solid
                              (setq sol '((0 . "SOLID")))
                              (setq sol (append sol (list (list 10 (car p5) (cadr p5) 0.0))))
                              (setq sol (append sol (list (list 11 (car p6) (cadr p6) 0.0))))
                              (setq sol (append sol (list (list 12 (car p8) (cadr p8) 0.0))))
                              (setq sol (append sol (list (list 13 (car p7) (cadr p7) 0.0))))
                              (setq sol (append sol (list (cons 62 (dstp_str2col col)))))
                              (setq sol (append sol (list (cons 8 uly))))
                              (entmake sol)
                              (setq pro (cons (list par (entlast)) pro))
                            )
                            ((= mth "3") ; 3dface
                              (setq val (+ elv 0.015))
                              (setq fac '((0 . "3DFACE")))
                              (setq fac (append fac (list (list 10 (car p5) (cadr p5) val))))
                              (setq fac (append fac (list (list 11 (car p6) (cadr p6) val))))
                              (setq fac (append fac (list (list 12 (car p7) (cadr p7) val))))
                              (setq fac (append fac (list (list 13 (car p8) (cadr p8) val))))
                              (setq fac (append fac (list (cons 70 15))))
                              (setq fac (append fac (list (cons 8 uly))))
                              (entmake fac)
                              (setq pro (cons (list par (entlast)) pro))
                              (dstp_setelv par (+ val 0.001))
                            )
                            ((= mth "M") ; maskimg
                              (setq minx 999999999999.99)
                              (setq maxx -999999999999.99)
                              (setq miny 999999999999.99)
                              (setq maxy -999999999999.99)
                              (setq tmp (list p5 p6 p7 p8))
                              (foreach pnt tmp
                                (if (< (car pnt) minx)(setq minx (car pnt)))
                                (if (> (car pnt) maxx)(setq maxx (car pnt)))
                                (if (< (cadr pnt) miny)(setq miny (cadr pnt)))
                                (if (> (cadr pnt) maxy)(setq maxy (cadr pnt)))
                              )
                              (setq minpt (list minx miny))
                              (setq maxpt (list maxx maxy))
                              (setq disx (- (car maxpt)(car minpt)))
                              (setq disy (- (cadr maxpt)(cadr minpt)))
                              (if (> disx disy)
                                (setq siz disx)
                                (setq siz disy)
                              )
                              (setq img (findfile dstp_wipeimage))
                              (command "_.IMAGE" "_A" img minpt 0.01 "0")
                              (setq hnd (entlast))
                              (setq ent (entget hnd))
                              (setq wid (car (cdr (assoc 11 ent))))
                              (setq g60 (assoc 60 ent))
                              (if (/= g60 nil)
                                (setq ent (subst (cons 60 1)(assoc 60 ent) ent))
                                (setq ent (append ent (list (cons 60 1))))
                              )
                              (entmod ent)
                              (setq scl (/ siz wid))
                              (command "_.SCALE" hnd "" minpt scl)
                              (command "_.CHPROP" hnd "" "_LA" uly "")
                              (command "_.IMAGECLIP" hnd "")
                              (if (/= (cdr (assoc 91 ent)) nil)
                                (if (> (cdr (assoc 91 ent)) 2)
                                  (command "_Y")
                                )
                              )
                              (if (and (equal (car p6) (car p7) 0.0001)(equal (cadr p5) (cadr p6) 0.0001))
                                (command "_R" p5 p7)
                                (command "_P" p5 p6 p7 p8 "")
                              )
                              (setq hnd (entlast))
                              (setq ent (entget hnd))
                              (setq ent (subst (cons 60 0)(assoc 60 ent) ent))
                              (entmod ent)
                              (setq pro (cons (list par (entlast)) pro))
                            )
                            ((= mth "W") ; wipeout
                              (command "_.WIPEOUT" p5 p6 p7 p8 "")
                              (command "_.CHPROP" (entlast) "" "_LA" uly "")
                              (setq pro (cons (list par (entlast)) pro))
                            )
                          )
                        )
                      )
                      (setq cnt (1+ cnt))
                    )
                    (princ ", Done.")
                    (if (> (length pro) 0)
                      (if (= grp "1")
                        (progn
                          (dstp_prompt "DS> Binding Collections ... ")
                          (setq highlight (getvar "HIGHLIGHT"))
                          (setvar "HIGHLIGHT" 0)
                          (while (> (length pro) 0)
                            (setq par (car (car pro)))
                            (setq sset (ssadd))
                            (foreach rec pro
                              (if (= (car rec) par)
                                (setq sset (ssadd (cadr rec) sset))
                              )
                            )
                            ;(dstp_dofloat par)
                            (command "_.DRAWORDER" par "" "_F")
                            (setq sset (ssadd par sset))
                            ;(setq sset (ssadd (entlast) sset))
                            (command "_.-GROUP" "" "*" "" sset "")
                            (setq sset nil)
                            (setq new nil)
                            (foreach rec pro
                              (if (not (= (car rec) par))
                                (setq new (cons rec new))
                              )
                            )
                            (setq pro new)
                          )
                          (setvar "HIGHLIGHT" highlight)
                          (princ "Done.")
                        )
                      )
                    )
                    (if (= mth "M")
                      (princ "\nDS> Optionally turn off IMAGEFRAME, followed by REGEN")
                    )
                    (dstp_ucspop)
                    (command "_.UNDO" "_E")
                    (setvar "CMDECHO" cmdecho)
                    (setvar "ORTHOMODE" orthomode)
                    (setvar "OSMODE" osmode)
                )
              )
            )
          )
        )
      )
    )
  )
  (princ)
)
;
; --- Unmask Function
;
(defun c:AnnMskRem ( / bhn ble cmdecho ent fnd g66 hds hnd img itm lst
                       msk nam num obj sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (dstp_prompt "DS> Building List of Groups ... ")
      (setq lst (dstp_groupinfo))
      (princ "Done.\r")
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "ATTDEF")(0 . "DIMENSION")(0 . "INSERT")(0 . "MTEXT")(0 . "TEXT")(0 . "TOLERANCE")(-4 . "OR>"))))
      (if (= sset nil)
        (progn
          (princ "\nDS> Select Annotation Objects to Unmask ...")
          (setq sset (ssget '((-4 . "<OR")(0 . "ATTDEF")(0 . "DIMENSION")(0 . "INSERT")(0 . "MTEXT")(0 . "TEXT")(0 . "TOLERANCE")(-4 . "OR>"))))
        )
      )
      (if sset
        (progn
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq fnd nil img nil)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (if (= obj "INSERT")
              (progn
                (setq g66 (cdr (assoc 66 ent)))
                (if (= g66 1)
                  (progn
                    (setq bhn hnd)
                    (setq ble ent)
                    (while (/= "SEQEND" (cdr (assoc 0 ble)))
                      (setq bhn (entnext bhn))
                      (setq ble (entget bhn))
                      (if (= (cdr (assoc 0 ble)) "ATTRIB")
                        (progn
                          (foreach rec lst
                            (setq nam (nth 0 rec))
                            (setq hds (nth 4 rec))
                            (if (= (substr nam 1 2) "*A")
                              (if (>= (length hds) 2)
                                (if (member hnd hds)
                                  (foreach hdl hds
                                    (if (not (equal bhn hdl))
                                      (progn
                                        (setq ent (entget hdl))
                                        (setq obj (cdr (assoc 0 ent)))
                                        (if (member obj (list "IMAGE" "SOLID" "3DFACE" "WIPEOUT"))
                                          (progn
                                            (setq fnd nam)
                                            (entdel hdl)
                                          )
                                        )
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (if (/= fnd nil)
                  (command "_.-GROUP" "_EX" fnd)
                )
              )
              (progn
                (foreach rec lst
                  (setq nam (nth 0 rec))
                  (setq hds (nth 4 rec))
                  (if (= (substr nam 1 2) "*A")
                    (if (= (length hds) 2)
                      (if (member hnd hds)
                        (foreach hdl hds
                          (if (not (equal hnd hdl))
                            (progn
                              (setq ent (entget hdl))
                              (setq obj (cdr (assoc 0 ent)))
                              (if (member obj (list "IMAGE" "SOLID" "3DFACE" "WIPEOUT"))
                                (progn
                                  (setq fnd nam)
                                  (setq msk hdl)
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (if (/= fnd nil)
                  (progn
                    (command "_.-GROUP" "_EX" fnd)
                    (entdel msk)
                  )
                )
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Generate Surrounding Geometry
; --------------------------------------------------------------------------

(defun c:AnnSurAdd ( / buffer chk cmdecho dcl_id doproc ent filint filrad
                       grpobj gset hgt highlight hnd horasp itm ll1 ll2 llc
                       lpt lrc nam num obj old p14 p14a p23 p23a p34 p34a
                       pellipse polwid pt1 pt2 pt3 pt4 pt5 pt6 pt7 pt8 rect
                       rpt sol sset tmp ufcval uflval ulc ur1 ur2 urc uscval
                       usetyp uslval verasp x y)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun annosurr_setdia ()
        (cond
          ((= usetyp 1)
            (setq nam "surr-rec")
            (set_tile "typrec" "1")
          )
          ((= usetyp 2)
            (setq nam "surr-sqr")
            (set_tile "typsqr" "1")
          )
          ((= usetyp 3)
            (setq nam "surr-rnd")
            (set_tile "typrnd" "1")
          )
          ((= usetyp 4)
            (setq nam "surr-cir")
            (set_tile "typcir" "1")
          )
          ((= usetyp 5)
            (setq nam "surr-ell")
            (set_tile "typell" "1")
          )
        )
        (setq x (dimx_tile "sample"))
        (setq y (dimy_tile "sample"))
        (start_image "sample")
        (fill_image 0 0 x y -2)
        (slide_image 0 0 x y (strcat dstpdir "toolpac(" nam ")"))
        (end_image)
        (if (= usetyp 4)
          (mode_tile "filrad" 1)
          (mode_tile "filrad" 0)
        )
        (if (/= usetyp 5)
          (progn
            (mode_tile "aspect" 1)
            (mode_tile "horasp" 1)
            (mode_tile "verasp" 1)
          )
          (progn
            (mode_tile "aspect" 0)
            (mode_tile "horasp" 0)
            (mode_tile "verasp" 0)
          )
        )
        (if (= filint "0")
          (progn
            (mode_tile "ufcval" 1)
            (mode_tile "ufcsel" 1)
            (mode_tile "uflval" 1)
            (mode_tile "uflsel" 1)
          )
          (progn
            (mode_tile "ufcval" 0)
            (mode_tile "ufcsel" 0)
            (mode_tile "uflval" 0)
            (mode_tile "uflsel" 0)
          )
        )
      )
      (defun annosurr_selopt (opt)
        (cond
          ((or (= opt 1)(= opt 3)) ; color
            (if (= opt 1)
              (setq old (dstp_str2col uscval))
              (setq old (dstp_str2col ufcval))
            )
            (setq chk (acad_colordlg old T))
            (if (/= chk nil)
              (if (= opt 1)
                (progn
                  (setq uscval (dstp_col2str chk))
                  (set_tile "uscval" uscval)
                )
                (progn
                  (setq ufcval (dstp_col2str chk))
                  (set_tile "ufcval" ufcval)
                )
              )
            )
          )
          ((or (= opt 2)(= opt 4)) ; layer
            (setq chk (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
            (if (/= chk "")
              (if (= opt 2)
                (progn
                  (setq uslval chk)
                  (set_tile "uslval" uslval)
                )
                (progn
                  (setq uflval chk)
                  (set_tile "uflval" uflval)
                )
              )
            )
          )
        )
      )
      (princ "\nDS> Select Annotation Objects to Process ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "MTEXT")(0 . "TEXT")(-4 . "OR>"))))
      (if sset
        (progn
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
               (setq sset (car chk))
               (sssetfirst sset nil)
               (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
            )
          )
          (setq usetyp (atoi (dstp_regfetch "Surround" "usetyp" "1")))
          (setq buffer (atof (dstp_regfetch "Surround" "buffer" (rtos (* 0.5 (dstp_textsize)) 2 4))))
          (setq polwid (atof (dstp_regfetch "Surround" "polwid" (rtos (getvar "PLINEWID") 2 4))))
          (setq filrad (atof (dstp_regfetch "Surround" "filrad" (rtos (getvar "FILLETRAD") 2 4))))
          (setq uscval (dstp_regfetch "Surround" "uscval" "BYLAYER"))
          (setq uslval (dstp_regfetch "Surround" "uslval" ""))
          (setq horasp (atof (dstp_regfetch "Surround" "horasp" "1.5")))
          (setq verasp (atof (dstp_regfetch "Surround" "verasp" "1.5")))
          (setq filint (dstp_regfetch "Surround" "filint" "0"))
          (setq ufcval (dstp_regfetch "Surround" "ufcval" "BYLAYER"))
          (setq uflval (dstp_regfetch "Surround" "uflval" ""))
          (setq grpobj (dstp_regfetch "Surround" "grpobj" "1"))
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog "annosurr" dcl_id)) (exit))
          (annosurr_setdia)
          (set_tile "buffer" (rtos buffer 2 4))
          (set_tile "polwid" (rtos polwid 2 4))
          (set_tile "filrad" (rtos filrad 2 4))
          (set_tile "uscval" uscval)
          (set_tile "uslval" uslval)
          (set_tile "horasp" (rtos horasp 2 4))
          (set_tile "verasp" (rtos verasp 2 4))
          (set_tile "filint" filint)
          (set_tile "ufcval" ufcval)
          (set_tile "uflval" uflval)
          (set_tile "grpobj" grpobj)
          (action_tile "typrec" "(setq usetyp 1)(annosurr_setdia)")
          (action_tile "typsqr" "(setq usetyp 2)(annosurr_setdia)")
          (action_tile "typrnd" "(setq usetyp 3)(annosurr_setdia)")
          (action_tile "typcir" "(setq usetyp 4)(annosurr_setdia)")
          (action_tile "typell" "(setq usetyp 5)(annosurr_setdia)")
          (action_tile "buffer" "(setq buffer (atof $value))")
          (action_tile "polwid" "(setq polwid (atof $value))")
          (action_tile "filrad" "(setq filrad (atof $value))")
          (action_tile "uscval" "(setq uscval $value)")
          (action_tile "uslval" "(setq uslval $value)")
          (action_tile "uscsel" "(annosurr_selopt 1)")
          (action_tile "uslsel" "(annosurr_selopt 2)")
          (action_tile "horasp" "(setq horasp (atof $value))")
          (action_tile "verasp" "(setq verasp (atof $value))")
          (action_tile "filint" "(setq filint $value)(annosurr_setdia)")
          (action_tile "ufcval" "(setq ufcval $value)")
          (action_tile "uflval" "(setq uflval $value)")
          (action_tile "ufcsel" "(annosurr_selopt 3)")
          (action_tile "uflsel" "(annosurr_selopt 4)")
          (action_tile "grpobj" "(setq grpobj $value)")
          (action_tile "accept" "(setq doproc T)(done_dialog 0)")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
          (action_tile "help" "(dstp_showhelp \"AnnSurAdd.htm\")")
          (start_dialog)
          (unload_dialog dcl_id)
          (if (= doproc T)
            (progn
              (dstp_regstore "Surround" "usetyp" (itoa usetyp))
              (dstp_regstore "Surround" "buffer" (rtos buffer 2 4))
              (dstp_regstore "Surround" "polwid" (rtos polwid 2 4))
              (dstp_regstore "Surround" "filrad" (rtos filrad 2 4))
              (dstp_regstore "Surround" "uscval" uscval)
              (dstp_regstore "Surround" "uslval" uslval)
              (dstp_regstore "Surround" "horasp" (rtos horasp 2 4))
              (dstp_regstore "Surround" "verasp" (rtos verasp 2 4))
              (dstp_regstore "Surround" "filint" filint)
              (dstp_regstore "Surround" "ufcval" ufcval)
              (dstp_regstore "Surround" "uflval" uflval)
              (dstp_regstore "Surround" "grpobj" grpobj)
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (setq num (sslength sset) itm 0)
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq obj (cdr (assoc 0 ent)))
                (cond
                  ((= obj "MTEXT")
                    (setq rect (mtxttool_rectang ent))
                  )
                  ((= obj "TEXT")
                    (setq rect (dstp_textrect ent))
                  )
                  (t nil)
                )
                (setq pt1 (car rect))
                (setq pt2 (cadr rect))
                (setq pt3 (caddr rect))
                (setq pt4 (cadddr rect))
                (setq pt5 (polar pt1 (angle pt2 pt1) buffer))
                (setq pt5 (polar pt5 (angle pt4 pt1) buffer))
                (setq pt6 (polar pt2 (angle pt1 pt2) buffer))
                (setq pt6 (polar pt6 (angle pt3 pt2) buffer))
                (setq pt7 (polar pt3 (angle pt4 pt3) buffer))
                (setq pt7 (polar pt7 (angle pt2 pt3) buffer))
                (setq pt8 (polar pt4 (angle pt3 pt4) buffer))
                (setq pt8 (polar pt8 (angle pt1 pt4) buffer))
                (setq gset (ssadd))
                (cond
                  ((= usetyp 1) ; basic rectangle
                    (dstp_savprop)
                    (if (= filint "1")
                      (progn
                        (setq sol '((0 . "SOLID")))
                        (if (/= uflval "")
                          (setq sol (append sol (list (cons 8 uflval))))
                        )
                        (setq sol (append sol (list (cons 10 pt5))))
                        (setq sol (append sol (list (cons 11 pt6))))
                        (setq sol (append sol (list (cons 12 pt8))))
                        (setq sol (append sol (list (cons 13 pt7))))
                        (if (/= ufcval "")
                          (setq sol (append sol (list (cons 62 (atoi ufcval)))))
                        )
                        (entmake sol)
                        (setq gset (ssadd (entlast) gset))
                      )
                    )
                    (if (/= uslval "")
                      (command "_.-LAYER" "_M" uslval "")
                    )
                    (if (/= uscval "")
                      (setvar "CECOLOR" uscval)
                    )
                    (setvar "PLINEWID" polwid)
                    (command "_.PLINE" pt5 pt6 pt7 pt8 "_C")
                    (setq gset (ssadd (entlast) gset))
                    (dstp_dofloat hnd)
                    (setq gset (ssadd (entlast) gset))
                    (dstp_resprop)
                  )
                  ((= usetyp 2) ; shadow squared
                    (dstp_savprop)
                    (if (= filint "1")
                      (progn
                        (setq sol '((0 . "SOLID")))
                        (if (/= uflval "")
                          (setq sol (append sol (list (cons 8 uflval))))
                        )
                        (setq sol (append sol (list (cons 10 pt5))))
                        (setq sol (append sol (list (cons 11 pt6))))
                        (setq sol (append sol (list (cons 12 pt8))))
                        (setq sol (append sol (list (cons 13 pt7))))
                        (if (/= ufcval "")
                          (setq sol (append sol (list (cons 62 (atoi ufcval)))))
                        )
                        (entmake sol)
                        (setq gset (ssadd (entlast) gset))
                      )
                    )
                    (setq ll1 pt5)
                    (setq ll2 (polar pt5 (angle pt5 pt6) polwid))
                    (setq ll2 (polar ll2 (angle pt8 pt5) (/ polwid 2.0)))
                    (setq ulc pt8)
                    (setq ur1 pt7)
                    (setq ur2 (polar ur1 (angle pt5 pt6) (/ polwid 2.0)))
                    (setq ur2 (polar ur2 (angle pt7 pt6) polwid))
                    (setq lrc (polar pt6 (angle pt5 pt6) (/ polwid 2.0)))
                    (setq lrc (polar lrc (angle pt7 pt6) (/ polwid 2.0)))
                    (if (/= uslval "")
                      (command "_.-LAYER" "_M" uslval "")
                    )
                    (if (/= uscval "")
                      (setvar "CECOLOR" uscval)
                    )
                    (command "_.PLINE" ll1 "_W" 0 0 ulc ur1 "_W" 0 polwid ur2 lrc ll2 "_W" polwid 0 "_C")
                    (setq gset (ssadd (entlast) gset))
                    (dstp_dofloat hnd)
                    (setq gset (ssadd (entlast) gset))
                    (dstp_resprop)
                  )
                  ((= usetyp 3) ; shadow rounded
                    (dstp_savprop)
                    (setq llc (polar pt5 (angle pt8 pt5) polwid))
                    (setq lrc (polar pt6 (angle pt7 pt6) polwid))
                    (setq lrc (polar lrc (angle pt5 pt6) (/ polwid 2.0)))
                    (setq urc (polar pt7 (angle pt8 pt7) (/ polwid 2.0)))
                    (if (/= uslval "")
                      (command "_.-LAYER" "_M" uslval "")
                    )
                    (if (/= uscval "")
                      (setvar "CECOLOR" uscval)
                    )
                    (command "_.PLINE" llc "_W" polwid "" lrc urc "_W" 0 "" pt8 "_C")
                    (setvar "CECOLOR" "BYLAYER")
                    (command "_.FILLET" "_R" filrad "_.FILLET" "_P" "_L")
                    (setq gset (ssadd (entlast) gset))
                    (setq tmp (entlast))
                    (if (= filint "1")
                      (progn
                        (if (/= uflval "")
                          (command "_.-LAYER" "_M" uflval "")
                        )
                        (if (/= ufcval "")
                          (setvar "CECOLOR" ufcval)
                        )
                        (command "_.HATCH" "_S" "_L" "")
                        (setq gset (ssadd (entlast) gset))
                        (setvar "CECOLOR" "BYLAYER")
                        (dstp_dofloat tmp)
                        (setq gset (ssadd (entlast) gset))
                      )
                    )
                    (dstp_dofloat hnd)
                    (setq gset (ssadd (entlast) gset))
                    (dstp_resprop)
                  )
                  ((= usetyp 4) ; circular
                    (dstp_savprop)
                    (setq lpt (polar pt5 (angle pt5 pt8) (/ (distance pt5 pt8) 2.0)))
                    (setq lpt (polar lpt (angle pt6 pt5) buffer))
                    (setq rpt (polar pt6 (angle pt6 pt7) (/ (distance pt6 pt7) 2.0)))
                    (setq rpt (polar rpt (angle pt5 pt6) buffer))
                    (if (/= uslval "")
                      (command "_.-LAYER" "_M" uslval "")
                    )
                    (if (/= uscval "")
                      (setvar "CECOLOR" uscval)
                    )
                    (command "_.PLINE" lpt "_W" polwid "" "_A" "_A" 180.0 rpt "_CL")
                    (setq gset (ssadd (entlast) gset))
                    (setq tmp (entlast))
                    (if (= filint "1")
                      (progn
                        (if (/= uflval "")
                          (command "_.-LAYER" "_M" uflval "")
                        )
                        (if (/= ufcval "")
                          (setvar "CECOLOR" ufcval)
                        )
                        (command "_.HATCH" "_S" "_L" "")
                        (setq gset (ssadd (entlast) gset))
                        (setvar "CECOLOR" "BYLAYER")
                        (dstp_dofloat tmp)
                        (setq gset (ssadd (entlast) gset))
                      )
                    )
                    (dstp_dofloat hnd)
                    (setq gset (ssadd (entlast) gset))
                    (dstp_resprop)
                  )
                  ((= usetyp 5) ; elliptical
                    (dstp_savprop)
                    (setq hgt (distance pt1 pt4))
                    (setq p14 (polar pt1 (angle pt1 pt4) (/ (distance pt1 pt4) 2.0)))
                    (setq p23 (polar pt2 (angle pt2 pt3) (/ (distance pt2 pt3) 2.0)))
                    (setq p34 (polar pt3 (angle pt3 pt4) (/ (distance pt3 pt4) 2.0)))
                    (setq p14a (polar p14 (angle pt3 pt4) (* hgt horasp)))
                    (setq p23a (polar p23 (angle pt1 pt2) (* hgt horasp)))
                    (setq p34a (polar p34 (angle pt1 pt4) (* hgt verasp)))
                    (setq pellipse (getvar "PELLIPSE"))
                    (setvar "PELLIPSE" 1)
                    (if (/= uslval "")
                      (command "_.-LAYER" "_M" uslval "")
                    )
                    (if (/= uscval "")
                      (setvar "CECOLOR" uscval)
                    )
                    (command "_.ELLIPSE" p14a p23a p34a)
                    (setvar "PELLIPSE" pellipse)
                    (command "_.PEDIT" (entlast) "_W" polwid "")
                    (setq gset (ssadd (entlast) gset))
                    (setq tmp (entlast))
                    (if (= filint "1")
                      (progn
                        (if (/= uflval "")
                          (command "_.-LAYER" "_M" uflval "")
                        )
                        (if (/= ufcval "")
                          (setvar "CECOLOR" ufcval)
                        )
                        (command "_.HATCH" "_S" "_L" "")
                        (setq gset (ssadd (entlast) gset))
                        (setvar "CECOLOR" "BYLAYER")
                        (dstp_dofloat tmp)
                        (setq gset (ssadd (entlast) gset))
                      )
                    )
                    (dstp_dofloat hnd)
                    (setq gset (ssadd (entlast) gset))
                    (dstp_resprop)
                  )
                  (t nil)
                )
                (if (= grpobj "1")
                  (progn
                    (setq highlight (getvar "HIGHLIGHT"))
                    (setvar "HIGHLIGHT" 0)
                    (command "_.-GROUP" "" "*" "" gset "")
                    (setq gset nil)
                    (setvar "HIGHLIGHT" highlight)
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
              (dstp_ucspop)
              (command "_.UNDO" "_E")
            )
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Slide Annotation Left/Right
; --------------------------------------------------------------------------

(defun c:AnnSldHor ( / ang cmdecho ent hnd ins miss obj olderr orthomode
                       osmode snapang snapbase snapmode tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun annoslide_error (s)
        (if (/= s "Function cancelled.")
          (progn
            (setvar "SNAPANG" snapang)
            (setvar "SNAPBASE" snapbase)
            (setvar "SNAPMODE" snapmode)
            (setvar "ORTHOMODE" orthomode)
            (setvar "OSMODE" osmode)
            (setvar "CMDECHO" cmdecho)
            (setq *error* olderr)
          )
        )
        (if olderr (setq *error* olderr))
        (princ)
      )
      (setq olderr *error* *error* annoslide_error)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (setq snapang (getvar "SNAPANG"))
      (setq snapbase (getvar "SNAPBASE"))
      (setq snapmode (getvar "SNAPMODE"))
      (setq orthomode (getvar "ORTHOMODE"))
      (setq osmode (getvar "OSMODE"))
      (setq miss nil)
      (while (= miss nil)
        (setq tmp (entsel "\nDS> Select Text/Mtext Object to Slide: "))
        (if (/= tmp nil)
          (progn
            (setq hnd (car tmp))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (if (or (= obj "TEXT")(= obj "MTEXT"))
              (progn
                (dstp_ucspush)
                (setq ins (cdr (assoc 10 ent)))
                (setq ang (cdr (assoc 50 ent)))
                (command "_.SNAP" "_R" "" (dstp_rtd ang))
                (setvar "SNAPMODE" 0)
                (setvar "ORTHOMODE" 1)
                (prompt "\nDS> To Point (or Enter Distance): ")
                (command "_.MOVE" hnd "" ins pause)
                (dstp_ucspop)
              )
              (princ "\nDS> Not a valid annotation object!")
            )
          )
          (setq miss T)
        )
      )
      (setvar "SNAPANG" snapang)
      (setvar "SNAPBASE" snapbase)
      (setvar "SNAPMODE" snapmode)
      (setvar "ORTHOMODE" orthomode)
      (setvar "OSMODE" osmode)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setq *error* olderr)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Establish Leroy Text Styles
; --------------------------------------------------------------------------

(defun c:AnnStyLer (/ chk cmdecho dcl_id doproc fac hgt itm scllst sizlst
                         usefnt useobl usescl usesiz usewid)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "ORTHOMODE" 0)
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (setq usefnt (dstp_regfetch "General" "leroyfnt" "ROMANS.SHX"))
      (setq usewid (dstp_regfetch "General" "leroywid" "1.00"))
      (setq useobl (dstp_regfetch "General" "leroyobl" "0"))
      (setq usesiz "")
      (cond
        ((or (= (getvar "LUNITS") 2)(= (getvar "LUNITS") 3))
          (setq scllst (list "5" "10" "20" "30" "40" "50" "60" "100" "200" "400" "500" "1000" "2000"))
        )
        ((or (= (getvar "LUNITS") 4)(= (getvar "LUNITS") 5))
          (setq scllst (list "6" "4" "3" "2" "1" "3/4" "1/2" "3/8" "1/4" "3/16" "1/8" "3/32" "1/16" "1/32"))
        )
        (t nil)
      )
      (setq sizlst (list "L40" "L50" "L60" "L80" "L100" "L120" "L140" "L175" "L200" "L240" "L290" "L350" "L425" "L500"))
      (setq dcl_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "leroysty" dcl_id)) (exit))
      (start_list "scllst")
      (mapcar 'add_list scllst)
      (end_list)
      (start_list "sizlst")
      (mapcar 'add_list sizlst)
      (end_list)
      (setq chk (itoa (fix (getvar "DIMSCALE"))))
      (if (member chk scllst)
        (progn
          (setq usescl chk)
          (set_tile "usescl" usescl)
          (set_tile "scllst" (itoa (- (length scllst)(length (member chk scllst)))))
        )
      )
      (set_tile "usefnt" usefnt)
      (set_tile "usewid" usewid)
      (set_tile "useobl" useobl)
      (action_tile "sizlst" "(setq itm (atoi $value))(setq usesiz (nth itm sizlst))")
      (action_tile "scllst" "(setq itm (atoi $value))(setq usescl (nth itm scllst))(set_tile \"usescl\" usescl)")
      (action_tile "usescl" "(setq usescl $value)")
      (action_tile "accept" "(setq doproc T)(done_dialog 0)")
      (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
      (action_tile "help" "(dstp_showhelp \"AnnLerSty.htm\")")
      (if (equal (start_dialog) 1)
        (progn)
      )
      (unload_dialog dcl_id)
      (if (= doproc T)
        (progn
          (dstp_regstore "General" "leroyfnt" usefnt)
          (dstp_regstore "General" "leroywid" usewid)
          (dstp_regstore "General" "leroyobl" useobl)
          (cond
            ((= usesiz "L40")(setq fac 0.04))
            ((= usesiz "L50")(setq fac 0.05))
            ((= usesiz "L60")(setq fac 0.06))
            ((= usesiz "L80")(setq fac 0.08))
            ((= usesiz "L100")(setq fac 0.10))
            ((= usesiz "L120")(setq fac 0.12))
            ((= usesiz "L140")(setq fac 0.14))
            ((= usesiz "L175")(setq fac 0.175))
            ((= usesiz "L200")(setq fac 0.20))
            ((= usesiz "L240")(setq fac 0.24))
            ((= usesiz "L290")(setq fac 0.29))
            ((= usesiz "L350")(setq fac 0.35))
            ((= usesiz "L425")(setq fac 0.425))
            ((= usesiz "L500")(setq fac 0.50))
          )
          (setq hgt (* fac (distof usescl)))
          (command "_.STYLE" usesiz usefnt hgt usewid useobl)
          (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
            (command "")
          )
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; ###########################################################################
;                                BLOKTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                        General Support Functions
; --------------------------------------------------------------------------

(defun dstp_blkuniform (blknam)
  (setq blktbl (vla-get-Blocks (vla-get-ActiveDocument (vlax-get-acad-object))))
  (setq blkdef (vla-item blktbl blknam))
  (eval (= (vlax-get blkdef 'BlockScaling) 1))
)

; --------------------------------------------------------------------------
;              Support Function Make Anonymous Definition
; --------------------------------------------------------------------------

(defun dstp_blksupmad (zlst zpnt / zabl zafl zdne zent znen znhd zobj ztmp)
  (entmake (list (cons 0 "BLOCK")(cons 2 "*U")(cons 70 1)(cons 10 zpnt)))
  (foreach zhnd zlst
    (setq zent (entget zhnd '("*")))
    (setq zobj (cdr (assoc 0 zent)))
    (setq zlst nil)
    (cond
      ((= zobj "INSERT")
        (setq zlst (list zent))
        (setq ztmp (assoc 66 zent))
        (if (= ztmp nil)
          (setq zafl nil)
          (progn
            (if (/= (cdr ztmp) nil)
              (setq zafl T)
            )
          )
        )
        (if (= zafl T)
          (progn
            (setq znhd zhnd)
            (setq zdne nil)
            (while (/= zdne T)
              (setq znhd (entnext znhd))
              (setq znen (entget znhd))
              (setq zlst (append zlst (list znen)))
              (if (= "SEQEND" (cdr (assoc 0 znen)))
                (setq zdne T)
              )
            )
          )
        )
        (entdel zhnd)
        (foreach zitm zlst
          (entmake zitm)
        )
      )
      ((or (= zobj "IMAGE")(= zobj "WIPEOUT"))
        (setq ztmp nil)
        (foreach zrec zent
          (if (= (car zrec) 13)
            (setq zrec (list 13 (cadr zrec) (caddr zrec)))
          )
          (if (= (car zrec) 14)
            (setq zrec (list 14 (cadr zrec) (caddr zrec)))
          )
          (setq ztmp (cons zrec ztmp))
        )
        (setq zent (reverse ztmp))
        (entdel zhnd)
        (entmake zent)
      )
      ((= zobj "HATCH")
        (setq ztmp nil)
        (foreach zrec zent
          (if (= (car zrec) 10)
            (setq zrec (list 10 (cadr zrec) (caddr zrec)))
          )
          (if (= (car zrec) 11)
            (setq zrec (list 11 (cadr zrec) (caddr zrec)))
          )
          (setq ztmp (cons zrec ztmp))
        )
        (setq zent (reverse ztmp))
        (entdel zhnd)
        (entmake zent)
      )
      ((= zobj "POLYLINE")
        (setq zlst (list zent))
        (setq znhd zhnd)
        (setq zdne nil)
        (while (/= zdne T)
          (setq znhd (entnext znhd))
          (setq znen (entget znhd))
          (setq zlst (cons znen zlst))
          (if (= "SEQEND" (cdr (assoc 0 znen)))
            (setq zdne T)
          )
        )
        (setq zlst (reverse zlst))
        (entdel zhnd)
        (foreach zitm zlst
          (entmake zitm)
        )
      )
      (t
        (entdel zhnd)
        (entmake zent)
      )
    )
    (setq zent nil)
  )
  (setq zabl (entmake '((0 . "ENDBLK"))))
)

; --------------------------------------------------------------------------
;              Support GetBlock (Select Block Current/External)
; --------------------------------------------------------------------------

(defun dstp_getblock ( / $value filnam resp tablst tabsel tab_id tmp)
  (defun getblock_dofilsel ()
    (setq tmp (dstp_getfiles "Select Drawing" "" "DWG" 0))
    (if (/= tmp nil)
      (progn
        (setq filnam tmp)
        (set_tile "filnam" filnam)
      )
    )
  )
  (setq filnam "")
  (setq tablst (dstp_bldlst "BLOCK"))
  (if (> (length tablst) 0)
    (setq tablst (acad_strlsort tablst))
  )
  (setq tab_id (load_dialog "toolpac.dcl"))
  (if (not (new_dialog "tablblk" tab_id)) (exit))
  (start_list "table")
  (mapcar 'add_list tablst)
  (end_list)
  (action_tile "table" "(setq tabsel $value)")
  (action_tile "filnam" "(setq filnam $value)")
  (action_tile "filsel" "(getblock_dofilsel)")
  (action_tile "cancel" "(done_dialog 0)")
  (if (equal (start_dialog) 1)
    (if (= filnam "")
      (setq resp (nth (atoi tabsel) tablst))
      (setq resp filnam)
    )
  )
  (unload_dialog tab_id)
  (setq tmp resp)
)

; --------------------------------------------------------------------------
;                    Support Routine Used by block inserts
; --------------------------------------------------------------------------

(defun dstp_insert (name / xsc ysc zsc rot)
  (if (= dstp_blkxsc nil)
    (progn
      (setq xsc (getreal (strcat "\n[" name "] X Scale Factor <1.0>: ")))
      (if (= xsc nil)(setq xsc 1.0))
    )
    (setq xsc dstp_blkxsc)
  )
  (if (= dstp_blkysc nil)
    (progn
      (setq ysc (getreal (strcat "\n[" name "] Y Scale Factor <" (rtos xsc 2 1) ">: ")))
      (if (= ysc nil)(setq ysc xsc))
    )
    (setq ysc dstp_blkysc)
  )
  (if (= dstp_blkzsc nil)
    (progn
      (setq zsc (getreal (strcat "\n[" name "] Z Scale Factor <1.0>: ")))
      (if (= zsc nil)(setq zsc 1.0))
    )
    (setq zsc dstp_blkzsc)
  )
  (if (= dstp_blkrot nil)
    (progn
      (setq rot (getreal (strcat "\n[" name "] Rotation Angle <0>: ")))
      (if (= rot nil)(setq rot 0.0))
    )
    (setq rot (- dstp_blkrot 360.0))
  )
  (princ (strcat "\nDS> Name:[" name "] X:[" (rtos xsc) "] Y:[" (rtos ysc) "] Z:[" (rtos zsc) "] R:[" (rtos rot) "] Insertion point: "))
  (initdia 1)
  (command "_.-INSERT" name "_X" xsc "_Y" ysc "_Z" zsc "_R" rot pause)
  (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
    (command pause)
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Align Block to Line
; --------------------------------------------------------------------------

(defun c:BlkAliLin ( / cmdecho tmp lin pt1 pt2 aol done blk old dif new)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (entsel "\nDS> Pick Alignment Line: "))
      (if (/= tmp nil)
        (progn
          (setq lin (entget (car tmp)))
          (setq pt1 (cdr (assoc 10 lin)))
          (setq pt2 (cdr (assoc 11 lin)))
          (setq aol (angle pt1 pt2))
          (setq done nil)
          (while (= done nil)
            (setq tmp (entsel "\nDS> Pick Block: "))
            (if (= tmp nil)
              (setq done T)
              (progn
                (setq blk (entget (car tmp)))
                (if (= "INSERT" (cdr (assoc 0 blk))) 
                  (progn
                    (setq old (cdr (assoc 50 blk)))
                    (if (= old 0.0)(setq old (* 2 pi)))
                    (setq dif (abs (- old aol)))
                    (if (< dif (/ pi 2))
                      (setq new aol)
                      (setq new (+ aol pi))
                    )
                    (setq blk (subst (cons 50 new)(assoc 50 blk) blk))
                    (entmod blk)
                  )
                )
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ---------------------------------------------------------------------------
;                           Block Import Information
; ---------------------------------------------------------------------------

(defun c:BlkDatImp ( / attent atthnd attlst attreq atttag attval blipmode
                         blk blkchg blkent blkfnd blkhnd blklay blkovr chk
                         cmdecho cnt ctr datlst done ent fh hdr hdrlst hfd
                         hnd hndall itm lin lookup lst new nins nme nrot num
                         nxtent nxthnd oins orot osmode pass pnt pos rot sset
                         tmp tmplst ucs upd xcd xsc ycd ysc zcd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq blipmode (getvar "BLIPMODE"))
      (setvar "BLIPMODE" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (not (equal (getvar "UCSORG") (list 0.0 0.0 0.0)))
        (progn
          (initget "Y N")
          (setq tmp (getkword "\nDS> Honor Current UCS Y/<N>: "))
          (if (/= tmp "Y")(setq ucs nil)(setq ucs T))
        )
      )
      (setq tmp (dstp_getfiles "Select Comma Separated ASCII File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "CSV;ASC;TXT" 0))
      (if (/= tmp nil)
        (progn
          (setq datlst nil)
          (setq hdrlst nil)
          (setq fh (open tmp "r"))
          (if (/= fh nil)
            (progn
              (princ "\nDS> File Open ... PreProcessing ... ")
              (setq lin (read-line fh))
              (setq lin (strcase lin))
              (setq hdrlst (dstp_pdf2lst lin dstp_csvchar))
              (if (and (= (length hdrlst) 1)(dstp_instr lin (chr 9)))
                (setq hdrlst (dstp_pdf2lst lin (chr 9)))
              )
              (setq done nil)
              (while (/= done T)
                (setq lin (read-line fh))
                (if (or (= lin nil) (= lin ""))
                  (setq done T)
                  (progn
                    (setq lin (dstp_ltrim (dstp_rtrim lin)))
                    (setq tmp (dstp_pdf2lst lin dstp_csvchar))
                    (if (and (= (length tmp) 1)(dstp_instr lin (chr 9)))
                      (setq tmp (dstp_pdf2lst lin (chr 9)))
                    )
                    (setq lst nil)
                    (foreach itm tmp
                      (if (= (substr itm 1 1) (chr 34))
                        (setq itm (substr itm 2 (- (strlen itm) 2)))
                      )
                      (setq lst (append lst (list itm)))
                    )
                    (if (< (length lst)(length hdrlst))
                      (repeat (- (length hdrlst)(length lst))
                        (setq lst (append lst (list "")))
                      )
                    )
                    (setq datlst (append datlst (list lst)))
                  )
                )
              )
              (close fh)
              (princ "Done.")
              (setq blkfnd nil)
              (setq blkovr nil)
              (foreach rec hdrlst
                (if (= rec ".BLOCKNAME")
                  (setq blkfnd T)
                )
              )
              (setq hndall nil)
              (foreach rec hdrlst
                (if (= (strcase rec) ".HANDLE")
                  (setq hndall T)
                )
              )
              (setq pass T)
              (if (= hndall nil)
                (progn
                  (initget "Y N")
                  (setq tmp (getkword "\nDS> Lookup Handle Based On Attribute Field Y/<N>: "))
                  (if (= tmp "Y")
                    (progn
                      (setq tmplst nil)
                      (foreach rec hdrlst
                        (if (/= (substr rec 1 1) ".")
                          (setq tmplst (cons rec tmplst))
                        )
                      )
                      (if (> (length tmplst) 0)
                        (progn
                          (setq lookup (dstp_tablesel "Select Lookup Attribute" (acad_strlsort tmplst) "s" ""))
                          (if (or (= lookup nil)(= lookup ""))
                            (setq hndall nil)
                            (progn
                              (setq hdrlst (cons ".HANDLE" hdrlst))
                              (setq tmp nil)
                              (foreach rec datlst
                                (setq rec (cons "" rec))
                                (setq tmp (cons rec tmp))
                              )
                              (setq datlst tmp)
                              (setq tmp (member lookup hdrlst))
                              (setq pos (- (length hdrlst) (length tmp)))
                              (setq sset (ssget "_X" (list (cons 0 "INSERT") (cons 66 1))))
                              (if sset
                                (progn
                                  (dstp_prompt "DS> Attempting to look up handles ... ")
                                  (setq num (sslength sset) itm 0)
                                  (princ "\nDS>")
                                  (while (< itm num)
                                    (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
                                    (setq blkhnd (ssname sset itm))
                                    (setq blkent (entget blkhnd))
                                    (setq blklay (cdr (assoc 8 blkent)))
                                    (setq blkchg nil)
                                    (setq atthnd blkhnd)
                                    (setq attent blkent)
                                    (while (/= "SEQEND" (cdr (assoc 0 attent)))
                                      (setq atthnd (entnext atthnd))
                                      (setq attent (entget atthnd))
                                      (if (= (cdr (assoc 0 attent)) "ATTRIB")
                                        (progn
                                          (setq atttag (strcase (cdr (assoc 2 attent))))
                                          (setq attval (strcase (cdr (assoc 1 attent))))
                                          (if (= atttag lookup)
                                            (foreach rec datlst
                                              (if (= (car rec) "")
                                                (if (= (strcase (nth pos rec)) (strcase attval))
                                                  (progn
                                                    (setq new nil)
                                                    (setq new (cons (cdr (assoc 5 blkent)) new))
                                                    (setq cnt 0)
                                                    (foreach itm rec
                                                      (if (> cnt 0)
                                                        (setq new (cons itm new))
                                                      )
                                                      (setq cnt (1+ cnt))
                                                    )
                                                    (setq new (reverse new))
                                                    (setq datlst (subst new rec datlst))
                                                  )
                                                )
                                              )
                                            )
                                          )
                                        )
                                      )
                                    )
                                    (setq itm (1+ itm))
                                  )
                                  (princ ", Done.")
                                  (setq hndall T)
                                  (setq blkovr "AutoCAD Point")
                                )
                              )
                            )
                          )
                        )
                        (alert "No Attribute Fields\nDesignated in Data File!")
                      )
                    )
                  )
                  (if (= blkfnd nil)
                    (if (= blkovr nil)
                      (progn
                        (setq blkovr (dstp_tablesel "Select Block Definition" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
                        (if (or (= blkovr nil)(= blkovr ""))
                          (setq pass nil)
                        )
                      )
                    )
                  )
                )
              )
              (if (= pass T)
                (progn
                  (setq upd nil)
                  (setq hfd nil)
                  (setq ctr 0)
                  (foreach rec hdrlst
                    (if (= rec ".HANDLE")
                      (setq hfd ctr)
                    )
                    (setq ctr (1+ ctr))
                  )
                  (princ "\nDS>")
                  (setq itm 0)
                  (setq ent nil)
                  (setq num (length datlst))
                  (foreach rec datlst
                    (princ (strcat "\rDS> Processing Record " (itoa (1+ itm)) " of " (itoa num)))
                    (setq upd nil)
                    (if (/= hfd nil)
                      (progn
                        (setq chk (nth hfd rec))
                        (if (dstp_instr chk "'")
                          (setq chk (substr chk 2 (- (strlen chk) 1)))
                        )
                        (setq hnd (handent chk))
                        (if (/= hnd nil)
                          (progn
                            (setq ent (entget hnd))
                            (if (/= ent nil)
                              (setq upd T)
                            )
                          )
                        )
                      )
                    )
                    (if (/= upd T)
                      (progn
                        (setq ctr 0)
                        (setq blk nil)
                        (setq xsc "1")
                        (setq ysc "1")
                        (setq xcd "0")
                        (setq ycd "0")
                        (setq zcd "0")
                        (foreach fld rec
                          (setq hdr (nth ctr hdrlst))
                          (if (= hdr ".BLOCKNAME")(setq blk fld))
                          (if (= hdr ".XSCALE")(setq xsc fld))
                          (if (= hdr ".YSCALE")(setq ysc fld))
                          (if (= hdr ".INSPTX")(setq xcd fld))
                          (if (= hdr ".INSPTY")(setq ycd fld))
                          (if (= hdr ".INSPTZ")(setq zcd fld))
                          (setq ctr (1+ ctr))
                        )
                        (if (and (= blkfnd nil)(/= blkovr nil))
                          (setq blk blkovr)
                        )
                        (setq pnt (list (atof xcd) (atof ycd) (atof zcd)))
                        (if (= ucs T)
                          (setq pnt (trans pnt 1 0))
                        )
                        (if (/= blk nil)
                          (progn
                            (if (= blk "AutoCAD Point")
                              (command "_.POINT" pnt)
                              (progn
                                (setq attreq (getvar "ATTREQ"))
                                (setvar "ATTREQ" 0)
                                (command "_.INSERT" blk pnt xsc ysc "0")
                                (setvar "ATTREQ" attreq)
                                (setq hnd (entlast))
                                (setq ent (entget hnd))
                                (if (/= ent nil)
                                  (setq upd T)
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    (if (and (= upd T)(/= ent nil))
                      (progn
                        (setq oins (cdr (assoc 10 ent)))
                        (setq orot (dstp_rtd (cdr (assoc 50 ent))))
                        (setq nins oins)
                        (setq nrot orot)
                        (setq attlst nil)
                        (if (/= (cdr (assoc 66 ent)) nil)
                          (progn
                            (if (= (boole 1 (cdr (assoc 66 ent)) 1) 1)
                              (progn
                                (setq nxthnd hnd)
                                (setq nxtent ent)
                                (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                                  (setq nxthnd (entnext nxthnd))
                                  (setq nxtent (entget nxthnd))
                                  (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                                    (setq attlst (append attlst (list nxtent)))
                                  )
                                )
                              )
                            )
                          )
                        )
                        (setq ctr 0)
                        (setq rot "0")
                        (foreach fld rec
                          (setq hdr (nth ctr hdrlst))
                          (if (/= hdr nil)
                            (progn
                              (cond
                                ((= hdr ".HANDLE")
                                  (setq tmp nil)
                                )
                                ((= hdr ".BLOCKNAME")
                                  (setq tmp nil)
                                )
                                ((= hdr ".INSPTX")
                                  (setq nins (list (atof fld) (nth 1 nins) (nth 2 nins)))
                                )
                                ((= hdr ".INSPTY")
                                  (setq nins (list (nth 0 nins) (atof fld) (nth 2 nins)))
                                )
                                ((= hdr ".INSPTZ")
                                  (setq nins (list (nth 0 nins) (nth 1 nins) (atof fld)))
                                )
                                ((= hdr ".XSCALE")
                                  (setq ent (subst (cons 41 (atof fld))(assoc 41 ent) ent))
                                )
                                ((= hdr ".YSCALE")
                                  (setq ent (subst (cons 42 (atof fld))(assoc 42 ent) ent))
                                )
                                ((= hdr ".ZSCALE")
                                  (setq ent (subst (cons 43 (atof fld))(assoc 43 ent) ent))
                                )
                                ((= hdr ".ROTATION")
                                  (setq nrot fld)
                                )
                                ((= hdr ".COLOR")
                                  (if (/= (assoc 62 ent) nil)
                                    (setq ent (subst (cons 62 (dstp_str2col fld))(assoc 62 ent) ent))
                                    (setq ent (append ent (list (cons 62 (dstp_str2col fld)))))
                                  )
                                )
                                ((= hdr ".LAYER")
                                  (setq ent (subst (cons 8 fld)(assoc 8 ent) ent))
                                )
                                ((= hdr ".LINETYPE")
                                  (setq ent (subst (cons 6 fld)(assoc 6 ent) ent))
                                )
                                ((= hdr ".THICKNESS")
                                  (setq ent (subst (cons 39 fld)(assoc 39 ent) ent))
                                )
                                (t
                                  (if (/= attlst nil)
                                    (progn
                                      (foreach att attlst
                                        (setq nme (cdr (assoc 2 att)))
                                        (if (= (strcase nme)(strcase hdr))
                                          (progn
                                            (setq att (subst (cons 1 fld)(assoc 1 att) att))
                                            (entmod att)
                                          )
                                        )
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                          (setq ctr (1+ ctr))
                        )
                        (entmod ent)
                        (if (= ucs T)
                          (setq nins (trans nins 1 0))
                        )
                        (command "_.MOVE" hnd "" oins nins)
                        (command "_.ROTATE" hnd "" nins "_R" orot nrot)
                      )
                    )
                    (setq itm (1+ itm))
                  )
                  (princ ", Done.")
                )
              )
            )
            (alert "ERROR: Unable to open file, check other\napplications that may have this file open.")
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "BLIPMODE" blipmode)
      (setvar "CMDECHO" cmdecho)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Group Rotate Block @ Insert
; --------------------------------------------------------------------------

(defun c:BlkRotIns ( / cmdecho da ent er hnd itm num obj opt osmode pt ra
                         sset tmp vt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq sset (ssget '((0 . "INSERT"))))
      (setq num (sslength sset) itm 0)
      (if sset 
        (progn
          (initget "A R H T")
          (setq opt (getkword "\nDS> Horizontal/Twisthorz/Relative/<Absolute>: "))
          (if (= opt nil)(setq opt "A"))
          (if (= opt "A")
            (progn
              (setq tmp (strcase (getstring "\nDS> Pick/Rotation Angle <0.0>: ")))
              (if (= tmp "P")
                (progn
                  (setq tmp (entsel "\nDS> Select Block with Desired Rotation: "))
                  (if (/= tmp nil)
                    (progn
                      (setq hnd (car tmp))
                      (setq ent (entget hnd))
                      (setq obj (cdr (assoc 0 ent)))
                      (if (= obj "INSERT")
                        (setq ra (* (/ (cdr (assoc 50 ent)) pi) 180.0))
                        (progn
                          (princ "\nDS> Selected Object was not an INSERT, using 0.0")
                          (setq ra 0.0)
                        )
                      )
                    )
                  )
                )
                (if (= tmp "")
                  (setq ra 0.0)
                  (setq ra (atof tmp))
                )
              )
            )
          )
          (if (= opt "R")
            (progn
              (setq ra (getreal "DS> Relative Rotation Angle <0.0>: "))
              (if (= ra nil)(setq ra 0.0))
            )
          )
          (setq vt (dstp_rtd (getvar "VIEWTWIST")))
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (if (= "INSERT" (cdr (assoc 0 ent))) 
              (progn
                (setq pt (cdr (assoc 10 ent)))
                (setq er (cdr (assoc 50 ent)))
                (cond
                  ((= opt "A")
                    (setq er (dstp_rtd er))
                    (setq da (- ra er))
                    (command "_.ROTATE" hnd "" pt da)
                  )
                  ((= opt "R")
                    (command "_.ROTATE" hnd "" pt ra)
                  )
                  ((= opt "H")
                    (setq er (dstp_rtd er))
                    (setq da (- 0.0 er))
                    (command "_.ROTATE" hnd "" pt da)
                  )
                  ((= opt "T")
                    (setq er (dstp_rtd er))
                    (setq da (- 0.0 er))
                    (setq da (- da vt))
                    (command "_.ROTATE" hnd "" pt da)
                  )
                  (t nil)
                )
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
        )
      )
      (command "_.SELECT" sset "")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           AutoWblock Repeater
; --------------------------------------------------------------------------

(defun c:BlkAutWbl ( / chkfil cmddia cmdecho done ent fndnam fulnam hnd
                         insbas itm lst num obj ovrwrt path retgeo sset
                         tmp usetxt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "UNDO" "G")
      (dstp_ucspush)
      (setq path (dstp_getfolder "Select Destination Directory" nil))
      (if (/= path nil)
        (progn
          (if (> (strlen path) 0)
            (progn
              (if (= (substr path (strlen path) 1) "\\")
                (setq path (substr path 1 (1- (strlen path))))
              ) 
              (setq path (strcat path "\\"))
            )
          )
          (initget "N Y")
          (setq tmp (getkword "\nDS> Use text as block name if selected <Y>/N: "))
          (if (/= tmp "N")(setq usetxt "Y")(setq usetxt "N"))
          (initget "N Y")
          (setq tmp (getkword "\nDS> Retain selected geometry Y/<N>: "))
          (if (/= tmp "Y")(setq retgeo "N")(setq retgeo "Y"))
          (initget "N Y")
          (setq tmp (getkword "\nDS> Overwrite existing files <Y>/N: "))
          (if (/= tmp "N")(setq ovrwrt "Y")(setq ovrwrt "N"))
          (setq done nil)
          (while (/= done T)
            (princ "\nDS> Select Objects to Wblock ...")
            (setq sset (ssget))
            (if (/= sset nil)
              (progn
                (setq insbas (getpoint "\nDS> Insertion base point <0,0,0>: "))
                (if (= insbas nil)
                  (setq insbas (list 0.0 0.0 0.0))
                )
                (setq fndnam "")
                (if (= usetxt "Y")
                  (progn
                    (setq lst nil)
                    (setq num (sslength sset) itm 0)
                    (while (< itm num)
                      (setq hnd (ssname sset itm))
                      (setq ent (entget hnd))
                      (setq obj (cdr (assoc 0 ent)))
                      (if (or (= obj "TEXT")(= obj "MTEXT"))
                        (setq lst (append lst (list (cdr (assoc 1 ent)))))
                      )
                      (setq itm (1+ itm))
                    )
                    (if (= (length lst) 1)
                      (setq fndnam (nth 0 lst))
                      (progn
                        (setq tmp (dstp_tablesel "Select Text for Name" (acad_strlsort lst) "s" ""))
                        (if (/= tmp nil)
                          (setq fndnam tmp)
                        )
                      )
                    )
                  )
                )
                (if (= fndnam "")
                  (progn
                    (setq tmp (getstring "\nDS> Specify block name: "))
                    (if (/= tmp "")
                      (setq fndnam tmp)
                    )
                  )
                )
                (if (/= fndnam "")
                  (progn
                    (setq fulnam (strcat path fndnam ".DWG"))
                    (setq chkfil (findfile fulnam))
                    (if (member "ade.arx" (arx))
                      (progn
                        (setq cmddia (getvar "CMDDIA"))
                        (setvar "CMDDIA" 0)
                        (if (= chkfil nil)
                          (command "_.WBLOCK" fulnam "" insbas sset "" "_N")
                          (if (= ovrwrt "Y")
                            (command "_.WBLOCK" fulnam "_Y" "" insbas sset "" "_N")
                          )
                        )
                        (setvar "CMDDIA" cmddia)
                      )
                      (if (= chkfil nil)
                        (command "_.WBLOCK" fulnam "" insbas sset "")
                        (if (= ovrwrt "Y")
                          (command "_.WBLOCK" fulnam "_Y" "" insbas sset "")
                        )
                      )
                    )
                    (if (= retgeo "Y")
                      (command "_.OOPS")
                    )
                  )
                )
              )
              (setq done T)
            )
          )
        )
      )
      (dstp_ucspop)
      (command "UNDO" "E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;               Insert block rotated with horz attributes
; --------------------------------------------------------------------------

(defun c:BlkInsRot ( / attdia cmdecho ent ins pnt rot use)
	  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setq attdia (getvar "ATTDIA"))
      (setvar "ATTDIA" 1)
      (initdia 1)
      (command "_.-INSERT")
      (setvar "CMDECHO" 1)
      (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
        (command pause)
      )
      (setq ins (entlast))
      (setq ent (entget ins))
      (setq pnt (cdr (assoc 10 ent)))
      (setq rot (cdr (assoc 50 ent)))
      (setq use (* (/ rot pi) 180.0))
      (setq use (- 0.0 use))
      (setvar "CMDECHO" 0)
      (command "_.ROTATE" ins "" pnt use)
      (setq ent (subst (cons 50 rot)(assoc 50 ent) ent))
      (entmod ent)
      (setvar "ATTDIA" attdia)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Trim or Extend to Block Objects
; --------------------------------------------------------------------------

(defun c:BlkEdgExt ()(dstp_blktrmext 1))
(defun c:BlkEdgTrm ()(dstp_blktrmext 2))

(defun dstp_blktrmext (opt / blk chk cmdecho done ent g10 g41 g50 hnd pik pnt
                           sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq done nil)
      (setq sset (ssadd))
      (while (/= done T)
        (setq pik (nentsel "\nDS> Pick Block Edge Object: "))
        (if (/= pik nil)
          (progn
            (setq hnd (car pik))
            (setq pnt (cadr pik))
            (setq tmp (ssget pnt))
            (setq blk (entget (ssname tmp 0)))
            (if (= (cdr (assoc 0 blk)) "INSERT")
              (progn
                (setq ent (entget hnd))
                (setq chk (entmake ent))
                (setq g10 (cdr (assoc 10 blk)))
                (setq g41 (cdr (assoc 41 blk)))
                (setq g50 (cdr (assoc 50 blk)))
                (if (not (equal g41 1.0))
                  (command "_.SCALE" (entlast) "" "0,0,0" g41)
                )
                (if (not (equal g50 0.0))
                  (command "_.ROTATE" (entlast) "" "0,0,0" (dstp_rtd g50))
                )
                (if (not (equal (distance g10 (list 0.0 0.0 0.0)) 0.0))
                  (command "_.MOVE" (entlast) "" "0,0,0" g10)
                )
                (setq sset (ssadd (entlast) sset))
                (redraw (entlast) 3)
              )
              (setq sset (ssadd hnd sset))
            )
          )
          (setq done T)
        )
      )
      (if (> (sslength sset) 0)
        (progn
          (setvar "CMDECHO" 1)
          (if (= opt 1)
            (command "_.EXTEND" sset "")
            (command "_.TRIM" sset "")
          )
          (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
            (command pause)
          )
          (setvar "CMDECHO" 0)
          (command "_.ERASE" sset "")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          Block Masking Options
; --------------------------------------------------------------------------

(defun c:BlkBndMsk (/ axo blkhnd box chk cmdecho conare conbox disx disy elv
                       ent fac fndare fndobj g60 grp gset highlight hnd img
                       itm llc maxpt minpt mset mskhnd mth num o1 o2 o3 o4 p7
                       objare objcnt of ofsfac orgmrk osmode p1 p2 p3 p4 p5 p6
                       p8 pass pp ptlst rec scl siz sol sset tmp urc val wid)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Select Blocks to Process ...")
      (setq sset (ssget '((0 . "INSERT"))))
      (if sset
        (progn
          (setvar "SORTENTS" 127)
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
              (setq sset (car chk))
              (sssetfirst nil sset)
              (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Object(s) Removed"))
            )
          )
          (if (= (dstp_wipeoutchk) T)
            (progn
              (initget "2 3 T W M")
              (setq tmp (getkword "\nDS> Mask Method 2dsolid/3dface/Trim/Wipeout/<MaskImg>: "))
              (if (= tmp nil)(setq mth "M")(setq mth tmp))
            )
            (progn
              (initget "2 3 T M")
              (setq tmp (getkword "\nDS> Mask Method 2dsolid/3dface/Trim/<MaskImg>: "))
              (if (= tmp nil)(setq mth "M")(setq mth tmp))
            )
          )
          (if (/= mth "T")
            (progn
              (initget "Y N")
              (setq tmp (getkword "\nDS> Group Symbol with Mask <Y>/N: "))
              (if (= tmp nil)(setq grp "Y")(setq grp tmp))
            )
          )
          (if (or (= mth "M")(= mth "W"))
            (progn
              (initget "B S")
              (setq tmp (getkword "\nDS> Bounding Box or Shrinkwrap B/<S>: "))
              (if (= tmp nil)(setq box "S")(setq box tmp))
            )
          )
          (if (= mth "T")
            (progn
              (setq ofsfac (atof (dstp_regfetch "BlkBndMsk" "ofsfac" "0.05")))
              (setq tmp (getreal (strcat "\nDS> Trim Offset Factor <" (rtos ofsfac 2 4) ">: ")))
              (if (/= tmp nil)(setq ofsfac tmp))
              (dstp_regstore "BlkBndMsk" "ofsfac" (rtos ofsfac 2 4))
            )
          )
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq num (sslength sset) itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (if (/= mth "W")
              (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            )
            (setq blkhnd (ssname sset itm))
            (entupd blkhnd)
            (setq axo (vlax-ename->vla-object blkhnd))
            (setq chk (vl-catch-all-apply 'vla-getboundingbox (list axo 'minpt 'maxpt)))
            (if (not (vl-catch-all-error-p chk))
              (progn
                (setq minpt (dstp_2dpoint (vlax-safearray->list minpt)))
                (setq maxpt (dstp_2dpoint (vlax-safearray->list maxpt)))
                (if (and (not (equal (car minpt) (car maxpt) 0.0001))
                         (not (equal (cadr minpt) (cadr maxpt) 0.0001)))
                  (progn
                    (setq pass T)
                    (setq p1 (list (car minpt)(cadr minpt)))
                    (setq p2 (list (car maxpt)(cadr minpt)))
                    (setq p3 (list (car maxpt)(cadr maxpt)))
                    (setq p4 (list (car minpt)(cadr maxpt)))
                    (if (= box "S")
                      (progn
                        (setq of (* (dstp_textsize) 0.25))  ;0.05
                        (setq o1 (polar p1 (+ pi (/ pi 4.0)) of))
                        (setq o2 (polar p2 (- (* pi 2) (/ pi 4.0)) of))
                        (setq o3 (polar p3 (/ pi 4.0) of))
                        (setq o4 (polar p4 (- pi (/ pi 4.0)) of))
                        (setq pp (polar o1 (/ pi 4.0) (/ of 2.0))) ;0.025
                        (command "_.PLINE" o1 o2 o3 o4 "_C")
                        (command "_.AREA" o1 o2 o3 o4 "")
                        (setq conare (getvar "AREA"))
                        (setq conbox (entlast))
                        (setq fndare 0.0)
                        (setq orgmrk (entlast))
                        (command "_-BOUNDARY" "_A" "_I" "_Y" "_B" "_N" blkhnd conbox "" "" pp "")
                        (setq gset (ssadd))
                        (setq objcnt 0)
                        (setq fndobj nil)
                        (while (/= orgmrk nil)
                          (setq orgmrk (entnext orgmrk))
                          (if (/= orgmrk nil)
                            (progn
                              (setq objcnt (1+ objcnt))
                              (command "_.AREA" "_O" orgmrk)
                              (setq objare (getvar "AREA"))
                              (if (> objare 0.0)
                                (if (> objare fndare)
                                  (if (not (equal objare conare 0.0001))
                                    (setq fndare objare fndobj orgmrk)
                                  )
                                )
                              )
                              (setq gset (ssadd orgmrk gset))
                            )
                          )
                        )
                        (if (> objcnt 1)
                          (if (/= fndobj nil)
                            (progn
                              (setq ptlst (dstp_obj2lst fndobj))
                              (command "_.AREA")
                              (foreach pnt ptlst
                                (command pnt)
                              )
                              (command "")
                              (if (equal (getvar "AREA") 0.0)
                                (setq pass nil)
                              )
                            )
                          )
                          (setq pass nil)
                        )
                        (command "_.ERASE" conbox "")
                        (command "_.ERASE" gset "")
                      )
                    )
                    (cond
                      ((= mth "T") ; trim
                        (setq p5 (polar p1 (angle p1 p3) ofsfac))
                        (setq p6 (polar p2 (angle p2 p4) ofsfac))
                        (setq p7 (polar p3 (angle p3 p1) ofsfac))
                        (setq p8 (polar p4 (angle p4 p2) ofsfac))
                        (dstp_ucspush)
                        (command "_.PLINE" p1 p2 p3 p4 "_C")
                        (setq rec (entlast))
                        (command "_.TRIM" rec "" "_F" p5 p6 p7 p8 p5 "" "")
                        (entdel rec)
                        (command "_.ERASE" "_W" p1 p3 "_R" blkhnd "")
                        (dstp_ucspop)
                      )
                      ((= mth "3") ; 3dface
                        (setq elv (getvar "ELEVATION"))
                        (setq val (+ elv 0.015))
                        (setq fac '((0 . "3DFACE")))
                        (setq fac (append fac (list (list 10 (car p1) (cadr p1) val))))
                        (setq fac (append fac (list (list 11 (car p2) (cadr p2) val))))
                        (setq fac (append fac (list (list 12 (car p3) (cadr p3) val))))
                        (setq fac (append fac (list (list 13 (car p4) (cadr p4) val))))
                        (setq fac (append fac (list (cons 70 15))))
                        (entmake fac)
                        (setq mskhnd (entlast))
                        (if (= grp "Y")
                          (progn
                            (dstp_dofloat blkhnd)
                            (dstp_setelv (entlast)(+ val 0.001))
                            (setq mset (ssadd))
                            (setq mset (ssadd mskhnd mset))
                            (setq mset (ssadd (entlast) mset))
                            (setq highlight (getvar "HIGHLIGHT"))
                            (setvar "HIGHLIGHT" 0)
                            (command "_.-GROUP" "" "*" "" mset "")
                            (setvar "HIGHLIGHT" highlight)
                            (setq mset nil)
                          )
                        )
                        (if (= (getvar "HIDEPRECISION") 0)
                          (setvar "HIDEPRECISION" 1)
                        )
                      )
                      ((= mth "2") ; solid
                        (setq sol '((0 . "SOLID")))
                        (setq sol (append sol (list (list 10 (car p1) (cadr p1) 0.0))))
                        (setq sol (append sol (list (list 11 (car p2) (cadr p2) 0.0))))
                        (setq sol (append sol (list (list 12 (car p4) (cadr p4) 0.0))))
                        (setq sol (append sol (list (list 13 (car p3) (cadr p3) 0.0))))
                        (setq sol (append sol (list (cons 62 254))))
                        (entmake sol)
                        (setq mskhnd (entlast))
                        (if (= grp "Y")
                          (progn
                            (dstp_dofloat blkhnd)
                            (setq mset (ssadd))
                            (setq mset (ssadd mskhnd mset))
                            (setq mset (ssadd (entlast) mset))
                            (setq highlight (getvar "HIGHLIGHT"))
                            (setvar "HIGHLIGHT" 0)
                            (command "_.-GROUP" "" "*" "" mset "")
                            (setvar "HIGHLIGHT" highlight)
                            (setq mset nil)
                          )
                        )
                      )
                      ((= mth "W") ; wipeout
                        (if (= pass T)
                          (progn
                            (dstp_ucspush)
                            (if (= box "S")
                              (progn
                                (command "_.WIPEOUT")
                                (foreach pnt ptlst
                                  (command pnt)
                                )
                                (command "")
                              )
                              (command "_.WIPEOUT" p1 p2 p3 p4 "")
                            )
                            (dstp_ucspop)
                            (setq mskhnd (entlast))
                            (if (= grp "Y")
                              (progn
                                (dstp_dofloat blkhnd)
                                (setq mset (ssadd))
                                (setq mset (ssadd mskhnd mset))
                                (setq mset (ssadd (entlast) mset))
                                (setq highlight (getvar "HIGHLIGHT"))
                                (setvar "HIGHLIGHT" 0)
                                (command "_.-GROUP" "" "*" "" mset "")
                                (setvar "HIGHLIGHT" highlight)
                                (setq mset nil)
                              )
                            )
                          )
                        )
                      )
                      ((= mth "M") ; maskimg
                        (if (= pass T)
                          (progn
                            (setq llc p1 urc p3)
                            (dstp_ucspush)
                            (setq disx (- (car urc)(car llc)))
                            (setq disy (- (cadr urc)(cadr llc)))
                            (if (> disx disy)
                              (setq siz disx)
                              (setq siz disy)
                            )
                            (setq img (findfile dstp_wipeimage))
                            (command "_.IMAGE" "_A" img llc 0.01 "0")
                            (setq hnd (entlast))
                            (setq ent (entget hnd))
                            (setq wid (car (cdr (assoc 11 ent))))
                            (setq g60 (assoc 60 ent))
                            (if (/= g60 nil)
                              (setq ent (subst (cons 60 1)(assoc 60 ent) ent))
                              (setq ent (append ent (list (cons 60 1))))
                            )
                            (entmod ent)
                            (setq scl (/ siz wid))
                            (command "_.SCALE" hnd "" llc scl)
                            (if (= box "S")
                              (progn
                                (command "_.IMAGECLIP" hnd "")
                                (if (/= (cdr (assoc 91 ent)) nil)
                                  (if (> (cdr (assoc 91 ent)) 2)
                                    (command "_Y")
                                  )
                                )
                                (command "_P")
                                (foreach pnt ptlst
                                  (command pnt)
                                )
                                (command "")
                              )
                              (progn
                                (command "_.IMAGECLIP" hnd "")
                                (if (/= (cdr (assoc 91 ent)) nil)
                                  (if (> (cdr (assoc 91 ent)) 2)
                                    (command "_Y")
                                  )
                                )
                                (command "_R" llc urc)
                              )
                            )
                            (setq mskhnd (entlast))
                            (setq ent (entget mskhnd))
                            (setq ent (subst (cons 60 0)(assoc 60 ent) ent))
                            (entmod ent)
                            (if (= grp "Y")
                              (progn
                                (dstp_dofloat blkhnd)
                                (setq mset (ssadd))
                                (setq mset (ssadd mskhnd mset))
                                (setq mset (ssadd (entlast) mset))
                                (setq highlight (getvar "HIGHLIGHT"))
                                (setvar "HIGHLIGHT" 0)
                                (command "_.-GROUP" "" "*" "" mset "")
                                (setvar "HIGHLIGHT" highlight)
                                (setq mset nil)
                              )
                            )
                            (dstp_ucspop)
                          )
                        )
                      )
                      (t nil)
                    )
                  )
                )
              )
            )
            (setq itm (1+ itm))
          )
          (if (/= mth "W")
            (princ ", Done.")
          )
          (dstp_ucspop)
          (if (= mth "M")
            (princ "\nDS> Optionally turn off IMAGEFRAME, followed by REGEN")
          )
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          Convert Inserts to Xref
; --------------------------------------------------------------------------

(defun c:BlkCnvXrf ( / chk clayer cmddia cmdecho ctab def ent fnd hnd ins
                         itm lay lst num osmode pass rec rot spc sset tmp
                         wtf xrf xsc ysc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Notice: Conversion of Inserts to Xrefs Removes Attributes!")
      (initget "Y N")
      (setq chk (getkword "\nDS> Write Block Definition to File <Y>/N: "))
      (if (/= chk "N")(setq wtf T)(setq wtf nil))
      (initget "D")
      (setq tmp (entsel "\nDS> Dialog/<Pick Block Type to Change>: "))
      (if (= tmp "D")
        (setq fnd (dstp_tablesel "Select Block" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
        (setq fnd (cdr (assoc 2 (entget (car tmp)))))
      )
      (setq pass T)
      (if (= wtf T)
        (progn
          (setq def (strcat (getvar "DWGPREFIX") fnd ".dwg"))
          (setq tmp (dstp_getfiles "Select Drawing to Create" def "DWG" 1))
          (if (/= tmp nil)
            (progn
              (setq xrf tmp)
              (setvar "EXPERT" 5)
              (setvar "FILEDIA" 0)
              (if (member "ade.arx" (arx))
                (progn
                  (setq cmddia (getvar "CMDDIA"))
                  (setvar "CMDDIA" 0)
                  (if (findfile xrf)
                    (command "_.WBLOCK" xrf  "_Y" fnd "_N")
                    (command "_.WBLOCK" xrf fnd "_N")
                  )
                  (setvar "CMDDIA" cmddia)
                )
                (if (findfile xrf)
                  (command "_.WBLOCK" xrf  "_Y" fnd)
                  (command "_.WBLOCK" xrf fnd)
                )
              )
              (setvar "FILEDIA" 1)
              (setvar "EXPERT" 0)
            )
            (setq pass nil)
          )
        )
        (progn
          (setq tmp (dstp_getfiles "Select Xref Replacement Drawing" "" "DWG" 0))
          (if (/= tmp nil)
            (setq xrf tmp)
            (setq pass nil)
          )
        )
      )
      (if (= pass T)
        (progn
          (setq sset (ssget "_X" (list (cons 0 "INSERT") (cons 2 fnd))))
          (if sset
            (progn
              (setq lst nil)
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Evaluating Insert " (itoa (1+ itm)) " of " (itoa num)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq lay (cdr (assoc 8 ent)))
                (setq ins (cdr (assoc 10 ent)))
                (setq xsc (cdr (assoc 41 ent)))
                (setq ysc (cdr (assoc 42 ent)))
                (setq rot (cdr (assoc 50 ent)))
                (setq spc (cdr (assoc 410 ent)))
                (setq lst (cons (list lay ins xsc ysc rot spc hnd) lst))
                (setq itm (1+ itm))
              )
              (setq lst (reverse lst))
              (princ ", Done.\n")
              (setq osmode (getvar "OSMODE"))
              (setvar "OSMODE" 0)
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (setq clayer (getvar "CLAYER"))
              (setq ctab (getvar "CTAB"))
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (foreach rec lst
                (setvar "CTAB" (nth 5 rec))
                (entdel (nth 6 rec))
              )
              (command "_.PURGE" "_B" fnd "_N")
              (princ "\nDS> Recreating Inserts as Xrefs ...")
              (setq num (length lst) itm 0)
              (while (< itm num)
                (setq rec (nth itm lst))
                (setvar "CLAYER" (nth 0 rec))
                (setvar "CTAB" (nth 5 rec))
                (command "_.XREF" "_O" xrf (nth 1 rec) (nth 2 rec) (nth 3 rec) (nth 4 rec))
                (setq itm (1+ itm))
              )
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CTAB" ctab)
              (setvar "CLAYER" clayer)
              (setvar "CMDECHO" cmdecho)
              (setvar "OSMODE" osmode)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;              Consolidate Multiple Inserts (At Same Point)
; --------------------------------------------------------------------------

(defun c:BlkConMul ( / attlst attnme attreq blk chk clayer cmdecho crdlst
                        ctr done ent fuz hnd hndlst itm la nbn num nxtent
                        nxthnd orglay orgnme orgpnt orgrot orgval osmode pos
                        pt rec ro sset tmp tot xs ys)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I" '((0 . "INSERT") (66 . 1))))
      (if (= sset nil)
        (progn
          (princ "\nDS> Select Inserts to Consolidate ...")
          (setq sset (ssget '((0 . "INSERT") (66 . 1))))
        )
      )
      (if sset 
        (progn
          (setq tmp (getdist "\nDS> Fuzz Factor Distance <0.00000001>: "))
          (if (= tmp nil)
            (setq fuz 0.00000001)
            (setq fuz tmp)
          )
          (setq nbn (dstp_tablesel "Replacement Block" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
          (if (/= nbn nil)
            (progn
              (setq chk (dstp_attdef nbn))
              (if (/= chk nil)
                (progn
                  (dstp_prompt "DS> Preparing Working Lists ... ")
                  (setq hndlst nil)
                  (setq crdlst nil)
                  (setq num (sslength sset) itm 0)
                  (while (< itm num)
                    (setq hnd (ssname sset itm))
                    (setq ent (entget hnd))
                    (setq pos (cdr (assoc 10 ent)))
                    (setq hndlst (cons (list pos hnd) hndlst))
                    (if (not (member pos crdlst))
                      (setq crdlst (cons pos crdlst))
                    )
                    (setq itm (1+ itm))
                  )
                  (setq sset nil)
                  (princ "Done.")
                  (setq clayer (getvar "CLAYER"))
                  (setq cmdecho (getvar "CMDECHO"))
                  (setq osmode (getvar "OSMODE"))
                  (setq attreq (getvar "ATTREQ"))
                  (setvar "CMDECHO" 0)
                  (setvar "ATTREQ" 0)
                  (command "_.UNDO" "_G")
                  (dstp_ucspush)
                  (setq itm 0)
                  (setq tot (length crdlst))
                  (princ "\nDS>")
                  (foreach pnt crdlst
                    (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa tot)))
                    (setq attlst nil)
                    (foreach rec hndlst
                      (if (equal (car rec) pnt fuz)
                        (progn
                          (setq hnd (cadr rec))
                          (setq ent (entget hnd))
                          (setq blk (cdr (assoc 2 ent)))
                          (setq la (cdr (assoc 8 ent)))
                          (setq pt (cdr (assoc 10 ent)))
                          (setq xs (cdr (assoc 41 ent)))
                          (if (= xs nil)(setq xs 1.0))
                          (setq ys (cdr (assoc 42 ent)))
                          (if (= ys nil)(setq ys 1.0))
                          (setq ro (cdr (assoc 50 ent)))
                          (if (= ro nil)(setq ro 0.0))
                          (setq nxthnd hnd)
                          (setq nxtent ent)
                          (setq attlst (append attlst (list (list "OLDBLOCK" blk nil nil nil))))
                          (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                            (setq nxthnd (entnext nxthnd))
                            (setq nxtent (entget nxthnd))
                            (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                              (progn
                                (setq orgnme (cdr (assoc 2 nxtent)))
                                (setq orgval (cdr (assoc 1 nxtent)))
                                (setq orgpnt (cdr (assoc 10 nxtent)))
                                (setq orgrot (cdr (assoc 50 nxtent)))
                                (setq orglay (cdr (assoc 8 nxtent)))
                                (setq attlst (append attlst (list (list orgnme orgval orgpnt orgrot orglay))))
                              )
                            )
                          )
                          (entdel hnd)
                        )
                      )
                    )
                    (setvar "CLAYER" la)
                    (setq pt (trans pt 0 1))
                    (command "_.INSERT" nbn pt xs ys (dstp_rtd ro))
                    (setq hnd (entlast))
                    (setq nxthnd hnd)
                    (setq nxtent ent)
                    (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                      (setq nxthnd (entnext nxthnd))
                      (setq nxtent (entget nxthnd))
                      (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                        (progn
                          (setq attnme (cdr (assoc 2 nxtent)))
                          (setq ctr 0)
                          (setq done nil)
                          (while (/= done T)
                            (setq rec (nth ctr attlst))
                            (if (= (strcase (car rec)) (strcase attnme))
                              (progn
                                (setq nxtent (subst (cons 1 (cadr rec))(assoc 1 nxtent) nxtent))
                                (if (/= (nth 2 rec) nil)
                                  (setq nxtent (subst (cons 10 (nth 2 rec))(assoc 10 nxtent) nxtent))
                                )
                                (if (/= (nth 3 rec) nil)
                                  (setq nxtent (subst (cons 50 (nth 3 rec))(assoc 50 nxtent) nxtent))
                                )
                                (if (/= (nth 4 rec) nil)
                                  (setq nxtent (subst (cons 8 (nth 4 rec))(assoc 8 nxtent) nxtent))
                                )
                                (entmod nxtent)
                                (setq done T)
                              )
                            )
                            (setq ctr (1+ ctr))
                            (if (= ctr (length attlst))
                              (setq done T)
                            )
                          )
                        )
                      )
                    )
                    (entupd hnd)
                    (setq itm (1+ itm))
                  )
                  (dstp_ucspop)
                  (command "_.UNDO" "E")
                  (setvar "ATTREQ" attreq)
                  (setvar "OSMODE" osmode)
                  (setvar "CMDECHO" cmdecho)
                  (setvar "CLAYER" clayer)
                  (princ ", Done.")
                )
                (princ "\nDS> Notice: Selected Replacement Has No Attributes Fields!")
              )
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Block Substitute
; --------------------------------------------------------------------------

(defun c:BlkSubIns ( / cmdecho ent hnd itm num rep sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Select Block(s) to Acquire Substitute ...")
      (setq sset (ssget '((0 . "INSERT") (66 . 0))))
      (if sset 
        (progn
          (initget "D")
          (setq tmp (entsel "\nDS> Dialog/<Select Replacement Block>: "))
          (if (= tmp "D")
            (setq rep (dstp_tablesel "Select Block" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
            (setq rep (cdr (assoc 2 (entget (car tmp)))))
          )
          (if (/= rep nil)
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (setq num (sslength sset) itm 0)
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq ent (subst (cons 2 rep)(assoc 2 ent) ent))
                (entmod ent)
                (entupd hnd)
                (setq itm (1+ itm))
              )
              (princ ", Done.")
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
              (princ ", Done.")
            )
            (alert "No blocks found")
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Explode Blocks to Groups
; --------------------------------------------------------------------------

(defun c:BlkExpGrp ( / addto attent attflw atthnd blkent blkhnd blklay chk
                         cmdecho dol dolst gset highlight itm newblk newtxt
                         num orgmrk osmode pass sset tmp tmpent tmpmrk)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I" '((0 . "INSERT"))))
      (if (= sset nil)
        (progn
          (princ "\nDS> Select Inserts to Convert to Groups ...")
          (setq sset (ssget '((0 . "INSERT"))))
        )
      )
      (if sset
        (progn
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
              (setq sset (car chk))
              (sssetfirst nil sset)
              (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Object(s) Removed"))
            )
          )
          (initget "Y N")
          (setq chk (getkword "\nDS> Change Resulting Geometry to Insert Layer <Y>/N: "))
          (if (/= chk "N")(setq dol T)(setq dol nil))
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq num (sslength sset) itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq blkhnd (ssname sset itm))
            (setq blkent (entget blkhnd))
            (setq blklay (cdr (assoc 8 blkent)))
            (setq atthnd blkhnd)
            (setq attent blkent)
            (setq orgmrk (entlast))
            (setq tmp (assoc 66 blkent))
            (if (= tmp nil)
              (setq attflw nil)
              (progn
                (if (/= (cdr tmp) nil)
                  (setq attflw T)
                )
              )
            )
            (if (= attflw T)
              (progn
                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                  (setq atthnd (entnext atthnd))
                  (setq attent (entget atthnd))
                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                    (progn
                      (setq pass T)
                      (if (= (cdr (assoc 1 attent)) "")
                        (setq pass nil)
                      )
                      (if (= (boole 1 (cdr (assoc 70 attent)) 1) 1)
                        (setq pass nil)
                      )
                      (if (= pass T)
                        (progn
                          (setq newtxt '((0 . "TEXT")))
                          (setq dolst (list 1 7 8 10 11 39 40 41 50 51 62 71 73))
                          (foreach grp dolst
                            (setq addto (assoc grp attent))
                            (if (/= addto nil)
                              (setq newtxt (append newtxt (list (assoc grp attent))))
                            )
                          )
                          (setq newtxt (subst (cons 8 blklay)(assoc 8 newtxt) newtxt))
                          (entmake newtxt)
                        )
                      )
                    )
                  )
                )
              )
            )
            ;
            ;--- erase, rebuild/insert basic block
            ;
            (entdel blkhnd)
            (setq newblk '((0 . "INSERT")(66 . 0)))
            (setq dolst (list 2 8 10 41 42 43 50 70 71 44 45 -3))
            (foreach grp dolst
              (setq addto (assoc grp blkent))
              (if (/= addto nil)
                (setq newblk (append newblk (list (assoc grp blkent))))
              )
            )
            (entmake newblk)
            (setq tmpmrk (entlast))
            (command "_.EXPLODE" (entlast))
            (while (/= tmpmrk nil)
              (setq tmpmrk (entnext tmpmrk))
              (if (/= tmpmrk nil)
                (progn
                  (setq tmpent (entget tmpmrk))
                  (if (= (cdr (assoc 0 tmpent)) "ATTDEF")
                    (entdel tmpmrk)
                  )
                )
              )
            )
            (setq gset (ssadd))
            (while (/= orgmrk nil)
              (setq orgmrk (entnext orgmrk))
              (if (/= orgmrk nil)
                (setq gset (ssadd orgmrk gset))
              )
            )
            (if (= dol T)
              (command "_.CHPROP" gset "" "_LA" blklay "")
            )
            (setq highlight (getvar "HIGHLIGHT"))
            (setvar "HIGHLIGHT" 0)
            (command "_.-GROUP" "" "*" "" gset "")
            (setvar "HIGHLIGHT" highlight)
            (setq gset nil)
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Block Multi Sheet Catalog
; --------------------------------------------------------------------------

(defun c:BlkCatGen ( / $value attreq axo buffer cenpt chk cmdecho count
                          crdlst curpag dcl_id decpag dir doproc fh fil
                          fillst fixpag flst hgt hnd ins itmper labdat labofs
                          laynam maxhgt maxpt maxwid minpt new osmode pagnum
                          perpag res root scf srcnam symcnt symlst tmp txt
                          txtsiz usesiz usetxt wid xdif ydif)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun blkcatalog_fillst ()
        (start_list "fillst")
        (mapcar 'add_list fillst)
        (end_list)
      )
      (defun blkcatalog_addfiles ()
        (setq res (dstp_getfilex "Select Drawing Files" nil "dwg"))
        (if (/= res nil)
          (progn
            (foreach fil res
              (if (not (member fil fillst))
                (setq fillst (cons fil fillst))
              )
            )
            (if (/= fillst nil)
              (setq fillst (acad_strlsort fillst))
            )
            (blkcatalog_fillst)
          )
        )
      )
      (defun blkcatalog_addfolder ()
        (setq dir (dstp_getfolder "Select Directory" nil))
        (if (/= dir nil)
          (progn
            (setq flst (vl-directory-files dir "*.dwg" 0))
            (if (/= flst nil)
              (progn
                (foreach rec flst
                  (setq fil (strcat dir "\\" rec))
                  (if (not (member fil fillst))
                    (setq fillst (cons fil fillst))
                  )
                )
                (if (/= fillst nil)
                  (setq fillst (acad_strlsort fillst))
                )
                (blkcatalog_fillst)
              )
            )
          )
        )
      )
      (defun blkcatalog_addsymdat ()
        (setq res (dstp_getfiles "Select ToolPac Symbol Manager Database" nil "sdb" 0))
        (if (/= res nil)
          (progn
            (setq fh (open res "r"))
            (if (/= fh nil)
              (progn
                (dstp_prompt "DS> Reading Symbol Database ... ")
                (setq chk (read-line fh))
                (if (= chk "TP60SYM")
                  (progn
                    (read-line fh)
                    (read-line fh)
                    (setq symlst (read (read-line fh)))
                    (princ "Done.\r")
                    (close fh)
                    (foreach rec symlst
                      (setq fil (nth 2 rec))
                      (if (not (member fil fillst))
                        (setq fillst (cons fil fillst))
                      )
                    )
                    (if (/= fillst nil)
                      (setq fillst (acad_strlsort fillst))
                    )
                    (blkcatalog_fillst)
                  )
                  (progn
                    (close fh)
                    (alert "File appears invalid")
                  )
                )
              )
            )
          )
        )
      )
      ;
      ; --- Main
      ;
      (if (/= (ssget "_X") nil)
        (princ "\nDS> Command should be started from a new, empty drawing.\n")
      )    
      (setq perpag (dstp_regfetch "BlockCat" "perpag" "1"))
      (setq buffer (atof (dstp_regfetch "BlockCat" "buffer" "0.40")))
      (setq txtsiz (atof (dstp_regfetch "BlockCat" "txtsiz" (rtos (dstp_textsize) 2 2))))
      (setq usetxt (atoi (dstp_regfetch "BlockCat" "usetxt" "1")))
      (setq labdat (dstp_regfetch "BlockCat" "labdat" "1"))
      (setq dcl_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "blkcatgen" dcl_id)) (exit))
      (blkcatalog_fillst)
      (set_tile "perpag" perpag)
      (set_tile "buffer" (rtos buffer 2 2))
      (set_tile "txtsiz" (rtos txtsiz 2 2))
      (if (= usetxt 1)
        (set_tile "usenam" "1")
        (set_tile "useful" "1")
      )
      (set_tile "labdat" labdat)
      (action_tile "clrlst" "(setq fillst nil)(blkcatalog_fillst)")
      (action_tile "addfil" "(blkcatalog_addfiles)")
      (action_tile "addfol" "(blkcatalog_addfolder)")
      (action_tile "addsdb" "(blkcatalog_addsymdat)")
      (action_tile "perpag" "(setq perpag $value)")
      (action_tile "buffer" "(setq buffer (atof $value))")
      (action_tile "txtsiz" "(setq txtsiz (atof $value))")
      (action_tile "usenam" "(setq usetxt 1)")
      (action_tile "useful" "(setq usetxt 2)")
      (action_tile "labdat" "(setq labdat $value)")
      (action_tile "accept" "(setq doproc T)(done_dialog 0)")
      (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
      (action_tile "help" "(dstp_showhelp \"BlkCatGen.htm\")")
      (if (equal (start_dialog) 1)
        (unload_dialog dcl_id)
      )
      ;
      (if (= doproc T)
        (progn
          (dstp_regstore "BlockCat" "perpag" perpag)
          (dstp_regstore "BlockCat" "buffer" (rtos buffer 2 2))
          (dstp_regstore "BlockCat" "txtsiz" (rtos txtsiz 2 2))
          (dstp_regstore "BlockCat" "usetxt" (itoa usetxt))
          (dstp_regstore "BlockCat" "labdat" labdat)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq attreq (getvar "ATTREQ"))
          (setvar "ATTREQ" 0)
          (command "_.UNDO" "_G")
          (cond
            ((= perpag "0") ; 2Cx3R (6)
              (setq itmper 6)
              (setq maxhgt 3.50)
              (setq maxwid 3.50)
              (setq labofs 1.80)
              (setq srcnam "PAGE6")
              (setq crdlst (list
                (list 1.80 8.85)(list 5.30 8.85)
                (list 1.80 5.35)(list 5.30 5.35)
                (list 1.80 1.85)(list 5.30 1.85)
              ))
            )
            ((= perpag "1") ; 3Cx4R (12)
              (setq itmper 12)
              (setq maxhgt 2.10)
              (setq maxwid 2.30)
              (setq labofs 1.50)
              (setq srcnam "PAGE12")
              (setq crdlst (list
                (list 1.20 9.40)(list 3.50 9.40)(list 5.90 9.40)
                (list 1.20 6.80)(list 3.50 6.80)(list 5.90 6.80)
                (list 1.20 4.15)(list 3.50 4.15)(list 5.90 4.15)
                (list 1.20 1.55)(list 3.50 1.55)(list 5.90 1.55)
              ))
            )
            ((= perpag "2") ; 4Cx6R (24)
              (setq itmper 24)
              (setq maxhgt 1.75)
              (setq maxwid 1.75)
              (setq labofs 0.85)
              (setq srcnam "PAGE24")
              (setq crdlst (list
                (list 0.90 9.65)(list 2.65 9.65)(list 4.40 9.65)(list 6.15 9.65)
                (list 0.90 7.90)(list 2.65 7.90)(list 4.40 7.90)(list 6.15 7.90)
                (list 0.90 6.15)(list 2.65 6.15)(list 4.40 6.15)(list 6.15 6.15)
                (list 0.90 4.40)(list 2.65 4.40)(list 4.40 4.40)(list 6.15 4.40)
                (list 0.90 2.65)(list 2.65 2.65)(list 4.40 2.65)(list 6.15 2.65)
                (list 0.90 0.90)(list 2.65 0.90)(list 4.40 0.90)(list 6.15 0.90)
              ))
            )
            ((= perpag "3") ; 6Cx9R (54)
              (setq itmper 54)
              (setq maxhgt 1.16)
              (setq maxwid 1.16)
              (setq labofs 0.55)
              (setq srcnam "PAGE54")
              (setq crdlst (list
                (list 0.60 9.90)(list 1.75 9.90)(list 2.90 9.90)(list 4.10 9.90)(list 5.25 9.90)(list 6.45 9.90)
                (list 0.60 8.75)(list 1.75 8.75)(list 2.90 8.75)(list 4.10 8.75)(list 5.25 8.75)(list 6.45 8.75)
                (list 0.60 7.57)(list 1.75 7.57)(list 2.90 7.57)(list 4.10 7.57)(list 5.25 7.57)(list 6.45 7.57)
                (list 0.60 6.40)(list 1.75 6.40)(list 2.90 6.40)(list 4.10 6.40)(list 5.25 6.40)(list 6.45 6.40)
                (list 0.60 5.25)(list 1.75 5.25)(list 2.90 5.25)(list 4.10 5.25)(list 5.25 5.25)(list 6.45 5.25)
                (list 0.60 4.05)(list 1.75 4.05)(list 2.90 4.05)(list 4.10 4.05)(list 5.25 4.05)(list 6.45 4.05)
                (list 0.60 2.92)(list 1.75 2.92)(list 2.90 2.92)(list 4.10 2.92)(list 5.25 2.92)(list 6.45 2.92)
                (list 0.60 1.72)(list 1.75 1.72)(list 2.90 1.72)(list 4.10 1.72)(list 5.25 1.72)(list 6.45 1.72)
                (list 0.60 0.55)(list 1.75 0.55)(list 2.90 0.55)(list 4.10 0.55)(list 5.25 0.55)(list 6.45 0.55)
              ))
            )
            ((= perpag "4") ; 9Cx12R (108)
              (setq itmper 108)
              (setq maxhgt 0.87)
              (setq maxwid 0.77)
              (setq labofs 0.42)
              (setq srcnam "PAGE108")
              (setq crdlst (list
                (list 0.37 10.15)(list 1.17 10.15)(list 1.95 10.15)(list 2.72 10.15)(list 3.50 10.15)(list 4.27 10.15)(list 5.05 10.15)(list 5.82 10.15)(list 6.60 10.15)
                (list 0.37 9.30)(list 1.17 9.30)(list 1.95 9.30)(list 2.72 9.30)(list 3.50 9.30)(list 4.27 9.30)(list 5.05 9.30)(list 5.82 9.30)(list 6.60 9.30)
                (list 0.37 8.37)(list 1.17 8.37)(list 1.95 8.37)(list 2.72 8.37)(list 3.50 8.37)(list 4.27 8.37)(list 5.05 8.37)(list 5.82 8.37)(list 6.60 8.37)
                (list 0.37 7.55)(list 1.17 7.55)(list 1.95 7.55)(list 2.72 7.55)(list 3.50 7.55)(list 4.27 7.55)(list 5.05 7.55)(list 5.82 7.55)(list 6.60 7.55)
                (list 0.37 6.57)(list 1.17 6.57)(list 1.95 6.57)(list 2.72 6.57)(list 3.50 6.57)(list 4.27 6.57)(list 5.05 6.57)(list 5.82 6.57)(list 6.60 6.57)
                (list 0.37 5.80)(list 1.17 5.80)(list 1.95 5.80)(list 2.72 5.80)(list 3.50 5.80)(list 4.27 5.80)(list 5.05 5.80)(list 5.82 5.80)(list 6.60 5.80)
                (list 0.37 4.90)(list 1.17 4.90)(list 1.95 4.90)(list 2.72 4.90)(list 3.50 4.90)(list 4.27 4.90)(list 5.05 4.90)(list 5.82 4.90)(list 6.60 4.90)
                (list 0.37 4.05)(list 1.17 4.05)(list 1.95 4.05)(list 2.72 4.05)(list 3.50 4.05)(list 4.27 4.05)(list 5.05 4.05)(list 5.82 4.05)(list 6.60 4.05)
                (list 0.37 3.15)(list 1.17 3.15)(list 1.95 3.15)(list 2.72 3.15)(list 3.50 3.15)(list 4.27 3.15)(list 5.05 3.15)(list 5.82 3.15)(list 6.60 3.15)
                (list 0.37 2.32)(list 1.17 2.32)(list 1.95 2.32)(list 2.72 2.32)(list 3.50 2.32)(list 4.27 2.32)(list 5.05 2.32)(list 5.82 2.32)(list 6.60 2.32)
                (list 0.37 1.40)(list 1.17 1.40)(list 1.95 1.40)(list 2.72 1.40)(list 3.50 1.40)(list 4.27 1.40)(list 5.05 1.40)(list 5.82 1.40)(list 6.60 1.40)
                (list 0.37 0.55)(list 1.17 0.55)(list 1.95 0.55)(list 2.72 0.55)(list 3.50 0.55)(list 4.27 0.55)(list 5.05 0.55)(list 5.82 0.55)(list 6.60 0.55)
              ))
            )
            (t nil)
          )
          (if (< maxwid maxhgt)
            (setq usesiz maxwid)
            (setq usesiz maxhgt)
          )
          (setq symcnt (length fillst))
          (setq decpag (/ (float symcnt) (float itmper)))
          (if (<= decpag 1.0)
            (setq fixpag 1)
            (progn
              (setq fixpag (fix decpag))
              (if (> (rem decpag fixpag) 0.0)
                (setq fixpag (1+ fixpag))
              )
            )
          )
          (command "_.LAYOUT" "_T" (strcat dstpdir "Data\\" "BLKCATALOG.DWT") srcnam)
          (command "_.LAYOUT" "_D" "LAYOUT1")
          (command "_.LAYOUT" "_D" "LAYOUT2")
          (setq count 1)
          (while (<= count fixpag)
            (setq pagnum (strcat "00" (itoa count)))
            (setq pagnum (substr pagnum (- (strlen pagnum) 2) 3))
            (setq laynam (strcat "PAGE-" pagnum))
            (command "_.LAYOUT" "_C" srcnam laynam)
            (setq count (1+ count))
          )
          (command "_.LAYOUT" "_D" srcnam)
          ;
          (setq count 0)
          (setq curpag 1)
          (setq pagnum (strcat "00" (itoa curpag)))
          (setq pagnum (substr pagnum (- (strlen pagnum) 2) 3))
          (setq laynam (strcat "PAGE-" pagnum))
          (setvar "CTAB" laynam)
          (if (= labdat "1")
            (progn
              (setq tmp (dstp_datetime (rtos (getvar "CDATE"))))
              (setq txt (strcat "(" (car tmp) " - " (cadr tmp) " - " laynam ")"))
              (setq new '((0 . "TEXT")))
              (setq new (append new (list (cons 10 (list (+ 7.05 txtsiz) 0.0)))))
              (setq new (append new (list (cons 1 txt))))
              (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
              (setq new (append new (list (cons 40 txtsiz))))
              (setq new (append new (list (cons 50 1.5714))))
              (entmake new)
            )
          )
          ;
          (foreach symbol fillst
            (if (= count itmper)
              (progn
                (setq curpag (1+ curpag))
                (setq pagnum (strcat "00" (itoa curpag)))
                (setq pagnum (substr pagnum (- (strlen pagnum) 2) 3))
                (setq laynam (strcat "PAGE-" pagnum))
                (setvar "CTAB" laynam)
                (setq count 0)
                (if (= labdat "1")
                  (progn
                    (setq tmp (dstp_datetime (rtos (getvar "CDATE"))))
                    (setq txt (strcat "(" (car tmp) " - " (cadr tmp) " - " laynam ")"))
                    (setq new '((0 . "TEXT")))
                    (setq new (append new (list (cons 10 (list (+ 7.05 txtsiz) 0.0)))))
                    (setq new (append new (list (cons 1 txt))))
                    (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
                    (setq new (append new (list (cons 40 txtsiz))))
                    (setq new (append new (list (cons 50 1.5714))))
                    (entmake new)
                  )
                )
              )
            )
            (command "_.INSERT" symbol "0,0" "1.0" "1.0" "0")
            (setq hnd (entlast))
            (setq axo (vlax-ename->vla-object hnd))
            (setq res (vl-catch-all-apply 'vla-getboundingbox (list axo 'minpt 'maxpt)))
            (if (not (vl-catch-all-error-p res))
              (progn
                (vla-getboundingbox axo 'minpt 'maxpt)
                (setq minpt (vlax-safearray->list minpt))
                (setq maxpt (vlax-safearray->list maxpt))
                (setq minpt (dstp_2dpoint minpt))
                (setq maxpt (dstp_2dpoint maxpt))
                (setq cenpt (polar minpt (angle minpt maxpt)(/ (distance minpt maxpt) 2.0)))
                (setq wid (abs (* (- (car maxpt)(car minpt)) (+ 1.0 buffer))))
                (setq hgt (abs (* (- (cadr maxpt)(cadr minpt)) (+ 1.0 buffer))))
                (if (or (> wid 0.0)(> hgt 0.0))
                  (progn
                    (setq xdif (- wid usesiz))
                    (setq ydif (- hgt usesiz))
                    (if (< xdif ydif)
                      (setq scf (/ usesiz hgt))
                      (setq scf (/ usesiz wid))
                    )
                  )
                  (setq scf 1.0)
                )
              )
              (setq scf 1.0)
            )
            (command "_.POINT" "0,0")
            (command "_.SCALE" hnd (entlast) "" cenpt scf)
            (command "_.MOVE" hnd (entlast) "" cenpt (nth count crdlst))
            (if (= usetxt 1)
              (progn
                (setq root (GetFileNameWithoutExtension symbol))
                (setq txt (strcase (last (dstp_pdf2lst root "\\"))))
              )
              (setq txt symbol)
            )
            (setq ins (polar (nth count crdlst) 4.71428 labofs))
            (setq new '((0 . "MTEXT")(100 . "AcDbEntity")(100 . "AcDbMText")))
            (setq new (append new (list (cons 10 ins))))
            (setq new (append new (list (cons 1 txt))))
            (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
            (setq new (append new (list (cons 40 txtsiz))))
            (setq new (append new (list (cons 41 maxwid))))
            (setq new (append new (list (cons 71 8))))
            (setq new (append new (list (cons 72 5))))
            (entmake new)
            (setq count (1+ count))
          )
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
          (setvar "ATTREQ" attreq)
          (princ)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Make Deterrent MInsert
; --------------------------------------------------------------------------

(defun c:BlkMakDet ( / abl actspc chk cmdecho lst osmode pnt sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= (getvar "tilemode") 1)
        (setq actspc 0)
        (if (> (getvar "cvport") 1)
          (setq actspc 0)
          (setq actspc 1)
        )
      )
      (if (= actspc 0)
        (setq sset (ssget '((67 . 0))))
        (progn
          (princ "\DS> Viewports cannot be selected ...")
          (setq sset (ssget '((67 . 1)(-4 . "<NOT")(0 . "VIEWPORT")(-4 . "NOT>"))))
        )
      )
      (if sset
        (progn
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
              (setq sset (car chk))
              (sssetfirst nil sset)
              (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Object(s) Removed"))
            )
          )
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (dstp_prompt "DS> Processing Selection Set ... ")
          (setq pnt (list 0.0 0.0 0.0))
          (setq lst (dstp_ss2lst sset))
          (setq abl (dstp_blksupmad lst pnt))
          (entmake (list (cons 0 "INSERT")(cons 2 abl)(cons 66 0)(cons 8 "0")(cons 10 pnt)(cons 70 1)))
          (princ "Done.")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Rename Anonymous Block
; --------------------------------------------------------------------------

(defun c:BlkRenAno ( / bln ent hnd itm nam nen new nhd num obd pik sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq pik (entsel "\nDS> Select Block to Rename: "))
      (if (/= pik nil)
        (progn
          (setq hnd (car pik))
          (setq ent (entget hnd))
          (setq nam (cdr (assoc 2 ent)))
          (if (= (substr nam 1 2) "*U")
            (progn
              (setq new (getstring (strcat "\nDS> New Name for (" nam "): ")))
              (if (and (/= new "")(= (tblsearch "BLOCK" new) nil))
                (progn
                  (setq obd (tblsearch "BLOCK" nam))
                  (setq nhd (cdr (assoc -2 obd)))
                  (setq nen (entget nhd))
                  (entmake (list (cons 0 "BLOCK")(cons 2 new)(cons 70 0)(cons 10 (cdr (assoc 10 obd)))))
                  (entmake nen)
                  (while
                    (setq nhd (entnext nhd)) 
                    (setq nen (entget nhd)) 
                    (entmake nen)
                  )
                  (entmake (list (cons 0 "ENDBLK")))
                  ;
                  (setq sset (ssget "_X" '((0 . "INSERT"))))
                  (setq num (sslength sset) itm 0)
                  (while (< itm num)
                    (setq nhd (ssname sset itm))
                    (setq nen (entget nhd))
                    (setq bln (cdr (assoc 2 nen)))
                    (if (= bln nam)
                      (progn
                        (setq nen (subst (cons 2 new)(assoc 2 nen) nen))
                        (entmod nen)
                        (entupd nhd)
                      )
                    )
                    (setq itm (1+ itm))
                  )
                )
              )
            )
            (princ "DS> Block does not appear to be anonymous!")
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;             Find & Replace Attribute Tag Names in Selection Set
; --------------------------------------------------------------------------

(defun c:BlkAttTag ( / attent atthnd atttag blkchg blkent blkhnd blklay
                         cmdecho fnd igd itm num rep sset taglst)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq fnd (strcase (getstring "\nDS> Attribute Tag Name to Find: " T)))
      (if (/= fnd "")
        (progn
          (setq rep (strcase (getstring "\nDS> Replacement Attribute Tag Name: ")))
          (if (/= rep "")
            (progn
              (initget "Y N")
              (setq igd (getkword "\nDS> Process Duplicates <Y>/N: "))
              (if (/= igd "N")(setq igd "Y"))
              ;
              (princ "\nDS> Select Block(s) to Process")
              (setq sset (ssget '((0 . "INSERT") (66 . 1))))
              (if sset 
                (progn
                  (setq num (sslength sset) itm 0)
                  (princ "\nDS>")
                  (while (< itm num)
                    (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                    (setq blkhnd (ssname sset itm))
                    (setq blkent (entget blkhnd))
                    (setq blklay (cdr (assoc 8 blkent)))
                    (setq blkchg nil)
                    (setq atthnd blkhnd)
                    (setq attent blkent)
                    (if (= igd "N")
                      (setq taglst nil)
                    )
                    (while (/= "SEQEND" (cdr (assoc 0 attent)))
                      (setq atthnd (entnext atthnd))
                      (setq attent (entget atthnd))
                      (if (= (cdr (assoc 0 attent)) "ATTRIB")
                        (progn
                          (setq atttag (strcase (cdr (assoc 2 attent))))
                          (if (= igd "N")
                            (progn
                              (if (not (member atttag taglst))
                                (progn
                                  (if (= (strcase atttag) fnd)
                                    (progn
                                      (setq attent (subst (cons 2 rep)(assoc 2 attent) attent))
                                      (entmod attent)
                                    )
                                  )
                                  (setq taglst (append taglst (list atttag)))
                                )
                              )
                            )
                            (progn
                              (if (= (strcase atttag) fnd)
                                (progn
                                  (setq attent (subst (cons 2 rep)(assoc 2 attent) attent))
                                  (entmod attent)
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    (setq itm (1+ itm))
                  )
                  (princ ", Done.")
                )
                (alert "No blocks found")
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;            Find & Replace Attribute Values in Selected Fields
; --------------------------------------------------------------------------

(defun c:BlkAttRep ( / $value add all attent atthnd attlst atttag attval
                         blkchg blkent blkhnd cmdecho dcl_id doproc fnd
                         fndtag itm msg new num nxtent nxthnd optitm optsel
                         rep resitm reslst sset tmp uct whl)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun attvalrp_updlst ()
        (start_list "attlst")
        (mapcar 'add_list attlst)
        (end_list)
      )
      ;
      ; --- select or deselect all in options
      ;
      (defun attvalrp_lstcon (op / inc lat)
        (if (= op 0)
          (set_tile "attlst" "")
          (progn
            (setq inc 0)
            (setq lat "")
            (repeat (length attlst)
              (setq lat (strcat lat (rtos inc 2 0) " "))
              (setq inc (1+ inc))
            )
            (set_tile "attlst" lat)
          )
        )
      )
      ;
      ; --- build attlst
      ;
      (defun attvalrp_bldlst ()
        (setq uct 1)
        (setq reslst nil)
        (setq optsel (get_tile "attlst"))
        (while (setq optitm (read optsel))
          (setq resitm (nth optitm attlst))
          (setq reslst (append reslst (list resitm)))
          (while (and (/= " " (substr optsel uct 1))
            (/= "" (substr optsel uct 1)))
            (setq uct (1+ uct))
          )
          (setq optsel (substr optsel uct))
        )
      )
      ;
      ; --- preprocess selset to build options
      ;
      (defun attvalrp_preproc ()
        (princ "\nDS> Select Blocks to Process ...")
        (setq sset (ssget '((0 . "INSERT") (66 . 1))))
        (if sset
          (progn
            (setq attlst nil)
            (setq num (sslength sset) itm 0)
            (while (< itm num)
              (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
              (setq blkhnd (ssname sset itm))
              (setq blkent (entget blkhnd))
              (setq nxthnd blkhnd)
              (setq nxtent blkent)
              (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                (setq nxthnd (entnext nxthnd))
                (setq nxtent (entget nxthnd))
                (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                  (progn
                    (setq attval (cdr (assoc 1 nxtent)))
                    (setq atttag (strcase (cdr (assoc 2 nxtent))))
                    (setq fndtag nil)
                    (foreach rec attlst
                      (if (= (strcase rec) atttag)
                        (setq fndtag T)
                      )
                    )
                    (if (= fndtag nil)
                      (setq attlst (append attlst (list atttag)))
                    )
                  )
                )
              )
              (setq itm (1+ itm))
            )
            (princ ", Done.")
          )
        )
      )
      ;
      ; --- check list and fndstr
      ;
      (defun attvalrp_docheck ()
        (setq msg "")
        (if (= (length reslst) 0)
          (progn
            (setq add "No Search Fields Chosen!")
            (if (= msg "")
              (setq msg add)
              (setq msg (strcat msg "\n" add))
            )
          )
        )
        (if (/= msg "")
          (alert msg)
        )
      )
      ;
      ; --- react to 'all' toggle
      ;
      (defun attvalrp_alltog ()
        (setq all (get_tile "all"))
        (if (= all "1")
          (progn
            (setq fnd "")
            (set_tile "fnd" "*")
            (mode_tile "fnd" 1)
            (setq whl "1")
            (set_tile "whl" whl)
            (mode_tile "whl" 1)
          )
          (progn
            (setq fnd "")
            (set_tile "fnd" "")
            (mode_tile "fnd" 0)
            (setq whl "0")
            (set_tile "whl" whl)
            (mode_tile "whl" 0)
          )
        )
      )
      ;
      ; --- main routine
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq fnd "")
      (setq rep "")
      (setq all "0")
      (setq whl "0")
      (setq sset nil)
      (setq doproc nil)
      (attvalrp_preproc)
      (if sset
        (progn
          (setq tmp "attvalrp")
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog tmp dcl_id)) (exit))
          (attvalrp_updlst)
          (action_tile "selall" "(attvalrp_lstcon 1)")
          (action_tile "clrall" "(attvalrp_lstcon 0)")
          (action_tile "fnd" "(setq fnd $value)")
          (action_tile "rep" "(setq rep $value)")
          (action_tile "all" "(attvalrp_alltog)")
          (action_tile "whl" "(setq whl $value)")
          (action_tile "accept" "(attvalrp_bldlst)(attvalrp_docheck)(if (= msg \"\")(progn (setq doproc T)(done_dialog 0)))")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
          (action_tile "help" "(dstp_showhelp \"BlkAttRep.htm\")")
          (if (equal (start_dialog) 1)
            (unload_dialog dcl_id)
          )
        )
      )
      ;
      ; --- Begin Processing Data
      ;
      (if (= doproc T)
        (progn
          (if (= fnd "")
            (setq whl "1")
          )
          (setq num (sslength sset) itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq blkchg nil)
            (setq blkhnd (ssname sset itm))
            (setq blkent (entget blkhnd))
            (setq atthnd blkhnd)
            (setq attent blkent)
            (while (/= "SEQEND" (cdr (assoc 0 attent)))
              (setq atthnd (entnext atthnd))
              (setq attent (entget atthnd))
              (if (= (cdr (assoc 0 attent)) "ATTRIB")
                (progn
                  (setq atttag (strcase (cdr (assoc 2 attent))))
                  (setq attval (cdr (assoc 1 attent)))
                  (if (member atttag reslst)
                    (progn
                      (if (= whl "1")
                        (progn
                          (if (or
                                (= all "1")
                                (and (= fnd "")(= attval ""))
                                (= (strcase attval) (strcase fnd))
                              )
                            (progn
                              (setq blkchg T)
                              (setq attent (subst (cons 1 rep)(assoc 1 attent) attent))
                              (entmod attent)
                            )
                          )
                        )
                        (progn
                          (if (dstp_instr (strcase attval) (strcase fnd))
                            (progn
                              (setq blkchg T)
                              (setq new (dstp_subtext attval fnd rep))
                              (setq attent (subst (cons 1 new)(assoc 1 attent) attent))
                              (entmod attent)
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
            (if (= blkchg T)(entupd blkhnd))
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (setq tmp nil)
      (setq reslst nil)
      (setq attlst nil)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Find & Update Acad Variable Attribs
; --------------------------------------------------------------------------

(defun c:BlkAttVar ( / attnew attnme attold ce1 cnt dd ent hnd hr itm mm
                         mn num nxtent nxthnd post sset upd var varchk yy)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq ce1 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset 
        (progn
          (setq num (sslength sset) itm 0)
          (while (< itm num)
           (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq upd nil)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq nxthnd hnd)
            (setq nxtent ent)
            (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
              (setq nxthnd (entnext nxthnd))
              (setq nxtent (entget nxthnd))
              (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                (progn
                  (setq attnme (cdr (assoc 2 nxtent)))
                  (cond
                    ((= attnme "DATE")
                      (setq var (rtos (getvar "CDATE") 2 4))
                      (setq mm (substr var 5 2))
                      (setq dd (substr var 7 2))
                      (setq yy (substr var 1 4))
                      (setq attnew (strcat mm "-" dd "-" yy))
                      (setq nxtent (subst (cons 1 attnew)(assoc 1 nxtent) nxtent))
                      (entmod nxtent)
                      (setq upd T)
                    )
                    ((= attnme "TIME")
                      (setq var (rtos (getvar "CDATE") 2 4))
                      (setq hr (substr var 10 2))
                      (if (<= 12 (atoi hr))
                        (setq post "pm")
                        (setq post "am")
                      )
                      (if (= (atoi hr) 0)
                        (setq hr "12")
                        (if (< 12 (atoi hr))
                          (setq hr (rtos (- (atoi hr) 12) 2 0))
                        )
                      )
                      (setq mn (substr var 12 2))
                      (if (= mn "")(setq mn "00"))
                      (setq attnew (strcat hr ":" mn post))
                      (setq nxtent (subst (cons 1 attnew)(assoc 1 nxtent) nxtent))
                      (entmod nxtent)
                      (setq upd T)
                    )
                    (t
                      (setq varchk (getvar attnme))
                      (if (/= varchk nil)
                        (progn
                          (setq attnew "")
                          (cond
                            ((= (type varchk) 'str)
                              (setq attnew varchk)
                            )
                            ((= (type varchk) 'real)
                              (setq attnew (rtos varchk))
                            )
                            ((= (type varchk) 'int)
                              (setq attnew (itoa varchk))
                            )
                            ((= (type varchk) 'list)
                              (setq cnt 0)
                              (foreach rec varchk
                                (if (> cnt 0)
                                  (setq attnew (strcat attnew ","))
                                )
                                (setq attnew (strcat attnew (rtos rec)))
                                (setq cnt (+ cnt 1))
                              )
                            )
                            (t 
                              (setq attnew "")
                            )
                          )
                          (setq attold (cdr (assoc 1 nxtent)))
                          (if (/= varchk attold)
                            (progn
                              (setq nxtent (subst (cons 1 attnew)(assoc 1 nxtent) nxtent))
                              (entmod nxtent)
                              (setq upd T)
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
            (if (= upd T)
              (entupd hnd)
            )
            (setq itm (1+ itm))
          )
        )
        (alert "No blocks found")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" ce1)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Attribute Copy to Text
; --------------------------------------------------------------------------

(defun c:BlkAttTxt ( / cmdecho done ent hnd new obj opt pnt str)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Attribute to Copy to Text: ")
      (setq obj (nentsel ""))
      (if (/= obj nil)
        (progn
          (setq hnd (car obj))
          (setq ent (entget hnd)) 
          (if (= (cdr (assoc 0 ent)) "ATTRIB")
            (progn
              (setq new '((0 . "TEXT")))
              (setq new (append new (list (assoc 10 ent))))
              (setq new (append new (list (assoc 11 ent))))
              (setq new (append new (list (assoc 40 ent))))
              (setq new (append new (list (assoc 7 ent))))
              (setq new (append new (list (assoc 8 ent))))
              (setq new (append new (list (assoc 1 ent))))
              (setq new (append new (list (assoc 72 ent))))
              (setq new (append new (list (assoc 73 ent))))
              (if (/= (assoc 62 ent) nil)
                (setq new (append new (list (cons 62 (cdr (assoc 62 ent))))))
              )
              (if (> (cdr (assoc 41 ent)) 0.0)
                (setq new (append new (list (cons 41 (cdr (assoc 41 ent))))))
              )
              (if (> (cdr (assoc 50 ent)) 0.0)
                (setq new (append new (list (cons 50 (cdr (assoc 50 ent))))))
              )
              (entmake new)
              (setq hnd (entlast))
              (setq str (cdr (assoc 1 ent)))
              (setq pnt (cdr (assoc 10 ent)))
              (setq done nil)
              (while (/= done T)
                (initget "X M E R")
                (setq opt (getkword "\nDS> Move/Rotate/Edit/<eXit>: "))
                (cond
                  ((or (= opt nil)(= opt "X"))
                    (setq done T)
                  )
                  ((= opt "M")
                    (princ (strcat "\nDS> Pick new position for [" str "]: "))
                    (command "_.MOVE" hnd "" pnt pause)
                    (setq pnt (getvar "LASTPOINT"))
                  )
                  ((= opt "R")
                    (princ (strcat "\nDS> Pick new rotation for [" str "]: "))
                    (command "_.ROTATE" hnd "" pnt pause)
                  )
                  ((= opt "E")
                    (command "_.DDEDIT" hnd "")
                  )
                  (t nil)
                )
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;             Revert Selected Attributes back to Default
; --------------------------------------------------------------------------

(defun c:BlkAttRev ( / attent atthnd attlst atttag blk blkchg blkent
                          blkhnd blklst blknam cmdecho datlst done doproc
                          ent fnd hnd ind itm nam num rec sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Blocks to Process ...")
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset
        (progn
          (setq doproc T)
          (initget "Y N")
          (setq ind (getkword "\nDS> Process Individual Tags Y/<N>: "))
          (if (= ind nil)(setq ind "N"))
          (if (= ind "Y")
            (progn
              (setq attlst (dstp_attlst sset))
              (if (> (length attlst) 0)
                (progn
                  (setq attlst (acad_strlsort attlst))
                  (setq attlst (dstp_tablesel "Select Tag(s) to Process" attlst "m" ""))
                  (if (= attlst nil)
                    (setq doproc nil)
                  )
                )
              )
            )
            (setq attlst (dstp_attlst sset))
          )
          (if (= doproc T)
            (progn
              (dstp_prompt "DS> Looking Up Default Values ... ")
              (setq blklst nil datlst nil)
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq nam (cdr (assoc 2 ent)))
                (if (not (member nam blklst))
                  (progn
                    (setq blklst (cons nam blklst))
                    (setq blk (tblsearch "BLOCK" nam))
                    (if (/= blk nil)
                      (progn
                        (setq hnd (cdr (assoc -2 blk)))
                        (setq done nil)
                        (while (/= done T)
                          (setq ent (entget hnd))
                          (if (= (cdr (assoc 0 ent)) "ATTDEF")
                            (progn
                              (setq rec (list nam (cdr (assoc 2 ent)) (cdr (assoc 1 ent))))
                              (setq datlst (cons rec datlst))
                            )
                          )
                          (if (= (setq hnd (entnext (cdr (assoc -1 ent)))) nil)
                            (setq done T)
                          )
                        )
                      )
                    )
                  )
                )
                (setq itm (1+ itm))
              )
              (princ "Done.")
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq blkhnd (ssname sset itm))
                (setq blkent (entget blkhnd))
                (setq blknam (cdr (assoc 2 blkent)))
                (setq atthnd blkhnd)
                (setq attent blkent)
                (setq blkchg nil)
                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                  (setq atthnd (entnext atthnd))
                  (setq attent (entget atthnd))
                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                    (progn
                      (setq atttag (strcase (cdr (assoc 2 attent))))
                      (if (member atttag attlst)
                        (progn
                          (setq fnd nil)
                          (foreach rec datlst
                            (if (= (car rec) blknam)
                              (if (= (cadr rec) atttag)
                                (setq fnd (caddr rec))
                              )
                            )
                          )
                          (if (/= fnd nil)
                            (progn
                              (setq attent (subst (cons 1 fnd)(assoc 1 attent) attent))
                              (entmod attent)
                              (setq blkchg T)
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (if (= blkchg T)(entupd blkhnd))
                (setq itm (1+ itm))
              )
              (princ ", Done.")
            )
          )
        )
        (alert "No blocks found")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Populate Selected Attribute with Property
; --------------------------------------------------------------------------

(defun c:BlkAttFil ( / attlst atttag blkent blkhnd cmdecho dcl_id doproc
                           itm newval num numdec nxtent nxthnd optlst seqval
                           sset useatt useopt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Select Blocks to Process ...")
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset
        (progn
          (setq attlst (dstp_attlst sset))
          (if (/= attlst nil)
            (progn
              (setq useatt nil)
              (setq useopt nil)
              (setq dcl_id (load_dialog "toolpac.dcl"))
              (if (not (new_dialog "attfillval" dcl_id)) (exit))
              (setq optlst (list
                 ".BLOCKNAME"
                 ".INSPTX"
                 ".INSPTY"
                 ".INSPTZ"
                 ".XSCALE"
                 ".YSCALE"
                 ".ZSCALE"
                 ".ROTATION"
                 ".COLOR"
                 ".LAYER"
                 ".LINETYPE"
                 ".THICKNESS"
                 ".SEQUENTIAL"
              ))
              (if (= (getvar "HANDLES") 1)
                (setq optlst (append optlst (list ".HANDLE")))
              )
              (start_list "attlst")
              (mapcar 'add_list attlst)
              (end_list)
              (start_list "optlst")
              (mapcar 'add_list optlst)
              (end_list)
              (setq numdec (atoi (dstp_regfetch "General" "numdec" "2")))
              (set_tile "decplc" (itoa numdec))
              ;
              (action_tile "attlst" "(setq useatt (nth (atoi $value) attlst))")
              (action_tile "optlst" "(setq useopt (nth (atoi $value) optlst))")
              (action_tile "decplc" "(setq numdec (atoi $value))")
              (action_tile "accept" "(setq doproc T)(done_dialog 0)")
              (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
              (action_tile "help" "(dstp_showhelp \"BlkAttFil.htm\")")
              (if (equal (start_dialog) 1)
                (unload_dialog dcl_id)
              )
              (if (= doproc T)
                (if (/= useatt nil)
                  (if (/= useopt nil)
                    (progn
                      (setq seqval 1)
                      (dstp_regstore "General" "numdec" (itoa numdec))
                      (setq cmdecho (getvar "CMDECHO"))
                      (setvar "CMDECHO" 0)
                      (command "_.UNDO" "_G")
                      (princ "\nDS>")
                      (setq num (sslength sset) itm 0)
                      (while (< itm num)
                        (setq blkhnd (ssname sset itm))
                        (setq blkent (entget blkhnd))
                        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                        (cond
                          ((= useopt ".BLOCKNAME")
                            (setq newval (cdr (assoc 2 blkent)))
                          )
                          ((= useopt ".INSPTX")
                            (setq newval (rtos (nth 1 (assoc 10 blkent)) 2 numdec))
                          )
                          ((= useopt ".INSPTY")
                            (setq newval (rtos (nth 2 (assoc 10 blkent)) 2 numdec))
                          )
                          ((= useopt ".INSPTZ")
                            (setq newval (rtos (nth 3 (assoc 10 blkent)) 2 numdec))
                          )
                          ((= useopt ".XSCALE")
                            (setq newval (rtos (cdr (assoc 41 blkent)) 2 numdec))
                          )
                          ((= useopt ".YSCALE")
                            (setq newval (rtos (cdr (assoc 42 blkent)) 2 numdec))
                          )
                          ((= useopt ".ZSCALE")
                            (setq newval (rtos (cdr (assoc 43 blkent)) 2 numdec))
                          )
                          ((= useopt ".ROTATION")
                            (setq newval (rtos (dstp_rtd (cdr (assoc 50 blkent))) 2 numdec))
                          )
                          ((= useopt ".COLOR")
                            (if (/= (cdr (assoc 62 blkent)) nil)
                              (setq newval (itoa (cdr (assoc 62 blkent))))
                              (setq newval "BYLAYER")
                            )
                          )
                          ((= useopt ".LAYER")
                            (setq newval (cdr (assoc 8 blkent)))
                          )
                          ((= useopt ".LINETYPE")
                            (if (/= (cdr (assoc 6 blkent)) nil)
                              (setq newval (cdr (assoc 6 blkent)))
                              (setq newval "BYLAYER")
                            )
                          )
                          ((= useopt ".THICKNESS")
                            (if (/= (cdr (assoc 39 blkent)) nil)
                              (setq newval (rtos (cdr (assoc 39 blkent)) 2 numdec))
                              (setq newval "0.00000000")
                            )
                          )
                          ((= useopt ".HANDLE")
                            (setq newval (cdr (assoc 5 blkent)))
                            ;(setq newval (strcat "'" newval)) ; prevblkent 13E4
                          )
                          ((= useopt ".SEQUENTIAL")
                            (setq newval (itoa seqval))
                            (setq seqval (1+ seqval))
                          )
                        )
                        (setq nxthnd blkhnd)
                        (setq nxtent blkent)
                        (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                          (setq nxthnd (entnext nxthnd))
                          (setq nxtent (entget nxthnd))
                          (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                            (progn
                              (setq atttag (strcase (cdr (assoc 2 nxtent))))
                              (if (= atttag (strcase useatt))
                                (progn
                                  (setq nxtent (subst (cons 1 newval)(assoc 1 nxtent) nxtent))
                                  (entmod nxtent)
                                )
                              )
                            )
                          )
                        )
                        (entupd blkhnd)
                        (setq itm (1+ itm))
                      )
                      (princ ", Done.")
                      (command "_.UNDO" "_E")
                      (setvar "CMDECHO" cmdecho)
                      (princ)
                    )
                  )
                )
              )
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Copy Multiple w/Fuzz Distance
; --------------------------------------------------------------------------

(defun c:BlkAttRad ( / attent atthnd attlst atttag attval blkchg blkent
                         blkhnd blkins blknam chk cmdecho dcl_id dis doproc
                         fnd fuzdis inc itm lat lst num pnt srcatt srcblk
                         srcdat srchnd srcsel sset tarblk tarsel)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun attcpymu_lstcon (op / inc lat)
        (if (= op 0)
          (set_tile "srcatt" "")
          (progn
            (setq srcsel (dstp_dclall srcatt))
            (set_tile "srcatt" srcsel)
          )
        )
      )
      (princ "\nDS> Select Source Insert(s) ...")
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset 
        (progn
          (princ "\nDS>")
          (setq fuzdis (atof (dstp_regfetch "General" "fuzzdist" "0.0")))
          (setq srchnd nil)
          (setq srcblk nil)
          (setq srcatt nil)
          (setq srcdat nil)
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Evaluating Insert " (itoa (1+ itm)) " of " (itoa num)))
            (setq blkhnd (ssname sset itm))
            (setq blkent (entget blkhnd))
            (setq blknam (strcase (cdr (assoc 2 blkent))))
            (setq blkins (cdr (assoc 10 blkent)))
            (setq srchnd (cons blkhnd srchnd))
            (if (not (member blknam srcblk))
              (setq srcblk (cons blknam srcblk))
            )
            (setq atthnd blkhnd)
            (setq attent blkent)
            (setq attlst nil)
            (while (/= "SEQEND" (cdr (assoc 0 attent)))
              (setq atthnd (entnext atthnd))
              (setq attent (entget atthnd))
              (if (= (cdr (assoc 0 attent)) "ATTRIB")
                (progn
                  (setq atttag (strcase (cdr (assoc 2 attent))))
                  (setq attval (cdr (assoc 1 attent)))
                  (setq attlst (cons (list atttag attval) attlst))
                  (if (not (member atttag srcatt))
                    (setq srcatt (cons atttag srcatt))
                  )
                )
              )
            )
            (setq srcdat (cons (list blkins attlst) srcdat))
            (setq itm (1+ itm))
          )
          (princ ", Done.\r")
          (setq tarblk (acad_strlsort (dstp_bldlst "BLOCK")))
          (setq doproc nil)
          (if (< (setq dcl_id (load_dialog "toolpac.dcl")) 0) (exit))
          (if (not (new_dialog "attcpymu" dcl_id)) (exit))
          (start_list "srcatt")
          (mapcar 'add_list srcatt)
          (end_list)
          (attcpymu_lstcon 1)
          (start_list "tarblk")
          (mapcar 'add_list tarblk)
          (end_list)
          (setq inc 0)
          (setq lat "")
          (repeat (length tarblk)
            (if (not (member (nth inc tarblk) srcblk))
              (setq lat (strcat lat (rtos inc 2 0) " "))
            )
            (setq inc (1+ inc))
          )
          (set_tile "tarblk" lat)
          (setq tarsel lat)
          (set_tile "fuzdis" (rtos fuzdis (getvar "LUNITS") 4))
          (action_tile "srcatt" "(setq srcsel $value)")
          (action_tile "selall" "(attcpymu_lstcon 1)")
          (action_tile "clrall" "(attcpymu_lstcon 0)")
          (action_tile "tarblk" "(setq tarsel $value)")
          (action_tile "fuzdis" "(setq fuzdis (atof $value))")
          (action_tile "accept" "(setq doproc T)(done_dialog 1)")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
          (action_tile "help" "(dstp_showhelp \"BlkAttRad.htm\")")
          (start_dialog)
          (unload_dialog dcl_id)
          (if (= doproc T)
            (progn
              (setq srcatt (dstp_dcllst srcatt srcsel))
              (setq tarblk (dstp_dcllst tarblk tarsel))
              (dstp_regstore "General" "fuzzdist" (rtos fuzdis 2 4))
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (setq sset (ssget "_X" '((0 . "INSERT") (66 . 1))))
              (setq num (sslength sset) itm 0)
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Processing Insert " (itoa (1+ itm)) " of " (itoa num)))
                (setq blkchg nil)
                (setq blkhnd (ssname sset itm))
                (setq blkent (entget blkhnd))
                (setq blknam (strcase (cdr (assoc 2 blkent))))
                (setq blkins (cdr (assoc 10 blkent)))
                (if (not (member blkhnd srchnd))
                  (if (member blknam tarblk)
                    (progn
                      (setq fnd nil)
                      (setq dis 999999999.99)
                      (foreach rec srcdat
                        (setq pnt (car rec))
                        (setq chk (distance (dstp_2dpoint pnt) (dstp_2dpoint blkins)))
                        (if (< chk dis)
                          (if (<= chk fuzdis)
                            (progn
                              (setq fnd T)
                              (setq lst (cadr rec))
                            )
                          )
                        )
                      )
                      (if (= fnd T)
                        (progn
                          (setq atthnd blkhnd)
                          (setq attent blkent)
                          (while (/= "SEQEND" (cdr (assoc 0 attent)))
                            (setq atthnd (entnext atthnd))
                            (setq attent (entget atthnd))
                            (if (= (cdr (assoc 0 attent)) "ATTRIB")
                              (progn
                                (setq atttag (strcase (cdr (assoc 2 attent))))
                                (if (member atttag srcatt)
                                  (foreach itm lst
                                    (if (= atttag (car itm))
                                      (progn
                                        (setq attent (subst (cons 1 (cadr itm))(assoc 1 attent) attent))
                                        (entmod attent)
                                        (setq blkchg T)
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                          (if (= blkchg T)
                            (entupd blkhnd)
                          )
                        )
                      )
                    )
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Copy Attributes to Selection Set
; --------------------------------------------------------------------------

(defun c:BlkAttCpy ( / lst done obj hnd ent nam val chm ctr sset num itm
                         blkhnd blkent blklay blkchg atthnd attent blkchg
                         rec atttag cmdecho)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      ;
      ; --- loop and build list on choose source attributes
      ;
      (setq lst nil)
      (setq done nil)
      (while (/= done T)
        (princ "\nDS> Select Attribute(s) to Copy ... ")
        (setq obj (nentsel ""))
        (if (/= obj nil)
          (progn
            (setq hnd (car obj))
            (setq ent (entget hnd)) 
            (if (= (cdr (assoc 0 ent)) "ATTRIB")
              (progn
                (setq nam (cdr (assoc 2 ent)))
                (setq val (cdr (assoc 1 ent)))
                (setq lst (append lst (list (list hnd nam val))))
                (redraw hnd 3)
                (princ (strcat "[" nam "] = [" val "]"))
              )
            )
          )
          (setq done T)
        )
      )
      ; 
      ; --- choose selection, loop and change chosen attributes
      ;
      (princ "\nDS> Select Block(s) to Acquire Attributes")
      (setq chm 0 ctr 0)
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset 
        (progn
          (setq num (sslength sset) itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq blkhnd (ssname sset itm))
            (setq blkent (entget blkhnd))
            (setq blklay (cdr (assoc 8 blkent)))
            (setq blkchg nil)
            (setq atthnd blkhnd)
            (setq attent blkent)
            (while (/= "SEQEND" (cdr (assoc 0 attent)))
              (setq atthnd (entnext atthnd))
              (setq attent (entget atthnd))
              (if (= (cdr (assoc 0 attent)) "ATTRIB")
                (progn
                  (setq atttag (strcase (cdr (assoc 2 attent))))
                  (foreach rec lst
                    (if (= (strcase (cadr rec)) atttag)
                      (progn
                        (setq blkchg T)
                        (setq attent (subst (cons 1 (caddr rec))(assoc 1 attent) attent))
                        (entmod attent)
                      )
                    )
                  )
                )
              )
            )
            (if (= blkchg T)(entupd blkhnd))
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
        (alert "No blocks found")
      )
      (foreach rec lst 
        (redraw (car rec) 4)
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Explode Attributes to Text
; --------------------------------------------------------------------------

(defun c:BlkAttExp ( / addto attent atthnd attopt attrec blkent blkhnd
                         blklay blkupd chk cmdecho dcl_id dolst doproc eed
                         itm newblk newtxt num pass plcopt prcinv red retpar
                         sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I" '((0 . "INSERT") (66 . 1))))
      (if (= sset nil)
        (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      )
      (if sset
        (progn
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
              (setq sset (car chk))
              (sssetfirst nil sset)
              (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Object(s) Removed"))
            )
          )
          (setq plcopt (dstp_regfetch "BlockExp" "plcopt" "1"))
          (setq attopt (dstp_regfetch "BlockExp" "attopt" "1"))
          (setq attrec (dstp_regfetch "BlockExp" "attrec" "1"))
          (setq prcinv (dstp_regfetch "BlockExp" "prcinv" "1"))
          (setq retpar (dstp_regfetch "BlockExp" "retpar" "1"))
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog "blkattex" dcl_id)) (exit))
          (cond
            ((= plcopt "1")(set_tile "plcorg" "1"))
            ((= plcopt "2")(set_tile "plcins" "1"))
            ((= plcopt "3")(set_tile "plccur" "1"))
          )
          (cond
            ((= attopt "1")(set_tile "attkep" "1"))
            ((= attopt "2")(set_tile "attemp" "1"))
            ((= attopt "3")(set_tile "attrem" "1"))
          )
          (set_tile "attrec" attrec)
          (set_tile "prcinv" prcinv)
          (set_tile "retpar" retpar)
          (action_tile "plcorg" "(setq plcopt \"1\")")
          (action_tile "plcins" "(setq plcopt \"2\")")
          (action_tile "plccur" "(setq plcopt \"3\")")
          (action_tile "attkep" "(setq attopt \"1\")")
          (action_tile "attemp" "(setq attopt \"2\")")
          (action_tile "attrem" "(setq attopt \"3\")")
          (action_tile "attrec" "(setq attrec $value)")
          (action_tile "prcinv" "(setq prcinv $value)")
          (action_tile "retpar" "(setq retpar $value)")
          (action_tile "accept" "(setq doproc T)(done_dialog 0)")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
          (action_tile "help" "(dstp_showhelp \"BlkAttExp.htm\")")
          (if (equal (start_dialog) 1)
            (unload_dialog dcl_id)
          )
          (if (= doproc T)
            (progn
              (dstp_regstore "BlockExp" "plcopt" plcopt)
              (dstp_regstore "BlockExp" "attopt" attopt)
              (dstp_regstore "BlockExp" "attrec" attrec)
              (dstp_regstore "BlockExp" "prcinv" prcinv)
              (dstp_regstore "BlockExp" "retpar" retpar)
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (if (= attrec "1")
                (if (null (tblsearch "APPID" "DSTP_ATTRCL"))
                  (regapp "DSTP_ATTRCL")
                )
              )
              (setq num (sslength sset) itm 0)
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq red nil)
                (setq blkupd nil)
                (setq blkhnd (ssname sset itm))
                (setq blkent (entget blkhnd))
                (setq blklay (cdr (assoc 8 blkent)))
                (setq atthnd blkhnd)
                (setq attent blkent)
                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                  (setq atthnd (entnext atthnd))
                  (setq attent (entget atthnd))
                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                    (progn
                      ;
                      ;--- build & create new text string
                      ;
                      (setq pass T)
                      (if (= (cdr (assoc 1 attent)) "")
                        (setq pass nil)
                      )
                      (if (= prcinv "0")
                        (if (= (boole 1 (cdr (assoc 70 attent)) 1) 1)
                          (setq pass nil)
                        )
                      )
                      (if (= pass T)
                        (progn
                          (setq newtxt '((0 . "TEXT")))
                          (setq dolst (list 1 7 8 10 11 39 40 41 50 51 62 71 73))
                          (foreach grp dolst
                            (setq addto (assoc grp attent))
                            (if (/= addto nil)
                              (setq newtxt (append newtxt (list (assoc grp attent))))
                            )
                          )
                          (cond
                            ((= plcopt "2") ; Insert
                              (setq newtxt (subst (cons 8 blklay)(assoc 8 newtxt) newtxt))
                            )
                            ((= plcopt "3") ; Current
                              (setq newtxt (subst (cons 8 (getvar "CLAYER"))(assoc 8 newtxt) newtxt))
                            )
                          )
                          (if (= attrec "1")
                            (progn
                              (setq eed (list -3 (list "DSTP_ATTRCL" (cons 1005 (cdr (assoc 5 attent))))))
                              (setq newtxt (append newtxt (list eed)))
                            )
                          )
                          (entmake newtxt)
                          (setq red (append red (list (entlast))))
                        )
                      )
                      ;
                      ;--- handle old attribute
                      ;
                      (if (= attopt "2") ; Empty
                        (progn
                          (setq attent (subst (cons 1 "")(assoc 1 attent) attent))
                          (entmod attent)
                          (setq blkupd T)
                        )
                      )
                    )
                  )
                )
                ;
                ;--- erase, rebuild/insert basic block
                ;
                (if (= retpar "1") ; Retain Parent
                  (progn
                    (if (= attopt "3") ; Remove
                      (progn
                        (entdel blkhnd)
                        (setq newblk '((0 . "INSERT")(66 . 0)))
                        (setq dolst (list 2 8 10 41 42 43 50 70 71 44 45 -3))
                        (foreach grp dolst
                          (setq addto (assoc grp blkent))
                          (if (/= addto nil)
                            (setq newblk (append newblk (list (assoc grp blkent))))
                          )
                        )
                        (entmake newblk) 
                      )
                    )
                  )
                  (entdel blkhnd)
                )
                ;
                ;--- do necessary redraws
                ;
                (if (= blkupd T)
                  (entupd blkhnd)
                )
                (foreach txt red
                  (redraw txt)
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
              (setq sset nil)
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Select Inserts By Attributes
; --------------------------------------------------------------------------

(defun c:BlkSelVal () (dstp_blkattcom "br"))
(defun c:BlkSelStr () (dstp_blkattcom "bs"))
(defun dstp_blkattcom (opt / attent atthnd attstr atttag attval blkchg blkent
                             blkflt blkhnd blklay cmdecho doproc grp highlight
                             ind inrng itm maxv minv mset num rngset srcstr
                             srcwrd sset tlst tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Blocks to Process ...")
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset
        (progn
          (setq doproc T)
          (setq ind (dstp_regfetch "BlokTool" "procindtag" "N"))
          (initget "Y N")
          (cond
            ((= ind "N")
              (setq tmp (getkword "\nDS> Process Individual Tags Y/<N>: "))
            )
            ((= ind "Y")
              (setq tmp (getkword "\nDS> Process Individual Tags <Y>/N: "))
            )
          )
          (if (/= tmp nil)(setq ind tmp))
          (dstp_regstore "BlokTool" "procindtag" ind)
          (if (= ind "Y")
            (progn
              (setq tlst (dstp_attlst sset))
              (if (> (length tlst) 0)
                (progn
                  (setq tlst (acad_strlsort tlst))
                  (setq tlst (dstp_tablesel "Select Tag(s) to Process" tlst "m" ""))
                  (if (= tlst nil)
                    (setq doproc nil)
                  )
                )
              )
            )
          )
          (if (= doproc T)
            (progn
              (cond
                ((= opt "br") ; --- build selection set by range
                  (setq minv (getstring "\nDS> Minimum Value to include <1>: "))
                  (if (= minv "")(setq minv "1"))
                  (setq maxv (getstring "\nDS> Maximum Value to include <1.0E+09>: "))
                  (if (= maxv "")(setq maxv "999999999"))
                )
                ((= opt "bs") ; --- build selection set by string search
                  (setq srcstr (getstring "\nDS> Search String: "))
                  (initget "Y N")
                  (setq srcwrd (getkword "\nDS> Whole Word Only Y/<N>: "))
                  (if (= srcwrd nil)(setq srcwrd "N"))
                )
                (t nil)
              )
              (princ "\nDS>")
              (setq rngset (ssadd)) ; inital range selection
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (if (= grp T)
                  (setq mset (ssadd))
                )
                (setq blkhnd (ssname sset itm))
                (setq blkent (entget blkhnd))
                (setq blklay (cdr (assoc 8 blkent)))
                (setq atthnd blkhnd)
                (setq attent blkent)
                (setq blkflt nil)
                (setq inrng nil)
                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                  (setq atthnd (entnext atthnd))
                  (setq attent (entget atthnd))
                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                    (progn
                      (setq doproc T)
                      (if (= ind "Y")
                        (progn
                          (setq atttag (strcase (cdr (assoc 2 attent))))
                          (if (not (member atttag tlst))
                            (setq doproc nil)
                          )
                        )
                      )
                      (if (= doproc T)
                        (progn
                          (setq blkchg nil)
                          (cond 
                            ((= opt "br")
                              (if (= inrng nil)
                                (progn
                                  (setq attstr (cdr (assoc 1 attent)))
                                  (setq attval (atof attstr))
                                  (if (and (>= attval (atof minv))(<= attval (atof maxv)))
                                    (setq inrng T)
                                    (setq inrng nil)
                                  )
                                )
                              )
                            )
                            ((= opt "bs")
                              (if (= inrng nil)
                                (progn
                                  (setq attstr (cdr (assoc 1 attent)))
                                  (if (= srcwrd "Y")
                                    (progn
                                      (if (= (strcase attstr)(strcase srcstr))
                                        (setq inrng T)
                                        (setq inrng nil)
                                      )
                                    )
                                    (progn
                                      (if (wcmatch (strcase attstr)(strcase (strcat "*" srcstr "*")))
                                        (setq inrng T)
                                        (setq inrng nil)
                                      )
                                    )
                                  )
                                )
                              )
                            )
                            (t nil)
                          )
                          (if (= blkchg T)
                            (entmod attent)
                          )
                        )
                      )
                    )
                  )
                )
                (if (= inrng T)
                  (setq rngset (ssadd blkhnd rngset))
                )
                (if (= blkchg T)(entupd blkhnd))
                (if (= blkflt T)(dstp_dofloat blkhnd))
                (if (= grp T)
                  (progn
                    (setq mset (ssadd (entlast) mset))
                    (setq highlight (getvar "HIGHLIGHT"))
                    (setvar "HIGHLIGHT" 0)
                    (command "_.-GROUP" "" "*" "" mset "")
                    (setvar "HIGHLIGHT" highlight)
                    (setq mset nil)
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
            )
          )
        )
        (alert "No blocks found")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (if (/= rngset nil)
        (if (> (sslength rngset) 0)
          (progn
            (command "_.SELECT" rngset "")
            (sssetfirst rngset rngset)
            (princ (strcat "\nDS> Total of " (rtos (sslength rngset) 2 0) " Inserts Found and Selected."))
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Change Properties in SelSet Blocks
; --------------------------------------------------------------------------

(defun c:BlkAttPrp ( / addto attent atthnd atttag attval blkchg blkent blkflt
                       blkhnd blklay chk cmdecho col cr cs dolst doproc grp
                       highlight ind inrng itm lay mset newblk nr ns num nw
                       oa one opt pass ra rngset sf sset tgf tlst tmp two)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "B C L H N O R S U V W")
      (setq one (getkword "\nDS> Backwards/Color/Delete/Layer/liNe/Height/Oblique/Rotate/Style/Upsidedown/Visibility/Width: "))
      (cond
        ((= one "C")(setq two "O"))
        ((= one "D")(setq two "E"))
        ((= one "L")(setq two "A"))
        ((= one "H")
          (initget "A S")
          (setq two (getkword "\nDS> Assign/Scale: "))
        )
        ((= one "N")
          (initget "O U")
          (setq two (getkword "\nDS> Over/Under: "))
        )
        ((= one "O")(setq two "A"))
        ((= one "R")
          (initget "A R")
          (setq two (getkword "\nDS> Absolute/Relative: "))
        )
        ((= one "S")(setq two "S"))
        ((= one "W")(setq two "S"))
        (t
          (initget "O F")
          (setq two (getkword "\nDS> On/oFf: "))
        )
      )
      (if (and (/= one nil)(/= two nil))
        (progn
          (setq opt (strcat one two))
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (princ "\nDS> Select Blocks to Process ...")
          (setq sset (ssget '((0 . "INSERT") (66 . 1))))
          (if sset
            (progn
              (if (= opt "DE")
                (progn
                  (initget "Y N")
                  (setq chk (getkword "\nDS> Completely Remove Attribute Slot Y/<N>: "))
                  (if (= chk "Y")
                    (progn
                      (setq num (sslength sset) itm 0)
                      (princ "\nDS>")
                      (while (< itm num)
                        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                        (setq blkhnd (ssname sset itm))
                        (setq blkent (entget blkhnd))
                        (entdel blkhnd)
                        (setq newblk '((0 . "INSERT")(66 . 0)))
                        (setq dolst (list 2 8 10 41 42 43 50 70 71 44 45 -3))
                        (foreach grp dolst
                          (setq addto (assoc grp blkent))
                          (if (/= addto nil)
                            (setq newblk (append newblk (list (assoc grp blkent))))
                          )
                        )
                        (entmake newblk) 
                        (setq itm (1+ itm))
                      )
                      (princ ", Done.")
                      (setq pass nil)
                    )
                    (setq pass T)
                  )
                )
                (setq pass T)
              )
              (if (= pass T)
                (progn
                  (setq doproc T)
                  (setq ind (dstp_regfetch "BlokTool" "procindtag" "N"))
                  (initget "Y N")
                  (cond
                    ((= ind "N")
                      (setq tmp (getkword "\nDS> Process Individual Tags Y/<N>: "))
                    )
                    ((= ind "Y")
                      (setq tmp (getkword "\nDS> Process Individual Tags <Y>/N: "))
                    )
                  )
                  (if (/= tmp nil)(setq ind tmp))
                  (dstp_regstore "BlokTool" "procindtag" ind)
                  (if (= ind "Y")
                    (progn
                      (setq tlst (dstp_attlst sset))
                      (if (> (length tlst) 0)
                        (progn
                          (setq tlst (acad_strlsort tlst))
                          (setq tlst (dstp_tablesel "Select Tag(s) to Process" tlst "m" ""))
                          (if (= tlst nil)
                            (setq doproc nil)
                          )
                        )
                      )
                    )
                  )
                  (if (= doproc T)
                    (progn
                      (cond
                        ((= opt "CO")
                          (setq col (dstp_str2col (getvar "CECOLOR")))
                          (if (= col nil)(setq col 256))
                          (setq tmp (acad_colordlg col))
                          (if (= tmp nil)(exit))
                          (setq col (dstp_col2str tmp))
                        )
                        ((= opt "HA")
                          (setq ns (getreal "\nDS> New Text Size: "))
                          (if (= ns nil)(exit))
                        )
                        ((= opt "HS")
                          (setq sf (getreal "\nDS> Scale Factor: "))
                          (if (= sf nil)(exit))
                        )
                        ((= opt "LA")
                          (setq tmp (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
                          (if (= tmp nil)(exit))
                          (setq lay tmp)
                        )
                        ((= opt "OA")
                          (setq oa (getreal "\nDS> New Oblique Angle: "))
                          (if (= oa nil)(exit))
                        )
                        ((= opt "RA")
                          (setq ra (getreal "\nDS> Absolute Rotation Angle: "))
                          (if (= ra nil)(exit))
                        )
                        ((= opt "RR")
                          (setq ra (getreal "\nDS> Relative Rotation Angle: "))
                          (if (= ra nil)(exit))
                        )
                        ((= opt "SS")
                          (setq ns (dstp_tablesel "Select Desired Style" (acad_strlsort (dstp_bldlst "STYLE")) "s" ""))
                          (if (= ns nil)(exit))
                        )
                        ((= opt "WS")
                          (setq nw (getreal "\nDS> New Width Factor: "))
                          (if (= nw nil)(exit))
                        )
                        (t nil)
                      )
                      (princ "\nDS>")
                      (setq rngset (ssadd)) ; inital range selection
                      (setq num (sslength sset) itm 0)
                      (while (< itm num)
                        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                        (if (= grp T)
                          (setq mset (ssadd))
                        )
                        (setq blkhnd (ssname sset itm))
                        (setq blkent (entget blkhnd))
                        (setq blklay (cdr (assoc 8 blkent)))
                        (setq atthnd blkhnd)
                        (setq attent blkent)
                        (setq blkflt nil)
                        (setq inrng nil)
                        (while (/= "SEQEND" (cdr (assoc 0 attent)))
                          (setq atthnd (entnext atthnd))
                          (setq attent (entget atthnd))
                          (if (= (cdr (assoc 0 attent)) "ATTRIB")
                            (progn
                              (setq doproc T)
                              (if (= ind "Y")
                                (progn
                                  (setq atttag (strcase (cdr (assoc 2 attent))))
                                  (if (not (member atttag tlst))
                                    (setq doproc nil)
                                  )
                                )
                              )
                              (if (= doproc T)
                                (progn
                                  (setq blkchg nil)
                                  (cond 
                                    ((= opt "BF")
                                      (setq tgf (cdr (assoc 71 attent)))
                                      (if (= (boole 1 tgf 2) 2)
                                        (progn
                                          (setq tgf (- tgf 2))
                                          (setq attent (subst (cons 71 tgf)(assoc 71 attent) attent))
                                          (setq blkchg T)
                                        )
                                      )
                                    )
                                    ((= opt "BO")
                                      (setq tgf (cdr (assoc 71 attent)))
                                      (if (/= (boole 1 tgf 2) 2)
                                        (progn
                                          (setq tgf (+ tgf 2))
                                          (setq attent (subst (cons 71 tgf)(assoc 71 attent) attent))
                                          (setq blkchg T)
                                        )
                                      )
                                    )
                                    ((= opt "CO")
                                      (if (= (assoc 62 attent) nil)
                                        (setq attent (append attent (list (cons 62 (dstp_str2col col)))))
                                        (setq attent (subst (cons 62 (dstp_str2col col))(assoc 62 attent) attent))
                                      )
                                      (setq blkchg T)
                                    )
                                    ((= opt "DE")
                                      (setq attent (subst (cons 1 "")(assoc 1 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "LA")
                                      (setq attent (subst (cons 8 lay)(assoc 8 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "NO")
                                      (setq attval (cdr (assoc 1 attent)))
                                      (setq attval (strcat "%%o" attval "%%o"))
                                      (setq attent (subst (cons 1 attval)(assoc 1 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "NU")
                                      (setq attval (cdr (assoc 1 attent)))
                                      (setq attval (strcat "%%u" attval "%%u"))
                                      (setq attent (subst (cons 1 attval)(assoc 1 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "OA")
                                      (setq attent (subst (cons 51 (dstp_dtr oa))(assoc 51 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "RA")
                                      (setq nr (dstp_dtr ra))
                                      (setq attent (subst (cons 50 nr)(assoc 50 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "RR")
                                      (setq cr (cdr (assoc 50 attent)))
                                      (setq nr (+ cr (dstp_dtr ra)))
                                      (setq attent (subst (cons 50 nr)(assoc 50 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "HA")
                                      (setq attent (subst (cons 40 ns)(assoc 40 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "HS")
                                      (setq cs (cdr (assoc 40 attent)))
                                      (setq ns (* cs sf))
                                      (setq attent (subst (cons 40 ns)(assoc 40 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "SS")
                                      (setq attent (subst (cons 7 ns)(assoc 7 attent) attent))
                                      (setq blkchg T)
                                    )
                                    ((= opt "UF")
                                      (setq tgf (cdr (assoc 71 attent)))
                                      (if (= (boole 1 tgf 4) 4)
                                        (progn
                                          (setq tgf (- tgf 4))
                                          (setq attent (subst (cons 71 tgf)(assoc 71 attent) attent))
                                          (setq blkchg T)
                                        )
                                      )
                                    )
                                    ((= opt "UO")
                                      (setq tgf (cdr (assoc 71 attent)))
                                      (if (/= (boole 1 tgf 4) 4)
                                        (progn
                                          (setq tgf (+ tgf 4))
                                          (setq attent (subst (cons 71 tgf)(assoc 71 attent) attent))
                                          (setq blkchg T)
                                        )
                                      )
                                    )
                                    ((= opt "VO")
                                      (setq tmp (cdr (assoc 70 attent)))
                                      (if (= (boole 1 tmp 1) 1)
                                        (progn
                                          (setq tmp (- tmp 1))
                                          (setq attent (subst (cons 70 tmp)(assoc 70 attent) attent))
                                          (setq blkchg T)
                                        )
                                      )
                                    )
                                    ((= opt "VF")
                                      (setq tmp (cdr (assoc 70 attent)))
                                      (if (/= (boole 1 tmp 1) 1)
                                        (progn
                                          (setq tmp (+ tmp 1))
                                          (setq attent (subst (cons 70 tmp)(assoc 70 attent) attent))
                                          (setq blkchg T)
                                        )
                                      )
                                    )
                                    ((= opt "WS")
                                      (setq attent (subst (cons 41 nw)(assoc 41 attent) attent))
                                      (setq blkchg T)
                                    )
                                    (t nil)
                                  )
                                  (if (= blkchg T)
                                    (entmod attent)
                                  )
                                )
                              )
                            )
                          )
                        )
                        (if (= inrng T)
                          (setq rngset (ssadd blkhnd rngset))
                        )
                        (if (= blkchg T)(entupd blkhnd))
                        (if (= blkflt T)(dstp_dofloat blkhnd))
                        (if (= grp T)
                          (progn
                            (setq mset (ssadd (entlast) mset))
                            (setq highlight (getvar "HIGHLIGHT"))
                            (setvar "HIGHLIGHT" 0)
                            (command "_.-GROUP" "" "*" "" mset "")
                            (setvar "HIGHLIGHT" highlight)
                            (setq mset nil)
                          )
                        )
                        (setq itm (1+ itm))
                      )
                      (princ ", Done.")
                    )
                  )
                )
              )
            )
            (alert "No blocks found")
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (if (/= rngset nil)
            (if (> (sslength rngset) 0)
              (progn
                (command "_.SELECT" rngset "")
                (sssetfirst rngset rngset)
                (princ (strcat "\nDS> Total of " (rtos (sslength rngset) 2 0) " Inserts Found and Selected."))
              )
            )
          )
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Recall Text Exploded from Attributes
; --------------------------------------------------------------------------

(defun c:BlkAttRec ( / attent atthnd blkhnd chk cmdecho ent hnd itm num
                         sset updlst val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget '((0 . "TEXT") (-3 ("DSTP_ATTRCL")))))
      (princ "\nDS>")
      (setq updlst nil)
      (setq num (sslength sset) itm 0)
      (while (< itm num)
        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (setq hnd (ssname sset itm))
        (setq ent (entget hnd '("DSTP_ATTRCL")))
        (setq chk (assoc -3 ent))
        (if (/= chk nil)
          (progn
            (setq val (cdr (cadr (car (cdr chk)))))
            (setq atthnd (handent val))
            (if (/= atthnd nil)
              (progn
                (setq attent (entget atthnd))
                (if (= (cdr (assoc 0 attent)) "ATTRIB")
                  (progn
                    (setq attent (subst (cons 1 (cdr (assoc 1 ent)))(assoc 1 attent) attent))
                    (entmod attent)
                    (entdel hnd)
                    (while (/= (cdr (assoc 0 attent)) "SEQEND")
                      (setq atthnd (entnext atthnd))
                      (setq attent (entget atthnd))
                    )
                    (setq blkhnd (cdr (assoc -2 attent)))
                    (if (not (member blkhnd updlst))
                      (setq updlst (append updlst (list blkhnd)))
                    )
                  )
                )
              )
            )
          )
        )
        (setq itm (1+ itm))
      )
      (princ ", Done.")
      ;
      ; --- update display of blocks involved
      ;
      (setq num (length updlst))
      (if (> num 0)
        (progn
          (setq itm 0)
          (princ "\nDS>")
          (foreach rec updlst
            (princ (strcat "\rDS> Updating Display of Block " (itoa (1+ itm)) " of " (itoa num)))
            (entupd rec)
            (setq itm (1+ itm))
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Export Attribute Data to File
; --------------------------------------------------------------------------

(defun c:BlkDatExp ( / $value add attflw attlst atttag attval chk cmdecho
                         cnt ctr dcl_id done doproc ent fh hnd itm msg num
                         nxtent nxthnd optitm optlst optsel outfil outhdr
                         outlst outquo res resitm reslst sset tmp uct)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun blkattxp_updlst ()
        (start_list "optlst")
        (mapcar 'add_list optlst)
        (end_list)
        (start_list "outlst")
        (mapcar 'add_list outlst)
        (end_list)
      )
      ;
      ; --- select or deselect all in options
      ;
      (defun blkattxp_lstcon (op / inc lat)
        (if (= op 0)
          (set_tile "optlst" "")
          (progn
            (setq inc 0)
            (setq lat "")
            (repeat (length optlst)
              (setq lat (strcat lat (rtos inc 2 0) " "))
              (setq inc (1+ inc))
            )
            (set_tile "optlst" lat)
          )
        )
      )
      ;
      ; --- move fields over to output
      ;
      (defun blkattxp_movert ()
        (setq uct 1)
        (setq reslst nil)
        (setq optsel (get_tile "optlst"))
        (while (setq optitm (read optsel))
          (setq resitm (nth optitm optlst))
          (setq reslst (append reslst (list resitm)))
          (while (and (/= " " (substr optsel uct 1))
            (/= "" (substr optsel uct 1)))
            (setq uct (1+ uct))
          )
          (setq optsel (substr optsel uct))
        )
        (foreach itm reslst
          (setq outlst (append outlst (list itm)))
        )
        (setq tmp nil)
        (foreach itm optlst
          (if (not (member itm reslst))
            (setq tmp (append tmp (list itm)))
          )
        )
        (setq optlst tmp)
        (blkattxp_updlst)
        (setq tmp nil)
        (setq optsel nil)
        (setq reslst nil)
      )
      ;
      ; --- move fields back to options
      ;
      (defun blkattxp_movelt ()
        (setq uct 1)
        (setq reslst nil)
        (setq optsel (get_tile "outlst"))
        (while (setq optitm (read optsel))
          (setq resitm (nth optitm outlst))
          (setq reslst (append reslst (list resitm)))
          (while (and (/= " " (substr optsel uct 1))
            (/= "" (substr optsel uct 1)))
            (setq uct (1+ uct))
          )
          (setq optsel (substr optsel uct))
        )
        (foreach itm reslst
          (setq optlst (append optlst (list itm)))
        )
        (if (> (length optlst) 0)
          (setq optlst (acad_strlsort optlst))
        )
        (setq tmp nil)
        (foreach itm outlst
          (if (not (member itm reslst))
            (setq tmp (append tmp (list itm)))
          )
        )
        (setq outlst tmp)
        (blkattxp_updlst)
        (setq tmp nil)
        (setq optsel nil)
        (setq reslst nil)
      )
      ;
      ; --- preprocess selset to build options
      ;
      (defun blkattxp_preproc ()
        (princ "\nDS> Select Blocks to Process ...")
        (setq sset (ssget '((0 . "INSERT"))))
        (if sset
          (progn
            (setq attlst nil)
            (setq num (sslength sset) itm 0)
            (while (< itm num)
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd))
              (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
              (setq tmp (assoc 66 ent))
              (if (= tmp nil)
                (setq attflw nil)
                (progn
                  (if (/= (cdr tmp) nil)
                    (setq attflw T)
                  )
                )
              )
              (if (= attflw T)
                (progn
                  (setq nxthnd hnd)
                  (setq nxtent ent)
                  (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                    (setq nxthnd (entnext nxthnd))
                    (setq nxtent (entget nxthnd))
                    (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                      (progn
                        (setq atttag (strcase (cdr (assoc 2 nxtent))))
                        (if (not (member atttag attlst))
                          (setq attlst (append attlst (list atttag)))
                        )
                      )
                    )
                  )
                )
              )
              (setq itm (1+ itm))
            )
            (princ ", Done.")
          )
        )
      )
      ;
      ; --- check list and filename
      ;
      (defun blkattxp_docheck ()
        (setq msg "")
        (if (= outfil "")
          (setq msg "No Output File Specified!")
        )
        (if (= (length outlst) 0)
          (progn
            (setq add "No Output Fields Chosen!")
            (if (= msg "")
              (setq msg add)
              (setq msg (strcat msg "\n" add))
            )
          )
        )
        (if (/= msg "")
          (alert msg)
        )
      )
      ;
      ; --- Main Function
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (blkattxp_preproc)
      (setq outhdr "1")
      (setq outquo "0")
      (setq outfil (strcase (strcat (getvar "DWGPREFIX")(dstp_dwgname) ".CSV")))
      (princ "\n")
      ;
      ; --- load and run dialog
      ;
      (setq dcl_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "BlkDatExp" dcl_id)) (exit))
      ;
      (setq outlst nil)
      (setq optlst (list
         ".BLOCKNAME"
         ".INSPTX"
         ".INSPTY"
         ".INSPTZ"
         ".XSCALE"
         ".YSCALE"
         ".ZSCALE"
         ".ROTATION"
         ".COLOR"
         ".LAYER"
         ".LINETYPE"
         ".THICKNESS"
      ))
      (if (= (getvar "HANDLES") 1)
        (setq optlst (append optlst (list ".HANDLE")))
      )
      (if (/= attlst nil)
        (progn
          (setq optlst (append optlst attlst))
          (setq attlst nil)
        )
      )
      (blkattxp_updlst)
      (set_tile "outfil" outfil)
      (set_tile "outhdr" outhdr)
      (set_tile "outquo" outquo)
      (action_tile "optlst" "(set_tile \"outlst\" \"\")")
      (action_tile "selall" "(blkattxp_lstcon 1)")
      (action_tile "clrall" "(blkattxp_lstcon 0)")
      (action_tile "addlst" "(blkattxp_movert)")
      (action_tile "outlst" "(set_tile \"optlst\" \"\")")
      (action_tile "remlst" "(blkattxp_movelt)")
      (action_tile "outfil" "(setq outfil $value)")
      (action_tile "outhdr" "(setq outhdr $value)")
      (action_tile "outquo" "(setq outquo $value)")
      (action_tile "accept" "(blkattxp_docheck)(if (= msg \"\")(progn (setq doproc T)(done_dialog 0)))")
      (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
      (action_tile "help" "(dstp_showhelp \"BlkDatExp.htm\")")
      (if (equal (start_dialog) 1)
        (unload_dialog dcl_id)
      )
      ;
      ; --- Begin Processing Data
      ;
      (if (= doproc T)
        (progn
          (setq fh (open outfil "w"))
          (if (/= fh nil)
            (progn
              (setq ctr 0)
              (if (= outhdr "1")
                (foreach fld outlst
                  (if (= outquo "1")
                    (princ (strcat (chr 34) fld (chr 34)) fh)
                    (princ fld fh)
                  )
                  (setq ctr (+ ctr 1))
                  (if (< ctr (length outlst))
                    (princ dstp_csvchar fh)
                  )
                )
              )
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (setq attlst nil)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq tmp (assoc 66 ent))
                (if (= tmp nil)
                  (setq attflw nil)
                  (progn
                    (if (/= (cdr tmp) nil)
                      (setq attflw T)
                    )
                  )
                )
                (if (= attflw T)
                  (progn
                    (setq nxthnd hnd)
                    (setq nxtent ent)
                    (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                      (setq nxthnd (entnext nxthnd))
                      (setq nxtent (entget nxthnd))
                      (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                        (progn
                          (setq atttag (strcase (cdr (assoc 2 nxtent))))
                          (setq attval (cdr (assoc 1 nxtent)))
                          (setq attlst (append attlst (list (list atttag attval))))
                        )
                      )
                    )
                  )
                )
                ;
                (setq ctr 0)
                (princ "\n" fh)
                (foreach fld outlst
                  (setq res "")
                  (cond
                    ((= fld ".BLOCKNAME")
                      (setq res (cdr (assoc 2 ent)))
                    )
                    ((= fld ".INSPTX")
                      (setq res (rtos (nth 1 (assoc 10 ent)) 2 8))
                    )
                    ((= fld ".INSPTY")
                      (setq res (rtos (nth 2 (assoc 10 ent)) 2 8))
                    )
                    ((= fld ".INSPTZ")
                      (setq res (rtos (nth 3 (assoc 10 ent)) 2 8))
                    )
                    ((= fld ".XSCALE")
                      (setq res (rtos (cdr (assoc 41 ent)) 2 8))
                    )
                    ((= fld ".YSCALE")
                      (setq res (rtos (cdr (assoc 42 ent)) 2 8))
                    )
                    ((= fld ".ZSCALE")
                      (setq res (rtos (cdr (assoc 43 ent)) 2 8))
                    )
                    ((= fld ".ROTATION")
                      (setq res (rtos (dstp_rtd (cdr (assoc 50 ent))) 2 8))
                    )
                    ((= fld ".COLOR")
                      (if (/= (cdr (assoc 62 ent)) nil)
                        (setq res (itoa (cdr (assoc 62 ent))))
                        (setq res "BYLAYER")
                      )
                    )
                    ((= fld ".LAYER")
                      (setq res (cdr (assoc 8 ent)))
                    )
                    ((= fld ".LINETYPE")
                      (if (/= (cdr (assoc 6 ent)) nil)
                        (setq res (cdr (assoc 6 ent)))
                        (setq res "BYLAYER")
                      )
                    )
                    ((= fld ".THICKNESS")
                      (if (/= (cdr (assoc 39 ent)) nil)
                        (setq res (rtos (cdr (assoc 39 ent)) 2 8))
                        (setq res "0.00000000")
                      )
                    )
                    ((= fld ".HANDLE")
                      (setq res (cdr (assoc 5 ent)))
                      (setq res (strcat "'" res)) ; prevent 13E4
                    )
                    (t
                      (if (> (length attlst) 0)
                        (progn
                          (setq cnt 0)
                          (setq done nil)
                          (while (/= done T)
                            (setq chk (nth cnt attlst))
                            (if (= (car chk) fld)
                              (progn
                                (setq res (cadr chk))
                                (setq done T)
                              )
                            )
                            (setq cnt (+ cnt 1))
                            (if (= cnt (length attlst))
                              (setq done T)
                            )
                          )
                        )
                      )
                    )
                  )
                  (if (= outquo "1")
                    (princ (strcat (chr 34) res (chr 34)) fh)
                    (princ res fh)
                  )
                  (setq ctr (+ ctr 1))
                  (if (< ctr (length outlst))
                    (princ dstp_csvchar fh)
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
              (close fh)
            )
          )
        )
      )
      (setq attlst nil)
      (setq reslst nil)
      (setq optlst nil)
      (setq outlst nil)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ###########################################################################
;                                    CONVTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                     Convert Stack of TEXT to MTEXT
; --------------------------------------------------------------------------

(defun c:CnvTxtSta ( / mwid dset ibrk bitm bent sset rect mlay mcol mlst
                         bins bang tang nins num ndis chnd cent nhnd nstr
                         str pt1 pt2 pt3 dis dvx dvy dvz new)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq mwid 0.0)
      (setq dset (ssadd))
      (initget "Y N")
      (setq tmp (getkword "\nDS> Include Line Breaks <Y>/N: "))
      (if (/= tmp "N")(setq ibrk "Y")(setq ibrk "N"))
      (setq bitm (car (entsel "\nDS> Pick Base String: ")))
      (setq bent (entget bitm))
      (setq rect (dstp_textrect bent))
      (setq chk (distance (car rect)(cadr rect)))
      (if (> chk mwid)(setq mwid chk))
      (if (= "TEXT" (cdr (assoc 0 bent))) 
        (progn
          (redraw bitm 3)
          (princ "\nDS> Select Remaining Text: ")
          (setq sset (ssget '((0 . "TEXT"))))
          (if sset
            (progn
              (setq rect (dstp_textrect bent))
              (setq orig rect)
              (setq mlay (cdr (assoc 8 bent)))
              (setq mcol (cdr (assoc 62 bent)))
              (setq mlst (list (cdr (assoc 1 bent))))
              (if (> (cdr (assoc 72 bent)) 0)
                (setq bins (cdr (assoc 11 bent)))
                (setq bins (cdr (assoc 10 bent)))
              )
              (setq bang (cdr (assoc 50 bent)))
              (setq tang (- bang (/ PI 2)))
              (setq nins bins)
              (ssdel bitm sset)
              (while (> (sslength sset) 0)
                (setq num (sslength sset) itm 0)
                (setq ndis 99999999.9)
                (while (< itm num)
                  (setq chnd (ssname sset itm))
                  (setq cent (entget chnd))
                  (if (> (cdr (assoc 72 cent)) 0)
                    (setq cins (cdr (assoc 11 cent)))
                    (setq cins (cdr (assoc 10 cent)))
                  )
                  (setq cdis (distance bins cins))
                  (if (< cdis ndis)
                    (setq ndis cdis nhnd chnd nent cent)
                  )
                  (setq itm (1+ itm))
                )
                (setq dset (ssadd nhnd dset))
                (ssdel nhnd sset)
                (setq rect (dstp_textrect nent))
                (setq chk (distance (car rect)(cadr rect)))
                (if (> chk mwid)(setq mwid chk))
                (setq nstr (cdr (assoc 1 nent)))
                (setq mlst (append mlst (list nstr)))
              )
              (entdel bitm)
              (setq num (sslength dset) itm 0)
              (while (< itm num)
                (setq hnd (ssname dset itm))
                (entdel hnd)
                (setq itm (1+ itm))
              )
              (dstp_savprop)
              (setvar "CLAYER" mlay)
              (if (/= mcol nil)
                (setvar "CECOLOR" (dstp_col2str mcol))
              )
              (setq mwid (+ mwid (* mwid 0.025)))
              (setq pt1 (car orig))
              (setq pt2 (cadr orig))
              (setq dis (distance pt1 pt2))
              (setq dvx (/ (- (car pt2)(car pt1)) dis))
              (setq dvy (/ (- (cadr pt2)(cadr pt1)) dis))
              (setq pt3 (list dvx dvy 0.0))
              (setq nins (list (car (cadddr orig)) (cadr (cadddr orig)) (nth 2 (cdr (assoc 10 bent)))))
              (setq new '((0 . "MTEXT")(100 . "AcDbEntity")(100 . "AcDbMText")))
              (setq new (append new (list (assoc 7 bent))))
              (setq new (append new (list (assoc 8 bent))))
              (setq new (append new (list (cons 10 nins))))
              (setq new (append new (list (cons 11 pt3))))
              (foreach lin mlst
                (if (and (= (strcase (substr lin 1 3)) "%%U")(= (strcase (substr lin (- (strlen lin) 2) 3)) "%%U"))
                  (setq lin (strcat "{\\L" (substr lin 4 (- (strlen lin) 6)) "}"))
                )
                (setq lin (dstp_subtext lin "%%u" ""))
                (setq lin (dstp_subtext lin "%%o" ""))
                (setq lin (dstp_subtext lin "%%%" "%"))
                (if (= ibrk "Y")
                  (if (/= lin (last mlst))
                    (setq lin (strcat lin "\\P"))
                  )
                  (setq lin (strcat lin " "))
                )
                (setq new (append new (list (cons 1 lin))))
              )
              (setq new (append new (list (assoc 40 bent))))
              (setq new (append new (list (cons 41 mwid))))
              (setq new (append new (list (cons 71 1))))
              (setq new (append new (list (cons 72 1))))
              (entmake new)
              (dstp_resprop)
              (setq sset nil)
              (setq dset nil)
              (setq lst nil)
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
            )
            (redraw bitm 4)
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;               Convert Groups Text to Mtext/Attribute
; --------------------------------------------------------------------------

(defun c:CnvTxtAmu () (dstp_cvgrptxt 2))
(defun c:CnvTxtMmu () (dstp_cvgrptxt 1))
(defun dstp_cvgrptxt (opt / attent atthnd attreq blkent blkhnd chk cmdecho
                            cnt cpt ctr dis done dset dvx dvy elv ent hlst
                            hnd ibrk jst lent lst mwid nam new nins oent
                            ohnd olayer osmode pnt proc pt1 pt2 pt3 pt4 pt5
                            pt6 ptx rect rot sset thnd tlst tmp tsel txt ump
                            used xsc ysc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq attreq (getvar "ATTREQ"))
      (setvar "ATTREQ" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq proc T)
      (if (= opt 1)
        (progn
          (initget "Y N")
          (setq tmp (getkword "\nDS> Include Line Breaks <Y>/N: "))
          (if (/= tmp "N")(setq ibrk "Y")(setq ibrk "N"))
        )
      )
      (if (= opt 2)
        (progn
          (setq lst (dstp_bldlst "BLOCK"))
          (if (/= lst nil)
            (progn
              (setq nam (dstp_tablesel "Select Local Block" (acad_strlsort lst) "s" ""))
              (if (/= nam "")
                (progn
                  (setq lst (dstp_attdef nam))
                  (if (/= lst nil)
                    (progn
                      (setq scl (atof (dstp_regfetch "Convert" "InsScl" "1.0")))
                      (setq tmp (getreal (strcat "\nDS> Insertion Scale <" (rtos scl 2 2) ">: ")))
                      (if (/= tmp nil)
                        (progn
                          (setq scl tmp)
                          (dstp_regstore "Convert" "InsScl" (rtos scl 2 4))
                        )
                      )
                    )
                    (progn
                      (princ "\nDS> Selected Block has no Attributes!")
                      (setq proc nil)
                    )
                  )
                )
              )
            )
            (progn
              (princ "\nDS> No Local Blocks Available!")
              (setq proc nil)
            )
          )
        )
      )
      (setq lhf (atof (dstp_regfetch "Convert" "HgtFac" "1.5")))
      (setq tmp (getdist (strcat "\nDS> Line Height Factor <" (rtos lhf 2 2) ">: ")))
      (if (/= tmp nil)
        (progn
          (setq lhf tmp)
          (dstp_regstore "Convert" "HgtFac" (rtos lhf 2 2))
        )
      )
      (if (= proc T)
        (progn
          (setq used 0)
          (setq nset (ssadd))
          (setq sset (ssget '((0 . "TEXT"))))
          (princ "\nDS> Please Wait ...\rDS> Please Wait ...")
          (setq tsel (sslength sset))
          (setq hlst (dstp_ss2lst sset))
          (while (> (length hlst) 0)
            (setq mwid 0.0)
            (setq ohnd (car hlst))
            (setq oent (entget ohnd))
            (setq lent oent)
            (setq tlst (list (cdr (assoc 1 oent))))
            (setq hlst (dstp_remove ohnd hlst))
            (setq dset (ssadd))
            (setq dset (ssadd ohnd dset))
            ;
            ; -- begin looking 'up' the list
            ;
            (setq done nil)
            (setq thnd ohnd)
            (while (/= done T)
              (setq hnd thnd)
              (setq ent (entget hnd))
              (if (/= ent nil)
                (progn
                  (setq rect (dstp_textrect ent))
                  (setq pt1 (nth 0 rect))
                  (setq pt2 (nth 1 rect))
                  (setq pt3 (nth 2 rect))
                  (setq pt4 (nth 3 rect))
                  (setq pt5 (polar pt1 (angle pt1 pt4) (* (distance pt1 pt4) lhf)))
                  (setq pt6 (polar pt2 (angle pt2 pt3) (* (distance pt2 pt3) lhf)))
                  (setq chk (distance (car rect)(cadr rect)))
                  (if (> chk mwid)(setq mwid chk))
                  (setq chk (ssget "_F" (list pt5 pt6) '((0 . "TEXT"))))
                  (if (/= chk nil)
                    (if (= (type chk) 'PICKSET)
                      (if (>= (sslength chk) 1)
                        (if (/= hlst nil)
                          (progn
                            (setq hnd (ssname chk 0))
                            (if (member hnd hlst)
                              (progn
                                (setq ent (entget hnd))
                                (setq tlst (cons (cdr (assoc 1 ent)) tlst))
                                (setq lent ent)
                                (setq thnd hnd)
                                (setq hlst (dstp_remove hnd hlst))
                                (setq dset (ssadd hnd dset))
                              )
                              (setq done T)
                            )
                          )
                          (setq done T)
                        )
                      )
                    )
                    (setq done T)
                  )
                )
                (setq done T)
              )
            )
            ;
            ; -- begin looking 'down' the list
            ;
            (setq done nil)
            (setq thnd ohnd)
            (while (/= done T)
              (setq hnd thnd)
              (setq ent (entget hnd))
              (setq rect (dstp_textrect ent))
              (setq pt1 (nth 0 rect))
              (setq pt2 (nth 1 rect))
              (setq pt3 (nth 2 rect))
              (setq pt4 (nth 3 rect))
              (setq pt5 (polar pt4 (angle pt4 pt1) (* (distance pt4 pt1) lhf)))
              (setq pt6 (polar pt3 (angle pt3 pt2) (* (distance pt3 pt2) lhf)))
              (setq chk (distance (car rect)(cadr rect)))
              (if (> chk mwid)(setq mwid chk))
              (setq chk (ssget "_F" (list pt5 pt6) '((0 . "TEXT"))))
              (if (/= chk nil)
                (if (= (type chk) 'PICKSET)
                  (if (>= (sslength chk) 1)
                    (if (/= hlst nil)
                      (progn
                        (setq hnd (ssname chk 0))
                        (if (member hnd hlst)
                          (progn
                            (setq ent (entget hnd))
                            (setq tlst (append tlst (list (cdr (assoc 1 ent)))))
                            (setq thnd hnd)
                            (setq hlst (dstp_remove hnd hlst))
                            (setq dset (ssadd hnd dset))
                          )
                          (setq done T)
                        )
                      )
                      (setq done T)
                    )
                  )
                )
                (setq done T)
              )
            )
            (setq used (+ used (length tlst)))
            ;
            ; --- convert to mtext
            ;
            (if (= opt 1)
              (progn
                (dstp_savprop)
                (setvar "CLAYER" (cdr (assoc 8 lent)))
                (if (/= (cdr (assoc 62 lent)) nil)
                  (setvar "CECOLOR" (dstp_col2str (cdr (assoc 62 lent))))
                )
                (setq mwid (+ mwid (* mwid 0.025)))
                (setq rect (dstp_textrect lent))
                (setq pt1 (nth 0 rect))
                (setq pt2 (nth 1 rect))
                (setq pt3 (nth 2 rect))
                (setq pt4 (nth 3 rect))
                (setq dis (distance pt1 pt2))
                (setq dvx (/ (- (car pt2)(car pt1)) dis))
                (setq dvy (/ (- (cadr pt2)(cadr pt1)) dis))
                (setq ptx (list dvx dvy 0.0))
                (setq ump (polar pt4 (angle pt4 pt3) (/ (distance pt4 pt3) 2.0)))
                (setq cpt (polar pt1 (angle pt1 pt3) (/ (distance pt1 pt3) 2.0)))
                (setq elv (nth 2 (cdr (assoc 10 lent))))
                (setq chk (assoc 72 lent))
                (if (/= chk nil)
                  (cond
                    ((= (cdr chk) 0)
                      (setq jst 1)
                      (setq nins (list (car pt4) (cadr pt4) elv))
                    )
                    ((= (cdr chk) 1)
                      (setq jst 2)
                      (setq nins (list (car ump) (cadr ump) elv))
                    )
                    ((= (cdr chk) 2)
                      (setq jst 3)
                      (setq nins (list (car pt3) (cadr pt3) elv))
                    )
                    ((= (cdr chk) 4)  ; middle
                      (setq jst 5)
                      (setq nins (list (car cpt) (cadr cpt) elv))
                    )
                    (t (setq jst 1))
                  )
                )
                (setq new '((0 . "MTEXT")(100 . "AcDbEntity")(100 . "AcDbMText")))
                (setq new (append new (list (assoc 7 lent))))
                (setq new (append new (list (assoc 8 lent))))
                (setq new (append new (list (cons 10 nins))))
                (setq new (append new (list (cons 11 ptx))))
                (setq ctr 1)
                (foreach lin tlst
                  (if (and (= (strcase (substr lin 1 3)) "%%U")(= (strcase (substr lin (- (strlen lin) 2) 3)) "%%U"))
                    (setq lin (strcat "{\\L" (substr lin 4 (- (strlen lin) 6)) "}"))
                  )
                  (setq lin (dstp_subtext lin "%%u" ""))
                  (setq lin (dstp_subtext lin "%%o" ""))
                  (setq lin (dstp_subtext lin "%%%" "%"))
                  (if (= ibrk "Y")
                    (if (< ctr (length tlst))
                      (setq lin (strcat (dstp_ltrim (dstp_rtrim lin)) "\\P"))
                    )
                    (setq lin (strcat (dstp_ltrim (dstp_rtrim lin)) " "))
                  )
                  (setq new (append new (list (cons 1 lin))))
                  (setq ctr (1+ ctr))
                )
                (setq new (append new (list (assoc 40 lent))))
                (setq new (append new (list (cons 41 mwid))))
                (setq new (append new (list (cons 71 jst))))
                (setq new (append new (list (cons 72 1))))
                (if (> (sslength dset) 0)
                  (command "_.ERASE" dset "")
                )
                (entmake new)
                (setq nset (ssadd (entlast) nset))
                (dstp_resprop)
              )
            )
            ;
            ; --- convert to block attributes
            ;
            (if (= opt 2)
              (progn
                (setq olayer (getvar "CLAYER"))
                (setq pnt (cdr (assoc 10 lent)))
                (setq rot (dstp_rtd (cdr (assoc 50 lent))))
                (setvar "CLAYER" (cdr (assoc 8 lent)))
                (command "_.INSERT" nam pnt scl scl rot)
                (setvar "CLAYER" olayer)
                (setq blkhnd (entlast))
                (setq blkent (entget blkhnd))
                (setq atthnd blkhnd)
                (setq attent blkent)
                (setq cnt 1)
                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                  (setq atthnd (entnext atthnd))
                  (setq attent (entget atthnd))
                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                    (if (<= cnt (length tlst))
                      (progn
                        (setq txt (nth (- cnt 1) tlst))
                        (setq txt (dstp_ltrim (dstp_rtrim txt)))
                        (setq attent (subst (cons 1 txt)(assoc 1 attent) attent))
                        (entmod attent)
                        (setq cnt (1+ cnt))
                      )
                    )
                  )
                )
                (entupd blkhnd)
                (if (> (sslength dset) 0)
                  (command "_.ERASE" dset "")
                )
                (setq nset (ssadd (entlast) nset))
              )
            )
            (princ (strcat "\rDS> Processed " (itoa used) " of " (itoa tsel) " Objects"))
          )
          (princ ", Done")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (if (> (sslength nset) 0)
        (progn
          (princ (strcat "\nDS> Total of " (rtos (sslength nset) 2 0) " Objects Created."))
          (princ "\nDS> Refer to Objects with P for Previous.")
          (command "_.SELECT" nset "")
        )
      )
      (setvar "ATTREQ" attreq)
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Convert 2D Objects to 3D
; --------------------------------------------------------------------------

(defun c:Cnv2do3do ( / 3dp cmdecho dstp_pldat hnd itm lst new num sset val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Select Lightweight or 2DPolys to convert: ")
      (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq 3dp 0)
          (setq itm 0)
          (dstp_savprop)
          (setq num (sslength sset))
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (dstp_getpline hnd)
            (if (= (nth 0 dstp_plhdr) "3D")
              (setq 3dp (+ 3dp 1))
              (progn
                (if (= (boole 1 (nth 1 dstp_plhdr) 1) 1)
                  (setq val 9)
                  (setq val 8)
                )
                (setq dstp_plhdr (list "3D" val (nth 2 dstp_plhdr)(nth 3 dstp_plhdr)(nth 4 dstp_plhdr)(nth 5 dstp_plhdr)(nth 6 dstp_plhdr)(nth 7 dstp_plhdr)))
                (setq lst nil)
                (foreach rec dstp_pldat
                  (setq new (list (nth 0 rec) 0.0 0.0 0.0 32))
                  (setq lst (append lst (list new)))
                )
                (setq dstp_pldat lst)
                (entdel hnd)
                (dstp_makepline)
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (dstp_resprop)
          (if (> 3dp 0)
            (princ (strcat "\nDS> Total of (" (itoa 3dp) ") 3D Polylines Ignored"))
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "OSMODE" osmode)
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Convert 3D Entities to 2D
; --------------------------------------------------------------------------

(defun c:Cnv3do2do ( / 2dp add chk cmdecho done elv ent g10 g70 hnd itm
                       lst n10 n70 nel new nhd num obj sset tmp u3d vtx)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Select Lines, 3DFaces, 3DPolys or Splines:")
      (setq sset (ssget '((-4 . "<OR")(0 . "3DFACE")(0 . "LINE")(0 . "POLYLINE")(0 . "SPLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (initget "Y N")
          (setq tmp (getkword "\nDS> Use First Vertex Elevation for 3D Polylines <Y>/N: "))
          (if (= tmp "N")(setq u3d nil)(setq u3d T))
          (setq tmp (getreal "\nDS> Default New Elevation for Objects <0.00>: "))
          (if (= tmp nil)(setq elv 0.0)(setq elv tmp))
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq itm 0)
          (setq 2dp 0)
          (princ "\nDS>")
          (dstp_savprop)
          (setq num (sslength sset))
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "3DFACE")
                (setq tmp (cdr (assoc 10 ent)))
                (setq new (list (nth 0 tmp) (nth 1 tmp) elv))
                (setq ent (subst (cons 10 new)(assoc 10 ent) ent))
                (setq tmp (cdr (assoc 11 ent)))
                (setq new (list (nth 0 tmp) (nth 1 tmp) elv))
                (setq ent (subst (cons 11 new)(assoc 11 ent) ent))
                (setq tmp (cdr (assoc 12 ent)))
                (setq new (list (nth 0 tmp) (nth 1 tmp) elv))
                (setq ent (subst (cons 12 new)(assoc 12 ent) ent))
                (setq tmp (cdr (assoc 13 ent)))
                (setq new (list (nth 0 tmp) (nth 1 tmp) elv))
                (setq ent (subst (cons 13 new)(assoc 13 ent) ent))
                (entmod ent)
              )
              ((= obj "LINE")
                (setq tmp (cdr (assoc 10 ent)))
                (setq new (list (nth 0 tmp) (nth 1 tmp) elv))
                (setq ent (subst (cons 10 new)(assoc 10 ent) ent))
                (setq tmp (cdr (assoc 11 ent)))
                (setq new (list (nth 0 tmp) (nth 1 tmp) elv))
                (setq ent (subst (cons 11 new)(assoc 11 ent) ent))
                (entmod ent)
              )
              ((= obj "POLYLINE")
                (if (= (boole 1 (cdr (assoc 70 ent)) 8) 8)
                  (progn
                    (if (= u3d T)
                      (progn
                        (setq chk (entget (entnext hnd)))
                        (setq nel (caddr (cdr (assoc 10 chk))))
                      )
                      (setq nel elv)
                    )
                    (setq ent (subst (cons 70 (- (cdr (assoc 70 ent)) 8))(assoc 70 ent) ent))
                    (setq ent (subst (cons 10 (list 0.0 0.0 nel))(assoc 10 ent) ent))
                    (entmake ent)
                    (setq done nil)
                    (setq nhd hnd)
                    (while (/= done T)
                      (setq nhd (entnext nhd))
                      (setq vtx (entget nhd))
                      (if (= (cdr (assoc 0 vtx)) "VERTEX")
                        (progn
                          (setq g10 (cdr (assoc 10 vtx)))
                          (setq n10 (list (nth 0 g10) (nth 1 g10) nel))
                          (setq vtx (subst (cons 10 n10)(assoc 10 vtx) vtx))
                          (setq g70 (cdr (assoc 70 vtx)))
                          (setq n70 (- g70 32))
                          (setq vtx (subst (cons 70 n70)(assoc 70 vtx) vtx))
                          (entmake vtx)
                        )
                      )
                      (if (= (cdr (assoc 0 vtx)) "SEQEND")
                        (setq done T)
                      )
                    )
                    (setq add (quote ((0 . "SEQEND"))))
                    (setq add (append add (list (assoc 8 ent))))
                    (entmake add)
                    (entdel hnd)
                    (redraw (entlast))
                  )
                  (setq 2dp (+ 2dp 1))
                )
              )
              ((= obj "SPLINE")
                (setq new nil)
                (foreach rec ent
                  (if (= (car rec) 10)
                    (progn
                      (setq g10 (cdr rec))
                      (setq n10 (list (nth 0 g10)(nth 1 g10) elv))
                      (setq rec (cons 10 n10))
                    )
                  )
                  (if (= (car rec) 11)
                    (progn
                      (setq g11 (cdr rec))
                      (setq n11 (list (nth 0 g11)(nth 1 g11) elv))
                      (setq rec (cons 11 n11))
                    )
                  )
                  (if (= (car rec) 12)
                    (progn
                      (setq g12 (cdr rec))
                      (setq n12 (list (nth 0 g12)(nth 1 g12) 0.0))
                      (setq rec (cons 12 n12))
                    )
                  )
                  (if (= (car rec) 13)
                    (progn
                      (setq g13 (cdr rec))
                      (setq n13 (list (nth 0 g13)(nth 1 g13) 0.0))
                      (setq rec (cons 13 n13))
                    )
                  )
                  (setq new (cons rec new))
                )
                (setq new (reverse new))
                (if (/= (boole 1 (cdr (assoc 70 new)) 8) 8)
                  (setq new (subst (cons 70 (+ (cdr (assoc 70 new)) 8))(assoc 70 new) new))
                )
                (entmod new)
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (dstp_resprop)
          (if (> 2dp 0)
            (princ (strcat "\nDS> Total of (" (itoa 2dp) ") 2D Polylines Ignored"))
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "OSMODE" osmode)
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Convert Single Line Text to Attribute
; --------------------------------------------------------------------------

(defun c:CnvTxtAtt ( / att attent atthnd attreq atttag blkent blkhnd
                         cmdecho ent hnd itm lst nam num olayer pnt rot sset
                         tmp txt xsc ysc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq attreq (getvar "ATTREQ"))
      (setvar "ATTREQ" 0)
      (setq lst (dstp_bldlst "BLOCK"))
      (if (/= lst nil)
        (progn
          (setq nam (dstp_tablesel "Select Local Block" (acad_strlsort lst) "s" ""))
          (if (/= nam "")
            (progn
              (setq lst (dstp_attdef nam))
              (if (/= lst nil)
                (progn
                  (setq att nil)
                  (if (= (length lst) 1)
                    (setq att (nth 0 lst))
                    (progn
                      (setq lst (acad_strlsort lst))
                      (setq att (dstp_tablesel "Select Tag to Fill" lst "s" ""))
                    )
                  )
                  (if (/= att nil)
                    (progn
                      (setq sset (ssget '((0 . "TEXT"))))
                      (if sset
                        (progn
                          (setq tmp (getreal "\nDS> Insertion X Scale <1.0>: "))
                          (if (= tmp nil)
                            (setq xsc 1.0)
                            (setq xsc tmp)
                          )
                          (setq tmp (getreal (strcat "\nDS> Insertion Y Scale <" (rtos xsc) ">: ")))
                          (if (= tmp nil)
                            (setq ysc xsc)
                            (setq ysc tmp)
                          )
                          (command "_.UNDO" "_G")
                          (dstp_ucspush)
                          (setq num (sslength sset) itm 0)
                          (setq olayer (getvar "CLAYER"))
                          (princ "\nDS> ")
                          (while (< itm num)
                            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                            (setq hnd (ssname sset itm))
                            (setq ent (entget hnd))
                            (setq txt (cdr (assoc 1 ent)))
                            (setq pnt (cdr (assoc 10 ent)))
                            (setq rot (dstp_rtd (cdr (assoc 50 ent))))
                            (setvar "CLAYER" (cdr (assoc 8 ent)))
                            (command "_.INSERT" nam pnt xsc ysc rot)
                            (setq blkhnd (entlast))
                            (setq blkent (entget blkhnd))
                            (setq atthnd blkhnd)
                            (setq attent blkent)
                            (while (/= "SEQEND" (cdr (assoc 0 attent)))
                              (setq atthnd (entnext atthnd))
                              (setq attent (entget atthnd))
                              (if (= (cdr (assoc 0 attent)) "ATTRIB")
                                (progn
                                  (setq atttag (cdr (assoc 2 attent)))
                                  (if (= att atttag)
                                    (progn
                                      (setq attent (subst (cons 1 txt)(assoc 1 attent) attent))
                                      (entmod attent)
                                    )
                                  )
                                )
                              )
                            )
                            (entupd blkhnd)
                            (entdel hnd)
                            (setq itm (1+ itm))
                          )
                          (setvar "CLAYER" olayer)
                          (princ ", Done.")
                          (dstp_ucspop)
                          (command "_.UNDO" "_E")
                        )
                      )
                    )
                  )
                )
                (princ "\nDS> Selected Block has no Attributes!")
              )
            )
          )
        )
        (princ "\nDS> No Local Blocks Available!")
      )
      (setvar "ATTREQ" attreq)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Convert Segments to Arc
; --------------------------------------------------------------------------

(defun c:CnvSegArc ( / cmdecho sset num ptlst itm num hnd ent pt1 pt2 mpt
                         pnt ptlst mdis dis sp1 sp2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Segments with Window ...")
      (setq sset (ssget '((0 . "LINE"))))
      (if sset
        (progn
          (setq num (sslength sset) itm 0)
          (setq ptlst nil)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq pt1 (cdr (assoc 10 ent)))
            (setq pt2 (cdr (assoc 11 ent)))
            (if (not (member pt1 ptlst))
              (setq ptlst (append ptlst (list pt1)))
            )
            (if (not (member pt2 ptlst))
              (setq ptlst (append ptlst (list pt2)))
            )
            (setq itm (1+ itm))
          )
          (setq mdis 0.0)
          (foreach pt1 ptlst
            (foreach pt2 ptlst
              (setq dis (distance (dstp_2dpoint pt1)(dstp_2dpoint pt2)))
              (if (> dis mdis)
                (progn
                  (setq mdis dis)
                  (setq sp1 pt1)
                  (setq sp2 pt2)
                )
              )
            )
          )
          (foreach pnt ptlst
            (if (/= pnt sp1)
              (if (/= pnt sp2)
                (setq mpt pnt)
              )
            )
          )
          (dstp_savprop)
          (dstp_prop2obj hnd)
          (command "_.ERASE" sset "")
          (command "_.ARC" sp1 mpt sp2)
          (dstp_resprop)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          Convert Polymesh to Polyline
; --------------------------------------------------------------------------

(defun c:CnvMesPln ( / pntmrk pset pitm phnd sset nxt hnd ent g10 g11 g12
                         g13 g70 nset blipmode cmdecho elevation itm num
                         osmode pnum)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq elevation (getvar "ELEVATION"))
      (setvar "ELEVATION" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq blipmode (getvar "BLIPMODE"))
      (setvar "BLIPMODE" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Polyface Meshes ...")
      (setq pset (ssget (list (cons 0 "POLYLINE") (cons 70 64))))
      (if pset
        (progn
          (princ "\nDS>")
          (dstp_savprop)
          (setq pnum (sslength pset) pitm 0)
          (while (< pitm pnum)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ pitm)) " of " (itoa pnum) (chr 13)))
            (setq phnd (ssname pset pitm))
            (dstp_prop2obj phnd)
            (command "_.POINT" "0,0")
            (setq pntmrk (entlast))
            (command "_.EXPLODE" phnd)
            (setq sset (ssadd))
            (setq nxt pntmrk)
            (while (/= nxt nil)
              (setq nxt (entnext nxt))
              (if (/= nxt nil)
                (setq sset (ssadd nxt sset))
              )
            )
            (setq nset (ssadd))
            (setq num (sslength sset) itm 0)
            (while (< itm num)
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd))
              (setq g10 (cdr (assoc 10 ent)))
              (setq g11 (cdr (assoc 11 ent)))
              (setq g12 (cdr (assoc 12 ent)))
              (setq g13 (cdr (assoc 13 ent)))
              (setq g70 (cdr (assoc 70 ent)))
              (if (= (boole 1 g70 1) 1)
                (progn
                  (command "_.LINE" g10 g13 "")
                  (setq nset (ssadd (entlast) nset))
                )
              )
              (if (= (boole 1 g70 2) 2)
                (progn
                  (command "_.LINE" g11 g10 "")
                  (setq nset (ssadd (entlast) nset))
                )
              )
              (if (= (boole 1 g70 4) 4)
                (progn
                  (command "_.LINE" g12 g11 "")
                  (setq nset (ssadd (entlast) nset))
                )
              )
              (if (= (boole 1 g70 8) 8)
                (progn
                  (command "_.LINE" g13 g12 "")
                  (setq nset (ssadd (entlast) nset))
                )
              )
              (setq itm (1+ itm))
            )
            (entdel pntmrk)
            (command "_.ERASE" sset "")
            (setq sset nil)
            (if (= (getvar "PEDITACCEPT") 0)
              (command "_.PEDIT" "_L" "_Y" "_J" nset "" "_X")
              (command "_.PEDIT" "_L" "_J" nset "" "_X")
            )
            (setq nset nil)
            (setq pitm (1+ pitm))
          )
          (dstp_resprop)
        )
      )
      (princ (strcat "\rDS> Processing Object " (itoa pnum) " of " (itoa pnum) ", Done."))
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
      (setvar "ELEVATION" elevation)
    )
  )
  (princ)
)

; ###########################################################################
;                                 DIMTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                             Dimension Calculator
; --------------------------------------------------------------------------

(defun c:DimObjCal ( / bhn ble blk cmdecho done ent g42 g70 hnd itm mod nam
                        nent new nhnd npik num obj opt pdis pik pnt prc rdis
                        sset str tmp val wrd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq mod "A")
      (setq wrd "Add")
      (setq rdis 0.0)
      (setq done nil)
      (while (/= done T)
        (princ (strcat "\nDS> Running Horz Distance Value: " (rtos rdis)))
        (if (= mod "A")
          (progn
            (initget "S G P V")
            (setq opt (entsel "\nDS> (Add Mode) Subtract/Value/Place/Group/<Select Dimension>: "))
          )
          (progn
            (initget "A G P V")
            (setq opt (entsel "\nDS> (Subtract Mode) Add/Value/Place/Group/<Select Dimension>: "))
          )
        )
        (cond
          ((= opt "A")
            (setq mod "A")
            (setq wrd "Add")
          )
          ((= opt "S")
            (setq mod "S")
            (setq wrd "Subtract")
          )
          ((= opt "V")
            (setq tmp (getreal (strcat "\nDS> New Current Value <" (rtos rdis) ">: ")))
            (if (/= tmp nil)(setq rdis tmp))
          )
          ((= opt "P")
            (initget "E N")
            (setq tmp (getkword "\nDS> Update Exiting or Create New Annotation <E>/N: "))
            (if (/= tmp "N")(setq prc "E")(setq prc "N"))
            (if (= prc "E")
              (progn
                (setq pik (entsel "\nDS> Select Existing Annotation to Update: "))
                (if (/= pik nil)
                  (progn
                    (setq hnd (car pik))
                    (setq ent (entget hnd))
                    (setq obj (cdr (assoc 0 ent)))
                    (cond
                      ((= obj "DIMENSION")
                        (setq pnt (cadr pik))
                        (setq npik (nentselp pnt))
                        (setq nhnd (car npik))
                        (setq nent (entget nhnd))
                        (setq nent (subst (cons 1 (rtos rdis)) (assoc 1 nent) nent))
                        (entmod nent)
                        (entupd hnd)
                      )
                      ((or (= obj "MTEXT")(= obj "TEXT"))
                        (setq ent (subst (cons 1 (rtos rdis)) (assoc 1 ent) ent))
                        (entmod ent)
                        (entupd hnd)
                      )
                      (t nil)
                    )
                  )
                )
              )
              (progn
                (setq pnt (getvar "VIEWCTR"))
                (setq new '((0 . "TEXT")))
                (setq new (append new (list (list 10 0.0 0.0 0.0))))
                (setq new (append new (list (list 11 (nth 0 pnt) (nth 1 pnt) (nth 2 pnt)))))
                (setq new (append new (list (cons 40 (dstp_textsize)))))
                (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
                (setq new (append new (list (cons 1 (rtos rdis)))))
                (setq new (append new (list (cons 72 4))))
                (setq new (append new (list (cons 73 0))))
                (entmake new)
                (setq hnd (entlast))
                (princ (strcat "\nDS> Placement Position For [" (rtos rdis) "]: "))
                (command "_.MOVE" hnd "" pnt pause)
              )
            )
          )
          ((= opt "G")
            (setq pdis 0.0)
            (princ (strcat "\nDS> Select Dimensions to " wrd " ..."))
            (setq sset (ssget '((-4 . "<OR")(0 . "DIMENSION")(0 . "TEXT")(0 . "MTEXT")(-4 . "OR>"))))
            (if sset
              (progn
                (setq pdis 0.0)
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq obj (cdr (assoc 0 ent)))
                  (cond
                    ((= obj "DIMENSION")
                      (setq g42 (cdr (assoc 42 ent)))
                      (setq g70 (cdr (assoc 70 ent)))
                      (if (= (boole 1 g70 128) 128)(setq g70 (- g70 128)))
                      (if (= (boole 1 g70 64) 64)(setq g70 (- g70 64)))
                      (if (= (boole 1 g70 32) 32)(setq g70 (- g70 32)))
                      (if (<= g70 1)
                        (progn
                          (if (> g42 0.0)
                            (setq val g42)
                            (progn
                              (setq val 0.0)
                              (setq nam (cdr (assoc 2 ent)))
                              (setq blk (tblsearch "BLOCK" nam))
                              (setq bhn (cdr (assoc -2 blk)))
                              (setq tmp nil)
                              (while (/= tmp T)
                                (setq ble (entget bhn))
                                (if (= (cdr (assoc 0 ble)) "MTEXT")
                                  (progn
                                    (setq str (cdr (assoc 1 ble)))
                                    (if (vl-string-position (ascii ";") str)
                                      (setq str (last (dstp_pdf2lst str ";")))
                                    )
                                    (setq val (distof str))
                                    (setq tmp T)
                                  )
                                )
                                (if (= (setq bhn (entnext (cdr (assoc -1 ble)))) nil)
                                  (setq tmp T)
                                )
                              )
                            )
                          )
                          (setq pdis (+ pdis val))
                        )
                        (princ "\nDS> *** Dimension not Rotated, Horizontal, Vertical or Aligned!")
                      )
                    )
                    ((or (= obj "TEXT")(= obj "MTEXT"))
                      (setq str (cdr (assoc 1 ent)))
                      (if (vl-string-position (ascii ";") str)
                        (setq str (last (dstp_pdf2lst str ";")))
                      )
                      (setq val (distof str))
                      (if (= val nil)(setq val 0.0))
                      (setq pdis (+ pdis (abs val)))
                    )
                    (t nil)
                  )
                  (setq itm (1+ itm))
                )
                (princ (strcat "\nDS> Sum of Selected Dimensions: " (rtos pdis)))
                (if (= mod "A")
                  (setq rdis (+ rdis pdis))
                  (setq rdis (- rdis pdis))
                )
              )
            )
          )
          ((= (type opt) 'LIST)
            (setq hnd (car opt))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "DIMENSION")
                (setq g42 (cdr (assoc 42 ent)))
                (setq g70 (cdr (assoc 70 ent)))
                (if (= (boole 1 g70 128) 128)(setq g70 (- g70 128)))
                (if (= (boole 1 g70 64) 64)(setq g70 (- g70 64)))
                (if (= (boole 1 g70 32) 32)(setq g70 (- g70 32)))
                (if (<= g70 1)
                  (progn
                    (if (> g42 0.0)
                      (setq val g42)
                      (progn
                        (setq val 0.0)
                        (setq nam (cdr (assoc 2 ent)))
                        (setq blk (tblsearch "BLOCK" nam))
                        (setq bhn (cdr (assoc -2 blk)))
                        (setq tmp nil)
                        (while (/= tmp T)
                          (setq ble (entget bhn))
                          (if (= (cdr (assoc 0 ble)) "MTEXT")
                            (progn
                              (setq str (cdr (assoc 1 ble)))
                              (if (vl-string-position (ascii ";") str)
                                (setq str (last (dstp_pdf2lst str ";")))
                              )
                              (setq val (distof str))
                              (setq tmp T)
                            )
                          )
                          (if (= (setq bhn (entnext (cdr (assoc -1 ble)))) nil)
                            (setq tmp T)
                          )
                        )
                      )
                    )
                    (if (= mod "A")
                      (setq rdis (+ rdis val))
                      (setq rdis (- rdis val))
                    )
                  )
                  (princ "\nDS> *** Dimension not Rotated, Horizontal, Vertical or Aligned!")
                )
              )
              ((or (= obj "TEXT")(= obj "MTEXT"))
                (setq str (cdr (assoc 1 ent)))
                (if (vl-string-position (ascii ";") str)
                  (setq str (last (dstp_pdf2lst str ";")))
                )
                (setq val (distof str))
                (if (= val nil)(setq val 0.0))
                (if (= mod "A")
                  (setq rdis (+ rdis (abs val)))
                  (setq rdis (- rdis (abs val)))
                )
              )
              (t
                (princ "\nDS> *** Selected Object does not appear to be a Dimension!")
              )
            )
          )
          (t
            (setq done T)
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;         Update Coordinates in Selection Set of Ordinate Dimensions
; --------------------------------------------------------------------------

(defun c:DimOrdUpd ( / chk cmdecho dcl_id doproc ent g13 g70 hnd itm morg
                          ndec num obj sset str xpre xsuf ypre ysuf)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (princ "\nDS> Select Ordinate Dimensions to Update ...")
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Preselected."))
        (setq sset (ssget '((0 . "DIMENSION"))))
      )
      (if sset
        (progn
          (setq doproc nil)
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
               (setq sset (car chk))
               (sssetfirst sset nil)
               (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
            )
          )
          (setq xpre (dstp_regfetch "OrdUpd" "xpre" ""))
          (setq xsuf (dstp_regfetch "OrdUpd" "xsuf" ""))
          (setq ypre (dstp_regfetch "OrdUpd" "ypre" ""))
          (setq ysuf (dstp_regfetch "OrdUpd" "ysuf" ""))
          (setq ndec (dstp_regfetch "OrdUpd" "ndec" "4"))
          (setq morg (dstp_regfetch "OrdUpd" "morg" "0"))
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog "ordupd" dcl_id)) (exit))
          (set_tile "xpre" xpre)
          (set_tile "xsuf" xsuf)
          (set_tile "ypre" ypre)
          (set_tile "ysuf" ysuf)
          (set_tile "ndec" ndec)
          (set_tile "morg" morg)
          (action_tile "xpre" "(setq xpre $value)")
          (action_tile "xsuf" "(setq xsuf $value)")
          (action_tile "ypre" "(setq ypre $value)")
          (action_tile "ysuf" "(setq ysuf $value)")
          (action_tile "ndec" "(setq ndec $value)")
          (action_tile "morg" "(setq morg $value)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(dstp_showhelp \"DimOrdUpd.htm\")")
          (if (equal (start_dialog) 1)
            (progn
              (setq doproc T)
              (dstp_regstore "OrdUpd" "xpre" xpre)
              (dstp_regstore "OrdUpd" "xsuf" xsuf)
              (dstp_regstore "OrdUpd" "ypre" ypre)
              (dstp_regstore "OrdUpd" "ysuf" ysuf)
              (dstp_regstore "OrdUpd" "ndec" ndec)
              (dstp_regstore "OrdUpd" "morg" morg)
            )
          )
          (unload_dialog dcl_id)
          (if (= doproc T)
            (progn
              (dstp_ucspush)
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq obj (cdr (assoc 0 ent)))
                (cond
                  ((= obj "DIMENSION")
                    (setq g70 (cdr (assoc 70 ent)))
                    (if (= (boole 1 g70 2) 2)
                      (progn
                        (setq g13 (cdr (assoc 13 ent)))
                        (if (= (boole 1 g70 64) 64)
                          (setq str (strcat xpre (rtos (car g13) (getvar "LUNITS") (atoi ndec)) xsuf)) ; X
                          (setq str (strcat ypre (rtos (cadr g13) (getvar "LUNITS") (atoi ndec)) ysuf)) ; Y
                        )
                        (setq ent (subst (cons 1 str)(assoc 1 ent) ent))
                        (if (= morg "1")
                          (setq ent (subst (cons 10 (cdr (assoc 11 ent)))(assoc 10 ent) ent))
                        )
                        (setq chk (entmod ent))
                        (entupd hnd)
                      )
                    )
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
              (dstp_ucspop)
            )
          )
        )
      )
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                            Quick Dimang > 180
; --------------------------------------------------------------------------

(defun c:DimQuiAng ( / cmdecho end1a end1b end2a end2b mid1 mid2 pause pik1
                       pik2 poi pt1 pt2 sel1 sel2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sel1 (entsel "\nDS> Pick 1st Segment: "))
      (if (/= sel1 nil)
        (progn
          (setq sel2 (entsel "\nDS> Pick 2nd Segment: "))
          (if (/= sel2 nil)
            (progn
              (setq pik1 (cadr sel1))
              (setq mid1 (osnap pik1 "_MID"))
              (setq end1a (osnap pik1 "_END"))
              (setq end1b (polar end1a (angle end1a mid1)(* (distance end1a mid1) 2.0)))
              (setq pik2 (cadr sel2))
              (setq mid2 (osnap pik2 "_MID"))
              (setq end2a (osnap pik2 "_END"))
              (setq end2b (polar end2a (angle end2a mid2)(* (distance end2a mid2) 2.0)))
              (setq poi (inters end1a end1b end2a end2b nil))
              (if (/= poi nil)
                (progn
                  (if (> (distance poi end1a)(distance poi end1b))
                    (setq pt1 end1a)
                    (setq pt1 end1b)
                  )
                  (if (> (distance poi end2a)(distance poi end2b))
                    (setq pt2 end2a)
                    (setq pt2 end2b)
                  )
                  (setq cmdecho (getvar "CMDECHO"))
                  (setvar "CMDECHO" 0)
                  (dstp_prompt "DS> Pick Location for Dimension ...")
                  (command "_.DIMANGULAR" "" poi pt1 pt2 pause)
                  (setvar "CMDECHO" cmdecho)
                )
                (princ "\nDS> Selected Segments do not appear to intersect!")
              )
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Dimension Polyline Segments (Distance)
; --------------------------------------------------------------------------

(defun c:DimPlnDis ( / cang cen chk clen clk cmdecho cpt ent hnd iang ins
                         itm larc lbu lpt mid2 num ofs ord osmode pp1 pp2
                         ppt pts rad2 sset str tpt use)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun dimpoly_prcseg (zp1 zp2 zbu zof)
        (if (= zbu 0.0)
          (progn
            (setq tpt (polar zp1 (angle zp1 zp2) (/ (distance zp1 zp2) 2.0)))
            (setq ppt (polar tpt (+ (angle zp1 zp2)(/ pi 2.0)) zof))
            (command "_.DIMALIGNED" zp1 zp2 ppt)
          )
          (progn
            (if (> zbu 0.0)
              (if (> zof 0.0)
                (setq zof (- 0.0 zof))
                (setq zof (abs zof))
              )
            )
            (setq cang (angle zp1 zp2))
            (setq clen (distance zp1 zp2))
            (setq iang (* (atan zbu) 4.0))
            (setq mid2 (polar zp1 cang (/ clen 2.0)))
            (setq rad2 (/ clen (* 2.0 (sin (/ iang 2.0)))))
            (setq larc (* iang rad2))
            (setq ord (- rad2 (* rad2 (- 1 (cos (/ iang 2.0))))))
            (setq cen (polar mid2 (+ cang (/ pi 2.0)) ord))
            (setq pp1 (polar cen (angle cen mid2) (abs rad2)))
            (setq pp2 (polar cen (angle cen mid2) (+ (abs rad2) zof)))
            (setq str (rtos larc (getvar "DIMLUNIT") (getvar "DIMDEC")))
            (command "_.DIMARC" pp1 pp2)
          )
        )
      )
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (setq ofs (* (getvar "DIMDLI") 1.5))
      (setq chk (getdist (strcat "\nDS> Offset Distance <" (rtos ofs) ">: ")))
      (if (/= chk nil)(setq ofs chk))
      (initget "I O")
      (setq chk (getkword "\nDS> Generate Dimensions Inside/<Outside>: "))
      (if (= chk "I")(setq ins T)(setq ins nil))
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (dstp_getpline hnd)
            (setq pts nil)
            (foreach rec dstp_pldat
              (setq pts (cons (car rec) pts))
            )
            (setq pts (reverse pts))
            (setq clk (dstp_clockwise pts))
            (if (= ins nil)
              (if (= clk nil)
                (setq ofs (- 0.0 ofs))
                (setq ofs (abs ofs))
              )
              (if (= clk nil)
                (setq ofs (abs ofs))
                (setq ofs (- 0.0 ofs))
              )
            )
            (setq lpt nil lbu 0.0)
            (foreach rec dstp_pldat
              (setq use ofs)
              (setq cpt (nth 0 rec))
              (if (/= lpt nil)
                (dimpoly_prcseg lpt cpt lbu ofs)
              )
              (setq lbu (nth 3 rec))
              (setq lpt cpt)
            )
            (if (= (boole 1 (nth 1 dstp_plhdr) 1) 1)
              (dimpoly_prcseg (last pts) (car pts) lbu ofs)
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Dimension Polyline Angles
; --------------------------------------------------------------------------

(defun c:DimPlnAng ( / ad0 ad1 ban bp bpt chk clk cmdecho ent fan fp fpt
                         hnd ins itm mp num ofs osmode ppa ppt pts sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (setq ins T)
      (setq ofs (* (getvar "DIMDLI") 1.5))
      (setq chk (getdist (strcat "\nDS> Offset Distance <" (rtos ofs) ">: ")))
      (if (/= chk nil)(setq ofs chk))
      (initget "I E")
      (setq chk (getkword "\nDS> Generate Dimensions <Interior>/Exterior: "))
      (if (= chk "E")(setq ins nil)(setq ins T))
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (dstp_getpline hnd)
            (setq pts nil)
            (foreach rec dstp_pldat
              (setq pts (cons (car rec) pts))
            )
            (setq pts (reverse pts))
            (setq clk (dstp_clockwise pts))
            (if (= ins T)
              (if (= clk nil)
                (setq ofs (- 0.0 ofs))
                (setq ofs (abs ofs))
              )
              (if (= clk nil)
                (setq ofs (abs ofs))
                (setq ofs (- 0.0 ofs))
              )
            )
            (if (= (boole 1 (nth 1 dstp_plhdr) 1) 1)
              (progn
                (setq ad0 (nth 0 pts))
                (setq ad1 (nth 1 pts))
                (setq pts (reverse pts))
                (setq pts (cons ad0 pts))
                (setq pts (cons ad1 pts))
                (setq pts (reverse pts))
              )
            )
            (setq bp nil mp nil fp nil)
            (foreach pnt pts
              (setq fp pnt)
              (if (and (/= bp nil)(/= mp nil))
                (progn
                  (setq ban (+ (angle mp bp) (* pi 2.0)))
                  (setq bpt (polar mp ban (abs ofs)))
                  (setq fan (+ (angle mp fp) (* pi 2.0)))
                  (setq fpt (polar mp fan (abs ofs)))
                  (setq ppa (/ (+ ban fan) 2.0))
                  (if (< ban fan)
                    (setq ppt (polar mp ppa ofs))
                    (setq ppt (polar mp (+ ppa pi) ofs))
                  )
                  (command "_.DIMANGULAR" "" mp bpt fpt ppt)
                )
              )
              (setq bp mp)
              (setq mp fp)
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                             Dimension Break
; --------------------------------------------------------------------------

(defun c:DimObjBrk ( / ent g70 hnd npt obj osmode pik pt1 pt2 tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq tmp (entsel "\nDS> Select Dimension to Break: "))
      (if (/= tmp nil)
        (progn
          (setq hnd (car tmp))
          (setq pik (cadr tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (if (= obj "DIMENSION")
            (progn
              (setq g70 (cdr (assoc 70 ent)))
              (if (= (boole 1 g70 128) 128)(setq g70 (- g70 128)))
              (if (= (boole 1 g70 64) 64)(setq g70 (- g70 64)))
              (if (= (boole 1 g70 32) 32)(setq g70 (- g70 32)))
              (cond
                ((or (= g70 0)(= g70 1))
                  (setq osmode (getvar "OSMODE"))
                  (setvar "OSMODE" 512)
                  (setq npt (getpoint "\nDS> Break Point: "))
                  (setvar "OSMODE" osmode)
                  (if (/= npt nil)
                    (progn
                      (setq pt1 (cdr (assoc 13 ent)))
                      (setq pt2 (cdr (assoc 14 ent)))
                      (entdel hnd)
                      (setq new '((0 . "DIMENSION")))
                      (setq dolst (list -3 1 3 8 10 11 12 13 14 15 16 40 41 42 50 51 52 53 54 70 71 72 67 100 210))
                      (foreach grp ent
                        (setq cod (car grp))
                        (if (member cod dolst)
                          (setq new (append new (list grp)))
                        )
                      )
                      (setq new (subst (cons 13 pt1) (assoc 13 new) new))
                      (setq new (subst (cons 14 npt) (assoc 14 new) new))
                      (entmake new)
                      (setq new (subst (cons 13 npt) (assoc 13 new) new))
                      (setq new (subst (cons 14 pt2) (assoc 14 new) new))
                      (entmake new)
                    )
                  )
                )
                (t
                  (princ "\nDS> Dimension type currently unsupported!")
                )
              )
            )
            (princ "\nDS> Selected object was not a dimension!")
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Dimension Text Flip
; --------------------------------------------------------------------------

(defun c:DimTxtFlp ( / apt axo chk cmdecho doproc ent g10 g42 hnd itm n11
                           num o11 sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (princ "\nDS> Select Dimensions to Process ...")
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Preselected."))
        (setq sset (ssget '((0 . "DIMENSION"))))
      )
      (if sset
        (progn
          (setq doproc nil)
          (setq chk (dstp_ssremlok sset))
          (if (> (cadr chk) 0)
            (progn
               (setq sset (car chk))
               (sssetfirst sset nil)
               (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
            )
          )
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq g10 (cdr (assoc 10 ent)))
            (setq g42 (cdr (assoc 42 ent)))
            (setq o11 (cdr (assoc 11 ent)))
            (setq n11 (polar g10 (+ (angle g10 o11) pi) (+ (distance g10 o11) g42)))
            (setq axo (vlax-ename->vla-object hnd))
            (setq apt (vlax-3d-point n11))
            (vla-put-textposition axo apt)
            (vlax-release-object axo)
            (entupd hnd)
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ###########################################################################
;                                DISPTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                           Restore Views from File
; --------------------------------------------------------------------------

(defun c:DisVueLod ( / chk cmdecho ct ent fh fn fnd grp nam val vdata)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq fn (dstp_getfiles "Select View Save File" (strcat (getvar "DWGPREFIX")(dstp_dwgname)) "vsf" 0))
      (if (/= fn nil)
        (progn
          (setq fh (open fn "r"))
          (princ "\nDS> [Load] File Open ... ")
          (setq chk (read-line fh))
          (princ "Reading ... ")
          (read-line fh)
          (read-line fh)
          (setq ct (atoi (read-line fh)))
          (repeat ct
            (setq vdata (read (read-line fh)))
            (setq nam (cdr (assoc 2 vdata)))
            (setq fnd (tblsearch "VIEW" nam))
            (if (= fnd nil)
              (progn
                (setq ent (list (cons 0 "VIEW")(cons 100 "AcDbSymbolTableRecord")(cons 100 "AcDbViewTableRecord")))
                (foreach rec vdata
                  (setq ent (append ent (list rec)))
                )
                (entmake ent)
              )
              (progn
                (setq ent (entget (tblobjname "VIEW" nam)))
                (foreach rec vdata
                  (setq grp (car rec))
                  (setq val (cdr rec))
                  (setq ent (subst (cons grp val)(assoc grp ent) ent))
                )
                (entmod ent)
              )
            )
          )
          (close fh)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Save Views to File
; --------------------------------------------------------------------------

(defun c:DisVueSav ( / cmdecho fh fn lst tmp vdata viewtab)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (setq viewtab (dstp_bldlst "VIEW"))
      (if (= viewtab nil)
        (alert "No Views Defined!")
        (progn
          (dstp_ucspush)
          (setq viewtab (acad_strlsort viewtab))
          (setq fn (dstp_getfiles "View Save File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "vsf" 1))
          (if (/= fn nil)
            (progn
              (setq fh (open fn "w"))
              (prompt "\nDS> [Save] File Open ... Writing ... ")
              (princ "VSF2" fh)
              (princ "\nView Save File" fh)
              (princ "\n--------------" fh)
              (princ (strcat "\n" (rtos (length viewtab) 2 0)) fh)
              (setq lst (list 2 10 11 12 20 40 41 42 43 44 50 70 71))
              (foreach nam viewtab
                (setq tmp (entget (tblobjname "VIEW" nam)))
                (setq vdata nil)
                (foreach rec tmp
                  (if (/= (member (car rec) lst) nil)
                    (progn
                      (if (= (car rec) 10)
                        (setq rec (list 10 (cadr rec) (caddr rec)))
                      )
                      (setq vdata (append vdata (list rec)))
                    )
                  )
                )
                (print vdata fh)
              )
              (close fh)
              (princ "Done.")
            )
          )
          (dstp_ucspop)
        )
      )
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Select View By Review
; --------------------------------------------------------------------------

(defun c:DisVueRev ( / aratio cmdecho cur done fg nam resp tmp vc vh viewtab
                       vr vw x1 x2 y1 y2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun disvwrev_drwview (nam pas)
        (if (= pas 1)
          (progn
            (princ (strcat "\nDS> View Name: [" nam "]"))
            (setq vr (tblsearch "VIEW" nam))
            (setq fg (cdr (assoc 70 vr)))
            (setq vc (cdr (assoc 10 vr)))
            (setq vh (cdr (assoc 40 vr)))
            (setq vw (cdr (assoc 41 vr)))
            (if (> vw (* vh (/ 1 aratio)))
            (setq vh (* vw aratio))
              (setq vw (* vh (/ 1.0 aratio)))
            )
            (setq x1 (- (car vc) (/ vw 2)))
            (setq y1 (- (cadr vc) (/ vh 2)))
            (setq x2 (+ (car vc) (/ vw 2)))
            (setq y2 (+ (cadr vc) (/ vh 2)))
          )
        )
        (grdraw (list x1 y1) (list x2 y1) -1 1)
        (grdraw (list x2 y1) (list x2 y2) -1 1)
        (grdraw (list x2 y2) (list x1 y2) -1 1)
        (grdraw (list x1 y2) (list x1 y1) -1 1)
      )
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq aratio (/ (cadr (getvar "SCREENSIZE")) (car (getvar "SCREENSIZE"))))
      (setq cur 0)
      (setq done nil)
      (setq viewtab (acad_strlsort (dstp_bldlst "VIEW")))
      (if (= nil viewtab)
        (alert "No Views Defined!")
        (progn
          (setq viewtab (acad_strlsort viewtab))
          (setq nam (nth 0 viewtab))
          (disvwrev_drwview nam 1)
          (while (/= done T)
            (setq tmp (strcase (getstring "\nDS> Option: Go/First/Last/Next/Previous/Select/Vmax/eXit <Next>: ")))
            (cond 
              ((= tmp "G")
                (disvwrev_drwview nam 0)
                (command "_.VIEW" "_R" nam)
                (setq done T)
              )
              ((= tmp "F")
                (disvwrev_drwview nam 0)
                (setq cur 0)
                (setq nam (nth cur viewtab))
                (disvwrev_drwview nam 1)
              )
              ((= tmp "L")
                (disvwrev_drwview nam 0)
                (setq cur (- (length viewtab) 1))
                (setq nam (nth cur viewtab))
                (disvwrev_drwview nam 1)
              )
              ((or (= tmp "")(= tmp "N"))
                (if (>= (1+ cur) (length viewtab))
                  (progn
                    (disvwrev_drwview nam 0)
                    (setq cur 0)
                    (setq nam (nth cur viewtab))
                    (disvwrev_drwview nam 1)
                  )
                  (progn
                    (disvwrev_drwview nam 0)
                    (setq cur (1+ cur))
                    (setq nam (nth cur viewtab))
                    (disvwrev_drwview nam 1)
                  )
                )
              )
              ((= tmp "P")
                (if (< (1- cur) 0)
                  (progn
                    (disvwrev_drwview nam 0)
                    (setq cur (- (length viewtab) 1))
                    (setq nam (nth cur viewtab))
                    (disvwrev_drwview nam 1)
                  )
                  (progn
                    (disvwrev_drwview nam 0)
                    (setq cur (1- cur))
                    (setq nam (nth cur viewtab))
                    (disvwrev_drwview nam 1)
                  )
                )
              )
              ((= tmp "S")
                (setq resp (dstp_tablesel "Select View" (acad_strlsort (dstp_bldlst "VIEW")) "s" ""))
                (if (/= resp nil)
                  (progn
                    (disvwrev_drwview nam 0)
                    (setq nam resp)
                    (disvwrev_drwview nam 1)
                  )
                )
              )
              ((= tmp "V")
                (command "_.ZOOM" "_V")
                (disvwrev_drwview nam 1)
              )
              ((= tmp "X")
                (setq viewtab nil)
                (disvwrev_drwview nam 0)
                (setq done T)
              )
              (t nil)
            )
          )
          (setq viewtab nil)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Dview Twist to Line Segment
; --------------------------------------------------------------------------

(defun c:DisVueTwi ( / ang cmdecho end hnd mid osmode pik tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq tmp (entsel "\nDS> Select Segment for Twist: "))
      (if (/= tmp nil)
        (progn
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq hnd (car tmp))
          (setq pik (cadr tmp))
          (setq end (osnap pik "_end"))
          (setq mid (osnap pik "_mid"))
          (setq ang (- 360.0 (dstp_rtd (angle mid end))))
          (command "_.DVIEW" hnd "" "_TW" ang "")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Quick Regen (Consolidated)
; --------------------------------------------------------------------------

(defun c:DisQuiReg ( / ar cc cmdecho frzlst hs laylst ln ls lt opt p1 p2
                           qtextmode resp slen slst ss sset str tmp vs x1 x2
                           y1 y2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "E L S T")
      (setq opt (getkword "\nDS> Option Entities/Layer/Screen/Thaw: "))
      (cond
        ((= opt "E")
          (setq sset (ssget))
          (setq slen (sslength sset))
          (setq str "DS> Processing Selection Set ... ")
          (princ (strcat "\n" str "\r" str))
          (setq qtextmode (getvar "QTEXTMODE"))
          (if (= qtextmode 1)
            (setvar "QTEXTMODE" 0)
          )
          (setq slst (reverse (dstp_ss2lst sset)))
          (foreach hnd slst
            (entupd hnd)
          )
          (princ "Done.\r")
          (setq sset nil)
          (setvar "QTEXTMODE" qtextmode)
        )
        ((= opt "L")
          (setq laylst nil)
          (setq tmp (dstp_bldlst "LAYER"))
          (foreach lay tmp
            (if (not (dstp_instr lay "|"))
              (setq laylst (append laylst (list lay)))
            )
          )
          (if (> (length laylst) 0)
            (progn
              (setq resp (dstp_tablesel "Select Layer(s)" (acad_strlsort laylst) "m" ""))
              (if (/= resp nil)
                (progn
                  (foreach nam resp
                    (princ (strcat "\nDS> Regenerating Layer: " nam))
                    (command "_.LAYER" "_ON" nam "")
                    (command "_.LAYER" "_T" nam "")
                    (setq sset (ssget "_X" (list (cons 8 nam))))
                    (if sset
                      (progn
                        (setq slst (reverse (dstp_ss2lst sset)))
                        (foreach hnd slst
                          (entupd hnd)
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
        ((= opt "S")
          (setq ss (getvar "SCREENSIZE"))
          (setq ar (/ (cadr ss) (car ss)))
          (setq cc (getvar "VIEWCTR"))
          (setq vs (getvar "VIEWSIZE"))
          (setq hs (/ vs ar))
          (setq x1 (- (car cc) (/ hs 2)))
          (setq y1 (- (cadr cc) (/ vs 2)))
          (setq x2 (+ (car cc) (/ hs 2)))
          (setq y2 (+ (cadr cc) (/ vs 2)))
          (setq p1 (list x1 y1))
          (setq p2 (list x2 y2))
          (setq sset (ssget "_C" p1 p2))
          (if sset
            (progn
              (princ "\nDS> Regenerating Viewport Objects ... \rDS> Regenerating Viewport Objects ... ")
              (setq slst (reverse (dstp_ss2lst sset)))
              (foreach hnd slst
                (entupd hnd)
              )
              (princ "Done.")
            )
          )
        )
        ((= opt "T")
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq frzlst nil)
          (setq lt (tblnext "LAYER" T))
          (while (/= lt nil)
            (setq ln (cdr (assoc 2 lt)))
            (setq ls (cdr (assoc 70 lt)))
            (if (= (boole 1 (- ls 64) 1) 1)
              (setq frzlst (append frzlst (list ln)))
            )
            (setq lt (tblnext "LAYER"))
          )
          (if (> (length frzlst) 0)
            (progn
              (setq resp (dstp_tablesel "Select Layer(s) to Thaw" (acad_strlsort frzlst) "m" ""))
              (if (/= resp nil)
                (progn
                  (if (/= (getvar "REGENMODE") 0)
                    (progn
                      (setvar "REGENMODE" 0)
                      (princ "\nDS> NOTICE: REGENAUTO has been turned off!")
                    )
                  )
                  ;
                  (princ "\nDS> REDRAW required for layer status change.")
                  (command "_.LAYER")
                  (foreach nam resp
                    (command "_T" nam "_ON" nam)
                  )
                  (command "")
                  (foreach nam resp
                    (princ (strcat "\nDS> Regenerating Layer: " nam))
                    (command "_.LAYER" "_T" nam "_ON" nam "")
                    (setq sset (ssget "_X" (list (cons 8 nam))))
                    (if sset 
                      (progn
                        (setq slst (reverse (dstp_ss2lst sset)))
                        (foreach hnd slst
                          (entupd hnd)
                        )
                      )
                    )
                  )
                )
              )
            )
            (princ "\nDS> NOTICE: No layers are currently FROZEN!")
          )
          (setq sset nil)
          (setq frzlst nil)
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; ###########################################################################
;                                DRAWTOOL
; ###########################################################################

; ---------------------------------------------------------------------------
;                        Draw Bounding Shrink Polylines
; ---------------------------------------------------------------------------

(defun c:DrwWrpBnd ( / cmdecho del done elevation ent fnd hnd ign itm jset
                       lst new nset num nxt obj osmode pnt pntmrk pt1 pt2
                       pt3 pt4 sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq elevation (getvar "ELEVATION"))
      (setvar "ELEVATION" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select 3DFACE, CIRCLE, LW/2D/3DPOLYLINE and SPLINE objects ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "CIRCLE")(0 . "3DFACE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (initget "Y N")
          (setq tmp (getkword "\nDS> Delete source geometry Y/<N>: "))
          (if (= tmp "Y")(setq del T)(setq del nil))
          (setq ign 0)
          (setq nset (ssadd))
          (command "_.POINT" "0,0")
          (setq pntmrk (entlast))
          (princ (strcat "\nDS> Evaluating Input Geometry ..." (chr 13)))
          (setq itm 0 num (sslength sset))
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "3DFACE")
                (setq lst nil)
                (setq pt1 (dstp_2dpoint (cdr (assoc 10 ent))))
                (setq pt2 (dstp_2dpoint (cdr (assoc 11 ent))))
                (setq pt3 (dstp_2dpoint (cdr (assoc 12 ent))))
                (setq pt4 (dstp_2dpoint (cdr (assoc 13 ent))))
                (setq lst (list pt1))
                (if (not (equal pt2 pt1))
                  (setq lst (append lst (list pt2)))
                )
                (if (not (equal pt3 pt2))
                  (setq lst (append lst (list pt3)))
                )
                (if (and (not (equal pt4 pt3))(not (equal pt4 pt1)))
                  (setq lst (append lst (list pt4)))
                )
                (command "_.PLINE")
                (foreach pnt lst
                  (command pnt)
                )
                (command "_C")
                (setq nset (ssadd (entlast) nset))
              )
              ((= obj "CIRCLE")
                (command "_.COPY" hnd "" "0,0,0" "@")
                (setq nset (ssadd (entlast) nset))
              )
              ((= obj "POLYLINE")
                (if (= (boole 1 (cdr (assoc 70 ent)) 1) 1)
                  (progn
                    (dstp_getpline hnd)
                    (if (= (car dstp_plhdr) "3D")
                      (progn
                        (setq new nil)
                        (setq dstp_plhdr (list "LW" 1 (nth 2 dstp_plhdr) (nth 3 dstp_plhdr) nil nil 0.0 0.0))
                        (foreach rec dstp_pldat
                          (setq pnt (car rec))
                          (setq pnt (list (car pnt) (cadr pnt) 0.0))
                          (setq rec (list pnt 0.0 0.0 0.0 0.0))
                          (setq new (append new (list rec)))
                        )
                        (setq dstp_pldat new)
                        (dstp_makepline)
                        (setq new nil)
                        (setq nset (ssadd (entlast) nset))
                      )
                      (progn
                        (command "_.COPY" hnd "" "0,0,0" "@")
                        (setq nset (ssadd (entlast) nset))
                      )
                    )
                  )
                  (setq ign (1+ ign))
                )
              )
              ((= obj "LWPOLYLINE")
                (if (= (boole 1 (cdr (assoc 70 ent)) 1) 1)
                  (progn
                    (command "_.COPY" hnd "" "0,0,0" "@")
                    (setq nset (ssadd (entlast) nset))
                  )
                  (setq ign (1+ ign))
                )
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
          (if (= del T)
            (command "_.ERASE" sset "")
          )
          (if (> (sslength nset) 1)
            (progn
              (princ (strcat "\nDS> Checking for Demand Loaded Support ..." (chr 13)))
              (command "_.BOX")
              (command)
              (command "_.REGION" nset "")
              (princ (strcat "\nDS> Determining Extents of Polygons ..." (chr 13)))
              (setq nset (ssadd))
              (setq nxt pntmrk)
              (while (/= nxt nil)
                (setq nxt (entnext nxt))
                (if (/= nxt nil)
                  (setq nset (ssadd nxt nset))
                )
              )
              (command "_.UNION" nset "")
              (command "_.EXPLODE" "_L")
              (princ (strcat "\nDS> Assembling Polyline Boundaries ..." (chr 13)))
              (setq done nil)
              (while (/= done T)
                (setq fnd nil)
                (setq jset (ssadd))
                (setq nxt pntmrk)
                (while (/= nxt nil)
                  (setq nxt (entnext nxt))
                  (if (/= nxt nil)
                    (progn
                      (setq obj (cdr (assoc 0 (entget nxt))))
                      (if (or (= obj "LINE")(= obj "ARC"))
                        (setq fnd T jset (ssadd nxt jset))
                      )
                    )
                  )
                )
                (if (= fnd T)
                  (if (= (getvar "PEDITACCEPT") 0)
                    (command "_.PEDIT" (ssname jset 0) "_Y" "_J" jset "" "_X")
                    (command "_.PEDIT" (ssname jset 0) "_J" jset "" "_X")
                  )
                  (setq done T)
                )
                (setq jset nil)
              )
              (entdel pntmrk)
              (command "_.SELECT" sset "")
              (princ (strcat "\nDS> Process Complete." (chr 13)))
              (if (> ign 0)
                (princ (strcat "\nDS> Ignored (" (itoa ign) ") Open Polylines!"))
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
      (setvar "ELEVATION" elevation)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                              Draw Bisecting Line
; --------------------------------------------------------------------------

(defun c:DrwLinBis ( / an1 an2 ang chk cmdecho haf l1d1 l1d2 l1p1 l1p2
                          l2d1 l2d2 l2p1 l2p2 na orthomode osmode pt1
                          pt2 sg1 sg2 snapang snapbase snapmode uba)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq sg1 (entsel "\nDS> Select 1st Segment: "))
      (if (/= sg1 nil)
        (progn
          (setq sg2 (entsel "\nDS> Select 2nd Segment: "))
          (if (/= sg2 nil)
            (progn
              (setq l1p1 (osnap (cadr sg1) "_mid"))
              (setq l1p2 (osnap (cadr sg1) "_end"))
              (setq l2p1 (osnap (cadr sg2) "_mid"))
              (setq l2p2 (osnap (cadr sg2) "_end"))
              (setq chk (inters l1p1 l1p2 l2p1 l2p2 nil))
              (if (/= chk nil)
                (progn
                  (setq l1d1 (distance chk l1p1))
                  (setq l1d2 (distance chk l1p2))
                  (if (> l1d1 l1d2)
                    (setq pt1 l1p1)
                    (setq pt1 l1p2)
                  )
                  (setq l2d1 (distance chk l2p1))
                  (setq l2d2 (distance chk l2p2))
                  (if (> l2d1 l2d2)
                    (setq pt2 l2p1)
                    (setq pt2 l2p2)
                  )
                  (setq an1 (+ (angle chk pt1) (* pi 2.0)))
                  (setq an2 (+ (angle chk pt2) (* pi 2.0)))
                  (setq ang (abs (- an2 an1)))
                  (setq haf (/ ang 2.0))
                  (if (< an1 an2)
                    (setq uba an1)
                    (setq uba an2)
                  )
                  (setq na (+ uba haf))
                  (setq cmdecho (getvar "CMDECHO"))
                  (setq snapang (getvar "SNAPANG"))
                  (setq snapbase (getvar "SNAPBASE"))
                  (setq snapmode (getvar "SNAPMODE"))
                  (setq orthomode (getvar "ORTHOMODE"))
                  (command "_.UNDO" "_G")
                  (dstp_ucspush)
                  (command "_.SNAP" "_R" "" (dstp_rtd na))
                  (setvar "SNAPMODE" 0)
                  (setvar "ORTHOMODE" 1)
                  (prompt "\nDS> Pick Point or Enter Distance: ")
                  (command "_.LINE" chk pause "")
                  (dstp_ucspop)
                  (command "_.UNDO" "_E")
                  (setvar "CMDECHO" cmdecho)
                  (setvar "SNAPANG" snapang)
                  (setvar "SNAPBASE" snapbase)
                  (setvar "SNAPMODE" snapmode)
                  (setvar "ORTHOMODE" orthomode)
                )
              )
            )
          )
        )
      )
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Draw Line Perpendicular to another
; --------------------------------------------------------------------------

(defun c:DrwLinPrp ( / *error* cmdecho olderr orthomode osmode pik
                        pnt pt1 pt2 snapang snapbase snapmode)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun drwperp_error (s)
        (if (/= s "Function cancelled.")
          (progn
            (setvar "SNAPANG" snapang)
            (setvar "SNAPBASE" snapbase)
            (setvar "SNAPMODE" snapmode)
            (setvar "ORTHOMODE" orthomode)
            (setvar "OSMODE" osmode)
            (setvar "CMDECHO" cmdecho)
            (setq *error* olderr)
          )
        )
        (if olderr (setq *error* olderr))
        (princ)
      )
      (setq olderr *error* *error* drwperp_error)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq snapang (getvar "SNAPANG"))
      (setq snapbase (getvar "SNAPBASE"))
      (setq snapmode (getvar "SNAPMODE"))
      (setq orthomode (getvar "ORTHOMODE"))
      (setq osmode (getvar "OSMODE"))
      (initget "E")
      (setq pik (getpoint "\nDS> End/<Pick Point On Segment>: "))
      (if (= pik "E")
        (progn
          (setq pik (entsel "\nDS> Select Object Near Desired End: "))
          (setvar "OSMODE" 0)
          (setq pnt (cadr pik))
          (setq pt1 (osnap pnt "_end"))
          (setq pt2 (osnap pnt "_nea"))
        )
        (progn
          (setvar "OSMODE" 0)
          (setq pt1 (osnap pik "_nea"))
          (setq pt2 (osnap pt1 "_end"))
          (if (equal pt1 pt2)
            (setq pt2 (osnap pt1 "_mid"))
          )
        )
      )
      (command "_.SNAP" "_R" pt1 pt2)
      (setvar "SNAPMODE" 0)
      (setvar "ORTHOMODE" 1)
      (prompt "\nDS> To Point (or Enter Distance): ")
      (command "_.LINE" pt1 pause "")
      (setvar "SNAPANG" snapang)
      (setvar "SNAPBASE" snapbase)
      (setvar "SNAPMODE" snapmode)
      (setvar "ORTHOMODE" orthomode)
      (setvar "OSMODE" osmode)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setq *error* olderr)
    )
  )
  (princ)
)

; ---------------------------------------------------------------------------
;                          Create Shadow Rectangle
; ---------------------------------------------------------------------------

(defun c:DrwShaRec (/ llc urc ulc lrc sav rnd plw ll1 ll2 ur1 ur2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "R S")
      (setq opt (getkword "\nDS> Option Rounded/Squared: "))
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq plw (getvar "PLINEWID"))
      (if (= plw 0.0)(setq plw (* (getvar "TEXTSIZE") 0.5)))
      (setq tmp (getdist (strcat "\nDS> Polyline Width <" (rtos plw 2 2) ">: ")))
      (if (/= tmp nil)(setq plw tmp))
      (if (= opt "R")
        (progn
          (setq frd (getvar "FILLETRAD"))
          (if (= frd 0.0)(setq frd (* plw 3.0)))
          (setq tmp (getdist (strcat "\nDS> Fillet Radius <" (rtos frd 2 2) ">: ")))
          (if (/= tmp nil)(setq frd tmp))
        )
      )
      (if (> plw 0.0)
        (progn
          (setq llc (getpoint "\nDS> Pick LL Corner: "))
          (setq urc (getcorner "\nDS> Pick UR Corner: " llc))
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (if (= opt "S")  ; squared
            (progn
              (setq ll1 (list (car llc) (+ (cadr llc) (/ plw 2))))
              (setq ll2 (list (+ (car llc) plw) (cadr llc)))
              (setq ulc (list (car llc) (cadr urc)))
              (setq ur1 (list (- (car urc) (/ plw 2)) (cadr urc)))
              (setq ur2 (list (car urc) (- (cadr urc) plw)))
              (setq lrc (list (car urc) (cadr llc)))
              (command "_.PLINE" ll1 "_W" 0 0 ulc ur1 "_W" 0 plw ur2 lrc ll2 "_W" plw 0 "_C")
            )
          )
          (if (= opt "R")  ; rounded
            (progn
              (setq ulc (list (car llc) (cadr urc)))
              (setq lrc (list (car urc) (cadr llc)))
              (command "_.PLINE" llc "_W" plw "" lrc urc "_W" 0 "" ulc "_C")
              (command "_.FILLET" "_R" frd "_.FILLET" "_P" llc)
            )
          )
          (setvar "OSMODE" osmode)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;           Label Elevation w/Rotate Option, Optional Trim Around
; --------------------------------------------------------------------------

(defun c:DrwLabElv ( / avg bos box brk chk cmdecho dec def elv ent fac g10
                        hnd los miss new osmode p1 p10 p11 p12 p2 p3 p4 p5
                        p6 p7 p8 p9 plinewid pnt rect ros sset sum tmp tos)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq dec 0)
      (setq tmp (getint (strcat "\nDS> Number of Decimal Places <0>: ")))
      (if (/= tmp nil)(setq dec tmp))
      (initget "Y N")
      (setq brk (getkword "\nDS> Trim Objects Around Text <Y>/N: "))
      (if (/= brk "N")
        (progn
          (setq brk "Y")
          (setq avg 0.0)
          (setq def (* 0.20 (dstp_textsize)))
          (setq tmp (getreal (strcat "\nDS> Left Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
          (if (/= tmp nil)(setq los tmp def tmp)(setq los def))
          (setq tmp (getreal (strcat "\nDS> Right Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
          (if (/= tmp nil)(setq ros tmp def tmp)(setq ros def))
          (setq tmp (getreal (strcat "\nDS> Top Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
          (if (/= tmp nil)(setq tos tmp def tmp)(setq tos def))
          (setq tmp (getreal (strcat "\nDS> Bottom Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
          (if (/= tmp nil)(setq bos tmp def tmp)(setq bos def))
          (setq sum (+ los ros tos bos))
          (if (> sum 0.0)(setq avg (/ sum 4.0)))
          (if (> avg 0.0)
            (setq fac (/ avg 2.0))
            (setq fac (/ (dstp_textsize) 10.0))
          )
        )
        (setq brk "N")
      )
      (setq miss nil)
      (while (= miss nil)
        (setq chk (nentsel "\nDS> Pick Object to Label Elevation: "))
        (if (/= chk nil)
          (progn
            (setq hnd (car chk))
            (setq pnt (cadr chk))
            (setq ent (entget hnd))
            (if (= (cdr (assoc 0 ent)) "LWPOLYLINE")
              (if (= (cdr (assoc 38 ent)) nil)
                (setq elv 0.0)
                (setq elv (cdr (assoc 38 ent)))
              )
              (setq elv (caddr (cdr (assoc 10 ent))))
            )
            (setq g10 (assoc 10 ent))
            (if (/= g10 nil)
              (progn
                (setq def (rtos elv 2 dec))
                (setq new '((0 . "TEXT")))
                (setq new (append new (list (list 10 0.0 0.0 elv))))
                (setq new (append new (list (list 11 (nth 0 pnt) (nth 1 pnt) elv))))
                (setq new (append new (list (cons 40 (dstp_textsize)))))
                (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
                (setq new (append new (list (cons 1 def))))
                (setq new (append new (list (cons 72 4))))
                (setq new (append new (list (cons 73 0))))
                (entmake new)
                (setq hnd (entlast))
                (princ (strcat "\nDS> Rotation Angle For [" def "]: "))
                (command "_.ROTATE" hnd "" pnt "_R" "" pause)
                (if (= brk "Y")
                  (progn
                    (setq plinewid (getvar "PLINEWID"))
                    (setvar "PLINEWID" 0.0)
                    (setq ent (entget hnd))
                    (setq rect (dstp_textrect ent))
                    (setq p1 (car rect))
                    (setq p2 (cadr rect))
                    (setq p3 (caddr rect))
                    (setq p4 (cadddr rect))
                    (setq p5 (polar p1 (angle p2 p1) los))
                    (setq p5 (polar p5 (angle p4 p1) bos))
                    (setq p6 (polar p2 (angle p1 p2) ros))
                    (setq p6 (polar p6 (angle p3 p2) bos))
                    (setq p7 (polar p3 (angle p4 p3) ros))
                    (setq p7 (polar p7 (angle p2 p3) tos))
                    (setq p8 (polar p4 (angle p3 p4) los))
                    (setq p8 (polar p8 (angle p1 p4) tos))
                    (setq p9 (polar p5 (angle p5 p6) fac))
                    (setq p9 (polar p9 (angle p5 p8) fac))
                    (setq p10 (polar p6 (angle p6 p5) fac))
                    (setq p10 (polar p10 (angle p6 p7) fac))
                    (setq p11 (polar p7 (angle p7 p8) fac))
                    (setq p11 (polar p11 (angle p7 p6) fac))
                    (setq p12 (polar p8 (angle p8 p7) fac))
                    (setq p12 (polar p12 (angle p8 p5) fac))
                    (command "_.PLINE" p5 p6 p7 p8 "_C")
                    (setq box (entlast))
                    ;
                    (command "_.TRIM" box "")
                    (repeat 2
                      (command "_F" p9 p10 "")
                      (command "_F" p10 p11 "")
                      (command "_F" p11 p12 "")
                      (command "_F" p12 p9 "")
                    )
                    (command "")
                    ;
                    (entdel box)
                    (setvar "PLINEWID" plinewid)
                  )
                )
              )
              (setq miss T)
            )
          )
          (setq miss T)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Label Object Properties
; --------------------------------------------------------------------------

(defun c:DrwLabPrp ( / ali ang chk cmdecho ent hnd miss new obj opt
                         orthomode p1 p2 pic pnt tmp val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (initget "LA LT C B T")
      (setq opt (getkword "\nDS> Label LAyer/LType/Color/Block/Type: "))
      (initget "N Y")
      (setq tmp (getkword "\nDS> Align With Object Y/<N>: "))
      (if (/= tmp "Y")(setq ali nil)(setq ali T))
      (setq miss nil)
      (while (= miss nil)
        (setq pic (entsel "\nDS> Select Object to Label: "))
        (if (/= pic nil)
          (progn
            (setq hnd (car pic))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (setq pnt (cadr pic))
            (setq val "")
            (cond
              ((= opt "C")
                (setq chk (assoc 62 ent))
                (if (/= chk nil)
                  (setq val (itoa (cdr chk)))
                  (setq val "BYLAYER")
                )
              )
              ((= opt "LA")
                (setq val (cdr (assoc 8 ent)))
              )
              ((= opt "LT")
                (setq chk (assoc 6 ent))
                (if (/= chk nil)
                  (setq val (cdr chk))
                  (setq val "BYLAYER")
                )
              )
              ((= opt "B")
                (if (= obj "INSERT")
                  (setq val (cdr (assoc 2 ent)))
                  (princ "\nDS> Selected Object was not an INSERT!")
                )
              )
              ((= opt "T")
                (setq val (cdr (assoc 0 ent)))
              )
              (t nil)
            )
            (if (= ali T)
              (progn
                (setq p1 (osnap pnt "_end"))
                (setq p2 (osnap pnt "_mid"))
                (setq ang (angle p1 p2))
              )
              (setq ang 0.0)
            )
            (if (/= val "")
              (progn
                (setq new '((0 . "TEXT")))
                (setq new (append new (list (list 10 0.0 0.0 0.0))))
                (setq new (append new (list (list 11 (nth 0 pnt) (nth 1 pnt) (nth 2 pnt)))))
                (setq new (append new (list (cons 40 (dstp_textsize)))))
                (setq new (append new (list (cons 50 ang))))
                (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
                (setq new (append new (list (cons 1 val))))
                (setq new (append new (list (cons 72 4))))
                (setq new (append new (list (cons 73 0))))
                (entmake new)
                (setq hnd (entlast))
                (princ (strcat "\nDS> Placement Position For [" val "]: "))
                (setq orthomode (getvar "ORTHOMODE"))
                (setvar "ORTHOMODE" 0)
                (command "_.MOVE" hnd "" (trans pnt 0 1) pause)
                (setvar "ORTHOMODE" orthomode)
              )
            )
          )
          (setq miss T)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Arc Leader Place
; --------------------------------------------------------------------------

(defun c:DrwLeaArc ( / alen axo chk cmdecho cpt1 cpt2 highlight hnd lset mrk
                       osmode pt1 pt2 rot rpt tj tlen tp tsize upt x1 x2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tsize (dstp_textsize))
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd))
      )
      (setq pt1 (getpoint "\nDS> Starting Point of Leader: "))
      (setq pt2 (getpoint pt1 "\nDS> Ending Point of Leader: "))
      (setq x1 (car pt1))
      (setq x2 (car pt2))
      (if (> x2 x1)
        (setq tj "_ML")
        (setq tj "_MR")
      )
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (princ "\nDS> Direction of Arc: ")
      (command "_.ARC" pt1 "_E" pt2 "_D" pause)
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd (entlast) lset))
      )
      (setq hnd (entlast))
      (setq ent (entget hnd))
      (setq axo (vlax-ename->vla-object hnd))
      (setq rads (cdr (assoc 40 ent)))
      (setq sang (cdr (assoc 50 ent)))
      (setq eang (cdr (assoc 51 ent)))
      (if (> eang sang)
        (setq iang (- eang sang))
        (setq iang (+ (- 6.28319 sang) eang))
      )
      (setq tlen (* iang rads))
      (setq alen (* tsize 1.0))
      (setq cpt1 (vlax-curve-getPointAtDist axo alen))
      (setq cpt2 (vlax-curve-getPointAtDist axo (- tlen alen)))
      (if (< (distance pt1 cpt1)(distance pt1 cpt2))
        (setq upt cpt1 rpt cpt2)
        (setq upt cpt2 rpt cpt1)
      )
      (command "_.PLINE" pt1 "_W" 0 (* tsize dstp_arrowscl) upt "_W" 0 0 "")
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd (entlast) lset))
      )
      (if (= dstp_leaalitxt 1)
        (progn
          (if (> x2 x1)
            (setq rot (angle rpt pt2))
            (setq rot (angle pt2 rpt))
          )
          (setq tp (polar pt2 rot (* tsize 0.7)))
        )
        (progn
          (setq rot (getvar "ANGBASE"))
          (if (> x2 x1)
            (setq tp (polar pt2 rot (* tsize 0.7)))
            (setq tp (polar pt2 (+ rot PI) (* tsize 0.7)))
          )
        )
      )
      (if (= dstp_leagrpgeo 1)
        (setq mrk (entlast))
      )
      (if (> (dstp_fixedhgt) 0.0)
        (command "_.DTEXT" "_J" tj tp (dstp_rtd rot))
        (command "_.DTEXT" "_J" tj tp tsize (dstp_rtd rot))
      )
      (if (= dstp_leagrpgeo 1)
        (progn
          (setq chk mrk)
          (while (/= chk nil)
            (setq chk (entnext chk))
            (if (/= chk nil)
              (setq lset (ssadd chk lset))
            )
          )
          (setq highlight (getvar "HIGHLIGHT"))
          (setvar "HIGHLIGHT" 0)
          (command "-GROUP" "" "*" "" lset "")
          (setvar "HIGHLIGHT" highlight)
          (setq lset nil)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                               Bubble Leader
; --------------------------------------------------------------------------

(defun c:DrwLeaBub ( / celtype cmdecho cpt dia ep highlight lset pt1 pt2
                          str tsize x1 x2 xp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq pt1 (getpoint "\nDS> Leader Start Point: "))
      (setq pt2 (getpoint pt1 "\nDS> Leader End Point: "))
      (setq str (getstring "\nDS> Bubble Text Label: "))
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd))
      )
      (setq tsize (dstp_textsize))
      (setq celtype (getvar "CELTYPE"))
      (setvar "CELTYPE" "CONTINUOUS")
      (setq xp (polar pt1 (angle pt1 pt2) (* tsize 1.0)))
      (setq x1 (car pt1))
      (setq x2 (car pt2))
      (if (> x2 x1)
        (setq ep (polar pt2 0 (* tsize 0.7)))
        (setq ep (polar pt2 pi (* tsize 0.7)))
      )
      (command "_.PLINE" pt1 "_W" 0 (* tsize dstp_arrowscl) xp "_W" 0 0 pt2 ep "")
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd (entlast) lset))
      )
      (setq dia (* dstp_bublfact tsize))
      (setq cpt (polar ep (angle pt2 ep) dia))
      (command "_.CIRCLE" cpt dia)
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd (entlast) lset))
      )
      (if (> (dstp_fixedhgt) 0.0)
        (command "_.TEXT" "_J" "M" cpt (dstp_rtd (getvar "ANGBASE")) str)
        (command "_.TEXT" "_J" "M" cpt tsize (dstp_rtd (getvar "ANGBASE")) str)
      )
      (if (= dstp_leagrpgeo 1)
        (setq lset (ssadd (entlast) lset))
      )
      (if (= dstp_leagrpgeo 1)
        (progn
          (setq highlight (getvar "HIGHLIGHT"))
          (setvar "HIGHLIGHT" 0)
          (command "-GROUP" "" "*" "" lset "")
          (setvar "HIGHLIGHT" highlight)
          (setq lset nil)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CELTYPE" celtype)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                               Adjacent Bubble
; --------------------------------------------------------------------------

(defun c:DrwLeaBua ( / celtype cmdecho cpt dis ent highlight hnd lset
                          ncp obj ppt qp1 qp2 qp3 qp4 rad str tmp tsize upt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq tmp (entsel "\nDS> Pick Existing Bubble near Quadrant: "))
      (if (/= tmp nil)
        (progn
          (setq ppt (cadr tmp))
          (setq hnd (car tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (if (= obj "CIRCLE")
            (progn
              (setq str (getstring "\nDS> Adjacent Bubble Text Label: "))
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (if (= dstp_leagrpgeo 1)
                (setq lset (ssadd))
              )
              (setq tsize (dstp_textsize))
              (setq celtype (getvar "CELTYPE"))
              (setvar "CELTYPE" "CONTINUOUS")
              (setq cpt (cdr (assoc 10 ent)))
              (setq rad (cdr (assoc 40 ent)))
              (setq qp1 (polar cpt 0 rad))
              (setq qp2 (polar cpt (/ pi 2.0) rad))
              (setq qp3 (polar cpt pi rad))
              (setq qp4 (polar cpt (+ pi (/ pi 2.0)) rad))
              (setq dis (* rad 100.0))
              (if (< (distance qp1 ppt) dis)
                (setq dis (distance qp1 ppt) upt qp1)
              )
              (if (< (distance qp2 ppt) dis)
                (setq dis (distance qp2 ppt) upt qp2)
              )
              (if (< (distance qp3 ppt) dis)
                (setq dis (distance qp3 ppt) upt qp3)
              )
              (if (< (distance qp4 ppt) dis)
                (setq dis (distance qp4 ppt) upt qp4)
              )
              (setq ncp (polar cpt (angle cpt upt)(* rad 2.0)))
              (command "_.CIRCLE" ncp rad)
              (if (= dstp_leagrpgeo 1)
                (setq lset (ssadd (entlast) lset))
              )
              (if (> (dstp_fixedhgt) 0.0)
                (command "_.TEXT" "_J" "M" ncp (dstp_rtd (getvar "ANGBASE")) str)
                (command "_.TEXT" "_J" "M" ncp tsize (dstp_rtd (getvar "ANGBASE")) str)
              )
              (if (= dstp_leagrpgeo 1)
                (setq lset (ssadd (entlast) lset))
              )
              (if (= dstp_leagrpgeo 1)
                (progn
                  (setq highlight (getvar "HIGHLIGHT"))
                  (setvar "HIGHLIGHT" 0)
                  (command "-GROUP" "" "*" "" lset "")
                  (setvar "HIGHLIGHT" highlight)
                  (setq lset nil)
                )
              )
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CELTYPE" celtype)
              (setvar "CMDECHO" cmdecho)
            )
            (princ "\nDS> Selected object was not a CIRCLE")
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Point at Distance along Object
; --------------------------------------------------------------------------

(defun c:DrwPntDis ( / 3do attent atthnd attreq atttag axo blkent blkhnd
                         cds chk cmdecho cpt dis dodot done ent hnd lpt lst
                         nam obj pnt rot str tmp tot wrd xsc ysc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq lst (dstp_bldlst "BLOCK"))
      (setq tmp (entsel "\nDS> Select linear object: "))
      (if (/= tmp nil)
        (progn
          (setq 3do nil)
          (setq hnd (car tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (setq lst (dstp_bldlst "BLOCK"))
          (setq lst (cons "AutoCAD Point" lst))
          (setq axo (vlax-ename->vla-object hnd))
          (setq nam (dstp_tablesel "Select Insert Object" (acad_strlsort lst) "s" ""))
          (if (/= nam nil)
            (progn
              (if (= (substr nam 1 8) "ToolPac ")
                (setq nam (substr nam 9 (- (strlen nam) 8)))
              )
              (if (/= nam "AutoCAD Point")
                (progn
                  (setq tmp (getreal "\nDS> Insertion X Scale <1.0>: "))
                  (if (= tmp nil)
                    (setq xsc 1.0)
                    (setq xsc tmp)
                  )
                  (setq tmp (getreal (strcat "\nDS> Insertion Y Scale <" (rtos xsc) ">: ")))
                  (if (= tmp nil)
                    (setq ysc xsc)
                    (setq ysc tmp)
                  )
                  (setq tmp (getreal "\nDS> Rotation Angle <0.0>: "))
                  (if (= tmp nil)
                    (setq rot 0.0)
                    (setq rot tmp)
                  )
                )
              )
              (if (/= nam "")
                (progn
                  (setq dodot nil)
                  (setq lst (dstp_attdef nam))
                  (if (/= lst nil)
                    (progn
                      (initget "Y N")
                      (setq tmp (getkword "\nDS> Fill dot variable attributes with values <Y>/N: "))
                      (if (/= tmp "N")(setq dodot T)(setq dodot nil))
                    )
                  )
                )
              )
              (if (vlax-curve-isPlanar axo)
                (setq wrd "Planar")
                (progn
                  (if (= obj "POLYLINE")
                    (progn
                      (initget "S H")
                      (setq chk (getkword "\nDS> (3DPOLY) Use Horizontal/Slope Distances H/<S>: "))
                      (if (= chk "H")
                        (progn
                          (setq 3do "H")
                          (setq wrd "Planar")
                          (dstp_getpline hnd)
                        )
                        (progn
                          (setq 3do "S")
                          (setq wrd "Slope")
                        )
                      )
                    )
                    (progn
                      (setq 3do nil)
                      (setq wrd "[NON-PLANAR]")
                    )
                  )
                )
              )
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (setq done nil)
              (while (/= done T)
                (setq dis (getdist (strcat "\nDS> " wrd " Distance Along Object: ")))
                (if (/= dis nil)
                  (progn
                    (if (/= 3do "H")
                      (setq pnt (vlax-curve-getPointAtDist axo dis))
                      (progn
                        (setq tot 0.0)
                        (setq pnt nil)
                        (setq lpt (dstp_2dpoint (car (car dstp_pldat))))
                        (foreach rec dstp_pldat
                          (setq cpt (dstp_2dpoint (car rec)))
                          (setq cds (distance lpt cpt))
                          (if (and (= pnt nil)(>= (+ tot cds) dis))
                            (progn
                              (setq pnt (polar lpt (angle lpt cpt)(- dis tot)))
                              (setq pnt (osnap pnt "_nea"))
                            )
                          )
                          (setq tot (+ tot cds))
                          (setq lpt cpt)
                        )
                      )
                    )
                    (if (/= pnt nil)
                      (progn
                        (if (= nam "AutoCAD Point")
                          (command "_.POINT" pnt)
                          (progn
                            (setq attreq (getvar "ATTREQ"))
                            (setvar "ATTREQ" 0)
                            (command "_.INSERT" nam pnt xsc ysc rot)
                            (setvar "ATTREQ" attreq)
                            (if (= dodot T)
                              (progn
                                (setq blkhnd (entlast))
                                (setq blkent (entget blkhnd))
                                (setq atthnd blkhnd)
                                (setq attent blkent)
                                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                                  (setq atthnd (entnext atthnd))
                                  (setq attent (entget atthnd))
                                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                                    (progn
                                      (setq str "")
                                      (setq atttag (cdr (assoc 2 attent)))
                                      (cond
                                        ((= atttag ".INSDIST")
                                          (setq str (rtos dis))
                                        )
                                        ((= atttag ".INSPTX")
                                          (setq str (rtos (nth 0 pnt)))
                                        )
                                        ((= atttag ".INSPTY")
                                          (setq str (rtos (nth 1 pnt)))
                                        )
                                        ((= atttag ".INSPTZ")
                                          (setq str (rtos (nth 2 pnt)))
                                        )
                                        (t nil)
                                      )
                                      (setq attent (subst (cons 1 str)(assoc 1 attent) attent))
                                      (entmod attent)
                                    )
                                  )
                                )
                                (entupd blkhnd)
                              )
                            )
                          )
                        )
                      )
                      (princ (strcat "\nDS> Specified distance " (rtos dis) " is out of range!"))
                    )
                  )
                  (setq done T)
                )
              )
            )
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Draw Interpolated Points
; --------------------------------------------------------------------------

(defun c:DrwPntInt ( / attent atthnd attreq atttag begel blkent blkhnd
                       cmdecho dist dodot ed el1 el2 hdist ini int lst miss
                       nam newel npxy pnt prise pt1 pt2 rot str thefac tmp
                       xsc ysc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun drwintrp_addpoint ()
        (if (/= pnt nil)
          (progn
            (if (= nam "AutoCAD Point")
              (command "_.POINT" pnt)
              (progn
                (setq attreq (getvar "ATTREQ"))
                (setvar "ATTREQ" 0)
                (command "_.INSERT" nam pnt xsc ysc rot)
                (setvar "ATTREQ" attreq)
                (if (= dodot T)
                  (progn
                    (setq blkhnd (entlast))
                    (setq blkent (entget blkhnd))
                    (setq atthnd blkhnd)
                    (setq attent blkent)
                    (while (/= "SEQEND" (cdr (assoc 0 attent)))
                      (setq atthnd (entnext atthnd))
                      (setq attent (entget atthnd))
                      (if (= (cdr (assoc 0 attent)) "ATTRIB")
                        (progn
                          (setq str "")
                          (setq atttag (cdr (assoc 2 attent)))
                          (cond
                            ((= atttag ".INSPTX")
                              (setq str (rtos (nth 0 pnt)))
                            )
                            ((= atttag ".INSPTY")
                              (setq str (rtos (nth 1 pnt)))
                            )
                            ((= atttag ".INSPTZ")
                              (setq str (rtos (nth 2 pnt)))
                            )
                            (t nil)
                          )
                          (setq attent (subst (cons 1 str)(assoc 1 attent) attent))
                          (entmod attent)
                        )
                      )
                    )
                    (entupd blkhnd)
                  )
                )
              )
            )
          )
        )
      )
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq lst (dstp_bldlst "BLOCK"))
      (setq lst (append lst dstp_inslst))
      (setq nam (dstp_tablesel "Select Insert Object" (acad_strlsort lst) "s" ""))
      (if (/= nam nil)
        (progn
          (if (= (substr nam 1 8) "ToolPac ")
            (setq nam (substr nam 9 (- (strlen nam) 8)))
          )
          (if (/= nam "AutoCAD Point")
            (progn
              (setq tmp (getreal "\nDS> Insertion X Scale <1.0>: "))
              (if (= tmp nil)
                (setq xsc 1.0)
                (setq xsc tmp)
              )
              (setq tmp (getreal (strcat "\nDS> Insertion Y Scale <" (rtos xsc) ">: ")))
              (if (= tmp nil)
                (setq ysc xsc)
                (setq ysc tmp)
              )
              (setq tmp (getreal "\nDS> Rotation Angle <0.0>: "))
              (if (= tmp nil)
                (setq rot 0.0)
                (setq rot tmp)
              )
            )
          )
          (setq dodot nil)
          (setq lst (dstp_attdef nam))
          (if (/= lst nil)
            (progn
              (initget "Y N")
              (setq tmp (getkword "\nDS> Fill dot variable attributes with values <Y>/N: "))
              (if (/= tmp "N")(setq dodot T)(setq dodot nil))
            )
          )
          (setq int 0)
          (setq miss nil)
          (while (/= miss T)
            (setq pt1 (getpoint "\nDS> 1st Point: "))
            (if (/= pt1 nil)
              (progn
                (setq pt2 (getpoint "\nDS> 2nd Point: "))
                (if (/= pt2 nil)
                  (progn
                    (setq el1 (caddr pt1))
                    (setq el2 (caddr pt2))
                    (if (> el2 el1)
                      (princ (strcat "\nDS> Elevations Range from " (rtos el1) " to " (rtos el2)))
                      (princ (strcat "\nDS> Elevations Range from " (rtos el2) " to " (rtos el1)))
                    )
                    (setq ed (- el2 el1))
                    (setq dist (distance (dstp_2dpoint pt1)(dstp_2dpoint pt2)))
                    (if (or (= ed 0.0)(= dist 0.0))
                      (princ "\nDS> No slope detected!")
                      (progn
                        (setq thefac (/ 1.0 (/ ed dist)))
                        (setq begel (getreal "\nDS> Beginning Elevation: "))
                        (if (/= begel nil)
                          (progn
                            (setq ini (getreal "\nDS> Interval Value (enter for none): "))
                            (if (= ini nil)
                              (progn
                                (setq newel begel)
                                (setq prise (- newel el1))
                                (setq hdist (* thefac prise))
                                (setq npxy (polar (dstp_2dpoint pt1) (angle pt1 pt2) hdist))
                                (setq pnt (list (car npxy)(cadr npxy) newel))
                                (drwintrp_addpoint)
                              )
                              (progn
                                (setq newel begel)
                                (while (< newel el2)
                                  (setq prise (- newel el1))
                                  (setq hdist (* thefac prise))
                                  (setq npxy (polar (dstp_2dpoint pt1) (angle pt1 pt2) hdist))
                                  (setq pnt (list (car npxy)(cadr npxy) newel))
                                  (drwintrp_addpoint)
                                  (setq newel (+ newel ini))
                                )
                              )
                            )
                          )
                          (t nil)
                        )
                      )
                    )
                  )
                )
              )
              (setq miss T)
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                Draw Incrementing Numbers/Letters with Symbols
; --------------------------------------------------------------------------

(defun c:DrwLabInc ( / $value beg bxv cct cds chk cmdecho cursiz dcl_id
                         doproc ent figrad figsid grpgeo highlight hnd itm
                         lst miss newval num obj pnt pre prefix ptlst rad
                         rct rds rotpmt sid sset suf suffix tht tmp txtsiz
                         val wset wxv wyv xavg xsum yavg ysum)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun labincvl_dogray ()
        (cond
          ((= figsid "0")
            (set_tile "symnon" "1")
          )
          ((= figsid "1")
            (set_tile "symund" "1")
          )
          ((= figsid "2")
            (set_tile "symcir" "1")
          )
          (t
            (set_tile "sympol" "1")
            (set_tile "figsid" figsid)
          )
        )
        (if (< (atoi figsid) 2)
          (mode_tile "figrad" 1)
          (mode_tile "figrad" 0)
        )
        (if (< (atoi figsid) 3)
          (mode_tile "figsid" 1)
          (mode_tile "figsid" 0)
        )
      )
      (defun labincvl_settings ()
        (setq dcl_id (load_dialog "toolpac.dcl"))
        (if (not (new_dialog "labincvl" dcl_id)) (exit))
        (labincvl_dogray)
        (set_tile "figrad" figrad)
        (set_tile "txtsiz" txtsiz)
        (set_tile "prefix" prefix)
        (set_tile "suffix" suffix)
        (set_tile "newval" newval)
        (set_tile "grpgeo" grpgeo)
        (set_tile "rotpmt" rotpmt)
        (action_tile "symnon" "(setq figsid \"0\")(labincvl_dogray)")
        (action_tile "symund" "(setq figsid \"1\")(labincvl_dogray)")
        (action_tile "symcir" "(setq figsid \"2\")(labincvl_dogray)")
        (action_tile "sympol" "(setq figsid \"3\")(labincvl_dogray)")
        (action_tile "figrad" "(setq figrad $value)")
        (action_tile "figsid" "(setq figsid $value)")
        (action_tile "txtsiz" "(setq txtsiz $value)")
        (action_tile "prefix" "(setq prefix $value)")
        (action_tile "suffix" "(setq suffix $value)")
        (action_tile "newval" "(setq newval $value)")
        (action_tile "grpgeo" "(setq grpgeo $value)")
        (action_tile "rotpmt" "(setq rotpmt $value)")
        (action_tile "accept" "(setq doproc T)(done_dialog 0)")
        (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
        (action_tile "help" "(dstp_showhelp \"DrwLabInc.htm\")")
        (start_dialog)
        (unload_dialog dcl_id)
        (if (= doproc T)
          (progn
            (dstp_regstore "DrawInc" "figsid" figsid)
            (dstp_regstore "DrawInc" "figrad" figrad)
            (dstp_regstore "DrawInc" "txtsiz" txtsiz)
            (dstp_regstore "DrawInc" "prefix" prefix)
            (dstp_regstore "DrawInc" "suffix" suffix)
            (dstp_regstore "DrawInc" "grpgeo" grpgeo)
            (dstp_regstore "DrawInc" "rotpmt" rotpmt)
            (setq tht (atof txtsiz))
            (setq sid (atoi figsid))
            (setq rad (atof figrad))
            (setq pre prefix)
            (setq suf suffix)
            (setq val newval)
          )
        )
        (princ)
      )
      (defun labincvl_dolabel (pnt)
        (setq wset (ssadd))
        (setq tmp (strcat pre val suf))
        (cond
          ((= sid 1)
            (setq tmp (strcat "%%u" tmp "%%u")) 
          )
          ((= sid 2)
            (command "_.CIRCLE" pnt rad)
            (setq wset (ssadd (entlast) wset))
          )
          ((> sid 2)
            (command "_.POLYGON" sid pnt "_C" rad)
            (setq wset (ssadd (entlast) wset))
          )
          (t nil)
        )
        (if (> (dstp_fixedhgt) 0.0)
          (command "_.TEXT" "M" pnt "" tmp)
          (command "_.TEXT" "M" pnt tht "" tmp)
        )
        (setq wset (ssadd (entlast) wset))
        (if (= grpgeo "1")
          (if (> (sslength wset) 1)
            (progn
              (setq highlight (getvar "HIGHLIGHT"))
              (setvar "HIGHLIGHT" 0)
              (command "_.-GROUP" "" "*" "" wset "")
              (setvar "HIGHLIGHT" highlight)
            )
          )
        )
        (if (= rotpmt "1")
          (progn
            (command "_.ROTATE" wset "" pnt pause)
          )
        )
        (setq wset nil)
        (if (> (atoi val) 0)
          (setq val (itoa (+ (atoi val) 1)))
          (progn
            (setq lst (substr val (strlen val) 1))
            (setq chk (ascii lst))
            (if (< chk 90)
              (setq val (strcat (substr val 1 (- (strlen val) 1)) (chr (1+ chk))))
              (setq val (strcat (substr val 1 (- (strlen val) 1)) "AA"))
            )
          )
        )
      )
      (setq cursiz (dstp_textsize))
      (setq figsid (dstp_regfetch "DrawInc" "figsid" "2"))
      (setq figrad (dstp_regfetch "DrawInc" "figrad" (rtos (* cursiz 1.25))))
      (setq txtsiz (dstp_regfetch "DrawInc" "txtsiz" (rtos cursiz)))
      (setq prefix (dstp_regfetch "DrawInc" "prefix" ""))
      (setq suffix (dstp_regfetch "DrawInc" "suffix" ""))
      (setq grpgeo (dstp_regfetch "DrawInc" "grpgeo" "0"))
      (setq rotpmt (dstp_regfetch "DrawInc" "rotpmt" "0"))
      (setq newval "1")
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (setq tht (atof txtsiz))
      (setq sid (atoi figsid))
      (setq rad (atof figrad))
      (setq pre prefix)
      (setq suf suffix)
      (setq val newval)
      (setq miss nil)
      (while (/= miss T)
        (initget "S V O A")
        (setq pnt (getpoint (strcat "\nDS> Settings/Array/Objects/Value/<Point Location for (" (strcat pre val suf) ")>: ")))
        (cond
          ((= pnt "S")
            (labincvl_settings)
          )
          ((= pnt "V")
            (setq tmp (strcase (getstring (strcat "\nDS> Starting Number/Letter <1>: "))))
            (if (= tmp "")(setq val "1")(setq val tmp))
          )
          ((= pnt "A")
            (setq beg (getpoint "\nDS> Beginning Point: "))
            (setq rct (getint "\nDS> Number of Rows: "))
            (setq cct (getint "\nDS> Number of Cols: "))
            (setq rds (getdist "\nDS> Distance between Rows: "))
            (setq cds (getdist "\nDS> Distance between Cols: "))
            (setq bxv (car beg))
            (setq wyv (cadr beg))
            (repeat rct
              (setq wxv bxv)
              (repeat cct
                (labincvl_dolabel (list wxv wyv))
                (setq wxv (+ wxv cds))
              )
              (setq wyv (+ wyv rds))
            )
          )
          ((= pnt "O")
            (princ "\nDS> Select Objects to Label ...")
            (setq sset (ssget '((-4 . "<OR")(0 . "POINT")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "SPLINE")(-4 . "OR>"))))
            (if sset
              (progn
                (dstp_ucspush)
                (setq itm 0 num (sslength sset))
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq obj (cdr (assoc 0 ent)))
                  (cond
                    ((= obj "POINT")
                      (labincvl_dolabel (cdr (assoc 10 ent)))
                    )
                    (t
                      (setq ptlst (dstp_obj2lst hnd))
                      (setq xsum 0.0)
                      (setq ysum 0.0)
                      (foreach pnt ptlst
                        (setq xsum (+ xsum (car pnt)))
                        (setq ysum (+ ysum (cadr pnt)))
                      )
                      (setq xavg (/ xsum (length ptlst)))
                      (setq yavg (/ ysum (length ptlst)))
                      (labincvl_dolabel (list xavg yavg))
                    )
                  )
                  (setq itm (1+ itm))
                )
                (princ ", Done.")
                (dstp_ucspop)
              )
            )
          )
          (t
            (if (/= pnt nil)
              (labincvl_dolabel pnt)
                (setq miss T)
            )
          )
        )
      )
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                              Draw Tangent Arc/Line
; --------------------------------------------------------------------------

(defun c:DrwTanArc () (dstp_tangent 1))
(defun c:DrwTanLin () (dstp_tangent 2))

(defun dstp_tangent (opt / cpnt eang ech ent ept1 ept2 hnd obj orthomode
                           osmode pnt1 pnt2 ppt rads sang sch snapang
                           snapmode spt1 spt2 tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq osmode (getvar "OSMODE"))
      (setq orthomode (getvar "ORTHOMODE"))
      (setvar "OSMODE" 0)
      (setvar "ORTHOMODE" 0)
      (setq tmp (entsel "\nDS> Pick Segment Near Desired End: "))
      (if (/= tmp nil)
        (progn
          (setq hnd (car tmp))
          (setq ppt (cadr tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (if (or (= obj "POLYLINE")(= obj "LWPOLYLINE"))
            (progn
              (command "_.UNDO" "_M")
              (command "_.EXPLODE" hnd)
              (setq tmp (nentselp ppt))
              (setq hnd (car tmp))
              (setq ent (entget hnd))
              (setq obj (cdr (assoc 0 ent)))
              (command "_.UNDO" "_B")
            )
          )
          (cond 
            ((= obj "ARC")
              (setq cpnt (dstp_2dpoint (cdr (assoc 10 ent))))
              (setq rads (cdr (assoc 40 ent)))
              (setq sang (cdr (assoc 50 ent)))
              (setq eang (cdr (assoc 51 ent)))
              (setq spt1 (polar cpnt sang rads))
              (setq spt2 (polar spt1 (+ sang (/ pi 2.0)) 1.0))
              (setq ept1 (polar cpnt eang rads))
              (setq ept2 (polar ept1 (- eang (/ pi 2.0)) 1.0))
              (setq sch (distance spt1 ppt))
              (setq ech (distance ept2 ppt))
              (if (< sch ech)
                (setq pnt1 spt2 pnt2 spt1)
                (setq pnt1 ept2 pnt2 ept1)
              )
            )
            ((= obj "LINE")
              (setq pnt2 (osnap ppt "_END"))
              (setq pnt1 (osnap ppt "_MID"))
            )
            (t nil)
          )
          (if (or (equal ppt pnt1)(equal ppt pnt2))
            (princ "\nDS> Picked point was exactly on endpoint, do not use osnaps.")
            (progn
              (if (= opt 1)
                (progn
                  (command "_.LINE" pnt1 pnt2 "")
                  (command "_.ERASE" "_L" "")
                  (command "_.ARC" "" pause)
                )
                (progn
                  (setq snapang (getvar "SNAPANG"))
                  (setq snapmode (getvar "SNAPMODE"))
                  (command "_.SNAP" "_R" pnt1 pnt2)
                  (setvar "SNAPMODE" 0)
                  (setvar "ORTHOMODE" 1)
                  (prompt "\nDS> To Point:")
                  (command "_.LINE" pnt2 pause "")
                  (setvar "SNAPMODE" snapmode)
                  (setvar "SNAPANG" snapang)
                )
              )
            )
          )
        )
      )
      (setvar "ORTHOMODE" orthomode)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Generate Font Samples
; --------------------------------------------------------------------------

(defun c:DrwFntLeg ( / add chk cmdecho cod cpx cpy dir flst fnd fntfil
                         fontalt ipl ipr isf itf itm lst nam new osmode pth
                         rlst spt stynam tht tmp tot wds xlst)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (/= (ssget "_X") nil)
        (alert "Command must be started from\na new, empty drawing")
        (progn
          (initget "Y N")
          (setq itf (getkword "\nDS> Include TTF fonts <Y>/N: "))
          (if (/= itf "N")
            (setq flst (dstp_getfonts))
            (setq flst nil)
          )
          (initget "Y N")
          (setq isf (getkword "\nDS> Include SHX fonts <Y>/N: "))
          (if (= isf nil)(setq isf "Y"))
          (if (= isf "Y")
            (progn
              (setq pth (getenv "ACAD"))
              (setq tmp (dstp_pdf2lst pth ";"))
              (setq lst nil)
              (foreach pth tmp
                (setq dir (vl-directory-files pth "*.shx" 0))
                (foreach fil dir
                  (setq lst (append lst (list (strcat pth "\\" fil))))
                )
              )
              (setq rlst nil)
              (foreach fnt lst
                (setq nam (strcase (last (dstp_pdf2lst fnt "\\"))))
                (setq rlst (cons (list nam fnt) rlst))
                (setq flst (cons nam flst))
              )
            )
          )
          (if (/= flst nil)
            (progn
              (setq xlst (list "AECCLAND.SHX" "GDT" "GDT.SHX" "LTYPESHP.SHX" "MS OUTLOOK" "PROXY 1" "PROXY 2" "PROXY 3" "PROXY 4" "PROXY 5" "PROXY 6" "PROXY 7" "PROXY 8"  "PROXY 9" "PRX1" "PRX2" "PRX3" "PRX4" "PRX5" "PRX6" "PRX7" "PRX8" "PRX9" "SYASTRO" "SYASTRO.SHX" "SYMAP" "SYMAP.SHX" "SYMATH" "SYMATH.SHX" "SYMBOL" "SYMETEO" "SYMETEO.SHX" "SYMUSIC" "SYMUSIC.SHX" "WEBDINGS" "WINGDINGS" "WINGDINGS 2" "WINGDINGS 3"))
              (setq new nil)
              (foreach fnt flst
                (if (not (member (strcase fnt) xlst))
                  (setq new (cons fnt new))
                )
              )
              (setq flst nil)
              (foreach fnt new
                (setq add T)
                (if (= (dstp_instr (strcase fnt) ".SHX") nil)
                  (if (member (strcat (strcase fnt) ".SHX") new)
                    (setq add nil)
                  )
                )
                (if (= add T)
                  (setq flst (cons fnt flst))
                )
              )
              (setq flst (dstp_dupremove flst))
              (setq flst (acad_strlsort flst))
              (setq flst (dstp_tablesel "Process Files" flst "m" "T"))
              (if (/= flst nil)
                (progn
                  (setq spt (getpoint "\nDS> Top Center Point: "))
                  (setq tht (getdist (strcat "\nDS> Text Height <1.0>: ")))
                  (if (= tht nil)(setq tht 1.0))
                  (setq itm 0)
                  (setq cpx (car spt))
                  (setq cpy (cadr spt))
                  (setq tot (length flst))
                  (setq fontalt (getvar "FONTALT"))
                  (setvar "FONTALT" "txt.shx")
                  (setq osmode (getvar "OSMODE"))
                  (setvar "OSMODE" 0)
                  (setq cmdecho (getvar "CMDECHO"))
                  (setvar "CMDECHO" 0)
                  (command "_.UNDO" "_G")
                  (dstp_ucspush)
                  (foreach fnt flst
                    (princ (strcat "\rDS> Processing Font " (itoa (1+ itm)) " of " (itoa tot)))
                    (setq chk (dstp_instr fnt ".SHX"))
                    (cond 
                      ((= chk T) ; is SHX!
                        (setq stynam (strcat "TEMP" (itoa itm)))
                        (setq fnd nil)
                        (foreach rec rlst
                          (if (= (car rec) fnt)
                            (setq fnd T fntfil (cadr rec))
                          )
                        )
                        (if (= fnd T)
                          (progn
                            (setq ipl (list (- cpx tht) cpy))
                            (setq ipr (list (+ cpx tht) cpy))
                            (setvar "TEXTSTYLE" "STANDARD")
                            (dstp_maketext "TR" ipl tht 0.0 fnt)
                            (command "_.STYLE" stynam fntfil)
                            (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                              (command "")
                            )
                            (dstp_maketext "TL" ipr tht 0.0 "ABC123abc")
                            (setq cpy (- cpy (* tht 2.0)))
                          )
                        )
                      )
                      ((= chk nil) ; is not SHX!
                        (setq add "")
                        (setq ipl (list (- cpx tht) cpy))
                        (setq ipr (list (+ cpx tht) cpy))
                        (setvar "TEXTSTYLE" "STANDARD")
                        (dstp_maketext "TR" ipl tht 0.0 fnt)
                        (setq wds (dstp_pdf2lst (strcase fnt) " "))
                        (if (member "BOLD" wds)
                          (setq add (strcat add "|b1"))
                          (setq add (strcat add "|b0"))
                        )
                        (if (or (member "ITALIC" wds)(member "OBLIQUE" wds))
                          (setq add (strcat add "|i1"))
                          (setq add (strcat add "|i0"))
                        )
                        (if (not (member fnt (list "Arial Rounded MT Bold")))
                          (progn
                            (setq lst (list "REGULAR" "NORMAL" "ITALIC" "BOLD" "DEMI" "OBLIQUE"))
                            (foreach wrd lst
                              (if (member wrd wds)
                                (setq wds (dstp_remove wrd wds))
                              )
                            )
                            (setq fnt "")
                            (foreach wrd wds
                              (setq fnt (strcat fnt wrd))
                              (if (/= wrd (last wds))
                                (setq fnt (strcat fnt " "))
                              )
                            )
                          )
                        )
                        (setq fnt (dstp_trim fnt))
                        (setq cod (strcat "\\f" fnt add ";"))
                        (setq new '((0 . "MTEXT")))
                        (setq new (cons (cons 100 "AcDbEntity") new))
                        (setq new (cons (cons 100 "AcDbMText") new))
                        (setq new (cons (cons 1 (strcat cod "ABC123abc")) new))
                        (setq new (cons (list 10 (car ipr) (cadr ipr)) new))
                        (setq new (cons (cons 71 1) new))
                        (setq new (cons (cons 40 tht) new))
                        (setq new (cons (cons 41 (* tht 10.0)) new))
                        (entmake (reverse new))
                        (setq cpy (- cpy (* tht 2.0)))
                      )
                      (t nil)
                    )
                    (setq itm (1+ itm))
                  )
                  (dstp_ucspop)
                  (command "_.UNDO" "_E")
                  (setvar "CMDECHO" cmdecho)
                  (setvar "OSMODE" osmode)
                  (setvar "FONTALT" fontalt)
                  (princ ", Done.")
                )
              )
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                                 Draw 3D Coil
; --------------------------------------------------------------------------

(defun c:DrwRadCoi ( / 3dp ainc ang cen cmdecho einc elv num osmode pnt ppr
                       rad rpr san)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq cen (getpoint "\nDS> Center Point of Coil: "))
      (setq rad (getdist cen "\nDS> Coil Radius: "))
      (setq san (getangle cen "\nDS> Starting Angle: "))
      (setq rpr (getreal "\nDS> Rise Per Revolution: "))
      (setq num (getint "\nDS> Number of Revolutions: "))
      (setq ppr (getint "\nDS> Points per Revolution <36>: "))
      (if (= ppr nil)(setq ppr 36))
      (setq ang san)
      (setq elv (cadr cen))
      (setq einc (/ rpr ppr))
      (setq ainc (/ (* 2.0 pi) ppr))
      (command "_.3DPOLY")
      (repeat (+ (* num ppr) 1)
        (setq pnt (polar cen ang rad))
        (setq 3dp (list (car pnt)(cadr pnt) elv))
        (command 3dp)
        (setq ang (+ ang ainc))
        (setq elv (+ elv einc))
      )
      (command "")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ---------------------------------------------------------------------------
;                          Create Multiple CenterMarks
; ---------------------------------------------------------------------------

(defun c:DrwCenMrk ( / apt1 apt2 aset cmdecho cpnt eang ent hnd itm mpnt
                        mrk num obj ppnt ptlst rads sang sset xen xob)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Arcs, Circles or LWPolylines ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "ARC")
                (setq cpnt (cdr (assoc 10 ent)))
                (setq rads (cdr (assoc 40 ent)))
                (setq sang (cdr (assoc 50 ent)))
                (setq eang (cdr (assoc 51 ent)))
                (setq apt1 (polar cpnt sang rads))
                (setq apt2 (polar cpnt eang rads))
                (setq mpnt (polar apt1 (angle apt1 apt2)(/ (distance apt1 apt2) 2.0)))
                (setq ppnt (polar cpnt (angle cpnt mpnt) rads))
                (command "_.DIMCENTER" ppnt)
              )
              ((= obj "CIRCLE")
                (setq cpnt (cdr (assoc 10 ent)))
                (setq rads (cdr (assoc 40 ent)))
                (setq ppnt (polar cpnt (/ pi 5.0) rads))
                (command "_.DIMCENTER" ppnt)
              )
              ((= obj "LWPOLYLINE")
                (command "_.UNDO" "_M")
                (command "_.POINT" "0,0")
                (setq mrk (entlast))
                (command "_.EXPLODE" hnd)
                (setq ptlst nil)
                (setq aset (ssadd))
                (while (/= mrk nil)
                  (setq mrk (entnext mrk))
                  (if (/= mrk nil)
                    (progn
                      (setq xen (entget mrk))
                      (setq xob (cdr (assoc 0 xen)))
                      (if (= xob "ARC")
                        (progn
                          (setq cpnt (cdr (assoc 10 xen)))
                          (setq rads (cdr (assoc 40 xen)))
                          (setq sang (cdr (assoc 50 xen)))
                          (setq eang (cdr (assoc 51 xen)))
                          (setq apt1 (polar cpnt sang rads))
                          (setq apt2 (polar cpnt eang rads))
                          (setq mpnt (polar apt1 (angle apt1 apt2)(/ (distance apt1 apt2) 2.0)))
                          (setq ppnt (polar cpnt (angle cpnt mpnt) rads))
                          (setq ptlst (cons ppnt ptlst))
                        )
                      )
                    )
                  )
                )
                (command "_.UNDO" "_B")
                (if (/= ptlst nil)
                  (foreach ppnt ptlst
                    (command "_.DIMCENTER" ppnt)
                  )
                )
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          Create New MaskImg
; --------------------------------------------------------------------------

(defun c:DrwMskImg ( / axo bnd chk cmdecho del disx disy ent g60 highlight
                        hnd img maxpt minpt osmode pik ptlst scl siz sset
                        tmp wid)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setvar "SORTENTS" 127)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (setq img (findfile dstp_wipeimage))
        (progn
          (initget "R P")
          (setq pik (entsel "\nDS> Rectangular/<Select Boundary Object>: "))
          (if (/= pik nil)
            (cond
              ((= pik "R")
                (setq tmp nil)
                (setq minpt (getpoint "\nDS> Lower Left Corner: "))
                (setq maxpt (getcorner minpt "\nDS> Upper Right Corner: "))
                (setq disx (- (car maxpt)(car minpt)))
                (setq disy (- (cadr maxpt)(cadr minpt)))
                (if (> disx disy)
                  (setq siz disx)
                  (setq siz disy)
                )
                (setq scl (* siz 100.0))
                (command "_.IMAGE" "_A" img minpt scl "0")
                (command "_.IMAGECLIP" (entlast) "")
                (if (/= (cdr (assoc 91 ent)) nil)
                  (if (> (cdr (assoc 91 ent)) 2)
                    (command "_Y")
                  )
                )
                (command "_R" minpt maxpt)
              )
              (t
                (initget "Y N")
                (setq chk (getkword "\nDS> Delete Boundary Object Y/<N>: "))
                (if (= chk "Y")(setq del T)(setq del nil))
                (if (/= del T)
                  (progn
                    (initget "Y N")
                    (setq chk (getkword "\nDS> Bind Mask with Boundary <Y>/N: "))
                    (if (= chk "N")(setq bnd nil)(setq bnd T))
                  )
                  (setq bnd nil)
                )
                (setq hnd (car pik))
                (setq ptlst (dstp_obj2lst hnd))
                (if (< (length ptlst) 2)
                  (princ "\nDS> Not a Valid Boundary Object.")
                  (progn
                    (setq axo (vlax-ename->vla-object hnd))
                    (vla-getboundingbox axo 'minpt 'maxpt)
                    (setq minpt (vlax-safearray->list minpt))
                    (setq maxpt (vlax-safearray->list maxpt))
                    (setq disx (- (car maxpt)(car minpt)))
                    (setq disy (- (cadr maxpt)(cadr minpt)))
                    (if (> disx disy)
                      (setq siz disx)
                      (setq siz disy)
                    )
                    (if (= del T)
                      (entdel hnd)
                    )
                    (command "_.IMAGE" "_A" img minpt 0.01 "0")
                    (setq hnd (entlast))
                    (setq ent (entget hnd))
                    (setq wid (car (cdr (assoc 11 ent))))
                    (setq g60 (assoc 60 ent))
                    (if (/= g60 nil)
                      (setq ent (subst (cons 60 1)(assoc 60 ent) ent))
                      (setq ent (append ent (list (cons 60 1))))
                    )
                    (entmod ent)
                    (setq scl (/ siz wid))
                    (command "_.SCALE" hnd "" minpt scl)
                    (command "_.IMAGECLIP" hnd "")
                    (if (/= (cdr (assoc 91 ent)) nil)
                      (if (> (cdr (assoc 91 ent)) 2)
                        (command "_Y")
                      )
                    )
                    (command "_P")
                    (foreach pnt ptlst
                      (command pnt)
                    )
                    (command "")
                    (setq hnd (entlast))
                    (setq ent (entget hnd))
                    (setq ent (subst (cons 60 0)(assoc 60 ent) ent))
                    (entmod ent)
                    (if (= del nil)
                      (dstp_dofloat (car pik))
                    )
                    (if (= bnd T)
                      (progn
                        (setq highlight (getvar "HIGHLIGHT"))
                        (setvar "HIGHLIGHT" 0)
                        (setq sset (ssadd))
                        (setq sset (ssadd hnd sset))
                        (setq sset (ssadd (entlast) sset))
                        (command "-GROUP" "" "*" "" sset "")
                        (setq sset nil)
                        (setvar "HIGHLIGHT" highlight)
                      )
                    )
                  )
                )
              )
            )
          )
        )
        (alert "Cannot find Wipeout Bitmap !!!\n\nCheck Support File Search Paths to make sure\nthe ToolPac program path is included and that\nthe wipeout bitmap file exists in the folder.")
      ) 
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Draw Line By Direction
; --------------------------------------------------------------------------

(defun c:DrwLinAng (/ angbase angdir arad astr bang cmdecho dis fang hub mid
                    pik pnt sel tar uang vec)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "AL AR AZ BE DL DR")
      (setq opt (getkword "\nDS> AngleLeft/AngleRight/AZimuth/BEaring/DeflectionLeft/DeflectionRight: "))
      (setq sel (entsel "\nDS> Pick Segment Near End Point: "))
      (if (/= sel nil)
        (progn
          (setq pik (cadr sel))
          (setq hub (osnap pik "_end"))
          (setq mid (osnap pik "_mid"))
          (setq bang (angle hub mid))
          (setq fang (angle mid hub))
          (setq vec (* (getvar "VIEWSIZE") 2.0))
          (cond
            ((= opt "AL") ; angle left
              (setq astr (getstring "\nDS> Angle Left: "))
              (setq arad (angtof astr))
              (setq uang (+ (+ bang (* pi 2.0)) arad))
              (setq tar (polar hub uang vec))
            )
            ((= opt "AR") ; angle right
              (setq astr (getstring "\nDS> Angle Right: "))
              (setq arad (angtof astr))
              (setq uang (- (+ bang (* pi 2.0)) arad))
              (setq tar (polar hub uang vec))
            )
            ((= opt "DL") ; deflection left
              (setq astr (getstring "\nDS> Deflection Left: "))
              (setq arad (angtof astr))
              (setq uang (+ (+ fang (* pi 2.0)) arad))
              (setq tar (polar hub uang vec))
            )
            ((= opt "DR") ; deflection right
              (setq astr (getstring "\nDS> Deflection Right: "))
              (setq arad (angtof astr))
              (setq uang (- (+ fang (* pi 2.0)) arad))
              (setq tar (polar hub uang vec))
            )
            ((= opt "BE") ; bearing
              (setq astr (getstring "\nDS> Bearing: "))
              (setq uang (angtof astr 4))
              (setq tar (polar hub uang vec))
            )
            ((= opt "AZ") ; azimuth
              (setq astr (getstring "\nDS> Azimuth: "))
              (setq angbase (getvar "ANGBASE"))
              (setvar "ANGBASE" (dstp_dtr 90.0))
              (setq angdir (getvar "ANGDIR"))
              (setvar "ANGDIR" 1)
              (setq uang (angtof astr 1))
              (setvar "ANGDIR" angdir)
              (setvar "ANGBASE" angbase)
              (setq tar (polar hub uang vec))
            )
            (t nil)
          )
          (grdraw hub tar -1 -1)
          (setq dis (getreal "\nDS> Distance: "))
          (grdraw hub tar -1 -1)
          (setq pnt (polar hub uang dis))
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (command "_.LINE" hub pnt "")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                             Bpoly MultiAuto (Shotgun)
; --------------------------------------------------------------------------

(defun c:DrwPlnMul ( / cmdecho curx cury inc llc pnt urc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq llc (getpoint "\nDS> Lower Left Corner: "))
      (if (/= llc nil)
        (progn
          (setq urc (getcorner llc "\nDS> Upper Right Corner: "))
          (if (/= urc nil)
            (progn
              (setq inc (getdist "\nDS> Increment Value <1.0>: "))
              (if (= inc nil)(setq inc 1.0))
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.BPOLY")
              (setq cury (cadr llc))
              (while (< cury (cadr urc))
                (setq curx (car llc))
                (while (< curx (car urc))
                  (setq pnt (list curx cury))
                  (command pnt)
                  (setq curx (+ curx inc))
                )
                (setq cury (+ cury inc))
              )
              (command "")
              (setvar "CMDECHO" cmdecho)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Initiate command by picking object
; --------------------------------------------------------------------------

(defun c:DrwLikExa () (dstp_drwbyex 1))
(defun c:DrwLikTyp () (dstp_drwbyex 2))

(defun dstp_drwbyex (opt / blk cecolor celtype chk clayer cmdecho col com
                           elevation elv ent g10 g11 hnd lay ltp pik
                           plinewid str sty sub textsize textstyle thickness
                           thk typ)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq pik (entsel "\nDS> Pick Object for Command: "))
      (if (/= pik nil)
        (progn
          (princ "\n")
          (setq hnd (car pik))
          (setq ent (entget hnd))
          (if (= opt 1)
            (progn
              (setq clayer (getvar "CLAYER"))
              (setq cecolor (getvar "CECOLOR"))
              (setq celtype (getvar "CELTYPE"))
              (setq elevation (getvar "ELEVATION"))
              (setq thickness (getvar "THICKNESS"))
              (setq plinewid (getvar "PLINEWID"))
              (setq lay (cdr (assoc 8 ent)))
              (setq col (cdr (assoc 62 ent)))
              (setq ltp (cdr (assoc 6 ent)))
              (setq elv (cadddr (assoc 10 ent)))
              (setq thk (cdr (assoc 39 ent)))
              (setvar "CLAYER" lay)
              (if (/= col nil)(setvar "CECOLOR" (itoa col)))
              (if (/= ltp nil)(setvar "CELTYPE" ltp))
              (if (/= elv nil)(setvar "ELEVATION" elv))
              (if (/= thk nil)(setvar "THICKNESS" thk))
            )
          )
          (setq com (cdr (assoc 0 ent)))
          (if (or (= com "LWPOLYLINE")(= com "POLYLINE"))
            (progn
              (setq com "PLINE")
              (if (/= (assoc 40 ent) nil)
                (setvar "PLINEWID" (cdr (assoc 40 ent)))
              )
            )
          )
          (if (= com "VIEWPORT")(setq com "MVIEW"))
          (cond
            ((= com "DIMENSION")
              (setq sub nil)
              (setq sty (cdr (assoc 3 ent)))
              (setq typ (cdr (assoc 70 ent)))
              (cond
                ((or (= typ 0)(= typ 32))
                  (setq g10 (assoc 10 ent))
                  (setq g11 (assoc 11 ent))
                  (if (equal (nth 1 g10)(nth 1 g11) 0.0001)
                    (setq sub "VER")
                  )
                  (if (equal (nth 2 g10)(nth 2 g11) 0.0001)
                    (setq sub "HOR")
                  )
                  (if (= sub nil)
                    (setq sub "ROT")
                  )
                )
                ((= typ 1)(setq sub "ALI"))
                ((= typ 2)(setq sub "ANG"))
                ((= typ 3)(setq sub "DIA"))
                ((= typ 4)(setq sub "RAD"))
                ((= typ 5)(setq sub "ANG"))
                ((= typ 6)(setq sub "ORD"))
                (t nil)
              )
              (if (/= sty "*UNNAMED")
                (command "_.DIM1" "RESTORE" sty)
              )
              (if (= opt 1)
                (command "_.LAYER" "_S" lay "")
              )
              (princ (strcat "\nDS> Layer: [" (getvar "CLAYER") "] Type: [" sub "]\n"))
              (command "_.DIM1" sub)
            )
            ((= com "INSERT")
              (setq blk (cdr (assoc 2 ent)))
              (setq chk (tblsearch "BLOCK" blk))
              (setvar "CMDECHO" 1)
              (if (= (assoc 1 chk) nil)
                (progn
                  (initdia 1)
                  (command "_.-INSERT" blk)
                )
                (command "_.XREF" "_A" blk)
              )
              (setvar "CMDECHO" 0)
              (if (/= (cdr (assoc 41 ent)) nil)
                (command "_X" (cdr (assoc 41 ent)))
              )
              (if (/= (cdr (assoc 42 ent)) nil)
                (command "_Y" (cdr (assoc 42 ent)))
              )
              (if (/= (cdr (assoc 43 ent)) nil)
                (command "_Z" (cdr (assoc 42 ent)))
              )
              (if (/= (cdr (assoc 50 ent)) nil)
                (command "_R" (dstp_rtd (cdr (assoc 50 ent))))
              )
              (setvar "CMDECHO" 1)
              (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                (command pause)
              )
              (setvar "CMDECHO" 0)
            )
            ((= com "MTEXT")
              (setq textstyle (getvar "TEXTSTYLE"))
              (setq textsize (getvar "TEXTSIZE"))
              (setvar "TEXTSTYLE" (cdr (assoc 7 ent)))
              (setvar "TEXTSIZE" (cdr (assoc 40 ent)))
              (setvar "CMDECHO" 1)
              (initdia)
              (command "_.MTEXT")
              (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                (command pause)
              )
              (setvar "TEXTSTYLE" textstyle)
              (setvar "TEXTSIZE" textsize)
              (setvar "CMDECHO" 0)
            )
            ((= com "TEXT")
              (setq textstyle (getvar "TEXTSTYLE"))
              (setq textsize (getvar "TEXTSIZE"))
              (setvar "TEXTSTYLE" (cdr (assoc 7 ent)))
              (setvar "TEXTSIZE" (cdr (assoc 40 ent)))
              (setvar "CMDECHO" 1)
              (command "_.DTEXT")
              (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                (command pause)
              )
              (setvar "TEXTSTYLE" textstyle)
              (setvar "TEXTSIZE" textsize)
              (setvar "CMDECHO" 0)
            )
            ((= com "LEADER")
              (setvar "CMDECHO" 1)
              (command "_.LEADER")
              (command pause)
              (command pause)
              (setq str (getstring "\nAnnotation: " T))
              (command "Annotation")
              (command str)
              (command "")
              (setvar "CMDECHO" 0)
            )
            (t
              (setvar "CMDECHO" 1)
              (command (strcat "_." com))
              (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                (command pause)
              )
              (setvar "CMDECHO" 0)
            )
          )
          (if (= opt 1)
            (progn
              (setvar "CLAYER" clayer)
              (setvar "CECOLOR" cecolor)
              (setvar "CELTYPE" celtype)
              (setvar "ELEVATION" elevation)
              (setvar "THICKNESS" thickness)
              (setvar "PLINEWID" plinewid)
            )
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Label area of selected object or point
; --------------------------------------------------------------------------

(defun c:DrwLabAre () (dstp_labarea 1))
(defun c:DrwLabPer () (dstp_labarea 2))

;   (setq
;      obj   (vlax-ename->vla-object ent)
;      objID (vla-get-objectid obj)
;      str (strcat "%<\\AcObjProp Object(%<\\_ObjId "(itoa objID)">%).TextString \\f \"%tc1\">%")
;    )
;  %<\AcObjProp Object(%<\_ObjId -1220600>%).Area \f "%lu6%qf1">%

(defun dstp_labarea (opt / area bnd cmdecho dcl_id disstr done doproc ent
                           g72 g73 hnd labdec labhgt labjst labpre labrot
                           labsuf labvfc labvop mode newtxt opt orthomode
                           pnt title tmp viewctr)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun labarea_setflds ()
        (set_tile "jst" labjst)
        (set_tile "hgt" labhgt)
        (set_tile "rot" labrot)
        (set_tile "dec" labdec)
        (set_tile "vop" labvop)
        (set_tile "vfc" labvfc)
        (set_tile "pre" labpre)
        (set_tile "suf" labsuf)
      )
      (defun labarea_getflds ()
        (setq labjst (get_tile "jst"))
        (setq labhgt (get_tile "hgt"))
        (setq labrot (get_tile "rot"))
        (setq labdec (get_tile "dec"))
        (setq labvop (get_tile "vop"))
        (setq labvfc (get_tile "vfc"))
        (setq labpre (get_tile "pre"))
        (setq labsuf (get_tile "suf"))
        (if (= opt 1)
          (progn
            (dstp_regstore "AreaLab" "labjst" labjst)
            (dstp_regstore "AreaLab" "labhgt" labhgt)
            (dstp_regstore "AreaLab" "labrot" labrot)
            (dstp_regstore "AreaLab" "labdec" labdec)
            (dstp_regstore "AreaLab" "labvop" labvop)
            (dstp_regstore "AreaLab" "labvfc" labvfc)
            (dstp_regstore "AreaLab" "labpre" labpre)
            (dstp_regstore "AreaLab" "labsuf" labsuf)
          )
          (progn
            (dstp_regstore "PerimLab" "labjst" labjst)
            (dstp_regstore "PerimLab" "labhgt" labhgt)
            (dstp_regstore "PerimLab" "labrot" labrot)
            (dstp_regstore "PerimLab" "labdec" labdec)
            (dstp_regstore "PerimLab" "labvop" labvop)
            (dstp_regstore "PerimLab" "labvfc" labvfc)
            (dstp_regstore "PerimLab" "labpre" labpre)
            (dstp_regstore "PerimLab" "labsuf" labsuf)
          )
        )
      )
      (defun labarea_doparms ()
        (if (< (setq dcl_id (load_dialog "toolpac.dcl")) 0) (exit))
        (if (not (new_dialog "labarea" dcl_id)) (exit))
        (set_tile "title" title)
        (labarea_setflds)
        (action_tile "cancel" "(done_dialog 0)")
        (action_tile "accept" "(labarea_getflds)(done_dialog 1)")
        (action_tile "help" "(dstp_showhelp \"DrwLabAre.htm\")")
        (start_dialog)
        (princ)
        (unload_dialog dcl_id)
      )
      (defun labarea_dolabel ()
        (cond
          ((= labvop "1")(setq area (+ area (atof labvfc))))
          ((= labvop "2")(setq area (- area (atof labvfc))))
          ((= labvop "3")(setq area (* area (atof labvfc))))
          ((= labvop "4")(setq area (/ area (atof labvfc))))
          (t nil)
        )
        (setq disstr (strcat labpre (rtos area 2 (atoi labdec)) labsuf))
        (setq newtxt '((0 . "TEXT")))
        (setq viewctr (getvar "VIEWCTR"))
        (setq newtxt (append newtxt (list (list 10 (nth 0 viewctr) (nth 1 viewctr) (nth 2 viewctr)))))
        (setq newtxt (append newtxt (list (cons 40 (atof labhgt)))))
        (setq newtxt (append newtxt (list (cons 50 (atof labrot)))))
        (setq newtxt (append newtxt (list (cons 7 (getvar "TEXTSTYLE")))))
        (setq newtxt (append newtxt (list (cons 1 disstr))))
        (cond
          ((= labjst "0")(setq g72 0)(setq g73 0))
          ((= labjst "1")(setq g72 1)(setq g73 0))
          ((= labjst "2")(setq g72 2)(setq g73 0))
          ((= labjst "3")(setq g72 4)(setq g73 0))
          (t nil)
        )
        (setq newtxt (append newtxt (list (cons 72 g72))))
        (setq newtxt (append newtxt (list (cons 73 g73))))
        (entmake newtxt)
        (setq hnd (entlast))
        (setq ent (entget hnd))
        (if (/= labjst "0")
          (setq pnt (list (nth 1 (assoc 11 ent)) (nth 2 (assoc 11 ent))))
          (setq pnt (list (nth 1 (assoc 10 ent)) (nth 2 (assoc 10 ent))))
        )
        (princ (strcat "\nDS> Location For Label [" disstr "]: "))
        (setq orthomode (getvar "ORTHOMODE"))
        (setvar "ORTHOMODE" 0)
        (command "_.MOVE" hnd "" (trans pnt 0 1) pause)
        (setvar "ORTHOMODE" orthomode)
      )
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (= opt 1)
        (progn
          (setq title "Area Labeling")
          (setq labjst (dstp_regfetch "AreaLab" "labjst" "3"))
          (setq labhgt (dstp_regfetch "AreaLab" "labhgt" (rtos (dstp_textsize))))
          (setq labrot (dstp_regfetch "AreaLab" "labrot" "0"))
          (setq labdec (dstp_regfetch "AreaLab" "labdec" (rtos (getvar "LUPREC"))))
          (setq labvop (dstp_regfetch "AreaLab" "labvop" "0"))
          (setq labvfc (dstp_regfetch "AreaLab" "labvfc" "0.0"))
          (setq labpre (dstp_regfetch "AreaLab" "labpre" ""))
          (setq labsuf (dstp_regfetch "AreaLab" "labsuf" ""))
        )
        (progn
          (setq title "Perimeter Labeling")
          (setq labjst (dstp_regfetch "PerimLab" "labjst" "3"))
          (setq labhgt (dstp_regfetch "PerimLab" "labhgt" (rtos (dstp_textsize))))
          (setq labrot (dstp_regfetch "PerimLab" "labrot" "0"))
          (setq labdec (dstp_regfetch "PerimLab" "labdec" (rtos (getvar "LUPREC"))))
          (setq labvop (dstp_regfetch "PerimLab" "labvop" "0"))
          (setq labvfc (dstp_regfetch "PerimLab" "labvfc" "0.0"))
          (setq labpre (dstp_regfetch "PerimLab" "labpre" ""))
          (setq labsuf (dstp_regfetch "PerimLab" "labsuf" ""))
        )
      )
      (setq doproc T)
      (setq mode "B")
      (setq done nil)
      (while (/= done T)
        (cond
          ((= mode "B")
            (setq tmp nil)
            (initget "S P")
            (setq tmp (entsel "\nDS> Settings/Pickmode/<Pick Closed Object>: "))
            (cond
              ((= tmp nil)(setq done T))
              ((= tmp "S")(labarea_doparms))
              ((= tmp "P")(setq mode "P"))
              (t
                (setq hnd (car tmp))
                (command "_.AREA" "_E" hnd)
                (if (= opt 1)
                  (setq area (getvar "AREA"))
                  (setq area (getvar "PERIMETER"))
                )
                (labarea_dolabel)
              )
            )
          )
          ((= mode "P")
            (initget "S B X")
            (setq tmp (getpoint "\nDS> Settings/Boundary/<Pick Interior Point>: "))
            (cond
              ((= tmp nil)(setq done T))
              ((= tmp "S")(labarea_doparms))
              ((= tmp "B")(setq mode "B"))
              (t
                ;(setq bnd (bpoly tmp))
                (command "_-BOUNDARY" tmp "")
                (setq bnd (entlast))
                (if (/= bnd nil)
                  (progn
                    (command "_.AREA" "_E" bnd)
                    (if (= opt 1)
                      (setq area (getvar "AREA"))
                      (setq area (getvar "PERIMETER"))
                    )
                    (redraw bnd 3)
                    (labarea_dolabel)
                    (redraw bnd 4)
                    (entdel bnd)
                  )
                )
              )
            )
          )
          (t nil)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Label Slope w/Text Arrow
; --------------------------------------------------------------------------

(defun c:DrwLabSlz () (dstp_labslope 1))
(defun c:DrwLabSxy () (dstp_labslope 2))

(defun dstp_labslope (meth / ang cmdecho cpt dec dgslp grade hnd miss new
                             opt orthomode osmode pt1 pt2 rise run stv egg
                             toone)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq opt (dstp_regfetch "DrawTool" "labslopeopt" "D"))
      (setq dec (atoi (dstp_regfetch "DrawTool" "labslopedec" "1")))
      (initget "G R D")
      (cond
        ((= opt "G")
          (setq tmp (getkword "\nDS> <Grade>/Ratio/Degree: "))
        )
        ((= opt "R")
          (setq tmp (getkword "\nDS> Grade/<Ratio>/Degree: "))
        )
        ((= opt "D")
          (setq tmp (getkword "\nDS> Grade/Ratio/<Degree>: "))
        )
      )
      (if (/= tmp nil)(setq opt tmp))
      (setq tmp (getint (strcat "\nDS> Number of Decimal Places <" (itoa dec) ">: ")))
      (if (/= tmp nil)(setq dec tmp))
      (setq tmp (getreal "\nDS> Vertical Exaggeration <1.0>: "))
      (if (/= tmp nil)(setq egg tmp)(setq egg 1.0))
      (dstp_regstore "DrawTool" "labslopeopt" opt)
      (dstp_regstore "DrawTool" "labslopedec" (itoa dec))
      (setq miss nil)
      (while (= miss nil)
        (setq pt1 (getpoint "\nDS> Pick 1st Point: "))
        (if (/= pt1 nil)
          (progn
            (setq pt2 (getpoint pt1 "\nDS> Pick 2nd Point: "))
            (if (/= pt2 nil)
              (progn
                (setq cpt (polar pt1 (angle pt1 pt2) (/ (distance pt1 pt2) 2)))
                (cond
                  ((= meth 1)  ; zslope
                    (setq rise (- (caddr pt2) (caddr pt1)))
                    (setq run (distance (list (car pt2)(cadr pt2)) (list (car pt1)(cadr pt1))))
                  )
                  ((= meth 2)  ; xyslope
                    (setq rise (- (cadr pt2) (cadr pt1)))
                    (setq run (- (car pt2) (car pt1)))
                  )
                  (t nil)
                )
                (setq rise (/ rise egg))
                (if (/= run 0)(setq grade (* (/ rise run) 100)))
                (if (/= run 0)(setq dgslp (dstp_rtd (atan (/ rise run)))))
                (if (/= rise 0)(setq toone (/ run rise)))
                (cond
                  ((= opt "G")(setq stv (strcat (rtos grade 2 dec) "%")))
                  ((= opt "R")(setq stv (strcat (rtos toone 2 dec) ":1")))
                  ((= opt "D")(setq stv (strcat (rtos dgslp 2 dec) "%%d")))
                  (t (setq stv ""))
                )
                (if (/= stv "")
                  (progn
                    (setq osmode (getvar "OSMODE"))
                    (setvar "OSMODE" 0)
                    (setq orthomode (getvar "ORTHOMODE"))
                    (setvar "ORTHOMODE" 0)
                    (setq ang (angle pt1 pt2))
                    (setq mrk (entlast))
                    (setq lset (ssadd))
                    (setq dis (* (dstp_textsize) 2.0))
                    (if (and (> ang (/ PI 2.0)) (< ang (+ PI (/ PI 2.0))))
                      (progn
                        (setq ptx (polar cpt 0.0 dis))
                        (command "_.LEADER" cpt ptx ptx "" stv "")
                      )
                      (progn
                        (setq ptx (polar cpt pi dis))
                        (command "_.LEADER" cpt ptx ptx "" stv "")
                      )
                    )
                    (setq chk mrk)
                    (while (/= chk nil)
                      (setq chk (entnext chk))
                      (if (/= chk nil)
                        (setq lset (ssadd chk lset))
                      )
                    )
                    (command "_.ROTATE" lset "" cpt "_R" cpt ptx pt1)
                    (princ (strcat "\nDS> Placement Position For [" stv "]: "))
                    (command "_.MOVE" lset "" (trans cpt 0 1) pause)
                    (setq lset nil)
                    (setvar "OSMODE" osmode)
                    (setvar "ORTHOMODE" orthomode)
                  )
                )
              )
              (setq miss T)
            )
          )
          (setq miss T)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ---------------------------------------------------------------------------
;                                Radial Endpoint Lines
; ---------------------------------------------------------------------------

(defun c:DrwRadEnd ( / aset beg chk cmdecho cpnt end ent epnt ept1 ept2 hnd
                         itm mrk new num obj ptlst rads spnt sset udis wlst
                         xen xob)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Arcs or LWPolylines ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq chk (getdist "\nDS> Beginning Offset Distance <0.00>: "))
          (if (= chk nil)(setq beg 0.0)(setq beg chk))
          (setq chk (getdist "\nDS> Ending Offset Distance (0=Radius Point) <0.00>: "))
          (if (= chk nil)(setq end 0.0)(setq end chk))
          (setq num (sslength sset) itm 0)
          (setq wlst nil)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "ARC")
                (setq cpnt (cdr (assoc 10 ent)))
                (setq rads (cdr (assoc 40 ent)))
                (setq ept1 (polar cpnt (cdr (assoc 50 ent)) rads))
                (setq ept2 (polar cpnt (cdr (assoc 51 ent)) rads))
                (setq wlst (cons (list cpnt rads ept1 ept2) wlst))
              )
              ((= obj "LWPOLYLINE")
                (command "_.UNDO" "_M")
                (command "_.POINT" "0,0")
                (setq mrk (entlast))
                (command "_.EXPLODE" hnd)
                (setq ptlst nil)
                (setq aset (ssadd))
                (while (/= mrk nil)
                  (setq mrk (entnext mrk))
                  (if (/= mrk nil)
                    (progn
                      (setq xen (entget mrk))
                      (setq xob (cdr (assoc 0 xen)))
                      (if (= xob "ARC")
                        (progn
                          (setq cpnt (cdr (assoc 10 xen)))
                          (setq rads (cdr (assoc 40 xen)))
                          (setq ept1 (polar cpnt (cdr (assoc 50 xen)) rads))
                          (setq ept2 (polar cpnt (cdr (assoc 51 xen)) rads))
                          (setq wlst (cons (list cpnt rads ept1 ept2) wlst))
                        )
                      )
                    )
                  )
                )
                (command "_.UNDO" "_B")
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
          (foreach rec wlst
            (setq cpnt (nth 0 rec))
            (setq rads (nth 1 rec))
            (setq ept1 (nth 2 rec))
            (setq ept2 (nth 3 rec))
            (if (<= end rads)
              (setq udis end)
              (setq udis rads)
            )
            (setq spnt (polar ept1 (angle ept1 cpnt) beg))
            (if (= end 0.0)
              (setq epnt cpnt)
              (setq epnt (polar ept1 (angle ept1 cpnt) udis))
            )
            (setq new '((0 . "LINE")))
            (setq new (append new (list (cons 10 spnt))))
            (setq new (append new (list (cons 11 epnt))))
            (entmake new)
            (setq spnt (polar ept2 (angle ept2 cpnt) beg))
            (if (= end 0.0)
              (setq epnt cpnt)
              (setq epnt (polar ept2 (angle ept2 cpnt) udis))
            )
            (setq new '((0 . "LINE")))
            (setq new (append new (list (cons 10 spnt))))
            (setq new (append new (list (cons 11 epnt))))
            (entmake new)
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ###########################################################################
;                                HATCHTOOL
; ###########################################################################

; ---------------------------------------------------------------------------
;                          Shared Support Functions
; ---------------------------------------------------------------------------

(defun hatchbnd_proc (zset / add aunits cls cur dis ea end ent fnd g10 g11
                             g40 g41 g410 g42 g50 g51 g73 g74 g94 g95 g96
                             grp hnd ispl itm kts lst new num p2x p2y prc
                             pt2 pts rec sa str tmp typ val)
  (if zset
    (progn
      (princ "\nDS>")
      (setq itm 0 num (sslength zset))
      (while (< itm num)
        (setq str (strcat "DS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (princ (strcat "\r" str "\r" str))
        (setq hnd (ssname zset itm))
        (setq ent (entget hnd))
        (setq g410 (cdr (assoc 410 ent)))
        (setq lst nil)
        (foreach rec ent
          (if (not (member (car rec) (list -1 0 2 5 6 8 62 67 100 210 330 410)))
            (setq lst (append lst (list (list (car rec)(cdr rec)))))
          )
        )
        (setq cur 0)
        (setq typ "")
        (setq end (length lst))
        (while (< cur end)
          (setq rec (nth cur lst))
          (setq grp (car rec))
          (setq val (cadr rec))
          (cond
            ((= grp 73)                         ; is closed flag
              (if (= (boole 1 val 1) 1)
                (setq cls 1)
                (setq cls 0)
              )
            )
            ((= grp 92)                         ; boundary path type
              (if (= (boole 1 val 2) 2)
                (setq ispl T)
                (setq ispl nil)
              )
            )
            ((= grp 93)                         ; number of edges
              (if (= ispl T)
                (progn
                  (setq new '((0 . "LWPOLYLINE")(100 . "AcDbEntity")(100 . "AcDbPolyline")))
                  (setq new (append new (list (cons 90 val))))
                  (setq new (append new (list (cons 70 cls))))
                  (setq fnd 0)
                  (setq cur (1+ cur))
                  (while (< fnd val)
                    (setq rec (nth cur lst))
                    (setq grp (car rec))
                    (cond
                      ((= grp 10)
                        (setq fnd (1+ fnd))
                        (setq new (append new (list (cons 10 (list (nth 0 (nth 1 rec)) (nth 1 (nth 1 rec)))))))
                      )
                      ((= grp 42)
                        (setq add (cons 42 (cadr rec)))
                        (setq new (append new (list add)))
                      )
                      (t nil)
                    )
                    (setq cur (1+ cur))
                  )
                  (setq rec (nth cur lst))
                  (if (= (car rec) 42)
                    (progn
                      (setq add (cons 42 (cadr rec)))
                      (setq new (append new (list add)))
                    )
                  )
                  (entmake new)
                )
                (progn
                  (setq prc 0)
                  (while (< prc val)
                    (setq cur (1+ cur))
                    (setq rec (nth cur lst))
                    (if (= (car rec) 72)
                      (progn
                        (setq typ (cadr rec))
                        (setq cur (1+ cur))
                        (cond
                          ((= typ 1)                   ; line
                            (setq new '((0 . "LINE")))
                            (setq rec (nth cur lst))
                            (setq new (append new (list (cons 10 (list (nth 0 (nth 1 rec)) (nth 1 (nth 1 rec)))))))
                            (setq cur (1+ cur))
                            (setq rec (nth cur lst))
                            (setq new (append new (list (cons 11 (list (nth 0 (nth 1 rec)) (nth 1 (nth 1 rec)))))))
                            (entmake new)
                          )
                          ((= typ 2)                   ; arc
                            (setq rec (nth cur lst))
                            (setq g10 (list (nth 0 (nth 1 rec)) (nth 1 (nth 1 rec))))
                            (setq cur (1+ cur))
                            (setq g40 (cadr (nth cur lst)))
                            (setq cur (1+ cur))
                            (setq g50 (cadr (nth cur lst)))
                            (setq cur (1+ cur))
                            (setq g51 (cadr (nth cur lst)))
                            (setq cur (1+ cur))
                            (setq g73 (cadr (nth cur lst))) ; is counterclockwise ?
                            ;
                            (if
                              (or
                                (equal g51 g50)
                                (equal (abs (- (* pi 2.0) g51)) (abs g50))
                                (equal (abs (- (* pi 2.0) g50)) (abs g51))
                                (and (equal g50 0.0)(equal g51 (* pi 2.0)))
                              )
                              (progn
                                (setq new '((0 . "CIRCLE")))
                                (setq new (append new (list (cons 10 g10))))
                                (setq new (append new (list (cons 40 g40))))
                                (entmake new)
                              )
                              (progn
                                (if (= g73 0)
                                  (progn
                                    (setq g50 (- (* pi 2.0) g50))
                                    (setq g51 (- (* pi 2.0) g51))
                                    (setq tmp g50 g50 g51 g51 tmp)
                                  )
                                )
                                (setq new '((0 . "ARC")))
                                (setq new (append new (list (cons 10 g10))))
                                (setq new (append new (list (cons 40 g40))))
                                (setq new (append new (list (cons 50 g50))))
                                (setq new (append new (list (cons 51 g51))))
                                (entmake new)
                              )
                            )
                          )
                          ((= typ 3)                   ; elliptic arc
                            (setq rec (nth cur lst))
                            (setq g10 (list (nth 0 (nth 1 rec)) (nth 1 (nth 1 rec)) 0.0))
                            (setq cur (1+ cur))
                            (setq g11 (cadr (nth cur lst))) ; endpoint of major axis relative to center
                            (setq cur (1+ cur))
                            (setq g40 (cadr (nth cur lst))) ; length of minor axis, percentage
                            (setq cur (1+ cur))
                            (setq g41 (cadr (nth cur lst))) ; source g50 (start angle)
                            (setq cur (1+ cur))
                            (setq g42 (cadr (nth cur lst))) ; source g51 (end angle)
                            (setq cur (1+ cur))
                            (setq g73 (cadr (nth cur lst))) ; is counterclockwise ?
                            ;
                            (setq p2x (+ (car g10)(car g11)))
                            (setq p2y (+ (cadr g10)(cadr g11)))
                            (setq pt2 (list p2x p2y))
                            (setq dis (* g40 (distance g10 pt2)))
                            (if (= g73 1)
                              (setq sa g41 ea g42)
                              (setq sa (- 0.0 g42) ea (- 0.0 g41))
                            )
                            (setq aunits (getvar "AUNITS"))
                            (setvar "AUNITS" 3)
                            (command "_.ELLIPSE" "_A" "_C" g10 pt2 dis sa ea)
                            (setvar "AUNITS" aunits)
                          )
                          ((= typ 4)                   ; spline
                            (setq rec (nth cur lst))
                            (setq g94 (cadr (nth cur lst)))  ; degree
                            (setq cur (1+ cur))
                            (setq rec (nth cur lst))
                            (setq g73 (cadr (nth cur lst)))  ; rational
                            (setq cur (1+ cur))
                            (setq rec (nth cur lst))
                            (setq g74 (cadr (nth cur lst)))  ; periodic
                            (setq cur (1+ cur))
                            (setq rec (nth cur lst))
                            (setq g95 (cadr (nth cur lst)))  ; number of knots
                            (setq cur (1+ cur))
                            (setq rec (nth cur lst))
                            (setq g96 (cadr (nth cur lst)))  ; number of control points
                            (setq kts nil)
                            (repeat g95
                              (setq cur (1+ cur))
                              (setq rec (nth cur lst))
                              (setq kts (append kts (list (cons 40 (nth 1 rec)))))
                            )
                            (setq pts nil)
                            (repeat g96
                              (setq cur (1+ cur))
                              (setq rec (nth cur lst))
                              (setq pts (append pts (list (cons 10 (list (nth 0 (nth 1 rec)) (nth 1 (nth 1 rec)))))))
                            )
                            (setq tmp nil)
                            ;
                            (setq new '((0 . "SPLINE")(100 . "AcDbEntity")(100 . "AcDbSpline")))
                            (setq new (append new (list (cons 71 g94))))
                            (setq new (append new (list (cons 72 g73))))
                            (setq new (append new (list (cons 73 g96))))
                            (foreach rec pts
                              (setq new (append new (list rec)))
                            )
                            (foreach rec kts
                              (setq new (append new (list rec)))
                            )
                            (entmake new)
                          )
                          (t nil)
                        )
                      )
                    )
                    (setq prc (1+ prc))
                  )
                )
              )
            )
            (t nil)
          )
          (setq cur (1+ cur))
        )
        (setq itm (1+ itm))
      )
      (princ ", Done.")
      (setq zset nil)
      (princ)
    )
  )
)

; ---------------------------------------------------------------------------
;                          Create Multiple Hatchs
; ---------------------------------------------------------------------------

(defun c:HatAddMul ( / ang cmdecho flt hnd itm num pat scl sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq pat (getvar "HPNAME"))
      (if (= pat "_SOLID")(setq pat "SOLID"))
      (setq tmp (strcase (getstring (strcat "\nDS> Hatch pattern to use <" pat ">: "))))
      (if (/= tmp "")(setq pat tmp))
      (if (/= pat "SOLID")
        (progn
          (setq scl (getvar "HPSCALE"))
          (setq tmp (getreal (strcat "\nDS> Scale for pattern <" (rtos scl) ">: ")))
          (if (/= tmp nil)(setq scl tmp))
          (setq ang (getvar "HPANG"))
          (setq tmp (getangle (strcat "\nDS> Angle for pattern <" (angtos ang) ">: ")))
          (if (/= tmp nil)(setq ang tmp))
        )
      )
      (princ "\nDS> Notice: Using Recreate option will remove associativity!")
      (initget "C D N R")
      (setq flt (getkword "\nDS> Float boundaries by None/Copy/Recreate/<Draworder>: "))
      (if (= flt nil)(setq flt "D"))
      (princ "\nDS> Select hatch boundaries ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "LWPOLYLINE")(0 . "POLYLINE")(0 . "REGION")(0 . "SPLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (if (= pat "SOLID")
              (command "_.BHATCH" "_P" "_S" "_S" hnd "" "")
              (command "_.BHATCH" "_P" pat scl (dstp_rtd ang) "_S" hnd "" "")
            )
            (setq itm (1+ itm))
          )
          (cond
            ((= flt "C")
              (command "_.COPY" sset "" "0,0,0" "0,0,0")
              (command "_.ERASE" sset "")
            )
            ((= flt "D")
              (command "_.DRAWORDER" sset "" "_F")
            )
            ((= flt "R")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (dstp_savprop)
                (dstp_dofloat hnd)
                (dstp_resprop)
                (setq itm (1+ itm))
              )
            )
            (t nil)
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Generate Hatch Legend (Samples)
; --------------------------------------------------------------------------

(defun c:HatLegGen ( / chk cmdecho cor cpx cpy def done ent fh flst hgp
                       hgt hid hnd ido ipr ipx itm llc lrc lst mpt nam
                       num osmode pas pat plst pth spt sset tht tmp tot
                       tpt ulc urc vgp wid hpscale scl usescl)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq pth (getenv "ACAD"))
      (setq tmp (dstp_pdf2lst pth ";"))
      (setq flst nil)
      (foreach pth tmp
        (setq lst (vl-directory-files pth "*.pat" 0))
        (foreach fil lst
          (if (/= (strcase fil) "ACADISO.PAT")
            (setq flst (append flst (list (strcat pth "\\" fil))))
          )
        )
      )
      (if (/= flst nil)
        (progn
          (setq flst (acad_strlsort flst))
          (setq flst (dstp_tablesel "Select Patterns" flst "m" "T"))
          (setq spt (getpoint "\nDS> Upper Left Corner: "))
          (setq scl (getdist "\nDS> Pattern Scale <5.0>: "))
          (if (= scl nil)(setq scl 5.0))
          (setq wid (getdist "\nDS> Rectangle Width <10.0>: "))
          (if (= wid nil)(setq wid 10.0))
          (setq hgt (getdist "\nDS> Rectangle Height <10.0>: "))
          (if (= hgt nil)(setq hgt 10.0))
          (setq hgp (getdist "\nDS> Horizonatal Gap <3.0>: "))
          (if (= hgp nil)(setq hgp 3.0))
          (setq vgp (getdist "\nDS> Vertical Gap <3.0>: "))
          (if (= vgp nil)(setq vgp 3.0))
          (setq def (/ hgt 10.0))
          (setq tht (getdist (strcat "\nDS> Text Height <" (rtos def) ">: ")))
          (if (= tht nil)(setq tht def))
          (setq ipr (getint "\nDS> Items Per Row <12>: "))
          (if (= ipr nil)(setq ipr 12))
          (initget "Y N")
          (setq chk (getkword "\nDS> Inside Drawing Only Y/<N>: "))
          (if (= chk nil)(setq ido "N")(setq ido "Y"))
          (if (= ido "Y")
            (progn
              (setq hid nil)
              (setq sset (ssget "_X" '((0 . "HATCH"))))
              (if (/= sset nil)
                (progn
                  (setq num (sslength sset) itm 0)
                  (while (< itm num)
                    (setq hnd (ssname sset itm))
                    (setq ent (entget hnd))
                    (setq pat (strcase (cdr (assoc 2 ent))))
                    (if (not (member pat hid))
                      (setq hid (cons pat hid))
                    )
                    (setq itm (1+ itm))
                  )
                )
              )
            )
          )
          (princ "\nDS>")
          (setq itm 0)
          (setq plst nil)
          (setq ipx (car spt))
          (setq cpx (car spt))
          (setq cpy (cadr spt))
          (setq num (length flst))
          (foreach fn flst
            (princ (strcat "\rDS> Scanning File " (itoa (1+ itm)) " of " (itoa num)))
            (setq done nil)
            (setq fh (open fn "r"))
            (while (/= done T)
              (setq chk (read-line fh))
              (if (= chk nil)
                (progn
                  (setq done T)
                  (close fh)
                )
                (progn
                  (if (= (substr chk 1 1) "*")
                    (progn
                      (setq chk (substr chk 2 (- (strlen chk) 1)))
                      (setq chk (dstp_subtext chk (chr 34) "'"))
                      (setq nam (strcase (car (dstp_pdf2lst chk ","))))
                      (setq pas T)
                      (if (= ido "Y")
                        (if (not (member (strcase nam) hid))
                          (setq pas nil)
                        )
                      )
                      (if (= pas T)
                        (setq plst (cons nam plst))
                      )
                    )
                  )
                )
              )
            )
            (setq itm (1+ itm))
          )
          (setq plst (dstp_dupremove plst))
          (setq plst (acad_strlsort plst))
          (setq flst nil)
          (princ ", Done.")
          (setq itm 0)
          (setq cor 0)
          (setq tot (length plst))
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (setq hpscale (getvar "HPSCALE"))
          (command "_.UNDO" "_G")
          (foreach pat plst
            (if (/= pat nil)
              (progn
                (setq ulc (list cpx cpy))
                (setq urc (list (+ cpx wid) cpy))
                (setq lrc (list (+ cpx wid) (- cpy hgt)))
                (setq llc (list cpx (- cpy hgt)))
                (setq mpt (polar llc (angle llc lrc) (/ (distance llc lrc) 2.0)))
                (setq tpt (polar mpt (angle ulc llc) (/ tht 2.0)))
                (dstp_maketext "TC" tpt tht 0.0 pat)
                (command "_.PLINE" ulc urc lrc llc "_C")
                (setq usescl scl)
                (cond
                  ((= (substr pat 1 3) "AR-")
                    (setq usescl (/ scl 12.0))
                  )
                  ((= (substr pat 1 8) "ACAD_ISO")
                    (setq usescl (/ scl 30.0))
                  )
                  ((= (substr pat 1 5) "GRATE")
                    (setq usescl (* scl 2.0))
                  )
                  (t nil)
                )
                (setvar "HPSCALE" usescl)
                (if (= pat "SOLID")
                  (command "_.HATCH" pat (entlast) "")
                  (command "_.HATCH" pat "" "" (entlast) "")
                )
                (setq cor (1+ cor))
                (if (= cor ipr)
                  (progn
                    (setq cpx ipx)
                    (setq cpy (- cpy hgt vgp))
                    (setq cor 0)
                  )
                  (setq cpx (+ cpx wid hgp))
                )
              )
            )
            (setq itm (1+ itm))
          )
          (command "_.UNDO" "_E")
          (setvar "HPSCALE" hpscale)
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Export Hatch Pattern Definitions
; --------------------------------------------------------------------------

(defun c:HatDefExp ( / c53 chkpth cnt cod das dv1 dv2 ent fh fn g45 g46 g53 hnd
                       itm lst nol num pat prc s53 scl sset usepth val xov yov)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq UsePth (getvar "TEMPPREFIX"))
      (setq ChkPth (getstring (strcat "\nDS> Destination Folder [" UsePth "]: ") T))
      (if (/= ChkPth "")(setq UsePth ChkPth))
      (if (vl-file-directory-p UsePth)
        (progn
          (if (> (strlen UsePth) 0)
            (progn
              (if (= (substr UsePth (strlen UsePth) 1) "\\")
                (setq UsePth (substr UsePth 1 (1- (strlen UsePth))))
              ) 
              (setq UsePth (strcat UsePth "\\"))
            )
          )
          (princ "\nDS> Select Hatch Patterns to Export: ")
          (setq sset (ssget '((0 . "HATCH"))))
          (if (/= sset nil)
            (progn
              (setq prc 0)
              (setq lst nil)
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq pat (strcase (cdr (assoc 2 ent))))
                (if (/= (strcase pat) "SOLID")
                  (if (not (member pat lst))
                    (progn
                      (setq cnt 0)
                      (setq lst (cons (strcase pat) lst))
                      (setq scl (cdr (assoc 41 ent)))
                      (setq nol (cdr (assoc 78 ent)))
                      (setq xov (cdr (assoc 43 ent)))
                      (setq yov (cdr (assoc 44 ent)))
                      (princ (strcat "\nDS> Processing Pattern: " (strcase pat)))
                      (setq fn (strcat UsePth pat ".pat"))
                      (setq fh (open fn "w"))
                      (princ (strcat "*" pat "," pat " Pattern" "\n") fh)
                      (foreach fld ent
                        (setq cod (car fld))
                        (setq val (cdr fld))
                        (cond
                          ((= cod 53)
                            (setq c53 (cos val))
                            (setq s53 (sin val))
                            (setq g53 (dstp_rtd val))
                            (princ (rtos g53 2 0) fh)
                          )
                          ((= cod 43)
                            (setq val (- val xov))
                            (setq val (/ val scl))
                            (princ (strcat ", " (dstp_sigfmt val 10)) fh)
                          )
                          ((= cod 44)
                            (setq val (- val yov))
                            (setq val (/ val scl))
                            (princ (strcat "," (dstp_sigfmt val 10)) fh)
                          )
                          ((= cod 45)
                            (setq g45 val)
                          )
                          ((= cod 46)
                            (setq g46 val)
                            (setq dv1 (/ (+ (* g45 c53)(* g46 s53)) scl))
                            (setq dv2 (/ (- (* g46 c53)(* g45 s53)) scl))
                            (princ (strcat ", " (dstp_sigfmt dv1 10)) fh)
                            (princ (strcat "," (dstp_sigfmt dv2 10)) fh)
                          )
                          ((= cod 79)
                            (setq das val)
                          )
                          ((= cod 49)
                            (setq val (/ val scl))
                            (if (= cnt 0)
                              (princ ", " fh)
                              (princ "," fh)
                            )
                            (princ (dstp_sigfmt val 4) fh)
                            (setq cnt (1+ cnt))
                            (if (= cnt das)
                              (progn
                                (princ "\n" fh)
                                (setq cnt 0)
                              )
                            )
                          )
                          (t nil)
                        )
                      )
                      (close fh)
                      (setq prc (1+ prc))
                    )
                  )
                )
                (setq itm (1+ itm))
              )
              (princ (strcat "\nDS> Exported (" (itoa prc) ") Hatch Patterns"))
            )
          )
        )
        (princ "\nDS> Folder Does Not Exist !!!")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Report Area of Hatch
; --------------------------------------------------------------------------

(defun c:HatArePer ( / chk cmdecho ent fnd hnd lst mrk obj org osmode
                          sset str tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq tmp (entsel "\nDS> Pick Hatch Object: "))
      (if (/= tmp nil)
        (progn
          (setq hnd (car tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (if (= obj "HATCH")
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (setq osmode (getvar "OSMODE"))
              (setvar "OSMODE" 0)
              (setq org (entlast))
              (command "_.UNDO" "_M")
              (dstp_prompt "DS> Extracting Hatch Boundaries ...")
              (hatchbnd_proc (ssadd hnd))
              (setq mrk org)
              (setq sset (ssadd))
              (while (/= mrk nil)
                (setq mrk (entnext mrk))
                (if (/= mrk nil)
                  (setq sset (ssadd mrk sset))
                )
              )
              (dstp_prompt "DS> Determining Regions ...")
              (command "_.REGION" sset "")
              (setq mrk org)
              (setq lst nil)
              (setq sset (ssadd))
              (while (/= mrk nil)
                (setq mrk (entnext mrk))
                (if (/= mrk nil)
                  (progn
                    (command "_.AREA" "_E" mrk)
                    (setq tmp (getvar "AREA"))
                    (setq lst (append lst (list (list mrk (getvar "AREA")(getvar "PERIMETER")))))
                    (setq sset (ssadd mrk sset))
                  )
                )
              )
              (dstp_prompt "DS> Preparing Area ...")
              (if (= (length lst) 1)
                (progn
                  (command "_.HATCH" "_SOLID" (car (car lst)) "")
                  (princ "\nDS> Hatch Area: ")
                  (princ (rtos (cadr (car lst))))
                  (princ " Perimeter: ")
                  (princ (rtos (caddr (car lst))))
                  (setq tmp (getstring "\nDS> Press Any Key to Continue: "))
                  (command "_.ERASE" "_L" sset "")
                )
                (progn
                  (setq chk 0.0)
                  (foreach rec lst
                    (if (> (cadr rec) chk)
                      (setq fnd rec chk (cadr rec))
                    )
                  )
                  (setq lst (dstp_remove fnd lst))
                  (setq sset (ssadd))
                  (foreach rec lst
                    (setq sset (ssadd (car rec) sset))
                  )
                  (princ "\n")
                  (command "_.SUBTRACT" (car fnd) "" sset "")
                  (command "_.AREA" "_E" "_L")
                  (command "_.HATCH" "_SOLID" "_L" "")
                  (princ "\nDS> Hatch Area: ")
                  (princ (rtos (getvar "AREA")))
                  (princ " Perimeter: ")
                  (princ (rtos (getvar "PERIMETER")))
                  (setq tmp (getstring "\nDS> Press Any Key to Continue: "))
                  (command "_.ERASE" "_L" (car fnd) sset "")
                )
              )
              (command "_.UNDO" "_B")
              (setvar "CMDECHO" cmdecho)
              (setvar "OSMODE" osmode)
            )
            (princ "\nDS> Selected Object was not a HATCH!")
          )
        )
      )
    )
  )
  (princ)
)

; ###########################################################################
;                                 INQTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                        Angle between two segments
; --------------------------------------------------------------------------

(defun c:InqAngRep ( / an1 an2 ang angbase angdir aunits chk ea ia l1d1
                        l1d2 l1p1 l1p2 l2d1 l2d2 l2p1 l2p2 osmode pt1 pt2
                        sg1 sg2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq angdir (getvar "ANGDIR"))
      (setvar "ANGDIR" 0)
      (setq angbase (getvar "ANGBASE"))
      (setvar "ANGBASE" 0)
      (setq aunits (getvar "AUNITS"))
      (setvar "AUNITS" 0)
      (setq sg1 (entsel "\nDS> Select 1st Segment: "))
      (if (/= sg1 nil)
        (progn
          (setq sg2 (entsel "\nDS> Select 2nd Segment: "))
          (if (/= sg2 nil)
            (progn
              (setq l1p1 (osnap (cadr sg1) "_mid"))
              (setq l1p2 (osnap (cadr sg1) "_end"))
              (setq l2p1 (osnap (cadr sg2) "_mid"))
              (setq l2p2 (osnap (cadr sg2) "_end"))
              (setq chk (inters l1p1 l1p2 l2p1 l2p2 nil))
              (if (/= chk nil)
                (progn
                  (if (< (atoi (getvar "ACADVER")) 15)
                    (setq dec (getvar "LUPREC"))
                    (setq dec (getvar "DIMADEC"))
                  )
                  (setq l1d1 (distance chk l1p1))
                  (setq l1d2 (distance chk l1p2))
                  (if (> l1d1 l1d2)
                    (setq pt1 l1p1)
                    (setq pt1 l1p2)
                  )
                  (setq l2d1 (distance chk l2p1))
                  (setq l2d2 (distance chk l2p2))
                  (if (> l2d1 l2d2)
                    (setq pt2 l2p1)
                    (setq pt2 l2p2)
                  )
                  (setq an1 (+ (angle chk pt1) (* pi 2.0)))
                  (setq an2 (+ (angle chk pt2) (* pi 2.0)))
                  (setq ang (abs (- an2 an1)))
                  (if (> ang pi)
                    (progn
                      (setq ea (angtos ang (getvar "DIMAUNIT") dec))
                      (setq ia (angtos (- (* pi 2.0) ang) (getvar "DIMAUNIT") dec))
                    )
                    (progn
                      (setq ia (angtos ang (getvar "DIMAUNIT") dec))
                      (setq ea (angtos (- (* pi 2.0) ang) (getvar "DIMAUNIT") dec))
                    )
                  )
                  (setq ia (dstp_subtext ia "d" (chr 176)))
                  (setq ea (dstp_subtext ea "d" (chr 176)))
                  (princ (strcat "\nDS> Interior Angle: " ia "  Exterior Angle: " ea))
                )
                (princ "\nDS> No intersection found!")
              )
            )
          )
        )
      )
      (setvar "ANGDIR" angdir)
      (setvar "ANGBASE" angbase)
      (setvar "AUNITS" aunits)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Report Arc Information
; --------------------------------------------------------------------------

(defun c:InqArcInf ( / apt1 apt2 cang ccd cen clen cmdecho cpnt eang ent
                        ext hnd iang larc mid2 miss obj ord ppt pti rads
                        sang tgnt tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq miss nil)
      (while (= miss nil)
        (setq tmp (entsel "\nDS> Select Arc or PolyArc Segment: "))
        (if (/= tmp nil)
          (progn
            (setq hnd (car tmp))
            (setq ppt (cadr tmp))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (if (or (= obj "POLYLINE")(= obj "LWPOLYLINE"))
              (progn
                (command "_.UNDO" "_M")
                (command "_.EXPLODE" hnd)
                (setq tmp (nentselp ppt))
                (setq hnd (car tmp))
                (setq ent (entget hnd))
                (setq obj (cdr (assoc 0 ent)))
                (command "_.UNDO" "_B")
              )
            )
            (if (= obj "ARC")
              (progn
                (setq cpnt (list (nth 1 (assoc 10 ent)) (nth 2 (assoc 10 ent))))
                (setq rads (cdr (assoc 40 ent)))                                       ; radius length
                (setq sang (cdr (assoc 50 ent)))
                (setq eang (cdr (assoc 51 ent)))
                (if (> eang sang)
                  (setq iang (- eang sang))
                  (setq iang (+ (- 6.28319 sang) eang))                                ; interior angle
                )
                (setq apt1 (polar cpnt sang rads))
                (setq apt2 (polar cpnt eang rads))
                (setq cang (angle apt1 apt2))                                          ; chord angle
                (setq clen (distance apt1 apt2))                                       ; chord length
                (setq larc (* iang rads))                                              ; length of arc
                (setq mid2 (polar apt1 cang (/ clen 2.0)))                             ; chord midpoint
                (setq ord (- rads (* rads (- 1 (cos (/ iang 2.0))))))                  ; middle ordinate
                (setq cen (polar mid2 (+ cang (/ pi 2.0)) ord))                        ; center coord
                (setq tgnt (abs (* (/ (sin (/ iang 2.0)) (cos (/ iang 2.0))) rads)))   ; tangent
                (setq ext (* rads (- (/ 1 (cos (/ iang 2.0))) 1)))                     ; external
                (setq ccd (angle cen mid2))                                            ; concave dir
                (setq pti (polar cen (angle cen mid2)(+ ext rads)))                    ; point of intersection
                (princ "\n---------------------------------------------------")
                (princ "\nRadius .................. ")
                (princ rads)
                (princ "\nInterior Angle .......... ")
                (princ (angtos iang 1))
                (princ "\nConcave Direction ....... ")
                (princ (angtos ccd))
                (princ "\nChord Angle ............. ")
                (princ (angtos cang))
                (princ "\nChord Length ............ ")
                (princ clen)
                (princ "\nArc Length .............. ")
                (princ larc)
                (princ "\nMiddle Ordinate ......... ")
                (princ ord)
                (princ "\nTangent ................. ")
                (princ tgnt)
                (princ "\nExternal ................ ")
                (princ ext)
                (princ "\nCenter Coordinate ....... ")
                (princ (strcat (rtos (car cen)) "," (rtos (cadr cen))))
                (princ "\nChord Midpoint .......... ")
                (princ (strcat (rtos (car mid2)) "," (rtos (cadr mid2))))
                (princ "\nPoint of Intersection ... ")
                (princ (strcat (rtos (car pti)) "," (rtos (cadr pti))))
                (princ "\n---------------------------------------------------")
              )
            )
          )
          (setq miss T)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Multi Object Area Calculator
; --------------------------------------------------------------------------

(defun c:InqAreSum ( / asum cmdecho hnd itm num res sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (princ (strcat "\nDS> Select Objects to Add Area ..."))
      (setq sset (ssget '((-4 . "<OR")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "HATCH")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "SPLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq asum 0.0)
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (command "_.AREA" "_O" hnd)
            (setq tmp (getvar "AREA"))
            (setq asum (+ asum tmp))
            (setq itm (1+ itm))
          )
          (cond
            ((= (getvar "LUNITS") 1)
              (setq res (rtos asum 1))
            )
            ((= (getvar "LUNITS") 2)
              (setq res (rtos asum 2))
            )
            ((or (= (getvar "LUNITS") 3)(= (getvar "LUNITS") 4))
              (setq res (strcat
                (rtos asum 2)
                " sq.in. ("
                (rtos (/ asum 144.0) 2)
                " sqft)"
              ))
            )
            ((= (getvar "LUNITS") 4)
              (setq res (rtos asum 4))
            )
            (t nil)
          )
          (princ (strcat "\nDS> Sum of Area in Objects: " res))
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Browse Entities by Passing Cursor Over
; --------------------------------------------------------------------------

(defun c:InqCurBro ( / elv ent hnd input linclr pnt sset tmp val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Move Crosshair Over Object, Press any button to stop ...")
      (princ "\nDS>")
      (setq linclr T) 
      (setq tmp (grread (quote T)))
      (while (= (car (setq input (grread (quote T)))) 5)
        (setq pnt (cadr input))
        (setq sset (ssget pnt))
        (if sset
          (progn
            (setq hnd (ssname sset 0))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (setq val "DS> Object: ")
            (setq val (strcat val obj))
            (if (= (cdr (assoc 0 ent)) "INSERT")
              (setq val (strcat val "=" (cdr (assoc 2 ent)) " ... "))
              (setq val (strcat val " ... "))
            )
            (setq val (strcat val "Layer: " (cdr (assoc 8 ent)) " ... "))
            (cond
              ((= obj "LWPOLYLINE")
                (if (= (cdr (assoc 38 ent)) nil)
                  (setq elv 0.0)
                  (setq elv (cdr (assoc 38 ent)))
                )
              )
              ((= obj "AECC_CONTOUR")
                (setq elv (cdr (assoc 40 ent)))
              )
              ((= obj "AECC_POINT")
                (setq val (dstp_subtext val obj (strcat obj "(" (rtos (cdr (assoc 90 ent)) 2 0) ")")))
                (setq elv (cadddr (assoc 11 ent)))
              )
              (t
                (setq elv (caddr (cdr (assoc 10 ent))))
              )
            )
            (setq val (strcat val "Elev: " (rtos elv 2 2)))
            (setq val (strcat val "                        "))
            (princ "\r")
            (princ val)
            (setq linclr nil)
          )
          (if (= linclr nil)
            (progn
              (princ "\rDS>")
              (princ "                                                                 ")
              (setq linclr T)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Distance (and elevation) along object
; --------------------------------------------------------------------------

(defun c:InqDisBro ( / axo ent hnd input linclr ndis obj pap pnt sset tmp val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Move Crosshair Over Object, Press any button to stop ...")
      (princ "\nDS>")
      (setq linclr T) 
      (setq tmp (grread (quote T)))
      (while (= (car (setq input (grread (quote T)))) 5)
        (setq pnt (cadr input))
        (setq sset (ssget pnt '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "LINE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
        (if sset
          (progn
            (setq pnt (osnap pnt "_nea")) 
            (setq hnd (ssname sset 0))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (setq axo (vlax-ename->vla-object hnd))
            (setq pap (vlax-curve-getparamatpoint axo pnt))
            (if (= pap nil)
              (setq val "\rDS> Distance: ???                                      ")
              (progn
                (setq ndis (vlax-curve-getdistatparam axo pap))
                (setq val (strcat "\rDS> Distance: " (rtos ndis)))
                (if (/= (caddr pnt) 0.0)
                  (setq val (strcat val "  Elevation: " (rtos (caddr pnt) 2 2)))
                )
                (setq val (strcat val "           "))
              )
            )
            (princ "\r")
            (princ val)
            (setq linclr nil)
          )
          (if (= linclr nil)
            (progn
              (princ "\rDS>")
              (princ "                                                                 ")
              (setq linclr T)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                   Polyline Area Individual/By Layer
; --------------------------------------------------------------------------

(defun c:InqArePln ( / asum atot cmdecho ent hnd itm laylst num obj pas sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq laylst (dstp_tablesel "Select Layer(s)" (acad_strlsort (dstp_bldlst "LAYER")) "m" ""))
      (if (/= laylst nil)
        (progn
          (setq atot 0.0 ptot 0.0)
          (foreach lay laylst
            (setq sset (ssget "_X" (list (cons 8 lay))))
            (if sset
              (progn
                (setq asum 0.0 psum 0.0)
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq obj (cdr (assoc 0 ent)))
                  (setq pas nil)
                  (cond
                    ((= obj "POLYLINE")
                      (if (/= (boole 1 (cdr (assoc 70 ent)) 8) 8)
                        (setq pas T)
                      )
                    )
                    ((= obj "LWPOLYLINE")
                      (setq pas T)
                    )
                    (t nil)
                  )
                  (if (= pas T)
                    (progn
                      (command "_.AREA" "_O" hnd)
                      (setq aitm (getvar "AREA"))
                      (setq pitm (getvar "PERIMETER"))
                      (setq asum (+ asum aitm))
                      (setq psum (+ psum pitm))
                    )
                  )
                  (setq itm (+ itm 1))
                )
                (setq atot (+ atot asum))
                (setq ptot (+ ptot psum))
                (princ (strcat "\nDS> [" lay "] Polyline Area: " (rtos asum) ", Perimeter: " (rtos psum)))
              )
            )
          )
          (princ "\n-----------------------------------------------------------------------")
          (princ (strcat "\nDS> Total Polyline Area: " (rtos atot) ", Perimeter: " (rtos ptot)))
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 List information of object picked in loop
; --------------------------------------------------------------------------

(defun c:InqObjInf (/ layr elv 3dp cmdecho def ent g70 hnd miss obj pnt tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq miss nil)
      (while (= miss nil)
        (setq tmp (entsel "\nDS> Select Object: "))
        (princ "\nDS> ")
        (if (/= tmp nil)
          (progn
            (setq 3dp nil)
            (setq pnt (cadr tmp))
            (setq hnd (car tmp))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (setq layr (cdr (assoc 8 ent)))
            (setq elv (caddr (cdr (assoc 10 ent))))
            (cond
              ((= obj "INSERT")
                (princ (strcat "INSERT of " (cdr (assoc 2 ent))))
                (setq def (tblsearch "BLOCK" (cdr (assoc 2 ent))))
                (setq g70 (cdr (assoc 70 def)))
                (if (= (boole 1 g70 4) 4)
                  (princ " (XREF)")
                )
              )
              ((= obj "POLYLINE")
                (if (= (boole 1 (cdr (assoc 70 ent)) 8) 8)
                  (progn
                    (princ "3DPOLY")
                    (setq elv (caddr (osnap pnt "_nea")))
                    (setq 3dp T)
                  )
                  (princ "2DPOLY")
                )
              )
              ((= obj "LWPOLYLINE")
                (if (= (cdr (assoc 38 ent)) nil)
                  (setq elv 0.0)
                  (setq elv (cdr (assoc 38 ent)))
                )
                (princ obj)
              )
              ((= obj "AECC_CONTOUR")
                (princ obj)
                (setq elv (cdr (assoc 40 ent)))
              )
              ((= obj "AECC_POINT")
                (princ obj)
                (setq val (dstp_subtext val obj (strcat obj "(" (rtos (cdr (assoc 90 ent)) 2 0) ")")))
                (setq elv (cadddr (assoc 11 ent)))
              )
              (t
                (princ obj)
              )
            )
            (princ " ... ")
            (princ "Layer: ")
            (princ layr)
            (princ " ... ")
            (princ "Elev: ")
            (princ (rtos elv))
            (if (= 3dp T)
              (princ " @ Pickpoint")
            )
          )
          (setq miss T)
        )
      )
      (dstp_ucspush)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                   Check Tangency of Selected Geometry
; --------------------------------------------------------------------------

(defun c:InqTanChk ( / alst ang anga ap1 ap2 apt1 apt2 atol cang cbul cen
                         chk clayer clen cmdecho cpnt ctr eang ent eold ept1
                         ept2 etol fndlst hnd iang itm lbul llst mid2 num obj
                         ord pnt1 pnt2 pt1 pt2 rads sang spt1 spt2 sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select LINE, ARC, LWPOLYLINE and POLYLINE objects ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "LINE")(0 . "ARC")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq tmp (getreal "\nDS> Decimal Angular Tolerance <0.0001>: "))
          (if (= tmp nil)(setq atol 0.0001)(setq atol tmp))
          (setq tmp (getreal "\nDS> Endpoint Matching Tolerance <0.0000001>: "))
          (if (= tmp nil)(setq etol 0.00000001)(setq etol tmp))
          (initget "Y N")
          (setq tmp (getkword "\nDS> Erase old error markers <Y>/N: "))
          (if (= tmp "N")(setq eold "N")(setq eold "Y"))
          (setq alst nil)
          (setq llst nil)
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "LINE")
                (setq pnt1 (dstp_2dpoint (cdr (assoc 10 ent))))
                (setq pnt2 (dstp_2dpoint (cdr (assoc 11 ent))))
                (setq llst (cons (list pnt1 pnt2) llst))
              )
              ((= obj "ARC")
                (setq cpnt (dstp_2dpoint (cdr (assoc 10 ent))))
                (setq rads (cdr (assoc 40 ent)))
                (setq sang (cdr (assoc 50 ent)))
                (setq eang (cdr (assoc 51 ent)))
                (setq spt1 (polar cpnt sang rads))
                (setq spt2 (polar spt1 (+ sang (/ pi 2.0)) 1.0))
                (setq ept1 (polar cpnt eang rads))
                (setq ept2 (polar ept1 (- eang (/ pi 2.0)) 1.0))
                (setq alst (cons (list spt1 spt2) alst))
                (setq alst (cons (list ept1 ept2) alst))
              )
              ((or (= obj "POLYLINE")(= obj "LWPOLYLINE"))
                (setq apt1 nil)
                (setq lbul nil)
                (dstp_getpline hnd)
                (foreach rec dstp_pldat
                  (setq apt2 (dstp_2dpoint (nth 0 rec)))
                  (setq cbul (nth 3 rec))
                  (if (/= lbul nil)
                    (if (not (equal (abs lbul) 0.0))
                      (progn
                        (setq iang (* 4.0 (atan (abs lbul))))
                        (setq anga (- (/ pi 2.0) (/ iang 2.0)))
                        (setq clen (distance apt1 apt2))
                        (setq rads (/ (/ clen 2.0) (cos anga)))
                        (if (> lbul 0.0)
                          (progn
                            (setq cang (angle apt1 apt2))
                            (setq mid2 (polar apt1 cang (/ clen 2.0)))
                          )
                          (progn
                            (setq cang (angle apt2 apt1))
                            (setq mid2 (polar apt2 cang (/ clen 2.0)))
                          )
                        )
                        (setq ord (- rads (* rads (- 1 (cos (/ iang 2.0))))))
                        (setq cen (polar mid2 (+ cang (/ pi 2.0)) ord))
                        (setq spt1 apt1)
                        (setq ept1 apt2)
                        (if (> lbul 0.0)
                          (progn
                            (setq spt2 (polar spt1 (+ (angle cen spt1) (/ pi 2.0)) 1.0))
                            (setq ept2 (polar ept1 (- (angle cen ept1) (/ pi 2.0)) 1.0))
                          )
                          (progn
                            (setq spt2 (polar spt1 (- (angle cen spt1) (/ pi 2.0)) 1.0))
                            (setq ept2 (polar ept1 (+ (angle cen ept1) (/ pi 2.0)) 1.0))
                          )
                        )
                        (setq alst (cons (list spt1 spt2) alst))
                        (setq alst (cons (list ept1 ept2) alst))
                      )
                      (progn
                        (if (/= apt1 nil)
                          (setq llst (cons (list apt1 apt2) llst))
                        )
                      )
                    )
                  )
                  (setq lbul cbul)
                  (setq apt1 apt2)
                )
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
          (if (> (length alst) 0)
            (if (> (length llst) 0)
              (progn
                (setq ctr 0)
                (setq fndlst nil)
                (princ "\nDS>")
                (foreach rec alst
                  (setq ctr (1+ ctr))
                  (princ (strcat "\rDS> Evaluating Endpoint Tangency " (itoa ctr) " of " (itoa (length alst))))
                  (setq ap1 (car rec))
                  (setq ap2 (cadr rec))
                  (setq ang (angle ap2 ap1))
                  ;
                  ; --- check for tangencies on lines
                  ;
                  (foreach lin llst
                    (setq pt1 (car lin))
                    (setq pt2 (cadr lin))
                    (if (equal pt1 ap1 etol)
                      (progn
                        (setq chk (angle pt1 pt2))
                        (if (not (equal ang chk atol))
                          (if (not (member ap1 fndlst))
                            (setq fndlst (cons ap1 fndlst))
                          )
                        )
                      )
                    )
                    (if (equal pt2 ap1 etol)
                      (progn
                        (setq chk (angle pt2 pt1))
                        (if (not (equal ang chk atol))
                          (if (not (member ap1 fndlst))
                            (setq fndlst (cons ap1 fndlst))
                          )
                        )
                      )
                    )
                  )
                  ;
                  ; --- check for tangencies on compound curves
                  ;
                  (foreach arc alst
                    (if (/= arc rec)
                      (progn
                        (if (equal (car arc) ap1 etol)
                          (progn
                            (setq chk (angle (car arc) (cadr arc)))
                            (if (not (equal ang chk atol))
                              (if (not (member ap1 fndlst))
                                (setq fndlst (cons ap1 fndlst))
                              )
                            )
                          )
                        )
                        (if (equal (caddr arc) ap1 etol)
                          (progn
                            (setq chk (angle (caddr arc) (cadr arc)))
                            (if (not (equal ang chk atol))
                              (if (not (member ap1 fndlst))
                                (setq fndlst (cons ap1 fndlst))
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (princ ", Done.")
                (if (= eold "Y")
                  (progn
                    (setq sset (ssget "_X" '((0 . "TEXT")(8 . "TANGENCY-CHECK"))))
                    (if sset
                      (command "_.ERASE" sset "")
                    )
                  )
                )
                (if (> (length fndlst) 0)
                  (progn
                    (setq clayer (getvar "CLAYER"))
                    (command "_LAYER" "_M" "TANGENCY-CHECK" "_C" "1" "TANGENCY-CHECK" "")
                    (foreach pnt fndlst
                      (dstp_maketext "MC" pnt 0.0 0.0 "X")
                    )
                    (setvar "CLAYER" clayer)
                    (princ (strcat "\nDS> (" (itoa (length fndlst)) ") Instances found and marked!"))
                  )
                  (princ "\nDS> No instances found.")
                )
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Report Elevation Range
; --------------------------------------------------------------------------

(defun c:InqElvRng ( / dat elv ent hnd itm maxz minz num obj pnt sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ (strcat "\nDS> Select Objects to Evaluate ..."))
      (setq sset (ssget '((-4 . "<OR")(0 . "AECC_CONTOUR")(0 . "AECC_POINT")(0 . "3DFACE")(0 . "ARC")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "INSERT")(0 . "LINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "MTEXT")(0 . "POINT")(0 . "POLYLINE")(0 . "SPLINE")(0 . "SOLID")(0 . "TEXT")(-4 . "OR>"))))
      (if sset
        (progn
          (princ "\nDS>")
          (setq minz 999999999999.99)
          (setq maxz -999999999999.99)
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Evaluating object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (cond
              ((= obj "AECC_CONTOUR")
                (setq elv (cdr (assoc 40 ent)))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
              )
              ((= obj "AECC_POINT")
                (setq elv (caddr (cdr (assoc 11 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
              )
              ((= obj "3DFACE")
                (setq elv (caddr (cdr (assoc 10 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
                (setq elv (caddr (cdr (assoc 11 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
                (setq elv (caddr (cdr (assoc 12 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
                (setq elv (caddr (cdr (assoc 13 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
              )
              ((= obj "LINE")
                (setq elv (caddr (cdr (assoc 10 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
                (setq elv (caddr (cdr (assoc 11 ent))))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
              )
              ((= obj "POLYLINE")
                (setq dat (cadr (dstp_getpline hnd)))
                (foreach rec dat
                  (setq pnt (car rec))
                  (setq elv (caddr pnt))
                  (if (< elv minz)(setq minz elv))
                  (if (> elv maxz)(setq maxz elv))
                )
              )
              ((or (= obj "MLINE")(= obj "SPLINE"))
                (foreach lin ent
                  (if (= (car lin) 11)
                    (progn
                      (setq elv (cadr (cdr lin)))
                      (if (< elv minz)(setq minz elv))
                      (if (> elv maxz)(setq maxz elv))
                    )
                  )
                )
              )
              (t
                (setq elv (dstp_getelev hnd))
                (if (< elv minz)(setq minz elv))
                (if (> elv maxz)(setq maxz elv))
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (princ (strcat "\nDS> Minimum: " (rtos minz) "  Maximum: " (rtos maxz) "  Average: " (rtos (/ (+ maxz minz) 2.0))))
        )
      )
    )
  )
  (princ)
)

; ###########################################################################
;                                 LAYOTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                            Display Viewport Scale
; --------------------------------------------------------------------------

(defun c:LyoVptScl ( / ang cmdecho cpy ctr cvhgt cvsiz ent hgt hnd llc lrc
                         osmode tmp ulc urc vpi vpl wid)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= (getvar "tilemode") 0)
        (progn
          (if (> (getvar "cvport") 1)
            (progn
              (setq vpi (getvar "cvport"))
              (setq vpl (ssget "_X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
              (setq hnd (ssname vpl 0))
              (setq ent (entget hnd '("ACAD")))
              (princ "\nDS> Current Viewport: ")
            )
            (progn
              (setq tmp (entsel "\nDS> Select Viewport: "))
              (if (/= tmp nil)
                (progn
                  (setq hnd (car tmp))
                  (setq ent (entget hnd '("ACAD")))
                  (setq obj (cdr (assoc 0 ent)))
                  (if (member obj (list "LWPOLYLINE" "POLYLINE" "ELLIPSE" "SPLINE" "REGION" "CIRCLE"))
                    (progn
                      (setq pik (cadr tmp))
                      (setq llc (list (- (car pik) 0.1) (- (cadr pik) 0.1)))
                      (setq lrc (list (+ (car pik) 0.1) (- (cadr pik) 0.1)))
                      (setq urc (list (+ (car pik) 0.1) (+ (cadr pik) 0.1)))
                      (setq ulc (list (- (car pik) 0.1) (+ (cadr pik) 0.1)))
                      (setq ptl (list llc lrc urc ulc))
                      (setq cset (ssget "_CP" ptl '((0 . "VIEWPORT"))))
                      (if (/= cset nil)
                        (progn
                          (setq hnd (ssname cset 0))
                          (setq ent (entget hnd '("ACAD")))
                          (setq obj (cdr (assoc 0 ent)))
                        )
                      )
                    )
                  )
                  (setq vpi (cdr (assoc 69 ent)))
                )
              )
            )
          )
          (if (< (atoi (getvar "ACADVER")) 15.0)
            (progn
              (setq cvhgt (cdr (assoc 41 ent)))
              (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
              (cond
                ((< cvsiz cvhgt)
                  (princ (strcat (rtos (/ cvhgt cvsiz)) ":" (rtos 1)))
                )
                (t
                  (princ (strcat (rtos 1) ":" (rtos (/ cvsiz cvhgt))))
                )
              )
            )
            (progn
              (setq axo (vlax-ename->vla-object hnd))
              (setq scl (vla-get-customscale axo))
              (if (< scl 1.0)
                (princ (strcat "1:" (rtos (/ 1.0 scl))))
                (princ (strcat (rtos scl) ":1" ))
              )
            )
          )
          (if (> (getvar "cvport") 1)
            (progn
              (initget "Y N")
              (setq cpy (getkword "\nDS> Copy ViewPort Limits to Model Space Rectangle Y/<N>: "))
              (if (/= cpy "Y")(setq cpy "N"))
              (if (= cpy "Y")
                (progn
                  (setq ctr (cdr (assoc 10 ent)))
                  (if (< (atoi (getvar "ACADVER")) 15)
                    (progn
                      (setq wid (cdr (assoc 40 ent)))
                      (setq hgt (cdr (assoc 41 ent)))
                      (setq ang (cdr (assoc 51 ent)))
                    )
                    (progn
                      (setq wid (vla-get-width axo))
                      (setq hgt (vla-get-height axo))
                      (setq ang (vla-get-twistangle axo))
                    )
                  )
                  (setq tmp (polar ctr 0 (/ wid 2.0)))
                  (setq urc (polar tmp (/ pi 2.0) (/ hgt 2.0)))
                  (setq ulc (polar urc pi wid))
                  (setq lrc (polar tmp (+ pi (/ pi 2.0)) (/ hgt 2.0)))
                  (setq llc (polar lrc pi wid))
                  (setq llc (trans (trans llc 3 2) 2 0))
                  (setq ulc (trans (trans ulc 3 2) 2 0))
                  (setq urc (trans (trans urc 3 2) 2 0))
                  (setq lrc (trans (trans lrc 3 2) 2 0))
                  (setq osmode (getvar "OSMODE"))
                  (setvar "OSMODE" 0)
                  (setq cmdecho (getvar "CMDECHO"))
                  (setvar "CMDECHO" 0)
                  (command "_.UNDO" "_G")
                  (dstp_ucspush)
                  (command "_.PLINE" ulc urc lrc llc "_C")
                  (dstp_ucspop)
                  (command "_.UNDO" "_E")
                  (setvar "CMDECHO" cmdecho)
                  (setvar "OSMODE" osmode)
                )
              )
            )
          )
        )
        (princ "\nDS> NOTICE: Enable Paper Space with TILEMODE=0")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                            Viewport Align
; --------------------------------------------------------------------------

(defun c:LyoVptAli ( / ang axo cmdecho ent hnd mds mp1 mp2 nsf osmode pds
                        pp1 pp2 pr1 pr2 scl tmp vpi vpl)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (= (getvar "tilemode") 0)
        (progn
          (if (> (getvar "cvport") 1)
            (progn
              (setq vpi (getvar "cvport"))
              (setq vpl (ssget "_X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
              (setq hnd (ssname vpl 0))
              (setq ent (entget hnd '("ACAD")))
            )
            (progn
              (setq tmp (entsel "\nDS> Select Viewport: "))
              (if (/= tmp nil)
                (progn
                  (setq hnd (car tmp))
                  (setq ent (entget hnd '("ACAD")))
                  (setq vpi (cdr (assoc 69 ent)))
                  (command "_.MSPACE")
                  (setvar "cvport" vpi)
                )
              )
            )
          )
          (setq mp1 (getpoint "\nDS> Model Space Point #1: "))
          (setq mp2 (getpoint mp1 "\nDS> Model Space Point #2: "))
          (setq mds (distance mp1 mp2))
          (command "_.PSPACE")
          (setq pp1 (getpoint "\nDS> Paper Space Point #1: "))
          (setq pp2 (getpoint pp1 "\nDS> Paper Space Point #2: "))
          (command "_.MSPACE")
          (setq axo (vlax-ename->vla-object hnd))
          (setq ang (vla-get-twistangle axo))
          (setq scl (vla-get-customscale axo))
          (setq pr1 (trans (trans pp1 3 2) 2 0))
          (setq pr2 (trans (trans pp2 3 2) 2 0))
          (setq pds (distance pr1 pr2))
          (setq nsf (* scl (/ pds mds)))
          (setq ang (- (angle pr1 pr2)(angle mp1 mp2)))
          (vla-put-twistangle axo ang)
          (vla-put-customscale axo nsf)
          (setq pr1 (trans (trans pp1 3 2) 2 0))
          (setq pr2 (trans (trans pp2 3 2) 2 0))
          (command "_.PAN" mp1 pr1)
        )
        (princ "\nDS> NOTICE: Enable Paper Space with TILEMODE=0")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          Viewport Synchronize
; --------------------------------------------------------------------------

(defun c:LyoVptSyn ( / ang axo cen cmdecho ent hnd itm lst ncp num obj
                       osmode pik scl sset tmp vpi)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (= (getvar "tilemode") 0)
        (progn
          (command "_.PSPACE")
          (setq pik (entsel "\nDS> Select Master Viewport: "))
          (if (/= pik nil)
            (progn
              (setq hnd (car pik))
              (setq ent (entget hnd))
              (setq obj (cdr (assoc 0 ent)))
              (if (= obj "VIEWPORT")
                (progn
                  (princ "\nDS> Select Viewports to Align: ")
                  (setq sset (ssget '((0 . "VIEWPORT"))))
                  (if sset
                    (progn
                      (setq axo (vlax-ename->vla-object hnd))
                      (setq ang (vla-get-twistangle axo))
                      (setq scl (vla-get-customscale axo))
                      (setq vpi (cdr (assoc 69 ent)))
                      (command "_.MSPACE")
                      (setvar "CVPORT" vpi)
                      (setq lst nil)
                      (setq num (sslength sset) itm 0)
                      (while (< itm num)
                        (setq hnd (ssname sset itm))
                        (setq ent (entget hnd))
                        (setq cen (cdr (assoc 10 ent)))
                        (setq ncp (trans (trans cen 3 2) 2 0))
                        (setq lst (cons ncp lst))
                        (setq itm (1+ itm))
                      )
                      (setq lst (reverse lst))
                      (setq tmp nil)
                      (setq num (sslength sset) itm 0)
                      (while (< itm num)
                        (setq hnd (ssname sset itm))
                        (setq ent (entget hnd))
                        (setq cen (cdr (assoc 10 ent)))
                        (setq axo (vlax-ename->vla-object hnd))
                        (vla-put-twistangle axo ang)
                        (vla-put-customscale axo scl)
                        (setq vpi (cdr (assoc 69 ent)))
                        (setvar "CVPORT" vpi)
                        (dstp_ucspush)
                        (command "_.ZOOM" "_C" (nth itm lst) "")
                        (dstp_ucspop)
                        (setq itm (1+ itm))
                      )
                      (command "_.PSPACE")
                    )
                  )
                )
                (princ "\nDS> Select Object is not a Viewport!")
              )
            )
          )
        )
        (princ "\nDS> NOTICE: Enable Paper Space with TILEMODE=0")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Copy Layer Status Between Viewports
; --------------------------------------------------------------------------

(defun c:LyoVptCls ( / chk cmdecho dat ent hnd lst obj opt sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "Y N")
      (setq opt (getkword "\nDS> Retain Frozen Layers in Target Viewports Y/<N>: "))
      (if (/= opt "Y")(setq opt "N"))
      (setq tmp (entsel "\nDS> Select Source Viewport: "))
      (setq hnd (car tmp))
      (setq ent (entget hnd '("ACAD")))
      (setq obj (cdr (assoc 0 ent)))
      (if (= obj "VIEWPORT")
        (progn
          (setq dat (car (cdr (assoc -3 ent))))
          (setq lst nil)
          (foreach rec dat
            (if (= (type rec) 'LIST)
              (if (= (car rec) 1003)
                (progn
                  (setq chk (cdr rec))
                  (if (/= (tblsearch "LAYER" chk) nil)
                    (setq lst (cons chk lst))
                  )
                )
              )
            )
          )
          (if (> (length lst) 0)
            (progn
              (setq lst (acad_strlsort lst))
              (princ "\nDS> Select Target Viewport(s) ...")
              (setq sset (ssget '((0 . "VIEWPORT"))))
              (if sset
                (progn
                  (setq cmdecho (getvar "CMDECHO"))
                  (setvar "CMDECHO" 0)
                  (command "_.UNDO" "_G")
                  (dstp_ucspush)
                  (if (/= opt "Y")
                    (command "_.VPLAYER" "_T" "*" "_S" sset "" "")
                  )
                  (foreach lay lst
                    (command "_.VPLAYER")
                    (command "_F" lay "_S" sset "")
                    (command "")
                  )
                  (dstp_ucspop)
                  (command "_.UNDO" "_E")
                  (setvar "CMDECHO" cmdecho)
                )
              )
            )
            (princ "\nDS> No Frozen Layers found in Source Viewport!")
          )
        )
        (princ "\nDS> Selected Object was not a Viewport!")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Create New Layers Visible in Current Only
; --------------------------------------------------------------------------

(defun c:LyoVptCnl ( / acd chk cmdecho cur doc ent hnd layouts lst nam opt
                         sset str tmp use vpi vpl)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= (getvar "tilemode") 0)
        (progn
          (if (> (getvar "cvport") 1)
            (progn
              (setq vpi (getvar "cvport"))
              (setq vpl (ssget "_X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
              (setq hnd (ssname vpl 0))
              (setq ent (entget hnd '("ACAD")))
            )
            (progn
              (setq tmp (entsel "\nDS> Select Layer Visible Viewport: "))
              (if (/= tmp nil)
                (progn
                  (setq hnd (car tmp))
                  (setq ent (entget hnd '("ACAD")))
                  (setq vpi (cdr (assoc 69 ent)))
                )
              )
            )
          )
          (princ "\nDS> Enter Layer Names to Create (Separate by Commas) ...")
          (setq str (getstring "\nDS> Layer(s): " T))
          (if (/= str "")
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (command "_.LAYER" "_N" str "")
              (if (< (atoi (getvar "ACADVER")) 15)
                (progn
                  (setq sset (ssget "_X" (list (cons 0 "VIEWPORT"))))
                  (if (/= sset nil)
                    (progn
                      (ssdel hnd sset)
                      (if (/= sset nil)
                        (command "_.VPLAYER" "_F" str "_S" sset "" "")
                      )
                    )
                  )
                )
                (progn
                  (initget "C A S")
                  (setq opt (getkword "\nDS> Freeze in Layouts All/Selected/<Current>: "))
                  (if (= opt nil)(setq opt "C"))
                  (setq acd (vlax-get-acad-object))
                  (setq doc (vla-get-activedocument acd))
                  (setq layouts (vla-get-layouts doc))
                  (setq lst nil)
                  (vlax-for itm layouts
                    (setq nam (vla-get-name itm))
                    (setq lst (cons nam lst))
                  )
                  (setq lst (dstp_remove "Model" lst))
                  (setq use nil)
                  (cond
                    ((= opt "A")
                      (setq use lst)
                    )
                    ((= opt "C")
                      (setq use (list (getvar "CTAB")))
                    )
                    ((= opt "S")
                      (setq lst (acad_strlsort lst))
                      (setq chk (dstp_tablesel "Process Layout(s)" lst "m" "T"))
                      (if (/= chk nil)
                        (setq use chk)
                      )
                    )
                  )
                  (if (/= use nil)
                    (progn
                      (setq cur (getvar "CTAB"))
                      (if (member cur use)
                        (progn
                          (dstp_remove cur use)
                          (setq use (append (list cur) use))
                        )
                      )
                      (foreach lay use
                        (command "_.LAYOUT" "_S" lay)
                        (setq sset (ssget "_X" (list (cons 0 "VIEWPORT")(cons 410 lay))))
                        (if (/= sset nil)
                          (progn
                            (ssdel hnd sset)
                            (if (/= sset nil)
                              (command "_.VPLAYER" "_F" str "_S" sset "" "")
                            )
                          )
                        )
                      )
                      (command "_.LAYOUT" "_S" cur)
                    )
                  )
                )
              )
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
            )
          )
        )
        (princ "\nDS> NOTICE: Enable Paper Space with TILEMODE=0")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                             Layout Merge
; --------------------------------------------------------------------------

(defun c:LyoMrgMul ( / $value acd add cmddia cmdecho dcl_id doc doproc emax
                       emin ent fillst layouts msg nam nxt optitm osmode out
                       pnt pntmrk pre prolst resitm srclst srcsel sset taritm
                       tarlst uct)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun dislaymrg_docheck ()
        (setq uct 1)
        (setq msg "")
        (setq prolst nil)
        (while (setq optitm (read srcsel))
          (setq resitm (nth optitm srclst))
          (setq prolst (append prolst (list resitm)))
          (while (and (/= " " (substr srcsel uct 1))
            (/= "" (substr srcsel uct 1)))
            (setq uct (1+ uct))
          )
          (setq srcsel (substr srcsel uct))
        )
        (if (member taritm prolst)
          (setq msg "Target Included in Source List!")
        )
        (if (= (length prolst) 0)
          (progn
            (setq add "No Source Layouts Chosen!")
            (if (= msg "")
              (setq msg add)
              (setq msg (strcat msg "\n" add))
            )
          )
        )
        (if (= taritm "")
          (progn
            (setq add "No Target Layout Chosen!")
            (if (= msg "")
              (setq msg add)
              (setq msg (strcat msg "\n" add))
            )
          )
        )
        (if (/= msg "")
          (alert msg)
        )
      )
      (setq acd (vlax-get-acad-object))
      (setq doc (vla-get-activedocument acd))
      (setq layouts (vla-get-layouts doc))
      (setq srclst nil)
      (vlax-for itm layouts
        (setq nam (vla-get-name itm))
        (setq srclst (cons nam srclst))
      )
      (setq srclst (dstp_remove "Model" srclst))
      (setq srclst (acad_strlsort srclst))
      (setq taritm "")
      (setq srcsel "")
      (setq tarlst srclst)
      (setq tarlst (cons "Model" tarlst))
      (setq dcl_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "layoutmrg" dcl_id)) (exit))
      (start_list "srclst")
      (mapcar 'add_list srclst)
      (end_list)
      (start_list "tarlst")
      (mapcar 'add_list tarlst)
      (end_list)
      (action_tile "srclst" "(setq srcsel $value)")
      (action_tile "tarlst" "(setq taritm (nth (atoi $value) tarlst))")
      (action_tile "accept" "(dislaymrg_docheck)(if (= msg \"\")(progn (setq doproc T)(done_dialog 0)))")
      (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
      (action_tile "help" "(dstp_showhelp \"LyoMrgMul.htm\")")
      (if (equal (start_dialog) 1)
        (unload_dialog dcl_id)
      )
      ;
      ; --- Begin Processing Data
      ;
      (if (= doproc T)
        (progn
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (setq pre (getvar "TEMPPREFIX"))
          (setq fillst nil)
          (foreach lay prolst
            (command "_.LAYOUT" "_S" lay)
            (command "_.PSPACE")
            (setq out (strcat pre lay ".dwg"))
            (if (findfile out)
              (vl-file-delete out)
            )
            (setq sset (ssget "_C" (getvar "LIMMIN")(getvar "LIMMAX")))
            (setvar "EXPERT" 5)
            (setvar "FILEDIA" 0)
            (if (member "ade.arx" (arx))
              (progn
                (setq cmddia (getvar "CMDDIA"))
                (setvar "CMDDIA" 0)
                (command "_.WBLOCK" out "" "0,0" sset "" "_N")
                (setvar "CMDDIA" cmddia)
              )
              (command "_.WBLOCK" out "" "0,0" sset "")
            )
            (setvar "FILEDIA" 1)
            (setvar "EXPERT" 0)
            (command "_.LAYOUT" "_D" lay)
            (setq fillst (cons out fillst))
          )
          ;
          (setq fillst (reverse fillst))
          (command "_.LAYOUT" "_S" taritm)
          (dstp_ucspush)
          (if (/= taritm "Model")
            (progn
              (command "_.POINT" "0,0")
              (setq pntmrk (entlast))
            )
          )
          (foreach fil fillst
            (setq emin (getvar "EXTMIN"))
            (setq emax (getvar "EXTMAX"))
            (setq pnt (list (car emax)(cadr emin)))
            (setq pnt (polar pnt 0.0 (* (dstp_textsize) 10.0)))
            (command "_.INSERT" (strcat "*" fil) pnt "1.0" "0.0")
            (vl-file-delete fil)
          )
          (if (/= taritm "Model")
            (progn
              (setq sset (ssadd))
              (setq nxt pntmrk)
              (while (/= nxt nil)
                (setq nxt (entnext nxt))
                (if (/= nxt nil)
                  (progn
                    (setq ent (entget nxt))
                    (if (= (cdr (assoc 0 ent)) "VIEWPORT")
                      (setq sset (ssadd nxt sset))
                    )
                  )
                )
              )
              (if (> (sslength sset) 0)
                (command "_.MVIEW" "_ON" sset "")
              )
            )
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Copy Viewports for later Pasting
; --------------------------------------------------------------------------

(defun c:LyoVptCpy ( / cmdecho sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= (getvar "tilemode") 0)
        (progn
          (if (= (getvar "cvport") 1)
            (progn
              (princ "\nDS> Select Viewports to Copy ...")
              (setq sset (ssget '((0 . "VIEWPORT"))))
              (if sset
                (progn
                  (setq cmdecho (getvar "CMDECHO"))
                  (setvar "CMDECHO" 0)
                  (command "_.UNDO" "_G")
                  (setq dstp_vpblknam (vl-string-subst "" "." (rtos (getvar "CDATE") 2 8)))
                  (command "_.-BLOCK" dstp_vpblknam "0,0,0" sset "")
                  (command "_.OOPS")
                  (command "_.UNDO" "_E")
                  (setvar "CMDECHO" cmdecho)
                  ;
                  (princ "\nDS> Switch to Target Viewport and use ToolPac Layout Viewport Paste")
                )
              )
            )
            (princ "\nDS> Switch to Paper Space to Select Viewports!")
          )
        )
        (princ "\nDS> NOTICE: Enable Paper Space with TILEMODE=0")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Paste Copied Viewports
; --------------------------------------------------------------------------

(defun c:LyoVptPst ( / chk cmdecho ent nxt pntmrk ret sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= (getvar "tilemode") 0)
        (progn
          (if (= (getvar "cvport") 1)
            (progn
              (if (/= dstp_vpblknam nil)
                (progn
                  (initget "Y N")
                  (setq chk (getkword "\nDS> Retain Copy for Additional Pastes Y/<N>: "))
                  (if (= chk "Y")(setq ret T)(setq ret nil))
                  (setq cmdecho (getvar "CMDECHO"))
                  (setvar "CMDECHO" 0)
                  (command "_.UNDO" "_G")
                  (command "_.POINT" "0,0")
                  (setq pntmrk (entlast))
                  (command "_.-INSERT" (strcat "*" dstp_vpblknam) "0,0,0" "1.0" "")
                  (setq sset (ssadd))
                  (setq nxt pntmrk)
                  (while (/= nxt nil)
                    (setq nxt (entnext nxt))
                    (if (/= nxt nil)
                      (progn
                        (setq ent (entget nxt))
                        (if (= (cdr (assoc 0 ent)) "VIEWPORT")
                          (setq sset (ssadd nxt sset))
                        )
                      )
                    )
                  )
                  (if (> (sslength sset) 0)
                    (command "_.MVIEW" "_ON" sset "")
                  )
                  (entdel pntmrk)
                  (command "_.UNDO" "_E")
                  (setvar "CMDECHO" cmdecho)
                  (if (/= ret T)
                    (progn
                      (command "_.PURGE" "_B" dstp_vpblknam "_N")
                      (setq dstp_vpblknam nil)
                    )
                  )
                )
                (princ "\nDS> No Viewports copied in this session!")
              )
            )
            (princ "\nDS> Switch to Paper Space before Paste!")
          )
        )
        (princ "\nDS> NOTICE: Enable Paper Space with TILEMODE=0")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Layout to Separate Files
; --------------------------------------------------------------------------

(if (/= (getvar "PRODUCT") "AutoCAD")
(defun c:LyoSavFil ( / $value acd ang attreq axo bnd bndhnd bndpts cen chk
                          cmdecho ctr cvhgt cvscl cvsiz dat dcl_id del doc
                          doproc ent eov fh frz g340 hgt hnd inc itm layouts
                          lc let ll llc llp llt ln lrc lrp lrt ls lst lt mrk
                          msctr mset nam new nset num obj ofs ofspts optitm
                          org osmode out pass path pik plinewid prj prolst
                          psctr psrot ptlst pur rec refpnt reg rep resitm
                          resp srclst srcsel sset str tmp uct ulc ulp ult urc
                          urp urt vers vid vpi vpl vptfrz vset wid xrfdat
                          xrffrz xyd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= (getvar "DBMOD") 0)
        (progn
          (setq org (strcat (getvar "DWGPREFIX")(getvar "DWGNAME")))
          (setq path (dstp_regfetch "Layout" "filepath" (getvar "TEMPPREFIX")))
          (setq vers (dstp_regfetch "Layout" "filevers" "2000"))
          (setq chk (dstp_regfetch "Layout" "doerase" "False"))
          (if (= chk "False")(setq eov nil)(setq eov T))
          (setq chk (dstp_regfetch "Layout" "dopurge" "False"))
          (if (= chk "False")(setq pur nil)(setq pur T))
          (setq chk (dstp_regfetch "Layout" "dofreeze" "False"))
          (if (= chk "False")(setq frz nil)(setq frz T))
          (setq chk (dstp_regfetch "Layout" "dobind" "False"))
          (if (= chk "False")(setq bnd nil)(setq bnd T))
          (setq chk (dstp_regfetch "Layout" "doproj" "False"))
          (if (= chk "False")(setq prj nil)(setq prj T))
          (setq acd (vlax-get-acad-object))
          (setq doc (vla-get-activedocument acd))
          (setq layouts (vla-get-layouts doc))
          (setq srclst nil)
          (vlax-for itm layouts
            (setq nam (vla-get-name itm))
            (setq srclst (cons nam srclst))
          )
          (setq srclst (dstp_remove "Model" srclst))
          (setq srclst (acad_strlsort srclst))
          (setq srcsel "")
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog "lyosavfil" dcl_id)) (exit))
          (cond
            ((= (atoi (getvar "ACADVER")) 17)
              (mode_tile "savr13" 1)
              (mode_tile "savr14" 1)
              (mode_tile "sava10" 1)
              (mode_tile "sava13" 1)
            )
            ((= (atoi (getvar "ACADVER")) 18)
              (mode_tile "savr13" 1)
              (mode_tile "savr14" 1)
              (mode_tile "sava13" 1)
            )
            ((= (atoi (getvar "ACADVER")) 19)
              (mode_tile "savr13" 1)
            )
          )
          (start_list "srclst")
          (mapcar 'add_list srclst)
          (end_list)
          (cond
            ((= vers "R12")(set_tile "savr12" "1"))
            ((= vers "R13")(set_tile "savr13" "1"))
            ((= vers "R14")(set_tile "savr14" "1"))
            ((= vers "2000")(set_tile "sava00" "1"))
            ((= vers "2004")(set_tile "sava04" "1"))
            ((= vers "2007")(set_tile "sava07" "1"))
            ((= vers "2010")(set_tile "sava10" "1"))
          )
          (if (= eov T)
            (set_tile "opteov" "1")
            (set_tile "opteov" "0")
          )
          (if (= pur T)
            (set_tile "optpur" "1")
            (set_tile "optpur" "0")
          )
          (if (= frz T)
            (set_tile "optfrz" "1")
            (set_tile "optfrz" "0")
          )
          (if (= bnd T)
            (set_tile "optbnd" "1")
            (set_tile "optbnd" "0")
          )
          (if (= prj T)
            (set_tile "optprj" "1")
            (set_tile "optprj" "0")
          )
          (set_tile "outpth" path)
          (action_tile "srclst" "(setq srcsel $value)")
          (action_tile "savr12" "(setq vers \"R12\")")
          (action_tile "savr13" "(setq vers \"R13\")")
          (action_tile "savr14" "(setq vers \"R14\")")
          (action_tile "sava00" "(setq vers \"2000\")")
          (action_tile "sava04" "(setq vers \"2004\")")
          (action_tile "sava07" "(setq vers \"2007\")")
          (action_tile "sava10" "(setq vers \"2010\")")
          (action_tile "opteov" "(if (= $value \"1\")(setq eov T)(setq eov nil))")
          (action_tile "optpur" "(if (= $value \"1\")(setq pur T)(setq pur nil))")
          (action_tile "optfrz" "(if (= $value \"1\")(setq frz T)(setq frz nil))")
          (action_tile "optbnd" "(if (= $value \"1\")(setq bnd T)(setq bnd nil))")
          (action_tile "optprj" "(if (= $value \"1\")(setq prj T)(setq prj nil))")
          (action_tile "outpth" "(setq path $value)")
          (action_tile "selpth" "(setq chk (dstp_getfolder \"Select Target Folder\" nil))(if (/= chk \"\")(progn (setq path chk)(set_tile \"outpth\" path)))")
          (action_tile "accept" "(if (= srcsel \"\")(alert \"No Source Layouts Selected\")(progn (setq doproc T)(done_dialog 0)))")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
          (if (equal (start_dialog) 1)
            (unload_dialog dcl_id)
          )
          (if (= doproc T)
            (progn
              (if (/= (substr path (strlen path) 1) (chr 92))
                (setq path (strcat path (chr 92)))
              )
              (dstp_regstore "Layout" "filepath" path)
              (dstp_regstore "Layout" "filevers" vers)
              (if (= eov T)
                (dstp_regstore "Layout" "doerase" "True")
                (dstp_regstore "Layout" "doerase" "False")
              )
              (if (= pur T)
                (dstp_regstore "Layout" "dopurge" "True")
                (dstp_regstore "Layout" "dopurge" "False")
              )
              (if (= frz T)
                (dstp_regstore "Layout" "dofreeze" "True")
                (dstp_regstore "Layout" "dofreeze" "False")
              )
              (if (= bnd T)
                (dstp_regstore "Layout" "dobind" "True")
                (dstp_regstore "Layout" "dobind" "False")
              )
              (if (= prj T)
                (dstp_regstore "Layout" "doproj" "True")
                (dstp_regstore "Layout" "doproj" "False")
              )
              (setq uct 1)
              (setq prolst nil)
              (while (setq optitm (read srcsel))
                (setq resitm (nth optitm srclst))
                (setq prolst (append prolst (list resitm)))
                (while (and (/= " " (substr srcsel uct 1))
                  (/= "" (substr srcsel uct 1)))
                  (setq uct (1+ uct))
                )
                (setq srcsel (substr srcsel uct))
              )
              (setq osmode (getvar "OSMODE"))
              (setvar "OSMODE" 0)
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (setq plinewid (getvar "PLINEWID"))
              (setvar "PLINEWID" 0.00)
              (setq angbase (getvar "ANGBASE"))
              (setvar "ANGBASE" 0)
              (setq angdir (getvar "ANGDIR"))
              (setvar "ANGDIR" 0)
              (foreach lay prolst
                (if (/= vers "R12")
                  (setq out (strcat path lay ".dwg"))
                  (setq out (strcat path lay ".dxf"))
                )
                (if (findfile out)
                  (vl-file-delete out)
                )
                (command "_.UNDO" "_M")
                (command "_.LAYER" "_U" "_*" "_T" "0" "S" "0" "")
                (if (= bnd T)
                  (progn
                    (dstp_prompt "DS> Bind Inserting Xrefs ... ")
                    ;
                    ; --- collect frozen in viewport info for later
                    ;
                    (setq vptfrz nil)
                    (command "_.PSPACE")
                    (setq vset (ssget "X" '((0 . "VIEWPORT"))))
                    (if (/= vset nil)
                      (progn
                        (setq num (sslength vset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname vset itm))
                          (setq ent (entget hnd '("ACAD")))
                          (setq vid (cdr (assoc 69 ent)))
                          (if (> vid 1)
                            (progn
                              (setq dat (car (cdr (assoc -3 ent))))
                              (foreach rec dat
                                (if (= (type rec) 'LIST)
                                  (if (= (car rec) 1003)
                                    (progn
                                      (setq chk (cdr rec))
                                      (if (/= (tblsearch "LAYER" chk) nil)
                                        (progn
                                          (if (dstp_instr chk "|")
                                            (setq chk (strcase (cadr (dstp_pdf2lst chk "|"))))
                                          )
                                          (setq vptfrz (cons (list vid chk) vptfrz))
                                        )
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                          (setq itm (1+ itm))
                        )
                      )
                    )
                    (setq xrffrz nil)
                    (setq xrfdat nil)
                    (if (= frz T)
                      (progn
                        (setq lt (tblnext "LAYER" T))
                        (while (/= lt nil)
                          (setq ln (cdr (assoc 2 lt)))
                          (setq lc (cdr (assoc 62 lt)))
                          (setq ll (cdr (assoc 6 lt)))
                          (setq ls (cdr (assoc 70 lt)))
                          (setq lt (tblnext "LAYER"))
                          (setq del nil)
                          (if (= (boole 1 (- ls 64) 1) 1)
                            (setq del T)
                          )
                          (if (< lc 0)
                            (setq del T)
                          )
                          (if (dstp_instr ln "|")
                            (progn
                              (setq ln (strcase (cadr (dstp_pdf2lst ln "|"))))
                              (if (dstp_instr ll "|")
                                (setq ll (strcase (cadr (dstp_pdf2lst ll "|"))))
                                (setq ll (strcase ll))
                              )
                              (if (not (member ln xrfdat))
                                (setq xrfdat (cons (list ln lc ll) xrfdat))
                              )
                              (if (= del T)
                                (progn
                                  (if (not (member ln xrffrz))
                                    (setq xrffrz (cons ln xrffrz))
                                  )
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    ;
                    (command "_.LAYER")
                    (foreach rec xrfdat
                      (if (not (tblsearch "LAYER" (nth 0 rec)))
                        (progn
                          (command "_N" (nth 0 rec))
                          (command "_C" (nth 1 rec) (nth 0 rec))
                          (setq chk (tblsearch "LTYPE" (nth 2 rec)))
                          (if (= chk nil)
                            (command "_LT" "Continuous" (nth 0 rec))
                            (command "_LT" (nth 2 rec) (nth 0 rec))
                          )
                        )
                      )
                    )
                    (command "")
                    (command "_.MSPACE")
                    (setq attreq (getvar "ATTREQ"))
                    (setvar "ATTREQ" 0)
                    (dstp_ucspush)
                    (setq resp (dstp_bldlst "XREF"))
                    (setq xyd nil)
                    (foreach nam resp
                      (setq sset (ssget "X" (list (cons 0 "INSERT")(cons 2 nam))))
                      (setq num (sslength sset) itm 0)
                      (setq lst nil)
                      (while (< itm num)
                        (setq hnd (ssname sset itm))
                        (setq ent (entget hnd))
                        (setq rec (list (cdr (assoc 1 (tblsearch "BLOCK" nam)))))
                        (setq rec (append rec (list (cdr (assoc 10 ent)))))
                        (setq rec (append rec (list (cdr (assoc 41 ent)))))
                        (setq rec (append rec (list (cdr (assoc 42 ent)))))
                        (setq rec (append rec (list (cdr (assoc 50 ent)))))
                        (setq lst (append lst (list rec)))
                        (setq itm (1+ itm))
                      )
                      (command "_.XREF" "_D" nam)
                      (foreach rec lst
                        (command "_.INSERT" (strcat "*" (nth 0 rec)) (nth 1 rec) (nth 2 rec) (dstp_rtd (nth 4 rec)))
                        (if (/= (nth 2 rec)(nth 3 rec))
                          (setq xyd T)
                        )
                      )
                      (setq sset nil)
                    )
                    (if (= xyd T)
                      (alert "At least one insert had different XY scales,\nwhich was inserted exploded at the X scale factor.")
                    )
                    (dstp_ucspop)
                    (setvar "ATTREQ" attreq)
                    (command "_.PSPACE")
                    (princ "Done.")
                  )
                )
                (if (= frz T)
                  (progn
                    (dstp_prompt "DS> Deleting Frozen Layers ... ")
                    (if (/= xrffrz nil)
                      (progn
                        (command "_.MSPACE")
                        (foreach ln xrffrz
                          (setq sset (ssget "X" (list (cons 8 ln))))
                          (if (/= sset nil)
                            (command "_.ERASE" sset "")
                          )
                        )
                        (command "_.PSPACE")
                      )
                    )
                    (setq lt (tblnext "LAYER" T))
                    (while (/= lt nil)
                      (setq ln (cdr (assoc 2 lt)))
                      (setq lc (cdr (assoc 62 lt)))
                      (setq ls (cdr (assoc 70 lt)))
                      (setq lt (tblnext "LAYER"))
                      (setq del nil)
                      (if (= (boole 1 (- ls 64) 1) 1)
                        (setq del T)
                      )
                      (if (< lc 0)
                        (setq del T)
                      )
                      (if (= del T)
                        (progn
                          (setq sset (ssget "X" (list (cons 8 ln))))
                          (if (/= sset nil)
                            (progn
                              (setq lst (dstp_ss2lst sset))
                              (foreach hnd lst
                                (entdel hnd)
                              )
                            )
                          )
                        )
                      )
                    )
                    (setq sset nil)
                    (princ "Done.")
                  )
                )
                (command "_.LAYOUT" "_S" lay)
                (command "_.PSPACE")
                (foreach itm srclst
                  (if (/= itm lay)
                    (command "_.LAYOUT" "_D" itm)
                  )
                )
                (if (= eov T)
                  (progn
                    (dstp_prompt "DS> Erasing Outside Viewports ... ")
                    (setq ptlst nil)
                    (setq vset (ssget "_C" (getvar "LIMMIN")(getvar "LIMMAX") '((0 . "VIEWPORT"))))
                    (command "_.MSPACE")
                    (if (/= vset nil)
                      (progn
                        (setq num (sslength vset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname vset itm))
                          (setq ent (entget hnd))
                          (setq vid (cdr (assoc 69 ent)))
                          (setvar "CVPORT" vid)
                          (setq axo (vlax-ename->vla-object hnd))
                          (setq ctr (cdr (assoc 10 ent)))
                          (setq wid (vla-get-width axo))
                          (setq hgt (vla-get-height axo))
                          (setq ang (vla-get-twistangle axo))
                          (setq tmp (polar ctr 0 (/ wid 2.0)))
                          (setq urc (polar tmp (/ pi 2.0) (/ hgt 2.0)))
                          (setq ulc (polar urc pi wid))
                          (setq lrc (polar tmp (+ pi (/ pi 2.0)) (/ hgt 2.0)))
                          (setq llc (polar lrc pi wid))
                          (setq llc (trans (trans llc 3 2) 2 0))
                          (setq ulc (trans (trans ulc 3 2) 2 0))
                          (setq urc (trans (trans urc 3 2) 2 0))
                          (setq lrc (trans (trans lrc 3 2) 2 0))
                          (setq ptlst (cons (list vid llc urc) ptlst))
                          (setq itm (1+ itm))
                        )
                      )
                    )
                    (if (/= ptlst nil)
                      (progn
                        (command "_.MSPACE")
                        (dstp_ucspush)
                        (setq mset (ssget "X" '((67 . 0))))
                        (foreach rec ptlst
                          (setvar "CVPORT" (nth 0 rec))
                          (setq sset (ssget "_C" (nth 1 rec)(nth 2 rec)))
                          (if (/= sset nil)
                            (progn
                              (setq num (sslength sset) itm 0)
                              (while (< itm num)
                                (setq hnd (ssname sset itm))
                                (ssdel hnd mset)
                                (setq itm (1+ itm))
                              )
                            )
                          )
                        )
                        (command "_.ERASE" mset "")
                        (dstp_ucspop)
                        (command "_.PSPACE")
                      )
                    )
                    (command "_.PSPACE")
                    (princ "Done.")
                  )
                )
                (if (= prj T)
                  (progn
                    (dstp_prompt "DS> Projecting/Trimming Geometry ... ")
                    (setq ptlst nil)
                    (command "_.PSPACE")
                    (setq vset (ssget "_C" (getvar "LIMMIN")(getvar "LIMMAX") '((0 . "VIEWPORT"))))
                    (if (/= vset nil)
                      (progn
                        (command "_.MSPACE")
                        (setq sset (ssget "X" '((0 . "AECC_CONTOUR"))))
                        (if sset
                          (progn
                            (setq lst (dstp_ss2lst sset))
                            (foreach hnd lst
                              (command)
                              (command "_.EXPLODE" hnd)
                            )
                          )
                        )
                        (setq num (sslength vset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname vset itm))
                          (setq ent (entget hnd '("ACAD")))
                          (setq vid (cdr (assoc 69 ent)))
                          (setvar "CVPORT" vid)
                          (setq axo (vlax-ename->vla-object hnd))
                          (setq ctr (cdr (assoc 10 ent)))
                          (setq wid (vla-get-width axo))
                          (setq hgt (vla-get-height axo))
                          (setq ang (vla-get-twistangle axo))
                          (setq g340 (assoc 340 ent))
                          ;
                          ; --- build a sset of modelspace objects inside viewport
                          ;
                          (if (= g340 nil)
                            (progn
                              (setq tmp (polar ctr 0 (/ wid 2.0)))
                              (setq urc (polar tmp (/ pi 2.0) (/ hgt 2.0)))
                              (setq ulc (polar urc pi wid))
                              (setq lrc (polar tmp (+ pi (/ pi 2.0)) (/ hgt 2.0)))
                              (setq llc (polar lrc pi wid))
                              (setq llp llc lrp lrc urp urc ulp ulc)
                              (setq llc (trans (trans llc 3 2) 2 0))
                              (setq ulc (trans (trans ulc 3 2) 2 0))
                              (setq urc (trans (trans urc 3 2) 2 0))
                              (setq lrc (trans (trans lrc 3 2) 2 0))
                              (setq lst (list llc lrc urc ulc))
                              (setq sset (ssget "_CP" lst))
                            )
                            (progn
                              (setq bndhnd (cdr (assoc 340 ent)))
                              (setq bndpts (dstp_obj2lst bndhnd))
                              (setq tmp nil)
                              (foreach pnt bndpts
                                (setq new (trans (trans pnt 3 2) 2 0))
                                (setq tmp (cons new tmp))
                              )
                              (setq bndpts (reverse tmp) tmp nil)
                              (setq sset (ssget "_CP" bndpts))
                            )
                          )
                          ;
                          ; --- delete objects from sset frozen in viewport
                          ;
                          (setq nset (ssadd))
                          (setq lst (dstp_ss2lst sset))
                          (foreach hnd lst
                            (setq pass T)
                            (setq ent (entget hnd))
                            (setq lay (strcase (cdr (assoc 8 ent))))
                            (foreach chk vptfrz
                              (if (= (car chk) vid)
                                (if (= (strcase (cadr chk)) lay)
                                  (setq pass nil)
                                )
                              )
                            )
                            (if (= pass T)
                              (setq nset (ssadd hnd nset))
                            )
                          )
                          (setq sset nset)
                          (setq nset nil)
                          ;
                          (setq vpi (getvar "CVPORT"))
                          (setq vpl (ssget "X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
                          (setq hnd (ssname vpl 0))
                          (setq ent (entget hnd '("ACAD")))
                          (setq psrot (cdr (assoc 51 ent)))
                          (setq psctr (cdr (assoc 10 ent)))
                          (setq cvhgt (cdr (assoc 41 ent)))
                          (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
                          (setq cvscl (/ cvhgt cvsiz))
                          (setq msctr (trans (trans psctr 3 2) 2 0))
                          (dstp_ucspush)
                          (command "_.BLOCK" "DSTP_PURGEME" msctr sset "")
                          (dstp_ucspop)
                          (command "_.OOPS")
                          (command "_.PSPACE")
                          (dstp_ucspush)
                          (setq mrk (entlast))
                          (command "_.INSERT" "*DSTP_PURGEME" psctr cvscl (dstp_rtd psrot))
                          (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
                          (setq sset (ssadd))
                          (while (/= mrk nil)
                            (setq mrk (entnext mrk))
                            (if (/= mrk nil)
                              (progn
                                (setq ent (entget mrk))
                                (setq obj (cdr (assoc 0 ent)))
                                (if (not (member obj (list "VERTEX" "SEQEND")))
                                  (setq sset (ssadd mrk sset))
                                )
                              )
                            )
                          )
                          (dstp_ucspop)
                          (dstp_ucspush)
                          (setq rep 10)
                          (setq inc 0.01)
                          (setq ofs 0.0)
                          (setq g340 (assoc 340 ent))
                          (if (= g340 nil)
                            (progn
                              (repeat rep
                                (setq ofs (+ ofs inc))
                                (setq llt (polar llp (angle urp llp) ofs))
                                (setq lrt (polar lrp (angle ulp lrp) ofs))
                                (setq urt (polar urp (angle llp urp) ofs))
                                (setq ult (polar ulp (angle lrp ulp) ofs))
                                (command "_.TRIM" hnd "" "_F" llt lrt urt ult llt "" "")
                              )
                              (command "_.PLINE" llp lrp urp ulp "_C")
                            )
                            (progn
                              (setq bndhnd (cdr (assoc 340 ent)))
                              (setq bndpts (dstp_obj2lst bndhnd))
                              (setq refpnt (car bndpts))
                              (command "_.PLINE")
                              (foreach pnt bndpts
                                (command pnt)
                              )
                              (command "_C")
                              (command "_.REGION" "_L" "")
                              (setq reg (vlax-ename->vla-object (entlast)))
                              (setq cen (vlax-safearray->list (vlax-variant-value (vla-get-centroid reg))))
                              (entdel (entlast))
                              (repeat rep
                                (setq ofs (+ ofs inc))
                                (setq pik (polar refpnt (angle cen refpnt) ofs))
                                (command "_.OFFSET" ofs bndhnd pik "")
                                (setq ofspts (dstp_obj2lst (entlast)))
                                (entdel (entlast))
                                (command "_.TRIM" bndhnd "" "_F")
                                (foreach pnt ofspts
                                  (command pnt)
                                )
                                (command "" "")
                              )
                              (command "_.PLINE")
                              (foreach pnt bndpts
                                (command pnt)
                              )
                              (command "_C")
                            )
                          )
                          (dstp_ucspop)
                          (command "_.MSPACE")
                          (setq itm (1+ itm))
                        )
                        (command "_.MSPACE")
                        (dstp_ucspush)
                        (setq vpi (getvar "CVPORT"))
                        (setq vpl (ssget "X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
                        (setq hnd (ssname vpl 0))
                        (setq ent (entget hnd '("ACAD")))
                        (setq psrot (cdr (assoc 51 ent)))
                        (setq psctr (cdr (assoc 10 ent)))
                        (setq cvhgt (cdr (assoc 41 ent)))
                        (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
                        (setq cvscl (/ cvsiz cvhgt))
                        (setq msctr (trans (trans psctr 3 2) 2 0))
                        (dstp_ucspop)
                        (command "_.PSPACE")
                        (dstp_ucspush)
                        (command "_.BLOCK" "DSTP_PURGEME" psctr "_ALL" "")
                        (dstp_ucspop)
                        (command "TILEMODE" "1")
                        (command "_.ERASE" "_ALL" "")
                        (dstp_ucspush)
                        (command "_.INSERT" "*DSTP_PURGEME" msctr cvscl (- 0.0 (dstp_rtd psrot)))
                        (setq sset (ssget "X" '((0 . "VIEWPORT"))))
                        (command "_.ERASE" sset "")
                        (command "_.DIM" "_UPD" "_ALL" "" "_E")
                        (dstp_ucspop)
                        (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
                        (command "_.DVIEW" "" "_TW" (dstp_rtd psrot) "")
                        (command "_.ZOOM" "_E")
                        (setq sset nil)
                      )
                    )
                    (princ "Done.")
                  )
                )
                (if (= pur T)
                  (repeat 3
                    (command "_.PURGE" "_A" "*" "_N")
                  )
                )
                (if (/= vers "R12")
                  (command "_.SAVEAS" vers out)
                  (command "_.SAVEAS" "_DXF" "_V" "_R12" "16" out)
                )
                (command "_.UNDO" "_B")
              )
              (setq fh (open org "r"))
              (setq str "")
              (repeat 6
                (setq let (read-char fh))
                (setq str (strcat str (chr let)))
              )
              (close fh)
              (cond
                ((= str "AC1024")(setq vers "2010"))
                ((= str "AC1021")(setq vers "2007"))
                ((= str "AC1018")(setq vers "2004"))
                ((= str "AC1015")(setq vers "2000"))
                ((= str "AC1014")(setq vers "R14"))
                ((= str "AC1013")(setq vers "R14"))
                ((= str "AC1012")(setq vers "R13"))
                (t (setq vers nil))
              )
              (if (/= vers nil)
                (command "_.SAVEAS" vers org "_Y")
              )
              (setvar "CMDECHO" cmdecho)
              (setvar "OSMODE" osmode)
              (setvar "ANGBASE" angbase)
              (setvar "ANGDIR" angdir)
            )
          )
        )
        (alert "Save Current Drawing First!")
      )
    )
  )
  (princ)
)
)

; ###########################################################################
;                                 LAYRTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                         Layer Block Contents
; --------------------------------------------------------------------------

(defun c:LayBlkMul (/ $value add cmdecho dcl_id inspnt insres itm laylst
                         new retexi src sset tmp uct)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun layblock_lstcon (op / inc lat)
        (if (= op 0)
          (progn
            (set_tile "laytab" "")
            (laygedit_grpupd)
          )
          (progn
            (setq inc 0)
            (setq lat "")
            (repeat (length laylst)
              (setq lat (strcat lat (rtos inc 2 0) " "))
              (setq inc (1+ inc))
            )
            (set_tile "laytab" lat)
            (laygedit_grpupd)
          )
        )
      )
      (defun layblock_lstmat (/ inc ms chk)
        (setq inc 0)
        (setq ms (strcase (get_tile "selpat")))
        (repeat (length laylst)
          (setq chk (nth inc laylst))
          (if (= (wcmatch chk ms) T)
            (set_tile "laytab" (strcat (rtos inc 2 0) " "))
          )
          (setq inc (1+ inc))
        )
        (set_tile "selpat" "")
      )
      (setq laylst nil)
      (setq tmp (acad_strlsort (dstp_bldlst "LAYER")))
      (setq new nil)
      (foreach lay tmp
        (if (= (dstp_instr lay "|") nil)
          (setq new (append new (list lay)))
        )
      )
      (setq laylst (acad_strlsort new))
      (setq inspnt "0,0,0")
      (setq insres "0")
      (setq retexi "1")
      ;
      ; --- load and run dialog
      ;
      (setq dcl_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "layblock" dcl_id)) (exit))
      (start_list "laytab")
      (mapcar 'add_list laylst)
      (end_list)
      (set_tile "inspnt" inspnt)
      (set_tile "insres" insres)
      (set_tile "retexi" retexi)
      ;
      (action_tile "laytab" "(setq src $value)")
      (action_tile "inspnt" "(setq inspnt $value)")
      (action_tile "insres" "(setq insres $value)")
      (action_tile "retexi" "(setq retexi $value)")
      (action_tile "accept" "(done_dialog 1)")
      (action_tile "cancel" "(done_dialog 0)")
      (action_tile "help" "(dstp_showhelp \"LayBlkMul.htm\")")
      (action_tile "selpat" "(layblock_lstmat)")
      (action_tile "selall" "(layblock_lstcon 1)")
      (action_tile "clrall" "(layblock_lstcon 0)")
      ;
      (if (equal (start_dialog) 1)
        (progn
          (unload_dialog dcl_id)
          (setq uct 1)
          (setq new nil)
          (while (setq itm (read src))
            (setq add (nth itm laylst))
            (setq new (append new (list add)))
            (while (and (/= " " (substr src uct 1))
              (/= "" (substr src uct 1)))
              (setq uct (1+ uct))
            )
            (setq src (substr src uct))
          )
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (foreach lay new
            (princ (strcat "\nDS> Processing ... " lay))
            (setq sset (ssget "_X" (list (cons 8 lay))))
            (command "_.BLOCK" lay inspnt sset "")
            (if (= insres "1")
              (command "_.INSERT" lay inspnt "1.0" "1.0" "0.0")
            )
            (if (= retexi "1")
              (command "_.OOPS")
            )
            (princ " ... Done.")
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Isolate Select Set of Layers
; --------------------------------------------------------------------------

(defun c:LayTblIso (/ cmdecho done ent fnd hnd inf isolst itm layr laytab
                        lc ls mode num olderr pnt sset tmp vis xent xfil
                        xfnd xhnd xnam xtmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun layriso_error (s)
        (if (/= s "Function cancelled.")
          (progn
            (setvar "CMDECHO" cmdecho)
            (redraw)
            (setq *error* olderr)
          )
        )
        (if olderr (setq *error* olderr))
        (princ)
      )
      (setq olderr *error*)
      (setq *error* layriso_error)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (= dstp_isometh nil)  ; for standalond module, toolpac has dialog
        (progn
          (initget "F O")
          (setq tmp (getkword "\nDS> Isolate Method Freeze/<Off>: "))
          (if (= tmp "F")
            (setq dstp_isometh 1)
            (setq dstp_isometh 2)
          )
        )
      )
      (if (= dstp_layrlite nil)  ; for standalond module, toolpac has dialog
        (progn
          (initget "Y N")
          (setq tmp (getkword "\nDS> Highlight Selected Layers <Yes>/No: "))
          (if (= tmp "N")
            (setq dstp_layrlite 0)
            (setq dstp_layrlite 1)
          )
        )
      )
      (setq mode "A")
      (setq done nil)
      (setq isolst nil)
      (while (/= done T)
        (if (= mode "A")
          (progn
            (initget "R")
            (setq tmp (entsel "\nDS> <Pick Object on Layer to Add>/Remove: "))
            (if (= tmp "R")(setq mode "R"))
          )
          (progn
            (initget "A")
            (setq tmp (entsel "\nDS> <Pick Object on Layer to Remove>/Add: "))
            (if (= tmp "A")(setq mode "A"))
          )
        )
        (if (= tmp nil)
          (setq done T)
          (progn
            (if (/= (type tmp) 'str)
              (progn
                (setq pnt (cadr tmp))
                (setq ent (entget (car tmp)))
                (setq layr (cdr (assoc 8 ent)))
                ;
                (if (= (cdr (assoc 0 ent)) "INSERT")
                  (progn
                    (setq xnam (cdr (assoc 2 ent)))
                    (setq xfnd (tblsearch "BLOCK" xnam))
                    (setq xfil (cdr (assoc 1 xfnd)))
                    (if (/= xfil nil)
                      (progn
                        (setq xtmp (nentselp pnt))
                        (setq xhnd (car xtmp))
                        (setq xent (entget xhnd))
                        (setq layr (cdr (assoc 8 xent)))
                      )
                    )
                  )
                )
                (if (/= layr nil)
                  (progn
                    (setq layr (strcase layr))
                    (princ layr)
                    (if (= mode "A")
                      (progn
                        (if (= (member (strcase layr) isolst) nil)
                          (setq isolst (append isolst (list layr)))
                          (princ " (Already Selected)")
                        )
                      )
                      (progn
                        (if (/= (member layr isolst) nil)
                          (progn
                            (setq isolst (dstp_remove layr isolst))
                            (princ " (Removed)")
                          )
                          (princ " (Not Previously Selected)")
                        )
                      )
                    )
                    (if (= dstp_layrlite 1)
                      (progn
                        (setq sset (ssget "_X" (list (cons 8 layr))))
                        (if sset
                          (progn
                            (setq num (sslength sset) itm 0)
                            (while (< itm num)
                              (setq hnd (ssname sset itm))
                              (if (= mode "A")
                                (redraw hnd 3)
                                (redraw hnd 4)
                              )
                              (setq itm (1+ itm))
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      )
      (if (> (length isolst) 0)
        (progn
          (princ "\nDS> Isolating Layers ...")
          (setq dstp_hidlst nil)
          (setq laytab (acad_strlsort (dstp_bldlst "LAYER")))
          (foreach itm laytab
            (if (= (member (strcase itm) isolst) nil)
              (progn
                (setq vis T)
                (setq inf (tblsearch "LAYER" itm))
                (setq ls (cdr (assoc 70 inf)))
                (setq lc (cdr (assoc 62 inf)))
                (if (and (= dstp_isometh 1)(= (boole 1 (- ls 64) 1) 1)) ; freeze method
                  (setq vis nil)
                )
                (if (and (= dstp_isometh 2)(< lc 0)) ; off method
                  (setq vis nil)
                )
                (if (= vis T)
                  (setq dstp_hidlst (append dstp_hidlst (list itm)))
                )
              )
            )
          )
          (if (member (getvar "CLAYER") dstp_hidlst)
            (progn
              (setq fnd nil)
              (foreach layr isolst
                (if (not (dstp_instr layr "|"))
                  (progn
                    (setvar "CLAYER" layr)
                    (setq fnd T)
                  )
                )
              )
              (if (= fnd nil)
                (progn
                  (setq dstp_hidlst (dstp_remove "0" dstp_hidlst))
                  (setvar "CLAYER" "0")
                  (alert "Cannot Make XREF Layer Current\nExcluding Layer 0 from Isolation Group")
                )
              )
            ) 
          )
          (if (= dstp_layrlite 1)
            (foreach layr isolst
              (setq sset (ssget "_X" (list (cons 8 layr))))
              (if sset
                (progn
                  (setq num (sslength sset) itm 0)
                  (while (< itm num)
                    (setq hnd (ssname sset itm))
                    (redraw hnd 4)
                    (setq itm (1+ itm))
                  )
                )
              )
            )
          )
          (cond
            ((= dstp_isometh 1)
              (setvar "CLAYER" (car isolst))
              (princ " Freeze Method ...")
              (if (= (getvar "TILEMODE") 0)
                (command "_.VPLAYER")
                (command "_.LAYER")
              )
              (foreach layr dstp_hidlst
                (if (= (getvar "TILEMODE") 0)
                  (command "_F" layr "_C")
                  (command "_F" layr)
                )
              )
              (command "")
            )
            ((= dstp_isometh 2)
              (setvar "CLAYER" (car isolst))
              (princ " Off Method ...")
              (command "_.LAYER")
              (foreach layr dstp_hidlst
                (command "_OFF" layr)
              )
              (command "")
            )
            (t nil)
          )
          (princ " Done.")
        )
      )
      (setq isolst nil)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setq *error* olderr)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;             Restores Layers Isolated by ToolPac Layer Isolate
; --------------------------------------------------------------------------

(defun c:LayTblRes (/ cmdecho layr)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (> (length dstp_hidlst) 0)
        (progn
          (princ "\nDS> Restoring Layers ...")
          (cond
            ((= dstp_isometh 1)
              (princ " Thaw Method ...")
              (if (= (getvar "TILEMODE") 0)
                (command "_.VPLAYER")
                (command "_.LAYER")
              )
              (foreach layr dstp_hidlst
                (if (= (getvar "TILEMODE") 0)
                  (command "_T" layr "_C")
                  (command "_T" layr)
                )
              )
              (command "")
            )
            ((= dstp_isometh 2)
              (princ " On Method ...")
              (command "_.LAYER")
              (foreach layr dstp_hidlst
                (command "_ON" layr)
              )
              (command "")
            )
            (t nil)
          )
          (setq dstp_hidlst nil)
          (princ " Done.")
        )
        (alert "No Layers Isolated by:\nToolPac Layer Isolate")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                  Current Layer Next/Previous/First/Last
; --------------------------------------------------------------------------

(defun c:LayCurJog ( / chk clay cmdecho ctr done itm laytab lin opt ts)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq laytab (acad_strlsort (dstp_bldlst "LAYER")))
      (setq clay (getvar "CLAYER"))
      (setq ctr 0)
      (setq done nil)
      (while (= done nil)
        (setq chk (nth ctr laytab))
        (if (= (strcase chk) (strcase clay))
          (setq itm ctr done T)
        )
        (setq ctr (1+ ctr))
      )
      (initget "0 P N F L")
      (setq opt (getkword "\nDS> Option 0/Previous/Next/First/Last: "))
      (cond 
        ((= opt "0")
          (command "_.LAYER" "_T" "0" "_ON" "0" "_U" "0" "_S" "0" "")
        )
        ((= opt "F")
          (setq ctr 0)
          (setq done nil)
          (while (= done nil)
            (setq chk (nth ctr laytab))
            (setq lin (tblsearch "LAYER" chk))
            (setq ts (- (cdr (assoc 70 lin)) 64))
            (if (/= (boole 1 ts 1) 1)
              (progn
                (command "_.LAYER" "_S" chk "")
                (setq done T)
              )
            )
            (setq ctr (1+ ctr))
          )
        )
        ((= opt "L")
          (setq ctr (- (length laytab) 1))
          (setq done nil)
          (while (= done nil)
            (setq chk (nth ctr laytab))
            (setq lin (tblsearch "LAYER" chk))
            (setq ts (- (cdr (assoc 70 lin)) 64))
            (if (/= (boole 1 ts 1) 1)
              (progn
                (command "_.LAYER" "_S" chk "")
                (setq done T)
              )
            )
            (setq ctr (1- ctr))
          )
        )
        ((= opt "N")
          (setq ctr (1+ itm))
          (if (< ctr (length laytab))
            (progn
              (setq done nil)
              (while (= done nil)
                (setq chk (nth ctr laytab))
                (setq lin (tblsearch "LAYER" chk))
                (setq ts (- (cdr (assoc 70 lin)) 64))
                (if (/= (boole 1 ts 1) 1)
                  (progn
                    (command "_.LAYER" "_S" chk "")
                    (setq done T)
                  )
                )
                (setq ctr (1+ ctr))
                (if (= ctr (length laytab))
                  (setq done T)
                )
              )
            )
            (princ "\nDS> Current Layer is last layer.")
          )
        )
        ((= opt "P")
          (setq ctr (1- itm))
          (if (> ctr -1)
            (progn
              (setq done nil)
              (while (= done nil)
                (setq chk (nth ctr laytab))
                (setq lin (tblsearch "LAYER" chk))
                (setq ts (- (cdr (assoc 70 lin)) 64))
                (if (/= (boole 1 ts 1) 1)
                  (progn
                    (command "_.LAYER" "_S" chk "")
                    (setq done T)
                  )
                )
                (setq ctr (1- ctr))
                (if (= ctr 0)
                  (setq done T)
                )
              )
            )
            (princ "\nDS> Current Layer is first layer.")
          )
        )
        (t nil)
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;               Layer Review  (Repeat Clear Screen, Show Layer)
; --------------------------------------------------------------------------

(defun c:LayRevObj ( / *error* cmdecho ctr cur done hnd itm layrrevw_error
                       laytab nam num olderr resp sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun layrrevw_error (s)
        (if (/= s "Function cancelled.")
          (progn
            (setq sset (ssget "_X"))
            (layrrevw_prcset 1)
            (dstp_ucspop)
            (command "_.UNDO" "_E")
            (setvar "CMDECHO" cmdecho)
            (setq *error* olderr)
          )
        )
        (if olderr (setq *error* olderr))
        (princ)
      )
      (defun layrrevw_drwlay (nam)
        (princ (strcat "\nDS> Displaying Layer: [" nam "]"))
        (setq sset (ssget "_X" (list (cons 8 nam))))
        (if sset 
          (progn
            (setq ctr 0 num (sslength sset) itm 0)
            (while (< itm num)
              (setq hnd (ssname sset itm))
              (redraw hnd)
              (setq itm (1+ itm))
            )
          )
        )
      )
      (defun layrrevw_prcset (opt)
        (if sset 
          (progn
            (setq ctr 0 num (sslength sset) itm 0)
            (while (< itm num)
              (setq hnd (ssname sset itm))
              (redraw hnd opt)
              (setq itm (1+ itm))
            )
          )
        )
      )
      (setq olderr *error*)
      (setq *error* layrrevw_error)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq cur 0)
      (setq done nil)
      (setq laytab (acad_strlsort (dstp_bldlst "LAYER")))
      (setq sset (ssget "_X"))
      (layrrevw_prcset 2)
      (setq nam (nth 0 laytab))
      (layrrevw_drwlay nam)
      (while (/= done T)
        (setq tmp (strcase (getstring "\nDS> Option: Go/All/First/Last/Next/Previous/Select/eXit <Next>: ")))
        (cond 
          ((= tmp "A")
            (setq resp nil)
            (layrrevw_prcset 2)
            (foreach nam laytab
              (layrrevw_drwlay nam)
            )
            (setq sset (ssget "_X"))
            (layrrevw_prcset 2)
            (setq nam (nth cur laytab))
            (layrrevw_drwlay nam)
          )
          ((= tmp "G")
            (princ "\n")
            (if (= resp nil)
              (progn
                (command "_.LAYER")
                (command "_ON" nam)
                (command "_T" nam)
                (command "_S" nam)
                (command "_F" (strcat "~" nam))
                (command "")
              )
              (progn
                (setq nam (nth 0 resp))
                (command "_.LAYER")
                (command "_ON" nam)
                (command "_T" nam)
                (command "_S" nam)
                (command "_F" (strcat "~" nam))
                (foreach nam resp
                  (command "_T" nam)
                  (command "_ON" nam)
                )
                (command "")
              )
            )
            (setq done T)
          )
          ((= tmp "F")
            (setq resp nil)
            (setq cur 0)
            (setq nam (nth cur laytab))
            (layrrevw_prcset 2)
            (layrrevw_drwlay nam)
          )
          ((= tmp "L")
            (setq resp nil)
            (setq cur (- (length laytab) 1))
            (setq nam (nth cur laytab))
            (layrrevw_prcset 2)
            (layrrevw_drwlay nam)
          )
          ((or (= tmp "")(= tmp "N"))
            (if (>= (1+ cur) (length laytab))
              (progn
                (setq resp nil)
                (setq cur 0)
                (setq nam (nth cur laytab))
                (layrrevw_prcset 2)
                (layrrevw_drwlay nam)
              )
              (progn
                (setq resp nil)
                (setq cur (1+ cur))
                (setq nam (nth cur laytab))
                (layrrevw_prcset 2)
                (layrrevw_drwlay nam)
              )
            )
          )
          ((= tmp "P")
            (if (< (1- cur) 0)
              (progn
                (setq resp nil)
                (setq cur (- (length laytab) 1))
                (setq nam (nth cur laytab))
                (layrrevw_prcset 2)
                (layrrevw_drwlay nam)
              )
              (progn
                (setq resp nil)
                (setq cur (1- cur))
                (setq nam (nth cur laytab))
                (layrrevw_prcset 2)
                (layrrevw_drwlay nam)
              )
            )
          )
          ((= tmp "S")
            (setq resp (dstp_tablesel "Select Layer(s)" (acad_strlsort (dstp_bldlst "LAYER")) "m" ""))
            (if (/= resp nil)
              (progn
                (layrrevw_prcset 2)
                (foreach nam resp
                  (layrrevw_drwlay nam)
                )
              )
            )
          )
          ((= tmp "X")
            (setq sset (ssget "_X"))
            (layrrevw_prcset 1)
            (setq done T)
          )
          (t nil)
        )
      )
      (redraw)
      (setq laytab nil)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setq *error* olderr)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Blink entities in designated Layer
; --------------------------------------------------------------------------

(defun c:LayBlkObj (/ cnt hnd itm num rate rept sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (= rept nil)(setq rept 10))
      (setq tmp (getint (strcat "\nDS> Blink Repeat Count <" (itoa rept) ">: ")))
      (if (/= tmp nil)(setq rept tmp))
      (if (= rate nil)(setq rate 500))
      (setq tmp (getint (strcat "\nDS> Delay Time in Milliseconds <" (itoa rate) ">: ")))
      (if (/= tmp nil)(setq rate tmp))
      (initget "D")
      (setq tmp (entsel "\nDS> Dialog/<Pick Object with Desired Layer>: "))
      (if (= tmp "D")
        (setq resp (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
        (setq resp (cdr (assoc 8 (entget (car tmp)))))
      )
      (if (/= resp nil)
        (progn
          (setq sset (ssget "_X" (list (cons 8 resp))))
          (if sset
            (progn
              (setq num (sslength sset))
              (princ (strcat "\nDS> Selected Layer " resp ", " (itoa num) " Items Found.\n"))
              (setq cnt 0)
              (princ "\nDS> ")
              (repeat rept
                (setq cnt (+ cnt 1))
                (princ (strcat "\rDS> Repeat Count " (itoa cnt) " of " (itoa rept)))
                (setq itm 0)
                (while (< itm num)
                  (setq hnd (ssname sset itm))
                  (redraw hnd 3)
                  (setq itm (1+ itm))
                )
                (command "_.DELAY" (itoa rate))
                (setq itm 0)
                (while (< itm num)
                  (setq hnd (ssname sset itm))
                  (redraw hnd 4)
                  (setq itm (1+ itm))
                )
                (command "_.DELAY" (itoa rate))
              )
              (princ ", Done.")
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ###########################################################################
;                                 MISCTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                     Export Linetype Info to File
; --------------------------------------------------------------------------

(defun c:GenLtpExp (/ bug chk dat done ent fh fil fn fnd g49 g74 hnd lst
                         nam pass resp rvl sfh sfi sfn shp shx str sty svl
                         tmp xvl yvl)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq lst nil)
      (setq tmp (dstp_bldlst "LTYPE"))
      (foreach ltp tmp
        (setq pass T)
        (if (= ltp "CONTINUOUS")
          (setq pass nil)
        )
        (if (= pass T)
          (setq lst (cons ltp lst))
        )
      )
      (setq tmp nil)
      (if (/= lst nil)
        (progn
          (setq resp (dstp_tablesel "Export Linetype(s)" lst "m" "T"))
          (if (/= resp nil)
            (progn
              (setq fn (dstp_getfiles "Linetype File to Create" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "lin" 1))
              (if (/= fn nil)
                (progn
                  (setq bug nil)
                  (setq fh (open fn "w"))
                  (dstp_prompt "DS> Creating Linetype File ... ")
                  (princ "; Linetype Definition File\n" fh)
                  (princ "; Created by DotSoft's ToolPac\n" fh)
                  (princ "; Website http://www.dotsoft.com\n" fh)
                  (princ ";\n" fh)
                  (foreach ltp resp
                    (setq dat (entget (tblobjname "LTYPE" ltp)))
                    (setq str (cdr (assoc 3 dat)))
                    (princ (strcat "*" ltp "," str "\n") fh)
                    (princ "A" fh)
                    (foreach rec dat
                      (if (= (car rec) 49)
                        (setq g49 (cdr rec))
                      )
                      (if (= (car rec) 74)
                        (progn
                          (setq g74 (cdr rec))
                          (cond
                            ((= g74 0)
                              (princ (strcat "," (rtos g49 2 3)) fh)
                            )
                            ((= g74 2) ; text string
                              (setq str (cdr (assoc 9 dat)))
                              (setq hnd (cdr (assoc 340 dat)))
                              (setq ent (entget hnd))
                              (setq sty (strcase (cdr (assoc 2 ent))))
                              (setq svl (rtos (cdr (assoc 46 dat)) 2 3))
                              (setq rvl (rtos (cdr (assoc 50 dat)) 2 3))
                              (setq xvl (rtos (cdr (assoc 44 dat)) 2 3))
                              (setq yvl (rtos (cdr (assoc 45 dat)) 2 3))
                              (princ (strcat "," (rtos g49 2 3) ",[" (chr 34) str (chr 34) "," sty ",S=" svl ",R=" rvl ",X=" xvl ",Y=" yvl "]") fh)
                            )
                            ((= g74 4) ; shape
                              (setq sfi (cdr (assoc 75 dat)))
                              (setq hnd (cdr (assoc 340 dat)))
                              (setq ent (entget hnd))
                              (setq shx (strcase (cdr (assoc 3 ent)) T))
                              (setq shp (dstp_subtext shx "shx" "shp"))
                              (setq fil (findfile shp))
                              (if (/= fil nil)
                                (progn                                                         ; SHP Found
                                  (setq fnd nil)
                                  (setq done nil)
                                  (setq sfh (open fil "r"))
                                  (while (/= done T)
                                    (setq chk (read-line sfh))
                                    (if (= chk nil)
                                      (setq done T)
                                      (if (= (substr chk 1 1) "*")
                                        (progn
                                          (setq chk (substr chk 2 (- (strlen chk) 1)))
                                          (setq lst (dstp_pdf2lst chk ","))
                                          (if (= (atoi (car lst)) sfi)
                                            (setq nam (last lst) fnd T done T)
                                          )
                                        )
                                      )
                                    )
                                  )
                                  (close sfh)
                                  (if (= fnd T)
                                    (progn
                                      (if (dstp_instr shx (chr 92))
                                        (setq sfn (last (dstp_pdf2lst shx (chr 92))))
                                        (setq sfn tmp)
                                      )
                                      (setq xvl (rtos (cdr (assoc 44 dat)) 2 3))
                                      (setq svl (rtos (cdr (assoc 46 dat)) 2 3))
                                      (princ (strcat "," (rtos g49 2 3) ",[" nam "," shx ",X=" xvl ",S=" svl "]") fh)
                                    )
                                  )
                                )
                                (progn                                                         ; SHP Absent
                                  (setq fil (findfile shx))
                                  (if (/= fil nil)
                                    (progn
                                      (setq nam (itoa (cdr (assoc 75 dat))))
                                      (setq xvl (rtos (cdr (assoc 44 dat)) 2 3))
                                      (setq svl (rtos (cdr (assoc 46 dat)) 2 3))
                                      (princ (strcat "," (rtos g49 2 3) ",[" nam "," shx ",X=" xvl ",S=" svl "]") fh)
                                    )
                                  )
                                )
                              )
                            )
                            (t nil)
                          )
                        )
                      )
                    )
                    (princ "\n" fh)
                  )
                  (close fh)
                  (princ "Done.")
                )
              )
            )
          )
        )
        (princ "\nDS> No non-continuous linetypes found in drawing!")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Various Set Current Routines
; --------------------------------------------------------------------------

(defun c:GenSetCur (/ ang cmdecho col colr ent hgt hnd ltplst p1 p2
                         pt1 pt2 rad resp tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "LA LT CO EL FR SA SP ST TH TM TS")
      (setq opt (getkword "\nDS> COlor/ELevation/LAyer/LineType/SnapAng/SPace/STyle/TextSize/TileMode/THickness: "))
      (if (/= opt nil)
        (progn
          (setq opt (strcase opt T))
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (cond
            ;
            ; --- Current Layer
            ;
            ((= opt "la")
              (initget "D")
              (setq tmp (entsel "\nDS> Dialog/<Pick Object with Desired Layer>: "))
              (if (= tmp "D")
                (setq resp (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
                (setq resp (cdr (assoc 8 (entget (car tmp)))))
              )
              (if (/= resp nil)
                (progn
                  (command "_.LAYER" "_ON" resp "_THAW" resp "_UNL" resp "_SET" resp "")
                  (princ (strcat "\nDS> Current Layer ... " resp))
                )
              )
            )
            ;
            ; --- Current Linetype
            ;
            ((= opt "lt")
              (initget "D B")
              (setq tmp (entsel "\nDS> Bylayer/Dialog/<Pick Object with Desired Linetype>: "))
              (cond
                ((= tmp "B")
                  (setq resp "BYLAYER")
                )
                ((= tmp "D")
                  (setq ltplst (dstp_bldlst "LTYPE"))
                  (setq ltplst (append (list "BYLAYER") ltplst))
                  (setq ltplst (append (list "BYBLOCK") ltplst))
                  (setq resp (dstp_tablesel "Select Desired Linetype" ltplst "s" ""))
                  (setq ltplst nil)
                )
                (t
                  (setq resp (cdr (assoc 6 (entget (car tmp)))))
                )
              )
              (if (/= resp nil)
                (progn
                  (command "_.LINETYPE" "_S" resp "")
                  (princ (strcat "\nDS> Current Linetype ... " resp))
                )
              )
            )
            ;
            ; --- Current Color
            ;
            ((= opt "co")
              (initget "D B")
              (setq tmp (entsel "\nDS> Bylayer/Dialog/<Pick Object with Desired Color>: "))
              (cond
                ((= tmp "B")
                  (setq colr "BYLAYER")
                )
                ((= tmp "D")
                  (setq colr (getvar "CECOLOR"))
                  (setq col (dstp_str2col colr))
                  (setq col (acad_colordlg col))
                  (setq colr (dstp_col2str col))
                )
                (t
                  (setq colr (cdr (assoc 62 (entget (car tmp)))))
                  (if (/= colr nil)(setq colr (itoa colr)))
                )
              )
              (if (/= colr nil)
                (progn
                  (setvar "CECOLOR" colr)
                  (princ (strcat "\nDS> Current Color ... " colr))
                )
              )
            )
            ;
            ; --- Current Elevation
            ;
            ((= opt "el")
              (setq tmp (strcase (getstring (strcat "\nDS> Object/Elevation <" (rtos (getvar "ELEVATION")) ">: "))))
              (cond
                ((= tmp "O")
                  (setq tmp (entsel "\nDS> Pick Object with Desired Elevation: "))
                  (setvar "ELEVATION" (dstp_getelev (car tmp)))
                )
                ((= tmp "")
                  (setq tmp nil)
                )
                (t
                  (setvar "ELEVATION" (atof tmp))
                )
              )
              (princ (strcat "\nDS> Current Elevation ... " (rtos (getvar "ELEVATION") 2 2)))
            )
            ;
            ; --- Current Fillet Radius
            ;
            ((= opt "fr")
              (setq hnd (car (entsel "\nDS> Pick Arc/Circle with Desired Fillet Radius: ")))
              (if (/= hnd nil)
                (progn
                  (setq ent (entget hnd))
                  (setq rad (cdr (assoc 40 ent)))
                  (if (/= rad nil)
                    (progn
                      (command "_.FILLETRAD" rad)
                      (princ (strcat "\nDS> Fillet Radius set to " (rtos rad)))
                    )
                  )
                )
              )
            )
            ;
            ; --- Current Snap Angle
            ;
            ((= opt "sa")
              (initget "Z V P")
              (setq tmp (entsel "\nDS> Zero/Points/Value/<Select Alignment Object or Edge>: "))
              (if (/= tmp nil)
                (if (= (type tmp) 'str)
                  (progn
                    (if (= tmp "Z")
                      (setvar "SNAPANG" 0)
                    )
                    (if (= tmp "V")
                      (progn
                        (setq ang (getreal "\nDS> Enter new SNAPANG value: "))
                        (command "_.SNAPANG" ang)
                      )
                    )
                    (if (= tmp "P")
                      (progn
                        (setq pt1 (getpoint "\nDS> Pick 1st Point: "))
                        (setq pt2 (getpoint pt1 "\nDS> Pick 2nd Point: "))
                        (setq ang (dstp_rtd (angle pt1 pt2)))
                        (command "_.SNAPANG" ang)
                      )
                    )
                  )
                  (progn
                    (setq p1 (osnap (cadr tmp) "_end"))
                    (setq p2 (osnap (cadr tmp) "_mid"))
                    (setq ang (angle p1 p2))
                    (setvar "SNAPANG" ang)
                  )
                )
              )
            )
            ;
            ; --- Current Model/Paper Space
            ;
            ((= opt "sp")
              (if (= (getvar "TILEMODE") 0)
                (if (= (getvar "CVPORT") 1)
                  (progn
                    (command "_.MSPACE")
                    (princ "\nDS> Switching to Model Space")
                  )
                  (progn
                    (command "_.PSPACE")
                    (princ "\nDS> Switching to Paper Space")
                  )
                )
                (princ "\nDS> Set TILEMODE Variable to 0 to enable Paper Space")
              )
            )
            ;
            ; --- Current Text Style
            ;
            ((= opt "st")
              (initget "D")
              (setq tmp (entsel "\nDS> Dialog/<Pick Object with Desired Style>: "))
              (if (= tmp "D")
                (setq resp (dstp_tablesel "Select Desired Style" (acad_strlsort (dstp_bldlst "STYLE")) "s" ""))
                (setq resp (cdr (assoc 7 (entget (car tmp)))))
              )
              ;
              (if (/= resp nil)
                (progn
                  (setvar "TEXTSTYLE" resp)
                  (princ (strcat "\nDS> Current Style ... " resp))
                )
              )
            )
            ;
            ; --- Current Thickness
            ;
            ((= opt "th")
              (setq resp (getreal (strcat "\nDS> Current Thickness <" (rtos (getvar "THICKNESS")) ">: ")))
              (if (/= resp nil)
                (setvar "THICKNESS" resp)
              )
              (princ (strcat "\nDS> Current Thickness ... " (rtos (getvar "THICKNESS") 2 2)))
            )
            ;
            ; --- Current Tilemode Status
            ;
            ((= opt "tm")
              (if (= (getvar "TILEMODE") 0)
                (setvar "TILEMODE" 1)
                (setvar "TILEMODE" 0)
              )
            )
            ;
            ; --- Current Text Height
            ;
            ((= opt "ts")
              (setq tmp (entsel "\nDS> Pick Text Object with Desired Height: "))
              (if (/= tmp nil)
                (progn
                  (setq hgt (cdr (assoc 40 (entget (car tmp)))))
                  (setvar "TEXTSIZE" hgt)
                  (princ (strcat "\nDS> Current Text Height ... " (rtos hgt)))
                )
              )
            )
            (t nil)
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Set Current Parms By Picking
; --------------------------------------------------------------------------

(defun c:GenSetObj (/ cmdecho col elv ent hnd lay ltp thk)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq hnd (car (entsel "\nDS> Pick Object With Desired Properties ... ")))
      (if (/= hnd nil)
        (progn
          (setq ent (entget hnd))
          (setq lay (cdr (assoc 8 ent)))
          (setq col (cdr (assoc 62 ent)))
          (setq ltp (cdr (assoc 6 ent)))
          (setq elv (dstp_getelev hnd))
          (setq thk (cdr (assoc 39 ent)))
          (if (/= lay nil)(command "_.SETVAR" "CLAYER" lay))
          (if (/= col nil)
            (command "_.SETVAR" "CECOLOR" col)
            (command "_.SETVAR" "CECOLOR" "BYLAYER")
          ) 
          (if (/= ltp nil)
            (command "_.SETVAR" "CELTYPE" ltp)
            (command "_.SETVAR" "CELTYPE" "BYLAYER")
          )
          (if (/= elv nil)(command "_.SETVAR" "ELEVATION" elv))
          (if (/= thk nil)(command "_.SETVAR" "THICKNESS" thk))
        )
      )
      (princ "\nDS> Current Layer ....... ")
      (princ (getvar "CLAYER"))
      (princ "\nDS> Current Color ....... ")
      (princ (getvar "CECOLOR"))
      (princ "\nDS> Current Linetype .... ")
      (princ (getvar "CELTYPE"))
      (princ "\nDS> Current Elevation ... ")
      (princ (getvar "ELEVATION"))
      (princ "\nDS> Current Thickness ... ")
      (princ (getvar "THICKNESS"))
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; ###########################################################################
;                                 OBJTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                Copy items inplace from one layer to another
; --------------------------------------------------------------------------

(defun c:ObjCpyLay (/ pt sset layr chk clayer cmdecho tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (if (/= sset nil)
        (progn
          (setq pt (list 0.0 0.0))
          (initget "D E")
          (setq tmp (entsel "\nDS> Enter/Dialog/<Pick Object with Desired Layer>: "))
          (cond
            ((= tmp "D")
              (setq layr (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
            )
            ((= tmp "E")
              (setq chk (getstring "\nDS> Enter Layer Name: " T))
              (if (snvalid chk)
                (setq layr chk)
                (progn
                  (setq layr "0")
                  (princ "\nDS> Bad layer name, using layer 0!")
                )
              )
            )
            (t
              (setq layr (cdr (assoc 8 (entget (car tmp)))))
            )
          )
          (if (/= layr "")
            (progn
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (setq clayer (getvar "CLAYER"))
              (if (= (tblsearch "LAYER" layr) nil)
                (command "_.LAYER" "_M" layr "")
              )
              (command "_.COPY" "_P" "" pt pt)
              (command "_.CHPROP" "_P" "" "_LA" layr "")
              (setvar "CLAYER" clayer)
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects copied."))
              (setq sset nil)
            )
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Multiple Copy w/Rotation Option
; --------------------------------------------------------------------------

(defun c:ObjCpyRot (/ bpt cmdecho done mrk rot sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (if (/= sset nil)
        (progn
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (setq bpt (getpoint "\nDS> Original Base Point: "))
          (setq done nil)
          (while (= done nil)
            (princ "\nDS> *** Press ESC to cancel operation ***")
            (princ "\nDS> Copy Placement Point: ")
            (setq mrk (entlast))
            (command "_.COPY" sset "" bpt pause)
            (setq rot (ssadd))
            (while (/= mrk nil)
              (setq mrk (entnext mrk))
              (if (/= mrk nil)
                (progn
                  (setq ent (entget mrk))
                  (setq obj (cdr (assoc 0 ent)))
                  (if (and (/= obj "ATTRIB")(/= obj "SEQEND"))
                    (setq rot (ssadd mrk rot))
                  )
                )
              )
            )
            (princ "\nDS> Copy Rotation Angle: ")
            (command "_.ROTATE" rot "" (getvar "lastpoint") pause)
          )
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                        Divide & Measure Multiple
; --------------------------------------------------------------------------

(defun c:ObjDivMul () (dstp_objdivmea 1))
(defun c:ObjMeaMul () (dstp_objdivmea 2))

(defun dstp_objdivmea (opt / ali blk chk cmdecho hnd itm num seg sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "LINE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "SPLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (cond
            ((= opt 1)(setq seg (getint "\nDS> Number of Segments: ")))
            ((= opt 2)(setq seg (getreal "\nDS> Segment Length: ")))
            (t nil)
          )
          (initget "Y N")
          (setq chk (getkword "\nDS> Use a block Y/<N>: "))
          (if (= chk "Y")
            (progn
              (setq blk (dstp_tablesel "Select Block Definition" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
              (if (/= blk nil)
                (progn
                  (initget "Y N")
                  (setq chk (getkword "\nDS> Align with object <Y>/N: "))
                  (if (/= chk "N")(setq ali "Y")(setq ali "N"))
                )
              )
            )
            (setq blk nil)
          )
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (cond
              ((= opt 1)
                (if (= blk nil)
                  (command "_.DIVIDE" hnd seg)
                  (command "_.DIVIDE" hnd "_B" blk ali seg)
                )
              )
              ((= opt 2)
                (if (= blk nil)
                  (command "_.MEASURE" hnd seg)
                  (command "_.MEASURE" hnd "_B" blk ali seg)
                )
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          Boundary Offset
; --------------------------------------------------------------------------

(defun c:ObjBndOfs ( / bnd cmdecho dis miss pnt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq dis (getdist "\nDS> Offset Distance: "))
      (if (/= dis nil)
        (progn
          (setq miss nil)
          (while (/= miss T)
            (setq pnt (getpoint "\nDS> Point Inside Boundary: "))
            (if (/= pnt nil)
              (progn
                ;(setq bnd (bpoly pnt))
                (command "_-BOUNDARY" pnt "")
                (setq bnd (entlast))
                (if (/= bnd nil)
                  (progn
                    (command "_.OFFSET" dis bnd pnt "")
                    (entdel bnd)
                  )
                )
              )
              (setq miss T)
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Draw Multiple Offsets of Objects
; --------------------------------------------------------------------------

(defun c:ObjOfsMul (/ osmode cmdecho dir dis done obj qty tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      ;
      (setq done nil)
      (if (= dstp_offsetdist nil)(setq dstp_offsetdist (dstp_textsize)))
      (setq tmp (getdist (strcat "\nDS> Offset Distance <" (rtos dstp_offsetdist) ">: ")))
      (if (/= tmp nil)(setq dstp_offsetdist tmp))
      (setq dis dstp_offsetdist)
      (while (/= done T)
        (setq obj (entsel "\nDS> Select Object to Offset: "))
        (if (/= obj nil)
          (progn
            (setq dir (getpoint "\nDS> Side To Offset: "))
            (setq qty (getint "\nDS> Number of Offsets: "))
            (setq tmp dis)
            (repeat qty
              (command "_.OFFSET" tmp obj dir "")
              (setq tmp (+ tmp dis))
            )
          )
          (setq done T)
        )
      )
      ;
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setvar "OSMODE" osmode)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Repeated Offset to Target Layer
; --------------------------------------------------------------------------

(defun c:ObjOfsLay (/ cmdecho dir dis done lay lst obj tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq lay nil)
      (initget "C D")
      (setq tmp (nentsel "\nDS> Current/Dialog/<Pick Object with Target Layer>: "))
      (cond
        ((= tmp "C")
          (setq lay (getvar "CLAYER"))
        )
        ((= tmp "D")
          (setq lst nil)
          (setq tmp (dstp_bldlst "LAYER"))
          (foreach lay tmp
            (if (= (dstp_instr lay "|") nil)
              (setq lst (append lst (list lay)))
            )
          )
          (setq lst (acad_strlsort lst))
          (setq lay (dstp_tablesel "Select Desired Layer" lst "s" ""))
        )
        (t
          (setq tmp (cdr (assoc 8 (entget (car tmp)))))
          (if (= (dstp_instr tmp "|") T)
            (princ "\nDS> XREF Layers cannot be used!")
            (setq lay tmp)
          )
        )
      )
      (if (/= lay nil)
        (progn
          (setq done nil)
          (if (= dstp_offsetdist nil)(setq dstp_offsetdist (dstp_textsize)))
          (setq tmp (getdist (strcat "\nDS> Offset Distance <" (rtos dstp_offsetdist) ">: ")))
          (if (/= tmp nil)(setq dstp_offsetdist tmp))
          (setq dis dstp_offsetdist)
          (while (/= done T)
            (setq obj (entsel "\nDS> Select Object to Offset: "))
            (if (/= obj nil)
              (progn
                (setq dir (getpoint "\nDS> Side To Offset: "))
                (command "_.OFFSET" dis obj dir "")
                (command "_.CHPROP" "_L" "" "_LA" lay "")
              )
              (setq done T)
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Offset ellipse to mathmatical ellipse
; --------------------------------------------------------------------------

(defun c:ObjOfsEll (/ cmdecho cpnt dis eang edif ent epnt hnd itm mlen num sang sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget '((0 . "ELLIPSE"))))
      (if sset
        (progn
          (princ "\nDS> Notice: Offsets created with this tool are not TRUE offsets.")
          (setq dis (getdist "\nPsuedo Offset Distance (negative for inside): "))
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq cpnt (cdr (assoc 10 ent)))
            (setq edif (cdr (assoc 11 ent)))
            (setq epnt (list (+ (car cpnt) (car edif)) (+ (cadr cpnt) (cadr edif))))
            (setq mlen (* (cdr (assoc 40 ent)) (distance cpnt epnt)))
            (setq epnt (polar epnt (angle cpnt epnt) dis))
            (setq mlen (+ mlen dis))
            (setq sang (cdr (assoc 41 ent)))
            (setq eang (cdr (assoc 42 ent)))
            (if (and (= sang 0.0)(= eang (* pi 2.0)))
              (command "_.ELLIPSE" "_C" cpnt epnt mlen)
            )
            (setq itm (1+ itm))
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Set elevation of selection set
; --------------------------------------------------------------------------

;
; --- set elevation absolute
;
(defun c:ObjElvAbs (/ chk cmdecho done elv hnd itm num sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if sset
        (progn
          (setq hnd (ssname sset 0))
          (setq chk (dstp_getelev hnd))
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq elv (dstp_getelev hnd))
            (if (not (equal elv chk 0.0001))
              (setq chk nil)
            )
            (setq itm (1+ itm))
          )
          (princ "\nDS> Previous Elevation <")
          (if (= chk nil)
            (princ "Varies")
            (princ (rtos chk 2 3))
          )
          (princ ">")
          (if (= dstp_elevmode nil)(setq dstp_elevmode "E"))
          (setq newelv (getvar "ELEVATION"))
          (setq done nil)
          (while (/= done T)
            (if (= dstp_elevmode "E")
              (progn
                (initget "P")
                (setq chk (getreal (strcat "\nDS> Pick/Enter New Elevation <" (rtos newelv 2 3) ">: ")))
                (if (= chk "P")
                  (setq dstp_elevmode "P")
                  (if (/= chk nil)
                    (progn
                      (setq newelv chk)
                      (setq done T)
                    )
                    (setq done T)
                  )
                )
              )
            )
            (if (= dstp_elevmode "P")
              (progn
                (initget "E")
                (setq chk (getpoint "\nDS> Enter/Pick Point for Elevation: "))
                (if (= chk "E")
                  (setq dstp_elevmode "E")
                  (progn
                    (if (= (length chk) 3)
                      (setq newelv (nth 2 chk))
                      (setq newelv 0.0)
                    )
                    (if (/= chk nil)
                      (setq done T)
                    )
                  )
                )
              )
            )
          )
          (princ (strcat "\nDS> Assigning Elevation: " (rtos newelv 2 3)))
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (dstp_setelv hnd newelv)
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (command "_.SELECT" sset "")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- set elevation relative
;
(defun c:ObjElvRel (/ chk cmdecho dif elv hnd itm num sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if sset
        (progn
          (setq hnd (ssname sset 0))
          (setq chk (dstp_getelev hnd))
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq elv (dstp_getelev hnd))
            (if (not (equal elv chk 0.00001))
              (setq chk nil)
            )
            (setq itm (1+ itm))
          )
          (princ "\nDS> Previous Elevation <")
          (if (= chk nil)
            (princ "Varies")
            (princ (rtos chk 2 3))
          )
          (princ ">")
          (setq dif (getreal (strcat "\nDS> Elevation Difference <0.00>: ")))
          (if (/= dif nil)
            (progn
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (ssname sset itm))
                (command "_.MOVE" hnd "" "0,0,0" (strcat "@0,0," (rtos dif 2 8)))
                (setq itm (1+ itm))
              )
              (princ ", Done.")
            )
          )
        )
      )
      (command "_.SELECT" sset "")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- copy elevation
;
(defun c:ObjElvCpy (/ cmdecho ent hnd itm nelv num sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (setq tmp (entsel "\nDS> Select Object with Elevation to Copy: "))
          (if (/= tmp nil)
            (progn
              (setq hnd (car tmp))
              (setq nelv (dstp_getelev hnd))
              (if (/= nelv nil)
                (progn
                  (princ (strcat "\nDS> Assigning Elevation: " (rtos nelv 2 3)))
                  (princ "\nDS>")
                  (while (< itm num)
                    (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                    (setq hnd (ssname sset itm))
                    (dstp_setelv hnd nelv)
                    (setq itm (1+ itm))
                  )
                  (princ ", Done.")
                )
              )
            )
          )
        )
      )
      (command "_.SELECT" sset "")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- block insert elevation to attribute value
;
(defun c:ObjElvAtt (/ attent atthnd atttag attval blkchg blkent blkhnd
                         cmdecho itm num sset tlst val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Blocks to Process ...")
      (setq sset (ssget '((0 . "INSERT") (66 . 1))))
      (if sset 
        (progn
          (setq tlst (dstp_attlst sset))
          (if (> (length tlst) 0)
            (progn
              (setq tlst (acad_strlsort tlst))
              (setq tlst (dstp_tablesel "Select Elevation Tag" tlst "s" ""))
              (if (/= tlst nil)
                (progn
                  (princ "\nDS>")
                  (setq num (sslength sset) itm 0)
                  (while (< itm num)
                    (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                    (setq blkhnd (ssname sset itm))
                    (setq blkent (entget blkhnd))
                    (setq atthnd blkhnd)
                    (setq attent blkent)
                    (setq blkchg nil)
                    ;
                    (while (/= "SEQEND" (cdr (assoc 0 attent)))
                      (setq atthnd (entnext atthnd))
                      (setq attent (entget atthnd))
                      (if (= (cdr (assoc 0 attent)) "ATTRIB")
                        (progn
                          (setq atttag (cdr (assoc 2 attent)))
                          (setq attval (cdr (assoc 1 attent)))
                          (if (and (= atttag tlst)(/= attval ""))
                            (progn
                              (setq val (atof attval))
                              (setq blkchg T)
                            )
                          )
                        )
                      )
                    )
                    (if (= blkchg T)
                      (dstp_setelv blkhnd val)
                    )
                    (setq itm (1+ itm))
                  )
                  (princ ", Done.")
                )
              )
            )
          )
        )
        (alert "No blocks found")
      )
      (command "_.SELECT" sset "")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- Assign elevation from layer value
;
(defun c:ObjElvLay (/ cmdecho edif elv ent hnd itm lay num old sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq lay (cdr (assoc 8 ent)))
            (setq elv (atof lay))
            (if (= (cdr (assoc 0 ent)) "LWPOLYLINE")
              (if (= (cdr (assoc 38 ent)) nil)
                (setq old 0.0)
                (setq old (cdr (assoc 38 ent)))
              )
              (setq old (caddr (cdr (assoc 10 ent))))
            )
            (setq edif (- elv old))
            (if (/= edif 0.0)
              (command "_.MOVE" hnd "" "0,0,0" (strcat "@0,0," (rtos edif 2 8)))
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (command "_.SELECT" sset "")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                            Delete Duplicates
; --------------------------------------------------------------------------

(defun c:ObjDelDup (/ actspc axo axo1 axo2 chk chk1 chk2 cmdecho cont
                          dcnt done ea1 ea2 ent1 ent2 fuzz hnd1 hnd2 ied ild
                          itm l1p1 l1p2 l2p1 l2p2 maxpt minpt mset num obj1
                          obj2 osmode p1 p2 ret sa1 sa2 sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun objdeldup_compare (hnd1 hnd2)
        (setq ret nil)
        (setq ent1 (entget hnd1))
        (setq ent2 (entget hnd2))
        (setq obj1 (cdr (assoc 0 ent1)))
        (setq obj2 (cdr (assoc 0 ent2)))
        (setq cont T)
        (if (= ild nil)
          (if (= (cdr (assoc 8 ent1))(cdr (assoc 8 ent2)))
            (setq cont nil)
          )
        )
        (if (= cont T)
          (if (= obj1 obj2)
            (cond
              ((or
                  (= obj1 "3DFACE")
                  (= obj1 "LEADER")
                  (= obj1 "LWPOLYLINE")
                  (= obj1 "MLINE")
                  (= obj1 "POLYLINE")
                  (= obj1 "SOLID")
                  (= obj1 "TRACE")
                )
                (setq axo1 (vlax-ename->vla-object hnd1))
                (setq axo2 (vlax-ename->vla-object hnd2))
                (setq chk1 (vlax-get axo1 "Coordinates"))
                (setq chk2 (vlax-get axo2 "Coordinates"))
                (if (equal chk1 chk2 fuzz)
                  (setq ret T)
                  (setq ret nil)
                )
                (if (and (vlax-property-available-p axo1 "Elevation")
                         (vlax-property-available-p axo2 "Elevation"))
                  (if (and (= ret T)(/= ied T))
                    (progn
                      (setq chk1 (vla-get-elevation axo1))
                      (setq chk2 (vla-get-elevation axo2))
                      (if (equal chk1 chk2 fuzz)
                        (setq ret T)
                        (setq ret nil)
                      )
                    )
                  )
                )
                (setq tmp ret)
              )
              ((= obj1 "3DSOLID")
                (setq axo1 (vlax-ename->vla-object hnd1))
                (setq axo2 (vlax-ename->vla-object hnd2))
                (setq chk1 (vla-get-volume axo1))
                (setq chk2 (vla-get-volume axo2))
                (if (equal chk1 chk2 fuzz)
                  (progn
                    (setq chk1 (vlax-get axo1 "Centroid"))
                    (setq chk2 (vlax-get axo2 "Centroid"))
                    (if (= ied T)
                      (progn
                        (setq chk1 (dstp_2dpoint chk1))
                        (setq chk2 (dstp_2dpoint chk2))
                      )
                    )
                    (if (equal chk1 chk2 fuzz)
                      (setq ret T)
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "ARC")
                (setq chk1 (cdr (assoc 40 ent1)))
                (setq chk2 (cdr (assoc 40 ent2)))
                (if (equal chk1 chk2 fuzz)
                  (progn
                    (setq sa1 (cdr (assoc 50 ent1)))
                    (setq sa2 (cdr (assoc 50 ent2)))
                    (setq ea1 (cdr (assoc 51 ent1)))
                    (setq ea2 (cdr (assoc 51 ent2)))
                    (if (and (equal sa1 sa2 fuzz)(equal ea1 ea2 fuzz))
                      (progn
                        (setq chk1 (cdr (assoc 10 ent1)))
                        (setq chk2 (cdr (assoc 10 ent2)))
                        (if (= ied T)
                          (progn
                            (setq chk1 (dstp_2dpoint p1))
                            (setq chk2 (dstp_2dpoint p2))
                          )
                        )
                        (if (equal chk1 chk2 fuzz)
                          (setq ret T)
                        )
                      )
                    )
                  )
                )
              )
              ((= obj1 "ARCALIGNEDTEXT")
                (setq chk1 (cdr (assoc 1 ent1)))
                (setq chk2 (cdr (assoc 1 ent2)))
                (if (= (strcase chk1)(strcase chk2))
                  (progn
                    (setq chk1 (cdr (assoc 40 ent1)))
                    (setq chk2 (cdr (assoc 40 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq sa1 (cdr (assoc 50 ent1)))
                        (setq sa2 (cdr (assoc 50 ent2)))
                        (setq ea1 (cdr (assoc 51 ent1)))
                        (setq ea2 (cdr (assoc 51 ent2)))
                        (if (and (equal sa1 sa2 fuzz)(equal ea1 ea2 fuzz))
                          (progn
                            (setq chk1 (cdr (assoc 10 ent1)))
                            (setq chk2 (cdr (assoc 10 ent2)))
                            (if (= ied T)
                              (progn
                                (setq chk1 (dstp_2dpoint p1))
                                (setq chk2 (dstp_2dpoint p2))
                              )
                            )
                            (if (equal chk1 chk2 fuzz)
                              (setq ret T)
                              (setq ret nil)
                            )
                          )
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "CIRCLE")
                (setq chk1 (cdr (assoc 40 ent1)))
                (setq chk2 (cdr (assoc 40 ent2)))
                (if (equal chk1 chk2 fuzz)
                  (progn
                    (setq chk1 (cdr (assoc 10 ent1)))
                    (setq chk2 (cdr (assoc 10 ent2)))
                    (if (= ied T)
                      (progn
                        (setq chk1 (dstp_2dpoint p1))
                        (setq chk2 (dstp_2dpoint p2))
                      )
                    )
                    (if (equal chk1 chk2 fuzz)
                      (setq ret T)
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "DIMENSION")
                (setq chk1 (cdr (assoc 70 ent1)))
                (setq chk2 (cdr (assoc 70 ent2)))
                (if (equal chk1 chk2)
                  (progn
                    (setq chk1 (cdr (assoc 10 ent1)))
                    (setq chk2 (cdr (assoc 10 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (cdr (assoc 11 ent1)))
                        (setq chk2 (cdr (assoc 11 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (setq ret T)
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "ELLIPSE")
                (setq chk1 (cdr (assoc 10 ent1)))
                (setq chk2 (cdr (assoc 10 ent2)))
                (if (equal chk1 chk2 fuzz)
                  (progn
                    (setq chk1 (cdr (assoc 11 ent1)))
                    (setq chk2 (cdr (assoc 11 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (cdr (assoc 40 ent1)))
                        (setq chk2 (cdr (assoc 40 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (progn
                            (setq chk1 (cdr (assoc 41 ent1)))
                            (setq chk2 (cdr (assoc 41 ent2)))
                            (if (equal chk1 chk2 fuzz)
                              (progn
                                (setq chk1 (cdr (assoc 42 ent1)))
                                (setq chk2 (cdr (assoc 42 ent2)))
                                (if (equal chk1 chk2 fuzz)
                                  (setq ret T)
                                  (setq ret nil)
                                )
                              )
                              (setq ret nil)
                            )
                          )
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "HATCH")
                (setq chk1 (cdr (assoc 2 ent1))) ; pattern name
                (setq chk2 (cdr (assoc 2 ent2)))
                (if (equal chk1 chk2)
                  (progn
                    (setq chk1 nil chk2 nil)
                    (foreach rec ent1
                      (if (or (= (car rec) 10)(= (car rec) 11))
                        (setq chk1 (append chk1 (list rec)))
                      )
                    )
                    (foreach rec ent2
                      (if (or (= (car rec) 10)(= (car rec) 11))
                        (setq chk2 (append chk2 (list rec)))
                      )
                    )
                    (if (equal chk1 chk2 fuzz)
                      (setq ret T)
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((or (= obj1 "IMAGE")(= obj1 "WIPEOUT"))
                (setq chk1 (cdr (assoc 10 ent1)))
                (setq chk2 (cdr (assoc 10 ent2)))
                (if (equal chk1 chk2 fuzz)
                  (progn
                    (setq chk1 (cdr (assoc 11 ent1)))
                    (setq chk2 (cdr (assoc 11 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (cdr (assoc 12 ent1)))
                        (setq chk2 (cdr (assoc 12 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (progn
                            (setq chk1 (cdr (assoc 13 ent1)))
                            (setq chk2 (cdr (assoc 13 ent2)))
                            (if (equal chk1 chk2 fuzz)
                              (progn
                                (setq chk1 (cdr (assoc 340 ent1)))
                                (setq chk2 (cdr (assoc 340 ent2)))
                                (if (equal chk1 chk2)
                                  (setq ret T)
                                  (setq ret nil)
                                )
                              )
                              (setq ret nil)
                            )
                          )
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "INSERT")
                (setq chk1 (cdr (assoc 2 ent1))) ; block name
                (setq chk2 (cdr (assoc 2 ent2)))
                (if (equal chk1 chk2)
                  (progn
                    (setq chk1 (cdr (assoc 66 ent1))) ; attr flw
                    (setq chk2 (cdr (assoc 66 ent2)))
                    (if (equal chk1 chk2)
                      (progn
                        (setq chk1 (cdr (assoc 10 ent1))) ; ins pt
                        (setq chk2 (cdr (assoc 10 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (progn
                            (setq chk1 (cdr (assoc 41 ent1))) ; xsc
                            (setq chk2 (cdr (assoc 41 ent2)))
                            (if (equal chk1 chk2 fuzz)
                              (progn
                                (setq chk1 (cdr (assoc 42 ent1))) ; ysc
                                (setq chk2 (cdr (assoc 42 ent2)))
                                (if (equal chk1 chk2 fuzz)
                                  (progn
                                    (setq chk1 (cdr (assoc 50 ent1))) ; rot
                                    (setq chk2 (cdr (assoc 50 ent2)))
                                    (if (equal chk1 chk2 fuzz)
                                      (setq ret T)
                                      (setq ret nil)
                                    )
                                  )
                                  (setq ret nil)
                                )
                              )
                              (setq ret nil)
                            )
                          )
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "LINE")
                (setq l1p1 (cdr (assoc 10 ent1)))
                (setq l1p2 (cdr (assoc 11 ent1)))
                (setq l2p1 (cdr (assoc 10 ent2)))
                (setq l2p2 (cdr (assoc 11 ent2)))
                (if (> (car l1p1)(car l1p2))
                  (setq tmp l1p1 l1p1 l1p2 l1p2 tmp) ; swap if not left->right
                )
                (if (> (car l2p1)(car l2p2))
                  (setq tmp l2p1 l2p1 l2p2 l2p2 tmp) ; swap if not left->right
                )
                (if (> (cadr l1p1)(cadr l1p2))
                  (setq tmp l1p1 l1p1 l1p2 l1p2 tmp) ; swap if not top->bottom
                )
                (if (> (cadr l2p1)(cadr l2p2))
                  (setq tmp l2p1 l2p1 l2p2 l2p2 tmp) ; swap if not top->bottom
                )
                (if (= ied T)
                  (progn
                    (setq l1p1 (dstp_2dpoint l1p1))
                    (setq l1p2 (dstp_2dpoint l1p2))
                    (setq l2p1 (dstp_2dpoint l2p1))
                    (setq l2p2 (dstp_2dpoint l2p2))
                  )
                )
                (if (and (equal l1p1 l2p1 fuzz)(equal l1p2 l2p2 fuzz))
                  (setq ret T)
                  (setq ret nil)
                )
              )
              ((= obj1 "MTEXT")
                (setq axo1 (vlax-ename->vla-object hnd1))
                (setq axo2 (vlax-ename->vla-object hnd2))
                (setq chk1 (vla-get-textstring axo1))
                (setq chk2 (vla-get-textstring axo2))
                (if (= (strcase chk1)(strcase chk2))
                  (progn
                    (setq chk1 (cdr (assoc 10 ent1)))
                    (setq chk2 (cdr (assoc 10 ent2)))
                    (if (= ied T)
                      (progn
                        (setq chk1 (dstp_2dpoint chk1))
                        (setq chk2 (dstp_2dpoint chk2))
                      )
                    )
                    (if (equal chk1 chk2 fuzz)
                      (setq ret T)
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "POINT")
                (setq chk1 (cdr (assoc 10 ent1)))
                (setq chk2 (cdr (assoc 10 ent2)))
                (if (= ied T)
                  (progn
                    (setq chk1 (dstp_2dpoint chk1))
                    (setq chk2 (dstp_2dpoint chk2))
                  )
                )
                (if (equal chk1 chk2 fuzz)
                  (setq ret T)
                  (setq ret nil)
                )
              )
              ((= obj1 "REGION")
                (setq axo1 (vlax-ename->vla-object hnd1))
                (setq axo2 (vlax-ename->vla-object hnd2))
                (setq chk1 (vlax-get axo1 "Area"))
                (setq chk2 (vlax-get axo2 "Area"))
                (if (equal chk1 chk2 fuzz)
                  (progn
                    (setq chk1 (vlax-get axo1 "Perimeter"))
                    (setq chk2 (vlax-get axo2 "Perimeter"))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (vlax-get axo1 "Centroid"))
                        (setq chk2 (vlax-get axo2 "Centroid"))
                        (if (= ied T)
                          (progn
                            (setq chk1 (dstp_2dpoint chk1))
                            (setq chk2 (dstp_2dpoint chk2))
                          )
                        )
                        (if (equal chk1 chk2 fuzz)
                          (setq ret T)
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "RTEXT")
                (setq chk1 (cdr (assoc 1 ent1)))
                (setq chk2 (cdr (assoc 1 ent2)))
                (if (= (strcase chk1)(strcase chk2))
                  (progn
                    (setq chk1 (cdr (assoc 50 ent1))) ; size
                    (setq chk2 (cdr (assoc 50 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (cdr (assoc 40 ent1))) ; hgt 
                        (setq chk2 (cdr (assoc 40 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (progn
                            (setq chk1 (cdr (assoc 10 ent1)))
                            (setq chk2 (cdr (assoc 10 ent2)))
                            (if (= ied T)
                              (progn
                                (setq chk1 (dstp_2dpoint p1))
                                (setq chk2 (dstp_2dpoint p2))
                              )
                            )
                            (if (equal chk1 chk2 fuzz)
                              (setq ret T)
                              (setq ret nil)
                            )
                          )
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "SHAPE")
                (setq chk1 (cdr (assoc 2 ent1))) ; shape name
                (setq chk2 (cdr (assoc 2 ent2)))
                (if (equal chk1 chk2)
                  (progn
                    (setq chk1 (cdr (assoc 10 ent1))) ; ins pt
                    (setq chk2 (cdr (assoc 10 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (cdr (assoc 40 ent1))) ; size
                        (setq chk2 (cdr (assoc 40 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (progn
                            (setq chk1 (cdr (assoc 50 ent1))) ; rot
                            (setq chk2 (cdr (assoc 50 ent2)))
                            (if (equal chk1 chk2 fuzz)
                              (setq ret T)
                              (setq ret nil)
                            )
                          )
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "SPLINE")
                (setq axo1 (vlax-ename->vla-object hnd1))
                (setq axo2 (vlax-ename->vla-object hnd2))
                (setq chk1 (vlax-get axo1 "NumberOfControlPoints"))
                (setq chk2 (vlax-get axo2 "NumberOfControlPoints"))
                (if (= chk1 chk2)
                  (progn
                    (setq chk1 (vlax-get axo1 "NumberOfFitPoints"))
                    (setq chk2 (vlax-get axo2 "NumberOfFitPoints"))
                    (if (= chk1 chk2)
                      (progn
                        (setq chk1 (vlax-get axo1 "Controlpoints"))
                        (setq chk2 (vlax-get axo2 "Controlpoints"))
                        (if (equal chk1 chk2 fuzz)
                          (setq ret T)
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((= obj1 "TOLERANCE")
                (setq chk1 (cdr (assoc 1 ent1)))
                (setq chk2 (cdr (assoc 1 ent2)))
                (if (equal chk1 chk2)
                  (progn
                    (setq chk1 (cdr (assoc 10 ent1)))
                    (setq chk2 (cdr (assoc 10 ent2)))
                    (if (equal chk1 chk2 fuzz)
                      (progn
                        (setq chk1 (cdr (assoc 11 ent1)))
                        (setq chk2 (cdr (assoc 11 ent2)))
                        (if (equal chk1 chk2 fuzz)
                          (setq ret T)
                          (setq ret nil)
                        )
                      )
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              ((or (= obj1 "ATTDEF")(= obj1 "TEXT"))
                (setq chk1 (cdr (assoc 1 ent1)))
                (setq chk2 (cdr (assoc 1 ent2)))
                (if (= (strcase chk1)(strcase chk2))
                  (progn
                    (setq chk1 (cdr (assoc 10 ent1)))
                    (setq chk2 (cdr (assoc 10 ent2)))
                    (if (= ied T)
                      (progn
                        (setq chk1 (dstp_2dpoint p1))
                        (setq chk2 (dstp_2dpoint p2))
                      )
                    )
                    (if (equal chk1 chk2 fuzz)
                      (setq ret T)
                      (setq ret nil)
                    )
                  )
                  (setq ret nil)
                )
              )
              (t nil)
            )
            (setq ret nil)
          )
        )
        (if (= ret T)
          (if (= ild nil)
            (if (/= (cdr (assoc 8 ent1))(cdr (assoc 8 ent2)))
              (setq ret nil)
            )
          )
        )
        (setq tmp ret)
      )
      ;
      ; --- Main
      ;
      (if (= (getvar "tilemode") 1)
        (setq actspc 0)
        (if (> (getvar "cvport") 1)
          (setq actspc 0)
          (setq actspc 1)
        )
      )
      (if (= actspc 0)
        (setq mset (ssget '((67 . 0)(-4 . "<OR")(0 . "3DFACE")(0 . "3DSOLID")(0 . "ARC")(0 . "ARCALIGNEDTEXT")(0 . "ATTDEF")(0 . "CIRCLE")(0 . "DIMENSION")(0 . "ELLIPSE")(0 . "HATCH")(0 . "IMAGE")(0 . "INSERT")(0 . "LEADER")(0 . "LINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "MTEXT")(0 . "POINT")(0 . "POLYLINE")(0 . "REGION")(0 . "RTEXT")(0 . "SHAPE")(0 . "SOLID")(0 . "SPLINE")(0 . "TEXT")(0 . "TOLERANCE")(0 . "TRACE")(0 . "WIPEOUT")(-4 . "OR>"))))
        (setq mset (ssget '((67 . 1)(-4 . "<OR")(0 . "3DFACE")(0 . "3DSOLID")(0 . "ARC")(0 . "ARCALIGNEDTEXT")(0 . "ATTDEF")(0 . "CIRCLE")(0 . "DIMENSION")(0 . "ELLIPSE")(0 . "HATCH")(0 . "IMAGE")(0 . "INSERT")(0 . "LEADER")(0 . "LINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "MTEXT")(0 . "POINT")(0 . "POLYLINE")(0 . "REGION")(0 . "RTEXT")(0 . "SHAPE")(0 . "SOLID")(0 . "SPLINE")(0 . "TEXT")(0 . "TOLERANCE")(0 . "TRACE")(0 . "WIPEOUT")(-4 . "OR>"))))
      )
      (if mset
        (progn
          (if (= fuzz nil)(setq fuzz 0.00000001))
          (setq chk (getdist (strcat "\nDS> Fuzz Distance <" (rtos fuzz 2 8) ">: ")))
          (if (/= chk nil)(setq fuzz chk))
          (initget "Y N")
          (setq chk (getkword "\nDS> Ignore Layer Difference <Y>/N: "))
          (if (= chk "N")(setq ild nil)(setq ild T))
          (initget "Y N")
          (setq chk (getkword "\nDS> Ignore Elevation Difference Y/<N>: "))
          (if (= chk "Y")(setq ied T)(setq ied nil))
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq dcnt 0)
          (setq done nil)
          (while (/= done T)
            (princ (strcat "\rDS> " (rtos (sslength mset) 2 0) " Objects Remaining ...    \r"))
            (setq hnd1 (ssname mset 0))
            (setq axo (vlax-ename->vla-object hnd1))
            (vla-getboundingbox axo 'minpt 'maxpt)
            (setq minpt (vlax-safearray->list minpt))
            (setq maxpt (vlax-safearray->list maxpt))
            (setq minpt (dstp_2dpoint minpt))
            (setq maxpt (dstp_2dpoint maxpt))
            (if (> fuzz 0.00000001)
              (progn
                (setq minpt (polar minpt pi fuzz))
                (setq minpt (polar minpt (+ pi (/ pi 2.0)) fuzz))
                (setq maxpt (polar maxpt 0 fuzz))
                (setq maxpt (polar maxpt (/ pi 2.0) fuzz))
              )
            )
            (setq sset (ssget "_C" minpt maxpt (list (cons 0 (cdr (assoc 0 (entget hnd1)))))))
            (if (/= sset nil)
              (progn
                (setq sset (ssdel hnd1 sset))
                (if (/= sset nil)
                  (progn
                    (setq itm 0 num (sslength sset))
                    (while (< itm num)
                      (setq hnd2 (ssname sset itm))
                      (if (ssmemb hnd2 mset)
                        (progn
                          (setq chk (objdeldup_compare hnd1 hnd2))
                          (if (= chk T)
                            (progn
                              (setq dcnt (+ dcnt 1))
                              (setq mset (ssdel hnd2 mset))
                              (entdel hnd2)
                              (princ (strcat "\rDS> " (rtos (sslength mset) 2 0) " Objects Remaining ...    "))
                              (setq itm (1- itm))
                            )
                          )
                        )
                      )
                      (setq itm (1+ itm))
                    )
                  )
                )
              )
            )
            (setq mset (ssdel hnd1 mset))
            (if (< (sslength mset) 2)
              (setq done T)
            )
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
          (if (> dcnt 0)
            (princ (strcat "\rDS> Total of " (rtos dcnt 2 0) " Duplicate Objects Removed!"))
            (princ (strcat "\rDS> No Duplicate Objects Found!"))
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Erase Entities by Passing Cursor Over
; --------------------------------------------------------------------------

(defun c:ObjMovEra (/ chk curact curera ent hnd ignlst key obj pik pnt
                         sset str0 str1 tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Use 'E' key to Exclude Object Types ...")
      (setq str0 "\nDS> Eraser Off, Left Click to Toggle, Right Click to Stop.")
      (setq str1 "\nDS> Eraser On, Left Click to Toggle, Right Click to Stop.")
      (setq curact T)
      (setq curera nil)
      (setq ignlst nil)
      (princ str0)
      (while curact
        (setq tmp (grread (quote T)))
        (setq chk (car tmp))
        (cond
          ((= chk 2) ' key
            (setq key (cadr tmp))
            (if (= key 101)
              (progn
                (setq pik (entsel "\nDS> Select Object Type to Exclude: "))
                (if (/= pik nil)
                  (progn
                    (setq hnd (car pik))
                    (setq ent (entget hnd))
                    (setq obj (cdr (assoc 0 ent)))
                    (if (not (member obj ignlst))
                      (setq ignlst (cons obj ignlst))
                    )
                  )
                )
                (if (= curera T)
                  (princ str1)
                  (princ str0)
                )
              )
            )
          )
          ((= chk 3) ' left
            (if (= curera T)
              (progn
                (princ str0)
                (setq curera nil)
              )
              (progn
                (princ str1)
                (setq curera T)
              )
            )
          )
          ((= chk 25) ' right
            (setq curact nil)
          )
          (t
            (if (= curera T)
              (progn
                (setq pnt (cadr tmp))
                (setq sset (ssget pnt))
                (if sset
                  (progn
                    (setq hnd (ssname sset 0))
                    (if (= ignlst nil)
                      (entdel hnd)
                      (progn
                        (setq ent (entget hnd))
                        (setq obj (cdr (assoc 0 ent)))
                        (if (not (member obj ignlst))
                          (entdel hnd)
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                  Delete entities inside/outside/more
; --------------------------------------------------------------------------

(defun c:ObjDelIns () (dstp_objdelcmd "io"))
(defun c:ObjDelObj () (dstp_objdelcmd "oo"))
(defun c:ObjDelWin () (dstp_objdelcmd "ow"))

(defun dstp_objdelcmd (opt / add chm cmdecho done eco ent highlight hnd itm
                          new nset num pt1 pt2 ptlst rco sset tmp val zhnd
                          zitm znum)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (cond 
        ((= opt "ow")
          (setq pt1 (getpoint "\nDS> Starting Corner: "))
          (setq pt2 (getcorner pt1 "\nDS> Other Corner: "))
          (setvar "HIGHLIGHT" 0)
          (command "_.ERASE" "_ALL" "_R" "_C" pt1 pt2 "")
          (setvar "HIGHLIGHT" 1)
        )
        ;
        ; --- erase inside/outside boundary(s)
        ;
        ((or (= opt "oo")(= opt "io"))
          (setq done nil)
          (princ "\nDS> Select Boundary Objects to Use ...")
          (setq sset (ssget '((-4 . "<OR")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "SPLINE")(-4 . "OR>"))))
          (if sset
            (progn
              (if (= opt "oo")
                (progn
                  (initget "Y N")
                  (setq tmp (getkword "\nDS> Retain Crossing Objects <Y>/N: "))
                  (if (/= tmp "N")(setq rco "Y")(setq rco "N"))
                )
              )
              (if (= opt "io")
                (progn
                  (initget "Y N")
                  (setq tmp (getkword "\nDS> Erase Crossing Objects Y/<N>: "))
                  (if (/= tmp "Y")(setq eco "N")(setq eco "Y"))
                )
              )
              (setq itm 0 num (sslength sset))
              (setq nset (ssadd))
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq ptlst (dstp_obj2lst hnd))
                (setq tmp nil)
                (foreach pnt ptlst
                  (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
                  (setq tmp (append tmp (list new)))
                )
                (setq ptlst tmp)
                (setq tmp nil)
                (cond
                  ((= opt "io")
                    (if (= eco "N")
                      (setq add (ssget "_WP" ptlst))
                      (setq add (ssget "_CP" ptlst))
                    )
                  )
                  ((= opt "oo")
                    (if (= rco "Y")
                      (setq add (ssget "_CP" ptlst))
                      (setq add (ssget "_WP" ptlst))
                    )
                  )
                  (t nil)
                )
                (if (/= add nil)
                  (progn
                    (setq zitm 0)
                    (setq znum (sslength add))
                    (while (< zitm znum)
                      (setq zhnd (ssname add zitm))
                      (setq nset (ssadd zhnd nset))
                      (setq zitm (1+ zitm))
                    )
                  )
                )
                (setq itm (1+ itm))
              ) 
              (if (> (sslength nset) 0)
                (progn
                  (setq highlight (getvar "HIGHLIGHT"))
                  (setvar "HIGHLIGHT" 0)
                  (cond
                    ((= opt "io")
                      (command "_.ERASE" nset "_R" sset "")
                    )
                    ((= opt "oo")
                      (command "_.ERASE" "_ALL" "_R" nset sset "")
                    )
                    (t nil)
                  )
                  (setvar "HIGHLIGHT" highlight)
                )
              )
            )
          )
          (setq add nil)
          (setq nset nil)
          (setq sset nil)
        )
        (t nil)
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Layer Objects based on elevation
; --------------------------------------------------------------------------

(defun c:ObjLayElv (/ chk cmdecho col dec elv ent hnd itm lay num sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (if (/= sset nil)
        (progn
          (setq dec 0)
          (setq tmp (getint "\nDS> Roundoff Decimal Places <0>: "))
          (if (/= tmp nil)(setq dec tmp))
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (if (= (cdr (assoc 0 ent)) "LWPOLYLINE")
              (if (= (cdr (assoc 38 ent)) nil)
                (setq elv 0.0)
                (setq elv (cdr (assoc 38 ent)))
              )
              (setq elv (caddr (cdr (assoc 10 ent))))
            )
            (setq lay (rtos elv 2 dec))
            (if (= (tblsearch "LAYER" lay) nil)
              (progn
                (setq tmp (assoc 62 ent))
                (if (/= tmp nil)
                  (setq col (cdr tmp))
                  (progn
                    (setq chk (tblsearch "LAYER" (cdr (assoc 8 ent))))
                    (setq col (abs (cdr (assoc 62 chk))))
                  )
                )
                (command "_.LAYER" "_N" lay "_C" col lay "")
              )
            )
            (command "_.CHPROP" hnd "" "_LA" lay "")
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Layer Objects by Object Type
; --------------------------------------------------------------------------

(defun c:ObjLayTyp (/ cmdecho ent hnd itm num obj sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget))
      (if (/= sset nil)
        (progn
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (if (= (tblsearch "LAYER" obj) nil)
              (command "_.LAYER" "_N" obj "")
            )
            (command "_.CHPROP" hnd "" "_LA" obj "")
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Object Layer Temporary Save/Restore
; --------------------------------------------------------------------------

(defun c:ObjLayDem (/ cmdecho chk ent hnd itm lay lc ll ls lt num
                          pass sset suf tar)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (if (/= sset nil)
        (progn
          (setq suf (dstp_regfetch "Layer" "tmpsuf" "DEMO"))
          (setq chk (getstring (strcat "\nDS> Temporary Layer Suffix <" suf ">: ")))
          (if (/= chk "")(setq suf chk))
          (dstp_regstore "Layer" "tmpsuf" suf)
          (setq num (sslength sset) itm 0)
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq lay (cdr (assoc 8 ent)))
            (setq pass T)
            (if (> (strlen lay)(strlen suf))
              (if (= (substr lay (1+ (- (strlen lay)(strlen suf))) (strlen suf)) suf)
                (setq pass nil)
              )
            )
            (if (= pass T)
              (progn
                (setq tar (strcat lay "-" suf))
                (if (= (tblsearch "LAYER" tar) nil)
                  (progn
                    (setq lt (tblsearch "LAYER" lay))
                    (setq ls (cdr (assoc 70 lt)))
                    (setq lc (cdr (assoc 62 lt)))
                    (setq ll (cdr (assoc 6 lt)))
                    (if (< lc 0)
                      (setq lc (- 0 lc))
                    )
                    (command "_.LAYER" "_N" tar "_C" lc tar "_LT" ll tar "")
                  )
                )
                (command "_.CHPROP" hnd "" "_LA" tar "")
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )
  (princ)
)

(defun c:ObjLayUnd (/ all cmdecho lc ll ls lst lt resp sset suf tar)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq suf (dstp_regfetch "Layer" "tmpsuf" "DEMO"))
      (setq all (dstp_bldlst "LAYER"))
      (setq lst nil)
      (foreach lay all
        (if (= (dstp_instr lay "|") nil)
          (if (> (strlen lay)(strlen suf))
            (if (= (substr lay (1+ (- (strlen lay)(strlen suf))) (strlen suf)) suf)
              (if (not (member lay lst))
                (setq lst (cons lay lst))
              )
            )
          )
        )
      )
      (if (/= lst nil)
        (progn
          (setq resp (dstp_tablesel "Select Desired Layer(s)" (acad_strlsort lst) "m" "T"))
          (if (/= resp nil)
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (foreach lay resp
                (command "_.LAYER" "_T" lay "")
                (setq sset (ssget "_X" (list (cons 8 lay))))
                (if (/= sset nil)
                  (progn
                    (setq tar (substr lay 1 (- (strlen lay) (1+ (strlen suf)))))
                    (if (= (tblsearch "LAYER" tar) nil)
                      (progn
                        (setq lt (tblsearch "LAYER" lay))
                        (setq ls (cdr (assoc 70 lt)))
                        (setq lc (cdr (assoc 62 lt)))
                        (setq ll (cdr (assoc 6 lt)))
                        (if (< lc 0)
                          (setq lc (- 0 lc))
                        )
                        (command "_.LAYER" "_N" tar "_C" lc tar "_LT" ll tar "")
                      )
                    )
                    (command "_.CHPROP" sset "" "_LA" tar "")
                    (command "_.PURGE" "_LA" lay "_N")
                  )
                )
              )
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
            )
          )
        )
        (princ (strcat "\nDS> No Matching Layers Found [" suf "]"))
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                 Align Objects with Rotate & Scale Relative
; --------------------------------------------------------------------------

(defun c:ObjPntAli (/ cmdecho dbp drp ibp irp osmode sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq ibp (dstp_2dpoint (getpoint "\nDS> Original Base Point: ")))
      (if (= ibp nil)(exit))
      (setq irp (dstp_2dpoint (getpoint "\nDS> Original Reference Point: ")))
      (if (= irp nil)(exit))
      (setq dbp (dstp_2dpoint (getpoint "\nDS> New Base Point: ")))
      (if (= dbp nil)(exit))
      (setq drp (dstp_2dpoint (getpoint "\nDS> New Reference Point: ")))
      (if (= drp nil)(exit))
      (initget "Y N")
      (setq scl (getkword "\nDS> Scale Objects <Y>/N: "))
      (if (/= scl "N")
        (progn
          (setq scl "Y")
          (princ "\nDS> Notice: This command uses the SCALE command,")
          (princ "\nDS> which will scale non-zero elevations also.")
        )
      )
      (setq sset (ssget))
      (if sset
        (progn
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (command "_.MOVE" sset "" ibp dbp)
          (if (= scl "Y")
            (command "_.SCALE" sset "" dbp "_R" (distance ibp irp) (distance dbp drp))
          )
          (command "_.ROTATE" sset "" dbp "_R" ibp irp drp)
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "OSMODE" osmode)
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                  Hardcolor Objects based on layer color
; --------------------------------------------------------------------------

(defun c:ObjBndCol (/ chk cmdecho col dat ent hnd itm lay mov num sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget))
      )
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (initget "Y N")
          (setq chk (getkword "\nDS> Move to 0 layer Y/<N>: "))
          (if (/= chk "Y")(setq mov nil)(setq mov T))
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq lay (cdr (assoc 8 ent)))
            (setq dat (tblsearch "LAYER" lay))
            (setq col (cdr (assoc 62 dat)))
            (if (= (assoc 62 ent) nil)
              (setq ent (append ent (list (cons 62 col))))
              (setq ent (subst (cons 62 col) (assoc 62 ent) ent))
            )
            (if (= mov T)
              (setq ent (subst (cons 8 "0") (assoc 8 ent) ent))
            )
            (entmod ent)
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (command "_.SELECT" sset "")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setq sset nil)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                  Explode Selected Objects to Chosen Layer
; --------------------------------------------------------------------------

(defun c:ObjExpLay (/ cmdecho lst nxt pntmrk resp sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (princ "\nDS> Select Objects to Explode ...")
      (setq sset (ssget))
      (if (/= sset nil)
        (progn
          (setq resp nil)
          (initget "C D")
          (setq tmp (entsel "\nDS> Current/Dialog/<Pick Object with Desired Layer>: "))
          (cond
            ((= tmp "C")
              (setq resp (getvar "CLAYER"))
            )
            ((= tmp "D")
              (setq resp (dstp_tablesel "Select Desired Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
            )
            (t
              (if (/= tmp nil)
                (setq resp (cdr (assoc 8 (entget (car tmp)))))
              )
            )
          )
          (if (/= resp nil)
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (command "_.POINT" "0,0")
              (setq pntmrk (entlast))
              (setq lst (dstp_ss2lst sset))
              (foreach hnd lst
                (command)
                (command "_.EXPLODE" hnd)
              )
              (setq sset (ssadd))
              (setq nxt pntmrk)
              (while (/= nxt nil)
                (setq nxt (entnext nxt))
                (if (/= nxt nil)
                  (setq sset (ssadd nxt sset))
                )
              )
              (command)
              (command "_.CHANGE" sset "" "_P" "_LA" resp "")
              (entdel pntmrk)
              (setq sset nil)
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
              (princ "\n")
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Glue two arcs together
; --------------------------------------------------------------------------

(defun c:ObjGluArc (/ a1 a1ent a1hnd a1p1 a1p2 a2 a2ent a2hnd a2p1 a2p2
                         a3 a4 ang1 ang2 bang cd cmdecho cpt1 cpt2 ean1 ean2
                         eang rad1 rad2 rd san1 san2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq a1hnd (car (entsel "\nDS> Pick 1st Arc: ")))
      (if (/= a1hnd nil)
        (progn
          (setq a2hnd (car (entsel "\nDS> Pick 2nd Arc: ")))
          (if (/= a2hnd nil)
            (progn
              (setq a1ent (entget a1hnd))
              (setq cpt1 (cdr (assoc 10 a1ent)))
              (setq rad1 (cdr (assoc 40 a1ent)))
              (setq san1 (cdr (assoc 50 a1ent)))
              (setq ean1 (cdr (assoc 51 a1ent)))
              (setq a1p1 (polar cpt1 san1 rad1))
              (setq a1p2 (polar cpt1 ean1 rad1))
              (setq a2ent (entget a2hnd))
              (setq cpt2 (cdr (assoc 10 a2ent)))
              (setq rad2 (cdr (assoc 40 a2ent)))
              (setq san2 (cdr (assoc 50 a2ent)))
              (setq ean2 (cdr (assoc 51 a2ent)))
              (setq a2p1 (polar cpt2 san2 rad2))
              (setq a2p2 (polar cpt2 ean2 rad2))
              (setq cd (distance cpt1 cpt2))
              (if (> cd 0.0)
                (princ (strcat "\nDS> WARNING: Center Point Variance of " (rtos cd)))
              )
              (setq rd (- rad2 rad1))
              (if (> rd 0.0)
                (princ (strcat "\nDS> WARNING: Radius Difference of " (rtos cd)))
              )
              (setq a1 (angle cpt1 a1p1))
              (setq a2 (angle cpt1 a1p2))
              (setq ang1 (min a1 a2))
              (setq a3 (angle cpt2 a2p1))
              (setq a4 (angle cpt2 a2p2))
              (setq ang2 (max a3 a4))
              (if (> ang1 ang2)
                (setq bang ang2 eang ang1)
                (setq bang ang1 eang ang2)
              )
              (entdel a2hnd)
              (setq a1ent (subst (cons 50 bang)(assoc 50 a1ent) a1ent))
              (setq a1ent (subst (cons 51 eang)(assoc 51 a1ent) a1ent))
              (entmod a1ent)
            )
          )
        )
      )
      (dstp_ucspush)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;               Glue selection set of lines together
; --------------------------------------------------------------------------

(defun c:ObjGluLin (/ addrec d1 d2 d3 d4 done fnd fuz l1ent l1hnd l1p1
                         l1p2 l2ent l2hnd l2p1 l2p2 lst maxdis md mindis
                         oldrec p1 p2 pas priang pricnt pript1 pript2 prirec
                         remcnt secang seccnt secpt1 secpt2 secrec sset tmp
                         tmpent tmppt1 tmppt2 wrklst)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I" '((0 . "LINE"))))
      (if (= sset nil)
        (setq sset (ssget '((0 . "LINE"))))
      )
      (if sset
        (if (= (sslength sset) 2)
          (progn
            (setq l1hnd (ssname sset 0))
            (setq l2hnd (ssname sset 1))
            (setq l1ent (entget l1hnd))
            (setq l1p1 (cdr (assoc 10 l1ent)))
            (setq l1p2 (cdr (assoc 11 l1ent)))
            (setq l2ent (entget l2hnd))
            (setq l2p1 (cdr (assoc 10 l2ent)))
            (setq l2p2 (cdr (assoc 11 l2ent)))
            ;
            (setq d1 (distance l1p1 l2p2))
            (setq d2 (distance l1p2 l2p1))
            (setq d3 (distance l1p1 l2p1))
            (setq d4 (distance l1p2 l2p2))
            (setq md (max d1 d2 d3 d4))
            (cond 
              ((= md d1)
                (setq p1 l1p1)
                (setq p2 l2p2)
              )
              ((= md d2)
                (setq p1 l1p2)
                (setq p2 l2p1)
              )
              ((= md d3)
                (setq p1 l1p1)
                (setq p2 l2p1)
              )
              ((= md d4)
                (setq p1 l1p2)
                (setq p2 l2p2)
              )
              (t nil)
            )
            (entdel l2hnd)
            (setq l1ent (subst (cons 10 p1)(assoc 10 l1ent) l1ent))
            (setq l1ent (subst (cons 11 p2)(assoc 11 l1ent) l1ent))
            (entmod l1ent)
          )
          (progn
            (setq tmp (getint "\nDS> Number of Passes <3>: "))
            (if (= tmp nil)
              (setq pas 3)
              (setq pas tmp)
            )
            (setq tmp (getdist "\nDS> Fuzz Factor <0.0001>: "))
            (if (= tmp nil)
              (setq fuz 0.0001)
              (setq fuz tmp)
            )
            (princ "\nDS> Processing ... Please Wait ...\r")
            (setq done nil)
            (setq wrklst nil)
            (setq lst (dstp_ss2lst sset))
            (foreach tmphnd lst
              (setq tmpent (entget tmphnd))
              (setq tmppt1 (cdr (assoc 10 tmpent)))
              (setq tmppt2 (cdr (assoc 11 tmpent)))
              (setq addrec (list "Y" tmphnd tmppt1 tmppt2))
              (setq wrklst (cons addrec wrklst))
            )
            (repeat pas
              (setq pricnt -1)
              (repeat (length wrklst)
                (setq pricnt (1+ pricnt))
                (setq prirec (nth pricnt wrklst))
                (if (and (= (car prirec) "Y")(/= done T))
                  (progn
                    (setq fnd 0)
                    (setq seccnt -1)
                    (repeat (length wrklst)
                      (setq seccnt (1+ seccnt))
                      (setq secrec (nth seccnt wrklst))
                      (if (and (= (car secrec) "Y")(/= done T))
                        (if (/= prirec secrec)
                          (progn
                            (setq pript1 (nth 2 prirec))
                            (setq pript2 (nth 3 prirec))
                            (setq secpt1 (nth 2 secrec))
                            (setq secpt2 (nth 3 secrec))
                            (setq priang (angle pript1 pript2))
                            (setq secang (angle secpt1 secpt2))
                            (if (>= priang pi)(setq priang (- priang pi)))
                            (if (>= secang pi)(setq secang (- secang pi)))
                            (if (equal priang secang fuz)
                              (progn
                                (setq d1 (distance pript1 secpt2))
                                (setq d2 (distance pript2 secpt1))
                                (setq d3 (distance pript1 secpt1))
                                (setq d4 (distance pript2 secpt2))
                                (setq mindis (min d1 d2 d3 d4))
                                (setq maxdis (max d1 d2 d3 d4))
                                (if (<= mindis fuz)
                                  (progn
                                    (cond
                                      ((= maxdis d1)
                                        (setq p1 pript1)
                                        (setq p2 secpt2)
                                      )
                                      ((= maxdis d2)
                                        (setq p1 pript2)
                                        (setq p2 secpt1)
                                      )
                                      ((= maxdis d3)
                                        (setq p1 pript1)
                                        (setq p2 secpt1)
                                      )
                                      ((= maxdis d4)
                                        (setq p1 pript2)
                                        (setq p2 secpt2)
                                      )
                                      (t nil)
                                    )
                                    (setq oldrec prirec)
                                    (setq prirec (list "Y" (nth 1 prirec) p1 p2))
                                    (setq wrklst (subst prirec oldrec wrklst))
                                    (setq wrklst (subst (list "N" (nth 1 secrec) nil nil) secrec wrklst))
                                  )
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
            (setq remcnt 0)
            (foreach tmprec wrklst
              (if (= (nth 0 tmprec) "Y")
                (progn
                  (setq tmpent (entget (nth 1 tmprec)))
                  (setq tmpent (subst (cons 10 (nth 2 tmprec))(assoc 10 tmpent) tmpent))
                  (setq tmpent (subst (cons 11 (nth 3 tmprec))(assoc 11 tmpent) tmpent))
                  (entmod tmpent)
                )
                (progn
                  (setq remcnt (1+ remcnt))
                  (entdel (nth 1 tmprec))
                )
              )
            )
            (princ "DS> Processing ... Please Wait ... Done.")
            (if (> remcnt 0)
              (princ (strcat "\rDS> Processing ... Please Wait ... " (itoa remcnt) " Lines Consolidated."))
            )
          )
        ) 
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Rotate Object @ Pick Pt
; --------------------------------------------------------------------------

(defun c:ObjRotPik (/ cmdecho tmp rot done ent pnt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (getvar "LASTANGLE"))
      (setq rot (angtos tmp))
      (setq tmp (getstring (strcat "\nDS> Rotation Angle <" rot ">: ")))
      (if (/= tmp "")
        (setq rot tmp)
      )
      (setq done nil)
      (while (= done nil)
        (setq tmp (entsel "\nDS> Pick Object: "))
        (if (= tmp nil)
          (setq done T)
          (progn
            (setq ent (entget (car tmp)))
            (setq pnt (car (cdr tmp)))
            (command "_.ROTATE" pnt "" pnt rot)
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Scale Object @ Pick Pt
; --------------------------------------------------------------------------

(defun c:ObjSclPik (/ cmdecho tmp scl done ent hnd pnt)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (getreal (strcat "\nDS> Scale Factor: ")))
      (if (/= tmp "")
        (progn
          (setq scl tmp)
          (setq done nil)
          (while (= done nil)
            (setq tmp (entsel "\nDS> Pick Object: "))
            (if (= tmp nil)
              (setq done T)
              (progn
                (setq ent (entget (car tmp)))
                (setq hnd (cdr (car ent)))
                (setq pnt (car (cdr tmp)))
                (command "_.SCALE" hnd "" pnt scl)
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Object Cleanup Intersection
; --------------------------------------------------------------------------

(defun c:ObjClnInt (/ axo bpt cang cbul cctr cleanint_error clen cmdecho
                         cpnt ctr ent epl ept hnd iang itm lpnt lrec lst
                         maxpt mido minpt miss mpnt new num obj olderr
                         osmode pass pjs ppnt rads res sset tfac tol wrd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun cleanint_error (s)
        (if (/= s "Function cancelled.")
          (progn
            (dstp_ucspop)
            (command "_.UNDO" "_E")
            (setvar "OSMODE" osmode)
            (setvar "CMDECHO" cmdecho)
            (setq *error* olderr)
          )
        )
        (if olderr (setq *error* olderr))
        (princ)
      )
      (setq olderr *error* *error* cleanint_error)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (command "_.UNDO" "G")
      (dstp_ucspush)
      (setq pjs 1)
      (setq miss nil)
      (while (= miss nil)
        (initget "J")
        (setq ppnt (getpoint "\nDS> Join/<Pick Point Inside Intersection>: "))
        (cond 
          ((= ppnt "J")
            (if (= pjs 1)
              (setq pjs 0 wrd "Off")
              (setq pjs 1 wrd "On")
            )
            (princ (strcat "\nDS> Join Results: " wrd))
          )
          (t
            (if (/= ppnt nil)
              (progn
                (if (and (= (getvar "PRODUCT") "AutoCAD")(< (atoi (getvar "ACADVER")) 20))
                  (setq hnd (bpoly ppnt))
                  (progn
                    (command "_-BOUNDARY" ppnt "")
                    (setq hnd (entlast))
                  )
                )
                (if (> (getvar "CMDACTIVE") 0)
                  (progn
                    (command "_Y")
                    (setq hnd (entlast))
                  )
                )
                (if (/= hnd nil)
                  (progn
                    (setq lrec nil)
                    (setq lst nil)
                    (dstp_getpline hnd)
                    (foreach crec dstp_pldat
                      (setq cpnt (nth 0 crec))
                      (if (= lrec nil)
                        (progn
                          (setq lpnt (nth 0 (last dstp_pldat)))
                          (setq cbul (nth 3 (last dstp_pldat)))
                        )
                        (progn
                          (setq lpnt (nth 0 lrec))
                          (setq cbul (nth 3 lrec))
                        )
                      )
                      (if (= cbul 0.0)
                        (setq mpnt (polar lpnt (angle lpnt cpnt) (/ (distance lpnt cpnt) 2.0)))
                        (progn
                          (setq cang (angle lpnt cpnt))
                          (setq clen (distance lpnt cpnt))
                          (setq iang (* (atan cbul) 4.0))
                          (setq mido (polar lpnt cang (/ clen 2.0)))
                          (setq rads (/ clen (* 2.0 (sin (/ iang 2.0)))))
                          (setq tfac (- rads (* rads (- 1 (cos (/ iang 2.0))))))
                          (setq cctr (polar mido (+ cang (/ pi 2.0)) tfac))
                          (setq mpnt (polar cctr (angle cctr mido) (abs rads)))
                        )
                      )
                      (setq lst (cons mpnt lst))
                      (setq lrec crec)
                    )
                    (setq axo (vlax-ename->vla-object hnd))
                    (vla-getboundingbox axo 'minpt 'maxpt)
                    (setq minpt (vlax-safearray->list minpt))
                    (setq maxpt (vlax-safearray->list maxpt))
                    (entdel hnd)
                    (setq minpt (dstp_2dpoint minpt))
                    (setq maxpt (dstp_2dpoint maxpt))
                    (setq sset (ssget "_C" minpt maxpt))
                    (setq epl nil)
                    (foreach pnt lst
                      (setq res (nentselp pnt))
                      (if (/= res nil)
                        (progn
                          (setq hnd (car res))
                          (setq axo (vlax-ename->vla-object hnd))
                          (setq bpt (vlax-curve-getStartPoint axo))
                          (setq epl (cons bpt epl))
                          (setq ept (vlax-curve-getEndPoint axo))
                          (setq epl (cons ept epl))
                        )
                      )
                    )
                    (setq tol nil)
                    (foreach bpt epl
                      (foreach ept epl
                        (if (not (equal ept bpt))
                          (foreach tpt lst
                            (if (equal (angle bpt ept)(angle bpt tpt) 0.05)
                              (if (equal (/ (distance bpt ept) 2.0)(distance bpt tpt) (* (distance bpt tpt) 0.001))
                                (if (not (member tpt tol))
                                  (setq tol (cons tpt tol))
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    (foreach tpt tol
                      (setq lst (dstp_remove tpt lst))
                    )
                    (setq new nil)
                    (foreach fpnt lst
                      (setq fpnt (polar ppnt (angle ppnt fpnt)(* (distance ppnt fpnt) 1.1)))
                      (setq new (cons fpnt new))
                    )
                    (setq lst new)
                    (command "_.TRIM" sset "" "_F")
                    (foreach fpnt lst
                      (command ppnt)
                      (command fpnt)
                    )
                    (command ppnt)
                    (command "")
                    (command "")
                    (if (= pjs 1)
                      (progn
                        (setq sset (ssget "_C" minpt maxpt))
                        (setq num (sslength sset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname sset itm))
                          (setq ent (entget hnd))
                          (setq obj (cdr (assoc 0 ent)))
                          (if (or (= obj "ARC")(= obj "LINE"))
                            (if (= (getvar "PEDITACCEPT") 0)
                              (command "_.PEDIT" hnd "_Y" "")
                              (command "_.PEDIT" hnd "")
                            )
                          )
                          (setq itm (1+ itm))
                        )
                        (setq ctr -1)
                        (repeat 10
                          (setq sset (ssget "_C" minpt maxpt))
                          (setq ctr (1+ ctr))
                          (if (>= ctr (sslength sset))
                            (setq ctr 0)
                          )
                          (setq pass T)
                          (setq ent (entget (ssname sset ctr)))
                          (if (= (cdr (assoc 0 ent)) "LWPOLYLINE")
                            (if (= (boole 1 (cdr (assoc 70 ent)) 1) 1)
                              (setq pass nil) ; closed polyline
                            )
                          )
                          (if (= pass T)
                            (command "_.PEDIT" (ssname sset ctr) "_J" sset "" "_X")
                          )
                        )
                      )
                    )
                  )
                )
              )
              (setq miss T)
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
      (setvar "CMDECHO" cmdecho)
      (setq *error* olderr)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Trim & Erase Inside of Circles
; --------------------------------------------------------------------------

(defun c:ObjClnCir (/ cc cmdecho cpnt ctr edg ent hnd itm llcp lpt lst
                        maxrad minrad num ofd osmode rads rtmp sset tmp urcp vs)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget "_I" '((0 . "CIRCLE"))))
      (if (= sset nil)
        (setq sset (ssget '((0 . "CIRCLE"))))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if sset
        (progn
          (if (= minrad nil)(setq minrad 0.0))
          (setq tmp (getdist (strcat "\nDS> Minimum Radius <" (rtos minrad 2 2) ">: ")))
          (if (/= tmp nil)(setq minrad tmp))
          (if (= maxrad nil)(setq maxrad 10000.0))
          (setq tmp (getdist (strcat "\nDS> Maximum Radius <" (rtos maxrad 2 2) ">: ")))
          (if (/= tmp nil)(setq maxrad tmp))
          (setq num (sslength sset) itm 0)
          (setq cc (getvar "VIEWCTR"))
          (setq vs (getvar "VIEWSIZE"))
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq rads (cdr (assoc 40 ent)))
            (if (>= rads minrad)
              (if (<= rads maxrad)
                (progn
                  (setq cpnt (list (nth 1 (assoc 10 ent)) (nth 2 (assoc 10 ent))))
                  (setq rtmp (* rads 1.1))
                  (setq llcp (list (- (car cpnt) rtmp)(- (cadr cpnt) rtmp)))
                  (setq urcp (list (+ (car cpnt) rtmp)(+ (cadr cpnt) rtmp)))
                  (command "_.ZOOM" "_W" llcp urcp)
                  (entupd hnd)
                  (setq osmode (getvar "OSMODE"))
                  (setvar "OSMODE" 0)
                  (setq ofd (/ (getvar "VIEWSIZE") 200.0))
                  (command "_.OFFSET" ofd hnd cpnt "")
                  (setq edg (entlast))
                  (setq lst (dstp_obj2lst edg))
                  (entdel edg)
                  (setq tmp (ssget "_WP" lst))
                  (if tmp      
                    (command "_.ERASE" tmp "")
                  )
                  (command "_.TRIM" hnd "")
                  (repeat 1
                    (setq ctr 0)
                    (foreach cpt lst
                      (if (> ctr 0)
                        (command "_F" lpt cpt "")
                      )
                      (setq lpt cpt)
                      (setq ctr (1+ ctr))
                    )
                  )
                  (command "")
                )
              )
            )
            (setvar "OSMODE" osmode)
            (setq itm (1+ itm))
          )
          (command "_.ZOOM" "_C" cc vs)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Trim By Object, Fence Walk Points
; --------------------------------------------------------------------------

(defun c:ObjTrmObj (/ cc cmdecho ctr dozoom edg ent hnd hs lpt lst maxx
                        maxy minx miny new obj ofd ofp osmode rep spt ss
                        sx1 sx2 sy1 sy2 tmp vs xcd ycd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq rep (getint "\nDS> Number of Passes <3>: "))
      (if (= rep nil)(setq rep 3))
      (setq tmp (entsel "\nDS> Select Cutting Edge Object: "))
      (if (/= tmp nil)
        (progn
          (setq hnd (car tmp))
          (setq spt (cdr tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setq ofd (/ (getvar "VIEWSIZE") 200.0))
          (setq ofp (getpoint "\nDS> Pick Point on Side to Trim: "))
          (command "_.OFFSET" ofd tmp ofp "")
          (setq edg (entlast))
          (setq lst (dstp_obj2lst edg))
          (setq tmp nil)
          (foreach pnt lst
            (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
            (setq tmp (append tmp (list new)))
          )
          (setq lst tmp)
          (entdel edg)
          (if (< (length lst) 2)
            (princ "\nDS> Not a Valid Object for Auto Trimming.")
            (progn
              (setq minx 999999999999.9)
              (setq miny 999999999999.9)
              (setq maxx -999999999999.9)
              (setq maxy -999999999999.9)
              (foreach pnt lst
                (setq xcd (car pnt))
                (setq ycd (cadr pnt))
                (if (> xcd maxx)(setq maxx xcd))
                (if (< xcd minx)(setq minx xcd))
                (if (> ycd maxy)(setq maxy ycd))
                (if (< ycd miny)(setq miny ycd))
              )
              (setq ss (getvar "SCREENSIZE"))
              (setq cc (getvar "VIEWCTR"))
              (setq vs (getvar "VIEWSIZE"))
              (setq hs (/ vs (/ (cadr ss) (car ss))))
              (setq sx1 (- (car cc) (/ hs 2)))
              (setq sy1 (- (cadr cc) (/ vs 2)))
              (setq sx2 (+ (car cc) (/ hs 2)))
              (setq sy2 (+ (cadr cc) (/ vs 2)))
              (setq dozoom nil)
              (if (< minx sx1)(setq dozoom T))
              (if (> maxx sx2)(setq dozoom T))
              (if (< miny sy1)(setq dozoom T))
              (if (> maxy sy2)(setq dozoom T))
              (if (= dozoom T)
                (command "_.ZOOM" "_W" (list minx miny) (list maxx maxy))
              )
              (command "_.TRIM" hnd "")
              (repeat rep
                (setq ctr 0)
                (foreach cpt lst
                  (setq cpt (dstp_2dpoint cpt))
                  (if (> ctr 0)
                    (command "_F" lpt cpt "")
                  )
                  (setq lpt cpt)
                  (setq ctr (1+ ctr))
                )
              )
              (command "")
            )
          )
          (setvar "OSMODE" osmode)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                            Control Object Visibility
; --------------------------------------------------------------------------

(defun c:ObjVisCon (/ cmdecho done ent g60 hnd itm num opt sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq done nil)
      (if (< (getvar "EXPERT") 5)
        (alert "Warning: Objects hidden with ToolPac's Object Hide\ncan only be made visible again with ToolPac's\nObject Unhide or another routine able to manipulate\na objects group 60 value.\n\nSetting EXPERT to 5 disables this dialog.")
      )
      (while (/= done T)
        (initget "B R H U")
        (setq opt (getkword "\nDS> Blank/Redrawall/Hide/Unhideall: "))
        (cond
          ((= opt "B")
            (princ (strcat "\nDS> Select Objects to Blank out..."))
            (setq sset (ssget))
            (if sset
              (progn
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                  (setq hnd (ssname sset itm))
                  (redraw hnd 2)
                  (setq itm (1+ itm))
                )
                (princ ", Done.")
                (princ (strcat "\nDS> Regeneration also restores blanked objects."))
              )
            )
          )
          ((= opt "R")
            (setq sset (ssget "_X"))
            (if sset
              (progn
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                  (setq hnd (ssname sset itm))
                  (redraw hnd 1)
                  (setq itm (1+ itm))
                )
                (princ ", Done.")
              )
            )
          )
          ((= opt "H")
            (princ (strcat "\nDS> Select Objects to Hide..."))
            (setq sset (ssget))
            (if sset
              (progn
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq g60 (assoc 60 ent))
                  (if (/= g60 nil)
                    (setq ent (subst (cons 60 1)(assoc 60 ent) ent))
                    (setq ent (append ent (list (cons 60 1))))
                  )
                  (entmod ent)
                  (setq itm (1+ itm))
                )
                (princ ", Done.")
              )
            )
          )
          ((= opt "U")
            (setq sset (ssget "_X" '((60 . 1))))
            (if sset
              (progn
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq ent (subst (cons 60 0)(assoc 60 ent) ent))
                  (entmod ent)
                  (setq itm (1+ itm))
                )
                (princ ", Done.")
              )
            )
          )
          (t
            (setq done T)
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;               Selection Set inside/crossing BufferFence
; --------------------------------------------------------------------------

(defun c:ObjSelBuf (/ ang bset chk cmdecho def done edg ent fset hnd
                         itm lan las lls lpt lst mth num olt ort ptlst
                         ran rls rpt tset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq done nil)
      (princ "\nDS> Select Centeline Objects to Use ...")
      (setq bset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "LINE")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "SPLINE")(-4 . "OR>"))))
      (if bset
        (progn
          (setq def (dstp_regfetch "General" "offsetlt" "0.0"))
          (setq chk (getdist (strcat "\nDS> Offset Distance to Left <" def ">: ")))
          (if (= chk nil)(setq olt (distof def))(setq olt chk))
          (dstp_regstore "General" "offsetlt" (rtos olt))
          (setq def (dstp_regfetch "General" "offsetrt" "0.0"))
          (setq chk (getdist (strcat "\nDS> Offset Distance to Right <" def ">: ")))
          (if (= chk nil)(setq ort (distof def))(setq ort chk))
          (dstp_regstore "General" "offsetrt" (rtos ort))
          (if (and (= olt 0.0)(= ort 0.0))
            (princ "\nDS> Both Offsets equal 0.0, nothing to do!")
            (progn
              (initget "W C")
              (setq def (dstp_regfetch "General" "bufsel" "W"))
              (if (= def "W")
                (progn
                  (setq chk (getkword "\nDS> Select Crossing/<Within>: "))
                  (if (= chk nil)(setq mth "W")(setq mth chk))
                )
                (progn
                  (setq chk (getkword "\nDS> Select Withing/<Crossing>: "))
                  (if (= chk nil)(setq mth "C")(setq mth chk))
                )
              )
              (dstp_regstore "General" "bufsel" mth)
              (if (= olt 0.0)(setq olt 0.00000001))
              (if (= ort 0.0)(setq ort 0.00000001))
              (setq itm 0)
              (setq fset (ssadd))
              (setq num (sslength bset))
              (while (< itm num)
                (setq hnd (ssname bset itm))
                (setq ent (entget hnd))
                (setq ptlst (dstp_obj2lst hnd))
                (setq ang (angle (nth 0 ptlst)(nth 1 ptlst)))
                (setq lan (+ ang (/ pi 2.0)))
                (setq ran (+ lan pi))
                (setq lpt (polar (nth 0 ptlst) lan 0.1))
                (setq rpt (polar (nth 0 ptlst) ran 0.1))
                (command "_.OFFSET" olt hnd lpt "")
                (setq edg (entlast))
                (setq lls (dstp_obj2lst edg))
                (entdel edg)
                (command "_.OFFSET" ort hnd rpt "")
                (setq edg (entlast))
                (setq rls (dstp_obj2lst edg))
                (entdel edg)
                (setq lst (append lls (reverse rls)))
                (setq las nil)
                (foreach pnt lst
                  (if (/= las nil)
                    (grdraw las pnt 1 1)
                  )
                  (setq las pnt)
                )
                (grdraw (last lst)(car lst) 1 1)
                (if (= mth "W")
                  (setq tset (ssget "_WP" lst))
                  (setq tset (ssget "_CP" lst))
                )
                (if (/= tset nil)
                  (progn
                    (setq lst (dstp_ss2lst tset))
                    (foreach hnd lst
                      (if (not (ssmemb hnd fset))
                        (setq fset (ssadd hnd fset))
                      )
                    )
                  )
                )
                (setq itm (1+ itm))
              )
              (if (> (sslength fset) 0)
                (sssetfirst fset fset)
              )
              (princ "\nDS> Use REDRAW to remove temporary buffer marks")
            )
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;               Select Object Within/Crossing/Fenced Object
; --------------------------------------------------------------------------

(defun c:ObjSelCro () (dstp_objselobj "cp"))
(defun c:ObjSelFnc () (dstp_objselobj "f"))
(defun c:ObjSelIns () (dstp_objselobj "wp"))

(defun dstp_objselobj (opt / add cmdecho done ent hnd itm new nset num ptlst
                            sset tmp zhnd zitm znum)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq done nil)
      (princ "\nDS> Select Objects to Use ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "LINE")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "SPLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq itm 0)
          (setq nset (ssadd))
          (setq num (sslength sset))
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq ptlst (dstp_obj2lst hnd))
            (setq tmp nil)
            (foreach pnt ptlst
              (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
              (setq tmp (append tmp (list new)))
            )
            (setq ptlst tmp)
            (setq add (ssget (strcat "_" opt) ptlst))
            (if (/= add nil)
              (progn
                (setq zitm 0)
                (setq znum (sslength add))
                (while (< zitm znum)
                  (setq zhnd (ssname add zitm))
                  (setq nset (ssadd zhnd nset))
                  (setq zitm (1+ zitm))
                )
              )
            )
            (setq itm (1+ itm))
          ) 
          (if (> (sslength nset) 0)
            (progn
              (setq itm 0)
              (setq num (sslength sset))
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (ssdel hnd nset)
                (setq itm (1+ itm))
              )
            )
          )
          (if (> (sslength nset) 0)
            (sssetfirst nset nset)
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Select by Object Type
; --------------------------------------------------------------------------

(defun c:ObjSelTyp (/ cmdecho ent hnd itm lay lyc num obj sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (initget "Y N")
      (setq tmp (getkword "\nDS> Consider Layer Y/<N>: "))
      (if (= tmp "Y")(setq lyc "Y")(setq lyc "N"))
      (setq tmp (entsel "\nDS> Select Object Type: "))
      (if (/= tmp nil)
        (progn
          (setq hnd (car tmp))
          (setq ent (entget hnd))
          (setq obj (cdr (assoc 0 ent)))
          (setq lay (cdr (assoc 8 ent)))
          (if (= lyc "Y")
            (setq sset (ssget "_X" (list (cons 0 obj)(cons 8 lay))))
            (setq sset (ssget "_X" (list (cons 0 obj))))
          )
          (if (> (sslength sset) 0)
            (sssetfirst sset sset)
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                    Snap Object Coordinates to Grid
; --------------------------------------------------------------------------

(defun c:ObjSnpAdj (/ add ang cmdecho cnt cpt done ent g10 g11 g12 g13
                        gix giy giz gridunit hnd ifx ify inh inv itm mth
                        n10 n11 n12 n13 nen new nhd npt npt1 npt2 npx npy
                        num obj opt opt1 opt2 osmode pass per ptlst ptx
                        pty rad rchk rdis ret rex rey rfnd rhnd ritm rlst
                        rnum rset sset tmp x11 x12 xsc y11 y12 ysc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun snapadj_calcpnt (pnt)
        (cond
          ((= mth "G")
            (setq ptx (car pnt))
            (if (/= ptx 0.0)
              (progn
                (setq ifx (fix (/ ptx gix)))
                (setq npx (* ifx gix))
                (setq rex (rem ptx gix))
                (setq per (/ rex gix))
                (cond
                  ((< per -0.5)
                    (setq npx (- npx gix))
                  )
                  ((> per 0.5)
                    (setq npx (+ npx gix))
                  )
                  (t nil)
                )
              )
              (setq npx 0.0)
            )
            (setq pty (cadr pnt))
            (if (/= pty 0.0)
              (progn
                (setq ify (fix (/ pty giy)))
                (setq npy (* ify giy))
                (setq rey (rem pty giy))
                (setq per (/ rey giy))
                (cond
                  ((< per -0.5)
                    (setq npy (- npy giy))
                  )
                  ((> per 0.5)
                    (setq npy (+ npy giy))
                  )
                  (t nil)
                )
              )
              (setq npy 0.0)
            )
            (if (= (length pnt) 3)
              (setq ret (list npx npy giz))
              (setq ret (list npx npy))
            )
          )
          ((= mth "N")
            ;(setq pnt (dstp_2dpoint pnt))
            (setq ang 0.0)
            (setq inv 15.0)
            (setq cnt (- (fix (/ 360.0 inv)) 1))
            (setq ptlst nil)
            (repeat cnt
              (setq add (polar pnt (dstp_dtr ang) rad))
              (setq ptlst (append ptlst (list add)))
              (setq ang (+ ang inv))
            )
            (setq rset (ssget "_CP" ptlst '((-4 . "<OR")(0 . "CIRCLE")(0 . "INSERT")(0 . "POINT")(-4 . "OR>"))))
            (if (/= rset nil)
              (progn
                (if (member hnd (dstp_ss2lst rset))
                  (setq rset (ssdel hnd rset))
                )
                (setq rfnd nil)
                (setq rdis 9999999.99)
                (setq rnum (sslength rset) ritm 0)
                (while (< ritm rnum)
                  (setq rhnd (ssname rset ritm))
                  (setq rlst (dstp_obj2lst rhnd))
                  (foreach rpnt rlst
                    (setq rchk (distance (dstp_2dpoint pnt) (dstp_2dpoint rpnt)))
                    (if (> rchk 0.0)
                      (if (< rchk rdis)
                        (setq rfnd rpnt rdis rchk)
                      )
                    )
                  )
                  (setq ritm (1+ ritm))
                )
                (if (/= rfnd nil)
                  (if (= (length pnt) 3)
                    (setq ret rfnd)
                    (setq ret (list (nth 0 rfnd)(nth 1 rfnd)))
                  )
                )
              )
            )
          )
          (t nil)
        )
        (setq tmp ret)
      )
      (setq pass T)
      (initget "G N")
      (setq mth (getkword "\nDS> Snap to AutoCAD Grid or Nodal Objects <G>/N: "))
      (if (= mth nil)(setq mth "G"))
      (cond
        ((= mth "G")
          (setq gridunit (getvar "GRIDUNIT"))
          (setq gix (car gridunit))
          (setq giy (cadr gridunit))
          (setq giz (getvar "ELEVATION"))
          (if (or (= gix 0.0)(= giy 0.0))
            (progn
              (princ "\nDS> Grid units cannot have 0 values!")
              (setq pass nil)
            )
            (progn
              (princ (strcat "\nDS> Grid Settings - X:" (rtos gix) "  Y:" (rtos giy) "  Z:" (rtos giz)))
              (princ "\nDS> Use GRID command to make changes!")
              (setq sset (ssget '((-4 . "<OR")(0 . "3DFACE")(0 . "ARC")(0 . "ATTDEF")(0 . "CIRCLE")(0 . "DIMENSION")(0 . "ELLIPSE")(0 . "HATCH")(0 . "IMAGE")(0 . "INSERT")(0 . "LEADER")(0 . "LINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "MTEXT")(0 . "POINT")(0 . "POLYLINE")(0 . "SOLID")(0 . "SPLINE")(0 . "TEXT")(-4 . "OR>"))))
            )
          )
        )
        ((= mth "N")
          (setq rad (getdist "\nDS> Search Radius <1.0>: "))
          (if (= rad nil)(setq rad 1.0))
          (setq sset (ssget '((-4 . "<OR")(0 . "3DFACE")(0 . "ATTDEF")(0 . "DIMENSION")(0 . "HATCH")(0 . "IMAGE")(0 . "LEADER")(0 . "LINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "MTEXT")(0 . "POLYLINE")(0 . "SOLID")(0 . "SPLINE")(0 . "TEXT")(-4 . "OR>"))))
        )
        (t nil)
      )
      (if (= pass T)
        (if sset
          (progn
            (setq osmode (getvar "OSMODE"))
            (setvar "OSMODE" 0)
            (setq cmdecho (getvar "CMDECHO"))
            (setvar "CMDECHO" 0)
            (command "_.UNDO" "_G")
            (dstp_ucspush)
            (setq itm 0 num (sslength sset))
            (princ "\nDS>")
            (while (< itm num)
              (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd))
              (setq obj (cdr (assoc 0 ent)))
              (if (= mth "N")
                (if (/= (assoc 38 ent) nil)
                  (setq giz (cdr (assoc 38 ent)))
                )
              )
              (cond
                ((= obj "3DFACE")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq g11 (cdr (assoc 11 ent)))
                  (setq g12 (cdr (assoc 12 ent)))
                  (setq g13 (cdr (assoc 13 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq n11 (snapadj_calcpnt g11))
                  (setq n12 (snapadj_calcpnt g12))
                  (setq n13 (snapadj_calcpnt g13))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (setq ent (subst (cons 11 n11)(assoc 11 ent) ent))
                  (setq ent (subst (cons 12 n12)(assoc 12 ent) ent))
                  (setq ent (subst (cons 13 n13)(assoc 13 ent) ent))
                  (entmod ent)
                )
                ((= obj "ARC")
                  (setq cpt (cdr (assoc 10 ent)))
                  (setq npt (snapadj_calcpnt cpt))
                  (setq ent (subst (cons 10 npt)(assoc 10 ent) ent))
                  (entmod ent)
                )
                ((= obj "ATTDEF")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq g11 (cdr (assoc 11 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq n11 (snapadj_calcpnt g11))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (setq ent (subst (cons 11 n11)(assoc 11 ent) ent))
                  (entmod ent)
                )
                ((= obj "CIRCLE")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (entmod ent)
                )
                ((= obj "DIMENSION")
                  (setq new nil)
                  (foreach rec ent
                    (if (= (car rec) 10)
                      (setq rec (cons 10 (snapadj_calcpnt (cdr rec))))
                    )
                    (if (= (car rec) 11)
                      (setq rec (cons 11 (snapadj_calcpnt (cdr rec))))
                    )
                    (if (= (car rec) 13)
                      (setq rec (cons 13 (snapadj_calcpnt (cdr rec))))
                    )
                    (if (= (car rec) 14)
                      (setq rec (cons 14 (snapadj_calcpnt (cdr rec))))
                    )
                    (setq new (cons rec new))
                  )
                  (entmod (reverse new))
                  (entupd hnd)
                )
                ((= obj "ELLIPSE")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (command "_.MOVE" hnd "" g10 n10)
                )
                ((= obj "HATCH")
                  (setq ent (subst (cons 38 giz)(assoc 38 ent) ent))
                  (setq new nil)
                  (foreach rec ent
                    (if (= (car rec) 10)
                      (setq rec (cons 10 (snapadj_calcpnt (cdr rec))))
                    )
                    (if (= (car rec) 11)
                      (setq rec (cons 11 (snapadj_calcpnt (cdr rec))))
                    )
                    (setq new (cons rec new))
                  )
                  (entmod (reverse new))
                )
                ((= obj "IMAGE")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (setq g11 (cdr (assoc 11 ent)))
                  (setq g12 (cdr (assoc 12 ent)))
                  (setq x11 (car g11))
                  (setq y11 (cadr g11))
                  (setq n11 (list (* x11 xsc)(* y11 ysc)(nth 2 g11)))
                  (setq x12 (car g12))
                  (setq y12 (cadr g12))
                  (setq n12 (list (* x12 xsc)(* y12 ysc)(nth 2 g12)))
                  (setq ent (subst (cons 11 n11)(assoc 11 ent) ent))
                  (setq ent (subst (cons 12 n12)(assoc 12 ent) ent))
                  (entmod ent)
                )
                ((= obj "INSERT")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (command "_.MOVE" hnd "" g10 n10)
                )
                ((= obj "LEADER")
                  (setq new nil)
                  (foreach rec ent
                    (if (= (car rec) 10)
                      (setq rec (cons 10 (snapadj_calcpnt (cdr rec))))
                    )
                    (setq new (cons rec new))
                  )
                  (entmod (reverse new))
                )
                ((= obj "LINE")
                  (setq opt1 (cdr (assoc 10 ent)))
                  (setq npt1 (snapadj_calcpnt opt1))
                  (setq opt2 (cdr (assoc 11 ent)))
                  (setq npt2 (snapadj_calcpnt opt2))
                  (setq ent (subst (cons 10 npt1)(assoc 10 ent) ent))
                  (setq ent (subst (cons 11 npt2)(assoc 11 ent) ent))
                  (entmod ent)
                )
                ((= obj "LWPOLYLINE")
                  (setq ent (subst (cons 38 giz)(assoc 38 ent) ent))
                  (setq new nil)
                  (foreach rec ent
                    (if (= (car rec) 10)
                      (setq rec (cons 10 (snapadj_calcpnt (cdr rec))))
                    )
                    (setq new (cons rec new))
                  )
                  (entmod (reverse new))
                )
                ((= obj "MLINE")
                  (setq new nil)
                  (foreach rec ent
                    (if (= (car rec) 10)
                      (setq rec (cons 10 (snapadj_calcpnt (cdr rec))))
                    )
                    (if (= (car rec) 11)
                      (setq rec (cons 11 (snapadj_calcpnt (cdr rec))))
                    )
                    (setq new (cons rec new))
                  )
                  (entmod (reverse new))
                )
                ((= obj "MTEXT")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (entmod ent)
                )
                ((= obj "POINT")
                  (setq opt (cdr (assoc 10 ent)))
                  (setq npt (snapadj_calcpnt opt))
                  (setq ent (subst (cons 10 npt)(assoc 10 ent) ent))
                  (entmod ent)
                )
                ((= obj "POLYLINE")
                  (setq nhd hnd)
                  (setq done nil)
                  (while (/= done T)
                    (setq nhd (entnext nhd))
                    (setq nen (entget nhd))
                    (if (= "VERTEX" (cdr (assoc 0 nen)))
                      (progn
                        (setq g10 (cdr (assoc 10 nen)))
                        (setq n10 (snapadj_calcpnt g10))
                        (setq nen (subst (cons 10 n10)(assoc 10 nen) nen))
                        (entmod nen)
                      )
                    )
                    (if (= "SEQEND" (cdr (assoc 0 nen)))
                      (setq done T)
                    )
                  )
                  (entupd hnd)
                )
                ((= obj "SOLID")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq g11 (cdr (assoc 11 ent)))
                  (setq g12 (cdr (assoc 12 ent)))
                  (setq g13 (cdr (assoc 13 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq n11 (snapadj_calcpnt g11))
                  (setq n12 (snapadj_calcpnt g12))
                  (setq n13 (snapadj_calcpnt g13))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (setq ent (subst (cons 11 n11)(assoc 11 ent) ent))
                  (setq ent (subst (cons 12 n12)(assoc 12 ent) ent))
                  (setq ent (subst (cons 13 n13)(assoc 13 ent) ent))
                  (entmod ent)
                )
                ((= obj "SPLINE")
                  (setq new nil)
                  (foreach rec ent
                    (if (= (car rec) 10)
                      (setq rec (cons 10 (snapadj_calcpnt (cdr rec))))
                    )
                    (if (= (car rec) 11)
                      (setq rec (cons 11 (snapadj_calcpnt (cdr rec))))
                    )
                    (setq new (cons rec new))
                  )
                  (entmod (reverse new))
                )
                ((= obj "TEXT")
                  (setq g10 (cdr (assoc 10 ent)))
                  (setq g11 (cdr (assoc 11 ent)))
                  (setq n10 (snapadj_calcpnt g10))
                  (setq n11 (snapadj_calcpnt g11))
                  (setq ent (subst (cons 10 n10)(assoc 10 ent) ent))
                  (setq ent (subst (cons 11 n11)(assoc 11 ent) ent))
                  (entmod ent)
                )
                (t nil)
              )
              (setq itm (1+ itm))
            )
            (princ ", Done.")
            (dstp_ucspop)
            (command "_.UNDO" "_E")
            (setvar "OSMODE" osmode)
            (setvar "CMDECHO" cmdecho)
            (setq sset nil)
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Snap Nodal Objects to Nearest Found
; --------------------------------------------------------------------------

(defun c:ObjSnpNod (/ 3dp add ang cmdecho cnt edif ent hnd inh inv itm nel
                        npt num oel osmode pnt ptlst rad rchk rdis rfnd rhnd
                        ritm rlst rnum rpnt rset sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(0 . "INSERT")(0 . "POINT")(-4 . "OR>"))))
      (if (= sset nil)
        (progn
          (princ "\nDS> Select Arc, Circle, Insert, or Point Objects ...")
          (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(0 . "INSERT")(0 . "POINT")(-4 . "OR>"))))
        )
      )
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq rad (getdist "\nDS> Search Radius <1.0>: "))
          (if (= rad nil)(setq rad 1.0))
          (setq inh (strcase (getstring "\nDS> Inherit Values <XYZ>: ")))
          (if (= inh "")(setq inh "XYZ"))
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq pnt (dstp_2dpoint (cdr (assoc 10 ent))))
            (setq oel (nth 3 (assoc 10 ent)))
            (setq ang 0.0)
            (setq inv 15.0)
            (setq cnt (- (fix (/ 360.0 inv)) 1))
            (setq ptlst nil)
            (repeat cnt
              (setq add (polar pnt (dstp_dtr ang) rad))
              (setq ptlst (append ptlst (list add)))
              (setq ang (+ ang inv))
            )
            (setq rset (ssget "_CP" ptlst))
            (if (/= rset nil)
              (progn
                (if (member hnd (dstp_ss2lst rset))
                  (setq rset (ssdel hnd rset))
                )
                (setq rfnd nil)
                (setq rdis 9999999.99)
                (setq rnum (sslength rset) ritm 0)
                (while (< ritm rnum)
                  (setq rhnd (ssname rset ritm))
                  (setq rlst (dstp_obj2lst rhnd))
                  (foreach rpnt rlst
                    (setq rchk (distance pnt rpnt))
                    (if (> rchk 0.0)
                      (if (< rchk rdis)
                        (setq rfnd rpnt rdis rchk)
                      )
                    )
                  )
                  (setq ritm (1+ ritm))
                )
                (if (/= rfnd nil)
                  (progn
                    (if (dstp_instr inh "X")
                      (progn
                        (setq npt (list (nth 0 rfnd)(nth 1 pnt)))
                        (command "_.MOVE" hnd "" pnt npt)
                        (setq pnt npt)
                      )
                    )
                    (if (dstp_instr inh "Y")
                      (progn
                        (setq npt (list (nth 0 pnt)(nth 1 rfnd)))
                        (command "_.MOVE" hnd "" pnt npt)
                        (setq pnt npt)
                      )
                    )
                    (if (dstp_instr inh "Z")
                      (progn
                        (command "_.ERASE" hnd "")
                        (setq 3dp (setq rpnt (osnap rfnd "_nea")))
                        (command "_.UNDO" "1")
                        (if (/= 3dp nil)
                          (progn
                            (setq nel (nth 2 3dp))
                            (setq edif (- nel oel))
                            (if (/= edif 0.0)
                              (command "_.MOVE" hnd "" "0,0,0" (strcat "@0,0," (rtos edif 2 8)))
                            )
                          )
                          (progn
                            (setq nel (nth 2 rfnd))
                            (setq edif (- nel oel))
                            (if (/= edif 0.0)
                              (command "_.MOVE" hnd "" "0,0,0" (strcat "@0,0," (rtos edif 2 8)))
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
            (setq rset nil)
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (command "_.SELECT" sset "")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
          (setvar "OSMODE" osmode)
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                          XDATA Inherited from AutoCELL
; --------------------------------------------------------------------------

(defun c:ObjXdaMan (/ $value anam anum astr attent atthnd atttag aval bld blk
                      blkchg blkent blkhnd chk cmdecho cnt dat dcl_id dianam
                      done doproc eed ent fh fld fn fnd hdr hnd itm itmfld
                      lst lstr nam namfld namlst namsel new nitm nnum nset
                      num old ovl pos ptlst rec rep rstr snam spos src srcent
                      srchnd srclst sset str sub sval tarent tarhnd tarlst tmp
                      tmplst trn tstr txt txtent txthnd use val valfld wrklst)
  (if (/= (dstp_isvalid) nil)
    (progn
      ;
      ; --- Number objects as selected
      ;
      (defun objxdata_num ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        ;
        (setq anam (getstring "\nDS> Field Name: "))
        (if (/= anam "")
          (progn
            (if (null (tblsearch "APPID" "DSTP_XDATA"))
              (regapp "DSTP_XDATA")
            )
            (setq anum (getint "\nDS> Starting Number <1>: "))
            (if (= anum nil)(setq anum 1))
            (setq done nil)
            (while (/= done T)
              (setq tmp (entsel (strcat "\nDS> Object to Add (" (itoa anum) "): ")))
              (if (= tmp nil)
                (setq done T)
                (progn
                  (setq hnd (car tmp))
                  (setq ent (entget hnd '("DSTP_XDATA")))
                  (setq chk (assoc -3 ent))
                  (if (= chk nil)
                    (setq lst nil)
                    (progn
                      (setq dat (cdr (nth 0 (cdr chk))))
                      (setq lst nil)
                      (foreach rec dat
                        (setq hdr (car rec))
                        (setq fld (cdr rec))
                        (if (= hdr 1000)
                          (setq lst (append lst (list fld)))
                        )
                      )
                    )
                  )
                  (setq astr (strcat (strcase anam) "=" (itoa anum)))
                  (setq tmp lst)
                  (setq lst nil)
                  (setq fnd nil)
                  (foreach str tmp
                    (setq pos (vl-string-position (ascii "=") str))
                    (setq nam (substr str 1 pos))
                    (setq val (substr str (+ pos 2) (- (strlen str) pos 1)))
                    (if (= (strcase nam) (strcase anam))
                      (progn
                        (setq str astr)
                        (setq fnd T)
                      )
                    )
                    (setq lst (cons str lst))
                  )
                  (if (= fnd nil)
                    (setq lst (cons astr lst))
                  )
                  (setq bld (list (cons 1002 "{")))
                  (foreach fil lst
                    (setq tmp (list (cons 1000 fil)))
                    (setq bld (append bld tmp))
                  )
                  (setq bld (append bld (list (cons 1002 "}"))))
                  (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
                  (if (= chk nil)
                    (setq ent (append ent (list eed)))
                    (setq ent (subst eed chk ent))
                  )
                  (entmod ent)
                  (setq anum (1+ anum))
                )
              )
            )
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Copy data from one object to selection set
      ;
      (defun objxdata_copy ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (initget "Y N")
        (setq trn (getkword "\nDS> Copy Field Names Only Y/<N>: "))
        (if (= trn nil)(setq trn "N"))
        (initget "Y N")
        (setq ovl (getkword "\nDS> Overlay Common Fields <Y>/N: "))
        (if (= ovl nil)(setq ovl "Y"))
        (if (null (tblsearch "APPID" "DSTP_XDATA"))
          (regapp "DSTP_XDATA")
        )
        (setq done nil)
        (while (/= done T)
          (setq src (entsel "\nDS> Source Object: "))
          (if (= src nil)
            (setq done T)
            (progn
              (setq srchnd (car src))
              (setq srcent (entget srchnd '("DSTP_XDATA")))
              (setq chk (assoc -3 srcent))
              (if (= chk nil)
                (alert "Source Object Contains No Data!")
                (progn
                  (princ "\nDS> Select Target Objects ...")
                  (setq sset (ssget))
                  (if (/= sset nil)
                    (progn
                      (setq srclst nil)
                      (setq dat (cdr (nth 0 (cdr chk))))
                      (foreach rec dat
                        (setq hdr (car rec))
                        (setq fld (cdr rec))
                        (if (= hdr 1000)
                          (setq srclst (append srclst (list fld)))
                        )
                      )
                      (princ "\nDS>")
                      (setq num (sslength sset) itm 0)
                      (while (< itm num)
                        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                        (setq wrklst nil)
                        (setq tarhnd (ssname sset itm))
                        (setq tarent (entget tarhnd '("DSTP_XDATA")))
                        (setq chk (assoc -3 tarent))
                        (if (= chk nil)
                          (setq tarlst nil)
                          (progn
                            (setq tarlst nil)
                            (setq dat (cdr (nth 0 (cdr chk))))
                            (foreach rec dat
                              (setq hdr (car rec))
                              (setq fld (cdr rec))
                              (if (= hdr 1000)
                                (setq tarlst (append tarlst (list fld)))
                              )
                            )
                          )
                        )
                        (setq wrklst tarlst)
                        (foreach sstr srclst
                          (setq spos (vl-string-position (ascii "=") sstr))
                          (setq snam (substr sstr 1 spos))
                          (setq sval (substr sstr (+ spos 2) (- (strlen sstr) spos 1)))
                          (setq fnd nil)
                          (foreach str wrklst
                            (setq pos (vl-string-position (ascii "=") str))
                            (setq nam (substr str 1 pos))
                            (setq val (substr str (+ pos 2) (- (strlen str) pos 1)))
                            (if (= (strcase nam) (strcase snam))
                              (setq fnd str)
                            )
                          )
                          (if (= trn "Y")
                            (setq astr (strcat snam "="))
                            (setq astr sstr)
                          )
                          (if (/= fnd nil)
                            (if (= ovl "Y")
                              (setq wrklst (subst astr fnd wrklst))
                            )
                            (setq wrklst (append wrklst (list astr)))
                          )
                        )
                        (setq bld (list (cons 1002 "{")))
                        (foreach fil wrklst
                          (setq tmp (list (cons 1000 fil)))
                          (setq bld (append bld tmp))
                        )
                        (setq bld (append bld (list (cons 1002 "}"))))
                        (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
                        (if (= chk nil)
                          (setq tarent (append tarent (list eed)))
                          (setq tarent (subst eed chk tarent))
                        )
                        (entmod tarent)
                        (setq itm (1+ itm))
                      )
                      (princ ", Done.")
                      (princ "\nDS> ===================================")
                    )
                  )
                )
              )
            )
          )
        )
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Acquire Pair String from Key & Picked text
      ;
      (defun objxdata_txt ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        (setq anam (getstring "\nDS> Field Name: "))
        (if (/= anam "")
          (progn
            (if (null (tblsearch "APPID" "DSTP_XDATA"))
              (regapp "DSTP_XDATA")
            )
            (setq done nil)
            (while (/= done T)
              (setq tmp (entsel "\nDS> Object to Acquire Attributes: "))
              (if (= tmp nil)
                (setq done T)
                (progn
                  (redraw (car tmp) 3)
                  (setq txt (entsel "\nDS> Select Text with Value: "))
                  (redraw (car tmp) 4)
                  (if (= txt nil)
                    (setq done T)
                    (progn
                      (setq txthnd (car txt))
                      (setq txtent (entget txthnd))
                      (setq hnd (car tmp))
                      (setq ent (entget hnd '("DSTP_XDATA")))
                      (setq chk (assoc -3 ent))
                      (if (= chk nil)
                        (setq lst nil)
                        (progn
                          (setq dat (cdr (nth 0 (cdr chk))))
                          (setq lst nil)
                          (foreach rec dat
                            (setq hdr (car rec))
                            (setq fld (cdr rec))
                            (if (= hdr 1000)
                              (setq lst (append lst (list fld)))
                            )
                          )
                        )
                      )
                      ;
                      (setq aval (cdr (assoc 1 txtent)))
                      (setq astr (strcat (strcase anam) "=" aval))
                      (setq tmp lst)
                      (setq lst nil)
                      (setq fnd nil)
                      (foreach str tmp
                        (setq pos (vl-string-position (ascii "=") str))
                        (setq nam (substr str 1 pos))
                        (setq val (substr str (+ pos 2) (- (strlen str) pos 1)))
                        (if (= (strcase nam) (strcase anam))
                          (progn
                            (setq str astr)
                            (setq fnd T)
                          )
                        )
                        (setq lst (cons str lst))
                      )
                      (if (= fnd nil)
                        (setq lst (cons astr lst))
                      )
                      (setq bld (list (cons 1002 "{")))
                      (foreach fil lst
                        (setq tmp (list (cons 1000 fil)))
                        (setq bld (append bld tmp))
                      )
                      (setq bld (append bld (list (cons 1002 "}"))))
                      (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
                      (if (= chk nil)
                        (setq ent (append ent (list eed)))
                        (setq ent (subst eed chk ent))
                      )
                      (entmod ent)
                    )
                  )
                )
              )
            )
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Acquire Pair String from Block Attributes
      ;
      (defun objxdata_blk ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        (initget "Y N")
        (setq trn (getkword "\nDS> Transfer Blank Values Y/<N>: "))
        (if (= trn nil)(setq trn "N"))
        (if (null (tblsearch "APPID" "DSTP_XDATA"))
          (regapp "DSTP_XDATA")
        )
        (setq done nil)
        (while (/= done T)
          (setq tmp (entsel "\nDS> Object to Acquire Attributes: "))
          (if (= tmp nil)
            (setq done T)
            (progn
              (redraw (car tmp) 3)
              (setq blk (entsel "\nDS> Block with Attributes: "))
              (redraw (car tmp) 4)
              (if (= blk nil)
                (setq done T)
                (progn
                  (setq cnt 0)
                  (setq blkhnd (car blk))
                  (setq blkent (entget blkhnd))
                  (if (or (/= (cdr (assoc 0 blkent)) "INSERT")(/= (cdr (assoc 66 blkent)) 1))
                    (setq done T)
                    (progn
                      (setq hnd (car tmp))
                      (setq ent (entget hnd '("DSTP_XDATA")))
                      (setq chk (assoc -3 ent))
                      (if (= chk nil)
                        (setq lst nil)
                        (progn
                          (setq dat (cdr (nth 0 (cdr chk))))
                          (setq lst nil)
                          (foreach rec dat
                            (setq hdr (car rec))
                            (setq fld (cdr rec))
                            (if (= hdr 1000)
                              (setq lst (append lst (list fld)))
                            )
                          )
                        )
                      )
                      (while (/= "SEQEND" (cdr (assoc 0 blkent)))
                        (setq blkhnd (entnext blkhnd))
                        (setq blkent (entget blkhnd))
                        (if (= (cdr (assoc 0 blkent)) "ATTRIB")
                          (progn
                            (setq anam (cdr (assoc 2 blkent)))
                            (setq aval (cdr (assoc 1 blkent)))
                            (setq astr (strcat (strcase anam) "=" aval))
                            (if (and (= trn "N")(= aval ""))
                              (setq tmp nil)
                              (progn
                                (setq tmp lst)
                                (setq lst nil)
                                (setq fnd nil)
                                (setq cnt (1+ cnt))
                                (foreach str tmp
                                  (setq pos (vl-string-position (ascii "=") str))
                                  (setq nam (substr str 1 pos))
                                  (setq val (substr str (+ pos 2) (- (strlen str) pos 1)))
                                  (if (= (strcase nam) (strcase anam))
                                    (progn
                                      (setq str astr)
                                      (setq fnd T)
                                    )
                                  )
                                  (setq lst (cons str lst))
                                )
                                (if (= fnd nil)
                                  (setq lst (cons astr lst))
                                )
                              )
                            )
                          )
                        )
                      )
                      (setq bld (list (cons 1002 "{")))
                      (foreach fil lst
                        (setq tmp (list (cons 1000 fil)))
                        (setq bld (append bld tmp))
                      )
                      (setq bld (append bld (list (cons 1002 "}"))))
                      (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
                      (if (= chk nil)
                        (setq ent (append ent (list eed)))
                        (setq ent (subst eed chk ent))
                      )
                      (entmod ent)
                      (princ (strcat "\nDS> [" (itoa cnt) "] Data Elements Transferred."))
                    )
                  )
                )
              )
            )
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Add/Update Pair String to Multiple Objects
      ;
      (defun objxdata_add ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        (setq lstr (strcase (getstring "\nDS> Field Name: ")))
        (setq rstr (getstring "\nDS> Field Value: " T))
        (setq tstr (strcat lstr "=" rstr))
        (if (/= tstr nil)
          (progn
            (if (null (tblsearch "APPID" "DSTP_XDATA"))
              (regapp "DSTP_XDATA")
            )
            (setq sset (ssget))
            (princ "\nDS>")
            (setq num (sslength sset) itm 0)
            (while (< itm num)
              (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd '("DSTP_XDATA")))
              (setq chk (assoc -3 ent))
              (if (= chk nil)
                (setq lst (list tstr))
                (progn
                  (setq dat (cdr (nth 0 (cdr chk))))
                  (setq lst nil)
                  (foreach rec dat
                    (setq hdr (car rec))
                    (setq fld (cdr rec))
                    (if (= hdr 1000)
                      (setq lst (append lst (list fld)))
                    )
                  )
                  (setq tmp lst)
                  (setq lst nil)
                  (setq fnd nil)
                  (foreach str tmp
                    (setq pos (vl-string-position (ascii "=") str))
                    (setq nam (substr str 1 pos))
                    (setq val (substr str (+ pos 2) (- (strlen str) pos 1)))
                    (if (= (strcase nam) (strcase lstr))
                      (progn
                        (setq str tstr)
                        (setq fnd T)
                      )
                    )
                    (setq lst (cons str lst))
                  )
                  (if (= fnd nil)
                    (setq lst (cons tstr lst))
                  )
                )
              )
              (setq bld (list (cons 1002 "{")))
              (foreach fil lst
                (setq tmp (list (cons 1000 fil)))
                (setq bld (append bld tmp))
              )
              (setq bld (append bld (list (cons 1002 "}"))))
              (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
              (if (= chk nil)
                (setq ent (append ent (list eed)))
                (setq ent (subst eed chk ent))
              )
              (entmod ent)
              (setq itm (1+ itm))
            )
            (princ ", Done.")
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Delete All Links on Selected Objects
      ;
      (defun objxdata_del ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        (princ (strcat "\nDS Select Objects to Remove Data ..."))
        (setq sset (ssget '((-3 ("DSTP_XDATA")))))
        (if sset
          (progn
            (princ "\nDS> Removing XData from Objects ...")
            (princ "\nDS>")
            (setq num (sslength sset) itm 0)
            (while (< itm num)
              (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd '("DSTP_XDATA")))
              (setq chk (assoc -3 ent))
              (if (/= chk nil)
                (progn
                  (setq ent (subst '(-3 ("DSTP_XDATA")) (assoc -3 ent) ent))
                  (entmod ent)
                )
              )
              (setq itm (1+ itm))
            )
            (princ ", Done.")
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Find & Replace Link Data on Selected Objects
      ;
      (defun objxdata_rep ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        (setq sset (ssget '((-3 ("DSTP_XDATA")))))
        (if sset
          (progn
            (initget "K V")
            (setq use (getkword "\nDS> Search Key/<Value>: "))
            (if (= use nil)(setq use "V"))
            (setq fnd (getstring "\nDS> Find String: " T))
            (setq fnd (dstp_subtext fnd "\\" "/"))
            (setq rep (getstring "\nDS> Replacement: " T))
            (setq rep (dstp_subtext rep "\\" "/"))
            (if (and (= fnd "")(= rep ""))
              (princ "\nDS> Nothing to do.")
              (progn
                (princ "\nDS> Updating XData Records ...")
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd '("DSTP_XDATA")))
                  (setq chk (assoc -3 ent))
                  (if (/= chk nil)
                    (progn
                      (setq dat (cdr (nth 0 (cdr chk))))
                      (setq lst nil)
                      (foreach rec dat
                        (setq hdr (car rec))
                        (setq fld (cdr rec))
                        (if (= hdr 1000)
                          (setq lst (append lst (list fld)))
                        )
                      )
                      (setq tmp nil)
                      (foreach str lst
                        (setq pos (vl-string-position (ascii "=") str))
                        (setq nam (substr str 1 pos))
                        (setq val (substr str (+ pos 2) (- (strlen str) pos 1)))
                        (if (= use "V")
                          (if (/= (dstp_instr val fnd) nil)
                            (setq val (dstp_subtext val fnd rep))
                          )
                          (if (/= (dstp_instr nam fnd) nil)
                            (setq nam (dstp_subtext nam fnd rep))
                          )
                        )
                        (setq str (strcat nam "=" val))
                        (setq tmp (append tmp (list str)))
                      )
                      (setq lst tmp)
                      (setq bld (list (cons 1002 "{")))
                      (foreach fil lst
                        (setq tmp (list (cons 1000 fil)))
                        (setq bld (append bld tmp))
                      )
                      (setq bld (append bld (list (cons 1002 "}"))))
                      (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
                      (setq ent (subst eed chk ent))
                      (entmod ent)
                    )
                  )
                  (setq itm (1+ itm))
                )
                (princ ", Done.")
              )
            )
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Dialog Edit XData
      ;
      (defun xdatedit_clrnam ()
        (setq namfld "")
        (setq valfld "")
        (set_tile "namfld" (strcase namfld))
        (set_tile "valfld" valfld)
      )
      (defun xdatedit_dispnam ()
        (setq rec (nth namsel namlst))
        (set_tile "namfld" (strcase (car rec)))
        (set_tile "valfld" (cadr rec))
      )
      (defun xdatedit_tablnam ()
        (start_list "namlst")
        (foreach itm namlst
          (add_list (strcat (nth 0 itm) "\t" (nth 1 itm)))
        )
        (end_list)
      )
      (defun xdatedit_updnam ()
        (if (/= namlst nil)
          (progn
            (setq namfld (strcase (get_tile "namfld")))
            (setq valfld (get_tile "valfld"))
            (if (/= itmfld "")
              (progn
                (setq old (nth (atoi (get_tile "namlst")) namlst))
                (setq new (list namfld valfld))
                (setq namlst (subst new old namlst))
                (xdatedit_tablnam)
              )
            )
          )
        )
      )
      (defun xdatedit_addnam ()
        (setq namfld (strcase (get_tile "namfld")))
        (setq valfld (get_tile "valfld"))
        (setq fnd nil)
        (foreach rec namlst
          (if (= (strcase (car rec)) (strcase namfld))
            (setq fnd T)
          )
        )
        (if (= fnd T)
          (alert "Link Already Exists in List, Use Update!")
          (progn
            (setq namlst (append namlst (list (list namfld valfld))))
            (xdatedit_tablnam)
            (xdatedit_clrnam)
          )
        )
      )
      (defun xdatedit_delnam ()
        (if (/= namlst nil)
          (progn
            (setq old (nth (atoi (get_tile "namlst")) namlst))
            (setq tmplst namlst)
            (setq namlst nil)
            (foreach rec tmplst
              (if (/= rec old)
                (setq namlst (append namlst (list rec)))
              )
            )
            (xdatedit_tablnam)
            (xdatedit_clrnam)
          )
        )
      )
      (defun xdatedit_sortnam ()
        (if (> (length namlst) 1)
          (progn
            (setq tmp nil)
            (foreach itm namlst
              (setq tmp (append tmp (list (car itm))))
            )
            (setq tmp (acad_strlsort tmp))
            (setq new nil)
            (foreach itm tmp
              (setq new (append new (list (assoc itm namlst))))
            )
            (setq namlst new)
            (xdatedit_tablnam)
            (xdatedit_clrnam)
          )
        )
      )
      (defun xdatedit_loadlst ()
        (setq namlst
          (list
            (list "BMP" "PBRUSH")
            (list "TXT" "NOTEPAD")
          )
        )
        (setq fn (findfile (strcat dstpdir "Data\\OBJLINK.DAT")))
        (if (/= fn nil)
          (progn
            (setq fh (open fn "r"))
            (if (/= fh nil)
              (progn
                (princ "\nDS> Reading Association Data File ... ")
                (setq tmp (read-line fh))
                (setq tmp (read-line fh))
                (setq tmp (read-line fh))
                (setq namlst (read tmp))
                (setq tmp nil)
                (close fh)
                (princ "Done.")
              )
            )
          )
        )
      )
      (defun objxdata_edit ()
        (setq cmdecho (getvar "CMDECHO"))
        (setvar "CMDECHO" 0)
        (command "_.UNDO" "_G")
        (dstp_ucspush)
        (if (null (tblsearch "APPID" "DSTP_XDATA"))
          (regapp "DSTP_XDATA")
        )
        (setq tmp (entsel "\nDS> Select Object to Edit: "))
        (if (/= tmp nil)
          (progn
            (setq hnd (car tmp))
            (setq ent (entget hnd '("DSTP_XDATA")))
            (setq chk (assoc -3 ent))
            (if (= chk nil)
              (setq namlst nil)
              (progn
                (setq dat (cdr (nth 0 (cdr chk))))
                (setq namlst nil)
                (foreach rec dat
                  (setq hdr (car rec))
                  (setq fld (cdr rec))
                  (if (= hdr 1000)
                    (progn
                      (setq pos (vl-string-position (ascii "=") fld))
                      (setq nam (substr fld 1 pos))
                      (setq val (substr fld (+ pos 2) (- (strlen fld) pos 1)))
                      (setq namlst (append namlst (list (list nam val))))
                    )
                  )
                )
              )
            )
            (setq dcl_id (load_dialog "toolpac.dcl"))
            (if (not (new_dialog "xdatedit" dcl_id)) (exit))
            (xdatedit_tablnam)
            (action_tile "namlst" "(setq namsel (atoi $value))(xdatedit_dispnam)")
            (action_tile "itmfld" "(setq itmfld $value)")
            (action_tile "namdia" "(xdatedit_namdia)")
            (action_tile "update" "(xdatedit_updnam)")
            (action_tile "add" "(xdatedit_addnam)")
            (action_tile "del" "(xdatedit_delnam)")
            (action_tile "sort" "(xdatedit_sortnam)")
            (action_tile "accept" "(setq doproc T)(done_dialog 2)")
            (action_tile "cancel" "(setq doproc nil)(done_dialog 2)")
            (action_tile "help" "(dstp_showhelp \"objxdata.htm\")")
            (if (equal (start_dialog) 1)(progn))
            (unload_dialog dcl_id)
            (if (= doproc T)
              (progn
                (setq chk (assoc -3 ent))
                (setq bld (list (cons 1002 "{")))
                (foreach rec namlst
                  (setq str (strcat (nth 0 rec) "=" (nth 1 rec)))
                  (setq tmp (list (cons 1000 str)))
                  (setq bld (append bld tmp))
                )
                (setq bld (append bld (list (cons 1002 "}"))))
                (setq eed (list -3 (append (list "DSTP_XDATA") bld)))
                (if (= chk nil)
                  (setq ent (append ent (list eed)))
                  (setq ent (subst eed chk ent))
                )
                (entmod ent)
              )
            )
          )
        )
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (princ)
      )
      ;
      ; --- Transfer to Attributes
      ;
      (defun objxdata_trans ()
        (setq done nil)
        (princ "\nDS> Select Objects to Use ...")
        (setq sset (ssget '((-4 . "<OR")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "SPLINE")(-4 . "OR>") (-3 ("DSTP_XDATA")))))
        (if sset
          (progn
            (setq cmdecho (getvar "CMDECHO"))
            (setvar "CMDECHO" 0)
            (command "_.UNDO" "_G")
            (setq itm 0)
            (setq num (sslength sset))
            (while (< itm num)
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd '("DSTP_XDATA")))
              (setq chk (assoc -3 ent))
              (if (= chk nil)
                (princ "\nDS> Source Object Contains No Data!")
                (progn
                  (setq dat (cdr (nth 0 (cdr chk))))
                  (setq namlst nil)
                  (foreach rec dat
                    (setq hdr (car rec))
                    (setq fld (cdr rec))
                    (if (= hdr 1000)
                      (progn
                        (setq pos (vl-string-position (ascii "=") fld))
                        (setq nam (substr fld 1 pos))
                        (setq val (substr fld (+ pos 2) (- (strlen fld) pos 1)))
                        (setq namlst (append namlst (list (list nam val))))
                      )
                    )
                  )
                  (setq ptlst (dstp_obj2lst hnd))
                  (setq tmp nil)
                  (foreach pnt ptlst
                    (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
                    (setq tmp (append tmp (list new)))
                  )
                  (setq ptlst tmp)
                  (setq nset (ssget "_WP" ptlst '((0 . "INSERT") (66 . 1))))
                  (if (> (sslength nset) 0)
                    (progn
                      (setq nitm 0)
                      (setq nnum (sslength nset))
                      (while (< nitm nnum)
                        (setq blkhnd (ssname nset nitm))
                        (setq blkent (entget blkhnd))
                        (setq blkchg nil)
                        (setq atthnd blkhnd)
                        (setq attent blkent)
                        (while (/= "SEQEND" (cdr (assoc 0 attent)))
                          (setq atthnd (entnext atthnd))
                          (setq attent (entget atthnd))
                          (if (= (cdr (assoc 0 attent)) "ATTRIB")
                            (progn
                              (setq atttag (strcase (cdr (assoc 2 attent))))
                              (foreach rec namlst
                                (setq nam (nth 0 rec))
                                (setq val (nth 1 rec))
                                (if (= (strcase atttag)(strcase nam))
                                  (progn
                                    (setq attent (subst (cons 1 val)(assoc 1 attent) attent))
                                    (entmod attent)
                                    (setq blkchg T)
                                  )
                                )
                              )
                            )
                          )
                        )
                        (if (= blkchg T)
                          (entupd blkhnd)
                        )
                        (setq nitm (1+ nitm))
                      )
                    )
                  )
                )
              )
              (setq itm (1+ itm))
            )
            (command "_.UNDO" "_E")
            (setvar "CMDECHO" cmdecho)
          )
        )
        (princ)
      )
      ;
      ; --- main function
      ;
      (initget "A B C D M N R T E")
      (setq sub (getkword "\nDS> Add/Block/Copy/Delete/Number/Replace/Text/transFer/<Edit>: "))
      (if (= sub nil)(setq sub "E"))
      (cond
        ((= sub "A")(objxdata_add))
        ((= sub "B")(objxdata_blk))
        ((= sub "C")(objxdata_copy))
        ((= sub "D")(objxdata_del))
        ((= sub "F")(objxdata_trans))
        ((= sub "N")(objxdata_num))
        ((= sub "R")(objxdata_rep))
        ((= sub "T")(objxdata_txt))
        ((= sub "E")(objxdata_edit))
        (t nil)
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;              Export Polyline Area & Perimeter w/Enclosed Text
; --------------------------------------------------------------------------

(defun c:ObjExpPln (/ add cmdecho cnt done ent fh fn hnd itm new nlst
                         nset num ptlst sset tmp xent xfnd xhnd xitm xlst
                         xnum ysrc)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq done nil)
      (princ "\nDS> Select Circles, Polylines, or LWPolylines to Use ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "CIRCLE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq fn (dstp_getfiles "Output CSV File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "csv" 1))
          (if (/= fn nil)
            (progn
              (setq fh (open fn "w"))
              (setq cnt 0)
              (setq itm 0)
              (setq nset (ssadd))
              (setq num (sslength sset))
              (princ "\nDS>")
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (command "_.AREA" "_E" hnd)
                (setq ptlst (dstp_obj2lst hnd))
                (setq tmp nil)
                (foreach pnt ptlst
                  (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
                  (setq tmp (append tmp (list new)))
                )
                (setq ptlst tmp)
                (setq add (ssget "_WP" ptlst))
                (if (/= add nil)
                  (progn
                    (setq xitm 0)
                    (setq xlst nil)
                    (setq xnum (sslength add))
                    (while (< xitm xnum)
                      (setq xhnd (ssname add xitm))
                      (setq xent (entget xhnd))
                      (if (= (cdr (assoc 0 xent)) "TEXT")
                        (setq xlst (append xlst (list (list (cdr (assoc 10 xent)) (cdr (assoc 1 xent))))))
                      )
                      (setq xitm (1+ xitm))
                    )
                    (setq nlst nil)
                    (if (> (length xlst) 0)
                      (while (> (length xlst) 0)
                        (setq xfnd nil)
                        (setq ysrc -999999999.99)
                        (foreach xrec xlst
                          (if (> (cadr (car xrec)) ysrc)
                            (progn
                              (setq xfnd xrec)
                              (setq ysrc (cadr (car xrec)))
                            )
                          )
                        )
                        (if (/= xfnd nil)
                          (progn
                            (setq xlst (dstp_remove xfnd xlst))
                            (setq nlst (append nlst (list (cadr xfnd))))
                          )
                        )
                      )
                    )
                    (if (> cnt 0)
                      (princ "\n" fh)
                    )
                    (princ (rtos (getvar "AREA") 2 8) fh)
                    (princ dstp_csvchar fh)
                    (princ (rtos (getvar "PERIMETER") 2 8) fh)
                    (foreach rec nlst
                      (princ dstp_csvchar fh)
                      (princ rec fh)
                    )
                    (setq cnt (+ cnt 1))
                  )
                )
                (setq itm (1+ itm))
              )
              (close fh)
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Solid Fill Float Objects to top
; --------------------------------------------------------------------------

(defun c:ObjFltTop (/ bent bhnd brec cmdecho done ent hnd itm non num obj sol solfnd sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setvar "SORTENTS" 127)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if (= (dstp_lockstat) T)
        (alert "Warning: At least one layer is locked!\nProcessing objects in locked layers\nwill result in duplicate objects!")
      )
      ;
      ; --- get selection set & process
      ;
      (princ "\nDS> WARNING: Floating Changes Object Handles!")
      (setq sset (ssget))
      (if sset
        (progn
          (dstp_savprop)
          (princ "\nDS> Checking Selection Set ...")
          (setq num (sslength sset) itm 0)
          (setq sol (ssadd))
          (setq non (ssadd))
          (while (< itm num)
            (setq solfnd nil)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (if (= obj "INSERT")
              (if (= (substr (cdr (assoc 2 ent)) 1 1) "*")
                (progn
                  (setq done nil)
                  (setq brec (tblsearch "BLOCK" (cdr (assoc 2 ent))))
                  (setq bhnd (cdr (assoc -2 brec)))
                  (setq bent (entget bhnd))
                  (if (= (cdr (assoc 0 bent)) "SOLID")
                    (setq solfnd T)
                  )
                )
              )
            )
            (if (= obj "HATCH")
              (if (= (cdr (assoc 2 ent)) "SOLID")
                (setq solfnd T)
              )
            )
            (if (or (= obj "SOLID")(= solfnd T))
              (setq sol (ssadd hnd sol))
              (setq non (ssadd hnd non))
            )
            (setq itm (1+ itm))
          )
          (princ " Done.")
          (if (> (sslength sol) 0)
            (progn
              (setq tmp (strcase (getstring "\nDS> Float Solids in Selection Set Y/<N>: ")))
              (if (= tmp "Y")
                (progn
                  (princ "\nDS>")
                  (setq num (sslength sol) itm 0)
                  (while (< itm num)
                    (princ (strcat "\rDS> Processing Solid " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                    (setq hnd (ssname sol itm))
                    (dstp_dofloat hnd)
                    (setq itm (1+ itm))
                  )
                  (princ ", Done.")
                )
              )
            )
          )
          (if (> (sslength non) 0)
            (progn
              (princ "\nDS>")
              (setq num (sslength non) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (ssname non itm))
                (dstp_dofloat hnd)
                (setq itm (1+ itm))
              )
              (princ ", Done.")
            )
          )
          (dstp_resprop)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                     Set/Scale Radius of Circles & Arcs
; --------------------------------------------------------------------------

(defun c:ObjRadCmd ( / cmdecho ent hnd itm nr num opt r1 sf sset typ xr)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "C P S R")
      (setq opt (getkword "\nDS> Option Change/coPy/Scale/Replace: "))
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ "\nDS> Select Arcs & Circles to Modify ...")
      (setq sset (ssget "_I"))
      (if (/= sset nil)
        (princ (strcat "\nDS> " (rtos (sslength sset) 2 0) " Objects Found."))
        (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(-4 . "OR>"))))
      )
      (setq num (sslength sset))
      (if sset
        (progn
          (cond 
            ((= opt "P")
              (setq hnd (car (entsel "\nDS> Pick Arc/Circle with Desired Radius:")))
              (if (= hnd nil)(exit))
              (setq ent (entget hnd))
              (setq nr (cdr (assoc 40 ent)))
            )
            ((= opt "C")
              (setq nr (getreal "\nDS> New Arc/Circle Radius: "))
              (if (= nr nil)(exit))
            )
            ((= opt "S")
              (setq sf (getreal "\nDS> Scale Factor: "))
              (if (= sf nil)(exit))
            )
            ((= opt "R")
              (setq xr (getreal "\nDS> Find Arc/Circle Radius: "))
              (if (= xr nil)(exit))
              (setq nr (getreal "\nDS> New Arc/Circle Radius: "))
              (if (= nr nil)(exit))
            )
            (t nil)
          )
          (setq itm 0)
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq typ (cdr (assoc 0 ent)))
            (if (or (= "ARC" typ)(= "CIRCLE" typ))
              (progn
                (cond 
                  ((or (= opt "C")(= opt "P"))
                    (setq ent (subst (cons 40 nr)(assoc 40 ent) ent))
                    (entmod ent)
                  )
                  ((= opt "S")
                    (setq nr (* (cdr (assoc 40 ent)) sf))
                    (setq ent (subst (cons 40 nr)(assoc 40 ent) ent))
                    (entmod ent)
                  )
                  ((= opt "R")
                    (setq r1 (cdr (assoc 40 ent)))
                    (if (= r1 xr)
                      (progn
                        (setq ent (subst (cons 40 nr)(assoc 40 ent) ent))
                        (entmod ent)
                      )
                    )
                  )
                  (t nil)
                )
              )
            )
            (setq itm (1+ itm))
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                              Object Z-Ordering
; --------------------------------------------------------------------------

(defun c:ObjZorAss ( / chk cmdecho eed ent hnd itm lev num opt pmt sset tmp val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "FR MF MI MB BA NL")
      (setq opt (getkword "\nDS> Assign FRont/MidFront/MIddle/MidBack/BAck/NumberLevel: "))
      (cond
        ((= opt "FR")(setq val 1))
        ((= opt "MF")(setq val 2))
        ((= opt "MI")(setq val 3))
        ((= opt "MB")(setq val 4))
        ((= opt "BA")(setq val 5))
        ((= opt "NL")(setq val 6))
        (t (setq val 0))
      )
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (cond
        ((= val 1)(setq pmt "Assign Front"))
        ((= val 2)(setq pmt "Assign MidFront"))
        ((= val 3)(setq pmt "Assign Middle"))
        ((= val 4)(setq pmt "Assign MidBack"))
        ((= val 5)(setq pmt "Assign Back"))
        ((= val 6)
          (setq tmp (getint "\nDS> Enter Far Back Level (6-9999): "))
          (if (and (>= tmp 6)(<= tmp 9999))
            (progn
              (setq val tmp)
              (setq pmt (strcat "Assign Far Back Level " (itoa val)))
            )
            (setq pmt "Assign Back")
          )
        )
        (t nil)
      )
      (if (and (>= val 1)(<= val 9999))
        (progn
          (setq tmp (strcat "000" (itoa val)))
          (setq lev (substr tmp (- (strlen tmp) 3) 4))
          (princ (strcat "\nDS Select Objects to " pmt ": "))
          (setq sset (ssget "_I"))
          (if (= sset nil)
            (setq sset (ssget))
          )
          (if sset
            (progn
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (if (null (tblsearch "APPID" "DSTP_ZORDER"))
                (regapp "DSTP_ZORDER")
              )
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd '("DSTP_ZORDER")))
                (setq eed (list -3 (list "DSTP_ZORDER" (cons 1000 lev))))
                (setq chk (assoc -3 ent))
                (if (/= chk nil)
                  (setq ent (subst eed chk ent))
                  (setq ent (append ent (list eed)))
                )
                ;
                (if (= (cdr (assoc 0 ent)) "HATCH")
                  (progn
                    (setq tmp nil)
                    (foreach rec ent
                      (if (= (car rec) 10)
                        (setq rec (list 10 (cadr rec) (caddr rec)))
                      )
                      (if (= (car rec) 11)
                        (setq rec (list 11 (cadr rec) (caddr rec)))
                      )
                      (setq tmp (cons rec tmp))
                    )
                    (setq ent (reverse tmp))
                  )
                )
                ;
                (entmod ent)
                (setq itm (1+ itm))
              )
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (princ ", Done.")
            )
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- Strip ZOrder EED Data
;
(defun c:ObjZorRem (/ chk cmdecho ent hnd itm num sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ (strcat "\nDS Select Objects to Remove Designation ..."))
      (setq sset (ssget '((-3 ("DSTP_ZORDER")))))
      (if sset
        (progn
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd '("DSTP_ZORDER")))
            (setq chk (assoc -3 ent))
            (if (/= chk nil)
              (progn
                (setq ent (subst '(-3 ("DSTP_ZORDER")) (assoc -3 ent) ent))
                (entmod ent)
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- Float Data Based on ZOrder Value
;
(defun c:ObjZorPrc (/ chk cmdecho cnt cur ent hnd itm lst mth num prc regenmode sset tmp tot val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setvar "SORTENTS" 127)
      (if (= (dstp_lockstat) T)
        (alert "Warning: At least one layer is locked!\nProcessing objects in locked layers\nwill result in duplicate objects!")
      )
      (setq sset (ssget '((-3 ("DSTP_ZORDER")))))
      (if sset
        (progn
          (initget "N R")
          (setq tmp (getkword "\nDS> Process Order - Reversed/Normal <N>: "))
          (if (/= tmp "R")(setq mth "N")(setq mth "R"))
          (dstp_savprop)
          (prompt "\nDS> PreProcessing Level Ranges ...")
          (prompt "\nDS>")
          (setq lst nil)
          (setq cnt 0)
          (setq tot (sslength sset))
          (while (< cnt tot)
            (setq hnd (ssname sset cnt))
            (setq ent (entget hnd '("DSTP_ZORDER")))
            (setq chk (assoc -3 ent))
            (if (/= chk nil)
              (progn
                (setq val (cdr (cadr (car (cdr chk)))))
                (setq lst (append lst (list (list val hnd))))
              )
            )
            (setq cnt (1+ cnt))
          )
          (if (= (not vl-sort) T)
            (if (/= mth "N")
              (setq lst (dstp_lstsort lst 0 nil))
              (setq lst (dstp_lstsort lst 0 T))
            )
            (if (/= mth "N")
              (setq lst (vl-sort lst (function (lambda (e1 e2)(< (car e1)(car e2))))))
              (setq lst (vl-sort lst (function (lambda (e1 e2)(> (car e1)(car e2))))))
            )
          )
          (cond
            ((= dstp_floatmeth 2)
              (setq prc (ssadd))
              (setq cur (car (car lst)))
              (setq regenmode (getvar "REGENMODE"))
              (setvar "REGENMODE" 0)
              (foreach rec lst
                (setq chk (car rec))
                (if (/= chk cur)
                  (progn
                    (princ (strcat "\rDS> Processing Level " cur))
                    (command "_.DRAWORDER" prc "" "_F")
                    (setq prc (ssadd))
                    (setq cur chk)
                  )
                )
                (setq prc (ssadd (cadr rec) prc))
              )
              (if (> (sslength prc) 0)
                (progn
                  (princ (strcat "\rDS> Processing Level " cur))
                  (command "_.DRAWORDER" prc "" "_F")
                )
              )
              (setvar "REGENMODE" regenmode)
              (command "_.REGEN")
            )
            (t
              (setq itm 0)
              (setq num (length lst))
              (foreach rec lst
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (cadr rec))
                (dstp_dofloat hnd)
                (setq itm (+ itm 1))
              )
            )
          )
          (princ ", Done.")
          (dstp_resprop)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- List ZOrder Data Assigned to Object
;
(defun c:ObjZorLst (/ chk cmdecho done ent hnd obj tmp val)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq done nil)
      (while (= done nil)
        (setq tmp (entsel "\nDS> Select Object: "))
        (if (/= tmp nil)
          (progn
            (setq hnd (car tmp))
            (setq ent (entget hnd '("DSTP_ZORDER")))
            (setq chk (assoc -3 ent))
            (setq obj (cdr (assoc 0 ent)))
            (if (/= chk nil)
              (progn
                (setq val (atoi (cdr (cadr (car (cdr chk))))))
                (cond
                  ((= val 0)(setq tmp "No Designation"))
                  ((= val 1)(setq tmp "Assigned to Front"))
                  ((= val 2)(setq tmp "Assigned to MidFront"))
                  ((= val 3)(setq tmp "Assigned to Middle"))
                  ((= val 4)(setq tmp "Assigned to MidBack"))
                  ((= val 5)(setq tmp "Assigned to Back"))
                  ((> val 5)(setq tmp (strcat "Assigned to Far Back Level " (itoa val))))
                  (t (setq tmp "No Designation"))
                )
                (princ (strcat obj " - " tmp))
              )
              (princ "No Designation")
            )
          )
          (setq done T)
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- ZOrder Assign Values to Layers
;
(defun c:ObjZorLay (/ $value chk clay clev cmdecho cnt ctr dianam dlay dlev
                         eed ent fh fn hnd inc itm lay lev new noresp num olay
                         old ovrpre srtby sset stodat tabitm tablst tabsel
                         tab_id tmp uct val)
  (if (/= (dstp_isvalid) nil)
    (progn
      ;
      ; --- clear or selectall in list
      ;
      (defun objzolay_lstcon (op / inc)
        (if (= op 0)
          (set_tile "table" "")
          (progn
            (setq tabsel "")
            (setq inc 0)
            (repeat (length tablst)
              (setq tabsel (strcat tabsel (rtos inc 2 0) " "))
              (setq inc (1+ inc))
            )
            (set_tile "table" tabsel)
          )
        )
      )
      ;
      ; --- select matchs in list
      ;
      (defun objzolay_lstmat (ms)
        (if (/= ms "")
          (progn
            (setq inc 0)
            (setq tabsel "")
            (setq ms (strcase ms))
            (repeat (length tablst)
              (setq chk (car (nth inc tablst)))
              (if (= (wcmatch chk ms) T)
                (progn
                  (setq tabsel (strcat tabsel (rtos inc 2 0) " "))
                )
              )
              (setq inc (1+ inc))
            )
            (set_tile "table" tabsel)
            (set_tile "selpat" "")
          )
        )
      )
      ;
      ; --- update list box
      ;
      (defun objzolay_update ()
        (start_list "table")
        (foreach rec tablst
          (if (= (nth 1 rec) "")
            (add_list (strcat "____" "\t" (nth 0 rec)))
            (add_list (strcat (nth 1 rec) "\t" (nth 0 rec)))
          )
        )
        (end_list)
      )
      ;
      ; --- assign specified level(s)
      ;
      (defun objzolay_assign ()
        (setq uct 1)
        (setq val (atoi (get_tile "level")))
        (if (and (>= val 1)(<= val 9999))
          (progn
            (setq tmp (strcat "000" (itoa val)))
            (setq lev (substr tmp (- (strlen tmp) 3) 4))
            (setq tabsel (get_tile "table"))
            (while (setq tabitm (read tabsel))
              (setq old (nth tabitm tablst))
              (setq new (list (car old) lev))
              (setq tablst (subst new old tablst))
              (while (and (/= " " (substr tabsel uct 1))(/= "" (substr tabsel uct 1)))
                (setq uct (1+ uct))
              )
              (setq tabsel (substr tabsel uct))
            )
            (setq tabsel "")
            (set_tile "level" "")
            (objzolay_update)
          )
          (progn
            (set_tile "level" "")
            (alert "Valid Level Designations are 1-9999")
          )
        )
      )
      ;
      ; --- unassign specified level(s)
      ;
      (defun objzolay_unassign ()
        (setq uct 1)
        (setq tabsel (get_tile "table"))
        (while (setq tabitm (read tabsel))
          (setq old (nth tabitm tablst))
          (setq new (list (car old) ""))
          (setq tablst (subst new old tablst))
          (while (and (/= " " (substr tabsel uct 1))(/= "" (substr tabsel uct 1)))
            (setq uct (1+ uct))
          )
          (setq tabsel (substr tabsel uct))
        )
        (setq tabsel "")
        (set_tile "table" tabsel)
        (set_tile "level" "")
        (objzolay_update)
      )
      ;
      ; --- sort list by chosen field
      ;
      (defun objzolay_sort ()
        (if (= srtby 1)
          (setq tablst (dstp_lstsort tablst 0 nil))
          (setq tablst (dstp_lstsort tablst 1 nil))
        )
        (setq tabsel "")
        (set_tile "level" "")
        (objzolay_update)
      )
      ;
      ; --- Export Level Assignments to File
      ;
      (defun objzolay_export ()
        (setq cnt 0)
        (foreach rec tablst
          (if (/= (cadr rec) "")
            (setq cnt (1+ cnt))
          )
        )
        (if (> cnt 0)
          (progn
            (setq fn (dstp_getfiles "Export ZOA File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "zoa" 1))
            (if (/= fn nil)
              (progn
                (setq fh (open fn "w"))
                (princ "ZOA40DAT" fh)
                (princ "\nToolPac 4.0 Z-Order Assignments" fh)
                (princ "\n-------------------------------" fh)
                (princ (strcat "\n" (itoa cnt)) fh)
                (foreach rec tablst
                  (setq lay (car rec))
                  (setq lev (cadr rec))
                  (if (/= lev "")
                    (progn
                      (princ (strcat "\n" lay) fh)
                      (princ (strcat "\n" lev) fh)
                    )
                  )
                )
                (close fh)
              )
            )
          )
          (alert "No assignments to export!")
        )
      )
      ;
      ; --- Import Level Assignments from File
      ;
      (defun objzolay_import ()
        (setq fn (dstp_getfiles "Import ZOA File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "zoa" 0))
        (if (/= fn nil)
          (progn
            (setq fh (open fn "r"))
            (setq tmp (read-line fh))
            (setq tmp (read-line fh))
            (setq tmp (read-line fh))
            (setq cnt (atoi (read-line fh)))
            (repeat cnt
              (setq lay (read-line fh))
              (setq lev (read-line fh))
              (foreach rec tablst
                (if (= lay (car rec))
                  (progn
                    (setq new (list lay lev))
                    (setq tablst (subst new rec tablst))
                  )
                )
              )
            )
            (close fh)
            (setq tabsel "")
            (set_tile "level" "")
            (objzolay_update)
          )
        )
      )
      ;
      ; --- Scan drawing objects to determine zorder by layer
      ;
      (defun objzolay_scandwg ()
        (setq sset (ssget "_X" '((-3 ("DSTP_ZORDER")))))
        (if sset
          (progn
            (princ "\nDS>")
            (setq num (sslength sset) itm 0)
            (while (< itm num)
              (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd '("DSTP_ZORDER")))
              (setq olay (strcase (cdr (assoc 8 ent))))
              (foreach rec tablst
                (setq dlay (nth 0 rec))
                (setq dlev (nth 1 rec))
                (if (and (= olay dlay)(= dlev ""))
                  (progn
                    (setq chk (assoc -3 ent))
                    (setq val (atoi (cdr (cadr (car (cdr chk))))))
                    (setq tmp (strcat "000" (itoa val)))
                    (setq lev (substr tmp (- (strlen tmp) 3) 4))
                    (setq new (list dlay lev))
                    (setq tablst (subst new rec tablst))
                  )
                )
              )
              (setq itm (1+ itm))
            )
            (princ ", Done.")
            (princ)
          )
        )
        (setq sset nil)
        (setq tabsel "")
        (set_tile "level" "")
        (objzolay_update)
      )
      ;
      ; --- Main Routine
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq srtby (atoi (dstp_regfetch "General" "zolsrtby" "1")))
      (setq ovrpre (dstp_regfetch "General" "zolovrpre" "1"))
      (setq tmp (acad_strlsort (dstp_bldlst "LAYER")))
      (setq tablst nil)
      (foreach rec tmp
        (if (not (dstp_instr rec "|"))
          (setq tablst (append tablst (list (list (strcase rec) ""))))
        )
      )
      (setq stodat nil)
      (setq tmp (dictsearch (namedobjdict) "DSZOLAYER10"))
      (if (/= tmp nil)
        (progn
          (princ "\nDS> Retrieving Layering Information ...\rDS> Retrieving Layering Information ...")
          (foreach rec tmp
            (cond
              ((= (car rec) 300)(setq lay (cdr rec)))
              ((= (car rec) 301)
                (setq lev (cdr rec))
                (setq new (list lay lev))
                (setq stodat (append stodat (list new)))
              )
              (t nil)
            )
          )
          (if (/= stodat nil)
            (progn
              (setq tmp tablst)
              (setq tablst nil)
              (foreach rec tmp
                (setq lay (nth 0 rec))
                (setq lev (nth 1 rec))
                (foreach itm stodat
                  (setq clay (nth 0 itm))
                  (setq clev (nth 1 itm))
                  (if (= lay clay)
                    (setq lev clev)
                  )
                )
                (setq tablst (append tablst (list (list lay lev))))
              )
            )
          )
          (princ " Done.\n")
        )
      )
      (setq tmp nil)
      (setq stodat nil)
      (set_tile "ovrpre" ovrpre)
      (if (= srtby 1)
        (set_tile "srtlay" "1")
        (set_tile "srtlev" "1")
      )
      (setq tab_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "objzolay" tab_id)) (exit))
      (objzolay_update)
      (set_tile "ovrpre" ovrpre)
      (if (= srtby 1)
        (set_tile "srtlay" "1")
        (set_tile "srtlev" "1")
      )
      (action_tile "srtlay" "(setq srtby 1)(objzolay_sort)")
      (action_tile "srtlev" "(setq srtby 2)(objzolay_sort)")
      (action_tile "table" "(setq tabsel $value)")
      (action_tile "cancel" "(setq noresp 1)")
      (action_tile "help" "(dstp_showhelp \"objzorder.htm\")")
      (action_tile "selpat" "(objzolay_lstmat $value)")
      (action_tile "selall" "(objzolay_lstcon 1)")
      (action_tile "clrall" "(objzolay_lstcon 0)")
      (action_tile "ovrpre" "(setq ovrpre $value)")
      (action_tile "assign" "(objzolay_assign)")
      (action_tile "scandwg" "(objzolay_scandwg)")
      (action_tile "import" "(objzolay_import)")
      (action_tile "export" "(objzolay_export)")
      (action_tile "unassign" "(objzolay_unassign)")
      (mode_tile "table" 2)
      (if (equal (start_dialog) 1)
        (progn
          (unload_dialog tab_id)
          (if (null (tblsearch "APPID" "DSTP_ZORDER"))
            (regapp "DSTP_ZORDER")
          )
          (command "_.UNDO" "_G")
          (dstp_regstore "General" "zolovrpre" ovrpre)
          (dstp_regstore "General" "zolsrtby" (itoa srtby))
          (dstp_ucspush)
          (princ "\nDS>")
          (setq ctr 0)
          (setq stodat nil)
          (foreach rec tablst
            (setq lay (nth 0 rec))
            (setq lev (nth 1 rec))
            (setq ctr (+ ctr 1))
            (princ (strcat "\rDS> Processing Layer " (itoa ctr) " of " (itoa (length tablst))))
            (if (/= lev "")
              (progn
                (setq stodat (append stodat (list (list lay lev))))
                (setq sset (ssget "_X" (list (cons 8 lay))))
                (if sset
                  (progn
                    (setq num (sslength sset) itm 0)
                    (while (< itm num)
                      (setq hnd (ssname sset itm))
                      (setq ent (entget hnd '("DSTP_ZORDER")))
                      (setq eed (list -3 (list "DSTP_ZORDER" (cons 1000 lev))))
                      (setq chk (assoc -3 ent))
                      (if (/= chk nil)
                        (if (= ovrpre "1")
                          (setq ent (subst eed chk ent))
                        )
                        (setq ent (append ent (list eed)))
                      )
                      (if (= (cdr (assoc 0 ent)) "HATCH")
                        (progn
                          (setq tmp nil)
                          (foreach rec ent
                            (if (= (car rec) 10)
                              (setq rec (list 10 (cadr rec) (caddr rec)))
                            )
                            (if (= (car rec) 11)
                              (setq rec (list 11 (cadr rec) (caddr rec)))
                            )
                            (setq tmp (cons rec tmp))
                          )
                          (setq ent (reverse tmp))
                        )
                      )
                      (entmod ent)
                      (setq itm (1+ itm))
                    )
                  )
                )
              )
            )
          )
          (princ ", Done.")
          (command "_.SELECT" "")
          (command)
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (dstp_prompt "DS> Storing Data Dictionary ...")
          (setq chk (dictremove (namedobjdict) "DSZOLAYER10"))
          (if (/= chk nil)
            (entdel chk)
          )
          (setq tmp '((0 . "XRECORD")(100 . "AcDbXrecord")))
          (foreach rec stodat
            (setq tmp (append tmp (list (cons 300 (car rec)))))
            (setq tmp (append tmp (list (cons 301 (cadr rec)))))
          )
          (dictadd (namedobjdict) "DSZOLAYER10" (entmakex tmp))
          (setq tmp nil)
          (princ " Done.")
          (setq stodat nil)
          (setq tablst nil)
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Breakup objects by objects
; --------------------------------------------------------------------------

(defun c:ObjBrkObj (/ cmdecho done ent fnd g60 hnd ilst itm new nset num
                         obj objpts ohnd pnt prc prclst ptlst sset tmppts)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq done nil)
      (setq prclst nil)
      (princ "\nDS> Select Objects to break by ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "CIRCLE")(0 . "ELLIPSE")(0 . "LINE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(0 . "MLINE")(0 . "SPLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq ohnd nil)
          (setq ptlst nil)
          (setq nset (ssadd))
          (setq itm 0 num (sslength sset))
          (while (< itm num)
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq ohnd (cons hnd ohnd))
            (setq objpts (dstp_obj2lst hnd))
            (setq tmppts nil)
            (foreach pnt objpts
              (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
              (setq tmppts (append tmppts (list new)))
            )
            (setq objpts tmppts)
            (setq prc (ssget "_F" objpts))
            (if (/= prc nil)
              (progn
                (setq prc (ssdel hnd prc))
                (setq ilst (ssnamex prc))
                (foreach rec ilst
                  (foreach itm rec
                    (cond
                      ((= (type itm) 'list)
                        (setq pnt (cadr itm))
                        (setq ptlst (append ptlst (list (list (car pnt)(cadr pnt)))))
                      )
                      (t nil)
                    )
                  )
                )
              )
            )
            (setq itm (1+ itm))
          )
          (if (/= ptlst nil)
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (setvar "SORTENTS" 0) '127
              (command "_.UNDO" "_G")
              (foreach hnd ohnd
                (setq ent (entget hnd))
                (setq g60 (assoc 60 ent))
                (if (/= g60 nil)
                  (setq ent (subst (cons 60 1)(assoc 60 ent) ent))
                  (setq ent (append ent (list (cons 60 1))))
                )
                (entmod ent)
              )
              (dstp_ucspush)
              (princ "\nDS> Breaking Objects ...")
              (foreach pnt ptlst
                (setq pnt (osnap pnt "_nea"))
                (if (/= pnt nil)
                  (progn
                    (setq fnd (nentselp pnt))
                    (if (/= fnd nil)
                      (progn
                        (setq hnd (car fnd))
                        (if (= (member hnd ohnd) nil)
                          (progn
                            (setq ent (entget hnd))
                            (setq obj (cdr (assoc 0 ent)))
                            (if (or (= obj "LINE")(= obj "ARC")(= obj "CIRCLE")(= obj "POLYLINE")(= obj "LWPOLYLINE")(= obj "ELLIPSE")(= obj "SPLINE"))
                              (command "_.BREAK" hnd pnt pnt)
                            )
                          )
                        )
                      )
                    )
                  )
                )
              )
              (foreach hnd ohnd
                (setq ent (entget hnd))
                (setq ent (subst (cons 60 0)(assoc 60 ent) ent))
                (entmod ent)
              )
              (dstp_ucspop)
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
            )
            (princ "\nDS> Cannot find any fenced objects!")
          )
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                        Break Object w/Gap
; --------------------------------------------------------------------------

(defun c:ObjBrkGap (/ axo beg chk cmdecho def dis end gap hnd ipt
                           osmode pik)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq pik (entsel "\nDS> Select Object to Break: "))
      (if (/= pik nil)
        (progn
          (setq osmode (getvar "OSMODE"))
          (setvar "OSMODE" 32)
          (setq ipt (getpoint "\nDS> Pick Intersection Point: "))
          (if (/= ipt nil)
            (progn
              (setq def (dstp_regfetch "General" "gapdist" "1.0"))
              (setq chk (getdist (strcat "\nDS> Gap Distance <" def ">: ")))
              (if (= chk nil)(setq gap (distof def))(setq gap chk))
              (dstp_regstore "General" "gapdist" (rtos gap))
              (setq hnd (car pik))
              (setq axo (vlax-ename->vla-object hnd))
              (setq dis (vlax-curve-getDistAtPoint axo ipt))
              (setq beg (vlax-curve-getPointAtDist axo (- dis (/ gap 2.0))))
              (setq end (vlax-curve-getPointAtDist axo (+ dis (/ gap 2.0))))
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.BREAK" hnd beg end)
              (setvar "CMDECHO" cmdecho)
            )
          )
          (setvar "OSMODE" osmode)
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                        Object Link, Edit and Launch
; --------------------------------------------------------------------------

;
; --- Add Link to Multiple Objects
;
(defun c:ObjLnkAdd (/ bld chk cmdecho dat eed ent fld fn hdr hnd itm lst num sset tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq fn (dstp_getfiles "Select File to Link" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "*" 0))
      (if (/= fn nil)
        (progn
          (if (null (tblsearch "APPID" "DSTP_LINK"))
            (regapp "DSTP_LINK")
          )
          (setq fn (dstp_subtext fn "\\" "/"))
          (setq sset (ssget))
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd '("DSTP_LINK")))
            (setq chk (assoc -3 ent))
            (if (/= chk nil)
              (progn
                (setq dat (cdr (nth 0 (cdr chk))))
                (setq lst nil)
                (foreach rec dat
                  (setq hdr (car rec))
                  (setq fld (cdr rec))
                  (if (= hdr 1000)
                    (setq lst (append lst (list fld)))
                  )
                )
                (if (not (member fn lst))
                  (progn
                    (setq lst (append lst (list fn)))
                    (setq bld (list (cons 1002 "{")))
                    (foreach fil lst
                      (setq tmp (list (cons 1000 fil)))
                      (setq bld (append bld tmp))
                    )
                    (setq bld (append bld (list (cons 1002 "}"))))
                    (setq eed (list -3 (append (list "DSTP_LINK") bld)))
                    (setq ent (subst eed chk ent))
                    (entmod ent)
                  )
                )
              )
              (progn
                (setq lst (list fn))
                (setq bld (list (cons 1002 "{")))
                (foreach fil lst
                  (setq tmp (list (cons 1000 fil)))
                  (setq bld (append bld tmp))
                )
                (setq bld (append bld (list (cons 1002 "}"))))
                (setq eed (list -3 (append (list "DSTP_LINK") bld)))
                (setq ent (append ent (list eed)))
                (entmod ent)
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)
;
; --- Edit Object Links
;
(defun c:ObjLnkEdt (/ $value bld chk cmdecho dat datlst dcl_id dianam doproc
                         eed ent fld hdr hnd itmfld itmsel new old tmp tmplst)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun objlkedt_clritm ()
        (setq itmfld "")
        (set_tile "itmfld" itmfld)
      )
      (defun objlkedt_dispitm ()
        (setq itmfld (nth itmsel datlst))
        (set_tile "itmfld" itmfld)
      )
      (defun objlkedt_tablitm ()
        (start_list "datlst")
        (foreach itm datlst
          (add_list itm)
        ) 
        (end_list)
      )
      (defun objlkedt_upditm ()
        (if (/= datlst nil)
          (progn
            (setq itmfld (get_tile "itmfld"))
            (if (/= itmfld "")
              (progn
                (setq old (nth (atoi (get_tile "datlst")) datlst))
                (setq new itmfld)
                (setq datlst (subst new old datlst))
                (objlkedt_tablitm)
              )
            )
          )
        )
      )
      (defun objlkedt_additm ()
        (setq itmfld (get_tile "itmfld"))
        (if (member itmfld datlst)
          (alert "Link Already Exists in List")
          (progn
            (setq datlst (append datlst (list itmfld)))
            (objlkedt_tablitm)
            (objlkedt_clritm)
          )
        )
      )
      (defun objlkedt_delitm ()
        (if (/= datlst nil)
          (progn
            (setq old (nth (atoi (get_tile "datlst")) datlst))
            (setq tmplst datlst)
            (setq datlst nil)
            (foreach rec tmplst
              (if (/= rec old)
                (setq datlst (append datlst (list rec)))
              )
            )
            (objlkedt_tablitm)
            (objlkedt_clritm)
          )
        )
      )
      (defun objlkedt_sortitm ()
        (if (> (length datlst) 1)
          (setq datlst (acad_strlsort datlst))
        )
      )
      (defun objlkedt_filsel ()
        (setq tmp (dstp_getfiles "Select Alternative Link File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "*" 0))
        (if (/= tmp nil)
          (progn
            (setq tmp (dstp_subtext tmp "\\" "/"))
            (setq itmfld tmp)
            (set_tile "itmfld" itmfld)
          )
        )
      )
      ;
      ; --- Main Routine
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (entsel "\nDS> Select Object: "))
      (if (/= tmp nil)
        (progn
          (if (null (tblsearch "APPID" "DSTP_LINK"))
            (regapp "DSTP_LINK")
          )
          (setq hnd (car tmp))
          (setq ent (entget hnd '("DSTP_LINK")))
          (setq chk (assoc -3 ent))
          (if (/= chk nil)
            (progn
              (setq dat (cdr (nth 0 (cdr chk))))
              (setq datlst nil)
              (foreach rec dat
                (setq hdr (car rec))
                (setq fld (cdr rec))
                (if (= hdr 1000)
                  (setq datlst (append datlst (list fld)))
                )
              )
            )
          )
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog "linkedit" dcl_id)) (exit))
          (objlkedt_tablitm)
          (action_tile "datlst" "(setq itmsel (atoi $value))(objlkedt_dispitm)")
          (action_tile "itmfld" "(setq itmfld $value)")
          (action_tile "filsel" "(objlkedt_filsel)")
          (action_tile "sort" "(objlkedt_sortitm)(objlkedt_tablitm)(objlkedt_clritm)")
          (action_tile "del" "(objlkedt_delitm)")
          (action_tile "add" "(objlkedt_additm)")
          (action_tile "update" "(objlkedt_upditm)")
          (action_tile "accept" "(setq doproc T)(done_dialog 2)")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 2)")
          (action_tile "help" "(dstp_showhelp \"ObjDocLnk.htm\")")
          (if (equal (start_dialog) 1)(progn))
          (unload_dialog dcl_id)
          (if (= doproc T)
            (progn
              (cond
                ((and (/= chk nil)(= datlst nil))
                  (princ "\nDS> Removing Existing Links")
                  (setq ent (subst '(-3 ("DSTP_LINK")) (assoc -3 ent) ent))
                  (entmod ent)
                )
                ((and (= chk nil)(/= datlst nil))
                  (princ "\nDS> Adding Object Links")
                  (setq bld (list (cons 1002 "{")))
                  (foreach fil datlst
                    (setq tmp (list (cons 1000 fil)))
                    (setq bld (append bld tmp))
                  )
                  (setq bld (append bld (list (cons 1002 "}"))))
                  (setq eed (list -3 (append (list "DSTP_LINK") bld)))
                  (setq ent (append ent (list eed)))
                  (entmod ent)
                )
                ((and (/= chk nil)(/= datlst nil))
                  (princ "\nDS> Updating Object Links")
                  (setq bld (list (cons 1002 "{")))
                  (foreach fil datlst
                    (setq tmp (list (cons 1000 fil)))
                    (setq bld (append bld tmp))
                  )
                  (setq bld (append bld (list (cons 1002 "}"))))
                  (setq eed (list -3 (append (list "DSTP_LINK") bld)))
                  (setq ent (subst eed chk ent))
                  (entmod ent)
                )
                (t nil)
              )
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)
;
; --- Execute Selected Links
;
(defun c:ObjLnkExe (/ app chk cmdecho dat ent ext fld hdr hnd lst objlink_extlst prc res tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq tmp (entsel "\nDS> Select Object: "))
      (if (/= tmp nil)
        (progn
          (if (null (tblsearch "APPID" "DSTP_LINK"))
            (regapp "DSTP_LINK")
          )
          (setq hnd (car tmp))
          (setq ent (entget hnd '("DSTP_LINK")))
          (setq chk (assoc -3 ent))
          (if (/= chk nil)
            (progn
              (setq dat (cdr (nth 0 (cdr chk))))
              (setq lst nil)
              (foreach rec dat
                (setq hdr (car rec))
                (setq fld (cdr rec))
                (if (= hdr 1000)
                  (setq lst (append lst (list fld)))
                )
              )
              (if (> (length lst) 1)
                (setq lst (acad_strlsort lst))
              )
              (setq prc (dstp_tablesel "Select Link(s) to Process" lst "m" "T"))
              (if (/= prc nil)
                (progn
                  (if (= objlink_extlst nil)
                    (objlkcon_loadlst)
                  )
                  (foreach fil prc
                    (setq app nil)
                    (setq ext (strcase (last (dstp_pdf2lst fil "."))))
                    (foreach chk objlink_extlst
                      (if (= (nth 0 chk) ext)
                        (setq app (nth 1 chk))
                      )
                    )
                    (if (= app nil)
                      (alert "Associated Application Undefined\nUse Document Link Maintenance")
                      (progn
                        (setq app (dstp_subtext app "/" "\\"))
                        (setq fil (dstp_subtext fil "/" "\\"))
                        (princ (strcat "\nDS> Processing Link: " fil))
                        (if (dstp_instr app " ")
                          (setq app (strcat (chr 34) app (chr 34)))
                        )
                        (if (dstp_instr fil " ")
                          (setq fil (strcat (chr 34) fil (chr 34)))
                        )
                        (setq res (startapp app fil))
                        (if (= res 0)
                          (progn
                            (princ "\nDS> Failure on: ")
                            (princ (strcat "\tApplication: " app))
                            (princ (strcat "\tFile: " fil))
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
            (princ "\nDS> Selected Object has no link data.")
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)
;
; --- Delete All Links on Selected Objects
;
(defun c:ObjLnkRem (/ chk cmdecho ent hnd itm num sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (princ (strcat "\nDS Select Objects to Remove Links ..."))
      (setq sset (ssget '((-3 ("DSTP_LINK")))))
      (if sset
        (progn
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd '("DSTP_LINK")))
            (setq chk (assoc -3 ent))
            (if (/= chk nil)
              (progn
                (setq ent (subst '(-3 ("DSTP_LINK")) (assoc -3 ent) ent))
                (entmod ent)
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)
;
; --- Find & Replace Link Data on Selected Objects
;
(defun c:ObjLnkRep (/ bld chk cmdecho dat eed ent fld fnd hdr hnd itm lst num rep sset tlst tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget '((-3 ("DSTP_LINK")))))
      (if sset
        (progn
          (setq fnd (getstring "\nDS> Find String: " T))
          (setq fnd (dstp_subtext fnd "\\" "/"))
          (setq rep (getstring "\nDS> Replacement: " T))
          (setq rep (dstp_subtext rep "\\" "/"))
          (if (and (= fnd "")(= rep ""))
            (princ "\nDS> Nothing to do.")
            (progn
              (princ "\nDS> Updating Object Links ...")
              (princ "\nDS>")
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd '("DSTP_LINK")))
                (setq chk (assoc -3 ent))
                (if (/= chk nil)
                  (progn
                    (setq dat (cdr (nth 0 (cdr chk))))
                    (setq lst nil)
                    (foreach rec dat
                      (setq hdr (car rec))
                      (setq fld (cdr rec))
                      (if (= hdr 1000)
                        (setq lst (append tlst (list fld)))
                      )
                    )
                    (setq tmp nil)
                    (foreach rec lst
                      (if (/= (dstp_instr rec fnd) nil)
                        (setq rec (dstp_subtext rec fnd rep))
                      )
                      (setq tmp (append tmp (list rec)))
                    )
                    (setq lst tmp)
                    (setq bld (list (cons 1002 "{")))
                    (foreach fil lst
                      (setq tmp (list (cons 1000 fil)))
                      (setq bld (append bld tmp))
                    )
                    (setq bld (append bld (list (cons 1002 "}"))))
                    (setq eed (list -3 (append (list "DSTP_LINK") bld)))
                    (setq ent (subst eed chk ent))
                    (entmod ent)
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)
;
; --- Edit Association List
;
(defun c:ObjLnkMan (/ $value appfld cmdecho dcl_id dianam doproc extfld
                         extsel fh fn fnd itmfld new objlink_extlst old rec
                         tmp tmplst)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun objlkcon_clrext ()
        (setq extfld "")
        (setq appfld "")
        (set_tile "extfld" (strcase extfld))
        (set_tile "appfld" appfld)
      )
      (defun objlkcon_dispext ()
        (setq rec (nth extsel objlink_extlst))
        (set_tile "extfld" (strcase (car rec)))
        (set_tile "appfld" (cadr rec))
      )
      (defun objlkcon_tablext ()
        (start_list "extlst")
        (foreach itm objlink_extlst
          (add_list (strcat (nth 0 itm) "\t" (nth 1 itm)))
        ) 
        (end_list)
      )
      (defun objlkcon_updext ()
        (if (/= objlink_extlst nil)
          (progn
            (setq extfld (strcase (get_tile "extfld")))
            (setq appfld (get_tile "appfld"))
            (if (/= itmfld "")
              (progn
                (setq old (nth (atoi (get_tile "extlst")) objlink_extlst))
                (setq new (list extfld appfld))
                (setq objlink_extlst (subst new old objlink_extlst))
                (objlkcon_tablext)
              )
            )
          )
        )
      )
      (defun objlkcon_addext ()
        (setq extfld (strcase (get_tile "extfld")))
        (setq appfld (get_tile "appfld"))
        (setq fnd nil)
        (foreach rec objlink_extlst
          (if (= (strcase (car rec)) (strcase extfld))
            (setq fnd T)
          )
        )
        (if (= fnd T)
          (alert "Link Already Exists in List, Use Update!")
          (progn
            (setq objlink_extlst (append objlink_extlst (list (list extfld appfld))))
            (objlkcon_tablext)
            (objlkcon_clrext)
          )
        )
      )
      (defun objlkcon_delext ()
        (if (/= objlink_extlst nil)
          (progn
            (setq old (nth (atoi (get_tile "extlst")) objlink_extlst))
            (setq tmplst objlink_extlst)
            (setq objlink_extlst nil)
            (foreach rec tmplst
              (if (/= rec old)
                (setq objlink_extlst (append objlink_extlst (list rec)))
              )
            )
            (objlkcon_tablext)
            (objlkcon_clrext)
          )
        )
      )
      (defun objlkcon_sortext ()
        (if (> (length objlink_extlst) 1)
          (progn
            (setq tmp nil)
            (foreach itm objlink_extlst
              (setq tmp (append tmp (list (car itm))))
            )
            (setq tmp (acad_strlsort tmp))
            (setq new nil)
            (foreach itm tmp
              (setq new (append new (list (assoc itm objlink_extlst))))
            )
            (setq objlink_extlst new)
            (objlkcon_tablext)
            (objlkcon_clrext)
          )
        )
      )
      (defun objlkcon_extdia ()
        (setq tmp (dstp_getfiles "Select Executable Program" "" "EXE" 0))
        (if (/= tmp nil)
          (progn
            (setq tmp (dstp_subtext tmp "\\" "/"))
            (setq appfld tmp)
            (set_tile "appfld" appfld)
          )
        )
      )
      (defun objlkcon_loadlst ()
        (setq objlink_extlst
          (list
            (list "BMP" "PBRUSH")
            (list "TXT" "NOTEPAD")
          )
        )
        (setq fn (findfile (strcat dstpdir "Data\\OBJLINK.DAT")))
        (if (/= fn nil)
          (progn
            (setq fh (open fn "r"))
            (if (/= fh nil)
              (progn
                (princ "\nDS> Reading Association Data File ... ")
                (setq tmp (read-line fh))
                (setq tmp (read-line fh))
                (setq tmp (read-line fh))
                (setq objlink_extlst (read tmp))
                (setq tmp nil)
                (close fh)
                (princ "Done.")
              )
            )
          )
        )
      )
      ;
      ; --- Main
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (objlkcon_loadlst)
      (setq dcl_id (load_dialog "toolpac.dcl"))
      (if (not (new_dialog "conedit" dcl_id)) (exit))
      (objlkcon_tablext)
      (action_tile "extlst" "(setq extsel (atoi $value))(objlkcon_dispext)")
      (action_tile "itmfld" "(setq itmfld $value)")
      (action_tile "extdia" "(objlkcon_extdia)")
      (action_tile "update" "(objlkcon_updext)")
      (action_tile "add" "(objlkcon_addext)")
      (action_tile "del" "(objlkcon_delext)")
      (action_tile "sort" "(objlkcon_sortext)")
      (action_tile "accept" "(setq doproc T)(done_dialog 2)")
      (action_tile "cancel" "(setq doproc nil)(done_dialog 2)")
      (action_tile "help" "(dstp_showhelp \"ObjDocLnk.htm\")")
      (if (equal (start_dialog) 1)(progn))
      (unload_dialog dcl_id)
      (if (= doproc T)
        (progn
          (setq fn (findfile (strcat dstpdir "Data\\OBJLINK.DAT")))
          (if (= fn nil)
            (setq fn (strcat dstpdir "Data\\OBJLINK.DAT"))
          )
          (princ "\nDS> Saving Association Data File ... ")
          (setq fh (open fn "w"))
          (princ "Extension Association Data File" fh)
          (princ "\n------------------------------" fh)
          (print objlink_extlst fh)
          (close fh)
          (princ "Done.")
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                             Acquire Properties
; --------------------------------------------------------------------------

(defun c:ObjAcqPrp (/ tmp sset hnd ent lay col ltp thk lts wd cmdecho)
  (if (/= (dstp_isvalid) nil)
    (progn
      (initget "A C L P T S")
      (setq opt (getkword "\nDS> All/Color/Layer/LinetyPe/Thickness/ltyleScale: "))
      (if (/= opt nil)
        (progn
          (setq opt (strcase opt T))
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (cond 
            ((= opt "a")(setq wd "Properties"))
            ((= opt "c")(setq wd "Color"))
            ((= opt "l")(setq wd "Layer"))
            ((= opt "p")(setq wd "Linetype"))
            ((= opt "t")(setq wd "Thickness"))
            ((= opt "s")(setq wd "Linetype Scale"))
            (t nil)
          )
          (setq sset (ssget "_I"))
          (if (= sset nil)
            (setq sset (ssget))
          )
          (if (/= sset nil)
            (progn
              (initget "C")
              (setq tmp (entsel (strcat "\nDS> Current/<Pick Object with Desired " wd ">: ")))
              (if (/= tmp nil)
                (progn
                  (command "_.UNDO" "_G")
                  (dstp_ucspush)
                  (if (= tmp "C")
                    (progn
                      (setq lay (getvar "CLAYER"))
                      (setq col (getvar "CECOLOR"))
                      (setq ltp (getvar "CELTYPE"))
                      (setq thk (getvar "THICKNESS"))
                      (setq lts (getvar "CELTSCALE"))
                    )
                    (progn
                      (setq hnd (car tmp))
                      (setq ent (entget hnd))
                      (setq lay (cdr (assoc 8 ent)))
                      (setq col (cdr (assoc 62 ent)))
                      (if (= col nil)(setq col "BYLAYER"))
                      (setq ltp (cdr (assoc 6 ent)))
                      (if (= ltp nil)(setq ltp "BYLAYER"))
                      (setq thk (cdr (assoc 39 ent)))
                      (if (= thk nil)(setq thk 0.0))
                      (setq lts (cdr (assoc 48 ent)))
                      (if (= lts nil)(setq lts 1.0))
                    )
                  )
                  (command "_.CHANGE" sset "" "_P")
                  (if (or (= opt "a")(= opt "c"))
                    (command "_C" col)
                  )
                  (if (or (= opt "a")(= opt "l"))
                    (command "_LA" lay)
                  )
                  (if (or (= opt "a")(= opt "p"))
                    (command "_LT" ltp)
                  )
                  (if (or (= opt "a")(= opt "t"))
                    (command "_T" thk)
                  )
                  (if (or (= opt "a")(= opt "s"))
                    (command "_S" lts)
                  )
                  (command "")
                  (dstp_ucspop)
                  (command "_.UNDO" "_E")
                )
              )
            )
          )
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )	
  (princ)
)

; ###########################################################################
;                                 POLYTOOL
; ###########################################################################

; --------------------------------------------------------------------------
;                   AutoConnect Points to Form 2D/3D Polyline
; --------------------------------------------------------------------------

(defun c:PlnConAut (/ bins cdis cent chnd cins cmdecho do3d docl done
                         itm ndis nent nhnd nins num ptlst sset tmp zchk zdif)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (strcase (getstring "\nDS> Generate 3DPoly if Elevation Varies <Y>/N: ")))
      (if (= tmp "N")
        (setq do3d nil)
        (setq do3d T)
      )
      (setq tmp (strcase (getstring "\nDS> Close Polyline After Connection Y/<N>: ")))
      (if (= tmp "Y")
        (setq docl T)
        (setq docl nil)
      )
      (princ "\nDS> Select POINTS & INSERTS to Connect ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "POINT")(0 . "INSERT")(-4 . "OR>"))))
      (if sset
        (progn
          (setq ptlst nil)
          (setq bins (getpoint "\nDS> Pick Near Starting Point: "))
          (princ "\nDS> Building Point List ...")
          (while (> (sslength sset) 0)
            (setq itm 0)
            (setq num (sslength sset))
            (setq done nil)
            (setq ndis 9999999.9)
            (while (= done nil)
              (setq chnd (ssname sset itm))
              (setq cent (entget chnd))
              (setq cins (cdr (assoc 10 cent)))
              (setq cdis (distance (list (car bins)(cadr bins)) (list (car cins)(cadr cins))))
              (if (< cdis ndis)
                (progn
                  (setq nins cins)
                  (setq ndis cdis)
                  (setq nhnd chnd)
                  (setq nent cent)
                )
              )
              (setq itm (1+ itm))
              (if (= itm num)(setq done T))
            )
            (setq bins nins)
            (setq ptlst (append ptlst (list nins)))
            (ssdel nhnd sset)
          )
          (princ " Done.")
        )
      )
      (setq zdif nil)
      (setq zchk (nth 2 (nth 0 ptlst)))
      (foreach pt ptlst
        (if (/= (nth 2 pt) zchk)
          (setq zdif T)
        )
      )
      (if (and (= zdif T)(= do3D T))
        (command "_.3DPOLY")
        (command "_.PLINE")
      )
      (foreach pt ptlst
        (command (trans pt 0 1))
      )
      (if (= docl T)
        (command "_C")
        (command "")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                       Fillet or Chamfer SelSet Plines
; --------------------------------------------------------------------------

(defun c:PlnFilMul () (dstp_plfilcha 0))
(defun c:PlnChaMul () (dstp_plfilcha 1))

(defun dstp_plfilcha (opt / cmd cmdecho ent hnd itm num sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (princ "\nDS> Select Polylines to ")
      (if (= opt 0)
        (progn
          (princ "Fillet: ")
          (setq cmd "FILLET")
        )
        (progn
          (princ "Chamfer: ")
          (setq cmd "CHAMFER")
        )
      )
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq num (sslength sset))
      (if sset
        (progn
          (setq itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (command cmd "P" hnd)
            (setq itm (1+ itm))
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;               Additional information about selected polyline
; --------------------------------------------------------------------------

(defun c:PlnDetInf (/ aln arc bpt brc bul cang chd clen clk cmdecho cpt csd
                       ctr ept erc hds hnd iang larc lbu lpt maxx maxy maxz
                       minx miny minz miss pik plt pts rad2 tmp totz xcd ycd
                       zcd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun plinfo_curvlen (p1 p2 bu)
        (setq cang (angle p1 p2))
        (setq clen (distance p1 p2))
        (setq iang (* (atan bu) 4.0))
        (setq rad2 (/ clen (* 2.0 (sin (/ iang 2.0)))))
        (setq larc (* iang rad2))
      )
      (setq miss nil)
      (while (/= miss T)
        (setq tmp (entsel "\nDS> Select Polyline: "))
        (if (/= tmp nil)
          (progn
            (setq pik (cadr tmp))
            (setq hnd (car tmp))
            (princ pik)
            (dstp_getpline hnd)
            (if (/= dstp_plhdr nil)
              (progn
                (setq cmdecho (getvar "CMDECHO"))
                (setvar "CMDECHO" 0)
                (setq minx 999999999999.9)
                (setq miny 999999999999.9)
                (setq minz 999999999999.9)
                (setq maxx -999999999999.9)
                (setq maxy -999999999999.9)
                (setq maxz -999999999999.9)
                (setq arc 0)
                (setq ctr 0)
                (setq lbu 0.0)
                (setq chd 0.0)
                (setq csd 0.0)
                (setq lpt nil)
                (setq totz 0.0)
                (setq plt (nth 0 dstp_plhdr))
                (foreach rec dstp_pldat
                  (setq cpt (nth 0 rec))
                  (setq xcd (car cpt))
                  (if (> xcd maxx)(setq maxx xcd))
                  (if (< xcd minx)(setq minx xcd))
                  (setq ycd (cadr cpt))
                  (if (> ycd maxy)(setq maxy ycd))
                  (if (< ycd miny)(setq miny ycd))
                  (setq zcd (caddr cpt))
                  (if (> zcd maxz)(setq maxz zcd))
                  (if (< zcd minz)(setq minz zcd))
                  (setq totz (+ totz zcd))
                  (if (/= lpt nil)
                    (progn
                      (setq csd (+ csd (distance lpt cpt)))
                      (setq hds (distance (list (car lpt)(cadr lpt)) (list (car cpt)(cadr cpt))))
                      (setq chd (+ chd hds))
                    )
                  )
                  (if (/= lbu 0.0)
                    (progn
                      (setq arc (1+ arc))
                      (setq chd (- chd hds))
                      (setq aln (plinfo_curvlen lpt cpt lbu))
                      (setq chd (+ chd aln))
                    )
                  )
                  (setq lbu (nth 3 rec))
                  (setq lpt cpt)
                  (setq ctr (1+ ctr))
                )
                (if (= (boole 1 (nth 1 dstp_plhdr) 1) 1)
                  (progn
                    (setq brc (last dstp_pldat))
                    (setq erc (car dstp_pldat))
                    (setq bpt (nth 0 brc))
                    (setq ept (nth 0 erc))
                    (setq bul (nth 3 brc))
                    (if (= bul 0.0)
                      (progn
                        (setq csd (+ csd (distance bpt ept)))
                        (setq hds (distance (list (car bpt)(cadr bpt)) (list (car ept)(cadr ept))))
                        (setq chd (+ chd hds))
                      )
                      (progn
                        (setq arc (1+ arc))
                        (setq aln (plinfo_curvlen bpt ept bul))
                        (setq chd (+ chd aln))
                      )
                    )
                  )
                )
                (setq pts nil)
                (foreach rec dstp_pldat
                  (setq pts (cons (car rec) pts))
                )
                (setq pts (reverse pts))
                (setq clk (dstp_clockwise pts))
                (command "_.AREA" "_E" hnd)
                (if (or (= plt "LW")(= plt "2D"))
                  (princ (strcat "\nDS> " plt " Polyline, " (itoa ctr) " Vertices, " (itoa arc) " Arc Segments" ", HzDist=" (rtos chd 2 3)))
                  (princ (strcat "\nDS> " plt " Polyline, " (itoa ctr) " Vertices, HzDist=" (rtos chd 2 3) ", SlpDist=" (rtos csd 2 3)))
                )
                (if (= clk T)
                  (princ "\nDS> Direction: Clockwise, ")
                  (princ "\nDS> Direction: CounterClockwise, ")
                )
                (princ (strcat "Area=" (rtos (getvar "AREA") 2 6) ", Perimeter=" (rtos (getvar "PERIMETER") 2 3)))
                (princ (strcat "\nDS> " "Vertex Xmin=" (rtos minx 2 3) ", Ymin=" (rtos miny 2 3) ", Xmax=" (rtos maxx 2 3) ", Ymax=" (rtos maxy 2 3)))
                (if (= plt "3D")
                  (princ (strcat ", Zmin=" (rtos minz 2 3) ", Zmax=" (rtos maxz 2 3) ", Zavg=" (rtos (/ totz (atof (itoa ctr))) 2 3)))
                  (princ (strcat ", Elevation=" (rtos minz 2 3)))
                )
                (princ "\nDS> ---------------------------------------------------------------------------")
                (setvar "CMDECHO" cmdecho)
              )
            )
          )
          (setq miss T)
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                        Join Polylines, Lines, & Arcs
; --------------------------------------------------------------------------

(defun c:PlnSegJoi (/ add ang bhnd bitm bld bnum bset cbp cep chd chk
                       cmdecho cnt cp1 cp2 cset ctr del dis done ehnd eitm
                       el1 el2 ela elv ent enum eset fnd g210 grp10 grp11
                       grp70 hdr hds hnd inv is3d itm jst lay lst mbp mep
                       mpt mth new num obj pnt pth ptlst rec sep sset sub
                       tmp tot val xy1 xy2 xya)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun plsegrev_revdat ()
        (setq dstp_pldat (reverse dstp_pldat))
        (setq 1strec (nth 0 dstp_pldat))
        (setq zctr 0)
        (while (< zctr (length dstp_pldat))
          (setq orgrec (nth zctr dstp_pldat))
          (if (< (+ zctr 1)(length dstp_pldat))
            (progn
              (setq nxtrec (nth (+ zctr 1) dstp_pldat))
              (setq g42 (nth 3 nxtrec))
              (if (< g42 0.0)
                (setq g42 (abs g42))
                (setq g42 (- 0.0 (abs g42)))
              )
              (setq g40 (nth 2 nxtrec))
              (setq g41 (nth 1 nxtrec))
              (setq newrec (list (nth 0 orgrec) g40 g41 g42 (nth 4 orgrec)))
              (setq dstp_pldat (subst newrec orgrec dstp_pldat))
            )
            (progn
              (setq orgrec (last dstp_pldat))
              (setq g42 (nth 3 1strec))
              (if (< g42 0.0)
                (setq g42 (abs g42))
                (setq g42 (- 0.0 (abs g42)))
              )
              (setq g40 (nth 2 1strec))
              (setq g41 (nth 1 1strec))
              (setq newrec (list (nth 0 orgrec) g40 g41 g42 (nth 4 orgrec)))
              (setq dstp_pldat (subst newrec orgrec dstp_pldat))
            )
          ) 
          (setq zctr (+ zctr 1))
        )
      )
      (defun pljoin_avgpoint (pt1 pt2)
        (setq xy1 (dstp_2dpoint pt1))
        (setq xy2 (dstp_2dpoint pt2))
        (setq xya (polar xy1 (angle xy1 xy2) (/ (distance xy1 xy2) 2.0)))
        (setq el1 (nth 2 pt1))
        (setq el2 (nth 2 pt2))
        (setq ela (/ (+ el1 el2) 2.0))
        (setq tmp (list (nth 0 xya) (nth 1 xya) ela))
      )
      (defun pljoin_intpoint (pt1 pt2)
        (command "_.POINT" "_INT" pt1 pt2)
        (setq pth (entlast))
        (setq pnt (cdr (assoc 10 (entget pth))))
        (entdel pth)
        (setq tmp pnt)
      )
      (defun pljoin_process (sset sep mth)
        (if sset
          (progn
            (princ "\nDS>")
            (setq sub nil)
            (setq add nil)
            (setq num (sslength sset) itm 0) ; --- convert lines/arcs to plines
            (while (< itm num)
              (princ (strcat "\rDS> PreProcessing Object " (itoa (1+ itm)) " of " (itoa num)))
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd))
              (setq obj (cdr (assoc 0 ent)))
              (if (= obj "LINE")
                (progn
                  (setq grp10 (cdr (assoc 10 ent)))
                  (setq grp11 (cdr (assoc 11 ent)))
                  (if (= (nth 2 grp10)(nth 2 grp11))
                    (if (= (getvar "PEDITACCEPT") 0)
                      (command "_.PEDIT" hnd "_Y" "_X")
                      (command "_.PEDIT" hnd "_X")
                    )
                    (progn
                      (setq new (quote ((0 . "POLYLINE"))))
                      (setq new (append new (list (cons 10 (list 0.0 0.0 0.0)))))
                      (setq new (append new (list (cons 66 1))))
                      (setq new (append new (list (cons 70 8))))
                      (setq new (append new (list (assoc 8 ent))))
                      (if (/= (assoc 62 ent) nil)
                        (setq new (append new (list (assoc 62 ent))))
                      )
                      (entmake new) ; polyline header
                      (setq new (quote ((0 . "VERTEX"))))
                      (setq new (append new (list (cons 10 grp10))))
                      (setq new (append new (list (cons 70 32))))
                      (setq new (append new (list (assoc 8 ent))))
                      (entmake new)
                      (setq new (quote ((0 . "VERTEX"))))
                      (setq new (append new (list (cons 10 grp11))))
                      (setq new (append new (list (cons 70 32))))
                      (setq new (append new (list (assoc 8 ent))))
                      (entmake new)
                      (setq new (quote ((0 . "SEQEND"))))
                      (setq new (append new (list (assoc 8 ent))))
                      (entmake new)
                      (entdel hnd)
                    )
                  )
                  (setq add (append add (list (entlast))))
                  (setq sub (append sub (list hnd)))
                )
              )
              (if (= obj "ARC")
                (progn
                  (if (= (getvar "PEDITACCEPT") 0)
                    (command "_.PEDIT" hnd "_Y" "_X")
                    (command "_.PEDIT" hnd "_X")
                  )
                  (setq add (append add (list (entlast))))
                  (setq sub (append sub (list hnd)))
                )
              )
              (if (or (= obj "POLYLINE")(= obj "LWPOLYLINE"))
                (progn
                  (setq grp70 (cdr (assoc 70 ent)))
                  (if (/= grp70 nil)
                    (if (= (boole 1 grp70 1) 1)
                      (setq sub (append sub (list hnd)))
                    )
                  )
                )
              )
              (setq itm (1+ itm))
            )
            (foreach hnd sub
              (setq sset (ssdel hnd sset))
            )
            (foreach hnd add
              (setq sset (ssadd hnd sset))
            )
            (setq sub nil)
            (setq add nil)
            (setq del nil)
            (princ ", Done.")
            ;
            ; --- loop and grab an object for start
            ;
            (princ "\nDS>")
            (while (> (sslength sset) 0)
              (setq g210 nil)
              (setq hnd (ssname sset 0))
              (setq sset (ssdel hnd sset))
              (dstp_getpline hnd)
              (setq hdr dstp_plhdr)
              (setq g210 (cdr (assoc 210 (entget hnd))))
              (setq del (append del (list hnd)))
              (setq bld dstp_pldat)
              (setq mbp (car (car dstp_pldat)))
              (setq mep (car (last dstp_pldat)))
              ;
              ; --- loop until nothing left to join
              ;
              (setq done nil)
              (while (= done nil)
                ;
                ; --- get selection set at beginning
                ;
                (setq ang 0.0)
                (setq inv 15.0)
                (setq cnt (- (fix (/ 360.0 inv)) 1))
                (setq ptlst nil)
                (repeat cnt
                  (setq ptlst (append ptlst (list (polar mbp (dstp_dtr ang) (* sep 1.25)))))
                  (setq ang (+ ang inv))
                )
                (setq bset (ssget "_CP" ptlst))
                ;
                ; --- get selection set at end
                ;
                (setq ang 0.0)
                (setq inv 15.0)
                (setq cnt (- (fix (/ 360.0 inv)) 1))
                (setq ptlst nil)
                (repeat cnt
                  (setq ptlst (append ptlst (list (polar mep (dstp_dtr ang) (* sep 1.25)))))
                  (setq ang (+ ang inv))
                )
                (setq eset (ssget "_CP" ptlst))
                ;
                ; --- compare to sset and reduce to cset
                ;
                (setq cset (ssadd))
                (if (/= bset nil)
                  (progn
                    (setq bnum (sslength bset) bitm 0)
                    (while (< bitm bnum)
                      (setq bhnd (ssname bset bitm))
                      (if (ssmemb bhnd sset)
                        (setq cset (ssadd bhnd cset))
                      )
                      (setq bitm (1+ bitm))
                    )
                  )
                )
                (if (/= eset nil)
                  (progn
                    (setq enum (sslength eset) eitm 0)
                    (while (< eitm enum)
                      (setq ehnd (ssname eset eitm))
                      (if (ssmemb ehnd sset)
                        (setq cset (ssadd ehnd cset))
                      )
                      (setq eitm (1+ eitm))
                    )
                  )
                )
                (if (and (= bset nil)(= eset nil))
                  (setq cset sset)
                )
                (setq bset nil)
                (setq eset nil)
                (setq jst "")
                (setq dis 9999999.99)
                (setq num (sslength cset) itm 0)
                (while (< itm num)
                  (setq hnd (ssname cset itm))
                  (dstp_getpline hnd)
                  (setq cbp (car (car dstp_pldat)))
                  (setq cep (car (last dstp_pldat)))
                  (setq chk (distance mep cbp)) 
                  (if (and (< chk dis)(<= chk sep))
                    (setq dis chk chd hnd jst "EB")
                  )
                  (setq chk (distance mep cep)) 
                  (if (and (< chk dis)(<= chk sep))
                    (setq dis chk chd hnd jst "EE")
                  )
                  (setq chk (distance mbp cbp))
                  (if (and (< chk dis)(<= chk sep))
                    (setq dis chk chd hnd jst "BB")
                  )
                  (setq chk (distance mbp cep)) 
                  (if (and (< chk dis)(<= chk sep))
                    (setq dis chk chd hnd jst "BE")
                  )
                  (setq itm (1+ itm))
                )
                (if (/= jst "")
                  (progn
                    (dstp_getpline chd)
                    (setq sset (ssdel chd sset))
                    (setq del (append del (list chd)))
                    (princ (strcat "\rDS> " (itoa (sslength sset)) " Objects Remaining ... "))
                    (cond
                      ((= jst "EB")
                        (if (or (= mth "A")(= mth "I"))
                          (progn
                            (setq cp1 (car (last bld)))
                            (setq cp2 (car (car dstp_pldat)))
                            (if (= mth "A")
                              (setq mpt (pljoin_avgpoint cp1 cp2))
                              (setq mpt (pljoin_intpoint cp1 cp2))
                            )
                            (setq rec (list mpt (nth 1 (car dstp_pldat)) (nth 2 (car dstp_pldat)) (nth 3 (car dstp_pldat)) (nth 4 (car dstp_pldat))))
                            (setq bld (subst rec (last bld) bld))
                            (setq dstp_pldat (dstp_remove (car dstp_pldat) dstp_pldat))
                          )
                        )
                        (progn
                          (if (equal (last bld)(car dstp_pldat))
                            (setq dstp_pldat (dstp_remove (car dstp_pldat) dstp_pldat))
                          )
                          (setq bld (append bld dstp_pldat))
                        )
                      )
                      ((= jst "EE")
                        (plsegrev_revdat)
                        (if (or (= mth "A")(= mth "I"))
                          (progn
                            (setq cp1 (car (last bld)))
                            (setq cp2 (car (car dstp_pldat))) ; has been reversed
                            (if (= mth "A")
                              (setq mpt (pljoin_avgpoint cp1 cp2))
                              (setq mpt (pljoin_intpoint cp1 cp2))
                            )
                            (setq rec (list mpt (nth 1 (car dstp_pldat)) (nth 2 (car dstp_pldat)) (nth 3 (car dstp_pldat)) (nth 4 (car dstp_pldat))))
                            (setq bld (subst rec (last bld) bld))
                            (setq dstp_pldat (dstp_remove (car dstp_pldat) dstp_pldat))  ; has been reversed
                          )
                        )
                        (progn
                          (if (equal (last bld)(car dstp_pldat))
                            (setq dstp_pldat (dstp_remove (car dstp_pldat) dstp_pldat))
                          )
                          (setq bld (append bld dstp_pldat))
                        )
                      )
                      ((= jst "BB")
                        (plsegrev_revdat)
                        (if (or (= mth "A")(= mth "I"))
                          (progn
                            (setq cp1 (car (car bld)))
                            (setq cp2 (car (last dstp_pldat))) ; has been reversed
                            (if (= mth "A")
                              (setq mpt (pljoin_avgpoint cp1 cp2))
                              (setq mpt (pljoin_intpoint cp1 cp2))
                            )
                            (setq rec (list mpt (nth 1 (car bld)) (nth 2 (car bld)) (nth 3 (car bld)) (nth 4 (car bld))))
                            (setq bld (subst rec (car bld) bld))
                            (setq dstp_pldat (dstp_remove (last dstp_pldat) dstp_pldat)) ; has been reversed 
                          )
                        )
                        (progn
                          (if (equal (last dstp_pldat)(car bld))
                            (setq dstp_pldat (dstp_remove (last dstp_pldat) dstp_pldat))
                          )
                          (setq bld (append dstp_pldat bld))
                        )
                      )
                      ((= jst "BE")
                        (if (or (= mth "A")(= mth "I"))
                          (progn
                            (setq cp1 (car (car bld)))
                            (setq cp2 (car (last dstp_pldat)))
                            (if (= mth "A")
                              (setq mpt (pljoin_avgpoint cp1 cp2))
                              (setq mpt (pljoin_intpoint cp1 cp2))
                            )
                            (setq rec (list mpt (nth 1 (car bld)) (nth 2 (car bld)) (nth 3 (car bld)) (nth 4 (car bld))))
                            (setq bld (subst rec (car bld) bld))
                            (setq dstp_pldat (dstp_remove (last dstp_pldat) dstp_pldat))
                          )
                        )
                        (progn
                          (if (equal (last dstp_pldat)(car bld))
                            (setq dstp_pldat (dstp_remove (last dstp_pldat) dstp_pldat))
                          )
                          (setq bld (append dstp_pldat bld))
                        )
                      )
                      (t nil)
                    )
                    (setq mbp (car (car bld)))
                    (setq mep (car (last bld)))
                  )
                  (setq done T)
                )
                (if (= (sslength sset) 0)
                  (setq done T)
                )
              )
              (setq cbp (car (car bld)))
              (setq cep (car (last bld)))
              (setq chk (distance cbp cep)) 
              (if (<= chk sep) ; should be closed polyline?
                (progn
                  (setq hdr (list (nth 0 hdr) (+ (nth 1 hdr) 1) (nth 2 hdr)(nth 3 hdr)(nth 4 hdr)(nth 5 hdr)(nth 6 hdr)(nth 7 hdr)))
                  (setq ctr 0)
                  (setq new nil)
                  (setq tot (length bld))
                  (foreach rec bld
                    (setq ctr (1+ ctr))
                    (if (< ctr tot)
                      (setq new (cons rec new))
                    )
                  )
                  (setq bld (reverse new))
                  (setq new nil)
                )
              )
              (if (> (length del) 0)
                (progn
                  (command "_.ERASE")
                  (foreach hnd del
                    (command hnd)
                  )
                  (command "")
                )
              )
              (setq dstp_plhdr hdr)
              (setq dstp_pldat bld)
              ;
              ; --- check to see if needs to be 3D
              ;
              (setq is3D nil)
              (setq tmp (caddr (car (car bld))))
              (foreach rec bld
                (setq pnt (car rec))
                (setq elv (caddr pnt))
                (if (/= elv tmp)
                  (setq is3D T)
                )
              )
              (if (= is3D T)
                (progn
                  (if (= (boole 1 (nth 1 dstp_plhdr) 1) 1)
                    (setq val 9)
                    (setq val 8)
                  )
                  (setq dstp_plhdr (list "3D" val (nth 2 dstp_plhdr) (nth 3 dstp_plhdr) (nth 4 dstp_plhdr) 1.0 0.0 0.0))
                )
              )
              (setq hdr nil bld nil)
              (if (= (car dstp_plhdr) "3D")
                (progn
                  (setq new nil)
                  (foreach rec dstp_pldat
                    (setq pnt (car rec))
                    (setq rec (list pnt 0.0 0.0 0.0 32))
                    (setq new (append new (list rec)))
                  )
                  (setq dstp_pldat new)
                  (setq new nil)
                )
              )
              (dstp_makepline)
              (if (/= g210 nil)
                (progn
                  (setq hnd (entlast))
                  (setq ent (entget hnd))
                  (setq ent (subst (cons 210 g210)(assoc 210 ent) ent))
                  (entmod ent)
                )
              )
              (setq del nil)
            )
            (princ "\rDS> 0 Objects Remaining ... Done.")
          )
        )
      )
      ;
      ; --- Main Routine
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "ARC")(0 . "LINE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "ARC")(0 . "LINE")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if sset
        (progn
          (setq sep (atof (dstp_regfetch "Polyline" "pjssep" (rtos (/ (dstp_textsize) 2.0) 2 4))))
          (setq tmp (getdist (strcat "\nDS> Maximum Separation <" (rtos sep 2 4) ">: ")))
          (if (/= tmp nil)(setq sep tmp))
          ;
          (setq mth (dstp_regfetch "Polyline" "pjsmth" "A"))
          (if (= mth "C")
            (progn
              (initget "A C")
              (setq tmp (strcase (getstring "\nDS> Endpoint Average/Connect A/<C>: ")))
              (if (/= tmp "A")(setq mth "C")(setq mth "A"))
            )
            (progn
              (initget "A C")
              (setq tmp (strcase (getstring "\nDS> Endpoint Average/Connect <A>/C: ")))
              (if (/= tmp "C")(setq mth "A")(setq mth "C"))
            )
          )
          ;
          (setq lay (dstp_regfetch "Polyline" "pjslay" "N"))
          (if (= lay "Y")
            (progn
              (initget "Y N")
              (setq tmp (strcase (getstring "\nDS> Process Layers Separately <Y>/N: ")))
              (if (/= tmp "N")(setq lay "Y")(setq lay "N"))
            )
            (progn
              (initget "Y N")
              (setq tmp (strcase (getstring "\nDS> Process Layers Separately Y/<N>: ")))
              (if (/= tmp "Y")(setq lay "N")(setq lay "Y"))
            )
          )
          ;
          (dstp_regstore "Polyline" "pjssep" (rtos sep 2 4))
          (dstp_regstore "Polyline" "pjsmth" mth)
          (dstp_regstore "Polyline" "pjslay" lay)
          (if (= lay "Y")
            (progn
              (princ "\nDS> Separating Layers ... \rDS> Separating Layers ... ")
              (setq lst nil)
              (setq num (sslength sset) itm 0)
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq lay (strcase (cdr (assoc 8 ent))))
                (setq fnd nil)
                (foreach rec lst
                  (if (= (car rec) lay)
                    (progn
                      (setq fnd T)
                      (setq new (list lay (cons hnd (cadr rec))))
                      (setq lst (subst new rec lst))
                    )
                  )
                )
                (if (= fnd nil)
                  (progn
                    (setq rec (list lay (list hnd)))
                    (setq lst (cons rec lst))
                  )
                )
                (setq itm (1+ itm))
              )
              (princ "Done.")
              (setq sset nil)
              (foreach rec lst
                (setq lay (car rec))
                (setq hds (cadr rec))
                (princ (strcat "\nDS> Processing Layer [" lay "] ..."))
                (setq sset (ssadd))
                (foreach hnd hds
                  (setq sset (ssadd hnd sset))
                )
                (pljoin_process sset sep mth)
              )
            )
            (pljoin_process sset sep mth)
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                        Remove Single Vertex Polylines
; --------------------------------------------------------------------------

(defun c:PlnDelInv (/ badp cmdecho cntr done ent hnd itm lst non num
                         nxtent nxthnd sol sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget "_X" (list (cons 0 "POLYLINE") (cons 66 1))))
      (if sset
        (progn
          (setq badp 0)
          (setq num (sslength sset) itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq nxthnd hnd)
            (setq done nil)
            (setq cntr 0)
            (while (/= done T)
              (setq nxthnd (entnext nxthnd))
              (setq nxtent (entget nxthnd))
              (if (= "SEQEND" (cdr (assoc 0 nxtent)))
                (setq done T)
              )
              (if (= "VERTEX" (cdr (assoc 0 nxtent)))
                (setq cntr (+ cntr 1))
              )
            )
            (if (< cntr 2)
              (progn
                (entdel hnd)
                (setq badp (+ badp 1))
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (if (> badp 0)
            (princ (strcat "\nDS> NOTICE: " (itoa badp) " Single Vertex Polylines Deleted."))
          )
        )
        (princ "\nDS> No Single Vertex Polylines Detected.")
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                      Apply BiCubic Spline to 2D Polylines
; --------------------------------------------------------------------------

; interpolate elevation of supp vertices and handle 3dpoly's
(defun c:PlnSplAdd (/ cmdecho cnt ctr d1 d2 don dt dun grp70 hnd itm new
                         nop num plcls pv1 pv2 pv3 pv4 rec sd segdist splseg
                         splweight sset t1 t2 t3 t5 tmp ud w x x4 x5 xv1 xv2
                         xv3 xv4 y y4 y5 yv1 yv2 yv3 yv4)
  (if (/= (dstp_isvalid) nil)
    (progn
      (defun plspline_addseg (v1 v2 v3 v4)
        (setq pv1 (car (nth v1 dstp_pldat)))
        (setq pv2 (car (nth v2 dstp_pldat)))
        (setq pv3 (car (nth v3 dstp_pldat)))
        (setq pv4 (car (nth v4 dstp_pldat)))
        (setq xv1 (car pv1))
        (setq yv1 (cadr pv1))
        (setq xv2 (car pv2))
        (setq yv2 (cadr pv2))
        (setq xv3 (car pv3))
        (setq yv3 (cadr pv3))
        (setq xv4 (car pv4))
        (setq yv4 (cadr pv4))
        (setq y5 (- yv2 yv1))
        (setq x5 (- xv2 xv1))
        (setq y4 (- yv3 yv4))
        (setq x4 (- xv3 xv4))
        (setq d1 (distance pv1 pv2))
        (setq sd (distance pv3 pv2))
        (setq d2 (distance pv4 pv3))
        (if (> d1 d2)
          (setq ud d1)
          (setq ud d2)
        )
        (setq rec (list pv3 0 0 0 0))
        (setq new (append new (list rec)))
        (setq SplSeg (fix (/ sd SegDist)))
        (if (> SplSeg 1)
          (progn
            (setq w (* (/ sd ud) SplWeight))
            (setq dt (/ 1.0 SplSeg))
            (setq cnt 1)
            (setq dun nil)
            (while (/= dun T)
              (setq t1 (* cnt dt))
              (setq t2 (- 1.0 t1))
              (setq t5 (* w t1 t1 t2))
              (setq t3 (* w t1 t2 t2))
              (setq y (+ (* yv2 t1)(* yv3 t2)(* y4 t3)(* y5 t5)))
              (setq x (+ (* xv2 t1)(* xv3 t2)(* x4 t3)(* x5 t5)))
              (setq tmp (list x y (nth 7 dstp_plhdr)))
              (setq rec (list tmp 0 0 0 8))
              (setq new (append new (list rec)))
              (setq cnt (+ cnt 1))
              (if (= cnt SplSeg)
                (setq dun T)
              )
            )
          )
        )
      )
      ;
      ; --- Begin Main Routine
      ;
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq SegDist (dstp_textsize))
      (setq tmp (getdist (strcat "\nDS> Distance Factor <" (rtos SegDist 2 2) ">: ")))
      (if (/= tmp nil)
        (setq SegDist tmp)
      )
      (setq SplWeight 0.70)
      (setq tmp (getreal (strcat "\nDS> Segment Weighting <" (rtos SplWeight 2 2) ">: ")))
      (if (/= tmp nil)
        (setq SplWeight tmp)
      )
      ;
      ; --- get selection set & process
      ;
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (if sset
        (progn
          (setq num (sslength sset) itm 0)
          (princ "\nDS> Note: BiCubic Splining is Time Consuming ... Please Wait.\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (command "_.PEDIT" hnd "_D" "_X")
            (dstp_getpline hnd)
            (if (/= (nth 0 dstp_plhdr) "3D")
              (progn
                (setq grp70 (nth 1 dstp_plhdr))
                (if (/= grp70 nil)
                  (progn
                    (if (= (boole 1 grp70 1) 1)
                      (setq plcls T)
                      (setq plcls nil)
                    )
                  )
                )
                (if (= plcls T)
                  (setq dstp_plhdr (list (nth 0 dstp_plhdr) 5 (nth 2 dstp_plhdr)(nth 3 dstp_plhdr)(nth 4 dstp_plhdr)(nth 5 dstp_plhdr)(nth 6 dstp_plhdr)(nth 7 dstp_plhdr)))
                  (setq dstp_plhdr (list (nth 0 dstp_plhdr) 4 (nth 2 dstp_plhdr)(nth 3 dstp_plhdr)(nth 4 dstp_plhdr)(nth 5 dstp_plhdr)(nth 6 dstp_plhdr)(nth 7 dstp_plhdr)))
                )
                (setq new nil)
                (setq nop (length dstp_pldat))
                (cond
                  ((= nop 3)
                    (plspline_addseg 2 1 0 0)
                    (plspline_addseg 2 2 1 0)
                  )
                  ((= nop 4)
                    (if (= plcls nil)
                      (progn
                        (plspline_addseg 2 1 0 0)
                        (plspline_addseg 3 2 1 0)
                        (plspline_addseg 3 3 2 1)
                      )
                      (progn
                        (plspline_addseg 2 1 0 3)
                        (plspline_addseg 3 2 1 0)
                        (plspline_addseg 0 3 2 1)
                        (plspline_addseg 1 0 3 2)
                      )
                    )
                  )
                  (t
                    (if (> nop 4)
                      (progn
                        (if (= plcls T)
                          (plspline_addseg 2 1 0 (- nop 1))
                          (plspline_addseg 2 1 0 0)
                        )
                        (setq ctr 2)
                        (setq don nil)
                        (while (/= don T)
                          (plspline_addseg (+ ctr 1) ctr (- ctr 1) (- ctr 2))
                          (setq ctr (1+ ctr))
                          (if (= ctr (- nop 1))
                            (setq don T)
                          )
                        )
                        (if (= plcls T)
                          (plspline_addseg 0 (- nop 1) (- nop 2) (- nop 3))
                          (plspline_addseg (- nop 1) (- nop 1) (- nop 2) (- nop 3))
                        )
                        (if (= plcls T)
                          (plspline_addseg 1 0 (- nop 1) (- nop 2))
                        )
                      )
                    )
                  )
                )
                (if (/= plcls T)
                  (progn
                    (setq rec (list (car (nth (- (length dstp_pldat) 1) dstp_pldat)) 0 0 0 16))
                    (setq new (append new (list rec)))
                  )
                )
                ;
                (entdel hnd)
                (setq dstp_pldat new)
                (dstp_makepline)
              )
            )
            (setq itm (1+ itm))
          )
          (princ " Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                      List a Selected Polyline Vertex
; --------------------------------------------------------------------------

(defun c:PlnVtxLst (/ chk cmdecho dis done elv g10 g70 hdrent hdrhnd
                         hdrobj miss nxtent nxthnd p10 plt ppt snm spt tic
                         tmp xvl yvl zvl)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tic nil)
      (setq miss nil)
      (while (/= miss T)
        (setq tmp (entsel "\nDS> Select Vertex: "))
        (if (/= tmp nil)
          (progn
            (setq snm nil)
            (setq ppt (list (car (cadr tmp)) (cadr (cadr tmp))))
            (setq dis 9999999.9)
            (setq hdrhnd (car tmp))
            (setq hdrent (entget hdrhnd))
            (setq hdrobj (cdr (assoc 0 hdrent)))
            (if (or (= hdrobj "POLYLINE")(= hdrobj "LWPOLYLINE"))
              (progn
                (if (= hdrobj "LWPOLYLINE")
                  (progn
                    (setq plt "LWPoly")
                    (if (= (cdr (assoc 38 hdrent)) nil)
                      (setq elv 0.0)
                      (setq elv (cdr (assoc 38 hdrent)))
                    )
                    (foreach lin hdrent
                      (if (= (car lin) 10)
                        (progn
                          (setq chk (distance (list (cadr lin) (caddr lin)) ppt))
                          (if (< chk dis)
                            (progn
                              (setq dis chk)
                              (setq snm T)
                              (setq spt (list (cadr lin) (caddr lin) elv))
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (if (= hdrobj "POLYLINE")
                  (progn
                    (setq g70 (cdr (assoc 70 hdrent)))
                    (if (= (boole 1 g70 8) 8)
                      (setq plt "3DPoly")
                      (setq plt "2DPoly")
                    )
                    (setq done nil)
                    (setq nxthnd hdrhnd)
                    (while (/= done T)
                      (setq nxthnd (entnext nxthnd))
                      (setq nxtent (entget nxthnd))
                      (if (/= "SEQEND" (cdr (assoc 0 nxtent)))
                        (progn
                          (setq g10 (cdr (assoc 10 nxtent)))
                          (setq chk (distance (list (car g10) (cadr g10)) ppt))
                          (if (< chk dis)
                            (progn
                              (setq dis chk)
                              (setq snm (cdr (assoc -1 nxtent)))
                              (setq spt g10)
                            )
                          )
                        )
                        (setq done T)
                      )
                    )
                  )
                )
                (if (/= snm nil)
                  (progn
                    (if (equal tic T)
                      (progn
                        (dstp_marker p10)
                        (setq tic nil)
                      )
                    )
                    (dstp_marker spt)
                    (setq tic T p10 spt)
                    (setq xvl (car spt))
                    (setq yvl (cadr spt))
                    (setq zvl (caddr spt))
                    (princ plt)
                    (princ ", X:")
                    (princ (rtos xvl))
                    (princ ", Y:")
                    (princ (rtos yvl))
                    (princ ", Z:")
                    (princ (rtos zvl))
                  )
                )
              )
            )
          )
          (setq miss T)
        )
      )
      (if (= tic T)(dstp_marker spt))
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                  Highlight Open/Closed/Curve/Spline/3DPolys
; --------------------------------------------------------------------------

(defun c:PlnHigLit (/ cmdecho ctr ent g70 hnd itm nset num obj opt sset)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (initget "O C F S 3")
      (setq opt (getkword "\nDS> Open/Close/curveFit/Spline/3dpolys O/C/F/S/3: "))
      (princ "\nDS> Select Objects to Evaluate ...")
      (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq nset (ssadd))
          (princ "\nDS>")
          (setq num (sslength sset) itm 0)
          (while (< itm num)
            (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq obj (cdr (assoc 0 ent)))
            (setq g70 (cdr (assoc 70 ent)))
            (cond
              ((= opt "O")
                (if (= (boole 1 g70 1) 0)
                  (setq nset (ssadd hnd nset))
                )
              )
              ((= opt "C")
                (if (= (boole 1 g70 1) 1)
                  (setq nset (ssadd hnd nset))
                )
              )
              ((= opt "F")
                (if (= (boole 1 g70 2) 2)
                  (setq nset (ssadd hnd nset))
                )
              )
              ((= opt "S")
                (if (= (boole 1 g70 4) 4)
                  (setq nset (ssadd hnd nset))
                )
              )
              ((= opt "3")
                (if (= (boole 1 g70 8) 8)
                  (setq nset (ssadd hnd nset))
                )
              )
              (t nil)
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (if (> (sslength nset) 0)
            (progn
              (command "_.SELECT" nset "")
              (princ (strcat "\nDS> " (itoa (sslength nset)) " Items Qualify."))
              (setq ctr 0 num (sslength nset) itm 0)
              (while (< itm num)
                (setq hnd (ssname nset itm))
                (redraw hnd 3)
                (setq itm (1+ itm))
              )
              (princ "\nDS> Regard Highlighed Items as Previous Selection Set.")
            )
          )
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                          Remove duplicate vertices
; --------------------------------------------------------------------------

(defun c:PlnRemDup (/ cmdecho cnt dis dstp_pldat fuz hnd itm lpt new num
                         plm sset str tmp vtr)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if sset
        (progn
          (setq tmp (getdist "\nDS> Fuzz Distance <0.00000001>: "))
          (if (= tmp nil)
            (setq fuz 0.00000001)
            (setq fuz tmp)
          )
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (setq vtr 0)
          (setq plm 0)
          (setq num (sslength sset) itm 0)
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (dstp_getpline hnd)
            (setq cnt 0)
            (setq new nil)
            (setq lpt nil)
            (foreach rec dstp_pldat
              (if (/= lpt nil)
                (progn
                  (setq dis (distance lpt (car rec)))
                  (setq str (rtos dis 2 8))
                  (if (not (equal dis 0.0 fuz))
                    (progn
                      (setq new (append new (list rec)))
                    )
                    (progn
                      (if (/= (nth 3 rec) 0.0)
                        (setq new (subst rec (last new) new))
                      )
                      (setq cnt (1+ cnt))
                    )
                  )
                )
                (setq new (append new (list rec)))
              )
              (setq lpt (car rec))
            )
            (if (> cnt 0)
              (progn
                (setq dstp_pldat new)
                (entdel hnd)
                (dstp_makepline)
                (setq vtr (+ vtr cnt))
                (setq plm (1+ plm))
              )
            )
            (setq itm (+ itm 1))
          )
          (princ ", Done.")
          (if (> vtr 0)
            (princ (strcat "\nDS> Removed (" (itoa vtr) ") vertices from (" (itoa plm) ") polylines!"))
            (princ "\nDS> No duplicate vertices found!")
          )
          (dstp_ucspop)
          (command "_.UNDO" "_E")
        )
      )
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                          Breakup Long Polylines
; --------------------------------------------------------------------------

(defun c:PlnBrkLng (/ brkcnt chk cmdecho cnt ent f10 g10 g70 hdr hnd itm
                        l10 l40 l41 l42 new newcnt num plc sset tot)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq brkcnt (getint "\nDS> Break Count: "))
      (if (/= brkcnt nil)
        (if (= brkcnt 1)
          (princ "\nDS> Use AutoCAD Explode command for individual segments!")
          (progn
            (princ "\nDS> Select LWPOLYLINE objects to process ...")
            (setq sset (ssget '((0 . "LWPOLYLINE"))))
            (if sset
              (progn
                (setq cmdecho (getvar "CMDECHO"))
                (setvar "CMDECHO" 0)
                (command "_.UNDO" "_G")
                (dstp_ucspush)
                (princ "\nDS>")
                (setq num (sslength sset) itm 0)
                (while (< itm num)
                  (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0)))
                  (setq f10 nil)
                  (setq l10 nil)
                  (setq hdr nil)
                  (setq cnt 0)
                  (setq new nil)
                  (setq tot 0)
                  (setq newcnt 0)
                  (setq hnd (ssname sset itm))
                  (setq ent (entget hnd))
                  (setq g70 (cdr (assoc 70 ent)))
                  (if (= (boole 1 g70 1) 1)
                    (setq plc T)
                    (setq plc nil)
                  )
                  (foreach rec ent
                    (cond
                      ((= (car rec) 40)(setq l40 rec))
                      ((= (car rec) 41)(setq l41 rec))
                      ((= (car rec) 42)(setq l42 rec))
                      ((= (car rec) 10)
                        (setq g10 rec)
                        (setq tot (1+ tot))
                        (if (= f10 nil)
                          (setq f10 g10)
                        )
                        (if (/= l10 nil)
                          (progn
                            (if (= new nil)
                              (setq new (reverse hdr))
                            )
                            (if (= (1+ cnt) brkcnt)
                              (progn
                                (setq new (cons l10 new))
                                (setq new (cons l40 new))
                                (setq new (cons l41 new))
                                (setq new (cons l42 new))
                                (setq new (reverse new))
                                (setq chk (entmake new))
                                (setq new (reverse hdr))
                                (setq cnt 0)
                                (setq newcnt (1+ newcnt))
                                (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0) ", (" (rtos newcnt 2 0) ") New Polylines Created     "))
                              )
                            )
                            (setq new (cons l10 new))
                            (setq new (cons l40 new))
                            (setq new (cons l41 new))
                            (setq new (cons l42 new))
                            (setq cnt (1+ cnt))
                          )
                        )
                        (setq l10 g10)
                      )
                      (t
                        (if (= plc T)
                          (if (= (car rec) 70)
                            (progn
                              (setq g70 (- (cdr rec) 1))
                              (setq rec (cons 70 g70))
                            )
                          )
                        )
                        (setq hdr (append hdr (list rec)))
                      )
                    )
                  )
                  (if (> cnt 0)
                    (progn
                      (setq new (cons l10 new))
                      (setq new (cons l40 new))
                      (setq new (cons l41 new))
                      (setq new (cons l42 new))
                      (setq new (reverse new))
                      (if (= plc T)
                        (setq new (append new (list f10)))
                      )
                      (setq chk (entmake new))
                      (setq newcnt (1+ newcnt))
                      (princ (strcat "\rDS> Processing Object " (rtos (1+ itm) 2 0) " of " (rtos num 2 0) ", (" (rtos newcnt 2 0) ") New Polylines Created     "))
                    )
                  )
                  (entdel hnd)
                  (setq itm (1+ itm))
                )
                (dstp_ucspush)
                (command "_.UNDO" "_E")
                (setvar "CMDECHO" cmdecho)
              )
            )
          )
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;              Report all details of a selected 3Dpoly segment
; --------------------------------------------------------------------------

(defun c:PlnSegRep (/ done tmp pt1 pt2 hnd ent g70 el1 el2 rise run
                         grade dgslp toone)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq done nil)
      (while (/= done T)
        (setq tmp (nentsel "\nDS> Select 3DPoly Segment: "))
        (if (/= tmp nil)
          (progn
            (setq pt1 nil)
            (setq pt2 nil)
            (setq hnd (car tmp))
            (setq ent (entget hnd))
            (if (= (cdr (assoc 0 ent)) "VERTEX")
              (progn
                (setq g70 (cdr (assoc 70 ent)))
                (if (= (boole 1 (cdr (assoc 70 ent)) 32) 32)
                  (progn
                    (setq pt1 (cdr (assoc 10 ent)))
                    (setq hnd (entnext hnd))
                    (setq ent (entget hnd))
                    (if (= (cdr (assoc 0 ent)) "VERTEX")
                      (setq pt2 (cdr (assoc 10 ent)))
                    )
                    (if (= (cdr (assoc 0 ent)) "SEQEND")
                      (progn
                        (setq hnd (cdr (assoc -2 ent))) ; parent pline
                        (setq hnd (entnext hnd))
                        (setq ent (entget hnd))
                        (setq pt2 (cdr (assoc 10 ent)))
                      )
                    )
                    (if (and (/= pt1 nil)(/= pt2 nil))
                      (progn
                        (setq el1 (caddr pt1))
                        (setq el2 (caddr pt2))
                        (setq run (distance (list (car pt2)(cadr pt2)) (list (car pt1)(cadr pt1))))
                        (setq rise (- (caddr pt2) (caddr pt1)))
                        (if (> run 0)(setq grade (* (/ rise run) 100)))
                        (if (> run 0)(setq dgslp (dstp_rtd (atan (/ rise run)))))
                        (if (/= rise 0)
                          (setq toone (/ (abs run) (abs rise)))
                          (setq toone 0.0)
                        )
                        (princ "\nDS> 1st:")
                        (princ pt1)
                        (princ (strcat "  HDist:" (rtos (distance (dstp_2dpoint pt1)(dstp_2dpoint pt2)))))
                        (princ (strcat "  VDist:" (rtos (- el2 el1))))
                        (princ (strcat "  SDist:" (rtos (distance pt1 pt2))))
                        (princ "\nDS> 2nd:")
                        (princ pt2)
                        (princ (strcat "  Grade:" (rtos (abs grade) 2) "%"))
                        (princ (strcat "  Slope:" (rtos (abs dgslp) 2) ""))
                        (princ (strcat "  Ratio:" (rtos (abs toone) 2) ":1"))
                      )
                    )
                  )
                  (princ "(Selected Vertex is not a 3Dpoly!)")
                )
                (setq tmp nil)
              )
              (princ "(Selected object was not a VERTEX!)")
            )
          )
          (setq done T)
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                      Add Polyline Vertices at Crossings
; --------------------------------------------------------------------------

(defun c:PlnAddCro (/ add addlst cang cdis chk cmdecho cpt cset dis dis1
                        dis2 done ent fnd fuz hnd ilst itm lpt lst mang mdis
                        new nod nset num pass pnt prc prclst pset ptlst tmp
                        zent zhnd zobj)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq done nil)
      (setq prclst nil)
      (princ "\nDS> Select Polylines to Process ...")
      (setq pset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if pset
        (progn
          (princ "\nDS> Select Crossing Geometry (Press Enter for All) ...")
          (setq cset (ssget))
          (setq fuz (getdist "\nDS> Close Point Discard Distance <0.0>: "))
          (if (= fuz nil)(setq fuz 0.0))
          (setq itm 0)
          (setq nset (ssadd))
          (setq num (sslength pset))
          (while (< itm num)
            (setq hnd (ssname pset itm))
            (setq ent (entget hnd))
            (setq ptlst (dstp_obj2lst hnd))
            (setq tmp nil)
            (foreach pnt ptlst
              (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
              (setq tmp (append tmp (list new)))
            )
            (setq ptlst tmp)
            (setq prc (ssget "_F" ptlst))
            (if (/= prc nil)
              (progn
                (setq prc (ssdel hnd prc))
                (setq ilst (ssnamex prc))
                (if (/= ilst nil)
                  (progn
                    (setq addlst nil)
                    (dstp_getpline hnd)
                    (entdel hnd)
                    (foreach rec ilst
                      (if (= (car rec) 4)
                        (progn
                          (setq pass T)
                          (setq zhnd (cadr rec))
                          (if (/= cset nil)
                            (if (not (ssmemb zhnd cset))
                              (setq pass nil)
                            )
                          )
                          (if (= pass T)
                            (progn
                              (setq zent (entget zhnd))
                              (setq zobj (cdr (assoc 0 zent)))
                              (if (or (= zobj "LINE")(= zobj "3DFACE")(= zobj "ARC")(= zobj "CIRCLE")(= zobj "POLYLINE")(= zobj "LWPOLYLINE")(= zobj "ELLIPSE")(= zobj "SPLINE"))
                                (foreach fld rec
                                  (if (= (type fld) 'LIST)
                                    (if (not (member (cadr fld) addlst))
                                      (setq addlst (cons (cadr fld) addlst))
                                    )
                                  )
                                )
                              )
                              (if (or (= zobj "INSERT")(= zobj "POINT"))
                                (progn
                                  (setq pnt (list (cadr (assoc 10 zent)) (caddr (assoc 10 zent)) (cadddr (assoc 10 zent))))
                                  (foreach fld rec
                                    (if (= (type fld) 'LIST)
                                      (if (equal pnt (cadr fld) 0.0001)
                                        (if (not (member (cadr fld) addlst))
                                          (setq addlst (cons (cadr fld) addlst))
                                        )
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    (setq new nil)
                    (foreach pnt addlst
                      (setq fnd nil)
                      (setq pnt (dstp_2dpoint pnt))
                      (foreach rec dstp_pldat
                        (setq cpt (dstp_2dpoint (nth 0 rec)))
                        (if (equal pnt cpt 0.00000001)
                          (setq fnd T)
                        )
                      )
                      (if (= fnd nil)
                        (setq new (cons pnt new))
                      )
                    )
                    (setq addlst new)
                    (setq lpt nil)
                    (setq new nil)
                    (foreach rec dstp_pldat
                      (setq cpt (dstp_2dpoint (nth 0 rec)))
                      (if (/= lpt nil)
                        (progn
                          ;
                          ; --- find points on-line
                          ;
                          (setq mang (angle lpt cpt))
                          (setq mdis (distance lpt cpt))
                          (setq tmp nil)
                          (foreach pnt addlst
                            (setq cang (angle lpt (dstp_2dpoint pnt)))
                            (setq cdis (distance lpt (dstp_2dpoint pnt)))
                            (if (and (equal mang cang 0.00001)(<= cdis mdis))
                              (setq tmp (append tmp (list pnt)))
                            )
                          )
                          ;
                          ; --- discard points too close
                          ;
                          (if (> (length tmp) 0)
                            (progn
                              (foreach pnt tmp
                                (setq addlst (dstp_remove pnt addlst))
                              )
                              (if (> fuz 0.0)
                                (progn
                                  (setq lst nil)
                                  (foreach pnt tmp
                                    (setq dis1 (distance lpt (dstp_2dpoint pnt)))
                                    (setq dis2 (distance cpt (dstp_2dpoint pnt)))
                                    (if (and (> dis1 fuz)(> dis2 fuz))
                                      (setq lst (append lst (list pnt)))
                                    )
                                  )
                                  (setq tmp lst)
                                )
                              )
                            )
                          )
                          ;
                          ; --- sort by closest first
                          ;
                          (if (> (length tmp) 0)
                            (progn
                              (setq lst nil)
                              (while (> (length tmp) 0)
                                (setq add nil)
                                (setq dis mdis)
                                (foreach pnt tmp
                                  (setq chk (distance lpt (dstp_2dpoint pnt)))
                                  (if (< chk dis)
                                    (setq add pnt dis chk)
                                  )
                                )
                                (if (/= add nil)
                                  (progn
                                    (if (= (car dstp_plhdr) "3D")
                                      (setq nod (osnap (dstp_2dpoint add) "_nea"))
                                      (setq nod (dstp_2dpoint add))
                                    )
                                    (setq lst (append lst (list nod)))
                                    (setq tmp (dstp_remove add tmp))
                                  )
                                )
                              )
                            )
                          )
                          (if (> (length lst) 0)
                            (progn
                              (foreach pnt lst
                                (setq add (list pnt (nth 1 rec) (nth 2 rec) (nth 3 rec) (nth 4 rec)))
                                (setq new (append new (list add)))
                              )
                            )
                          )
                        )
                      )
                      (setq lst nil)
                      (setq new (append new (list rec)))
                      (setq lpt cpt)
                    )
                    (setq dstp_pldat new)
                    (dstp_makepline)
                
                  )
                )
              )
            )
            (setq itm (1+ itm))
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                           3DPoly Generate Tool
; --------------------------------------------------------------------------

(defun c:PlnSloGen (/ chk cmdecho cnt done elv hds lel lpt pnt pxy tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq pxy (getpoint "\nDS> Starting Point: "))
      (if (/= pxy nil)
        (progn
          (setq elv (caddr pxy))
          (setq chk (getreal (strcat "\nDS> Elevation <" (rtos elv) ">: ")))
          (if (/= chk nil)(setq elv chk))
          (setq pnt (list (car pxy)(cadr pxy) elv))
          (command "_.3DPOLY" pnt)
          (setq cnt 1)
          (setq lel elv)
          (setq lpt pnt)
          (setq done nil)
          (while (/= done T)
            (setq pxy (getpoint pnt "\nDS> Next Point Location: "))
            (if (/= pxy nil)
              (progn
                (setq elv (caddr pxy))
                (initget "S G R V")
                (setq chk (getreal (strcat "\nDS> Grade/Ratio/Slope/Vertdiff/Elevation <" (rtos elv) ">: ")))
                (cond
                  ((= chk "G")
                    (setq tmp (getreal "\nDS> Percent Grade: "))
                    (setq hds (distance (dstp_2dpoint lpt)(dstp_2dpoint pxy)))
                    (setq elv (+ lel (* hds tmp)))
                    (princ (strcat "(Elev: " (rtos elv) ")"))
                  )
                  ((= chk "R")
                    (setq tmp (getreal "\nDS> Ratio To One: "))
                    (setq hds (distance (dstp_2dpoint lpt)(dstp_2dpoint pxy)))
                    (setq elv (+ lel (/ hds tmp)))
                    (princ (strcat "(Elev: " (rtos elv) ")"))
                  )
                  ((= chk "S")
                    (setq tmp (getreal "\nDS> Degree of Slope: "))
                    (setq hds (distance (dstp_2dpoint lpt)(dstp_2dpoint pxy)))
                    (setq elv (+ lel (* hds (dstp_tan (dstp_dtr tmp)))))
                    (princ (strcat "(Elev: " (rtos elv) ")"))
                  )
                  ((= chk "V")
                    (setq tmp (getreal "\nDS> Vertical Difference: "))
                    (setq elv (+ lel tmp))
                    (princ (strcat "(Elev: " (rtos elv) ")"))
                  )
                  (t
                    (if (/= chk nil)(setq elv chk))
                  )
                )
                (setq pnt (list (car pxy)(cadr pxy) elv))
                (command pnt)
              )
              (setq done T)
            )
            (setq lpt pnt)
            (setq lel elv)
          )
          (command "")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                         Buffer Offset Polyline
; --------------------------------------------------------------------------

(defun c:PlnBufOfs (/ cmdecho filletrad hnd ofd pik pnt tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (entsel "\nDS> Select Polyline or LWPolyline: "))
      (if (/= tmp nil)
        (progn
          (setq hnd (car tmp))
          (setq pik (cadr tmp))
          (dstp_getpline hnd)
          (if (/= dstp_plhdr nil)
            (if (or (= (car dstp_plhdr) "LW")(= (car dstp_plhdr) "2D"))
              (if (> (length dstp_pldat) 2)
                (progn
                  (setq ofd (getdist "\nDS> Offset Distance: "))
                  (setq pnt (getpoint "\nDS> Side To Offset: "))
                  (command "_.OFFSET" ofd hnd pnt "")
                  (setq filletrad (getvar "FILLETRAD"))
                  (setvar "FILLETRAD" ofd)
                  (command "_.FILLET" "_P" "_L")
                  (setvar "FILLETRAD" filletrad)
                )
                (princ " Polyline has only two vertices!")
              )
              (princ " Polyline is not a 2D or LW Polyline!")
            )
            (princ " Object is not a Polyline or LWPolyline!")
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                    Wide Polyline to Polyline Outlines
; --------------------------------------------------------------------------

(defun c:PlnWidOut (/ ar cc chk cmdecho dfn done fillmode fnd hs ip jset
                         lst nset nxe nxo nxt obj pntmrk ss sset vs x1 x2 y1 y2)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (if sset
        (progn
          (if (= (getvar "DELOBJ") 1)
            (progn
              (setq chk (dstp_ssremlok sset))
              (if (> (cadr chk) 0)
                (progn
                   (setq sset (car chk))
                   (sssetfirst sset nil)
                   (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
                )
              )
            )
          )
          (dstp_prompt "DS> PreProcessing Selection ... ")
          (setq dfn (strcat (getvar "TEMPPREFIX") "SCRATCH.WMF"))
          (vl-file-delete dfn)
          (setq fillmode (getvar "FILLMODE"))
          (setvar "FILLMODE" 0)
          (command "_.WMFOUT" dfn sset "")
          (setvar "FILLMODE" fillmode)
          (setq ss (getvar "SCREENSIZE"))
          (setq ar (/ (cadr ss) (car ss)))
          (setq cc (getvar "VIEWCTR"))
          (setq vs (getvar "VIEWSIZE"))
          (setq hs (/ vs ar))
          (setq x1 (- (car cc) (/ hs 2)))
          (setq y1 (- (cadr cc) (/ vs 2)))
          (setq x2 (+ (car cc) (/ hs 2)))
          (setq y2 (+ (cadr cc) (/ vs 2)))
          (setq ip (list x1 y2))
          (command "_.POINT" "0,0")
          (setq pntmrk (entlast))
          (command "_.WMFIN" dfn ip 2.0 "" "")
          (vl-file-delete dfn)
          (command "_.EXPLODE" (entlast))
          (if (= (getvar "DELOBJ") 1)
            (command "_.ERASE" sset "")
          )
          (setq lst nil)
          (setq nxt pntmrk)
          (while (/= nxt nil)
            (setq nxe (entget nxt))
            (setq nxo (cdr (assoc 0 nxe)))
            (if (= nxo "POLYLINE")
              (setq lst (cons nxt lst))
            )
            (setq nxt (entnext nxt))
          )
          (foreach hnd lst
            (command "_.CONVERTPOLY" "_L" hnd "")
          )
          (setq nxt pntmrk)
          (setq nset (ssadd))
          (while (/= nxt nil)
            (setq nxt (entnext nxt))
            (if (/= nxt nil)
              (setq nset (ssadd nxt nset))
            )
          )
          (dstp_prompt "DS> Checking for Demand Loaded Support ...")
          (command "_.BOX")
          (command)
          (command "_.REGION" nset "")
          (dstp_prompt "DS> Determining Extents of Polygons ...")
          (setq nset (ssadd))
          (setq nxt pntmrk)
          (while (/= nxt nil)
            (setq nxt (entnext nxt))
            (if (/= nxt nil)
              (setq nset (ssadd nxt nset))
            )
          )
          (command "_.UNION" nset "")
          (command "_.EXPLODE" "_L")
          (setq nset (ssadd))
          (setq nxt pntmrk)
          (while (/= nxt nil)
            (setq nxt (entnext nxt))
            (if (/= nxt nil)
              (setq nset (ssadd nxt nset))
            )
          )
          (setq lst (dstp_ss2lst nset))
          (foreach hnd lst
            (command)
            (command "_.EXPLODE" hnd "")
          )
          ;
          (dstp_prompt "DS> Assembling Polyline Boundaries ...")
          (setq done nil)
          (while (/= done T)
            (setq fnd nil)
            (setq jset (ssadd))
            (setq nxt pntmrk)
            (while (/= nxt nil)
              (setq nxt (entnext nxt))
              (if (/= nxt nil)
                (progn
                  (setq obj (cdr (assoc 0 (entget nxt))))
                  (if (or (= obj "LINE")(= obj "ARC"))
                    (setq fnd T jset (ssadd nxt jset))
                  )
                )
              )
            )
            (if (= fnd T)
              (if (= (getvar "PEDITACCEPT") 0)
                (command "_.PEDIT" (ssname jset 0) "_Y" "_J" jset "" "_X")
                (command "_.PEDIT" (ssname jset 0) "_J" jset "" "_X")
              )
              (setq done T)
            )
            (setq jset nil)
          )
          (entdel pntmrk)
          (princ "Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                      Closest Points on 2 Polylines
; --------------------------------------------------------------------------

(defun c:PlnClsDis (/ chk cmdecho dat1 dat2 dis fnd1 fnd2 hnd1 hnd2 mpt
                         pnt1 pnt2 tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq tmp (entsel "\nDS> Select 1st Polyline: "))
      (if (/= tmp nil)
        (progn
          (setq hnd1 (car tmp))
          (setq tmp (entsel "\nDS> Select 2nd Polyline: "))
          (if (/= tmp nil)
            (progn
              (dstp_prompt "DS> Evaluating Points on Polylines ... ")
              (setq hnd2 (car tmp))
              (setq dis 9999999999.9)
              (setq dat1 (cadr (dstp_getpline hnd1)))
              (setq dat2 (cadr (dstp_getpline hnd2)))
              (foreach rec1 dat1
                (setq pnt1 (car rec1))
                (foreach rec2 dat2
                  (setq pnt2 (car rec2))
                  (setq chk (distance pnt1 pnt2))
                  (if (< chk dis)
                    (setq fnd1 pnt1 fnd2 pnt2 dis chk)
                  )
                )
              )
              (princ "Done")
              (setq mpt (polar fnd1 (angle fnd1 fnd2) (/ (distance fnd1 fnd2) 2.0)))
              (command "_.DONUT" 0.0 (distance fnd1 fnd2) mpt "")
              (princ (strcat "\nDS> Location Marked, Minimum Distance is " (rtos (distance fnd1 fnd2))))
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                  Label all Vertex's of Selected Polylines
; --------------------------------------------------------------------------

(defun c:PlnVtxLab (/ bul chk cmdecho dat dis done edf ewd g71 hbu hdr
                         hds hgt hnd idx ins itm labdis labqad labpnt labwid
                         lbu lpt new num pnt sds sset str swd xcd ycd zcd)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq hgt (dstp_textsize))
      (setq labqad (atoi (dstp_regfetch "Polyline" "labqad" "1")))
      (setq labdis (atof (dstp_regfetch "Polyline" "labdis" (rtos (* hgt 0.75)))))
      (setq labwid (atof (dstp_regfetch "Polyline" "labwid" "0.0")))
      (setq labpnt (dstp_regfetch "Polyline" "labpnt" "Index: [VI]\\PNorth: [YC]\\PEast: [XC]\\PElev: [ZC]\\PDiff: [ED]\\PHorz: [HD]\\PSlope: [SD]\\PHPrev: [HP]\\PSPrev: [SP]"))
      (setq done nil)
      (while (/= done T)
        (initget "Q D W T")
        (setq chk (getkword "\nDS> Quadrant/Distance/Template/Width/<Begin Selection>: "))
        (cond
          ((= chk "Q")
            (cond
              ((= labqad 1)(setq str "<1>/2/3/4"))
              ((= labqad 2)(setq str "1/<2>/3/4"))
              ((= labqad 3)(setq str "1/2/<3>/4"))
              ((= labqad 4)(setq str "1/2/3/<4>"))
            )
            (initget "1 2 3 4")
            (setq chk (getkword (strcat "\nDS> Quadrant " str ": ")))
            (if (/= chk nil)
              (setq labqad (atoi chk))
            )
            (dstp_regstore "Polyline" "labqad" (itoa labqad))
          )
          ((= chk "D")
            (setq chk (getdist (strcat "\nDS> Label Offset Distance <" (rtos labdis) ">: ")))
            (if (/= chk nil)
              (setq labdis chk)
            )
            (dstp_regstore "Polyline" "labdis" (rtos labdis))
          )
          ((= chk "T")
            (setq str labpnt)
            (setq str (dstp_subtext str "\\P" (strcat (chr 13)(chr 10))))
            (setq str (dstp_textedit str))
            (if (/= str "")
              (progn
                (setq str (dstp_subtext str "\r\n" "\\P"))
                (setq labpnt str)
                (dstp_regstore "Polyline" "labpnt" labpnt)
              )
            )
          )
          ((= chk "W")
            (setq chk (getdist (strcat "\nDS> Mtext Object Width <" (rtos labwid) ">: ")))
            (if (/= chk nil)
              (setq labwid chk)
            )
            (dstp_regstore "Polyline" "labwid" (rtos labwid))
          )
          ((= chk nil)
            (setq done T)
          )
        )
      )
      (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      (if (= sset nil)
        (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
      )
      (if sset
        (progn
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (command "_.UNDO" "_G")
          (dstp_ucspush)
          (princ "\nDS>")
          (setq itm 0 num (sslength sset))
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq chk (dstp_getpline hnd))
            (setq hdr (car chk))
            (setq dat (cadr chk))
            (setq idx 0)
            (setq hds 0.0)
            (setq sds 0.0)
            (setq hbu nil)
            (foreach rec dat
              (if (not (equal (nth 3 rec) 0.0 0.0000001))
                (setq hbu T)
              )
            )
            (foreach rec dat
              (setq idx (1+ idx))
              (setq pnt (nth 0 rec))
              (setq swd (nth 1 rec))
              (setq ewd (nth 2 rec))
              (setq bul (nth 3 rec))
              (setq xcd (rtos (nth 0 pnt)))
              (setq ycd (rtos (nth 1 pnt)))
              (setq zcd (rtos (nth 2 pnt)))
              (setq str labpnt)
              (setq str (dstp_subtext str "[VI]" (itoa idx)))
              (setq str (dstp_subtext str "[XC]" xcd))
              (setq str (dstp_subtext str "[YC]" ycd))
              (setq str (dstp_subtext str "[ZC]" zcd))
              (if (> idx 1)
                (progn
                  (if (/= lbu 0.0)
                    (setq dis (plinfo_curvlen lpt pnt lbu))
                    (setq dis (distance (dstp_2dpoint lpt)(dstp_2dpoint pnt)))
                  )
                  (setq str (dstp_subtext str "[HP]" (rtos dis)))
                  (setq hds (+ hds dis))
                  (setq str (dstp_subtext str "[HD]" (rtos hds)))
                  (setq edf (rtos (- (caddr pnt)(caddr lpt))))
                  (if (/= (substr edf 1 1) "-")
                    (setq edf (strcat "+" edf))
                  )
                  (setq str (dstp_subtext str "[ED]" edf))
                  (if (= hbu nil)
                    (progn
                      (setq dis (distance lpt pnt))
                      (setq str (dstp_subtext str "[SP]" (rtos dis)))
                      (setq sds (+ sds dis))
                      (setq str (dstp_subtext str "[SD]" (rtos sds)))
                    )
                  )
                )
                (progn
                  (setq str (dstp_subtext str "[HD]" (rtos 0.0)))
                  (setq str (dstp_subtext str "[HP]" (rtos 0.0)))
                  (setq str (dstp_subtext str "[ED]" (rtos 0.0)))
                  (if (= hbu nil)
                    (progn
                      (setq str (dstp_subtext str "[SD]" (rtos 0.0)))
                      (setq str (dstp_subtext str "[SP]" (rtos 0.0)))
                    )
                  )
                )
              )
              (cond
                ((= labqad 1) ;ur
                  (setq ins (polar pnt (/ pi 4.0) labdis))
                  (setq g71 7)
                )
                ((= labqad 2) ;lr
                  (setq ins (polar pnt (- (* pi 2.0) (/ pi 4.0)) labdis))
                  (setq g71 1)
                )
                ((= labqad 3) ;ll
                  (setq ins (polar pnt (+ pi (/ pi 4.0)) labdis))
                  (setq g71 3)
                )
                ((= labqad 4) ;ul
                  (setq ins (polar pnt (- pi (/ pi 4.0)) labdis))
                  (setq g71 9)
                )
              )
              (setq new '((0 . "MTEXT")))
              (setq new (cons (cons 100 "AcDbEntity") new))
              (setq new (cons (cons 100 "AcDbMText") new))
              (setq new (cons (cons 1 str) new))
              (setq new (cons (cons 7 (getvar "TEXTSTYLE")) new))
              (setq new (cons (list 10 (car ins) (cadr ins)) new))
              (setq new (cons (cons 71 g71) new))
              (setq new (cons (cons 40 hgt) new))
              (setq new (cons (cons 41 labwid) new))
              (entmake (reverse new))
              (setq lpt pnt)
              (setq lbu bul)
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
          (dstp_ucspop)
          (command "_.UNDO" "_E")
          (setvar "CMDECHO" cmdecho)
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                         Offset Polyline Segment to Line
; --------------------------------------------------------------------------

(defun c:PlnSegOfs (/ cmdecho dir dis endp1 endp2 hnd lin midpt miss pik tmp)
  (if (/= (dstp_isvalid) nil)
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq dis (getvar "OFFSETDIST"))
      (setq tmp (getdist (strcat "\nDS> Offset Distance <" (rtos dis) ">: ")))
      (if (/= tmp nil)
        (setq dis tmp)
      )
      (setq miss nil)
      (while (= miss nil)
        (setq tmp (entsel "\nDS> Select Polyline Segment : "))
        (if (/= tmp nil)
          (progn
            (setq hnd (car tmp))
            (setq pik (cadr tmp))
            (setq midpt (osnap pik "_mid"))
            (setq endp1 (osnap pik "_end"))
            (setq tmp (polar midpt (angle endp1 midpt) 0.01))
            (setq endp2 (osnap tmp "_end"))
            (dstp_savprop)
            (dstp_prop2obj hnd)
            (command "_.LINE" endp1 endp2 "")
            (dstp_resprop)
            (setq lin (entlast))
            (setq dir (getpoint "\nDS> Side To Offset: "))
            (command "_.OFFSET" dis lin dir "")
            (entdel lin)
          )
          (setq miss T)
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )	
  (princ)
)

; ###########################################################################
;                                SYMBLMAN
; ###########################################################################

; --------------------------------------------------------------------------
;                         Check File Read-Only
; --------------------------------------------------------------------------

(defun filereadonly (cfn / fh zres)
  (setq fh (open cfn "a"))
  (if (/= fh nil)
    (progn
      (close fh)
      (setq zres nil)
    )
    (setq zres T)
  )
)

; --------------------------------------------------------------------------
;                         Bounding Buffer Command
; --------------------------------------------------------------------------

(setq dstp_boundbuf nil)
(setq chk (dstp_regfetch "Symblman" "bndbuf" ""))
(if (/= chk "")
  (setq dstp_boundbuf (atof chk))
)
(defun c:BlkSymBuf ()
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (= dstp_boundbuf nil)
        (princ "\nDS> No Bounding Buffer Value Set!")
        (princ (strcat "\nDS> Bounding Buffer Value is " (rtos dstp_boundbuf)))
      )
      (setq chk (getreal "\nDS> New Percentage Value for Bounding Buffer: "))
      (if (/= chk nil)
        (if (or (< chk 0.0)(> chk 100.0))
          (princ "\nDS> Value entered is outside of range of 0-100")
          (progn
            (setq dstp_boundbuf chk)
            (dstp_regstore "Symblman" "bndbuf" (rtos chk 2 2))
          )
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                  Find old SYMBLMAN.DAT files and convert
; --------------------------------------------------------------------------

(setq cvl nil)
(setq pth (getenv "ACAD"))
(setq tmp (dstp_pdf2lst pth ";"))
(foreach pth tmp
  (setq ifn (strcat pth "\\" "SYMBLMAN.DAT"))
  (if (/= (findfile ifn) nil)
    (progn
      (setq ofn (strcase (strcat (GetFileNameWithoutExtension ifn) ".sdb") t))
      (if (= (findfile ofn) nil)
        (progn
          (setq fh (open ifn "r"))
          (if (/= fh nil)
            (progn
              (setq tmp (read-line fh))
              (if (= tmp "TP20SYM")
                (progn
                  (read-line fh)
                  (read-line fh)
                  (setq tmp (read (read-line fh)))
                  (close fh)
                  (setq lst nil)
                  (foreach rec tmp
                    (setq rec (append rec (list "" "" "" "0" "1" "0")))
                    (setq lst (cons rec lst))
                  )
                  (setq lst (reverse lst))
                  ;
                  (setq fh (open ofn "w"))
                  (princ "TP60SYM" fh)
                  (princ "\nToolPac 6.0 Symbol Data File" fh)
                  (princ "\n----------------------------" fh)
                  (print lst fh)
                  (princ "Done.\r")
                  (close fh)
                  (setq cvl (cons (strcat ifn " > " ofn) cvl))
                )
                (close fh)
              )
            )
          )
        )
      )
    )
  )
)
(if (/= cvl nil)
  (progn
    (setq str "Symbol Manager 6.0 has found the following old format databases\nand converted them to the new format.  The old file remains intact\nand was not deleted.\n")
    (foreach itm cvl
      (setq str (strcat str "\n" itm))
    )
    (alert str)
  )
)

; --------------------------------------------------------------------------
;                  Menu Callable function to set defaults
; --------------------------------------------------------------------------

; grp = group name
; dia = starting dialog (1=Details, 2=Tiles)
; dbf = full path to database file

(if (or (= prdnam "AutoCAD")(= prdnam "Bricscad"))
  (progn
    (pragma '((export-to-acad dstp_symblset)))
      (defun dstp_symblset (dbf grp dia)
        (setq dbf (vl-string-translate "/" "\\" dbf))
        (if (/= dbf nil)
          (if (findfile dbf)
             (setq dstp_symblpth (findfile dbf))
          )
        )
        (if (/= grp nil)
           (setq dstp_symblgrp (strcase grp))
        )
        (if (/= dia nil)
           (setq dstp_symbldia dia)
        )
     )
  )
)

; --------------------------------------------------------------------------
;                  SYMBLSLD (Automate Symbol Slide Making)
; --------------------------------------------------------------------------

(defun symblsld_procsld (inp)
  (setq symfil (strcase inp))
  (setq sldfil (strcase (strcat (GetFileNameWithoutExtension inp) ".SLD")))
  (princ (strcat "\nDS> Processing Slide " inp " ..."))
  ;
  (command "_.UNDO" "_M")
  (setq osmode (getvar "OSMODE"))
  (setvar "OSMODE" 0)
  (setvar "FILEDIA" 0)
  (setq attreq (getvar "ATTREQ"))
  (setvar "ATTREQ" 0)
  (command "_.INSERT" symfil "0,0" "1" "1" "0")
  ;
  (if (= fil "1")
    (progn
      (setq blkhnd (entlast))
      (setq blkent (entget blkhnd))
      (if (/= (assoc 66 blkent) nil)
        (if (= (cdr (assoc 66 blkent)) 1)
          (progn
            (setq atthnd blkhnd)
            (setq attent blkent)
            ;
            (while (/= "SEQEND" (cdr (assoc 0 attent)))
              (setq atthnd (entnext atthnd))
              (setq attent (entget atthnd))
              (if (= (cdr (assoc 0 attent)) "ATTRIB")
                (progn
                  (setq atttag (strcase (cdr (assoc 2 attent))))
                  (setq attent (subst (cons 1 atttag)(assoc 1 attent) attent))
                  (entmod attent)
                )
              )
            )
            (entupd blkhnd)
          )
        )
      )
    )
  )
  ;
  (command "_.ZOOM" "_E")
  (command "_.ZOOM" "0.9X")
  ;
  (setq minx (car (getvar "EXTMIN")))
  (setq miny (cadr (getvar "EXTMIN")))
  (setq maxx (car (getvar "EXTMAX")))
  (setq maxy (cadr (getvar "EXTMAX")))
  (setq avgx (/ (+ maxx minx) 2))
  (setq avgy (/ (+ maxy miny) 2))
  (setq avgp (list avgx avgy))
  (command "_.ZOOM" "_C" avgp "")
  ;
  (if (= mrk "1")
    (progn
      (setq cpt (list 0.0 0.0))
      (setq siz (/ (getvar "VIEWSIZE") 30.0))
      (setvar "CECOLOR" "1")
      (command "_.LINE" (polar cpt 0.78540 siz) (polar cpt 3.92699 siz) "")
      (command "_.LINE" (polar cpt 2.35619 siz) (polar cpt 5.49779 siz) "")
      (command "_.LINE" (polar cpt 0.00000 siz) (polar cpt 3.14159 siz) "")
      (command "_.LINE" (polar cpt 1.57079 siz) (polar cpt 4.71238 siz) "")
    )
  )
  ;
  (command "_.REGEN")
  (cond
    ((= pre 1)(command "_.SHADE"))
    ((= pre 2)(command "_.HIDE"))
    (t nil)
  )
  ;
  (command "_.MSLIDE" sldfil)
  (setvar "FILEDIA" 1)
  (setvar "OSMODE" osmode)
  (setvar "ATTREQ" attreq)
  (command "_.UNDO" "_B")
  (princ " Done.")
)

(defun c:BlkSymSld ()
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (/= (ssget "_X") nil)
        (alert "Command must be started from\na new, empty drawing")
        (progn
          (setq pre 0)
          (setq mth 3)
          (setq mrk "1")
          (setq fil "1")
          (setq dcl_id (load_dialog "toolpac.dcl"))
          (if (not (new_dialog "symblsld" dcl_id)) (exit))
          (set_tile "genmrk" mrk)
          (set_tile "filatt" fil)
          (set_tile "seldir" "1")
          (set_tile "prenon" "1")
          (action_tile "prenon" "(setq pre 0)")
          (action_tile "preshd" "(setq pre 1)")
          (action_tile "prehid" "(setq pre 2)")
          (action_tile "selsng" "(setq mth 1)")
          (action_tile "selmul" "(setq mth 2)")
          (action_tile "seldir" "(setq mth 3)")
          (action_tile "genmrk" "(setq mrk $value)")
          (action_tile "filatt" "(setq fil $value)")
          (action_tile "accept" "(setq doproc T)(done_dialog 1)")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 1)")
          (action_tile "help" "(dstp_showhelp \"BlkSymSld.htm\")")
          (start_dialog)
          (if (= doproc T)
            (progn
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (setq ucsicon (getvar "UCSICON"))
              (setvar "UCSICON" 2)
              (command "_.UNDO" "_G")
              (cond
                ((= mth 1) ; single
                  (setq fil (dstp_getfiles "Select Drawing File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "dwg" 0))
                  (if (/= fil nil)(symblsld_procsld fil))
                )
                ((= mth 2) ; multiple
                  (setq flst (dstp_getfilex "Select Drawing Files" nil "dwg"))
                  (if (/= flst nil)
                    (foreach rec flst
                      (symblsld_procsld rec)
                    )
                  )
                )
                ((= mth 3) ; directory
                  (setq dir (dstp_getfolder "Select Directory" nil))
                  (if (/= dir nil)
                    (progn
                      (setq flst (vl-directory-files dir "*.dwg" 0))
                      (if (/= flst nil)
                        (progn
                          (setq flst (acad_strlsort flst))
                          (foreach rec flst
                            (symblsld_procsld (strcat dir "\\" rec))
                          )
                        )
                      )
                    )
                  )
                )
                (t nil)
              )
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
              (setvar "UCSICON" ucsicon)
            )
          )
        )
      )
    )
  )	
  (princ)
)

; --------------------------------------------------------------------------
;                             Symbol Manager
; --------------------------------------------------------------------------

(defun symblman_scalechk (inp)
  (setq chk inp)
  (cond
    ((= (substr (strcase chk) 1 5) "USERR")
      (setq tmp (getvar chk))
      (if (equal tmp 0.0)
        (setq tmp 1.0)
      )
    )
    ((= (strcase chk) "DIMSCALE")
      (setq tmp (getvar "DIMSCALE"))
      (if (= tmp 0.0)
        (progn
          (setq tmp 1.0)
          (if (= (getvar "TILEMODE") 0)
            (progn
              (if (> (getvar "CVPORT") 1)
                (progn
                  (setq vpi (getvar "CVPORT"))
                  (setq vpl (ssget "_X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
                  (setq hnd (ssname vpl 0))
                  (setq ent (entget hnd '("ACAD")))
                  (setq cvhgt (cdr (assoc 41 ent)))
                  (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
                  (setq tmp (/ cvsiz cvhgt))
                )
                (setq tmp 1.0) ; in paper space!
              )
            )
            (princ "\nDS> Paper Space not enabled, using default of 1.0")
          )
        )
      )
    )
    (t
      (setq tmp (atof chk))
    )
  )
  (eval tmp)
)
;
; --- add blockname from filename
;
(defun symblman_extblknam ()
  (if (/= blkfil "")
    (progn
      (setq fnd 0)
      (setq pos (strlen blkfil))
      (repeat (strlen blkfil)
        (setq chkchr (substr blkfil pos 1))
        (if (= chkchr ".")
          (if (= fnd 0)
            (setq fnd pos)
          )
        )
        (setq pos (1- pos))
      )
      (setq root (substr blkfil 1 (- fnd 1)))
      ;(setq root (car (dstp_pdf2lst blkfil ".")))
      (setq blknam (strcase (last (dstp_pdf2lst root "\\"))))
    )
  )
)
;
; --- add slidename from long filename
;
(defun symblman_extsldnam ()
  (if (/= sldfil "")
    (progn
      (setq fnd 0)
      (setq pos (strlen sldfil))
      (repeat (strlen sldfil)
        (setq chkchr (substr sldfil pos 1))
        (if (= chkchr ".")
          (if (= fnd 0)
            (setq fnd pos)
          )
        )
        (setq pos (1- pos))
      )
      (setq root (substr sldfil 1 (- fnd 1)))
      ;(setq root (car (dstp_pdf2lst sldfil ".")))
      (setq blksld (last (dstp_pdf2lst root "\\")))
      (setq blksld (strcase (strcat blksld ".SLD")))
    )
  )
)
;
; --- scan data to fill popups
;
(defun symblman_bldpoplst ()
  (setq poplst (list "*"))
  (foreach rec dstp_symblman_symlst
    (setq chkgrp (nth 0 rec))
    (if (and (/= chkgrp "")(not (member (strcase chkgrp) poplst)))
      (setq poplst (append poplst (list (strcase chkgrp))))
    )
  )
  (setq poplst (acad_strlsort poplst))
  (setq chk (member dstp_symblgrp poplst))
  (if (/= chk nil)
    (setq grpsel (itoa (- (length poplst) (length chk))))
  )
)
;
; --- fill popup with data
;
(defun symblman_filpoplst ()
  (start_list "grppop")
  (foreach rec poplst
    (add_list rec)
  ) 
  (end_list)
  (set_tile "grppop" grpsel)
)
;
; --- select group name
;
(defun symblman_dogrpsel ()
  (setq tmp (dstp_tablesel "Select Group" (cdr poplst) "s" ""))
  (if (and (/= tmp nil)(/= tmp ""))
    (progn
      (setq blkgrp (strcase tmp))
      (set_tile "blkgrp" blkgrp)
    )
  )
)
;
; --- select layer name
;
(defun symblman_dolaysel ()
  (setq lst nil)
  (setq tmp (dstp_bldlst "LAYER"))
  (foreach lay tmp
    (if (not (dstp_instr lay "|"))
      (setq lst (cons lay lst))
    )
  )
  (setq lst (acad_strlsort lst))
  (setq tmp (dstp_tablesel "Select Layer" lst "s" ""))
  (if (/= tmp nil)
    (progn
      (setq inslay tmp)
      (set_tile "inslay" inslay)
    )
  )
)
;
; --- select color
;
(defun symblman_docolsel ()
  (if (/= inscol "")
    (setq col (dstp_str2col inscol))
    (setq col 256)
  )
  (setq chk (acad_colordlg col))
  (if (/= chk nil)
    (progn
      (setq inscol (dstp_col2str chk))
      (set_tile "inscol" inscol)
    )
  )
)
;
; --- build item array with qualifiers
;
(defun symblman_blditmlst ()
  (setq itmlst nil)
  (setq tmpdes "")
  (foreach rec dstp_symblman_symlst
    (setq chkgrp (nth 0 rec))
    (if (= lstmth "2")
      (progn
        (setq tmpdes (nth 4 rec))
        (if (= tmpdes "")
          (setq tmpdes (nth 1 rec))
        )
      )
    )
    (if (or (= dstp_symblgrp "*")(= (strcase chkgrp) dstp_symblgrp))
      (setq itmlst (append itmlst (list (list (nth 0 rec) (nth 1 rec) tmpdes (nth 3 rec)))))
    )
  )
  (if (= (not vl-sort) T)
    (if (= lstmth "1")
      (setq itmlst (dstp_lstsort itmlst 1 nil))
      (setq itmlst (dstp_lstsort itmlst 2 nil))
    )
    (if (= lstmth "1")
      (setq itmlst (vl-sort itmlst (function (lambda (e1 e2)(< (nth 1 e1)(nth 1 e2))))))
      (setq itmlst (vl-sort itmlst (function (lambda (e1 e2)(< (nth 2 e1)(nth 2 e2))))))
    )
  )
)
;
; --- update popup & list box
;
(defun symblman_filitmlst ()
  (if (= lstmth "1")
    (progn
      (start_list "itmlst")
      (foreach rec itmlst
        (add_list (nth 1 rec))
      )
      (end_list)
      (set_tile "lstnam" "1")
    )
    (progn
      (start_list "itmlst")
      (foreach rec itmlst
        (add_list (nth 2 rec))
      )
      (end_list)
      (set_tile "lstdes" "1")
    )
  )
)
;
; --- new list item chosen
;
(defun symblman_evtitmlst ()
  (if (= itmchg T)
    (symblman_itmupd)
  )
  (setq itmrec nil)
  (setq itmsel (atoi itmsel))
  (setq itm (nth itmsel itmlst))
  (if (/= itm nil)
    (progn
      (setq ctr 0)
      (setq done nil)
      (while (= done nil)
        (setq chk (nth ctr dstp_symblman_symlst))
        (if (and (= (nth 0 itm) (nth 0 chk))
                 (= (nth 1 itm) (nth 1 chk)))
          (progn
            (setq itmrec chk)
            (setq done T)
          )
        )
        (setq ctr (1+ ctr))
        (if (= ctr (length dstp_symblman_symlst))
          (setq done T)
        )
      )
      (if (/= itmrec nil)
        (progn
          (setq blkgrp (strcase (nth 0 chk)))
          (setq blknam (nth 1 chk))
          (setq blkfil (nth 2 chk))
          (setq blksld (nth 3 chk))
          (setq blkdes (nth 4 chk))
          (setq xscale (nth 5 chk))
          (setq yscale (nth 6 chk))
          (setq zscale (nth 7 chk))
          (setq rotate (nth 8 chk))
          (setq inslay (nth 9 chk))
          (setq inscol (nth 10 chk))
          (setq inselv (nth 11 chk))
          (setq insthk (nth 12 chk))
          (setq insexp (nth 13 chk))
          (setq attpmt (nth 14 chk))
          (setq runbef (nth 15 chk)) ; NEW (Data)
          (setq runaft (nth 16 chk)) ; NEW (Data)
          (setq osnval (nth 17 chk)) ; NEW (Data)
          (setq ortins (nth 18 chk)) ; NEW (Data)
          (setq mskmth (nth 19 chk)) ; NEW (Data)
          (setq atthor (nth 20 chk)) ; NEW (Data)
          (symblman_displin)
        )
      )
    )
  )
)
;
; --- reset running variables
;
(defun symblman_setdef ()
  (setq blknam "")
  (setq blkfil "")
  (setq blksld "")
  (setq blkdes "")
  (setq blkgrp "")
  (setq xscale (dstp_regfetch "Symblman" "xscale" "Dimscale"))
  (setq yscale (dstp_regfetch "Symblman" "yscale" "Dimscale"))
  (setq zscale (dstp_regfetch "Symblman" "zscale" "Dimscale"))
  (setq rotate (dstp_regfetch "Symblman" "rotate" "0"))
  (setq inslay (dstp_regfetch "Symblman" "inslay" ""))
  (setq inscol (dstp_regfetch "Symblman" "inscol" ""))
  (setq inselv (dstp_regfetch "Symblman" "inselv" ""))
  (setq insthk (dstp_regfetch "Symblman" "insthk" ""))
  (setq insexp (dstp_regfetch "Symblman" "insexp" "0"))
  (setq attpmt (dstp_regfetch "Symblman" "attpmt" "1"))
  (setq runbef (dstp_regfetch "Symblman" "runbef" ""))
  (setq runaft (dstp_regfetch "Symblman" "runaft" ""))
  (setq osnval (dstp_regfetch "Symblman" "osnval" ""))
  (setq ortins (dstp_regfetch "Symblman" "ortins" "0"))
  (setq mskmth (dstp_regfetch "Symblman" "mskmth" "1"))
  (setq atthor (dstp_regfetch "Symblman" "atthor" "0"))
)
;
; --- check field caps
;
(defun symblman_chkfldcap ()
  (setq blkgrp (strcase blkgrp))
  (setq blknam (strcase blknam))
  (setq blkfil (strcase blkfil))
  (setq blksld (strcase blksld))
  (setq inslay (strcase inslay))
  (setq inscol (strcase inscol))
)
;
; --- select block file
;
(defun symblman_doblksel ()
  (if (= blkfil nil)(setq blkfil ""))
  (setq tmp (dstp_getfiles "Select Symbol File" blkfil "dwg" 0))
  (if (/= tmp nil)
    (progn
      (setq blkfil (strcase tmp))
      (symblman_extblknam)
      (set_tile "blkfil" blkfil)
      (setq blksld (strcase (strcat root ".SLD")))
      (set_tile "blksld" blksld)
    )
  )
)
;
; --- select slide file
;
(defun symblman_dosldsel ()
  (if (= sldfil nil)(setq sldfil ""))
  (setq tmp (dstp_getfiles "Select Slide File" sldfil "sld" 0))
  (if (/= tmp nil)
    (progn
      (setq sldfil tmp)
      (symblman_extsldnam)
      (set_tile "blksld" blksld)
    )
  )
)
;
; --- clearup for new item
;
(defun symblman_itmnew ()
  (symblman_setdef)
  (symblman_displin)
  (set_tile "itmlst" "")
  (mode_tile "blknam" 2)
)
;
; --- add item to list
;
(defun symblman_itmadd ()
  (if (/= blkfil "")
    (progn
      (setq root (GetFileNameWithoutExtension blkfil))
      (setq blknam (strcase (last (dstp_pdf2lst root "\\"))))
      (setq fnd nil)
      (foreach rec dstp_symblman_symlst
        (if (and (= blkgrp (nth 0 rec))(= blknam (nth 1 rec)))
          (progn
            (setq fnd T)
            (alert "Cannot ADD, this block exists in this group.")
          )
        )
      )
      (if (= fnd nil)
        (progn
          (if (= blkdes nil)(setq blkdes ""))
          (setq new (list blkgrp blknam blkfil blksld blkdes
                          xscale yscale zscale rotate
                          inslay inscol inselv insthk
                          insexp attpmt runbef runaft
                          osnval ortins mskmth atthor))
          (setq dstp_symblman_symlst (append dstp_symblman_symlst (list new)))
          (symblman_bldpoplst)
          (symblman_filpoplst)
          (symblman_blditmlst)
          (symblman_filitmlst)
          (symblman_dotitle)
          (setq itmchg nil)
        )
      )
    )
  )
)
;
; --- update item in list
;
(defun symblman_itmupd ()
  (setq fnd nil)
  (setq old itmrec)
  (if (/= old nil)
    (progn
      (foreach rec dstp_symblman_symlst
        (if (and (/= rec old)(= blkgrp (nth 0 rec))(= blknam (nth 1 rec)))
          (progn
            (setq fnd T)
            (alert "Cannot UPDATE, this block exists in the assigned group.")
          )
        )
      )
      (if (= fnd nil)
        (progn
          (if (/= blkfil "")
            (progn
              (symblman_chkfldcap)
              (setq new (list blkgrp blknam blkfil blksld blkdes
                              xscale yscale zscale rotate
                              inslay inscol inselv insthk
                              insexp attpmt runbef runaft
                              osnval ortins mskmth atthor))
              (setq dstp_symblman_symlst (subst new old dstp_symblman_symlst))
              (setq itmrec new)
              (if (= grpchg T)
                (progn
                  (symblman_bldpoplst)
                  (symblman_filpoplst)
                  (setq ctr 0)
                  (setq pop "")
                  (foreach itm poplst
                    (if (= itm dstp_symblgrp)
                      (progn
                        (setq pop (itoa ctr))
                        (set_tile "grppop" pop)
                        (setq namchg T)
                      )
                    )
                    (setq ctr (1+ ctr))
                  )
                  (setq grpchg nil)
                )
              )
              (if (= namchg T)
                (progn
                  (symblman_blditmlst)
                  (symblman_filitmlst)
                  (setq namchg nil)
                )
              )
              (setq itmchg nil)
            )
          )
        )
      )
    )
  )
)
;
; --- display selected itm after read
;
(defun symblman_displin ()
  (set_tile "blkgrp" blkgrp)
  (set_tile "blknam" blknam)
  (set_tile "blkfil" blkfil)
  (set_tile "blksld" blksld)
  (set_tile "blkdes" blkdes)
  (set_tile "xscale" xscale)
  (set_tile "yscale" yscale)
  (set_tile "zscale" zscale)
  (set_tile "rotate" rotate)
  (if (= rotate "")
    (set_tile "drgrot" "1")
    (set_tile "drgrot" "0")
  )
  (set_tile "inslay" inslay)
  (set_tile "inscol" inscol)
  (set_tile "inselv" inselv)
  (set_tile "insthk" insthk)
  (set_tile "osnval" osnval)
  (set_tile "insexp" insexp)
  (set_tile "attpmt" attpmt)
  (set_tile "runbef" runbef)
  (set_tile "runaft" runaft)
  (set_tile "osnval" osnval)
  (set_tile "ortins" ortins)
  (set_tile "atthor" atthor)
  (cond
    ((= mskmth "1")(set_tile "msknon" "1"))
    ((= mskmth "2")(set_tile "msktrm" "1"))
    ((= mskmth "3")(set_tile "msksol" "1"))
    ((= mskmth "4")(set_tile "mskwip" "1"))
    ((= mskmth "5")(set_tile "mskimg" "1"))
    (t nil)
  )
  (if (/= blkfil "")
    (progn
      (setq sldfil blksld)
      (setq x (dimx_tile "symbol"))
      (setq y (dimy_tile "symbol"))
      (start_image "symbol")
      (fill_image 0 0 x y -2)
      (slide_image 0 0 x y sldfil)
      (end_image)
    )
    (progn
      (setq x (dimx_tile "symbol"))
      (setq y (dimy_tile "symbol"))
      (start_image "symbol")
      (fill_image 0 0 x y -2)
      (end_image)
    )
  )
)
;
; --- export data to csv file
;
(defun expdata_lstcon (op / inc)
  (if (= op 0)
    (progn
      (setq srcsel "")
      (set_tile "srclst" srcsel)
    )
    (progn
      (setq tmp "")
      (setq inc 0)
      (repeat (length srclst)
        (setq tmp (strcat tmp (itoa inc) " "))
        (setq inc (1+ inc))
      )
      (setq srcsel tmp)
      (set_tile "srclst" srcsel)
    )
  )
)
;
(defun expdata_wrtfile ()
  (if (and (/= tarfil nil)(/= tarfil ""))
    (progn
      (setq codlst (dstp_pdf2lst srcsel " "))
      (setq wrtlst nil)
      (foreach itm codlst
        (setq tmp (nth (atoi itm) srclst))
        (setq wrtlst (append wrtlst (list tmp)))
      )
      (setq codlst nil)
      ;
      (setq fh (open tarfil "w"))
      (princ "\nDS> Creating Export File ... Open ... Writing ... \rDS> Creating Export File ... Open ... Writing ... ")
      ;
      (princ "Group," fh)
      (princ "Block," fh)
      (princ "File," fh)
      (princ "Slide," fh)
      (princ "Description," fh)
      (princ "XScale," fh)
      (princ "YScale," fh)
      (princ "ZScale," fh)
      (princ "Rotation," fh)
      (princ "Layer," fh)
      (princ "Color," fh)
      (princ "Elevation," fh)
      (princ "Thickness," fh)
      (princ "Exploded," fh)
      (princ "AttPrompt," fh)
      (princ "RunBefore," fh)
      (princ "RunAfter," fh)
      (princ "OsnapVal," fh)
      (princ "OrthoOn," fh)
      (princ "MaskMeth," fh)
      (princ "AttHorz" fh)
      (foreach rec dstp_symblman_symlst
        (if (member (strcase (nth 0 rec)) wrtlst)
          (progn
            (setq ctr 0)
            (foreach itm rec
              (if (= ctr 0)(princ "\n" fh))
              (princ itm fh)
              (if (< ctr 20)(princ dstp_csvchar fh))
              (setq ctr (1+ ctr))
            )
          )
        )
      )
      (setq wrtlst nil)
      (close fh)
      (princ "Done.\r")
    )
  )
)

(defun expdata_tarsel ()
  (if (= tarfil nil)(setq tarfil ""))
  (setq tmp (dstp_getfiles "Export File Name" "" "csv" 1))
  (if (/= tmp nil)
    (progn
      (setq tarfil tmp)
      (set_tile "tarfil" tarfil)
    )
  )
)

(defun symblman_expdata ()
  (setq doproc nil)
  (setq tarfil "")
  (if (> (length dstp_symblman_symlst) 0)
    (progn
      (setq srclst nil)
      (setq tarfil (strcat dstpdir "EXPORT.CSV"))
      (foreach rec poplst
        (if (/= rec "*")
          (setq srclst (append srclst (list rec)))
        )
      ) 
      ;
      (if (not (new_dialog "export" dcl_id)) (exit))
      (set_tile "tarfil" tarfil)
      (start_list "srclst")
      (foreach rec srclst
        (add_list rec)
      ) 
      (end_list)
      (expdata_lstcon 1)
      ;
      (action_tile "write" "(if (or (= tarfil nil)(= tarfil \"\"))(alert \"Filename Not Specified\")(expdata_wrtfile))")
      (action_tile "srclst" "(setq srcsel $value)")
      (action_tile "cancel" "(done_dialog 1)")
      (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
      (action_tile "selall" "(expdata_lstcon 1)")
      (action_tile "clrall" "(expdata_lstcon 0)")
      (action_tile "tarfil" "(setq tarfil $value)")
      (action_tile "tarsel" "(expdata_tarsel)")
      (start_dialog)
    )
    (alert "Nothing To Export")
  )
)
;
; --- load or merge data from csv file
;
(defun symblman_loddata ()
  (setq str "DS> WARNING: Import Utility ignores first (header) line of file!")
  (princ (strcat "\n" str "\r" str))
  (setq fn (dstp_getfiles "Import Symbol Specification Data" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "csv" 0))
  (if (/= fn nil)
    (progn
      (setq fh (open fn "r"))
      (if (/= fh nil)
        (progn
          (if (= clrlst T)
            (progn
              (setq dstp_symblman_symlst nil)
              (princ "\nDS> IMPORT: Data File ... Open ... Reading ... \rDS> IMPORT: Data File ... Open ... Reading ... ")
            )
            (princ "\nDS> MERGE: Data File ... Open ... Reading ... \rDS> MERGE: Data File ... Open ... Reading ... ")
          )
          (read-line fh) ; header line
          (setq done nil)
          (setq ctr 0)
          (while (= done nil)
            (setq tmp (read-line fh))
            (if (/= tmp nil)
              (progn
                (setq ctr (1+ ctr))
                (set_tile "title" (strcat "Processing Line " (itoa ctr) " of file."))
                (if (= tmp nil)
                  (setq done T)
                  (progn
                    (setq new (dstp_pdf2lst tmp dstp_csvchar))
                    (if (= (length new) 15) ; old 2.0 format
                      (setq new (append new (list runbef runaft osnval ortins mskmth atthor)))
                    )
                    (if (= (length new) 21)
                      (progn
                        (setq old nil)
                        (foreach rec dstp_symblman_symlst
                          (if (and (= (nth 0 new)(nth 0 rec))(= (nth 1 new)(nth 1 rec)))
                            (setq old rec)
                          )
                        )
                        (if (= old nil)
                          (setq dstp_symblman_symlst (append dstp_symblman_symlst (list new)))
                          (setq dstp_symblman_symlst (subst new old dstp_symblman_symlst))
                        )
                      )
                    )
                  )
                )
              )
              (setq done T)
            )
          )
          (close fh)
          (princ "Done.\r")
          (symblman_bldpoplst)
          (symblman_blditmlst)
          (symblman_filpoplst)
          (symblman_filitmlst)
          (symblman_itmnew)
          (symblman_dotitle)
        )
      )
    )
  )
)
;
; --- check for existing xref/block definition
;
(defun symblman_tblchk (opt)
  (setq dopass nil)
  (if (/= blknam "")
    (progn
      (setq chk (tblsearch "BLOCK" blknam))
      (if (/= chk nil)
        (progn
          (cond
            ((= opt 1)
              (if (= (assoc 1 chk) nil)
                (setq dopass T)
                (alert "Currently Defined as XREF,\nCannot Block Insert!")
              )
            )
            ((= opt 2)
              (if (= (assoc 1 chk) nil)
                (alert "Currently Defined as BLOCK,\nCannot XREF Attach!")
                (setq dopass T)
              )
            )
            (t nil)
          )
        )
        (setq dopass T)
      )
    )
    (alert "No Symbol Selected!")
  )
)
;
; --- check for quotations in descriptions
;
(defun symblman_quotechk ()
  (setq chk (dstp_instr blkdes (chr 34)))
  (if (= chk T)
    (progn
      (setq blkdes (dstp_subtext blkdes (chr 34) "in"))
      (set_tile "blkdes" blkdes)
      (alert "Quotation Marks not allowed, changed to 'in'")
    )
  )
)
;
; --- new popup group chosen
;
(defun symblman_evtpoplst ()
  (setq dstp_symblgrp (nth (atoi grpsel) poplst))
  (symblman_blditmlst)
  (symblman_filitmlst)
  (symblman_setdef)
  (symblman_displin)
)
;
; --- Graphical Select Child Dialog
;
(defun grasel_paint ()
  (if (= tiletop 0)
    (setq pag "1")
    (setq pag (itoa (+ (/ tiletop 25) 1)))
  )
  (setq chk (/ (length itmlst) 25))
  (setq rvl (- (length itmlst) (* chk 25)))
  (if (> rvl 0)
    (setq tot (itoa (1+ chk)))
    (setq tot (itoa chk))
  )
  (set_tile "title" (strcat "ToolPac Symbol Manager - Page " pag " of " tot))
  (if (< tiletop (length itmlst))
    (if (> tiletop -1)
      (progn
        (setq ctr 1)
        (repeat 25
          (setq ttile (strcat "T" (itoa ctr)))
          (setq gtile (strcat "G" (itoa ctr)))
          (setq tvalu "")
          (setq gvalu "")
          (if (< (+ tiletop (- ctr 1)) (length itmlst))
            (progn
              (setq tvalu (nth 1 (nth (+ tiletop (- ctr 1)) itmlst)))
              (setq gvalu (nth 3 (nth (+ tiletop (- ctr 1)) itmlst)))
            )
          )
          (setq x (dimx_tile gtile))
          (setq y (dimy_tile gtile))
          (start_image gtile)
          (fill_image 0 0 x y -2)
          (if (/= gvalu "")
            (slide_image 0 0 x y gvalu)
          )
          (end_image)
          (set_tile ttile tvalu)
          (setq ctr (+ ctr 1))
        )
      )
    )
  )
  (if (>= (+ tiletop 25) (length itmlst))
    (mode_tile "next" 1)
    (mode_tile "next" 0)
  )
  (if (< (- tiletop 25) 0)
    (mode_tile "prev" 1)
    (mode_tile "prev" 0)
  )
  (setq oldtil nil)
  (setq oldval nil)
)

(defun grasel_listpos ()
  (setq itm (atoi itmsel))
  (if (and (>= itm tiletop)(< itm (+ tiletop 25)))
    (setq tmp nil)
    (progn
      (setq tmp (/ itm 25))
      (setq tiletop (* tmp 25))
      (grasel_paint)
    )
  )
  (setq pos (+ (- itm tiletop) 1))
  (if (/= oldtil nil)
    (progn
      (setq x (dimx_tile oldtil))
      (setq y (dimy_tile oldtil))
      (start_image oldtil)
      (fill_image 0 0 x y -2)
      (slide_image 0 0 x y oldval)
      (end_image)
    )
  )
  (setq gtile (strcat "G" (itoa pos)))
  (setq gvalu (nth 3 (nth (- (+ tiletop pos) 1) itmlst)))
  (setq x (dimx_tile gtile))
  (setq y (dimy_tile gtile))
  (start_image gtile)
  (fill_image 0 0 x y 9)
  (slide_image 0 0 x y gvalu)
  (end_image)
  (setq oldtil gtile)
  (setq oldval gvalu)
  (setq retcode itm)
)

(defun grasel_datpth ()
  (setq dstp_symblpth (nth (atoi datpth) datlst))
  (symblman_loaddata)
  (setq symbak dstp_symblman_symlst)
  (setq dstp_symblgrp "*")
  (setq grpsel "0")
  (symblman_bldpoplst)
  (symblman_blditmlst)
  (symblman_filpoplst)
  (symblman_filitmlst)
  (grasel_paint)
)

(defun symblman_grasel ()
  (if (> (length itmlst) 0)
    (progn
      (setq tiletop 0)
      (setq retcode nil)
      (if (not (new_dialog "blkmulti" dcl_id)) (exit))
      (if (<= (length itmlst) 25)
        (progn
          (mode_tile "prev" 1)
          (mode_tile "next" 1)
        )
      )
      (start_list "datlst")
      (foreach rec datlst
        (setq nam (last (dstp_pdf2lst rec "\\")))
        (add_list nam)
      )
      (end_list)
      (set_tile "datlst" (itoa (- (length datlst)(length (member dstp_symblpth datlst)))))
      (if (< (length datlst) 2)
        (mode_tile "datlst" 1)
      )
      (symblman_filpoplst)
      (symblman_filitmlst)
      (grasel_paint)
      (action_tile "datlst" "(setq datpth $value)(grasel_datpth)")
      (action_tile "grppop" "(setq grpsel $value)(symblman_evtpoplst)(grasel_paint)")
      (action_tile "itmlst" "(setq itmsel $value)(grasel_listpos)")
      (action_tile "detsel" "(setq dstp_symbldia 1)(done_dialog 0)")
      (action_tile "accept" "(setq diadone T)(done_dialog 1)")
      (action_tile "cancel" "(setq retcode nil)(setq diadone T)(done_dialog 1)")
      (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
      (action_tile "prev" "(setq tiletop (- tiletop 25))(grasel_paint)")
      (action_tile "next" "(setq tiletop (+ tiletop 25))(grasel_paint)")
      (action_tile "G1" "(setq retcode (+ tiletop 0))(setq diadone T)(done_dialog 1)")
      (action_tile "G2" "(setq retcode (+ tiletop 1))(setq diadone T)(done_dialog 1)")
      (action_tile "G3" "(setq retcode (+ tiletop 2))(setq diadone T)(done_dialog 1)")
      (action_tile "G4" "(setq retcode (+ tiletop 3))(setq diadone T)(done_dialog 1)")
      (action_tile "G5" "(setq retcode (+ tiletop 4))(setq diadone T)(done_dialog 1)")
      (action_tile "G6" "(setq retcode (+ tiletop 5))(setq diadone T)(done_dialog 1)")
      (action_tile "G7" "(setq retcode (+ tiletop 6))(setq diadone T)(done_dialog 1)")
      (action_tile "G8" "(setq retcode (+ tiletop 7))(setq diadone T)(done_dialog 1)")
      (action_tile "G9" "(setq retcode (+ tiletop 8))(setq diadone T)(done_dialog 1)")
      (action_tile "G10" "(setq retcode (+ tiletop 9))(setq diadone T)(done_dialog 1)")
      (action_tile "G11" "(setq retcode (+ tiletop 10))(setq diadone T)(done_dialog 1)")
      (action_tile "G12" "(setq retcode (+ tiletop 11))(setq diadone T)(done_dialog 1)")
      (action_tile "G13" "(setq retcode (+ tiletop 12))(setq diadone T)(done_dialog 1)")
      (action_tile "G14" "(setq retcode (+ tiletop 13))(setq diadone T)(done_dialog 1)")
      (action_tile "G15" "(setq retcode (+ tiletop 14))(setq diadone T)(done_dialog 1)")
      (action_tile "G16" "(setq retcode (+ tiletop 15))(setq diadone T)(done_dialog 1)")
      (action_tile "G17" "(setq retcode (+ tiletop 16))(setq diadone T)(done_dialog 1)")
      (action_tile "G18" "(setq retcode (+ tiletop 17))(setq diadone T)(done_dialog 1)")
      (action_tile "G19" "(setq retcode (+ tiletop 18))(setq diadone T)(done_dialog 1)")
      (action_tile "G20" "(setq retcode (+ tiletop 19))(setq diadone T)(done_dialog 1)")
      (action_tile "G21" "(setq retcode (+ tiletop 20))(setq diadone T)(done_dialog 1)")
      (action_tile "G22" "(setq retcode (+ tiletop 21))(setq diadone T)(done_dialog 1)")
      (action_tile "G23" "(setq retcode (+ tiletop 22))(setq diadone T)(done_dialog 1)")
      (action_tile "G24" "(setq retcode (+ tiletop 23))(setq diadone T)(done_dialog 1)")
      (action_tile "G25" "(setq retcode (+ tiletop 24))(setq diadone T)(done_dialog 1)")
      (start_dialog)
    )
    (progn
      (alert "Nothing To Select From!")
      (setq dstp_symbldia 1)
    )
  )
)

(defun symblman_grachk ()
  (if (/= retcode nil)
    (progn
      (setq itmsel (itoa retcode))
      (set_tile "itmlst" itmsel)
      (symblman_evtitmlst)
    )
  )
)
;
; --- load data from file
;
(defun symblman_loaddata ()
  (setq dstp_symblman_symlst nil)
  (setq fh (open dstp_symblpth "r"))
  (if (/= fh nil)
    (progn
      (princ "\nDS> Symbol Data File ... Open ... \rDS> Symbol Data File ... Open ... ")
      (setq chk (read-line fh))
      (if (= chk "TP60SYM")
        (progn
          (princ "Reading ... ")
          (read-line fh)
          (read-line fh)
          (setq dstp_symblman_symlst (read (read-line fh)))
          (princ "Done.\r")
          (close fh)
          (if (> (atoi (getvar "ACADVER")) 13)
            (if (/= (not vl-file-systime) T)
              (setq dstp_symblman_fildat (vl-file-systime dstp_symblpth))
            )
          )
          (symblman_dorogray)
        )
        (progn
          (close fh)
          (alert "File appears invalid")
        )
      )
    )
  )
)
;
; --- save data to file
;
(defun symblman_savedata ()
  (if (/= dstp_symblpth nil)
    (setq fn dstp_symblpth)
    (setq fn (findfile (strcat dstpdir "data\\symblman.sdb")))
  )
  (if (= fn nil)
    (setq fn (strcat dstpdir "data\\symblman.sdb"))
  )
  (setq pass T)
  (if (/= (dstp_fexist fn) nil)
    (if (= (filereadonly fn) T)
      (setq pass nil)
    )
  )
  (if (= pass T)
    (progn
      (setq fh (open fn "w"))
      (princ "TP60SYM" fh)
      (princ "\nToolPac 6.0 Symbol Data File" fh)
      (princ "\n----------------------------" fh)
      (print dstp_symblman_symlst fh)
      (dstp_echoline "DS> Updating Symbol Data File ... Done." T)
      (close fh)
      (if (/= (not vl-file-systime) T)
        (setq dstp_symblman_fildat (vl-file-systime fn))
      )
    )
  )
)

(defun fndrep_replace (val)
  (if (= whl "1")
    (if (or (= fnd "")(= (strcase val) fnd))
      (setq ret rep)
      (setq ret val)
    )
    (if (dstp_instr val fnd)
      (setq ret (dstp_subtext val fnd rep))
      (setq ret val)
    )
  )
  (setq tmp ret)
)

(defun fndrep_process ()
  (if (= (get_tile "frblock") "1")(setq frblock T)(setq frblock nil))
  (if (= (get_tile "frslide") "1")(setq frslide T)(setq frslide nil))
  (if (= (get_tile "frdesc") "1")(setq frdesc T)(setq frdesc nil))
  (if (= (get_tile "frgroup") "1")(setq frgroup T)(setq frgroup nil))
  (if (= (get_tile "frlayer") "1")(setq frlayer T)(setq frlayer nil))
  (if (= (get_tile "frcolor") "1")(setq frcolor T)(setq frcolor nil))
  (if (= (get_tile "frelev") "1")(setq frelev T)(setq frelev nil))
  (if (= (get_tile "frthick") "1")(setq frthick T)(setq frthick nil))
  (if (= (get_tile "frxscale") "1")(setq frxscale T)(setq frxscale nil))
  (if (= (get_tile "fryscale") "1")(setq fryscale T)(setq fryscale nil))
  (if (= (get_tile "frzscale") "1")(setq frzscale T)(setq frzscale nil))
  (if (= (get_tile "frrotate") "1")(setq frrotate T)(setq frrotate nil))
  (if (= (get_tile "frexplode") "1")(setq frexplode T)(setq frexplode nil))
  (if (= (get_tile "frattpmt") "1")(setq frattpmt T)(setq frattpmt nil))
  (if (= (get_tile "frrunbef") "1")(setq frrunbef T)(setq frrunbef nil))
  (if (= (get_tile "frrunaft") "1")(setq frrunaft T)(setq frrunaft nil))
  (if (= (get_tile "frosnval") "1")(setq frosnval T)(setq frosnval nil))
  (if (= (get_tile "frortins") "1")(setq frortins T)(setq frortins nil))
  (if (= (get_tile "frmskmth") "1")(setq frmskmth T)(setq frmskmth nil))
  (if (= (get_tile "fratthor") "1")(setq fratthor T)(setq fratthor nil))
  (setq fnd (get_tile "fnd"))
  (setq rep (get_tile "rep"))
  (setq whl (get_tile "whl"))
  ;
  (if (= fnd "")
    (setq whl "1")
    (setq fnd (strcase fnd))
  )
  (setq tmp dstp_symblman_symlst)
  (setq dstp_symblman_symlst nil)
  (setq num (length tmp) itm 0)
  (foreach chk tmp
    (setq title (strcat "Processing " (itoa (1+ itm)) " of " (itoa num)))
    (set_tile "title" title)
    (if (or (= dstp_symblgrp "*")(= (strcase (nth 0 chk)) dstp_symblgrp))
      (progn
        (setq blkgrp (strcase (nth 0 chk)))
        (setq blknam (nth 1 chk))
        (setq blkfil (nth 2 chk))
        (setq blksld (nth 3 chk))
        (setq blkdes (nth 4 chk))
        (setq xscale (nth 5 chk))
        (setq yscale (nth 6 chk))
        (setq zscale (nth 7 chk))
        (setq rotate (nth 8 chk))
        (setq inslay (nth 9 chk))
        (setq inscol (nth 10 chk))
        (setq inselv (nth 11 chk))
        (setq insthk (nth 12 chk))
        (setq insexp (nth 13 chk))
        (setq attpmt (nth 14 chk))
        (setq runbef (nth 15 chk))
        (setq runaft (nth 16 chk))
        (setq osnval (nth 17 chk))
        (setq ortins (nth 18 chk))
        (setq mskmth (nth 19 chk))
        (setq atthor (nth 20 chk))
        ;
        (if (= frblock T)
          (progn
            (setq blkfil (fndrep_replace blkfil))
            (setq root (GetFileNameWithoutExtension blkfil))
            (setq blknam (strcase (last (dstp_pdf2lst root "\\"))))
          )
        )
        (if (= frslide T)(setq blksld (fndrep_replace blksld)))
        (if (= frdes T)(setq blkdes (fndrep_replace blkdes)))
        (if (= frgroup T)(setq blkgrp (strcase (fndrep_replace blkgrp))))
        (if (= frlayer T)(setq inslay (fndrep_replace inslay)))
        (if (= frcolor T)(setq inscol (fndrep_replace inscol)))
        (if (= frelev T)(setq inselv (fndrep_replace inselv)))
        (if (= frthick T)(setq insthk (fndrep_replace insthk)))
        (if (= frxscale T)(setq xscale (fndrep_replace xscale)))
        (if (= fryscale T)(setq yscale (fndrep_replace yscale)))
        (if (= frzscale T)(setq zscale (fndrep_replace zscale)))
        (if (= frrotate T)(setq rotate (fndrep_replace rotate)))
        (if (= frexplode T)(setq insexp (fndrep_replace insexp)))
        (if (= frattpmt T)(setq attpmt (fndrep_replace attpmt)))
        (if (= frrunbef T)(setq runbef (fndrep_replace runbef)))
        (if (= frrunaft T)(setq runaft (fndrep_replace runaft)))
        (if (= frosnval T)(setq osnval (fndrep_replace osnval)))
        (if (= frortins T)(setq ortins (fndrep_replace ortins)))
        (if (= frmskmth T)(setq mskmth (fndrep_replace mskmth)))
        (if (= fratthor T)(setq atthor (fndrep_replace atthor)))
        ;
        (setq new (list blkgrp blknam blkfil blksld blkdes
                        xscale yscale zscale rotate
                        inslay inscol inselv insthk
                        insexp attpmt runbef runaft
                        osnval ortins mskmth atthor))
        (setq dstp_symblman_symlst (cons new dstp_symblman_symlst))
      )
      (setq dstp_symblman_symlst (cons chk dstp_symblman_symlst))
    )
    (setq itm (+ itm 1))
  )
)
;
; --- find & replace data
;
(defun symblman_fndrep ()
  (if (> (length dstp_symblman_symlst) 0)
    (progn
      (if (not (new_dialog "fndrep" dcl_id)) (exit))
      (action_tile "process" "(fndrep_process)(done_dialog 1)")
      (action_tile "cancel" "(done_dialog 1)")
      (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
      (start_dialog)
    )
    (alert "Nothing To Process")
  )
  (if (> (length dstp_symblman_symlst) 0)
    (progn
      (setq grpsel "0")
      (setq dstp_symblgrp "*")
      (symblman_bldpoplst)
      (symblman_blditmlst)
      (symblman_filpoplst)
      (symblman_filitmlst)
      (symblman_itmnew)
      (symblman_dotitle)
    )
  )
)
;
; --- add multiple drawings
;
(defun symblman_doaddmul ()
  (if (= itmchg T)
    (symblman_itmupd)
  )
  (symblman_maddgroup)  ;mdstp_symblgrp
  (if (/= mdstp_symblgrp nil)
    (progn
      (if (= blkdes nil)
        (setq blkdes "")
      )
      (setq flst (dstp_getfilex "Select Drawing Files" nil "dwg"))
      (if (/= flst nil)
        (progn
          (if (> (length flst) 1)
            (setq flst (acad_strlsort flst))
          )
          (if (= mdstp_symblgrp "")
            (progn
              (setq lst (dstp_pdf2lst (last flst) "\\"))
              (setq mdstp_symblgrp (strcase (nth (- (length lst) 2) lst)))
            )
          )
          (setq ctr 0)
          (foreach blkfil flst
            (setq ctr (1+ ctr))
            (set_tile "title" (strcat "Processing Drawing " (itoa ctr) " of " (itoa (length flst))))
            (setq blkfil (strcase blkfil))
            (setq root (GetFileNameWithoutExtension blkfil))
            (setq blknam (strcase (last (dstp_pdf2lst root "\\"))))
            (setq blksld (strcase (strcat root ".SLD")))
            (setq new (list mdstp_symblgrp blknam blkfil blksld blkdes
                            xscale yscale zscale rotate
                            inslay inscol inselv insthk
                            insexp attpmt runbef runaft
                            osnval ortins mskmth atthor))
            (setq old nil)
            (foreach rec dstp_symblman_symlst
              (if (and (= mdstp_symblgrp (nth 0 rec))(= blknam (nth 1 rec)))
                (setq old rec)
              )
            )
            (if (= old nil)
              (setq dstp_symblman_symlst (append dstp_symblman_symlst (list new)))
              (setq dstp_symblman_symlst (subst new old dstp_symblman_symlst))
            )
          )
          (symblman_bldpoplst)
          (symblman_blditmlst)
          (symblman_filpoplst)
          (symblman_filitmlst)
          (symblman_itmnew)
          (symblman_dotitle)
        )
      )
    )
  )
)
;
; --- add all dwgs in dir
;
(defun symblman_doadddir ()
  (if (= itmchg T)
    (symblman_itmupd)
  )
  (symblman_maddgroup)  ;mdstp_symblgrp
  (if (/= mdstp_symblgrp nil)
    (progn
      (if (= blkdes nil)
        (setq blkdes "")
      )
      (setq dir (dstp_getfolder "Select Directory" nil))
      (if (/= dir nil)
        (progn
          (if (= mdstp_symblgrp "")
            (setq mdstp_symblgrp (strcase (last (dstp_pdf2lst dir (chr 92)))))
          )
          (setq flst (vl-directory-files dir "*.dwg" 0))
          (if (/= flst nil)
            (progn
              (setq ctr 0)
              (setq flst (acad_strlsort flst))
              (foreach blkfil flst
                (setq ctr (1+ ctr))
                (set_tile "title" (strcat "Processing Drawing " (itoa ctr) " of " (itoa (length flst))))
                (setq blkfil (strcase (strcat dir "\\" blkfil)))
                (setq root (GetFileNameWithoutExtension blkfil))
                (setq blknam (strcase (last (dstp_pdf2lst root "\\"))))
                (setq blksld (strcase (strcat root ".SLD")))
                (setq new (list mdstp_symblgrp blknam blkfil blksld blkdes
                                xscale yscale zscale rotate
                                inslay inscol inselv insthk
                                insexp attpmt runbef runaft
                                osnval ortins mskmth atthor))
                (setq old nil)
                (foreach rec dstp_symblman_symlst
                  (if (and (= mdstp_symblgrp (nth 0 rec))(= blknam (nth 1 rec)))
                    (setq old rec)
                  )
                )
                (if (= old nil)
                  (setq dstp_symblman_symlst (append dstp_symblman_symlst (list new)))
                  (setq dstp_symblman_symlst (subst new old dstp_symblman_symlst))
                )
              )
              (symblman_bldpoplst)
              (symblman_blditmlst)
              (symblman_filpoplst)
              (symblman_filitmlst)
              (symblman_itmnew)
              (symblman_dotitle)
            )
          )
        )
      )
    )
  )
)
;
; --- delete multiple records
;
(defun symblman_delgroup ()
  (setq tmp (dstp_tablesel "Select Group" (cdr poplst) "s" ""))
  (if (and (/= tmp nil)(/= tmp ""))
    (progn
      (setq newlst nil)
      (setq blkgrp (strcase tmp))
      (foreach rec dstp_symblman_symlst
				(setq grp (strcase (nth 0 rec)))
				(if (/= grp blkgrp)
          (setq newlst (append newlst (list rec)))
			  )
      )
      (setq dstp_symblman_symlst newlst)
      (setq newlst nil)
    )
  )
)

(defun delmulti_process ()
  (setq uct 1 dellst nil)
  (while (setq tabitm (read delsel))
    (setq respitm (nth tabitm itmlst))
    (setq dellst (append dellst (list respitm)))
    (while (and (/= " " (substr delsel uct 1))
                (/= "" (substr delsel uct 1)))
           (setq uct (1+ uct)))
    (setq delsel (substr delsel uct))
  )
  (if (/= dellst nil)
    (progn
      (setq tmp nil)
      (foreach rec dstp_symblman_symlst
        (setq fnd nil)
        (foreach itm dellst
          (if (and (= (nth 0 rec) (nth 0 itm)) (= (nth 1 rec) (nth 1 itm)))
            (setq fnd T)
          )
        )
        (if (= fnd nil)
          (setq tmp (append tmp (list rec)))
        )
      )
      (setq dstp_symblman_symlst tmp)
      (setq tmp nil)
    )
  )
)

(defun symblman_delmulti ()
  (if (> (length dstp_symblman_symlst) 0)
    (progn
      (if (not (new_dialog "delmulti" dcl_id)) (exit))
      (start_list "dellst")
      (foreach rec itmlst
        (if (= lstmth "1")
          (add_list (nth 1 rec))
          (add_list (nth 2 rec))
        )
      )
      (end_list)
      ;
      (action_tile "dellst" "(setq delsel $value)")
      (action_tile "process" "(delmulti_process)(done_dialog 0)")
      (action_tile "cancel" "(done_dialog 1)")
      (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
      (start_dialog)
    )
    (alert "Nothing To Delete")
  )
)

(defun symblman_dlgreset ()
  (setq grpsel "0")
  (setq dstp_symblgrp "*")
  (symblman_bldpoplst)
  (symblman_blditmlst)
  (symblman_filpoplst)
  (symblman_filitmlst)
  (symblman_dotitle)
  (symblman_itmnew)
)

(defun maddgroup_dotoggle ()
  (if (= musedir "1")
    (progn
      (setq mdstp_symblgrp "")
      (set_tile "mgrplst" "")
      (set_tile "mdstp_symblgrp" mdstp_symblgrp)
      (mode_tile "mdstp_symblgrp" 1)
      (mode_tile "mgrplst" 1)
      (mode_tile "mgrpval" 1)
    )
    (progn
      (setq mdstp_symblgrp "")
      (set_tile "mgrplst" "")
      (set_tile "mdstp_symblgrp" mdstp_symblgrp)
      (mode_tile "mdstp_symblgrp" 0)
      (mode_tile "mgrplst" 0)
      (mode_tile "mgrpval" 0)
    )
  )
)

(defun symblman_maddgroup ()
  (setq mdstp_symblgrp "")
  (if (= musedir nil)
    (setq musedir "1")
  )
  (setq mgrplst nil)
  (foreach rec dstp_symblman_symlst
    (setq chkgrp (nth 0 rec))
    (if (and (/= chkgrp "")(not (member (strcase chkgrp) mgrplst)))
      (setq mgrplst (append mgrplst (list (strcase chkgrp))))
    )
  )
  ; 
  (if (not (new_dialog "maddgroup" dcl_id)) (exit))
  (if (/= mgrplst nil)
    (if (> (length mgrplst) 0)
      (progn
        (setq mgrplst (acad_strlsort mgrplst))
        (start_list "mgrplst")
        (foreach rec mgrplst
          (add_list rec)
        )
        (end_list)
      )
    )
  )
  (maddgroup_dotoggle)
  (set_tile "mdstp_symblgrp" mdstp_symblgrp)
  (set_tile "musedir" musedir)
  (action_tile "mgrplst" "(setq mdstp_symblgrp (strcase (nth (atoi $value) mgrplst)))(set_tile \"mdstp_symblgrp\" mdstp_symblgrp)")
  (action_tile "mgrpval" "(setq mdstp_symblgrp $value)")
  (action_tile "mdstp_symblgrp" "(setq mdstp_symblgrp (strcase $value))")
  (action_tile "musedir" "(setq musedir $value)(maddgroup_dotoggle)")
  (action_tile "accept" "(done_dialog 0)")
  (action_tile "cancel" "(setq mdstp_symblgrp nil)(done_dialog 1)")
  (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
  (start_dialog)
)
;
; --- alert user if cancelling and changes were made
;
(defun symblman_cancel ()
  (if (= datchg T)
    (if (< (getvar "EXPERT") 5)
      (progn
        (if (not (new_dialog "losechg" dcl_id)) (exit))
        (action_tile "msave" "(symblman_savedata)(done_dialog 1)")
        (action_tile "mdiscard" "(setq dstp_symblman_symlst symbak)(done_dialog 1)")
        (start_dialog)
      )
      (setq dstp_symblman_symlst symbak)
    )
  )
)
;
(defun symblman_dotitle ()
  (set_tile "title" (strcat "ToolPac Symbol Manager [" (itoa (length dstp_symblman_symlst)) "] Definitions"))
  (mode_tile "itmlst" 2)
)
;
; --- set osnap child dia
;
(defun symblman_osnapset ()
  (setq val (atoi osnval))
  (if (= (logand val 1) 1)(setq end "1")(setq end "0"))
  (if (= (logand val 2) 2)(setq mid "1")(setq mid "0"))
  (if (= (logand val 4) 4)(setq cen "1")(setq cen "0"))
  (if (= (logand val 8) 8)(setq nod "1")(setq nod "0"))
  (if (= (logand val 16) 16)(setq qua "1")(setq qua "0"))
  (if (= (logand val 32) 32)(setq int "1")(setq int "0"))
  (if (= (logand val 64) 64)(setq ins "1")(setq ins "0"))
  (if (= (logand val 128) 128)(setq per "1")(setq per "0"))
  (if (= (logand val 256) 256)(setq tan "1")(setq tan "0"))
  (if (= (logand val 512) 512)(setq nea "1")(setq nea "0"))
  (if (= (logand val 1024) 1024)(setq qui "1")(setq qui "0"))
  (if (= (logand val 2048) 2048)(setq app "1")(setq app "0"))
  ;  
  (if (not (new_dialog "setosnap" dcl_id)) (exit))
  (set_tile "end" end)
  (set_tile "mid" mid)
  (set_tile "cen" cen)
  (set_tile "nod" nod)
  (set_tile "qua" qua)
  (set_tile "int" int)
  (set_tile "ins" ins)
  (set_tile "per" per)
  (set_tile "tan" tan)
  (set_tile "nea" nea)
  (set_tile "qui" qui)
  (set_tile "app" app)
  (action_tile "end" "(setq end $value)")
  (action_tile "mid" "(setq mid $value)")
  (action_tile "cen" "(setq cen $value)")
  (action_tile "nod" "(setq nod $value)")
  (action_tile "qua" "(setq qua $value)")
  (action_tile "int" "(setq int $value)")
  (action_tile "ins" "(setq ins $value)")
  (action_tile "per" "(setq per $value)")
  (action_tile "tan" "(setq tan $value)")
  (action_tile "nea" "(setq nea $value)")
  (action_tile "qui" "(setq qui $value)")
  (action_tile "app" "(setq app $value)")
  (action_tile "accept" "(setq doproc T)(done_dialog 1)")
  (action_tile "cancel" "(done_dialog 1)")
  (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
  (start_dialog)
  (if (= doproc T)
    (progn
      (setq new 0)
      (if (= end "1")(setq new (+ new 1)))
      (if (= mid "1")(setq new (+ new 2)))
      (if (= cen "1")(setq new (+ new 4)))
      (if (= nod "1")(setq new (+ new 8)))
      (if (= qua "1")(setq new (+ new 16)))
      (if (= int "1")(setq new (+ new 32)))
      (if (= ins "1")(setq new (+ new 64)))
      (if (= per "1")(setq new (+ new 128)))
      (if (= tan "1")(setq new (+ new 256)))
      (if (= nea "1")(setq new (+ new 512)))
      (if (= qui "1")(setq new (+ new 1024)))
      (if (= app "1")(setq new (+ new 2048)))
      (setq osnval (itoa new))
      (setq itmchg T)
      (setq datchg T)
    )
  )
)
;
; --- save item defaults to registery per button
;
(defun symblman_savitmdef ()
  (dstp_regstore "Symblman" "xscale" xscale)
  (dstp_regstore "Symblman" "yscale" yscale)
  (dstp_regstore "Symblman" "zscale" zscale)
  (dstp_regstore "Symblman" "rotate" rotate)
  (dstp_regstore "Symblman" "inslay" inslay)
  (dstp_regstore "Symblman" "inscol" inscol)
  (dstp_regstore "Symblman" "inselv" inselv)
  (dstp_regstore "Symblman" "insthk" insthk)
  (dstp_regstore "Symblman" "insexp" insexp)
  (dstp_regstore "Symblman" "attpmt" attpmt)
  (dstp_regstore "Symblman" "runbef" runbef)
  (dstp_regstore "Symblman" "runaft" runaft)
  (dstp_regstore "Symblman" "osnval" osnval)
  (dstp_regstore "Symblman" "ortins" ortins)
  (dstp_regstore "Symblman" "mskmth" mskmth)
  (dstp_regstore "Symblman" "atthor" atthor)
)
;
; --- load defaults
;
(defun symblman_loadini ()
  (if (= dstp_symblgrp nil)
    (setq dstp_symblgrp (dstp_regfetch "Symblman" "grpval" "*"))
  )
  (setq lstmth (dstp_regfetch "Symblman" "lstmth" "1"))
  (setq repmod (dstp_regfetch "Symblman" "repmod" "0"))
  (setq dwgred (dstp_regfetch "Symblman" "dwgred" "0"))
  (setq grpobj (dstp_regfetch "Symblman" "grpobj" "1"))
)
;
; --- save defaults
;
(defun symblman_saveini ()
  (dstp_regstore "Symblman" "grpval" dstp_symblgrp)
  (dstp_regstore "Symblman" "lstmth" lstmth)
  (dstp_regstore "Symblman" "repmod" repmod)
  (dstp_regstore "Symblman" "dwgred" dwgred)
  (dstp_regstore "Symblman" "grpobj" grpobj)
  (dstp_regstore "Symblman" "datpth" dstp_symblpth)
)
;
; --- Data Path Pulldown
;
(defun symblman_datpth ()
  (if (= datchg T)
    (symblman_cancel)
  )
  (setq dstp_symblpth (nth (atoi datpth) datlst))
  (symblman_loaddata)
  (setq symbak dstp_symblman_symlst)
  (setq dstp_symblgrp "*")
  (setq grpsel "0")
  (setq poplst nil)
  (symblman_bldpoplst)
  (symblman_blditmlst)
  (symblman_filpoplst)
  (symblman_filitmlst)
  (symblman_itmnew)
  (symblman_dotitle)
  (setq itmchg nil)
  (setq datchg nil)
)

(defun symblman_newsdb ()
  (if (= datchg T)
    (symblman_cancel)
  )
  (setq fn (dstp_getfiles "New Symbol Manager Database" dstpdir "sdb" 1))
  (if (/= fn nil)
    (progn
      (setq fnd nil)
      (setq ctr (strlen fn))
      (repeat (strlen fn)
        (if (= fnd nil)
          (progn
            (setq cha (substr fn ctr 1))
            (if (= cha "\\")
              (setq fnd ctr)
            )
          )
        )
        (setq ctr (1- ctr))
      )
      (setq pth (substr fn 1 (1- fnd)))
      (setq tmp (dstp_pdf2lst (getenv "ACAD") ";"))
      (if (not (member pth tmp))
        (alert "Notice: The folder selected for this database\nis not included in the AutoCAD support paths!\n\nIf this file is created it will not be automatically\nfound when Symbol Manager restarts.")
      )
      (setq dstp_symblpth fn)
      (setq dstp_symblman_symlst nil)
      (setq fh (open dstp_symblpth "w"))
      (princ "TP60SYM" fh)
      (princ "\nToolPac 6.0 Symbol Data File" fh)
      (princ "\n----------------------------" fh)
      (print dstp_symblman_symlst fh)
      (close fh)
      ;
      (symblman_dorogray)
      (setq symbak dstp_symblman_symlst)
      (setq dstp_symblgrp "*")
      (setq grpsel "0")
      (setq poplst nil)
      (symblman_bldpoplst)
      (symblman_blditmlst)
      (symblman_filpoplst)
      (symblman_filitmlst)
      (symblman_itmnew)
      (symblman_dotitle)
      (setq itmchg nil)
      (setq datchg nil)
      ;
      (setq datlst (cons dstp_symblpth datlst))
      (start_list "datlst")
      (mapcar 'add_list datlst)
      (end_list)
      (set_tile "datlst" (itoa (- (length datlst)(length (member dstp_symblpth datlst)))))
      (if (< (length datlst) 2)
        (mode_tile "datlst" 1)
      )
    )
  )
)

(defun symblman_dorogray ()
  (if (/= dstp_symblpth nil)
    (progn
      (setq lst (list "blkfil" "blksld" "blkdes" "blksel" "sldsel" "blkgrp" "grpsel" "symbol" "itmupd" "itmadd" "itmnew" "itmdef" "addmul" "adddir" "itmdel" "grpdel" "fndrep" "impcsv" "mercsv"))
      (if (= (filereadonly dstp_symblpth) T)
        (setq val 1)
        (setq val 0)
      )
      (foreach itm lst
        (mode_tile itm val)
      )
    )
  )
)

; ====================================================================================
;                                Startup w/Dialog Control
; ====================================================================================

(defun c:BlkSymMgr ( / dosave doinst doxref tmp fn chk itmchg symbak redo)
  (if (/= (dstp_isvalid) nil)
    (progn
      (if (/= (dstp_isvalid) nil)
        (progn
          (setq cmdecho (getvar "CMDECHO"))
          (setvar "CMDECHO" 0)
          (setq dosave nil)
          (setq doinst nil)
          (setq doxref nil)
          (symblman_loadini)
          ;
          ; --- find SYMBLMAN.SDB files and set path
          ;
          (setq pth (getenv "ACAD"))
          (setq tmp (dstp_pdf2lst pth ";"))
          (setq datlst nil)
          (foreach pth tmp
            (setq lst (vl-directory-files pth "*.sdb" 0))
            (foreach fil lst
              (setq datlst (append datlst (list (strcat pth "\\" fil))))
            )
          )
          (if (/= datlst nil)
            (progn
              (setq fnd nil)
              (if (/= dstp_symblpth nil)
                (progn
                  (setq datlst (acad_strlsort datlst))
                  (foreach fil datlst
                    (if (= (strcase dstp_symblpth) (strcase fil))
                      (progn
                        (setq fnd T)
                        (setq dstp_symblpth fil)
                      )
                    )
                  )
                )
              )
              (if (= fnd nil)
                (progn
                  (setq chk (dstp_regfetch "Symblman" "datpth" ""))
                  (if (and (/= chk "")(member chk datlst))
                    (setq dstp_symblpth chk)
                    (setq dstp_symblpth (car datlst))
                  )
                  (setq datlst (acad_strlsort datlst))
                )
              )
            )
            (progn
              (setq dstp_symblpth (strcat dstpdir "data\\symblman.sdb"))
              (setq datlst (list dstp_symblpth))
            )
          )
          (if (/= dstp_symblpth nil)
            (progn
              (setq bypass nil)
              (if (/= (not vl-file-systime) T)
                (progn
                  (setq chkdat (vl-file-systime dstp_symblpth))
                  (if (equal dstp_symblman_fildat chkdat)
                    (setq bypass T)
                    (setq bypass nil)
                  )
                  (if (= dstp_symblman_symlst nil)
                    (setq bypass nil)
                  )
                  (if (= dstp_symblman_fildat nil)
                    (setq bypass nil)
                  )
                )
              )
              (if (= bypass nil)
                (symblman_loaddata)
                (princ "\nDS> Using Symbol Data in Memory !\rDS> Using Symbol Data in Memory !")
              )
            )
          )
          (symblman_bldpoplst)
          (symblman_blditmlst)
          (if (= dstp_symblgrp nil)
            (setq dstp_symblgrp "*")
            (if (not (member dstp_symblgrp poplst))
              (setq dstp_symblgrp "*")
            )
          )
          (if (= grpsel nil)(setq grpsel "0"))
          (setq symbak dstp_symblman_symlst)
          ;
          ; --- load and run dialog
          ;
          (setq diadone nil)
          (if (= dstp_symbldia nil)
            (setq dstp_symbldia (atoi (dstp_regfetch "Symblman" "inidia" "1")))
          )
          (setq dcl_id (load_dialog (strcat dstpdir "toolpac.dcl")))
          (while (= diadone nil)
            (if (= dstp_symbldia 2)
              (progn
                (setq retcode nil)
                (symblman_grasel)
                (if (/= retcode nil)
                  (progn
                    (setq itmsel (itoa retcode))
                    (symblman_evtitmlst)
                    (setq doinst T)
                  )
                )
              )
              (progn
                (if (not (new_dialog "symblman" dcl_id)) (exit))
                (symblman_dorogray)
                (if (/= (dstp_wipeoutchk) T)
                  (mode_tile "mskwip" 1)
                )
                (start_list "datlst")
                (mapcar 'add_list datlst)
                (end_list)
                (set_tile "datlst" (itoa (- (length datlst)(length (member dstp_symblpth datlst)))))
                (if (< (length datlst) 2)
                  (mode_tile "datlst" 1)
                )
                (set_tile "repmod" repmod)
                (set_tile "dwgred" dwgred)
                (set_tile "grpobj" grpobj)
                (symblman_itmnew)
                (symblman_filpoplst)
                (symblman_filitmlst)
                (symblman_dotitle)
                (setq itmchg nil)
                (setq datchg nil)
                (action_tile "symbol" "(setq diadone T)(symblman_tblchk 1)(if (= dopass T)(progn (setq doinst T)(done_dialog 0)))")
                (action_tile "insert" "(setq diadone T)(symblman_tblchk 1)(if (= dopass T)(progn (setq doinst T)(done_dialog 0)))")
                (action_tile "attach" "(setq diadone T)(symblman_tblchk 2)(if (= dopass T)(progn (setq doxref T)(done_dialog 0)))")
                (action_tile "datlst" "(setq datpth $value)(symblman_datpth)")
                (action_tile "newsdb" "(symblman_newsdb)")
                (action_tile "savsdb" "(symblman_savedata)(princ)")
                ;
                (action_tile "grppop" "(setq grpsel $value)(symblman_evtpoplst)")
                (action_tile "itmlst" "(setq itmsel $value)(symblman_evtitmlst)")
                (action_tile "lstnam" "(setq lstmth \"1\")(symblman_blditmlst)(symblman_filitmlst)")
                (action_tile "lstdes" "(setq lstmth \"2\")(symblman_blditmlst)(symblman_filitmlst)")
                (action_tile "grasel" "(setq dstp_symbldia 2)(done_dialog 0)")
                ;
                (action_tile "repmod" "(setq repmod $value)")
                (action_tile "dwgred" "(setq dwgred $value)")
                (action_tile "grpobj" "(setq grpobj $value)")
                (action_tile "blkfil" "(setq blkfil $value)(symblman_extblknam)(setq namchg T)(setq itmchg T)(setq datchg T)")
                (action_tile "blksel" "(symblman_doblksel)(setq itmchg T)(setq datchg T)")
                (action_tile "blksld" "(setq blksld $value)(setq itmchg T)(setq datchg T)")
                (action_tile "sldsel" "(symblman_dosldsel)(setq itmchg T)(setq datchg T)")
                (action_tile "blkdes" "(setq blkdes $value)(symblman_quotechk)(setq itmchg T)(setq datchg T)")
                (action_tile "blkgrp" "(setq blkgrp (strcase $value))(setq grpchg T)(setq itmchg T)(setq datchg T)")
                (action_tile "grpsel" "(symblman_dogrpsel)(setq itmchg T)(setq datchg T)")
                (action_tile "inslay" "(setq inslay $value)(setq itmchg T)(setq datchg T)")
                (action_tile "laysel" "(symblman_dolaysel)(setq itmchg T)(setq datchg T)")
                (action_tile "runbef" "(setq runbef $value)(setq itmchg T)(setq datchg T)")
                (action_tile "runaft" "(setq runaft $value)(setq itmchg T)(setq datchg T)")
                (action_tile "inscol" "(setq inscol $value)(setq itmchg T)(setq datchg T)")
                (action_tile "colsel" "(symblman_docolsel)(setq itmchg T)(setq datchg T)")
                (action_tile "inselv" "(setq inselv $value)(setq itmchg T)(setq datchg T)")
                (action_tile "insthk" "(setq insthk $value)(setq itmchg T)(setq datchg T)")
                (action_tile "osnval" "(setq osnval $value)(setq itmchg T)(setq datchg T)")
                (action_tile "osnset" "(symblman_osnapset)(set_tile \"osnval\" osnval)")
                ;
                (action_tile "xscale" "(setq xscale $value)(setq yscale xscale)(setq zscale xscale)(set_tile \"yscale\" yscale)(set_tile \"zscale\" zscale)(setq itmchg T)(setq datchg T)")
                (action_tile "yscale" "(setq yscale $value)(setq itmchg T)(setq datchg T)")
                (action_tile "zscale" "(setq zscale $value)(setq itmchg T)(setq datchg T)")
                (action_tile "rotate" "(setq rotate $value)(if (/= rotate \"\")(set_tile \"drgrot\" \"0\")(set_tile \"drgrot\" \"1\"))(setq itmchg T)(setq datchg T)")
                (action_tile "drgrot" "(if (= $value \"1\")(progn (setq rotate \"\")(set_tile \"rotate\" \"\")))(setq itmchg T)(setq datchg T)")
                (action_tile "msknon" "(setq mskmth \"1\")(setq itmchg T)(setq datchg T)")
                (action_tile "msktrm" "(setq mskmth \"2\")(setq itmchg T)(setq datchg T)")
                (action_tile "msksol" "(setq mskmth \"3\")(setq itmchg T)(setq datchg T)")
                (action_tile "mskwip" "(setq mskmth \"4\")(setq itmchg T)(setq datchg T)")
                (action_tile "mskimg" "(setq mskmth \"5\")(setq itmchg T)(setq datchg T)")
                (action_tile "ortins" "(setq ortins $value)(setq itmchg T)(setq datchg T)")
                (action_tile "insexp" "(setq insexp $value)(setq itmchg T)(setq datchg T)")
                (action_tile "attpmt" "(setq attpmt $value)(setq itmchg T)(setq datchg T)")
                (action_tile "atthor" "(setq atthor $value)(setq itmchg T)(setq datchg T)")
                (action_tile "addmul" "(symblman_doaddmul)(setq datchg T)")
                (action_tile "adddir" "(symblman_doadddir)(setq datchg T)")
                (action_tile "fndrep" "(symblman_itmnew)(symblman_fndrep)(set_tile \"grppop\" grpsel)(setq datchg T)")
                ;
                (action_tile "itmupd" "(symblman_itmupd)(symblman_displin)(setq datchg T)")
                (action_tile "itmadd" "(symblman_itmadd)(symblman_displin)(setq datchg T)")
                (action_tile "itmnew" "(symblman_itmnew)(setq datchg T)")
                (action_tile "itmdel" "(symblman_delmulti)(symblman_dlgreset)(setq datchg T)")
                (action_tile "grpdel" "(symblman_delgroup)(symblman_dlgreset)(setq datchg T)")
                (action_tile "itmdef" "(symblman_savitmdef)")
                ;
                (action_tile "accept" "(setq doproc T)(setq diadone T)(symblman_savedata)(symblman_saveini)(done_dialog 1)")
                (action_tile "cancel" "(setq doproc nil)(setq diadone T)(symblman_cancel)(done_dialog 0)")
                (action_tile "help" "(dstp_showhelp \"BlkSymMgr.htm\")")
                (action_tile "impcsv" "(setq clrlst T)(symblman_loddata)(setq datchg T)")
                (action_tile "mercsv" "(setq clrlst nil)(symblman_loddata)(setq datchg T)")
                (action_tile "expcsv" "(symblman_expdata)")
                ;
                (if (equal (start_dialog) 1)
                  (progn
                    (unload_dialog dcl_id)
                  )
                )
              )
            )
          )
          (dstp_regstore "Symblman" "inidia" (itoa dstp_symbldia))
          ;
          ; --- do block insert or xref
          ;
          (if (= (substr (strcase blkfil) 1 8) "NOINSERT")
            (progn
              (if (= doproc T)
                (if (/= runbef "")
                  (if (= (substr runbef 1 1) "(")
                    (eval (read runbef))
                    (command "vbastmt" runbef)
                  )
                )
              )
            )
            (if (or (= doinst T)(= doxref T))
              (progn
                (symblman_saveini)
                (if (= datchg T)
                  (symblman_savedata)
                )
                (setq attreq (getvar "ATTREQ"))
                (setq attdia (getvar "ATTDIA"))
                (setq clayer (getvar "CLAYER"))
                (setq cecolor (getvar "CECOLOR"))
                (setq elevation (getvar "ELEVATION"))
                (setq thickness (getvar "THICKNESS"))
                (setq osmode (getvar "OSMODE"))
                (setq orthomode (getvar "ORTHOMODE"))
                (command "_.UNDO" "_G")
                (if (= repmod "1")
                  (progn
                    (defun symblman_error (msg)
                      (setvar "CMDECHO" 0)
                      (command "_.UNDO" "_E")
                      (setvar "ORTHOMODE" orthomode)
                      (setvar "OSMODE" osmode)
                      (setvar "THICKNESS" thickness)
                      (setvar "ELEVATION" elevation)
                      (setvar "CECOLOR" cecolor)
                      (setvar "CLAYER" clayer)
                      (setvar "ATTDIA" attdia)
                      (setvar "ATTREQ" attreq)
                      (setvar "CMDECHO" cmdecho)
                      (setq *error* olderr)
                      (princ "\nDS> Exiting Repeat Mode!")
                    )
                    (setq olderr *error*)
                    (setq *error* symblman_error)
                  )
                )
                (setq done nil)
                (while (/= done T)
                  (if (/= osnval "")(setvar "OSMODE" (atoi osnval)))
                  (if (= ortins "1")(setvar "ORTHOMODE" 1))
                  (if (/= runbef "")
                    (if (= (substr runbef 1 1) "(")
                      (eval (read runbef))
                      (command "vbastmt" runbef)
                    )
                  )
                  (if (= repmod "1")
                    (princ (strcat "\nDS> [" blknam "] Press ESC to Exit Repeat Mode ..."))
                    (princ (strcat "\nDS> [" blknam "] Single Insert Mode ..."))
                  )
                  (if (= doinst T)
                    (progn
                      (command)
                      (if (= attpmt "1")
                        (setvar "ATTREQ" 1)
                        (setvar "ATTREQ" 0)
                      )
                      (setvar "ATTDIA" 1)
                      (if (/= inslay "")(command "_.LAYER" "_M" inslay ""))
                      (if (/= inscol "")(setvar "CECOLOR" inscol))
                      (if (/= inselv "")(setvar "ELEVATION" (atof inselv)))
                      (if (/= insthk "")(setvar "THICKNESS" (atof insthk)))
                      (if (/= insexp "1")
                        (progn
                          (if (= xscale "")
                            (setq xscale (getstring "\nDS> X Scale <1.0>: "))
                          )
                          (if (= yscale "")
                            (setq yscale (getstring "\nDS> Y Scale <1.0>: "))
                          )
                          (if (= zscale "")
                            (setq zscale (getstring "\nDS> Z Scale <1.0>: "))
                          )
                          (if (= xscale "")(setq xscale "1.0"))
                          (if (= yscale "")(setq yscale "1.0"))
                          (if (= zscale "")(setq zscale "1.0"))
                          (princ "\nDS> Xscale/Yscale/Zscale/Rotate/<Insertion Point>: ")
                          (if (= dwgred "1")
                            (setq insnam (strcat blknam "=" blkfil))
                            (setq insnam blkfil)
                          )
                          (initdia 1)
                          (command "_.-INSERT")
                          (command insnam)
                          (if (= (dstp_blkuniform blknam) nil)
                            (progn
                              (command "_X")
                              (command (symblman_scalechk xscale))
                              (command "_Y")
                              (command (symblman_scalechk yscale))
                              (command "_Z")
                              (command (symblman_scalechk zscale))
                            )
                            (progn
                              (command "_S")
                              (command (symblman_scalechk xscale))
                            )
                          )
                          (if (/= rotate "")
                            (progn
                              (command "_R")
                              (command (read rotate))
                            )
                          )
                          (setvar "CMDECHO" 1)
                          (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                            (command pause)
                          )
                          (setvar "CMDECHO" 0)
                          (if (= attpmt "1")
                            (if (>= (atof (getvar "ACADVER")) 18.2)  ; 2012 or higher
                              (vl-cmdf "._DDATTE" (entlast))
                            )
                          )
                        )
                        (progn
                          (if (= xscale "")
                            (setq xscale (getstring "\nDS> Scale Factor <1.0>: "))
                          )
                          (if (= xscale "")(setq xscale "1.0"))
                          (princ "\nDS> Insertion Point: ")
                          (setq insnam (strcat "*" blkfil))
                          (command "_.INSERT")
                          (command insnam)
                          (command pause)
                          (command (symblman_scalechk xscale))
                          (if (/= rotate "")
                            (command (read rotate))
                            (progn
                              (princ "\nDS> Specify rotation angle: ")
                              (command pause)
                            )
                          )
                        )
                      )
                      ;
                      (if (= atthor "1")
                        (progn
                          (setq blkhnd (entlast))
                          (setq blkent (entget blkhnd))
                          (if (/= (assoc 66 blkent) nil)
                            (if (= (cdr (assoc 66 blkent)) 1)
                              (progn
                                (setq nxthnd blkhnd)
                                (setq nxtent blkent)
                                (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                                  (setq nxthnd (entnext nxthnd))
                                  (setq nxtent (entget nxthnd))
                                  (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                                    (progn
                                      (setq nxtent (subst (cons 50 0.0)(assoc 50 nxtent) nxtent))
                                      (entmod nxtent)
                                    )
                                  )
                                )
                                (entupd blkhnd)
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                  (if (= doxref T)
                    (progn
                      (command)
                      (princ (strcat "\nDS> [" blknam "] Xscale/Yscale/Zscale/Rotate/<Attachment Point>: "))
                      (if (/= inslay "")(command "_.LAYER" "_M" inslay ""))
                      (if (/= inscol "")(setvar "CECOLOR" (dstp_str2col inscol)))
                      (if (/= inselv "")(setvar "ELEVATION" (atof inselv)))
                      (if (/= insthk "")(setvar "THICKNESS" (atof insthk)))
                      (command "_.XREF")
                      (command "_A")
                      (command blkfil)
                      (command "_X")
                      (command (symblman_scalechk xscale))
                      (command "_Y")
                      (command (symblman_scalechk yscale))
                      (if (/= rotate "")
                        (progn
                          (command "_R")
                          (command (read rotate))
                        )
                      )
                      (setvar "CMDECHO" 1)
                      (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                        (command pause)
                      )
                    )
                  )
                  (if (> (atoi mskmth) 1)
                    (progn
                      (setvar "SORTENTS" 127)
                      (setvar "OSMODE" 0)
                      (setq blkhnd (entlast))
                      (setq axo (vlax-ename->vla-object blkhnd))
                      (vla-getboundingbox axo 'minpt 'maxpt)
                      (setq minpt (vlax-safearray->list minpt))
                      (setq maxpt (vlax-safearray->list maxpt))
                      (setq minpt (dstp_2dpoint minpt))
                      (setq maxpt (dstp_2dpoint maxpt))
                      (if (/= dstp_boundbuf nil)
                        (if (= (type dstp_boundbuf) 'REAL)
                          (progn
                            (setq buf (* (/ dstp_boundbuf 100.0) (symblman_scalechk xscale)))
                            (setq minpt (polar minpt pi buf))
                            (setq minpt (polar minpt (+ pi (/ pi 2.0)) buf))
                            (setq maxpt (polar maxpt 0 buf))
                            (setq maxpt (polar maxpt (/ pi 2.0) buf))
                          )
                        )
                      )
                      (setq llc (list (car minpt)(cadr minpt)))
                      (setq lrc (list (car maxpt)(cadr minpt)))
                      (setq urc (list (car maxpt)(cadr maxpt)))
                      (setq ulc (list (car minpt)(cadr maxpt)))
                      (setq tmp (* (symblman_scalechk xscale) 0.025))
                      (setq ip1 (list (+ (car llc) tmp) (+ (cadr llc) tmp)))
                      (setq ip2 (list (- (car lrc) tmp) (+ (cadr lrc) tmp)))
                      (setq ip3 (list (- (car urc) tmp) (- (cadr urc) tmp)))
                      (setq ip4 (list (+ (car ulc) tmp) (- (cadr ulc) tmp)))
                      (cond
                        ((= mskmth "2") ; trim
                          (dstp_ucspush)
                          (command "_.PLINE" llc lrc urc ulc "_C")
                          (setq rec (entlast))
                          (command "_.TRIM" rec "" "_F" ip1 ip2 ip3 ip4 ip1 "" "")
                          (entdel rec)
                          (command "_.ERASE" "_W" ip1 ip3 "_R" blkhnd "")
                          (dstp_ucspop)
                        )
                        ((= mskmth "3") ; solid
                          (setq sol '((0 . "SOLID")))
                          (setq sol (append sol (list (list 10 (car llc) (cadr llc) 0.0))))
                          (setq sol (append sol (list (list 11 (car lrc) (cadr lrc) 0.0))))
                          (setq sol (append sol (list (list 12 (car ulc) (cadr ulc) 0.0))))
                          (setq sol (append sol (list (list 13 (car urc) (cadr urc) 0.0))))
                          (setq sol (append sol (list (cons 62 254))))
                          (entmake sol)
                          (setq mskhnd (entlast))
                          (if (= grpobj "1")
                            (progn
                              (dstp_dofloat blkhnd)
                              (setq mset (ssadd))
                              (setq mset (ssadd mskhnd mset))
                              (setq mset (ssadd (entlast) mset))
                              (setq highlight (getvar "HIGHLIGHT"))
                              (setvar "HIGHLIGHT" 0)
                              (command "_.-GROUP" "" "*" "" mset "")
                              (setvar "HIGHLIGHT" highlight)
                              (setq mset nil)
                            )
                          )
                        )
                        ((= mskmth "4") ; wipeout
                          (dstp_ucspush)
                          (command "_.WIPEOUT" llc lrc urc ulc "")
                          (dstp_ucspop)
                          (setq mskhnd (entlast))
                          (if (= grpobj "1")
                            (progn
                              (dstp_dofloat blkhnd)
                              (setq mset (ssadd))
                              (setq mset (ssadd mskhnd mset))
                              (setq mset (ssadd (entlast) mset))
                              (setq highlight (getvar "HIGHLIGHT"))
                              (setvar "HIGHLIGHT" 0)
                              (command "_.-GROUP" "" "*" "" mset "")
                              (setvar "HIGHLIGHT" highlight)
                              (setq mset nil)
                            )
                          )
                        )
                        ((= mskmth "5") ; maskimg
                          (dstp_ucspush)
                          (setq disx (- (car urc)(car llc)))
                          (setq disy (- (cadr urc)(cadr llc)))
                          (if (> disx disy)
                            (setq siz disx)
                            (setq siz disy)
                          )
                          (setq img (findfile dstp_wipeimage))
                          (command "_.IMAGE" "_A" img llc 0.01 "0")
                          (setq hnd (entlast))
                          (setq ent (entget hnd))
                          (setq wid (car (cdr (assoc 11 ent))))
                          (setq g60 (assoc 60 ent))
                          (if (/= g60 nil)
                            (setq ent (subst (cons 60 1)(assoc 60 ent) ent))
                            (setq ent (append ent (list (cons 60 1))))
                          )
                          (entmod ent)
                          (setq scl (/ siz wid))
                          (command "_.SCALE" hnd "" llc scl)
                          (command "_.IMAGECLIP" hnd "")
                          (if (/= (cdr (assoc 91 ent)) nil)
                            (if (> (cdr (assoc 91 ent)) 2)
                              (command "_Y")
                            )
                          )
                          (command "_R" llc urc)
                          (setq mskhnd (entlast))
                          (setq ent (entget mskhnd))
                          (setq ent (subst (cons 60 0)(assoc 60 ent) ent))
                          (entmod ent)
                          (if (= grpobj "1")
                            (progn
                              (dstp_dofloat blkhnd)
                              (setq mset (ssadd))
                              (setq mset (ssadd mskhnd mset))
                              (setq mset (ssadd (entlast) mset))
                              (setq highlight (getvar "HIGHLIGHT"))
                              (setvar "HIGHLIGHT" 0)
                              (command "_.-GROUP" "" "*" "" mset "")
                              (setvar "HIGHLIGHT" highlight)
                              (setq mset nil)
                            )
                          )
                          (dstp_ucspop)
                        )
                        (t nil)
                      )
                    )
                  )
                  (if (/= runaft "")
                    (if (= (substr runaft 1 1) "(")
                      (eval (read runaft))
                      (command "vbastmt" runaft)
                    )
                  )
                  (if (= repmod "0")
                    (setq done T)
                  )
                )
                (command "_.UNDO" "_E")
                (setvar "ORTHOMODE" orthomode)
                (setvar "OSMODE" osmode)
                (setvar "THICKNESS" thickness)
                (setvar "ELEVATION" elevation)
                (setvar "CECOLOR" cecolor)
                (setvar "CLAYER" clayer)
                (setvar "ATTDIA" attdia)
                (setvar "ATTREQ" attreq)
                (se