(vl-load-com)

(defun dstp_rastersup ()
  (setq fnd nil)
  (setq supcol (dstp_strsplit (getvar "ACADPREFIX") ";"))
  (foreach supstr supcol
    (if (/= (vl-string-search "RASTER DESIGN" (strcase supstr)) nil)
      (setq fnd T)
    )
  )
  (eval fnd)
)

(defun dstp_textwidth (tent)
  (setq p0 (cdr (assoc 10 tent))
    ang (cdr (assoc 50 tent))
    sinrot (sin ang)
    cosrot (cos ang)
    t1 (car (textbox tent))
    t2 (cadr (textbox tent))
    p1 (list (+ (car p0)
       (- (* (car t1) cosrot) (* (cadr t1) sinrot)))
       (+ (cadr p0)
       (+ (* (car t1) sinrot) (* (cadr t1) cosrot))))
    p2 (list (+ (car p0)
       (- (* (car t2) cosrot) (* (cadr t1) sinrot)))
       (+ (cadr p0)
       (+ (* (car t2) sinrot) (* (cadr t1) cosrot))))
  )
  (distance p1 p2)
)

; --------------------------------------------------------------------------
;                     Unload ADS/ARX Applications in Dialog
; --------------------------------------------------------------------------

(defun c:LegAdsUnl (/ $value adslst arx arxlst dcl_id new respitm tabitm
                         tablst tabsel tmp typ unl)
  ;
  ; --- clear or selectall in list
  ;
  (defun adsunlod_lstcon (op / inc)
    (if (= op 0)
      (set_tile "table" "")
      (progn
        (setq tabsel "")
        (setq inc 0)
        (repeat (length tablst)
          (setq tabsel (strcat tabsel (rtos inc 2 0) " "))
          (setq inc (1+ inc))
        )
        (set_tile "table" tabsel)
      )
    )
  )
  ;
  ; --- update current list
  ;
  (defun adsunlod_updlst ()
    (setq tabsel nil)
    (setq tablst nil)
    (if arx
      (progn
        (setq arxlst (arx))
        (foreach itm arxlst
          (setq tablst (append tablst (list (list (strcase itm) "ARX"))))
        )
      )
    )
    (if (/= tablst nil)
      (progn
        (setq tmp nil)
        (foreach itm tablst
          (setq tmp (append tmp (list (car itm))))
        )
        (setq tmp (acad_strlsort tmp))
        (setq new nil)
        (foreach itm tmp
          (setq new (append new (list (assoc itm tablst))))
        )
        (setq tablst new)
        (setq new nil)
        (setq tmp nil)
        ;
        (start_list "table")
        (foreach itm tablst
          (add_list (strcat (car itm) "\t" (cadr itm)))
        )
        (end_list)
      )
      (progn
        (start_list "table")
        (end_list)
      )
    )
  )
  ;
  ; --- unload tagged items
  ;
  (defun adsunlod_dounlod ( / uct resp itm)
    (setq uct 1)
    (setq resp nil)
    (while (setq tabitm (read tabsel))
      (setq respitm (nth tabitm tablst))
      (setq resp (append resp (list respitm)))
      (while (and (/= " " (substr tabsel uct 1))
        (/= "" (substr tabsel uct 1)))
        (setq uct (1+ uct))
      )
      (setq tabsel (substr tabsel uct))
    )
    (foreach itm resp
      (setq unl (car itm))
      (setq typ (cadr itm))
      (cond
        ((= typ "ADS")
          (if (= (xunload unl T) T)
            (alert (strcat "ERROR Unloading:\n" unl))
          )
        )
        ((= typ "ARX")
          (if (= (arxunload unl T) T)
            (alert (strcat "ERROR Unloading:\n" unl))
          )
        )
        (t nil)
      )
    )
    (setq tabsel nil)
    (setq tablst nil)
    (adsunlod_updlst)
  )
  ;
  ; --- main routine
  ;
  ;(vl-arx-import 'arx)
  (if (= (arx) nil)
    (alert "No ARX Applications to Unload !")
    (progn
      (if (= dstp_diasize 2)
        (setq tmp "adsunlod2")
        (setq tmp "adsunlod1")
      )
      (setq dcl_id (load_dialog "unsupport.dcl"))
      (if (not (new_dialog tmp dcl_id)) (exit))
      (adsunlod_updlst)
      (action_tile "table" "(setq tabsel $value)")
      (action_tile "unload" "(adsunlod_dounlod)")
      (action_tile "selall" "(adsunlod_lstcon 1)")
      (action_tile "clrall" "(adsunlod_lstcon 0)")
      (if (equal (start_dialog) 1)
        (progn)
      )
      (unload_dialog dcl_id)
    )
  )
  ;
  (setq adslst nil)
  (setq arxlst nil)
  (princ)
)

; --------------------------------------------------------------------------
;            Generate/Update ArcAlignedText using Curve Parameters
; --------------------------------------------------------------------------

(defun labarcprm_calc (inf)
  (setq ret inf)
  (setq cpnt (cdr (assoc 10 ent)))                                       ; [CP] Center Point
  (setq rads (cdr (assoc 40 ent)))                                       ; [RL] Radius Length
  (setq sang (cdr (assoc 50 ent)))                                       ; [SA] Starting Angle
  (setq eang (cdr (assoc 51 ent)))                                       ; [EA] Ending Angle
  (if (> eang sang)
    (setq iang (- eang sang))
    (setq iang (+ (- 6.28319 sang) eang))                                ; [DA] Delta Angle
  )
  (setq apt1 (polar cpnt sang rads))                                     ; [SP] Starting Point
  (setq apt2 (polar cpnt eang rads))                                     ; [EP] Ending Point
  (setq cang (angle apt1 apt2))                                          ; [CA] Chord Angle
  (setq clen (distance apt1 apt2))                                       ; [CL] Chord Length
  (setq larc (* iang rads))                                              ; [AL] Arc Length
  (setq mid2 (polar apt1 cang (/ clen 2.0)))                             ;      Chord midpoint
  (setq ord (- rads (* rads (- 1 (cos (/ iang 2.0))))))                  ;      Middle Ordinate
  (setq cen (polar mid2 (+ cang (/ pi 2.0)) ord))                        ;      Center Coord
  (setq tgnt (abs (* (/ (sin (/ iang 2.0)) (cos (/ iang 2.0))) rads)))   ; [TL] Tangent Length
  (setq ext (* rads (- (/ 1 (cos (/ iang 2.0))) 1)))                     ;      External
  (setq ccd (angle cen mid2))                                            ; [CD] Concave Direction
  ;
  (if (dstp_instr inf "[AL]")
    (setq ret (dstp_subtext ret "[AL]" (rtos larc)))
  )
  (if (dstp_instr inf "[RL]")
    (setq ret (dstp_subtext ret "[RL]" (rtos rads)))
  )
  (if (dstp_instr inf "[CL]")
    (setq ret (dstp_subtext ret "[CL]" (rtos clen)))
  )
  (if (dstp_instr inf "[DA]")
    (setq ret (dstp_subtext ret "[DA]" (angtos iang 1)))
  )
  (if (dstp_instr inf "[CA]")
    (setq ret (dstp_subtext ret "[CA]" (angtos cang 4)))
  )
  (if (dstp_instr inf "[TL]")
    (setq ret (dstp_subtext ret "[TL]" (rtos tgnt)))
  )
  (if (dstp_instr inf "[CP]")
    (setq ret (dstp_subtext ret "[CP]" (strcat (rtos (car cpnt)) "," (rtos (cadr cpnt)))))
  )
  (if (dstp_instr inf "[SP]")
    (setq ret (dstp_subtext ret "[SP]" (strcat (rtos (car apt1)) "," (rtos (cadr apt1)))))
  )
  (if (dstp_instr inf "[EP]")
    (setq ret (dstp_subtext ret "[EP]" (strcat (rtos (car apt2)) "," (rtos (cadr apt2)))))
  )
  (if (dstp_instr inf "[SA]")
    (setq ret (dstp_subtext ret "[SA]" (angtos sang 1)))
  )
  (if (dstp_instr inf "[EA]")
    (setq ret (dstp_subtext ret "[EA]" (angtos eang 1)))
  )
  (if (dstp_instr inf "[CD]")
    (setq ret (dstp_subtext ret "[CD]" (angtos ccd 1)))
  )
  (setq tmp ret)
)

(defun c:LegArcAdd ( / chk cmdecho drf dstp_expstr eed ent fld fnt g79
                          hnd itm lst new num res sdf siz sset str tmp)
  (if (null (tblsearch "APPID" "DSTP_ARCPARM"))
    (regapp "DSTP_ARCPARM")
  )
  (if (= (member "ctextapp.arx" (arx)) nil)
    (progn
      (arxload "ctextapp")
      (princ "\n\n\n")
    )
  )
  ;
  (initget "C V")
  (setq chk (getkword "\nDS> Label conVex/<conCave> side: "))
  (if (/= chk "V")(setq sdf 2)(setq sdf 1))
  ;
  (initget "O I")
  (setq chk (getkword "\nDS> Label Inward/<Outward> direction: "))
  (if (/= chk "I")(setq drf 1)(setq drf 2))
  ;
  (princ "\nDS> [AL] Arc Length")
  (princ "\nDS> [CA] Chord Angle")
  (princ "\nDS> [CD] Concave Direction")
  (princ "\nDS> [CL] Chord Length")
  (princ "\nDS> [CP] Center Point")
  (princ "\nDS> [DA] Delta Angle")
  (princ "\nDS> [EA] Ending Angle")
  (princ "\nDS> [EP] Ending Point")
  (princ "\nDS> [RL] Radius Length")
  (princ "\nDS> [SA] Starting Angle")
  (princ "\nDS> [SP] Starting Point")
  (princ "\nDS> [TL] Tangent Length")
  (if (= dstp_expstr nil)
    (setq dstp_expstr "L=[AL]")
  )
  (setq tmp (getstring (strcat "\nDS> Expression String <" dstp_expstr ">: ") T))
  (if (= tmp "")(setq fld dstp_expstr)(setq fld tmp))
  (setq dstp_expstr fld)
  ;
  (setq sset (ssget '((0 . "ARC"))))
  (if sset
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
       
      (setq itm 0 num (sslength sset))
      (while (< itm num)
        (setq hnd (ssname sset itm))
        (setq ent (entget hnd))
        (setq str (labarcprm_calc fld))
        (setq lst (dstp_pdf2lst (cdr (assoc 3 (tblsearch "STYLE" (getvar "TEXTSTYLE")))) "."))
        (setq fnt (car lst))
        (if (> (length lst) 1)
          (if (= (strcase (cadr lst)) "SHX")
            (setq g79 1) ; shx
            (setq g79 0) ; ttf
          )
          (setq g79 1)
        )
        (setq siz (dstp_textsize))
        (setq new '((0 . "ARCALIGNEDTEXT")(100 . "AcDbEntity")(100 . "AcDbArcAlignedText")))
        (setq new (append new (list (cons 1 str))))
        (setq new (append new (list (cons 2 fnt))))
        (setq new (append new (list (cons 3 ""))))
        (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
        (setq new (append new (list (cons 8 (getvar "CLAYER")))))
        (setq new (append new (list (cons 10 (cdr (assoc 10 ent))))))
        (setq new (append new (list (cons 40 (cdr (assoc 40 ent))))))
        (setq new (append new (list (cons 41 1.0))))
        (setq new (append new (list (cons 42 (dstp_textsize)))))
        (setq new (append new (list (cons 43 (* (dstp_textsize) 0.275)))))
        (setq new (append new (list (cons 44 (/ siz 2.0)))))
        (setq new (append new (list (cons 45 0.0))))
        (setq new (append new (list (cons 46 0.0))))
        (setq new (append new (list (cons 50 (cdr (assoc 50 ent))))))
        (setq new (append new (list (cons 51 (cdr (assoc 51 ent))))))
        (setq new (append new (list (cons 62 (dstp_str2col (getvar "CECOLOR"))))))
        (setq new (append new (list (cons 70 0))))
        (setq new (append new (list (cons 71 drf))))
        (setq new (append new (list (cons 72 4))))
        (setq new (append new (list (cons 73 sdf))))
        (setq new (append new (list (cons 74 0))))
        (setq new (append new (list (cons 75 0))))
        (setq new (append new (list (cons 76 0))))
        (setq new (append new (list (cons 77 1))))
        (setq new (append new (list (cons 78 0))))
        (setq new (append new (list (cons 79 g79))))
        (setq new (append new (list (cons 90 (dstp_str2col (getvar "CECOLOR"))))))
        (setq new (append new (list (cons 210 (cdr (assoc 210 ent))))))
        (setq new (append new (list (cons 280 1))))
        (setq new (append new (list (cons 330 (handent (cdr (assoc 5 ent)))))))
        (setq res (entmake new))
        (if (/= res nil)
          (progn
            (setq hnd (entlast))
            (setq ent (entget hnd))
            (setq eed (list -3 (list "DSTP_ARCPARM" (cons 1000 fld))))
            (setq ent (append ent (list eed)))
            (entmod ent)
          )
        )
        (setq itm (1+ itm))
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setq sset nil)
    )
  )
  (princ)
)

(defun c:LegArcUpd ( / chk cmdecho ent fld hnd itm num sset str tent thnd)
  (princ "\nDS> Select ToolPac generated ArcAlignedText to update ...")
  (setq sset (ssget '((-3 ("DSTP_ARCPARM")))))
  (if sset
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq itm 0 num (sslength sset))
      (while (< itm num)
        (setq thnd (ssname sset itm))
        (setq tent (entget thnd '("DSTP_ARCPARM")))
        (foreach rec tent
          (if (= (car rec) 330)
            (setq hnd (cdr rec))
          )
        )
        (setq ent (entget hnd))
        (if (/= ent nil)
          (progn
            (setq chk (assoc -3 tent))
            (if (/= chk nil)
              (progn
                (setq fld (cdr (cadr (car (cdr chk)))))
                (setq str (labarcprm_calc fld))
                (setq tent (subst (cons 1 str) (assoc 1 tent) tent))
                (setq tent (subst (assoc 10 ent) (assoc 10 tent) tent))
                (setq tent (subst (assoc 40 ent) (assoc 40 tent) tent))
                (setq tent (subst (assoc 50 ent) (assoc 50 tent) tent))
                (setq tent (subst (assoc 51 ent) (assoc 51 tent) tent))
                (entmod tent)
              )
            )
          )
          (princ "\nDS> Referenced ARC object is missing!")
        )
        (setq itm (1+ itm))
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (setq sset nil)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         Group Change X/Y/Z/Rot
; --------------------------------------------------------------------------

(defun c:LegBlkChg ( / xs ys ro chm ctr sset itm hnd ent cmdecho dcl_id
                         num rot xsc ysc zsc)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq xsc "")
  (setq ysc "")
  (setq zsc "")
  (setq rot "")
  ;
  (setq dcl_id (load_dialog "unsupport.dcl"))
  (if (not (new_dialog "blkparms" dcl_id)) (exit))
  ;
  (set_tile "blkxsc" xsc)
  (set_tile "blkysc" ysc)
  (set_tile "blkzsc" zsc)
  (set_tile "blkrot" rot)
  (action_tile "blkxsc" "(setq xsc $value)")
  (action_tile "blkysc" "(setq ysc $value)")
  (action_tile "blkzsc" "(setq zsc $value)")
  (action_tile "blkrot" "(setq rot $value)")
  ;
  (if (equal (start_dialog) 1)
    (progn
      (setq chm 0)
      (setq ctr 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq sset (ssget '((0 . "INSERT"))))
      (setq num (sslength sset) itm 0)
      (if sset 
        (progn
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (if (= "INSERT" (cdr (assoc 0 ent))) 
              (progn
                (if (/= xsc "")
                  (setq ent (subst (cons 41 (atof xsc))(assoc 41 ent) ent))
                )
                (if (/= ysc "")
                  (setq ent (subst (cons 42 (atof ysc))(assoc 42 ent) ent))
                )
                (if (/= zsc "")
                  (setq ent (subst (cons 43 (atof zsc))(assoc 43 ent) ent))
                )
                (if (/= rot "")
                  (setq ent (subst (cons 50 (dstp_dtr (atof rot)))(assoc 50 ent) ent))
                )
                (entmod ent)
                (setq chm (1+ chm))
              )
            )
            (setq itm (1+ itm))
          )
          (princ ", Done.")
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
    )
  )
  ;
  (setq sset nil)
  (setvar "CMDECHO" cmdecho)
  (unload_dialog dcl_id)
  (princ)
)

; --------------------------------------------------------------------------
;                    Block Definition/Desciption Editor
; --------------------------------------------------------------------------

(defun c:LegBlkEdt ( / $value attprt atttag attval blk blkchg blkdes
                          blklst blksel chg chglst chk cmdecho cnt col
                          colval datlst datsel dcl_id dne docancel done
                          doproc ent g70 hnd itm lay laylst lst ltp ltplst
                          modcon modinv modpre modver nam nen new nhd num
                          obj old pos regchg reinst sset str tag tmp)
  (defun blkdefedt_chpdisp ()
    (if (= blkchg T)
      (progn
        (mode_tile "revert" 0)
      )
      (progn
        (mode_tile "revert" 1)
      )
    )
  )
  (defun blkdefedt_dispdat ()
    (start_list "datlst")
    (foreach rec lst
      (setq ent (car rec))
      (setq obj (cdr (assoc 0 ent)))
      (cond
        ((= obj "ATTDEF")
          (setq tag (strcase (cdr (assoc 2 ent))))
          (setq str (strcat obj "\t" tag))
        )
        ((= obj "INSERT")
          (setq nam (cdr (assoc 2 ent)))
          (setq str (strcat obj "\t" nam))
        )
        (t
          (setq str obj)
        )
      )
      (add_list str)
    )
    (end_list)
  )
  (defun blkdefedt_selblk ()
    (if (= blkchg T)
      (blkdefedt_applychg)
    )
    (setq blkchg nil)
    (setq datlst nil)
    (setq itm (atoi blksel))
    (setq nam (nth itm blklst))
    (setq blk (tblsearch "BLOCK" nam))
    (setq hnd (cdr (assoc -2 blk)))
    ;
    (if (= (assoc 4 blk) nil)
      (setq blkdes "")
      (setq blkdes (cdr (assoc 4 blk)))
    )
    (mode_tile "revert" 1)
    (mode_tile "laysel" 1)
    (set_tile "laysel" "")
    (mode_tile "ltpsel" 1)
    (set_tile "ltpsel" "")
    (mode_tile "colval" 1)
    (set_tile "colval" "")
    (mode_tile "colsel" 1)
    (mode_tile "moveup" 1)
    (mode_tile "movedn" 1)
    (mode_tile "modify" 1)
    (set_tile "blkdes" blkdes)
    ;
    (mode_tile "datlst" 0)
    (setq lst nil)
    (setq done nil)
    (while (/= done T)
      (setq chg nil)
      (setq ent (entget hnd))
      (setq itm ent)
      (if (= (cdr (assoc 0 ent)) "POLYLINE")
        (progn
          (setq itm (list ent))
          (setq nhd hnd)
          (setq dne nil)
          (while (/= dne T)
            (setq nhd (entnext nhd))
            (setq nen (entget nhd))
            (setq itm (cons nen itm))
            (if (= "SEQEND" (cdr (assoc 0 nen)))
              (setq dne T)
            )
          )
          (setq itm (reverse itm))
          (setq ent nen)
          (setq lst (append lst (list itm)))
        )
        (setq lst (append lst (list (list itm))))
      )
      (if (= (setq hnd (entnext (cdr (assoc -1 ent)))) nil)
        (setq done T)
      )
    )
    (blkdefedt_dispdat)
  )
  (defun blkdefedt_seldat ()
    (setq old (nth (atoi datsel) lst))
    (setq ent (car (nth (atoi datsel) lst)))
    (setq obj (cdr (assoc 0 ent)))
    (mode_tile "laysel" 0)
    (mode_tile "ltpsel" 0)
    (mode_tile "colval" 0)
    (mode_tile "colsel" 0)
    (if (= (atoi datsel) 0)
      (mode_tile "moveup" 1)
      (mode_tile "moveup" 0)
    )
    (if (= (atoi datsel) (- (length lst) 1))
      (mode_tile "movedn" 1)
      (mode_tile "movedn" 0)
    )
    (if (= obj "ATTDEF")
      (mode_tile "modify" 0)
      (mode_tile "modify" 1)
    )
    ;
    (setq chk (assoc 62 ent))
    (if (= chk nil)
      (setq colval 256)
      (setq colval (cdr chk))
    )
    (set_tile "colval" (dstp_col2str colval))
    ;
    (setq lay (cdr (assoc 8 ent)))
    (setq itm (- (length laylst)(length (member lay laylst))))
    (set_tile "laysel" (itoa itm))
    ;
    (setq ltp nil)
    (if (= (assoc 6 ent) nil)
      (setq ltp "BYLAYER")
      (setq ltp (strcase (cdr (assoc 6 ent))))
    )
    (setq itm (- (length ltplst)(length (member ltp ltplst))))
    (set_tile "ltpsel" (itoa itm))
    (setq tmp nil)
  )
  (defun blkdefedt_getlay ()
    (setq chk (atoi (get_tile "laysel")))
    (setq lay (nth chk laylst))
    (setq ent (car old))
    (setq ent (subst (cons 8 lay)(assoc 8 ent) ent))
    (if (= (cdr (assoc 0 ent)) "POLYLINE")
      (progn
        (setq cnt 0)
        (setq new (list ent))
        (foreach rec old
          (if (> cnt 0)
            (setq new (append new (list rec)))
          )
          (setq cnt (1+ cnt))
        )
        (setq lst (subst new old lst))
        (setq old new)
      )
      (progn
        (setq new (list ent))
        (setq lst (subst new old lst))
        (setq old new)
      )
    )
  )
  (defun blkdefedt_getltp ()
    (setq chk (atoi (get_tile "ltpsel")))
    (setq ltp (nth chk ltplst))
    (setq ent (car old))
    (if (/= (assoc 6 ent) nil)
      (setq ent (subst (cons 6 ltp)(assoc 6 ent) ent))
      (setq ent (append ent (list (cons 6 ltp))))
    )
    (if (= (cdr (assoc 0 ent)) "POLYLINE")
      (progn
        (setq cnt 0)
        (setq new (list ent))
        (foreach rec old
          (if (> cnt 0)
            (setq new (append new (list rec)))
          )
          (setq cnt (1+ cnt))
        )
        (setq lst (subst new old lst))
        (setq old new)
      )
      (progn
        (setq new (list ent))
        (setq lst (subst new old lst))
        (setq old new)
      )
    )
  )
  (defun blkdefedt_getcol (dia)
    (if (= dia T)
      (setq chk (acad_colordlg colval))
      (progn
        (setq tmp (get_tile "colval"))
        (setq col (dstp_str2col tmp))
        (if (and (>= col 0)(<= col 256))
          (setq chk col)
        )
      )
    )
    (if (/= chk nil)
      (progn
        (setq colval chk)
        (set_tile "colval" (dstp_col2str colval))
        (setq ent (car old))
        (if (/= (assoc 62 ent) nil)
          (setq ent (subst (cons 62 chk)(assoc 62 ent) ent))
          (setq ent (append ent (list (cons 62 chk))))
        )
        (if (= (cdr (assoc 0 ent)) "POLYLINE")
          (progn
            (setq cnt 0)
            (setq new (list ent))
            (foreach rec old
              (if (> cnt 0)
                (setq new (append new (list rec)))
              )
              (setq cnt (1+ cnt))
            )
            (setq lst (subst new old lst))
            (setq old new)
          )
          (progn
            (setq new (list ent))
            (setq lst (subst new old lst))
            (setq old new)
          )
        )
        (mode_tile "revert" 0)
      )
    )
  )
  (defun blkdefedt_applychg ()
    (if (= blkchg T)
      (progn
        (if (/= blkdes "")
          (if (/= (assoc 4 blk) nil)
            (setq blk (subst (cons 4 blkdes)(assoc 4 blk) blk))
            (setq blk (append blk (list (cons 4 blkdes))))
          )
        )
        (entmake blk)
        (foreach rec lst
          (setq itm (car rec))
          (if (= (cdr (assoc 0 itm)) "POLYLINE")
            (foreach itm rec
              (entmake itm)
            )
            (entmake itm)
          )
        )
        (entmake (list (cons 0 "ENDBLK")))
        (setq tmp (cdr (assoc 2 blk)))
        (if (not (member tmp chglst))
          (setq chglst (cons tmp chglst))
        )
        (mode_tile "revert" 1)
        (setq blkchg nil)
      )
    )
  )
  (defun blkdefedt_moveup ()
    (setq new nil)
    (setq pos (atoi datsel))
    (setq ent (nth pos lst))
    (setq cnt 0)
    (foreach rec lst
      (cond
        ((= cnt (- pos 1))
          (setq new (append new (list ent)))
          (setq new (append new (list rec)))
        )
        ((= cnt pos)
          (setq tmp nil)
        )
        (t
          (setq new (append new (list rec)))
        )
      )
      (setq cnt (1+ cnt))
    )
    (setq lst new)
    (setq new nil)
    (blkdefedt_dispdat)
    (setq datsel (itoa (- (atoi datsel) 1)))
    (mode_tile "datlst" 2)
    (set_tile "datlst" datsel)
    (if (= (atoi datsel) 0)
      (mode_tile "moveup" 1)
      (mode_tile "moveup" 0)
    )
    (if (= (atoi datsel) (- (length lst) 1))
      (mode_tile "movedn" 1)
      (mode_tile "movedn" 0)
    )
    (mode_tile "revert" 0)
  )
  (defun blkdefedt_movedn ()
    (setq new nil)
    (setq pos (atoi datsel))
    (setq ent (nth pos lst))
    (setq cnt 0)
    (foreach rec lst
      (cond
        ((= cnt pos)
          (setq tmp nil)
        )
        ((= cnt (+ pos 1))
          (setq new (append new (list rec)))
          (setq new (append new (list ent)))
        )
        (t
          (setq new (append new (list rec)))
        )
      )
      (setq cnt (1+ cnt))
    )
    (setq lst new)
    (setq new nil)
    (blkdefedt_dispdat)
    (setq datsel (itoa (+ (atoi datsel) 1)))
    (mode_tile "datlst" 2)
    (set_tile "datlst" datsel)
    (if (= (atoi datsel) 0)
      (mode_tile "moveup" 1)
      (mode_tile "moveup" 0)
    )
    (if (= (atoi datsel) (- (length lst) 1))
      (mode_tile "movedn" 1)
      (mode_tile "movedn" 0)
    )
    (mode_tile "revert" 0)
  )
  (defun blkdefedt_modatt ()
    (setq old (nth (atoi datsel) lst))
    (setq ent (car (nth (atoi datsel) lst)))
    (setq g70 (cdr (assoc 70 ent)))
    (if (= (boole 1 g70 1) 1)
      (setq modinv "1")
      (setq modinv "0")
    )
    (if (= (boole 1 g70 2) 2)
      (setq modcon "1")
      (setq modcon "0")
    )
    (if (= (boole 1 g70 4) 4)
      (setq modver "1")
      (setq modver "0")
    )
    (if (= (boole 1 g70 8) 8)
      (setq modpre "1")
      (setq modpre "0")
    )
    (setq attval (cdr (assoc 1 ent)))
    (setq atttag (strcase (cdr (assoc 2 ent))))
    (setq attprt (cdr (assoc 3 ent)))
    ;
    (if (not (new_dialog "blkdefedtatt" dcl_id)) (exit))
    (set_tile "modinv" modinv)
    (set_tile "modcon" modcon)
    (set_tile "modver" modver)
    (set_tile "modpre" modpre)
    (set_tile "attval" attval)
    (set_tile "atttag" atttag)
    (set_tile "attprt" attprt)
    (mode_tile "attval" 2)
    ;
    (action_tile "modinv" "(setq modinv $value)")
    (action_tile "modcon" "(setq modcon $value)")
    (action_tile "modver" "(setq modver $value)")
    (action_tile "modpre" "(setq modpre $value)")
    (action_tile "attval" "(setq attval $value)")
    (action_tile "atttag" "(setq atttag (strcase $value))")
    (action_tile "attprt" "(setq attprt $value)")
    (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
    (action_tile "accept" "(setq doproc T)(done_dialog 1)")
    (start_dialog)
    (if (= doproc T)
      (progn
        (setq g70 0)
        (if (= modinv "1")
          (setq g70 (+ g70 1))
        )
        (if (= modcon "1")
          (setq g70 (+ g70 2))
        )
        (if (= modver "1")
          (setq g70 (+ g70 4))
        )
        (if (= modpre "1")
          (setq g70 (+ g70 8))
        )
        (setq ent (subst (cons 70 g70)(assoc 70 ent) ent))
        (setq ent (subst (cons 1 attval)(assoc 1 ent) ent))
        (setq ent (subst (cons 2 atttag)(assoc 2 ent) ent))
        (setq ent (subst (cons 3 attprt)(assoc 3 ent) ent))
        (setq new (list ent))
        (setq lst (subst new old lst))
        (setq old new)
        (setq blkchg T)
        (blkdefedt_chpdisp)
        (blkdefedt_dispdat)
      )
    )
  )
  ;
  ; --- Main Dialog Routine
  ;
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  ;
  (setq blkchg nil)
  (setq chglst nil)
  (setq regchg "1")
  (setq reinst "1")
  (setq laylst (dstp_bldlst "LAYER"))
  (setq ltplst (dstp_bldlst "LTYPE"))
  (setq blklst (dstp_bldlst "BLOCK"))
  (if (> (length blklst) 0)
    (progn
      (setq laylst (acad_strlsort laylst))
      (setq ltplst (acad_strlsort ltplst))
      (setq ltplst (cons "BYBLOCK" ltplst))
      (setq ltplst (cons "BYLAYER" ltplst))
      (setq blklst (acad_strlsort blklst))
      (setq dcl_id (load_dialog "unsupport.dcl"))
      (if (not (new_dialog "blkdefedt" dcl_id)) (exit))
      (set_tile "regchg" regchg)
      (set_tile "reinst" reinst)
      (start_list "blklst")
      (mapcar 'add_list blklst)
      (end_list)
      (start_list "laysel")
      (mapcar 'add_list laylst)
      (end_list)
      (start_list "ltpsel")
      (mapcar 'add_list ltplst)
      (end_list)
      ;
      (action_tile "blklst" "(setq blksel $value)(blkdefedt_selblk)")
      (action_tile "regchg" "(setq regchg $value)")
      (action_tile "reinst" "(setq reinst $value)")
      (action_tile "revert" "(setq blkchg nil)(blkdefedt_selblk)")
      (action_tile "datlst" "(setq datsel $value)(blkdefedt_seldat)")
      (action_tile "moveup" "(blkdefedt_moveup)(setq blkchg T)(blkdefedt_chpdisp)")
      (action_tile "movedn" "(blkdefedt_movedn)(setq blkchg T)(blkdefedt_chpdisp)")
      (action_tile "modify" "(blkdefedt_modatt)")
      (action_tile "laysel" "(blkdefedt_getlay)(setq blkchg T)(blkdefedt_chpdisp)")
      (action_tile "ltpsel" "(blkdefedt_getltp)(setq blkchg T)(blkdefedt_chpdisp)")
      (action_tile "colval" "(blkdefedt_getcol nil)(setq blkchg T)(blkdefedt_chpdisp)")
      (action_tile "colsel" "(blkdefedt_getcol T)(setq blkchg T)(blkdefedt_chpdisp)")
      (action_tile "blkdes" "(setq blkdes $value)(setq blkchg T)(blkdefedt_chpdisp)")
      ;
      (action_tile "accept" "(setq docancel nil)(done_dialog 0)")
      (action_tile "cancel" "(setq docancel T)(done_dialog 0)")
      (if (equal (start_dialog) 1)
        (setq tmp nil)
      )
      (unload_dialog dcl_id)
      (if (= docancel T)
        (progn
          (princ "\nDS> Undoing any changes made!")
          (command "_.UNDO" "_B")
        )
        (progn
          (if (= blkchg T)
            (blkdefedt_applychg)
          )
          (if (and (= regchg "0")(= reinst "0"))
            (setq tmp nil)
            (progn
              (setq cnt 0)
              (princ "\nDS> Processing Changed Blocks ...\rDS> Processing Changed Blocks ...")
              (foreach nam chglst
                (setq chk (tblsearch "BLOCK" nam))
                (setq g70 (cdr (assoc 70 chk)))
                (setq sset (ssget "_X" (list (cons 0 "INSERT") (cons 2 nam))))
                (if (/= sset nil)
                  (progn
                    (setq num (sslength sset) itm 0)
                    (while (< itm num)
                      (setq hnd (ssname sset itm))
                      (if (= reinst "1")
                        (progn
                          (if (= (boole 1 g70 2) 2) ; has attrib?
                            (dstp_supreins hnd)
                            (if (= regchg "1")
                              (entupd hnd)
                            )
                          )
                        )
                        (progn
                          (entupd hnd)
                        )
                      )
                      (setq itm (1+ itm))
                    )
                  )
                )
                (setq cnt (1+ cnt))
              )
              (princ " Done.")
            )
          )
        )
      )
    )
    (princ "\nDS> No Blocks Defined!")
  )
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                          Block Import Data
; --------------------------------------------------------------------------

(defun c:LegBlkImp ( / attent atthnd attlst attreq atttag attval blipmode
                       blk blkchg blkent blkfnd blkhnd blklay blkovr chk
                       cmdecho cnt ctr datlst done ent fh hdr hdrlst hfd
                       hnd hndall itm lin lookup lst new nins nme nrot num
                       nxtent nxthnd oins orot osmode pass pnt pos rot sset
                       tmp tmplst ucs upd xcd xsc ycd ysc zcd)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq blipmode (getvar "BLIPMODE"))
  (setvar "BLIPMODE" 0)
  (setq osmode (getvar "OSMODE"))
  (setvar "OSMODE" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (if (not (equal (getvar "UCSORG") (list 0.0 0.0 0.0)))
    (progn
      (initget "Y N")
      (setq tmp (getkword "\nDS> Honor Current UCS Y/<N>: "))
      (if (/= tmp "Y")(setq ucs nil)(setq ucs T))
    )
  )
  (setq tmp (dstp_getfiles "Select Comma Separated ASCII File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "CSV;ASC;TXT" 0))
  (if (/= tmp nil)
    (progn
      (setq datlst nil)
      (setq hdrlst nil)
      (setq fh (open tmp "r"))
      (if (/= fh nil)
        (progn
          (princ "\nDS> File Open ... PreProcessing ... ")
          (setq lin (read-line fh))
          (setq lin (strcase lin))
          (setq hdrlst (dstp_pdf2lst lin dstp_csvchar))
          (if (and (= (length hdrlst) 1)(dstp_instr lin (chr 9)))
            (setq hdrlst (dstp_pdf2lst lin (chr 9)))
          )
          (setq done nil)
          (while (/= done T)
            (setq lin (read-line fh))
            (if (or (= lin nil) (= lin ""))
              (setq done T)
              (progn
                (setq lin (dstp_ltrim (dstp_rtrim lin)))
                (setq tmp (dstp_pdf2lst lin dstp_csvchar))
                (if (and (= (length tmp) 1)(dstp_instr lin (chr 9)))
                  (setq tmp (dstp_pdf2lst lin (chr 9)))
                )
                (setq lst nil)
                (foreach itm tmp
                  (if (= (substr itm 1 1) (chr 34))
                    (setq itm (substr itm 2 (- (strlen itm) 2)))
                  )
                  (setq lst (append lst (list itm)))
                )
                (if (< (length lst)(length hdrlst))
                  (repeat (- (length hdrlst)(length lst))
                    (setq lst (append lst (list "")))
                  )
                )
                (setq datlst (append datlst (list lst)))
              )
            )
          )
          (close fh)
          (princ "Done.")
          (setq blkfnd nil)
          (setq blkovr nil)
          (foreach rec hdrlst
            (if (= rec ".BLOCKNAME")
              (setq blkfnd T)
            )
          )
          (setq hndall nil)
          (foreach rec hdrlst
            (if (= (strcase rec) ".HANDLE")
              (setq hndall T)
            )
          )
          (setq pass T)
          (if (= hndall nil)
            (progn
              (initget "Y N")
              (setq tmp (getkword "\nDS> Lookup Handle Based On Attribute Field Y/<N>: "))
              (if (= tmp "Y")
                (progn
                  (setq tmplst nil)
                  (foreach rec hdrlst
                    (if (/= (substr rec 1 1) ".")
                      (setq tmplst (cons rec tmplst))
                    )
                  )
                  (if (> (length tmplst) 0)
                    (progn
                      (setq lookup (dstp_tablesel "Select Lookup Attribute" (acad_strlsort tmplst) "s" ""))
                      (if (or (= lookup nil)(= lookup ""))
                        (setq hndall nil)
                        (progn
                          (setq hdrlst (cons ".HANDLE" hdrlst))
                          (setq tmp nil)
                          (foreach rec datlst
                            (setq rec (cons "" rec))
                            (setq tmp (cons rec tmp))
                          )
                          (setq datlst tmp)
                          (setq tmp (member lookup hdrlst))
                          (setq pos (- (length hdrlst) (length tmp)))
                          (setq sset (ssget "_X" (list (cons 0 "INSERT") (cons 66 1))))
                          (if sset
                            (progn
                              (dstp_prompt "DS> Attempting to look up handles ... ")
                              (setq num (sslength sset) itm 0)
                              (princ "\nDS>")
                              (while (< itm num)
                                (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
                                (setq blkhnd (ssname sset itm))
                                (setq blkent (entget blkhnd))
                                (setq blklay (cdr (assoc 8 blkent)))
                                (setq blkchg nil)
                                (setq atthnd blkhnd)
                                (setq attent blkent)
                                (while (/= "SEQEND" (cdr (assoc 0 attent)))
                                  (setq atthnd (entnext atthnd))
                                  (setq attent (entget atthnd))
                                  (if (= (cdr (assoc 0 attent)) "ATTRIB")
                                    (progn
                                      (setq atttag (strcase (cdr (assoc 2 attent))))
                                      (setq attval (strcase (cdr (assoc 1 attent))))
                                      (if (= atttag lookup)
                                        (foreach rec datlst
                                          (if (= (car rec) "")
                                            (if (= (strcase (nth pos rec)) (strcase attval))
                                              (progn
                                                (setq new nil)
                                                (setq new (cons (cdr (assoc 5 blkent)) new))
                                                (setq cnt 0)
                                                (foreach itm rec
                                                  (if (> cnt 0)
                                                    (setq new (cons itm new))
                                                  )
                                                  (setq cnt (1+ cnt))
                                                )
                                                (setq new (reverse new))
                                                (setq datlst (subst new rec datlst))
                                              )
                                            )
                                          )
                                        )
                                      )
                                    )
                                  )
                                )
                                (setq itm (1+ itm))
                              )
                              (princ ", Done.")
                              (setq hndall T)
                              (setq blkovr "AutoCAD Point")
                            )
                          )
                        )
                      )
                    )
                    (alert "No Attribute Fields\nDesignated in Data File!")
                  )
                )
              )
              (if (= blkfnd nil)
                (if (= blkovr nil)
                  (progn
                    (setq blkovr (dstp_tablesel "Select Block Definition" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
                    (if (or (= blkovr nil)(= blkovr ""))
                      (setq pass nil)
                    )
                  )
                )
              )
            )
          )
          (if (= pass T)
            (progn
              (setq upd nil)
              (setq hfd nil)
              (setq ctr 0)
              (foreach rec hdrlst
                (if (= rec ".HANDLE")
                  (setq hfd ctr)
                )
                (setq ctr (1+ ctr))
              )
              (princ "\nDS>")
              (setq itm 0)
              (setq ent nil)
              (setq num (length datlst))
              (foreach rec datlst
                (princ (strcat "\rDS> Processing Record " (itoa (1+ itm)) " of " (itoa num)))
                (setq upd nil)
                (if (/= hfd nil)
                  (progn
                    (setq chk (nth hfd rec))
                    (if (dstp_instr chk "'")
                      (setq chk (substr chk 2 (- (strlen chk) 1)))
                    )
                    (setq hnd (handent chk))
                    (if (/= hnd nil)
                      (progn
                        (setq ent (entget hnd))
                        (if (/= ent nil)
                          (setq upd T)
                        )
                      )
                    )
                  )
                )
                (if (/= upd T)
                  (progn
                    (setq ctr 0)
                    (setq blk nil)
                    (setq xsc "1")
                    (setq ysc "1")
                    (setq xcd "0")
                    (setq ycd "0")
                    (setq zcd "0")
                    (foreach fld rec
                      (setq hdr (nth ctr hdrlst))
                      (if (= hdr ".BLOCKNAME")(setq blk fld))
                      (if (= hdr ".XSCALE")(setq xsc fld))
                      (if (= hdr ".YSCALE")(setq ysc fld))
                      (if (= hdr ".INSPTX")(setq xcd fld))
                      (if (= hdr ".INSPTY")(setq ycd fld))
                      (if (= hdr ".INSPTZ")(setq zcd fld))
                      (setq ctr (1+ ctr))
                    )
                    (if (and (= blkfnd nil)(/= blkovr nil))
                      (setq blk blkovr)
                    )
                    (setq pnt (list (atof xcd) (atof ycd) (atof zcd)))
                    (if (= ucs T)
                      (setq pnt (trans pnt 1 0))
                    )
                    (if (/= blk nil)
                      (progn
                        (if (= blk "AutoCAD Point")
                          (command "_.POINT" pnt)
                          (progn
                            (setq attreq (getvar "ATTREQ"))
                            (setvar "ATTREQ" 0)
                            (command "_.INSERT" blk pnt xsc ysc "0")
                            (setvar "ATTREQ" attreq)
                            (setq hnd (entlast))
                            (setq ent (entget hnd))
                            (if (/= ent nil)
                              (setq upd T)
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (if (and (= upd T)(/= ent nil))
                  (progn
                    (setq oins (cdr (assoc 10 ent)))
                    (setq orot (dstp_rtd (cdr (assoc 50 ent))))
                    (setq nins oins)
                    (setq nrot orot)
                    (setq attlst nil)
                    (if (/= (cdr (assoc 66 ent)) nil)
                      (progn
                        (if (= (boole 1 (cdr (assoc 66 ent)) 1) 1)
                          (progn
                            (setq nxthnd hnd)
                            (setq nxtent ent)
                            (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
                              (setq nxthnd (entnext nxthnd))
                              (setq nxtent (entget nxthnd))
                              (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
                                (setq attlst (append attlst (list nxtent)))
                              )
                            )
                          )
                        )
                      )
                    )
                    (setq ctr 0)
                    (setq rot "0")
                    (foreach fld rec
                      (setq hdr (nth ctr hdrlst))
                      (if (/= hdr nil)
                        (progn
                          (cond
                            ((= hdr ".HANDLE")
                              (setq tmp nil)
                            )
                            ((= hdr ".BLOCKNAME")
                              (setq tmp nil)
                            )
                            ((= hdr ".INSPTX")
                              (setq nins (list (atof fld) (nth 1 nins) (nth 2 nins)))
                            )
                            ((= hdr ".INSPTY")
                              (setq nins (list (nth 0 nins) (atof fld) (nth 2 nins)))
                            )
                            ((= hdr ".INSPTZ")
                              (setq nins (list (nth 0 nins) (nth 1 nins) (atof fld)))
                            )
                            ((= hdr ".XSCALE")
                              (setq ent (subst (cons 41 (atof fld))(assoc 41 ent) ent))
                            )
                            ((= hdr ".YSCALE")
                              (setq ent (subst (cons 42 (atof fld))(assoc 42 ent) ent))
                            )
                            ((= hdr ".ZSCALE")
                              (setq ent (subst (cons 43 (atof fld))(assoc 43 ent) ent))
                            )
                            ((= hdr ".ROTATION")
                              (setq nrot fld)
                            )
                            ((= hdr ".COLOR")
                              (if (/= (assoc 62 ent) nil)
                                (setq ent (subst (cons 62 (dstp_str2col fld))(assoc 62 ent) ent))
                                (setq ent (append ent (list (cons 62 (dstp_str2col fld)))))
                              )
                            )
                            ((= hdr ".LAYER")
                              (setq ent (subst (cons 8 fld)(assoc 8 ent) ent))
                            )
                            ((= hdr ".LINETYPE")
                              (setq ent (subst (cons 6 fld)(assoc 6 ent) ent))
                            )
                            ((= hdr ".THICKNESS")
                              (setq ent (subst (cons 39 fld)(assoc 39 ent) ent))
                            )
                            (t
                              (if (/= attlst nil)
                                (progn
                                  (foreach att attlst
                                    (setq nme (cdr (assoc 2 att)))
                                    (if (= (strcase nme)(strcase hdr))
                                      (progn
                                        (setq att (subst (cons 1 fld)(assoc 1 att) att))
                                        (entmod att)
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                        )
                      )
                      (setq ctr (1+ ctr))
                    )
                    (entmod ent)
                    (if (= ucs T)
                      (setq nins (trans nins 1 0))
                    )
                    (command "_.MOVE" hnd "" oins nins)
                    (command "_.ROTATE" hnd "" nins "_R" orot nrot)
                  )
                )
                (setq itm (1+ itm))
              )
              (princ ", Done.")
            )
          )
        )
        (alert "ERROR: Unable to open file, check other\napplications that may have this file open.")
      )
    )
  )
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "BLIPMODE" blipmode)
  (setvar "CMDECHO" cmdecho)
  (setvar "OSMODE" osmode)
  (princ)
)

; --------------------------------------------------------------------------
;                          Block Insert Incrementing
; --------------------------------------------------------------------------

(defun c:LegBlkInc ( / attdia attent atthnd attreq atttag blkent blkhnd
                        cmdecho done fld inc lst nam name rot tmp val
                        xsc ysc zsc)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq attdia (getvar "ATTDIA"))
  (setvar "ATTDIA" 1)
  (setq attreq (getvar "ATTREQ"))
  (setvar "ATTREQ" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  ;
  (defun blkincr_error (s)
    (if (/= s "Function cancelled.")
      (progn
        (dstp_ucspop)
        (command "_.UNDO" "_E")
        (setvar "CMDECHO" cmdecho)
        (setvar "ATTDIA" attdia)
        (setvar "ATTREQ" attreq)
        (setq *error* olderr)
      )
    )
    (if olderr (setq *error* olderr))
    (princ)
  )
  (setq olderr *error*)
  (setq *error* blkincr_error)
  (setq nam (dstp_tablesel "Select Block" (acad_strlsort (dstp_bldlst "BLOCK")) "s" ""))
  (if (/= nam nil)
    (progn
      (setq lst (dstp_attdef nam))
      (if (/= lst nil)
        (progn
          (if (= (length lst) 1)
            (setq fld (car lst))
            (setq fld (dstp_tablesel "Select Attribute" (acad_strlsort lst) "s" ""))
          )
          (setq tmp (getint "\nDS> Increment Value <1>: "))
          (if (= tmp nil)(setq inc 1)(setq inc tmp))
          (setq tmp (getint "\nDS> Starting Value <1>: "))
          (if (= tmp nil)(setq val 1)(setq val tmp))
          ;
          (if (= dstp_blkxsc nil)
            (progn
              (setq xsc (getreal (strcat "\n[" name "] X Scale Factor <1.0>: ")))
              (if (= xsc nil)(setq xsc 1.0))
            )
            (setq xsc dstp_blkxsc)
          )
          (if (= dstp_blkysc nil)
            (progn
              (setq ysc (getreal (strcat "\n[" name "] Y Scale Factor <" (rtos xsc 2 1) ">: ")))
              (if (= ysc nil)(setq ysc xsc))
            )
            (setq ysc dstp_blkysc)
          )
          (if (= dstp_blkzsc nil)
            (progn
              (setq zsc (getreal (strcat "\n[" name "] Z Scale Factor <1.0>: ")))
              (if (= zsc nil)(setq zsc 1.0))
            )
            (setq zsc dstp_blkzsc)
          )
          (if (= dstp_blkrot nil)
            (progn
              (setq rot (getreal (strcat "\n[" name "] Rotation Angle <0>: ")))
              (if (= rot nil)(setq rot 0.0))
            )
            (setq rot (- dstp_blkrot 360.0))
          )
          ;
          (setq done nil)
          (while (/= done T)
            (princ (strcat "\nDS> Pick location for [" nam "] with value of [" (rtos val 2 0) "] (Esc to cancel): "))
            (initdia 1)
            (command "_.-INSERT" nam "_X" xsc "_Y" ysc "_Z" zsc "_R" rot pause)
            (setq blkhnd (entlast))
            (setq blkent (entget blkhnd))
            (setq atthnd blkhnd)
            (setq attent blkent)
            (while (/= "SEQEND" (cdr (assoc 0 attent)))
              (setq atthnd (entnext atthnd))
              (setq attent (entget atthnd))
              (if (= (cdr (assoc 0 attent)) "ATTRIB")
                (progn
                  (setq atttag (strcase (cdr (assoc 2 attent))))
                  (if (= atttag fld)
                    (progn
                      (setq attent (subst (cons 1 (rtos val 2 0))(assoc 1 attent) attent))
                      (entmod attent)
                    )
                  )
                )
              )
            )
            (entupd blkhnd)
            (setq val (+ val inc))
          )
        )
        (princ "\nDS> Selected Block has no attributes!")
      )
    )
  )
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (setvar "ATTDIA" attdia)
  (setvar "ATTREQ" attreq)
  (setq *error* olderr)
  (princ)
)

; --------------------------------------------------------------------------
;                            Dialog Calculator
; --------------------------------------------------------------------------

(defun c:LegCalDia (/ redo mem1 mem2 disval decplc disdone hnd ent val)
  ;
  ; --- get first value & operator
  ;
  (defun calculat_setops (opt)
    (setq v1 disval)
    (setq op opt)
    (setq disdone T)
  )
  ;
  ; --- get second value & process
  ;
  (defun calculat_calops ()
    (setq v2 disval)
    (setq res nil)
    (cond
      ((= op "+")(setq res (+ v1 v2)))
      ((= op "-")(setq res (- v1 v2)))
      ((= op "*")(setq res (* v1 v2)))
      ((= op "/")(setq res (/ v1 v2)))
      (t nil)
    )
    (if (/= res nil)
      (progn
        (setq disval res)
        (setq disstr (rtos disval 2 decplc))
        (set_tile "disval" disstr)
      )
    )
    (setq v1 nil)
    (setq v2 nil)
    (setq op nil)
    (calculat_setenter)
    (setq disdone T)
  )
  ;
  ; --- clear display & operators
  ;
  (defun calculat_clear ()
    (setq disval 0)
    (setq v1 nil v2 nil op nil)
    (setq disstr (rtos disval 2 decplc))
    (set_tile "disval" disstr)
    (mode_tile "disval" 2)
  )
  ;
  ; --- change decimal precision & display
  ;
  (defun calculat_chgprec ()
    (setq decplc (atoi (get_tile "prec")))
    (setq disstr (rtos disval 2 decplc))
    (set_tile "disval" disstr)
    (set_tile "mem1" (rtos mem1 2 decplc))
    (set_tile "mem2" (rtos mem2 2 decplc))
    (calculat_setenter)
  )
  ;
  ; --- set enter key as default key
  ;
  (defun calculat_setenter ()
    (mode_tile "enter" 2)
  )
  ;
  ; --- decide on clear & append number
  ;
  (defun calculat_donum (opt)
    (if (= disdone T)
      (progn
        (set_tile "disval" "")
        (setq disdone nil)
      )
    )
    (setq nstr (strcat (get_tile "disval") opt))
    (setq disval (atof nstr))
    (set_tile "disval" nstr)
  )
  ;
  ; --- main routine
  ;
  (setq orthomode (getvar "ORTHOMODE"))
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "ORTHOMODE" 0)
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (setq redo T)
  (setq mem1 0.0)
  (setq mem2 0.0)
  (setq disval 0.0)
  (setq decplc (getvar "LUPREC"))
  (setq disdone T)
  (princ "\nDS> ")
  ;
  ; --- load and run dialog
  ;
  (setq dcl_id (load_dialog (strcat dstpdir "unsupport.dcl")))
  (setq what_next 9)
  (while (< 2 what_next)
    (if (not (new_dialog "calculat" dcl_id)) (exit))
    (if (= redo T)
      (progn
        (set_tile "prec" (itoa decplc))
        (setq disstr (rtos disval 2 decplc))
        (set_tile "disval" disstr)
        (set_tile "mem1" (rtos mem1 2 decplc))
        (set_tile "mem2" (rtos mem2 2 decplc))
        (calculat_setenter)
        (setq redo nil)
      )
    )
    ;
    (action_tile "disval" "(setq disval (atof $value))(calculat_setenter)")
    (action_tile "." "(calculat_donum \".\")")
    (action_tile "0" "(calculat_donum \"0\")")
    (action_tile "1" "(calculat_donum \"1\")")
    (action_tile "2" "(calculat_donum \"2\")")
    (action_tile "3" "(calculat_donum \"3\")")
    (action_tile "4" "(calculat_donum \"4\")")
    (action_tile "5" "(calculat_donum \"5\")")
    (action_tile "6" "(calculat_donum \"6\")")
    (action_tile "7" "(calculat_donum \"7\")")
    (action_tile "8" "(calculat_donum \"8\")")
    (action_tile "9" "(calculat_donum \"9\")")
    ;
    (action_tile "+" "(calculat_setops \"+\")")
    (action_tile "-" "(calculat_setops \"-\")")
    (action_tile "*" "(calculat_setops \"*\")")
    (action_tile "/" "(calculat_setops \"/\")")
    (action_tile "=" "(calculat_calops)")
    ;
    (action_tile "valget" "(done_dialog 3)")
    (action_tile "valplc" "(done_dialog 4)")
    (action_tile "prec" "(calculat_chgprec)")
    (action_tile "clear" "(calculat_clear)")
    (action_tile "mem1" "(setq mem1 (atof $value))(calculat_setenter)")
    (action_tile "str1" "(setq mem1 disval)(set_tile \"mem1\" (rtos mem1 2 decplc))(calculat_setenter)")
    (action_tile "rcl1" "(setq disval mem1)(set_tile \"disval\" (rtos disval 2 decplc))(calculat_setenter)")
    (action_tile "mem2" "(setq mem2 (atof $value))(calculat_setenter)")
    (action_tile "str2" "(setq mem2 disval)(set_tile \"mem2\" (rtos mem2 2 decplc))(calculat_setenter)")
    (action_tile "rcl2" "(setq disval mem2)(set_tile \"disval\" (rtos disval 2 decplc))(calculat_setenter)")
    ;
    (setq what_next (start_dialog))
    (cond 
      ((= what_next 3)
        (setq hnd (car (entsel "Select Text Value: ")))
        (if (/= hnd nil)
          (progn
            (setq ent (entget hnd))
            (if (= "TEXT" (cdr (assoc 0 ent))) 
              (progn
                (setq val (cdr (assoc 1 ent)))
                (setq disval (atof val))
                (princ disval)
                (setq disdone T)
                (setq redo T)
              )
            )
          )
        )
        (princ "\nDS> ")
        (setq redo T)
      )
      ((= what_next 4)
        (setq newtxt '((0 . "TEXT")))
        (setq viewctr (getvar "VIEWCTR"))
        (setq newtxt (append newtxt (list (list 10 (nth 0 viewctr) (nth 1 viewctr) (nth 2 viewctr)))))
        (setq newtxt (append newtxt (list (cons 40 (dstp_textsize)))))
        (setq newtxt (append newtxt (list (cons 7 (getvar "TEXTSTYLE")))))
        (setq newtxt (append newtxt (list (cons 1 disstr))))
        (entmake newtxt)
        (setq hnd (entlast))
        (princ (strcat "Location For " disstr ": "))
        (command "_.MOVE" hnd "" viewctr pause)
        (princ "\nDS> ")
        (setq redo T)
      )
      (t nil)
    )
  )
  (unload_dialog dcl_id)
  ;
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "ORTHOMODE" orthomode)
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;               Change Space Paper <-> Model of selected objects
; --------------------------------------------------------------------------

(defun c:LegChgSpc ( / chk cmdecho cvhgt cvscl cvsiz ent eoo hnd msctr
                         osmode psctr psrot sset tmp vpi vpl)
  (if (= (getvar "TILEMODE") 1)
    (alert "Paper Space Not Enabled!\n\nSet TILEMODE variable to 0\nor use Layout tabs.")
    (progn
      (if (= (getvar "CVPORT") 1)
        (progn ; paper > model
          (princ "\nDS> Select Objects to Transfer to Model Space ...")
          (setq sset (ssget '((-4 . "<NOT")(0 . "VIEWPORT")(-4 . "NOT>"))))
          (if sset
            (progn
              (setq chk (dstp_ssremlok sset))
              (if (> (cadr chk) 0)
                (progn
                  (setq sset (car chk))
                  (sssetfirst nil sset)
                  (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
                )
              )
              ;
              (initget "Y N")
              (setq tmp (getkword "\nDS> Erase Original Objects <Y>/N: "))
              (if (/= tmp "N")(setq eoo T)(setq eoo nil))
              ;
              (setq tmp (entsel "\nDS> Select Viewport: "))
              (if (/= tmp nil)
                (progn
                  (setq hnd (car tmp))
                  (setq ent (entget hnd '("ACAD")))
                  (setq obj (cdr (assoc 0 ent)))
                  (if (member obj (list "LWPOLYLINE" "POLYLINE" "ELLIPSE" "SPLINE" "REGION" "CIRCLE"))
                    (progn
                      (setq pik (cadr tmp))
                      (setq llc (list (- (car pik) 0.1) (- (cadr pik) 0.1)))
                      (setq lrc (list (+ (car pik) 0.1) (- (cadr pik) 0.1)))
                      (setq urc (list (+ (car pik) 0.1) (+ (cadr pik) 0.1)))
                      (setq ulc (list (- (car pik) 0.1) (+ (cadr pik) 0.1)))
                      (setq ptl (list llc lrc urc ulc))
                      (setq cset (ssget "_CP" ptl '((0 . "VIEWPORT"))))
                      (if (/= cset nil)
                        (progn
                          (setq hnd (ssname cset 0))
                          (setq ent (entget hnd '("ACAD")))
                          (setq obj (cdr (assoc 0 ent)))
                        )
                      )
                    )
                  )
                  (if (= obj "VIEWPORT")
                    (progn
                      (setq g68 (cdr (assoc 68 ent)))
                      (if (/= (cdr (assoc 68 ent)) 0)
                        (progn
                          (setq vpi (cdr (assoc 69 ent)))
                          (setq vpl (ssget "_X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
                          (setq hnd (ssname vpl 0))
                          (setq ent (entget hnd '("ACAD")))
                          (setq psrot (cdr (assoc 51 ent)))
                          (setq psctr (cdr (assoc 10 ent)))
                          (setq cvhgt (cdr (assoc 41 ent)))
                          (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
                          (setq cvscl (/ cvsiz cvhgt))
                          (setq osmode (getvar "OSMODE"))
                          (setvar "OSMODE" 0)
                          (setq cmdecho (getvar "CMDECHO"))
                          (setvar "CMDECHO" 0)
                          (command "_.MSPACE")
                          (setvar "CVPORT" vpi)
                          (setq msctr (trans (trans psctr 3 2) 2 0))
                          (command "_.PSPACE")
                          ;
                          (command "_.UNDO" "_G")
                          (dstp_ucspush)
                          (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
                          (command "_.BLOCK" "DSTP_PURGEME" psctr sset "")
                          (dstp_ucspop)
                          (if (= eoo nil)
                            (command "_.OOPS")
                          )
                          (command "_.MSPACE")
                          (dstp_ucspush)
                          (command "_.INSERT" "*DSTP_PURGEME" msctr cvscl (- 0.0 (dstp_rtd psrot)))
                          (dstp_ucspop)
                          (command "_.PSPACE")
                          (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
                          (command "_.UNDO" "_E")
                          (setvar "CMDECHO" cmdecho)
                          (setvar "OSMODE" osmode)
                          (princ (strcat "\nDS> Total of " (itoa (sslength sset)) " Objects Processed"))
                          (princ (strcat "\nDS> Geometry Scaled at Factor of " (rtos cvscl)))
                          (setq sset nil)
                        )
                        (alert "Cannot use selected viewport, it is turned off.")
                      )
                    )
                    (princ "\nDS> Selected Object was not a VIEWPORT!")
                  )
                )
              )
            )
          )
        )
        (progn ; model > paper
          (princ "\nDS> Select Objects to Transfer to Paper Space ...")
          (setq sset (ssget))
          (if sset
            (progn
              (setq chk (dstp_ssremlok sset))
              (if (> (cadr chk) 0)
                (progn
                  (setq sset (car chk))
                  (sssetfirst nil sset)
                  (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Objects Removed"))
                )
              )
              ;
              (initget "Y N")
              (setq tmp (getkword "\nDS> Erase Original Objects <Y>/N: "))
              (if (/= tmp "N")(setq eoo T)(setq eoo nil))
              ;
              (setq vpi (getvar "CVPORT"))
              (setq vpl (ssget "_X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
              (setq hnd (ssname vpl 0))
              (setq ent (entget hnd '("ACAD")))
              (setq psrot (cdr (assoc 51 ent)))
              (setq psctr (cdr (assoc 10 ent)))
              (setq cvhgt (cdr (assoc 41 ent)))
              (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
              (setq cvscl (/ cvhgt cvsiz))
              (setq msctr (trans (trans psctr 3 2) 2 0))
              ;
              (setq osmode (getvar "OSMODE"))
              (setvar "OSMODE" 0)
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (command "_.UNDO" "_G")
              (dstp_ucspush)
              (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
              (command "_.BLOCK" "DSTP_PURGEME" msctr sset "")
              (dstp_ucspop)
              (if (= eoo nil)
                (command "_.OOPS")
              )
              (command "_.PSPACE")
              (dstp_ucspush)
              (command "_.INSERT" "*DSTP_PURGEME" psctr cvscl (dstp_rtd psrot))
              (dstp_ucspop)
              (command "_.MSPACE")
              (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
              (command "_.UNDO" "_E")
              (setvar "CMDECHO" cmdecho)
              (setvar "OSMODE" osmode)
              (princ (strcat "\nDS> Total of " (itoa (sslength sset)) " Objects Processed"))
              (princ (strcat "\nDS> Geometry Scaled at Factor of " (rtos cvscl)))
              (setq sset nil)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Convert Attributes to ADE1 EED
; --------------------------------------------------------------------------

(defun c:LegCnvAtt ( / $value addto attcat attlst atttag attval blkent
                        blkhnd cmdecho datlst dcl_id dianam dolst doproc
                        eedlin eedlst eedstr eedtot eedtyp fndtag itm
                        newblk num nxtent nxthnd optitm optsel resitm
                        reslst sset tmp typ uct)
  (defun cvatt2ed_updlst ()
    (start_list "attlst")
    (foreach rec attlst
      (add_list (strcat (car rec) "\t" (cadr rec)))
    )
    (end_list)
  )
  ;
  (defun cvatt2ed_lstcon (op / inc lat)
    (if (= op 0)
      (set_tile "attlst" "")
      (progn
        (setq inc 0)
        (setq lat "")
        (repeat (length attlst)
          (setq lat (strcat lat (rtos inc 2 0) " "))
          (setq inc (1+ inc))
        )
        (set_tile "attlst" lat)
      )
    )
  )
  ;
  (defun cvatt2ed_asstyp (opt)
    (if (= opt 1)
      (setq typ "Character")
      (setq typ "Numeric")
    )
    (setq uct 1)
    (setq reslst nil)
    (while (setq optitm (read optsel))
      (setq resitm (car (nth optitm attlst)))
      (setq reslst (append reslst (list resitm)))
      (while (and (/= " " (substr optsel uct 1))
        (/= "" (substr optsel uct 1)))
        (setq uct (1+ uct))
      )
      (setq optsel (substr optsel uct))
    )
    (setq tmp nil)
    (foreach itm attlst
      (if (member (car itm) reslst)
        (setq itm (list (car itm) typ))
      )
      (setq tmp (append tmp (list itm)))
    )
    (setq attlst tmp)
    (cvatt2ed_updlst)
  )
  ;
  (defun cvatt2ed_preproc ()
    (princ "\nDS> Select Blocks to Process ...")
    (setq sset (ssget '((0 . "INSERT") (66 . 1))))
    (if sset
      (progn
        (setq attlst nil)
        (setq num (sslength sset) itm 0)
        (while (< itm num)
          (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
          (setq blkhnd (ssname sset itm))
          (setq blkent (entget blkhnd))
          (setq nxthnd blkhnd)
          (setq nxtent blkent)
          (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
            (setq nxthnd (entnext nxthnd))
            (setq nxtent (entget nxthnd))
            (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
              (progn
                (setq attval (cdr (assoc 1 nxtent)))
                (setq atttag (cdr (assoc 2 nxtent)))
                (setq fndtag nil)
                (foreach rec attlst
                  (if (= (car rec) atttag)
                     (setq fndtag T)
                  )
                )
                (if (= fndtag nil)
                  (progn
                    (if (or (/= (atof attval) 0.0)(= attval "0"))
                      (setq attcat "Numeric")
                      (setq attcat "Character")
                    )
                    (setq attlst (append attlst (list (list atttag attcat))))
                  )
                )
              )
            )
          )
          (setq itm (1+ itm))
        )
        (princ ", Done.\n")
      )
    )
  )
  ;
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (setq doproc nil)
  (cvatt2ed_preproc)
  (if sset
    (progn
      (if (= dstp_diasize 2)
        (setq dianam "cvatt2ed2")
        (setq dianam "cvatt2ed1")
      )
      (setq dcl_id (load_dialog "unsupport.dcl"))
      (if (not (new_dialog dianam dcl_id)) (exit))
      (cvatt2ed_updlst)
      ;
      (action_tile "attlst" "(setq optsel $value)")
      (action_tile "selall" "(cvatt2ed_lstcon 1)")
      (action_tile "clrall" "(cvatt2ed_lstcon 0)")
      (action_tile "fldchr" "(cvatt2ed_asstyp 1)")
      (action_tile "fldnum" "(cvatt2ed_asstyp 2)")
      ;
      (action_tile "accept" "(setq doproc T)(done_dialog 0)")
      (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
      (if (equal (start_dialog) 1)
        (unload_dialog dcl_id)
      )
    )
  )
  ;
  ; --- Begin Processing Data
  ;
  (if (= doproc T)
    (progn
      (princ "\nDS>")
      (if (not (tblsearch "APPID" "ADE"))
        (regapp "ADE")
      )
      (setq num (sslength sset) itm 0)
      (while (< itm num)
        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (setq datlst nil)
        (setq blkhnd (ssname sset itm))
        (setq blkent (entget blkhnd))
        (setq nxthnd blkhnd)
        (setq nxtent blkent)
        ;
        (while (/= "SEQEND" (cdr (assoc 0 nxtent)))
          (setq nxthnd (entnext nxthnd))
          (setq nxtent (entget nxthnd))
          (if (= (cdr (assoc 0 nxtent)) "ATTRIB")
            (progn
              (setq attval (cdr (assoc 1 nxtent)))
              (setq atttag (cdr (assoc 2 nxtent)))
              (setq datlst (append datlst (list (list atttag attval))))
            )
          )
        )
        (setq eedlst nil)
        (foreach itm datlst
          (setq eedtyp "Character")
          (setq atttag (car itm))
          (setq attval (cadr itm))
          (foreach chk attlst
            (if (= (car chk) atttag)
              (setq eedtyp (cadr chk))
            )
          )
          (if (= eedtyp "Numeric")
            (setq atttag (strcat "#" atttag))
          )
          (setq eedstr (strcat atttag "=" attval))
          (setq eedlin (cons 1000 eedstr))
          (setq eedlst (append eedlst (list eedlin)))
        )
        (setq eedtot (cons -3 (list (cons "ADE" (append (list (cons 1002 '"{")) eedlst (list (cons 1002 '"}")))))))
        ;
        (setq newblk '((0 . "INSERT")(66 . 0)))
        (setq dolst (list 2 8 10 41 42 43 50 70 71 44 45))
        (foreach grp dolst
          (setq addto (assoc grp blkent))
          (if (/= addto nil)
            (setq newblk (append newblk (list (assoc grp blkent))))
          )
        )
        (setq newblk (append newblk (list eedtot)))
        (entdel blkhnd)
        (entmake newblk) 
        (setq itm (1+ itm))
      )
      (princ ", Done.")
    )
  )
  ;
  (setq tmp nil)
  (setq reslst nil)
  (setq attlst nil)
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                        Draw Revision Cloud
; --------------------------------------------------------------------------

(defun c:LegDrwClo ( / chdang chdlen chk cls cmdecho cnt dis done fpt hnd
                         hwp imp lpt lst new osmode pnt rep tmp)
  (setq chdang (atof (dstp_regfetch "RevCloud" "chdang" "120.0")))
  (if (= (getvar "FILLETRAD") 0.0)
    (setq chdlen (dstp_textsize))
    (setq chdlen (getvar "FILLETRAD"))
  )
  (setq chdlen (distof (dstp_regfetch "RevCloud" "chdlen" (rtos chdlen))))
  (princ (strcat "\nDS> Chord Length: " (rtos chdlen) "  Angle: " (rtos chdang 2 1)))
  (setq done nil)
  (while (/= done T)
    (initget "A L O")
    (setq tmp (getpoint "\nDS> Angle/Length/Object/<Initial Point>: "))
    (cond 
      ((= tmp "A")
        (princ "\nDS> *** Use Negative Angle for Clockwise Movement ***")
        (setq tmp (getreal (strcat "\nDS> Included Angle <" (rtos chdang 2 1) ">: ")))
        (if (/= tmp nil)
          (progn
            (setq chdang tmp)
            (dstp_regstore "RevCloud" "chdang" (rtos chdang 2 1))
          )
        )
      )
      ((= tmp "L")
        (setq tmp (getdist (strcat "\nDS> Chord Length <" (rtos chdlen) ">: ")))
        (if (/= tmp nil)
          (progn
            (setq chdlen tmp)
            (dstp_regstore "RevCloud" "chdlen" (rtos chdlen 2 4))
          )
        )
      )
      ((= tmp "O")
        (setq tmp (entsel "\nDS> Select Object for Path: "))
        (if (/= tmp nil)
          (progn
            (setq hnd (car tmp))
            (setq lst (dstp_obj2lst hnd))
            (if (= lst nil)
              (alert "Object Not Supported!")
              (progn
                (setq cls (vlax-curve-isClosed (vlax-ename->vla-object hnd)))
                (if (= cls T)
                  (setq lst (append lst (list (car lst))))
                )
                (setq lpt (car lst))
                (setq new (list lpt))
                (foreach pnt (cdr lst)
                  (if (< (distance lpt pnt) chdlen)
                    (progn
                      (setq hwp (polar lpt (angle lpt pnt) (/ (distance lpt pnt) 2.0)))
                      (setq new (append new (list hwp)))
                      (setq new (append new (list pnt)))
                    )
                    (progn
                      (setq dis 0.0)
                      (setq rep (fix (/ (distance lpt pnt) (/ chdlen 10.0))))
                      (repeat rep
                        (setq dis (+ dis (/ chdlen 10.0)))
                        (setq imp (polar lpt (angle lpt pnt) dis))
                        (setq new (append new (list imp)))
                      )
                      (setq new (append new (list pnt)))
                    )
                  )
                  (setq lpt pnt)
                )
                (setq lst new new nil)
                ;
                (setq cnt 0)
                (setq lpt (car lst))
                (setq  fpt lpt)
                (setq osmode (getvar "OSMODE"))
                (setvar "OSMODE" 0)
                (setq cmdecho (getvar "CMDECHO"))
                (setvar "CMDECHO" 0)
                (command "_.UNDO" "_G")
                (dstp_ucspush)
                (command "_.PLINE" lpt "_A" "_A" chdang)
                (foreach pnt lst
                  (if (> cnt 2)
                    (progn
                      (setq dis (distance pnt lpt))
                      (if (>= dis chdlen)
                        (progn
                          (command pnt)
                          (command "_A" chdang)
                          (setq lpt pnt)
                        )
                      )
                    )
                  )
                  (setq cnt (1+ cnt))
                )
                (if (= cls T)
                  (progn
                    (command fpt)
                    (command "CL")
                  )
                  (progn
                    (command (last lst))
                    (command "")
                  )
                )
                (dstp_ucspop)
                (command "_.UNDO" "_E")
                (setvar "CMDECHO" cmdecho)
                (setvar "OSMODE" osmode)
                (setq done T)
              )
            )
          )
        )
      )
      (t
        (if (= (type tmp) 'LIST)
          (progn
            (setq cnt 0)
            (setq lpt tmp)
            (setq  fpt lpt)
            (setq osmode (getvar "OSMODE"))
            (setvar "OSMODE" 0)
            (setq cmdecho (getvar "CMDECHO"))
            (setvar "CMDECHO" 0)
            (command "_.UNDO" "_G")
            (dstp_ucspush)
            (command "_.PLINE" lpt "_A" "_A" chdang)
            (princ "\nDS> Move Crosshair in Cloud Direction ...")
            (setq done nil)
            (while (/= done T)
              (setq chk (grread (quote T)))
              (setq pnt (cadr chk))
              (cond 
                ((= (car chk) 3)
                  (command pnt)
                  (command "")
                  (setq done T)
                )
                ((= (car chk) 5)
                  (if (and (> cnt 2)(<= (distance pnt fpt) chdlen))
                    (progn ; time to close
                      (command pnt)
                      (command "_A" chdang)
                      (command fpt)
                      (command "_CL")
                      (setq done T)
                    )
                    (progn ; keep going
                      (setq dis (distance pnt lpt))
                      (if (>= dis chdlen)
                        (progn
                          (command pnt)
                          (command "_A" chdang)
                          (setq lpt pnt)
                          (setq cnt (1+ cnt))
                        )
                      )
                    )
                  )
                )
                (t nil)
              )
            )
            (dstp_ucspop)
            (command "_.UNDO" "_E")
            (setvar "CMDECHO" cmdecho)
            (setvar "OSMODE" osmode)
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                                Draw Profile
; --------------------------------------------------------------------------

(defun c:LegDrwPro ( / cdis chk clayer cmdecho ctr cut dcl_id done elv ent
                       fpnt gen3dp grddrw grdint grdlin hnd ignor0 ilst
                       labdec laygrd laypro llx lly lpnt lpt ndis new nxc
                       nxtent nxthnd nyc obj osmode oxc oyc p1 p2 pnt prc
                       prlst ptlst pxc pyc siz solst spt sta sxc syc tic
                       tmp urx ury xc xval yc yval)
  (defun profile_sellaypro ()
    (setq tmp (dstp_tablesel "Select Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
    (if (/= tmp nil)
      (progn
        (setq laypro tmp)
        (set_tile "laypro" laypro)
      )
    )
  )
  (defun profile_sellaygrd ()
    (setq tmp (dstp_tablesel "Select Layer" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
    (if (/= tmp nil)
      (progn
        (setq laygrd tmp)
        (set_tile "laygrd" laygrd)
      )
    )
  )
  (defun profile_setflds ()
    (set_tile "ignor0" ignor0)
    (set_tile "gen3dp" gen3dp)
    (set_tile "laypro" laypro)
    (set_tile "laygrd" laygrd)
    (set_tile "grddrw" grddrw)
    (set_tile "grdlin" grdlin)
    (set_tile "grdint" grdint)
    (set_tile "labdec" labdec)
  )
  (defun profile_getflds ()
    (setq ignor0 (get_tile "ignor0"))
    (setq gen3dp (get_tile "gen3dp"))
    (setq laypro (get_tile "laypro"))
    (setq laygrd (get_tile "laygrd"))
    (setq grddrw (get_tile "grddrw"))
    (setq grdlin (get_tile "grdlin"))
    (setq grdint (get_tile "grdint"))
    (setq labdec (get_tile "labdec"))
    (dstp_regstore "Profile" "ignor0" ignor0)
    (dstp_regstore "Profile" "gen3dp" gen3dp)
    (dstp_regstore "Profile" "laypro" laypro)
    (dstp_regstore "Profile" "laygrd" laygrd)
    (dstp_regstore "Profile" "grddrw" grddrw)
    (dstp_regstore "Profile" "grdlin" grdlin)
    (dstp_regstore "Profile" "grdint" grdint)
    (dstp_regstore "Profile" "labdec" labdec)
  )
  (defun profile_doparms ()
    (if (< (setq dcl_id (load_dialog "unsupport.dcl")) 0) (exit))
    (if (not (new_dialog "profile" dcl_id)) (exit))
    (profile_setflds)
    (action_tile "selpro" "(profile_sellaypro)")
    (action_tile "selgrd" "(profile_sellaygrd)")
    (action_tile "cancel" "(done_dialog 0)")
    (action_tile "accept" "(profile_getflds)(done_dialog 1)")
    (start_dialog)
    (princ)
    (unload_dialog dcl_id)
  )
  ;
  (setq clayer (getvar "CLAYER"))
  (setq osmode (getvar "OSMODE"))
  (setvar "OSMODE" 0)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  ;
  (setq ignor0 (dstp_regfetch "Profile" "ignor0" "1"))
  (setq gen3dp (dstp_regfetch "Profile" "gen3dp" "0"))
  (setq laypro (dstp_regfetch "Profile" "laypro" ""))
  (setq laygrd (dstp_regfetch "Profile" "laygrd" ""))
  (setq grddrw (dstp_regfetch "Profile" "grddrw" "1"))
  (setq grdlin (dstp_regfetch "Profile" "grdlin" "0"))
  (setq grdint (dstp_regfetch "Profile" "grdint" "50.0"))
  (setq labdec (dstp_regfetch "Profile" "labdec" "0"))
  ;
  (setq done nil)
  (while (/= done T)
    (initget "S")
    (setq tmp (entsel "\nDS> Settings/<Select Profile Path Object>: "))
    (cond
      ((= tmp nil)
        (setq done T)
      )
      ((or (= tmp "S")(= tmp "s"))
        (profile_doparms)
      )
      (t
        (setq hnd (car tmp))
        (setq ent (entget hnd))
        (setq obj (cdr (assoc 0 ent)))
        (if (member obj (list "ARC" "CIRCLE" "LINE" "POLYLINE" "LWPOLYLINE" "SPLINE"))
          (progn
            (setq cut T)
            (setq ptlst nil)
            (if (= obj "POLYLINE")
              (if (= (boole 1 (cdr (assoc 70 ent)) 8) 8)
                (progn
                  (setq nxthnd hnd)
                  (setq done nil)
                  (while (/= done T)
                    (setq nxthnd (entnext nxthnd))
                    (setq nxtent (entget nxthnd))
                    (if (= "VERTEX" (cdr (assoc 0 nxtent)))
                      (setq ptlst (append ptlst (list (cdr (assoc 10 nxtent)))))
                    )
                    (if (= "SEQEND" (cdr (assoc 0 nxtent)))
                      (setq done T)
                    )
                  )
                  (setq cut nil)
                )
              )
            )
            ;
            (if (= cut T)
              (progn
                (setq solst (dstp_obj2lst hnd))
                (setq tmp nil)
                (foreach pnt solst
                  (setq new (list (nth 0 pnt)(nth 1 pnt) 0.0))
                  (setq tmp (append tmp (list new)))
                )
                (setq solst tmp)
                ;
                (setq prc (ssget "_F" solst))
                (if (/= prc nil)
                  (progn
                    (setq ptlst nil)
                    (setq prc (ssdel hnd prc))
                    (setq ilst (ssnamex prc))
                    (foreach rec ilst
                      (foreach itm rec
                        (cond
                          ((= (type itm) 'list)
                            (setq pnt (cadr itm))
                            (setq ptlst (append ptlst (list (list (car pnt)(cadr pnt)))))
                          )
                          (t nil)
                        )
                      )
                    )
                    ;
                    ; --- get the 3D snapped points
                    ;
                    (setq new nil)
                    (command "_UNDO" "_M")
                    (command "_ERASE" hnd "")
                    (foreach pnt ptlst
                      (setq chk (osnap pnt "_nea"))
                      (if (/= chk nil)
                        (progn
                          (if (= ignor0 "0")
                            (setq new (cons chk new))
                            (if (/= (caddr chk) 0.0)
                              (setq new (cons chk new))
                            )
                          )
                        )
                      )
                    )
                    (command "_UNDO" "_B")
                    (setq ptlst new new nil)
                    ;
                    ; --- sort from path beginning
                    ;
                    (setq new nil)
                    (setq lpnt (car solst))
                    (while (> (length ptlst) 0)
                      (setq ndis 9999999.9)
                      (foreach cpnt ptlst
                        (setq cdis (distance (dstp_2dpoint lpnt) (dstp_2dpoint cpnt)))
                        (if (< cdis ndis)
                          (setq fpnt cpnt ndis cdis)
                        )
                      )
                      (setq lpnt fpnt)
                      (setq new (append new (list fpnt)))
                      (setq ptlst (dstp_remove fpnt ptlst))
                    )
                    (setq ptlst new new nil)
                    (if (= gen3dp "1")
                      (progn
                        (command "_.3DPOLY")
                        (foreach pnt ptlst
                          (command pnt)
                        )
                        (command "")
                      )
                    )
                  )
                )
              )
            )
            ;
            (if (/= ptlst nil)
              (progn
                ;
                ; --- from points to sta/elev
                ;
                (setq ctr 0)
                (if (= solst nil)
                   (setq sta 0.0)
                   (setq sta (distance (dstp_2dpoint (car solst))(dstp_2dpoint (car ptlst))))
                )
                (setq elv (nth 2 (car ptlst)))
                (setq prlst (list (list sta elv)))
                (foreach cpt ptlst
                  (setq xval (nth 0 cpt))
                  (setq yval (nth 1 cpt))
                  (setq elv (nth 2 cpt))
                  (if (> ctr 0)
                    (progn
                      (setq sta (+ sta (distance (dstp_2dpoint lpt)(dstp_2dpoint cpt))))
                      (setq prlst (append prlst (list (list sta elv))))
                    )
                  )
                  (setq lpt cpt)
                  (setq ctr (1+ ctr))
                )
                ;
                ; --- draw profile
                ;
                (setq spt (getpoint "\nDS> Starting Point for Profile: "))
                (setq sxc (car spt))
                (setq syc (cadr spt))
                (setq oxc (car (car prlst)))
                (setq oyc (cadr (car prlst)))
                (if (= grddrw "1")
                  (progn
                    (setq oxc (dstp_roundoff oxc -1 (atof grdint)))
                    (setq oyc (dstp_roundoff oyc -1 (atof grdint)))
                  )
                )
                ;
                (if (/= laypro "")
                  (command "_.LAYER" "_M" laypro "")
                )
                (command "_.PLINE")
                (foreach pnt prlst
                  (setq pxc (car pnt))
                  (setq pyc (cadr pnt))
                  (setq nxc (+ sxc (- pxc oxc)))
                  (setq nyc (+ syc (- pyc oyc)))
                  (setq pnt (list nxc nyc))
                  (command pnt)
                )
                (command "")
                (setvar "CLAYER" clayer)
                ;
                ; --- draw profile grid?
                ;
                (if (= grddrw "1")
                  (progn
                    (if (/= laygrd "")
                      (command "_.LAYER" "_M" laygrd "")
                    )
                    (setq siz (dstp_textsize))
                    (setq tic (* siz 0.75))
                    (setq llx (dstp_roundoff (car (car prlst)) -1 (atof grdint)))
                    (setq lly (dstp_roundoff (cadr (car prlst)) -1 (atof grdint)))
                    (setq urx (dstp_roundoff (car (last prlst)) 1 (atof grdint)))
                    (setq ury (dstp_roundoff (cadr (last prlst)) 1 (atof grdint)))
                    ;
                    (setq xc llx)           ; tics/text across bottom
                    (while (<= xc urx)
                      (setq pxc xc)
                      (setq pyc lly)
                      (setq nxc (+ sxc (- pxc oxc)))
                      (setq nyc (+ syc (- pyc oyc)))
                      (setq p1 (list nxc nyc))
                      (setq p2 (list nxc (- nyc tic)))
                      (command "_.LINE" p1 p2 "")
                      (setq p1 (list nxc (- nyc (* siz 2.25))))
                      (dstp_maketext "C" p1 siz 0.0 (rtos xc 2 (atoi labdec)))
                      (setq xc (+ xc (atof grdint)))
                    )
                    ;
                    (setq yc lly)           ; tics/text up left side
                    (while (<= yc ury)
                      (setq pxc llx)
                      (setq pyc yc)
                      (setq nxc (+ sxc (- pxc oxc)))
                      (setq nyc (+ syc (- pyc oyc)))
                      (setq p1 (list nxc nyc))
                      (setq p2 (list (- nxc tic) nyc))
                      (command "_.LINE" p1 p2 "")
                      (setq p1 (list (- nxc (* siz 1.25)) nyc))
                      (dstp_maketext "MR" p1 siz 0.0 (rtos yc 2 (atoi labdec)))
                      (setq yc (+ yc (atof grdint)))
                    )
                    ;
                    (if (= grdlin "0")
                      (progn
                        (setq nxc (+ sxc (- llx oxc)))
                        (setq nyc (+ syc (- lly oyc)))
                        (setq p1 (list nxc nyc))
                        (setq p2 (list (+ nxc (- urx llx)) nyc))
                        (command "_.LINE" p1 p2 "")
                        (setq nxc (+ sxc (- llx oxc)))
                        (setq nyc (+ syc (- lly oyc)))
                        (setq p1 (list nxc nyc))
                        (setq p2 (list nxc (+ nyc (- ury lly))))
                        (command "_.LINE" p1 p2 "")
                      )
                      (progn
                        (setq xc llx)           ; vertical lines
                        (while (<= xc urx)
                          (setq pxc xc)
                          (setq pyc lly)
                          (setq nxc (+ sxc (- pxc oxc)))
                          (setq nyc (+ syc (- pyc oyc)))
                          (setq p1 (list nxc nyc))
                          (setq p2 (list nxc (+ nyc (- ury lly))))
                          (command "_.LINE" p1 p2 "")
                          (setq xc (+ xc (atof grdint)))
                        )
                        ;
                        (setq yc lly)           ; horizontal lines
                        (while (<= yc ury)
                          (setq pxc llx)
                          (setq pyc yc)
                          (setq nxc (+ sxc (- pxc oxc)))
                          (setq nyc (+ syc (- pyc oyc)))
                          (setq p1 (list nxc nyc))
                          (setq p2 (list (+ nxc (- urx llx)) nyc))
                          (command "_.LINE" p1 p2 "")
                          (setq yc (+ yc (atof grdint)))
                        )
                      )
                    )
                    (setvar "CLAYER" clayer)
                  )
                )
                (setq done T)
              )
              (princ "\nDS> Incomplete Profile Information!")
            )
          )
          (princ "\nDS> Cannot profile from that object!")
        )
      )
    )
  )
  ;
  (setq ilst nil)
  (setq ptlst nil)
  (setq solst nil)
  (setq prlst nil)
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (setvar "OSMODE" osmode)
  (setvar "CLAYER" clayer)
  (princ)
)

; ---------------------------------------------------------------------------
;                          3-Point Rotated Rectangle
; ---------------------------------------------------------------------------

(defun c:LegDrwRec ( / pt1 pt2 pt3 str ulc lrc urc hd1 hd2 dis chk fnd
                       blipmode cmdecho ent lr1 lr2 lst osmode pnt pts
                       ss1 ss2 ul1 ul2 ur1 ur2)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq osmode (getvar "OSMODE"))
  (setvar "OSMODE" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  ;
  (princ "\nDS> Pick 3 points that form an L shape ...")
  (setq pt1 (dstp_2dpoint (getpoint "\nDS> Pick 1st Point: ")))
  (setq pt2 (dstp_2dpoint (getpoint pt1 "\nDS> Pick 2nd Point: ")))
  (grdraw pt1 pt2 -1)
  (setq pt3 (dstp_2dpoint (getpoint pt2 "\nDS> Pick 3rd Point: ")))
  (grdraw pt1 pt2 -1)
  (setq str "DS> Determining best solution ...")
  (princ (strcat "\n" str "\r" str))
  ;
  (setq blipmode (getvar "BLIPMODE"))
  (setvar "BLIPMODE" 0)
  (setq ss1 (ssadd))
  (setq ul1 (list (car pt1) (+ (cadr pt1) (distance pt2 pt3))))
  (setq lr1 (list (+ (car pt1) (distance pt1 pt2)) (cadr pt1)))
  (setq ur1 (list (+ (car pt1) (distance pt1 pt2)) (+ (cadr pt1) (distance pt2 pt3))))
  (command "_.POINT" pt1)
  (setq ss1 (ssadd (entlast) ss1))
  (command "_.POINT" lr1)
  (setq ss1 (ssadd (entlast) ss1))
  (command "_.POINT" ur1)
  (setq ss1 (ssadd (entlast) ss1))
  (command "_.POINT" ul1)
  (setq ss1 (ssadd (entlast) ss1))
  (command "_.ROTATE" ss1 "" pt1 "_R" pt1 ur1 pt3)
  ;  
  (setq ss2 (ssadd))
  (setq ul2 (list (car pt1) (+ (cadr pt1) (distance pt1 pt2))))
  (setq lr2 (list (+ (car pt1) (distance pt2 pt3)) (cadr pt1)))
  (setq ur2 (list (+ (car pt1) (distance pt2 pt3)) (+ (cadr pt1) (distance pt1 pt2))))
  (command "_.POINT" pt1)
  (setq ss2 (ssadd (entlast) ss2))
  (command "_.POINT" lr2)
  (setq ss2 (ssadd (entlast) ss2))
  (command "_.POINT" ur2)
  (setq ss2 (ssadd (entlast) ss2))
  (command "_.POINT" ul2)
  (setq ss2 (ssadd (entlast) ss2))
  (command "_.ROTATE" ss2 "" pt1 "_R" pt1 ur2 pt3)
  (setvar "BLIPMODE" blipmode)
  ;
  (setq pts nil)
  (setq dis 999999999999.99)
  (setq lst (dstp_ss2lst ss1))
  (foreach hnd lst
    (setq ent (entget hnd))
    (setq pnt (cdr (assoc 10 ent)))
    (setq pts (append pts (list pnt)))
    (setq chk (distance pt2 (dstp_2dpoint pnt)))
    (if (< chk dis)
      (setq dis chk fnd 1)
    )
  )
  (setq lst (dstp_ss2lst ss2))
  (foreach hnd lst
    (setq ent (entget hnd))
    (setq pnt (cdr (assoc 10 ent)))
    (setq pts (append pts (list pnt)))
    (setq chk (distance pt2 (dstp_2dpoint pnt)))
    (if (< chk dis)
      (setq dis chk fnd 2)
    )
  )
  ;
  (command "_.ERASE" ss1 ss2 "")
  (if (= fnd 1)
    (command "_.PLINE" (nth 0 pts)(nth 1 pts)(nth 2 pts)(nth 3 pts) "_C")
    (command "_.PLINE" (nth 4 pts)(nth 5 pts)(nth 6 pts)(nth 7 pts) "_C")
  )
  (princ " Done.")
  ;
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "OSMODE" osmode)
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                         Drill Schedule/Hole Table
; --------------------------------------------------------------------------

(defun c:LegDrwSch (/ chk cmdecho cntr1st colcnt datlst doproc ent g10
                         hnd horzpad itm lst new num pnt rad rowcnt sset
                         str texthgt tmp txt val vertpad xcd ycd)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (initget "Y N")
  (setq tmp (getkword "\nDS> Circles Contain Text ID's <Y>/N: "))
  (if (/= tmp "N")(setq txt T)(setq txt nil))
  (initget "R D")
  (setq tmp (getkword "\nDS> Label <Radius>/Diameter: "))
  (if (/= tmp "D")(setq rad T)(setq rad nil))
  (setq sset (ssget '((0 . "CIRCLE"))))
  (if sset
    (progn
      (setq num (sslength sset) itm 0)
      (setq lst nil)
      (princ "\nDS>")
      (while (< itm num)
        (princ (strcat "\rDS> Evaluating Circle " (itoa (1+ itm)) " of " (itoa num)))
        (setq hnd (ssname sset itm))
        (setq ent (entget hnd))
        (setq g10 (cdr (assoc 10 ent)))
        (setq xcd (car g10))
        (setq ycd (cadr g10))
        (setq val (cdr (assoc 40 ent)))
        (if (= rad nil)
           (setq val (* val 2.0))
        )
        (if (= txt T)
          (progn
            (setq chk (dstp_obj2lst hnd))
            (setq tmp (ssget "_WP" chk '((0 . "TEXT"))))
            (if tmp
              (setq str (cdr (assoc 1 (entget (ssname tmp 0)))))
              (setq str "?")
            )
            (setq lst (append lst (list (list xcd ycd val str))))
          )
          (setq lst (append lst (list (list xcd ycd val))))
        )
        (setq itm (1+ itm))
      )
      (if (/= lst nil)
        (progn
          (setq datlst nil)
          (if (= rad T)
            (setq str "Radius")
            (setq str "Diameter")
          )
          (if (= txt T)
            (setq new (list "ID" "X-Value" "Y-Value" str))
            (setq new (list "X-Value" "Y-Value" str))
          )
          (setq datlst (append datlst (list new)))
          (foreach rec lst
            (setq xcd (nth 0 rec))
            (setq ycd (nth 1 rec))
            (setq val (nth 2 rec))
            (if (= txt T)
              (progn
                (setq str (nth 3 rec))
                (setq new (list str (rtos xcd) (rtos ycd) (rtos val)))
              )
              (setq new (list (rtos xcd) (rtos ycd) (rtos val)))
            )
            (setq datlst (append datlst (list new)))
          )
          (dstp_tbloutput datlst)
          (setq lst nil)
        )
      )
    )
  )
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                                 Draw Slot
; --------------------------------------------------------------------------

(defun c:LegDrwSlt (/  chk  cmdecho  hgt mth  osmode pt1 pt2 pt3 pt4 pt5 pt6 rad wid)
  (setq mth (atoi (dstp_regfetch "Draw" "slotmeth" "1")))
  (cond
    ((= mth 1)
     (initget "R C")
     (setq chk (getkword "\nDS> Input by Rectangle/<Center>: "))
     (if (= chk "R")
       (setq mth 2)
     )
    )
    ((= mth 2)
     (initget "R C")
     (setq chk (getkword "\nDS> Input by Center/<Rectangle>: "))
     (if (= chk "C")
       (setq mth 1)
     )
    )
    (t nil)
  )
  (dstp_regstore "Draw" "slotmeth" (itoa mth))
  (cond
    ((= mth 1)
     (setq pt1 (getpoint "\nDS> First Center Point: "))
     (if (/= pt1 nil)
       (progn
         (setq pt2 (getpoint pt1 "\nDS> Second Center Point: "))
         (if (/= pt2 nil)
           (progn
             (grdraw pt1 pt2 -1 -1)
             (setq rad (getdist pt1 "\nDS> Slot Halfwidth/Radius: "))
             (grdraw pt1 pt2 -1 -1)
             (if (/= rad nil)
               (progn
                 (setq pt3
                        (polar pt1 (+ (angle pt1 pt2) pi (/ pi 2.0)) rad)
                 )
                 (setq pt4
                        (polar pt2 (+ (angle pt1 pt2) pi (/ pi 2.0)) rad)
                 )
                 (setq pt5
                        (polar pt2 (+ (angle pt2 pt1) pi (/ pi 2.0)) rad)
                 )
                 (setq pt6
                        (polar pt1 (+ (angle pt2 pt1) pi (/ pi 2.0)) rad)
                 )
                 (setq cmdecho (getvar "CMDECHO"))
                 (setvar "CMDECHO" 0)
                 (setq osmode (getvar "OSMODE"))
                 (setvar "OSMODE" 0)
                 (command "_.UNDO" "_G")
                 (dstp_ucspush)
                 (command  "_.PLINE"  pt3  pt4  "_A" pt5 "_L"  pt6  "_A" "_CL")
                 (dstp_ucspop)
                 (command "_.UNDO" "_E")
                 (setvar "OSMODE" osmode)
                 (setvar "CMDECHO" cmdecho)
               )
             )
           )
         )
       )
     )
    )
    ((= mth 2)
     (setq pt1 (getpoint "\nDS> First Corner: "))
     (if (/= pt1 nil)
       (progn
         (setq pt2 (getcorner pt1 "\nDS> Other Corner: "))
         (if (/= pt2 nil)
           (progn
             (setq wid (- (car pt2) (car pt1)))
             (setq hgt (- (cadr pt2) (cadr pt1)))
             (setq pt3 (polar pt1 0 (/ hgt 2.0)))
             (setq pt4 (polar pt3 0 (- wid hgt)))
             (setq pt5 (polar pt4 (/ pi 2.0) hgt))
             (setq pt6 (polar pt5 pi (- wid hgt)))
             (setq cmdecho (getvar "CMDECHO"))
             (setvar "CMDECHO" 0)
             (setq osmode (getvar "OSMODE"))
             (setvar "OSMODE" 0)
             (command "_.UNDO" "_G")
             (dstp_ucspush)
             (command "_.PLINE" pt3 pt4 "_A" pt5 "_L" pt6 "_A" "_CL")
             (dstp_ucspop)
             (command "_.UNDO" "_E")
             (setvar "OSMODE" osmode)
             (setvar "CMDECHO" cmdecho)
           )
         )
       )
     )
    )
    (t nil)
  )
  (princ)
)

; --------------------------------------------------------------------------
;                       Convert Full Justified Text
; --------------------------------------------------------------------------

(defun c:LegFulMtx ( / ang axo chk cmdecho cnt ent hnd isf itm lst new num
                       rot siz sset stp str sty tot wid)
  (princ "\nDS> Select MTEXT or Full Justified Text ...")
  (setq sset (ssget '((0 . "INSERT")(-3 ("DSTP_TXTFULJST")))))
  (if sset
    (progn
      (setq itm 0)
      (setq num (sslength sset))
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (princ "\nDS>")
      (while (< itm num)
        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (setq hnd (ssname sset itm))
        (setq ent (entget hnd '("DSTP_TXTFULJST")))
        (setq chk (assoc -3 ent))
        (setq lst (cdr (nth 0 (cdr chk))))
        ;
        (setq ang (cdr (nth 0 lst)))
        (setq wid (cdr (nth 1 lst)))
        (setq sty (cdr (nth 2 lst)))
        (setq siz (cdr (nth 3 lst)))
        (setq isf (cdr (nth 4 lst)))
        (setq tot (cdr (nth 5 lst)))
        (setq cnt 0)
        (setq str "")
        (repeat tot
          (setq chk (cdr (nth (+ 6 cnt) lst)))
          (setq str (strcat str chk))
          (setq cnt (1+ cnt))
        ) 
        (setq stp (cdr (assoc 10 ent)))
        (setq rot (cdr (assoc 50 ent)))
        (if (/= rot 0.0)
          (setq ang (+ ang rot))
        )
        (setq str (dstp_subtext str "\r\n" "\\P"))
        (setq new '((0 . "MTEXT")(100 . "AcDbEntity")(100 . "AcDbMText")))
        (setq new (append new (list (cons 7 sty))))
        (setq new (append new (list (cons 8 (cdr (assoc 8 ent))))))
        (setq new (append new (list (cons 10 stp))))
        (setq new (append new (list (cons 1 "TEMP"))))
        (setq new (append new (list (cons 40 siz))))
        (setq new (append new (list (cons 41 wid))))
        (setq new (append new (list (cons 50 ang))))
        (if (/= (assoc 62 ent) nil)
          (setq new (append new (list (cons 62 (cdr (assoc 62 ent))))))
        )
        (entdel hnd)
        (entmake new)
        ;
        (setq hnd (entlast))
        (setq axo (vlax-ename->vla-object hnd))
        (vla-put-textstring axo str)
        (vlax-release-object axo)
        ;         
        (setq itm (1+ itm))
      )
      (princ ", Done.")
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Erase Frozen+Off Layers
; --------------------------------------------------------------------------

(defun c:LegLayInv ( / cmdecho del lc ln ls lst lt sset)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  ;
  (princ "\nDS> Evaluating Invisible Layers ...\r")
  (setq lt (tblnext "LAYER" T))
  (while (/= lt nil)
    (setq ln (cdr (assoc 2 lt)))
    (setq lc (cdr (assoc 62 lt)))
    (setq ls (cdr (assoc 70 lt)))
    (setq lt (tblnext "LAYER"))
    (setq del nil)
    (if (= (boole 1 (- ls 64) 1) 1)
      (setq del T)
    )
    (if (< lc 0)
      (setq del T)
    )
    (if (= del T)
      (progn
        (setq sset (ssget "_X" (list (cons 8 ln))))
        (if (/= sset nil)
          (progn
            (setq lst (dstp_ss2lst sset))
            (foreach hnd lst
              (entdel hnd)
            )
          )
        )
      )
    )
  )
  (setq sset nil)
  (princ "DS> Evaluating Invisible Layers ... Done.\n")
  (if (< (getvar "EXPERT") 5)
    (alert "Warning: All objects in frozen or off layers\nhave been removed, use undo to restore.\nIf these layers were locked the geometry\ncould not be removed.\n\nThaw frozen layers and use PURGE to\nremove layer names.")
  )
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                        Layout to Separate Files
; --------------------------------------------------------------------------

(defun c:LegLyoSav ( / $value acd ang attreq axo bnd bndhnd bndpts cen chk
                          cmdecho ctr cvhgt cvscl cvsiz dat dcl_id del doc
                          doproc ent eov fh frz g340 hgt hnd inc itm layouts
                          lc let ll llc llp llt ln lrc lrp lrt ls lst lt mrk
                          msctr mset nam new nset num obj ofs ofspts optitm
                          org osmode out pass path pik plinewid prj prolst
                          psctr psrot ptlst pur rec refpnt reg rep resitm
                          resp srclst srcsel sset str tmp uct ulc ulp ult urc
                          urp urt vers vid vpi vpl vptfrz vset wid xrfdat
                          xrffrz xyd)
  (if (= (car (dstp_isvalid)) T)
    (progn
      (if (= (getvar "DBMOD") 0)
        (progn
          (setq org (strcat (getvar "DWGPREFIX")(getvar "DWGNAME")))
          (setq path (dstp_regfetch "Layout" "filepath" (getvar "TEMPPREFIX")))
          (setq vers (dstp_regfetch "Layout" "filevers" "2000"))
          (setq chk (dstp_regfetch "Layout" "doerase" "False"))
          (if (= chk "False")(setq eov nil)(setq eov T))
          (setq chk (dstp_regfetch "Layout" "dopurge" "False"))
          (if (= chk "False")(setq pur nil)(setq pur T))
          (setq chk (dstp_regfetch "Layout" "dofreeze" "False"))
          (if (= chk "False")(setq frz nil)(setq frz T))
          (setq chk (dstp_regfetch "Layout" "dobind" "False"))
          (if (= chk "False")(setq bnd nil)(setq bnd T))
          (setq chk (dstp_regfetch "Layout" "doproj" "False"))
          (if (= chk "False")(setq prj nil)(setq prj T))
          (setq acd (vlax-get-acad-object))
          (setq doc (vla-get-activedocument acd))
          (setq layouts (vla-get-layouts doc))
          (setq srclst nil)
          (vlax-for itm layouts
            (setq nam (vla-get-name itm))
            (setq srclst (cons nam srclst))
          )
          (setq srclst (dstp_remove "Model" srclst))
          (setq srclst (acad_strlsort srclst))
          (setq srcsel "")
          (setq dcl_id (load_dialog "unsupport.dcl"))
          (if (not (new_dialog "lyosavfil" dcl_id)) (exit))
          (cond
            ((= (atoi (getvar "ACADVER")) 17)
              (mode_tile "savr13" 1)
              (mode_tile "savr14" 1)
              (mode_tile "sava10" 1)
              (mode_tile "sava13" 1)
            )
            ((= (atoi (getvar "ACADVER")) 18)
              (mode_tile "savr13" 1)
              (mode_tile "savr14" 1)
              (mode_tile "sava13" 1)
            )
            ((= (atoi (getvar "ACADVER")) 19)
              (mode_tile "savr13" 1)
            )
          )
          (start_list "srclst")
          (mapcar 'add_list srclst)
          (end_list)
          (cond
            ((= vers "R12")(set_tile "savr12" "1"))
            ((= vers "R13")(set_tile "savr13" "1"))
            ((= vers "R14")(set_tile "savr14" "1"))
            ((= vers "2000")(set_tile "sava00" "1"))
            ((= vers "2004")(set_tile "sava04" "1"))
            ((= vers "2007")(set_tile "sava07" "1"))
            ((= vers "2010")(set_tile "sava10" "1"))
          )
          (if (= eov T)
            (set_tile "opteov" "1")
            (set_tile "opteov" "0")
          )
          (if (= pur T)
            (set_tile "optpur" "1")
            (set_tile "optpur" "0")
          )
          (if (= frz T)
            (set_tile "optfrz" "1")
            (set_tile "optfrz" "0")
          )
          (if (= bnd T)
            (set_tile "optbnd" "1")
            (set_tile "optbnd" "0")
          )
          (if (= prj T)
            (set_tile "optprj" "1")
            (set_tile "optprj" "0")
          )
          (set_tile "outpth" path)
          (action_tile "srclst" "(setq srcsel $value)")
          (action_tile "savr12" "(setq vers \"R12\")")
          (action_tile "savr13" "(setq vers \"R13\")")
          (action_tile "savr14" "(setq vers \"R14\")")
          (action_tile "sava00" "(setq vers \"2000\")")
          (action_tile "sava04" "(setq vers \"2004\")")
          (action_tile "sava07" "(setq vers \"2007\")")
          (action_tile "sava10" "(setq vers \"2010\")")
          (action_tile "opteov" "(if (= $value \"1\")(setq eov T)(setq eov nil))")
          (action_tile "optpur" "(if (= $value \"1\")(setq pur T)(setq pur nil))")
          (action_tile "optfrz" "(if (= $value \"1\")(setq frz T)(setq frz nil))")
          (action_tile "optbnd" "(if (= $value \"1\")(setq bnd T)(setq bnd nil))")
          (action_tile "optprj" "(if (= $value \"1\")(setq prj T)(setq prj nil))")
          (action_tile "outpth" "(setq path $value)")
          (action_tile "selpth" "(setq chk (dstp_getfolder \"Select Target Folder\" nil))(if (/= chk \"\")(progn (setq path chk)(set_tile \"outpth\" path)))")
          (action_tile "accept" "(if (= srcsel \"\")(alert \"No Source Layouts Selected\")(progn (setq doproc T)(done_dialog 0)))")
          (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
          (if (equal (start_dialog) 1)
            (unload_dialog dcl_id)
          )
          (if (= doproc T)
            (progn
              (if (/= (substr path (strlen path) 1) (chr 92))
                (setq path (strcat path (chr 92)))
              )
              (dstp_regstore "Layout" "filepath" path)
              (dstp_regstore "Layout" "filevers" vers)
              (if (= eov T)
                (dstp_regstore "Layout" "doerase" "True")
                (dstp_regstore "Layout" "doerase" "False")
              )
              (if (= pur T)
                (dstp_regstore "Layout" "dopurge" "True")
                (dstp_regstore "Layout" "dopurge" "False")
              )
              (if (= frz T)
                (dstp_regstore "Layout" "dofreeze" "True")
                (dstp_regstore "Layout" "dofreeze" "False")
              )
              (if (= bnd T)
                (dstp_regstore "Layout" "dobind" "True")
                (dstp_regstore "Layout" "dobind" "False")
              )
              (if (= prj T)
                (dstp_regstore "Layout" "doproj" "True")
                (dstp_regstore "Layout" "doproj" "False")
              )
              (setq uct 1)
              (setq prolst nil)
              (while (setq optitm (read srcsel))
                (setq resitm (nth optitm srclst))
                (setq prolst (append prolst (list resitm)))
                (while (and (/= " " (substr srcsel uct 1))
                  (/= "" (substr srcsel uct 1)))
                  (setq uct (1+ uct))
                )
                (setq srcsel (substr srcsel uct))
              )
              (setq osmode (getvar "OSMODE"))
              (setvar "OSMODE" 0)
              (setq cmdecho (getvar "CMDECHO"))
              (setvar "CMDECHO" 0)
              (setq plinewid (getvar "PLINEWID"))
              (setvar "PLINEWID" 0.00)
              (setq angbase (getvar "ANGBASE"))
              (setvar "ANGBASE" 0)
              (setq angdir (getvar "ANGDIR"))
              (setvar "ANGDIR" 0)
              (foreach lay prolst
                (if (/= vers "R12")
                  (setq out (strcat path lay ".dwg"))
                  (setq out (strcat path lay ".dxf"))
                )
                (if (findfile out)
                  (vl-file-delete out)
                )
                (command "_.UNDO" "_M")
                (command "_.LAYER" "_U" "_*" "_T" "0" "S" "0" "")
                (if (= bnd T)
                  (progn
                    (dstp_prompt "DS> Bind Inserting Xrefs ... ")
                    ;
                    ; --- collect frozen in viewport info for later
                    ;
                    (setq vptfrz nil)
                    (command "_.PSPACE")
                    (setq vset (ssget "X" '((0 . "VIEWPORT"))))
                    (if (/= vset nil)
                      (progn
                        (setq num (sslength vset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname vset itm))
                          (setq ent (entget hnd '("ACAD")))
                          (setq vid (cdr (assoc 69 ent)))
                          (if (> vid 1)
                            (progn
                              (setq dat (car (cdr (assoc -3 ent))))
                              (foreach rec dat
                                (if (= (type rec) 'LIST)
                                  (if (= (car rec) 1003)
                                    (progn
                                      (setq chk (cdr rec))
                                      (if (/= (tblsearch "LAYER" chk) nil)
                                        (progn
                                          (if (dstp_instr chk "|")
                                            (setq chk (strcase (cadr (dstp_pdf2lst chk "|"))))
                                          )
                                          (setq vptfrz (cons (list vid chk) vptfrz))
                                        )
                                      )
                                    )
                                  )
                                )
                              )
                            )
                          )
                          (setq itm (1+ itm))
                        )
                      )
                    )
                    (setq xrffrz nil)
                    (setq xrfdat nil)
                    (if (= frz T)
                      (progn
                        (setq lt (tblnext "LAYER" T))
                        (while (/= lt nil)
                          (setq ln (cdr (assoc 2 lt)))
                          (setq lc (cdr (assoc 62 lt)))
                          (setq ll (cdr (assoc 6 lt)))
                          (setq ls (cdr (assoc 70 lt)))
                          (setq lt (tblnext "LAYER"))
                          (setq del nil)
                          (if (= (boole 1 (- ls 64) 1) 1)
                            (setq del T)
                          )
                          (if (< lc 0)
                            (setq del T)
                          )
                          (if (dstp_instr ln "|")
                            (progn
                              (setq ln (strcase (cadr (dstp_pdf2lst ln "|"))))
                              (if (dstp_instr ll "|")
                                (setq ll (strcase (cadr (dstp_pdf2lst ll "|"))))
                                (setq ll (strcase ll))
                              )
                              (if (not (member ln xrfdat))
                                (setq xrfdat (cons (list ln lc ll) xrfdat))
                              )
                              (if (= del T)
                                (progn
                                  (if (not (member ln xrffrz))
                                    (setq xrffrz (cons ln xrffrz))
                                  )
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                    ;
                    (command "_.LAYER")
                    (foreach rec xrfdat
                      (if (not (tblsearch "LAYER" (nth 0 rec)))
                        (progn
                          (command "_N" (nth 0 rec))
                          (command "_C" (nth 1 rec) (nth 0 rec))
                          (setq chk (tblsearch "LTYPE" (nth 2 rec)))
                          (if (= chk nil)
                            (command "_LT" "Continuous" (nth 0 rec))
                            (command "_LT" (nth 2 rec) (nth 0 rec))
                          )
                        )
                      )
                    )
                    (command "")
                    (command "_.MSPACE")
                    (setq attreq (getvar "ATTREQ"))
                    (setvar "ATTREQ" 0)
                    (dstp_ucspush)
                    (setq resp (dstp_bldlst "XREF"))
                    (setq xyd nil)
                    (foreach nam resp
                      (setq sset (ssget "X" (list (cons 0 "INSERT")(cons 2 nam))))
                      (setq num (sslength sset) itm 0)
                      (setq lst nil)
                      (while (< itm num)
                        (setq hnd (ssname sset itm))
                        (setq ent (entget hnd))
                        (setq rec (list (cdr (assoc 1 (tblsearch "BLOCK" nam)))))
                        (setq rec (append rec (list (cdr (assoc 10 ent)))))
                        (setq rec (append rec (list (cdr (assoc 41 ent)))))
                        (setq rec (append rec (list (cdr (assoc 42 ent)))))
                        (setq rec (append rec (list (cdr (assoc 50 ent)))))
                        (setq lst (append lst (list rec)))
                        (setq itm (1+ itm))
                      )
                      (command "_.XREF" "_D" nam)
                      (foreach rec lst
                        (command "_.INSERT" (strcat "*" (nth 0 rec)) (nth 1 rec) (nth 2 rec) (dstp_rtd (nth 4 rec)))
                        (if (/= (nth 2 rec)(nth 3 rec))
                          (setq xyd T)
                        )
                      )
                      (setq sset nil)
                    )
                    (if (= xyd T)
                      (alert "At least one insert had different XY scales,\nwhich was inserted exploded at the X scale factor.")
                    )
                    (dstp_ucspop)
                    (setvar "ATTREQ" attreq)
                    (command "_.PSPACE")
                    (princ "Done.")
                  )
                )
                (if (= frz T)
                  (progn
                    (dstp_prompt "DS> Deleting Frozen Layers ... ")
                    (if (/= xrffrz nil)
                      (progn
                        (command "_.MSPACE")
                        (foreach ln xrffrz
                          (setq sset (ssget "X" (list (cons 8 ln))))
                          (if (/= sset nil)
                            (command "_.ERASE" sset "")
                          )
                        )
                        (command "_.PSPACE")
                      )
                    )
                    (setq lt (tblnext "LAYER" T))
                    (while (/= lt nil)
                      (setq ln (cdr (assoc 2 lt)))
                      (setq lc (cdr (assoc 62 lt)))
                      (setq ls (cdr (assoc 70 lt)))
                      (setq lt (tblnext "LAYER"))
                      (setq del nil)
                      (if (= (boole 1 (- ls 64) 1) 1)
                        (setq del T)
                      )
                      (if (< lc 0)
                        (setq del T)
                      )
                      (if (= del T)
                        (progn
                          (setq sset (ssget "X" (list (cons 8 ln))))
                          (if (/= sset nil)
                            (progn
                              (setq lst (dstp_ss2lst sset))
                              (foreach hnd lst
                                (entdel hnd)
                              )
                            )
                          )
                        )
                      )
                    )
                    (setq sset nil)
                    (princ "Done.")
                  )
                )
                (command "_.LAYOUT" "_S" lay)
                (command "_.PSPACE")
                (foreach itm srclst
                  (if (/= itm lay)
                    (command "_.LAYOUT" "_D" itm)
                  )
                )
                (if (= eov T)
                  (progn
                    (dstp_prompt "DS> Erasing Outside Viewports ... ")
                    (setq ptlst nil)
                    (setq vset (ssget "_C" (getvar "LIMMIN")(getvar "LIMMAX") '((0 . "VIEWPORT"))))
                    (command "_.MSPACE")
                    (if (/= vset nil)
                      (progn
                        (setq num (sslength vset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname vset itm))
                          (setq ent (entget hnd))
                          (setq vid (cdr (assoc 69 ent)))
                          (setvar "CVPORT" vid)
                          (setq axo (vlax-ename->vla-object hnd))
                          (setq ctr (cdr (assoc 10 ent)))
                          (setq wid (vla-get-width axo))
                          (setq hgt (vla-get-height axo))
                          (setq ang (vla-get-twistangle axo))
                          (setq tmp (polar ctr 0 (/ wid 2.0)))
                          (setq urc (polar tmp (/ pi 2.0) (/ hgt 2.0)))
                          (setq ulc (polar urc pi wid))
                          (setq lrc (polar tmp (+ pi (/ pi 2.0)) (/ hgt 2.0)))
                          (setq llc (polar lrc pi wid))
                          (setq llc (trans (trans llc 3 2) 2 0))
                          (setq ulc (trans (trans ulc 3 2) 2 0))
                          (setq urc (trans (trans urc 3 2) 2 0))
                          (setq lrc (trans (trans lrc 3 2) 2 0))
                          (setq ptlst (cons (list vid llc urc) ptlst))
                          (setq itm (1+ itm))
                        )
                      )
                    )
                    (if (/= ptlst nil)
                      (progn
                        (command "_.MSPACE")
                        (dstp_ucspush)
                        (setq mset (ssget "X" '((67 . 0))))
                        (foreach rec ptlst
                          (setvar "CVPORT" (nth 0 rec))
                          (setq sset (ssget "_C" (nth 1 rec)(nth 2 rec)))
                          (if (/= sset nil)
                            (progn
                              (setq num (sslength sset) itm 0)
                              (while (< itm num)
                                (setq hnd (ssname sset itm))
                                (ssdel hnd mset)
                                (setq itm (1+ itm))
                              )
                            )
                          )
                        )
                        (command "_.ERASE" mset "")
                        (dstp_ucspop)
                        (command "_.PSPACE")
                      )
                    )
                    (command "_.PSPACE")
                    (princ "Done.")
                  )
                )
                (if (= prj T)
                  (progn
                    (dstp_prompt "DS> Projecting/Trimming Geometry ... ")
                    (setq ptlst nil)
                    (command "_.PSPACE")
                    (setq vset (ssget "_C" (getvar "LIMMIN")(getvar "LIMMAX") '((0 . "VIEWPORT"))))
                    (if (/= vset nil)
                      (progn
                        (command "_.MSPACE")
                        (setq sset (ssget "X" '((0 . "AECC_CONTOUR"))))
                        (if sset
                          (progn
                            (setq lst (dstp_ss2lst sset))
                            (foreach hnd lst
                              (command)
                              (command "_.EXPLODE" hnd)
                            )
                          )
                        )
                        (setq num (sslength vset) itm 0)
                        (while (< itm num)
                          (setq hnd (ssname vset itm))
                          (setq ent (entget hnd '("ACAD")))
                          (setq vid (cdr (assoc 69 ent)))
                          (setvar "CVPORT" vid)
                          (setq axo (vlax-ename->vla-object hnd))
                          (setq ctr (cdr (assoc 10 ent)))
                          (setq wid (vla-get-width axo))
                          (setq hgt (vla-get-height axo))
                          (setq ang (vla-get-twistangle axo))
                          (setq g340 (assoc 340 ent))
                          ;
                          ; --- build a sset of modelspace objects inside viewport
                          ;
                          (if (= g340 nil)
                            (progn
                              (setq tmp (polar ctr 0 (/ wid 2.0)))
                              (setq urc (polar tmp (/ pi 2.0) (/ hgt 2.0)))
                              (setq ulc (polar urc pi wid))
                              (setq lrc (polar tmp (+ pi (/ pi 2.0)) (/ hgt 2.0)))
                              (setq llc (polar lrc pi wid))
                              (setq llp llc lrp lrc urp urc ulp ulc)
                              (setq llc (trans (trans llc 3 2) 2 0))
                              (setq ulc (trans (trans ulc 3 2) 2 0))
                              (setq urc (trans (trans urc 3 2) 2 0))
                              (setq lrc (trans (trans lrc 3 2) 2 0))
                              (setq lst (list llc lrc urc ulc))
                              (setq sset (ssget "_CP" lst))
                            )
                            (progn
                              (setq bndhnd (cdr (assoc 340 ent)))
                              (setq bndpts (dstp_obj2lst bndhnd))
                              (setq tmp nil)
                              (foreach pnt bndpts
                                (setq new (trans (trans pnt 3 2) 2 0))
                                (setq tmp (cons new tmp))
                              )
                              (setq bndpts (reverse tmp) tmp nil)
                              (setq sset (ssget "_CP" bndpts))
                            )
                          )
                          ;
                          ; --- delete objects from sset frozen in viewport
                          ;
                          (setq nset (ssadd))
                          (setq lst (dstp_ss2lst sset))
                          (foreach hnd lst
                            (setq pass T)
                            (setq ent (entget hnd))
                            (setq lay (strcase (cdr (assoc 8 ent))))
                            (foreach chk vptfrz
                              (if (= (car chk) vid)
                                (if (= (strcase (cadr chk)) lay)
                                  (setq pass nil)
                                )
                              )
                            )
                            (if (= pass T)
                              (setq nset (ssadd hnd nset))
                            )
                          )
                          (setq sset nset)
                          (setq nset nil)
                          ;
                          (setq vpi (getvar "CVPORT"))
                          (setq vpl (ssget "X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
                          (setq hnd (ssname vpl 0))
                          (setq ent (entget hnd '("ACAD")))
                          (setq psrot (cdr (assoc 51 ent)))
                          (setq psctr (cdr (assoc 10 ent)))
                          (setq cvhgt (cdr (assoc 41 ent)))
                          (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
                          (setq cvscl (/ cvhgt cvsiz))
                          (setq msctr (trans (trans psctr 3 2) 2 0))
                          (dstp_ucspush)
                          (command "_.BLOCK" "DSTP_PURGEME" msctr sset "")
                          (dstp_ucspop)
                          (command "_.OOPS")
                          (command "_.PSPACE")
                          (dstp_ucspush)
                          (setq mrk (entlast))
                          (command "_.INSERT" "*DSTP_PURGEME" psctr cvscl (dstp_rtd psrot))
                          (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
                          (setq sset (ssadd))
                          (while (/= mrk nil)
                            (setq mrk (entnext mrk))
                            (if (/= mrk nil)
                              (progn
                                (setq ent (entget mrk))
                                (setq obj (cdr (assoc 0 ent)))
                                (if (not (member obj (list "VERTEX" "SEQEND")))
                                  (setq sset (ssadd mrk sset))
                                )
                              )
                            )
                          )
                          (dstp_ucspop)
                          (dstp_ucspush)
                          (setq rep 10)
                          (setq inc 0.01)
                          (setq ofs 0.0)
                          (setq g340 (assoc 340 ent))
                          (if (= g340 nil)
                            (progn
                              (repeat rep
                                (setq ofs (+ ofs inc))
                                (setq llt (polar llp (angle urp llp) ofs))
                                (setq lrt (polar lrp (angle ulp lrp) ofs))
                                (setq urt (polar urp (angle llp urp) ofs))
                                (setq ult (polar ulp (angle lrp ulp) ofs))
                                (command "_.TRIM" hnd "" "_F" llt lrt urt ult llt "" "")
                              )
                              (command "_.PLINE" llp lrp urp ulp "_C")
                            )
                            (progn
                              (setq bndhnd (cdr (assoc 340 ent)))
                              (setq bndpts (dstp_obj2lst bndhnd))
                              (setq refpnt (car bndpts))
                              (command "_.PLINE")
                              (foreach pnt bndpts
                                (command pnt)
                              )
                              (command "_C")
                              (command "_.REGION" "_L" "")
                              (setq reg (vlax-ename->vla-object (entlast)))
                              (setq cen (vlax-safearray->list (vlax-variant-value (vla-get-centroid reg))))
                              (entdel (entlast))
                              (repeat rep
                                (setq ofs (+ ofs inc))
                                (setq pik (polar refpnt (angle cen refpnt) ofs))
                                (command "_.OFFSET" ofs bndhnd pik "")
                                (setq ofspts (dstp_obj2lst (entlast)))
                                (entdel (entlast))
                                (command "_.TRIM" bndhnd "" "_F")
                                (foreach pnt ofspts
                                  (command pnt)
                                )
                                (command "" "")
                              )
                              (command "_.PLINE")
                              (foreach pnt bndpts
                                (command pnt)
                              )
                              (command "_C")
                            )
                          )
                          (dstp_ucspop)
                          (command "_.MSPACE")
                          (setq itm (1+ itm))
                        )
                        (command "_.MSPACE")
                        (dstp_ucspush)
                        (setq vpi (getvar "CVPORT"))
                        (setq vpl (ssget "X" (list (cons 0 "VIEWPORT")(cons 69 vpi))))
                        (setq hnd (ssname vpl 0))
                        (setq ent (entget hnd '("ACAD")))
                        (setq psrot (cdr (assoc 51 ent)))
                        (setq psctr (cdr (assoc 10 ent)))
                        (setq cvhgt (cdr (assoc 41 ent)))
                        (setq cvsiz (cdr (nth 6 (cdadr (assoc -3 ent)))))
                        (setq cvscl (/ cvsiz cvhgt))
                        (setq msctr (trans (trans psctr 3 2) 2 0))
                        (dstp_ucspop)
                        (command "_.PSPACE")
                        (dstp_ucspush)
                        (command "_.BLOCK" "DSTP_PURGEME" psctr "_ALL" "")
                        (dstp_ucspop)
                        (command "TILEMODE" "1")
                        (command "_.ERASE" "_ALL" "")
                        (dstp_ucspush)
                        (command "_.INSERT" "*DSTP_PURGEME" msctr cvscl (- 0.0 (dstp_rtd psrot)))
                        (setq sset (ssget "X" '((0 . "VIEWPORT"))))
                        (command "_.ERASE" sset "")
                        (command "_.DIM" "_UPD" "_ALL" "" "_E")
                        (dstp_ucspop)
                        (command "_.PURGE" "_B" "DSTP_PURGEME" "_N")
                        (command "_.DVIEW" "" "_TW" (dstp_rtd psrot) "")
                        (command "_.ZOOM" "_E")
                        (setq sset nil)
                      )
                    )
                    (princ "Done.")
                  )
                )
                (if (= pur T)
                  (repeat 3
                    (command "_.PURGE" "_A" "*" "_N")
                  )
                )
                (if (/= vers "R12")
                  (command "_.SAVEAS" vers out)
                  (command "_.SAVEAS" "_DXF" "_V" "_R12" "16" out)
                )
                (command "_.UNDO" "_B")
              )
              (setq fh (open org "r"))
              (setq str "")
              (repeat 6
                (setq let (read-char fh))
                (setq str (strcat str (chr let)))
              )
              (close fh)
              (cond
                ((= str "AC1024")(setq vers "2010"))
                ((= str "AC1021")(setq vers "2007"))
                ((= str "AC1018")(setq vers "2004"))
                ((= str "AC1015")(setq vers "2000"))
                ((= str "AC1014")(setq vers "R14"))
                ((= str "AC1013")(setq vers "R14"))
                ((= str "AC1012")(setq vers "R13"))
                (t (setq vers nil))
              )
              (if (/= vers nil)
                (command "_.SAVEAS" vers org "_Y")
              )
              (setvar "CMDECHO" cmdecho)
              (setvar "OSMODE" osmode)
              (setvar "ANGBASE" angbase)
              (setvar "ANGDIR" angdir)
            )
          )
        )
        (alert "Save Current Drawing First!")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                      Make Linetype in Current Drawing
; --------------------------------------------------------------------------

(defun c:LegLtpTxt (/ cha chs cmdecho ctr fh fn hnd itm lin1 lin2 ncod
                         nnam num sln sset tmp txt wid)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  ;
  (setq txt (getstring "\nDS> Text for Linetype: " T))
  (if (/= txt "")
    (progn
      (setq tmp (getreal "\nDS> Character Width Factor <1.0>: "))
      (if (/= tmp nil)(setq wid (/ tmp 10.0))(setq wid 0.1))
      ;
      (if (> (strlen txt) 31)
        (progn 
          (setq txt (substr txt 1 31))
          (princ "\nNOTICE: String length truncated to 31 characters")
        )
      )
      (setq ctr 1)
      (setq sln (strlen txt))
      (setq nnam "")
      (setq ncod "")
      (while (<= ctr sln)
        (setq chs (substr txt ctr 1))
        (setq cha (ascii chs))
        ;
        (if (= cha 34)(setq chs "\\U+0022")) ; handle " marks for inches
        (setq ncod (strcat ncod chs))
        ;
        (if (< cha 48)(setq chs "_"))
        (if (and (> cha 57)(< cha 65))(setq chs "_"))
        (if (and (> cha 90)(< cha 97))(setq chs "_"))
        (if (> cha 122)(setq chs "_"))
        (if (= cha 34)(setq chs "IN")) ; handle " marks for inches
        ;
        (setq nnam (strcat nnam chs))
        ;
        (setq ctr (1+ ctr))
      )
      (setq nnam (strcase nnam))
      ;
      (setq fn (strcat (getvar "TEMPPREFIX") "SCRATCH.LIN"))
      (setq fh (open fn "w"))
      (if (/= fh nil)
        (progn
          (setq lin1 (strcat "*" nnam "," "-----" nnam "-----"))
          (setq lin2 (strcat "\n" "A,.5,-.2,[" (chr 34) ncod (chr 34) "," (getvar "TEXTSTYLE") ",S=.1,R=0.0,X=-0.1,Y=-.05],-" (rtos (* (strlen txt) wid) 2 1)))
          (princ lin1 fh)
          (princ lin2 fh)
          (close fh)
          (if (/= (tblsearch "LTYPE" nnam) nil)
            (progn
              (command "_.LINETYPE" "_L" nnam (strcat (getvar "TEMPPREFIX") "SCRATCH") "Y" "S" nnam "")
              (princ (strcat "\nDS> Linetype [" nnam "] Changed, Set Current, Updating Objects, "))
              (setq sset (ssget "_X" (list (cons 6 nnam))))
              (if sset
                (progn
                  (setq num (sslength sset) itm 0)
                  (while (< itm num)
                    (setq hnd (ssname sset itm))
                    (entupd hnd)
                    (setq itm (1+ itm))
                  )
                  (princ "Done.")
                )
              )
              (setq sset nil)
            )
            (progn
              (command "_.LINETYPE" "_L" nnam (strcat (getvar "TEMPPREFIX") "SCRATCH") "S" nnam "")
              (princ (strcat "\nDS> Linetype [" nnam "] Created, Set Current."))
            )
          )
        )
      )
      (setq tmp (vl-file-delete (strcat (getvar "TEMPPREFIX") "SCRATCH.LIN")))
    )
  )
  ;
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                                  Station Polyline
; --------------------------------------------------------------------------

(defun c:LegPlnSta ( / apnt axo beg cdis chk cind cmdecho dec fang hnd
                          ibul int ipap ipnt lpre lstr npnt pct plen ppos
                          rang rstr sdis spre tind tmp tstr uscl attreq)
  (defun plstation_addpnt ()
    (if (= dec 0)
      (progn
        (setq sdis (rtos (+ cdis beg) 2 0))
        (cond 
          ((= (strlen sdis) 1)
            (setq lstr "0")
            (setq rstr (strcat "0" sdis))
          )
          ((= (strlen sdis) 2)
            (setq lstr "0")
            (setq rstr sdis)
          )
          (t
            (setq lstr (substr sdis 1 (- (strlen sdis) 2)))
            (setq tstr (strcat "0" sdis))
            (setq rstr (substr tstr (- (strlen tstr) 1) 2))
          )
        )
      )
      (progn
        (setq sdis (rtos (+ cdis beg) 2 dec))
        (setq ppos (vl-string-position 46 sdis))
        (if (< ppos 3)                                          ; < 100
          (progn
            (setq lstr "0")
            (setq tstr (strcat "0" sdis))
            (setq rstr (substr tstr ppos (- (strlen tstr) (- ppos 2))))
          )
          (progn
            (setq lstr (substr sdis 1 (- ppos 2)))
            (setq rstr (substr sdis (- ppos 1) (- (strlen sdis) (- ppos 2))))
          )
        )
      )
    )
    (setq npnt (vlax-curve-getPointAtDist axo cdis))
    (setq uscl (dstp_textsize))
    (if (< (+ cdis 0.01) plen)
      (progn
        (setq apnt (vlax-curve-getPointAtDist axo (+ cdis 0.01)))
        (setq fang (angle npnt apnt))
        (setq rang (+ fang pi (/ pi 2))) 
      )
      (progn
        (setq apnt (vlax-curve-getPointAtDist axo (- cdis 0.01)))
        (setq fang (angle npnt apnt))
        (setq rang (+ fang (/ pi 2))) 
      )
    )
    (if (/= spre "")
      (setq lstr (strcat spre " " lstr))
    )
    (command "_.INSERT" (strcat dstpdir "DATA/POLYSTA") npnt uscl uscl (dstp_rtd rang) lstr rstr)
  )
  (setq tmp (entsel "\nDS> Select Polyline or LWPolyline: "))
  (if (/= tmp nil)
    (progn
      (setq hnd (car tmp))
      (dstp_getpline hnd)
      (if (/= dstp_plhdr nil)
        (if (= (boole 1 (nth 1 dstp_plhdr) 1) 0)
          (progn
            (setq chk (getdist "\nDS> Beginning Station Value <0.00>: "))
            (if (= chk nil)(setq beg 0.0)(setq beg chk))
            (setq chk (getdist "\nDS> Station Distance Interval <100.00>: "))
            (if (= chk nil)(setq int 100.0)(setq int chk))
            (setq chk (getint "\nDS> Number of Decimal Places <2>: "))
            (if (= chk nil)(setq dec 2)(setq dec chk))
            (if (< dec 0)(setq dec 0))
            (if (> dec 8)(setq dec 8))
            (initget "Y N")
            (setq chk (getkword "\nDS> Label PC/PT Positions <Y>/N: "))
            (if (= chk "N")(setq pct 0)(setq pct 1))
            (initget "Y N")
            (setq chk (getkword "\nDS> Prompt for Random Points Y/<N>: "))
            (if (= chk "Y")(setq rnd 1)(setq rnd 0))
            ;
            (setq spre "")
            (setq axo (vlax-ename->vla-object hnd))
            (setq plen (vlax-curve-getDistAtParam axo (vlax-curve-getendparam axo)))
            (if (>= plen int)
              (progn
                (setq cmdecho (getvar "CMDECHO"))
                (setvar "CMDECHO" 0)
                (setq attreq (getvar "ATTREQ"))
                (setvar "ATTREQ" 1)
                (command "_.UNDO" "_G")
                (if (= (tblsearch "BLOCK" "POLYSTA") nil)
                  (progn
                    (command "_.INSERT" (strcat dstpdir "DATA\\POLYSTA"))
                    (command)
                  )
                )
                (dstp_ucspush)
                ;
                (setq cdis 0.0)
                (while (< cdis plen)
                  (plstation_addpnt)
                  (setq cdis (+ cdis int))
                )
                (setq cdis plen)
                (plstation_addpnt)
                ;
                (if (= pct 1)
                  (progn
                    (setq cind 1)
                    (setq tind (- (length dstp_pldat) 1))
                    (repeat tind
                      (setq ipnt (nth 0 (nth cind dstp_pldat)))
                      (setq ibul (nth 3 (nth cind dstp_pldat)))
                      (setq ipap (vlax-curve-getparamatpoint axo ipnt))
                      (setq cdis (vlax-curve-getdistatparam axo ipap))
                      (if (> cdis 0.0)
                        (progn
                          (if (/= ibul 0.0)
                            (setq spre "PC")
                            (if (= lpre "PC")
                              (setq spre "PT")
                              (setq spre "")
                            )
                          )
                          (plstation_addpnt)
                          (setq lpre spre)
                        )
                      )
                      (setq cind (+ cind 1))
                    )
                  )
                )
                (if (= rnd 1)
                  (progn
                    (setq spre "")
                    (setq done nil)
                    (setq osmode (getvar "OSMODE"))
                    (setvar "OSMODE" 513)
                    (dstp_prompt "DS> Nearest/Endpoint Osnap Temporarily Set On!")
                    (while (= done nil)
                      (setq ipnt (getpoint "\nDS> Pick Point Along Stationed Polyline: "))
                      (if (= ipnt nil)
                        (setq done T)
                        (progn
                          (setq ipap (vlax-curve-getparamatpoint axo ipnt))
                          (setq cdis (vlax-curve-getdistatparam axo ipap))
                          (plstation_addpnt)
                        )
                      )
                    )
                    (setvar "OSMODE" osmode)
                  )
                )
                (dstp_ucspop)
                (command "_.UNDO" "_E")
                (setvar "CMDECHO" cmdecho)
                (setvar "ATTREQ" attreq)
                (dstp_prompt "DS> Tangency not verified, use Tangency Check tool.")
              )
              (dstp_prompt "DS> Polyline too short for interval!")
            )
          )
          (dstp_prompt "DS> Polyline is closed!")
        )
        (dstp_prompt "DS> Object is not a Polyline or LWPolyline")
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                         3D Polyline Edit by Text Tag
; --------------------------------------------------------------------------

(defun c:LegPlnTag (/ $value chk cmdecho dcl_id dec done doproc eed elv
                         elvfld ent hnd itm new npt num nxtent nxthnd opt
                         plhnd pnt sset str val vtxent vtxhnd)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      ;
      (if (= (getvar "HANDLES") 1)
        (progn
          (princ "\nDS> Select 3D Polyline(s) to Edit ...")
          (setq sset (ssget '((0 . "POLYLINE")(-4 . "<OR")(70 . 8) (70 . 9)(-4 . "OR>"))))
          (if sset
            (progn
              (if (null (tblsearch "APPID" "DSTP_3DTAG"))
                (regapp "DSTP_3DTAG")
              )
              (setq num (sslength sset) itm 0)
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Labeling Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq plhnd (ssname sset itm))
                (setq nxthnd plhnd)
                (setq done nil)
                (while (/= done T)
                  (setq nxthnd (entnext nxthnd))
                  (setq nxtent (entget nxthnd))
                  (if (= "VERTEX" (cdr (assoc 0 nxtent)))
                    (progn
                      (setq pnt (cdr (assoc 10 nxtent)))
                      (setq new '((0 . "TEXT")))
                      (setq new (append new (list (list 10 (nth 0 pnt) (nth 1 pnt) (nth 2 pnt)))))
                      (setq new (append new (list (cons 40 (dstp_textsize)))))
                      (setq new (append new (list (cons 7 (getvar "TEXTSTYLE")))))
                      (setq new (append new (list (cons 1 (rtos (nth 2 pnt))))))
                      (setq new (append new (list (cons 72 0))))
                      (setq new (append new (list (cons 73 0))))
                      (setq eed (list -3 (list "DSTP_3DTAG" (cons 1005 (cdr (assoc 5 nxtent))))))
                      (setq new (append new (list eed)))
                      (entmake new)
                    )
                  )
                  (if (= "SEQEND" (cdr (assoc 0 nxtent)))
                    (setq done T)
                  )
                )
                (setq itm (+ itm 1))
              )
              ;
              (setq done nil)
              (while (= done nil)
                (initget "D M Z P X")
                (setq opt (entsel "\nDS> Decimals/Move/Zoom/Pan/eXit/<Select Label>: "))
                (cond
                  ((= opt "D")
                    (setq dec (getint "\nDS> Number of Decimal Places: "))
                    (if (/= dec nil)
                      (progn
                        (if (< dec 0)(setq dec 0))
                        (if (> dec 8)(setq dec 8))
                        (setq sset (ssget '((0 . "TEXT") (-3 ("DSTP_3DTAG")))))
                        (if sset
                          (progn
                            (setq num (sslength sset) itm 0)
                            (while (< itm num)
                              (setq hnd (ssname sset itm))
                              (setq ent (entget hnd '("DSTP_3DTAG")))
                              (setq chk (assoc -3 ent))
                              (setq val (cdr (cadr (car (cdr chk)))))
                              (setq vtxhnd (handent val))
                              (setq vtxent (entget vtxhnd))
                              (setq pnt (cdr (assoc 10 vtxent)))
                              (setq elv (nth 2 pnt))
                              (setq str (rtos elv 2 dec))
                              (setq ent (subst (cons 1 str)(assoc 1 ent) ent))
                              (entmod ent)
                              (setq itm (+ itm 1))
                            )
                          )
                        )
                      )
                    )
                  )
                  ((= opt "M")
                    (setvar "CMDECHO" 1)
                    (command "_.MOVE")
                    (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                      (command pause)
                    )
                    (setvar "CMDECHO" 0)
                  )
                  ((= opt "Z")
                    (setvar "CMDECHO" 1)
                    (command "_.RTZOOM")
                    (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                      (command pause)
                    )
                    (setvar "CMDECHO" 0)
                  )
                  ((= opt "P")
                    (setvar "CMDECHO" 1)
                    (command "_.RTPAN")
                    (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
                      (command pause)
                    )
                    (setvar "CMDECHO" 0)
                  )
                  ((or (= opt "X")(= opt "")(= opt nil))
                    (setq sset (ssget "_X" '((0 . "TEXT") (-3 ("DSTP_3DTAG")))))
                    (if sset (command "_.ERASE" sset ""))
                    (redraw plhnd)
                    (setq done T)
                  )
                  (t
                    (setq hnd (car opt))
                    (setq ent (entget hnd '("DSTP_3DTAG")))
                    (setq chk (assoc -3 ent))
                    (setq val (cdr (cadr (car (cdr chk)))))
                    (setq vtxhnd (handent val))
                    (setq vtxent (entget vtxhnd))
                    (setq pnt (cdr (assoc 10 vtxent)))
                    (setq elv (nth 2 pnt))
                    (setq str (rtos elv 2 8))
                    ;
                    (dstp_marker pnt)
                    (if (< (setq dcl_id (load_dialog "unsupport.dcl")) 0) (exit))
                    (if (not (new_dialog "pl3dtags" dcl_id)) (exit))
                    (set_tile "elvfld" str)
                    (mode_tile "elvfld" 2)
                    (action_tile "elvfld" "(setq elvfld $value)")
                    (action_tile "accept" "(setq str elvfld)(setq doproc T)(done_dialog 1)")
                    (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
                    (action_tile "help" "(dstp_showhelp \"pl3dtags.htm\")")
                    (start_dialog)
                    (princ)
                    (unload_dialog dcl_id)
                    (dstp_marker pnt)
                    ;
                    (if (= doproc T)
                      (progn
                        (setq ent (subst (cons 1 str)(assoc 1 ent) ent))
                        (setq ent (subst (cons 10 (list (nth 1 (assoc 10 ent))(nth 2 (assoc 10 ent))(atof str)))(assoc 10 ent) ent))
                        (setq npt (list (nth 0 pnt)(nth 1 pnt)(atof str)))
                        (entmod ent)
                        (setq npt (list (nth 0 pnt)(nth 1 pnt)(atof str)))
                        (setq vtxent (subst (cons 10 npt)(assoc 10 vtxent) vtxent))
                        (entmod vtxent)
                        (entupd vtxhnd)
                      )
                    )
                  )
                )
              )
            )
          )
        )
        (princ "\nDS> Handles not turned on, EED Recall Tags not available.")
      )
      ;
      (setq sset nil)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
  (princ)
)

; -------------------------------------------------------------------------
;                          Multi-Pline Modify
; --------------------------------------------------------------------------

(defun c:LegPlnWid ()(dstp_legplnedt "w")(princ))

(defun dstp_legplnedt (cmd / 3dp cmdecho done sset num opt tmp nw hnd ent itm)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq done nil)
  (setq sset (ssget "_I" '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
  (if (= sset nil)
    (setq sset (ssget '((-4 . "<OR")(0 . "POLYLINE")(0 . "LWPOLYLINE")(-4 . "OR>"))))
  )
  (if sset
    (progn
      (setq num (sslength sset))
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (while (/= done T)
        (if (/= cmd nil)
          (setq opt cmd done T)
          (progn
            (initget "o c s f d w l x")
            (setq opt (getkword "\nDS> Open/Close/Spline/Fitcurve/Decurve/Width/Ltgen/eXit <X>: "))
            (if (= opt "l")
              (progn
                (initget "ON OFF")
                (setq tmp (getkword "\nDS> ON/OFF: "))
                (if (= tmp "OFF")(setq opt "0"))
                (if (= tmp "ON")(setq opt "1"))
              )
            )
            (if (= opt "x")(setq done T))
            (if (= opt nil)(setq done T))
          )
        )
        (if (/= opt nil)
          (progn
            (cond
              ((= opt "w")
                (setq nw (getdist "\nDS> New Polyline Width: "))
              )
              ((= opt "r")
                (setq tmp (entsel "\nDS> Pick Source Polyline: "))
                (setq nw (cdr (assoc 40 (entget (car tmp)))))
              )
              ((= opt "x")
                (setq scf (getreal "\nDS> Scale Factor <1.0>: "))
                (if (= scf nil)(setq scf 1.0))
              )
              (t nil)
            )
            (setq itm 0)
            (while (< itm num)
              (setq hnd (ssname sset itm))
              (setq ent (entget hnd))
              (if (= (boole 1 (cdr (assoc 70 ent)) 8) 8)
                (setq 3dp T)
                (setq 3dp nil)
              )
              (if (= opt "o")(command "_.PEDIT" hnd "_O" "_X"))
              (if (= opt "c")(command "_.PEDIT" hnd "_C" "_X"))
              (if (= opt "s")(command "_.PEDIT" hnd "_S" "_X"))
              (if (and (= opt "f")(= 3dp nil))(command "_.PEDIT" hnd "_F" "_X"))
              (if (= opt "d")(command "_.PEDIT" hnd "_D" "_X"))
              (if (and (= opt "1")(= 3dp nil))(command "_.PEDIT" hnd "_L" "ON" "_X"))
              (if (and (= opt "0")(= 3dp nil))(command "_.PEDIT" hnd "_L" "OFF" "_X"))
              (if (and (= opt "w")(= 3dp nil))(command "_.PEDIT" hnd "_W" nw "_X"))
              (if (and (= opt "r")(= 3dp nil))(command "_.PEDIT" hnd "_W" nw "_X"))
              (if (and (= opt "x")(= 3dp nil))(command "_.PEDIT" hnd "_W" (* scf (cdr (assoc 43 ent))) "_X"))
              (setq itm (1+ itm))
            )
          )
        )
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
    )
  )
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; ----------------------------------------------------------------------
;                          Setup New Drawing
; ----------------------------------------------------------------------

(defun c:LegNewDwg (/ $value arcscl baklst bdrlst bdrnam bdrorg bdrrot
                         chk cld cldlst cnt ctr curscl dcl_id delkey dim
                         dis done doproc dstpdir engscl fh fn hps ibblst
                         lim lts mecscl metscl newnam pos prolst pronam
                         quo run scale scltyp scrfn tex tmp tsz val wrn)
  (defun setupnew_cldfil ()
    (start_list "cldlst")
    (mapcar 'add_list cldlst)
    (end_list)
  )
  (defun setupnew_cldadd ()
    (setq tmp (dstp_getfiles "Add Prototype Drawing" "" "dwg;dwt" 0))
    (if (/= tmp nil)
      (progn
        (setq cldlst (append cldlst (list tmp)))
        (setupnew_cldfil)
      )
    )
  )
  (defun setupnew_clddel ()
    (setq delkey (atoi (get_tile "cldlst")))
    (if (or (= delkey nil)(< delkey 0))
      (alert "Nothing Selected to Delete!")
      (progn
        (setq tmp cldlst)
        (setq cldlst nil)
        (setq ctr 0)
        (repeat (length tmp)
          (if (/= ctr delkey)
            (setq cldlst (append cldlst (list (nth ctr tmp))))
          )
          (setq ctr (1+ ctr))
        )
        (setupnew_cldfil)
      )
    )
  )
  (defun setupnew_cldman ()
    (setq baklst cldlst)
    (if (not (new_dialog "cldman" dcl_id)) (exit))
    (cond
      ((= cld 1)(set_tile "cldtle" "Prototype Drawings"))
      ((= cld 2)(set_tile "cldtle" "Border/Title Blocks"))
      (t nil)
    )
    (setupnew_cldfil)
    ;
    (action_tile "add" "(setupnew_cldadd)")
    (action_tile "del" "(setupnew_clddel)")
    (action_tile "srt" "(setq cldlst (acad_strlsort cldlst))(setupnew_cldfil)")
    ;
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "cancel" "(setq cldlst baklst)(done_dialog 1)")
    (start_dialog)
  )
  ;
  ; --- fill prototype pop from list
  ;
  (defun setupnew_updpro ()
    (if (> (length prolst) 0)
      (setq tmp prolst)
      (setq tmp prolst)
    )
    (start_list "pronam")
    (add_list "(ACAD)")
    (mapcar 'add_list tmp)
    (end_list)
    (setq chk (member pronam tmp))
    (if (/= chk nil)
      (progn
        (setq pos (- (length tmp) (length chk)))
        (set_tile "pronam" (itoa (+ pos 1)))
      )
    )
  )
  ;
  ; --- fill border pop from list
  ;
  (defun setupnew_updbdr ()
    (if (> (length bdrlst) 0)
      (setq tmp bdrlst)
      (setq tmp bdrlst)
    )
    (start_list "bdrnam")
    (add_list "(none)")
    (mapcar 'add_list tmp)
    (end_list)
    (setq chk (member bdrnam tmp))
    (if (/= chk nil)
      (progn
        (setq pos (- (length tmp) (length chk)))
        (set_tile "bdrnam" (itoa (+ pos 1)))
      )
    )
  )
  ;
  ; --- load scales from setupnew.scl
  ;
  (defun setupnew_lodscl ()
    (setq fn (findfile (strcat dstpdir "Data\\SETUPNEW.SCL")))
    (if (/= fn nil)
      (progn
        (setq done nil)
        (setq arcscl nil)
        (setq engscl nil)
        (setq mecscl nil)
        (setq metscl nil)
        (setq fh (open fn "r"))
        (while (/= done T)
          (setq chk (read-line fh))
          (cond
            ((= chk "-----arc")(setq tmp 1))
            ((= chk "-----eng")(setq tmp 2))
            ((= chk "-----mec")(setq tmp 3))
            ((= chk "-----met")(setq tmp 4))
            ((= chk "-----end")(setq done T tmp 0))
            (t
              (cond
                ((= tmp 1)(setq arcscl (append arcscl (list chk))))
                ((= tmp 2)(setq engscl (append engscl (list chk))))
                ((= tmp 3)(setq mecscl (append mecscl (list chk))))
                ((= tmp 4)(setq metscl (append metscl (list chk))))
              )
            )
          )
        )
        (close fh)
      )
    )
  )
  ;
  ; --- fill scale from picked list
  ;
  (defun setupnew_updscl ()
    (cond 
      ((= scltyp 1)(setq tmp arcscl))
      ((= scltyp 2)(setq tmp engscl))
      ((= scltyp 3)(setq tmp mecscl))
      ((= scltyp 4)(setq tmp metscl))
    )
    (start_list "scales")
    (mapcar 'add_list tmp)
    (end_list)
    (setq chk (member curscl tmp))
    (if (/= chk nil)
      (progn
        (setq pos (- (length tmp) (length chk)))
        (set_tile "scales" (itoa pos))
      )
    )
  )
  ;
  ; --- set prototype when popdown chosen
  ;
  (defun setupnew_setpro ()
    (cond 
      ((= $value "0")(setq pronam "(ACAD)"))
      (t
        (setq pronam (nth (- (atoi $value) 1) prolst))
      )
    )
  )
  ;
  ; --- set border when popdown chosen
  ;
  (defun setupnew_setbdr ()
    (cond 
      ((= $value "0")(setq bdrnam "(none)"))
      (t
        (setq bdrnam (nth (- (atoi $value) 1) bdrlst))
      )
    )
  )
  ;
  ; --- set scale when popdown chosen
  ;
  (defun setupnew_setscl ()
    (cond
      ((= scltyp 1)(setq curscl (nth val arcscl)))
      ((= scltyp 2)(setq curscl (nth val engscl)))
      ((= scltyp 3)(setq curscl (nth val mecscl)))
      ((= scltyp 4)(setq curscl (nth val metscl)))
    )
  )
  ;
  ; --- select new filename from dialog
  ;
  (defun setupnew_donewsel ()
    (if (= newnam nil)(setq newnam ""))
    (setq tmp (dstp_getfiles "New Drawing Name" newnam "dwg" 1))
    (if (/= tmp nil)
      (progn
        (setq newnam tmp)
        (set_tile "newnam" newnam)
      )
    )
  )
  ;
  ; --- check new filename from edit field
  ;
  (defun setupnew_donewchk ()
    (if (/= newnam "")
      (progn
        (if (/= (strcase (substr newnam (- (strlen newnam) 3) 4)) ".DWG")
          (setq newnam (strcat newnam ".DWG"))
        )
        (if (findfile newnam)
          (progn
            (alert "Filename specified already exists!")
            (mode_tile "accept" 2)
          )
        )
      )
      (alert "New filename is blank!")
    )
  )
  ;
  ; --- load first ini file found
  ;
  (defun setupnew_lodini ()
    (setq fn (findfile "setupnew.ini"))
    (if (/= fn nil)
      (progn
        (setq fh (open fn "r"))
        (setq chk (read-line fh))
        (setq pronam (read-line fh))
        (setq bdrnam (read-line fh))
        (setq scltyp (atoi (read-line fh)))
        (setq curscl (read-line fh))
        (setq cnt (atoi (read-line fh)))
        (repeat cnt
          (setq prolst (append prolst (list (read-line fh))))
        )
        (setq cnt (atoi (read-line fh)))
        (repeat cnt
          (setq bdrlst (append bdrlst (list (read-line fh))))
        )
        (setq bdrorg (read-line fh))
        (setq bdrrot (read-line fh))
        (setq lts (read-line fh))
        (setq dim (read-line fh))
        (setq hps (read-line fh))
        (setq lim (read-line fh))
        (setq tex (read-line fh))
        (setq tsz (read-line fh))
        (close fh)
        ;
        (if (= pronam "nil")(setq pronam ""))
        (if (= curscl "nil")
          (progn
            (setq val 0)
            (setupnew_setscl)
          )
        )
      )
    )
  )
  ;
  ; --- Main Control 
  ;
  (setq run T)
  (if (/= (getvar "SDI") 0)
    (progn
      (alert "New Drawing Setup must be run in MDI mode.")
      (setq run nil)
    )
  )
  (if (= run T)
    (progn
      (setq doproc nil)
      (setq prolst nil)
      (setq bdrlst nil)
      (setq ibblst nil)
      ;
      (setq scltyp 1)
      (setq newnam "Drawing")
      (setq bdrnam "")
      (setq bdrorg "0,0")
      (setq bdrrot "0")
      (setq lts "1")
      (setq dim "1")
      (setq hps "1")
      (setq lim "1")
      (setq tex "1")
      (setq tsz (rtos 0.08))
      ;
      (setq wrn (strcat "WARNING: The status of your current drawing"
                      "\nindicates that changes have not been saved!"))
      (if (> (getvar "DBMOD") 0)
        (setq dis T)
        (setq dis nil)
      )
      (if (= (getvar "SDI") 0)
        (setq dis nil)
      )
      (if (= (getvar "EXPERT") 5)
        (setq dis nil)
      )
      (if (= dis T)
        (alert wrn)
      )
      ;
      (setq dcl_id (load_dialog "unsupport.dcl"))
      (if (not (new_dialog "setupnew" dcl_id)) (exit))
      (setupnew_lodscl)
      (setupnew_lodini)
      (setupnew_updscl)
      (setupnew_updpro)
      (setupnew_updbdr)
      (set_tile "newnam" newnam)
      ;
      (cond
        ((= scltyp 1)(set_tile "arc" "1"))
        ((= scltyp 2)(set_tile "eng" "1"))
        ((= scltyp 3)(set_tile "mec" "1"))
        ((= scltyp 4)(set_tile "met" "1"))
      )
      (set_tile "lts" lts)
      (set_tile "dim" dim)
      (set_tile "hps" hps)
      (set_tile "lim" lim)
      (set_tile "tex" tex)
      (set_tile "tsz" tsz)
      (set_tile "bdrorg" bdrorg)
      (set_tile "bdrrot" bdrrot)
      ;
      (action_tile "newnam" "(setq newnam $value)(setupnew_donewchk)")
      (action_tile "newsel" "(setupnew_donewsel)")
      (action_tile "pronam" "(setupnew_setpro)")
      (action_tile "proman" "(setq cld 1)(setq cldlst prolst)(setupnew_cldman)(setq prolst cldlst)(setupnew_updpro)")
      (action_tile "bdrnam" "(setupnew_setbdr)")
      (action_tile "bdrman" "(setq cld 2)(setq cldlst bdrlst)(setupnew_cldman)(setq bdrlst cldlst)(setupnew_updbdr)")
      ;
      (action_tile "bdrorg" "(setq bdrorg $value)")
      (action_tile "bdrrot" "(setq bdrrot $value)")
      ;
      (action_tile "arc" "(setq scltyp 1)(setupnew_updscl)")
      (action_tile "eng" "(setq scltyp 2)(setupnew_updscl)")
      (action_tile "mec" "(setq scltyp 3)(setupnew_updscl)")
      (action_tile "met" "(setq scltyp 4)(setupnew_updscl)")
      (action_tile "scales" "(setq val (atoi $value))(setupnew_setscl)")
      ;
      (action_tile "lts" "(setq lts $value)")
      (action_tile "dim" "(setq dim $value)")
      (action_tile "hps" "(setq hps $value)")
      (action_tile "lim" "(setq lim $value)")
      (action_tile "tex" "(setq tex $value)")
      (action_tile "tsz" "(setq tsz $value)")
      ;
      (action_tile "accept" "(setq doproc T)(done_dialog 0)")
      ;
      (if (equal (start_dialog) 1)
        (setq tmp nil)
      )
      (unload_dialog dcl_id)
      ;
      (if (= doproc T)
        (progn
          (setq fn (findfile "setupnew.ini"))
          (if (= fn nil)(setq fn (strcat dstpdir "setupnew.ini")))
          (setq fh (open fn "w"))
          (if (/= fh nil)
            (progn
              (princ "New Drawing Setup Specs" fh)
              (princ "\n" fh)
              (princ pronam fh)
              (princ "\n" fh)
              (princ bdrnam fh)
              (princ "\n" fh)
              (princ scltyp fh)
              (princ "\n" fh)
              (princ curscl fh)
              (princ "\n" fh)
              (princ (length prolst) fh)
              (foreach itm prolst
                (princ "\n" fh)
                (princ itm fh)
              )
              (princ "\n" fh)
              (princ (length bdrlst) fh)
              (foreach itm bdrlst
                (princ "\n" fh)
                (princ itm fh)
              )
              (princ "\n" fh)
              (princ bdrorg fh)
              (princ "\n" fh)
              (princ bdrrot fh)
              (princ "\n" fh)
              (princ lts fh)
              (princ "\n" fh)
              (princ dim fh)
              (princ "\n" fh)
              (princ hps fh)
              (princ "\n" fh)
              (princ lim fh)
              (princ "\n" fh)
              (princ tex fh)
              (princ "\n" fh)
              (princ tsz fh)
              (close fh)
            )
          )
          ;
          ; --- write script for execution
          ;
          (setq quo (chr 34))
          (setq tmp (getvar "LOGINNAME"))
          (if (> (strlen tmp) 8)(setq tmp (substr tmp 1 8)))
          (setq scrfn (strcat (getvar "TEMPPREFIX") tmp ".SCR"))
          (setq fh (open scrfn "w"))
          (if (/= fh nil)
            (progn
              (princ (strcat "NEW " quo pronam quo) fh)
              (setq bdrnam (dstp_subtext bdrnam "\\" "/"))
              (if (/= curscl nil)
                (cond
                  ((= scltyp 1)(setq scale (rtos (/ 12 (distof curscl)) 2))) ; architectural
                  ((= scltyp 2)(setq scale (rtos (distof curscl) 2)))        ; engineering
                  ((= scltyp 3)(setq scale (rtos (/ 12 (distof curscl)) 2))) ; mechanical
                  ((= scltyp 4)(setq scale (rtos (distof curscl) 2)))        ; metric
                )
              )
              (if (/= scale nil)
                (progn
                  (if (= lts "1")
                    (princ (strcat "\nLTSCALE " (rtos (/ (distof scale) 2) 2)) fh)
                  )
                  (if (= dim "1")
                    (princ (strcat "\nDIMSCALE " scale) fh)
                  )
                  (if (= hps "1")
                    (princ (strcat "\nHPSCALE " scale) fh)
                  )
                  (if (= tex "1")
                    (princ (strcat "\nTEXTSIZE " (rtos (* (distof scale) (distof tsz)) 2)) fh)
                  )
                  ;
                  (princ "\nATTDIA 1" fh)
                  (princ "\nATTREQ 0" fh)
                  (if (/= bdrnam "")
                    (progn
                      (princ (strcat "\nINSERT " quo bdrnam quo " " bdrorg " " scale " " scale " " bdrrot) fh)
                      (princ (strcat "\nZOOM EXTENTS") fh)
                      (if (= lim "1")
                        (princ (strcat "\nLIMITS " "(getvar " (chr 34) "EXTMIN" (chr 34) ")" " " "(getvar " (chr 34) "EXTMAX" (chr 34) ")") fh)
                      )
                      (princ "\nZOOM 0.98X" fh)
                    )
                  )
                )
              )
              ;
              (if (/= newnam "Drawing")
                (progn
                  (setq newnam (dstp_subtext newnam "\\" "/"))
                  (if (findfile newnam)
                    (princ (strcat "\nSAVE " quo newnam quo " " "Y") fh)
                    (princ (strcat "\nSAVE " quo newnam quo) fh)
                  )
                )
              )
              (princ "\nATTREQ 1" fh)
              (princ "\nATTDIA 1" fh)
              (princ "\n" fh)
              (close fh)
              (princ "Done.")
              ;
              (princ "\n")
              (setvar "CMDECHO" 0)
              (command "_.SCRIPT" scrfn)
            )
          )
        )
      )
    )
  )
  (princ)
)

; --------------------------------------------------------------------------
;                           Translate Standards
; --------------------------------------------------------------------------

(defun c:LegStdTrn (/ $value autofile autoload ccol chg chk clay cltp
                         cmdecho col colst ctr cur curfil datlst dcl_id
                         dianam done doproc dstp_diasize ent fh fld fn fnd
                         frval gplst gpval hnd itm lay ltp ltplst lty ncol
                         new nlay nltp num opt pmt pre redo resp sset stv
                         tmp toval val what_next xfr xgp xto)
  ;
  ; --- select item from group choices
  ;
  (defun translat_dogrpsel (opt)
    (if (/= opt nil)
      (progn
        (setq gpval (nth opt gplst))
        (set_tile "gpval" gpval)
      )
    )
  )
  ;
  ; --- react to select buttons
  ;
  (defun translat_doselect (opt)
    (if (= opt 1)
      (setq cur frval)
      (setq cur toval)
    )
    (if (= cur nil)(setq cur ""))
    (cond
      ((= (strcase gpval) "COLOR")
        (setq col (dstp_str2col cur))
        (if (= col nil)(setq col 256))
        (setq tmp (acad_colordlg col))
        (setq val (dstp_col2str tmp))
      )
      ((= (strcase gpval) "LINETYPE")
        (setq ltplst (dstp_bldlst "LTYPE"))
        (setq ltplst (append (list "BYLAYER") ltplst))
        (setq ltplst (append (list "BYBLOCK") ltplst))
        (setq resp (dstp_tablesel "Select Desired Linetype" ltplst "s" ""))
        (if (/= resp nil)(setq val resp))
        (setq ltplst nil)
      )
      ((= (strcase gpval) "LAYER")
        (setq resp (dstp_tablesel "LAYER" (acad_strlsort (dstp_bldlst "LAYER")) "s" ""))
        (if (/= resp nil)(setq val resp))
      )
      (t nil)
    )
    (if (= opt 1)
      (progn
        (setq frval val)
        (set_tile "frval" frval)
      )
      (progn
        (setq toval val)
        (set_tile "toval" toval)
      )
    )
  )
  ;
  ; --- clear edit fields
  ;
  (defun translat_clrflds ()
    (setq frval "")
    (setq toval "")
    (set_tile "gpval" gpval)
    (set_tile "frval" frval)
    (set_tile "toval" toval)
    (mode_tile "gpval" 2)
  )
  ;
  ; --- add record from input
  ;
  (defun translat_addinp ()
    (if (and (/= gpval "")(/= frval "")(/= toval ""))
      (progn
        (setq gpval (strcase gpval))
        (setq frval (strcase frval))
        (setq toval (strcase toval))
        (setq new (list gpval frval toval))
        (setq datlst (append datlst (list new)))
        (translat_updlst)
        (translat_clrflds)
        (set_tile "lstbox" (itoa (1- (length datlst))))
        (mode_tile "gpval" 2)
      )
      (alert "Insufficient Data")
    )
  )
  ;
  ; --- update list box
  ;
  (defun translat_updlst ()
    (setq ctr 1)
    (start_list "lstbox")
    (foreach chk datlst
      (setq xgp (nth 0 chk))
      (setq xfr (nth 1 chk))
      (setq xto (nth 2 chk))
      ;
      (if (= xgp "COLOR")
        (progn
          (if (and (> (atoi xfr) 0)(< (atoi xfr) 8))
            (setq xfr (strcat xfr " (" (nth (- (atoi xfr) 1) colst) ")"))
          )        
          (if (and (> (atoi xto) 0)(< (atoi xto) 8))
            (setq xto (strcat xto " (" (nth (- (atoi xto) 1) colst) ")"))
          )
        )
      )
      ;
      (add_list (strcat xgp "\t" xfr "\t" xto))
      (setq ctr (1+ ctr))
    ) 
    (end_list)
  )
  ;
  ; --- display selected line
  ;
  (defun translat_displin ()
    (setq itm (atoi (get_tile "lstbox")))
    (if (/= itm nil)
      (progn
        (setq chk (nth itm datlst))
        (setq gpval (nth 0 chk))
        (set_tile "gpval" gpval)
        (setq frval (nth 1 chk))
        (set_tile "frval" frval)
        (setq toval (nth 2 chk))
        (set_tile "toval" toval)
      )
    )
  )
  ;
  ; --- change line in list
  ;
  (defun translat_chglin ()
    (setq itm (atoi (get_tile "lstbox")))
    (if (= itm nil)
      (alert "Nothing to CHANGE")
      (progn
        (setq chk (nth itm datlst))
        (setq gpval (strcase gpval))
        (setq frval (strcase frval))
        (setq toval (strcase toval))
        (setq new (list gpval frval toval))
        (setq datlst (subst new chk datlst))
        (translat_clrflds)
        (translat_updlst)
        (set_tile "databox" (itoa (1- itm)))
        (mode_tile "gpval" 2)
      )
    )
  )
  ;
  ; --- delete current line in list
  ;
  (defun translat_dellin ()
    (setq itm (atoi (get_tile "lstbox")))
    (if (= itm nil)
      (alert "Nothing to DELETE !")
      (progn
        (setq tmp datlst)
        (setq datlst nil)
        (setq ctr 0)
        (repeat (length tmp)
          (if (/= ctr itm)
            (setq datlst (append datlst (list (nth ctr tmp))))
          )
          (setq ctr (1+ ctr))
        )
        (translat_updlst)
        (translat_clrflds)
        (set_tile "lstbox" (itoa itm))
        (mode_tile "gpval" 2)
        (setq tmp nil)
      )
    )
  )
  ;
  ; --- sort list by groups
  ;
  (defun translat_sortlst ()
    (princ "Sorting List By Group ...")
    (setq tmp nil)
    (foreach itm datlst
      (setq xgp (nth 0 itm))
      (setq xfr (nth 1 itm))
      (setq xto (nth 2 itm))
      (cond 
        ((= xgp "LAYER")(setq pre "1"))
        ((= xgp "COLOR")(setq pre "2"))
        ((= xgp "LINETYPE")(setq pre "3"))
        (t nil)
      )
      (setq stv (strcat pre "," xgp "," xfr "," xto))
      (setq tmp (append tmp (list stv)))
    )
    (setq tmp (acad_strlsort tmp))
    ;
    (setq datlst nil)
    (foreach itm tmp
      (setq chk (dstp_pdf2lst itm ","))
      (setq xgp (nth 1 chk))
      (setq xfr (nth 2 chk))
      (setq xto (nth 3 chk))
      (setq new (list xgp xfr xto))
      (setq datlst (append datlst (list new)))
    )
    (princ "Done.")
    (princ "\nDS> ")
    (translat_updlst)
    (translat_clrflds)
    (set_tile "lstbox" (itoa (1- (length datlst))))
    (mode_tile "gpval" 2)
    (setq tmp nil)
  )
  ;
  ; --- reverse list
  ;
  (defun translat_revlst ()
    (princ "Reversing From & To Values ...")
    (setq tmp datlst)
    (setq datlst nil)
    (foreach itm tmp
      (setq xgp (nth 0 itm))
      (setq xfr (nth 1 itm))
      (setq xto (nth 2 itm))
      (setq new (list xgp xto xfr))
      (setq datlst (append datlst (list new)))
    )
    (princ "Done.")
    (princ "\nDS> ")
    (translat_updlst)
    (translat_clrflds)
    (set_tile "lstbox" (itoa (1- (length datlst))))
    (mode_tile "gpval" 2)
    (setq tmp nil)
  )
  ;
  ; --- reset for new
  ;
  (defun translat_reset ()
    (setq curfil nil)
    (setq datlst nil)
    (setq gpval "COLOR")
    (setq frval "")
    (setq toval "")
    (translat_clrflds)
    (translat_updlst)
    (mode_tile "gpval" 2)
  )
  ;
  ; --- load data from ascii file
  ;
  (defun translat_loaddata ()
    (if (= autofile nil)
      (progn
        (if (= curfil nil)(setq curfil (strcat (getvar "DWGPREFIX") (dstp_dwgname))))
        (setq fn (dstp_getfiles "Load Translation Data" curfil "trn" 0))
      )
      (progn
        (setq fn autofile)
        (setq autofile nil)
      )
    )
    (if (/= fn nil)
      (progn
        (setq fh (open fn "r"))
        (princ "Loading File ... Open ... Reading ... ")
        (setq chk (read-line fh))
        (if (/= chk "TRN")
          (alert "File appears invalid")
          (progn
            (read-line fh)
            (read-line fh)
            (setq datlst nil)
            (translat_clrflds)
            ;
            (setq ctr (atoi (read-line fh)))
            (repeat ctr
              (setq xgp (read-line fh))
              (setq xfr (read-line fh))
              (setq xto (read-line fh))
              (setq new (list xgp xfr xto))
              (setq datlst (append datlst (list new)))
            )
          )
        ) 
        (close fh)
        (princ "Done.")
        (princ "\nDS> ")
        (setq curfil fn)
        (translat_updlst)
        (set_tile "lstbox" (itoa (1- (length datlst))))
        (mode_tile "gpval" 2)
      )
    )
  )
  ;
  ; --- merge data from ascii file
  ;
  (defun translat_mergdata ( / fn fh chk ctr)
    (setq fn (dstp_getfiles "Merge Translation Data" "" "trn" 0))
    (if (/= fn nil)
      (progn
        (setq fh (open fn "r"))
        (princ "Merging File ... Open ... Reading ... ")
        (setq chk (read-line fh))
        (if (/= chk "TRN")
          (alert "File appears invalid")
          (progn
            (read-line fh)
            (read-line fh)
            ;
            (translat_clrflds)
            (setq ctr (atoi (read-line fh)))
            (repeat ctr
              (setq xgp (read-line fh))
              (setq xfr (read-line fh))
              (setq xto (read-line fh))
              (setq new (list xgp xfr xto))
              (setq datlst (append datlst (list new)))
            )
          )
        ) 
        (close fh)
        (princ "Done.")
        (princ "\nDS> ")
        (setq curfil fn)
        (translat_updlst)
        (set_tile "lstbox" (itoa (1- (length datlst))))
        (mode_tile "gpval" 2)
      )
    )
  )
  ;
  ; --- save data to ascii file
  ;
  (defun translat_savedata ()
    (if (= curfil nil)(setq curfil (strcat (getvar "DWGPREFIX") (dstp_dwgname))))
    (setq fn (dstp_getfiles "Save Translation Data" curfil "trn" 1))
    (if (/= fn nil)
      (progn
        (setq fh (open fn "w"))
        (princ "Saving File ... Open ... Writing ... ")
        (princ "TRN" fh)
        (princ "\nTranslator Control File" fh)
        (princ "\n-----------------------" fh)
        ;
        (princ (strcat "\n" (rtos (length datlst) 2 0)) fh)
        (setq ctr 0)
        (foreach chk datlst
          (setq fld (nth 0 chk))                    ; gpval
          (princ (strcat "\n" fld) fh)
          (setq fld (nth 1 chk))                    ; frval
          (princ (strcat "\n" fld) fh)
          (setq fld (nth 2 chk))                    ; toval
          (princ (strcat "\n" fld) fh)
          (setq ctr (1+ ctr))
        ) 
        ;
        (close fh)
        (princ "Done.")
        (princ "\nDS> ")
        (setq curfil fn)
      )
    )
  )
  ;
  ; --- print data to file
  ;
  (defun translat_prntdata ()
    (if (> (length datlst) 0)
      (progn
        (setq fn (dstp_getfiles "Print Translation Data" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "txt" 1))
        (if (/= fn nil)
          (progn
            (setq fh (open fn "w"))
            (princ "Printing File ... Open ... Writing ... ")
            (princ "Translator Process File" fh)
            (princ "\n-----------------------" fh)
            (princ (strcat "\n" (rtos (length datlst) 2 0) " Items") fh)
            (princ "\n" fh)
            (princ (strcat "\n" (dstp_rpad "Group" 12) "  " (dstp_rpad "From" 31) "  " (dstp_rpad "To" 31)) fh)
            (princ (strcat "\n" "------------" "  " "-------------------------------" "  " "-------------------------------") fh)
            ;
            (setq ctr 0)
            (foreach chk datlst
              (setq xgp (nth 0 chk))
              (setq xfr (nth 1 chk))
              (setq xto (nth 2 chk))
              (princ (strcat "\n" (dstp_rpad xgp 12) "  " (dstp_rpad xfr 31) "  " (dstp_rpad xto 31)) fh)
              (setq ctr (1+ ctr))
            ) 
            ;
            (close fh)
            (princ "Done.")
            (princ "\nDS> ")
          )
        )
      )
      (alert "Nothing To Print")
    )
  )
  ;
  ; --- Begin Main Routine
  ;
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  ;
  (setq curfil nil)
  (setq datlst nil)
  (setq gpval "COLOR")
  (setq frval "")
  (setq toval "")
  (setq redo T)
  (setq doproc nil)
  (setq autoload nil)
  (setq gplst (list "COLOR" "LAYER" "LINETYPE"))
  (setq colst (list "Red" "Yellow" "Green" "Cyan" "Blue" "Magenta" "White"))
  (princ "\nDS> ")
  ;
  ; --- load and run dialog
  ;
  (if (= dstp_diasize 2)
    (setq dianam "translat2")
    (setq dianam "translat1")
  )
  (setq dcl_id (load_dialog "unsupport.dcl"))
  (setq what_next 9)
  (while (< 2 what_next)
    (if (not (new_dialog dianam dcl_id)) (exit))
    (if (= redo T)
      (progn
        (set_tile "gpval" gpval)
        (set_tile "frval" frval)
        (set_tile "toval" toval)
        (translat_updlst)
        (setq redo nil)
      )
    )
    ;
    ; --- look for filename.trn and autoload
    ;
    (if (= autoload nil)
      (progn
        (setq fnd (findfile (strcat (GetFileNameWithoutExtension (getvar "DWGNAME")) ".TRN")))
        (if (/= fnd nil)
          (progn
            (princ (strcat "AutoLoading File [" fnd "]"))
            (princ "\nDS> ")
            (setq autofile fnd)
            (translat_loaddata)
          )
          (setq autofile nil)
        )
        (setq autoload T)
      )
    )
    ;
    ; --- fill up group choices popdown
    ;
    (start_list "gpsel")
    (mapcar 'add_list gplst)
    (end_list)
    ;
    (action_tile "gpval" "(setq gpval $value)")
    (action_tile "gpsel" "(translat_dogrpsel (atoi $value))")
    (action_tile "frval" "(setq frval $value)")
    (action_tile "frsel" "(translat_doselect 1)")
    (action_tile "frent" "(setq opt 1)(done_dialog 3)")
    (action_tile "toval" "(setq toval $value)")
    (action_tile "tosel" "(translat_doselect 2)")
    (action_tile "toent" "(setq opt 2)(done_dialog 3)")
    ;
    (action_tile "lstbox" "(translat_displin)")
    ;
    (action_tile "add" "(translat_addinp)")
    (action_tile "chg" "(translat_chglin)")
    (action_tile "del" "(translat_dellin)")
    (action_tile "sort" "(translat_sortlst)")
    (action_tile "rev" "(translat_revlst)")
    (action_tile "clr" "(translat_clrflds)")
    ;
    (action_tile "accept" "(setq doproc 1)(done_dialog 2)")
    (action_tile "new" "(translat_reset)")
    (action_tile "load" "(translat_loaddata)")
    (action_tile "merg" "(translat_mergdata)")
    (action_tile "save" "(translat_savedata)")
    (action_tile "prnt" "(translat_prntdata)")
    ;
    (setq what_next (start_dialog))
    (cond 
      ((= what_next 3)
        (if (= opt 1)
          (setq pmt (strcat "SOURCE " (strcase gpval)))
          (setq pmt (strcat "TARGET " (strcase gpval)))
        )
        (setq chk (entsel (strcat "Select Object with " pmt ": ")))
        (if (/= chk nil)
          (progn
            (setq ent (entget (car chk)))
            (setq tmp (cdr (assoc 62 ent)))
            (setq lty (cdr (assoc 6 ent)))
            (setq lay (cdr (assoc 8 ent)))
            (cond 
              ((= (strcase gpval) "COLOR")
                (setq val (dstp_col2str tmp))
                (if (= opt 1)
                  (setq frval val)
                  (setq toval val)
                )
              )
              ((= (strcase gpval) "LINETYPE")
                (if (= opt 1)
                  (setq frval lty)
                  (setq toval lty)
                )
              )
              ((= (strcase gpval) "LAYER")
                (if (= opt 1)
                  (setq frval lay)
                  (setq toval lay)
                )
              )
              (t nil)
            )
            (setq redo T)
          )
        )
        (princ "\nDS> ")
      )
      (t nil)
    )
  )
  (unload_dialog dcl_id)
  ;
  ; --- If accepted, do processing
  ;
  (if (= doproc 1)
    (progn
      (princ "Preparing to Process Data")
      (if (> (length datlst) 0)
        (progn
          (setq sset (ssget))
          (setq num (sslength sset))
          (setq itm 0)
          (if sset 
            (progn
              (princ "\nDS> Processing Entities ... ")
              (while (< itm num)
                (setq chg nil)
                (setq ncol nil nlay nil nltp nil)
                (setq ccol nil clay nil cltp nil)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq ltp (cdr (assoc 6 ent)))
                (setq lay (cdr (assoc 8 ent)))
                (setq col (cdr (assoc 62 ent)))
                ;
                (setq fnd nil ctr 0 done nil)
                (while (= done nil)
                  (setq chk (nth ctr datlst))
                  (setq xgp (nth 0 chk))
                  (setq xfr (nth 1 chk))
                  (setq xto (nth 2 chk))
                  (cond
                    ((= xgp "COLOR")
                      (if (= xfr (dstp_col2str col))
                        (progn
                          (setq ncol (dstp_str2col xto))
                          (setq chg T)
                          (setq ccol T)
                        )
                      )
                    )
                    ((= xgp "LAYER")
                      (if (= xfr lay)
                        (progn
                          (setq nlay xto)
                          (setq chg T)
                          (setq clay T)
                        )
                      )
                    )
                    ((= xgp "LINETYPE")
                      (if (= xfr ltp)
                        (progn
                          (setq nltp xto)
                          (setq chg T)
                          (setq cltp T)
                        )
                      )
                    )
                  )
                  (setq ctr (1+ ctr))
                  (if (= ctr (length datlst))(setq done T))
                )
                ;
                (if (= chg T)
                  (progn
                    (if (= ccol T)
                      (progn
                        (if (= col nil)
                          (setq ent (append ent (list (cons 62 ncol))))
                          (setq ent (subst (cons 62 ncol)(assoc 62 ent) ent))
                        )
                      )
                    )
                    (if (= clay T)
                      (setq ent (subst (cons 8 nlay)(assoc 8 ent) ent))
                    )
                    (if (= cltp T)
                      (progn
                        (if (= ltp nil)
                          (setq ent (append ent (list (cons 6 ncol))))
                          (setq ent (subst (cons 6 nltp)(assoc 6 ent) ent))
                        )
                      )
                    )
                    (entmod ent)
                  )
                )
                (setq itm (1+ itm))
              )
            )
          )
          (princ "Done.")
        )
      )
    )
    (princ "Exiting Routine")
  )
  (setq sset nil)
  (setq datlst nil)
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                       Generate Text along Object
; --------------------------------------------------------------------------

(defun c:LegTxtAlo (/ abl ali ang axo beg chk chw cmdecho ctr dis done
                         eed end ent entlst fnd fst gen hdl hnd hndlst let
                         lst nam new obj ofa ofs org osmode pik pnt rec res
                         rev siz spc std stp str sty tmp tot)
      (defun txtonobj_make ()
        (setq ctr 1)
        (setq lst nil)
        (repeat (strlen str)
          (setq lst (append lst (list (substr str ctr 1))))
          (setq ctr (1+ ctr))
        )
        (setq hndlst (ssadd))
        (setq entlst nil)
        (setq beg (vlax-curve-getStartPoint axo))
        (setq end (vlax-curve-getEndPoint axo))
        (setq tot (vlax-curve-getDistAtPoint axo end))
        (setq std (vlax-curve-getDistAtPoint axo stp))
        (setq fst "")
        (setq dis std)
        (foreach let lst
          (setq pnt (vlax-curve-getPointAtDist axo dis))
          (if (= rev 0)
            (setq ali (vlax-curve-getPointAtDist axo (+ dis (* siz 0.75))))
            (setq ali (vlax-curve-getPointAtDist axo (- dis (* siz 0.75))))
          )
          (if (and (/= pnt nil)(/= ali nil))
            (progn
              (setq ang (angle pnt ali))
              (if (= gen 0)
                (progn
                  (setq ofa (+ ang (/ pi 2.0)))
                  (setq pnt (polar pnt ofa ofs))
                )
                (progn
                  (setq ofa (- ang (/ pi 2.0)))
                  (setq pnt (polar pnt ofa (+ siz ofs)))
                )
              )
              (setq new '((0 . "TEXT")))
              (setq new (append new (list (cons 1 let))))
              (setq new (append new (list (cons 7 sty))))
              (setq new (append new (list (list 10 (nth 0 pnt) (nth 1 pnt) (nth 2 pnt)))))
              (setq new (append new (list (cons 40 siz))))
              (setq new (append new (list (cons 50 ang))))
              (entmake new)
              (setq hnd (entlast))
              (setq ent (entget hnd))
              (setq hndlst (ssadd hnd hndlst))
              (setq entlst (append entlst (list ent)))
              (if (= let " ")
                (setq chw (* siz 0.65))
                (setq chw (dstp_textwidth new))
              )
              (if (= rev 0)
                (setq dis (+ dis chw (* siz spc)))
                (setq dis (- dis chw (* siz spc)))
              )
            )
            (setq fst (strcat fst let))
          )
        )
        (entmake (list (cons 0 "BLOCK")(cons 2 "*U")(cons 70 1)(cons 10 stp)))
        (foreach rec entlst
          (entmake rec)
        )
        (setq abl (entmake '((0 . "ENDBLK"))))
        (if (null (tblsearch "APPID" "DSTP_TXTONOBJ"))
          (regapp "DSTP_TXTONOBJ")
        )
        (setq eed (list "DSTP_TXTONOBJ"))
        (setq eed (append eed (list (cons 1005 hdl))))
        (setq eed (append eed (list (cons 1040 std))))
        (setq eed (append eed (list (cons 1000 sty))))
        (setq eed (append eed (list (cons 1040 siz))))
        (setq eed (append eed (list (cons 1040 ofs))))
        (setq eed (append eed (list (cons 1040 spc))))
        (setq eed (append eed (list (cons 1070 rev))))
        (setq eed (append eed (list (cons 1070 gen))))
        (entmake (list (cons 0 "INSERT")(cons 2 abl)(cons 66 0)(cons 10 stp)(list -3 eed)))
        (command "_.ERASE" hndlst "")
        (setq hndlst nil)
        (setq entlst nil)
      )
      (defun txtonobj_read ()
        (setq ent (entget hnd '("DSTP_TXTONOBJ")))
        (setq chk (assoc -3 ent))
        (setq lst (cdr (nth 0 (cdr chk))))
        (setq hdl (cdr (nth 0 lst)))
        (setq std (cdr (nth 1 lst)))
        (setq sty (cdr (nth 2 lst)))
        (setq siz (cdr (nth 3 lst)))
        (setq ofs (cdr (nth 4 lst)))
        (setq spc (cdr (nth 5 lst)))
        (setq rev (cdr (nth 6 lst)))
        (setq gen (cdr (nth 7 lst)))
        (setq fnd nil)
        (setq nam (cdr (assoc 2 ent)))
        (setq rec (tblnext "BLOCK" T))
        (while (/= rec nil)
          (setq chk (cdr (assoc 2 rec)))
          (if (= (strcase nam)(strcase chk))
            (progn
              (setq hnd (cdr (assoc -2 rec)))
              (setq fnd T)
            )
          )
          (if (= fnd T)
            (setq rec nil)
            (setq rec (tblnext "BLOCK"))
          )
        )
        (setq str "")
        (setq done nil)
        (while (/= done T)
          (setq ent (entget hnd))
          (if (= (cdr (assoc 0 ent)) "TEXT")
            (progn
              (setq let (cdr (assoc 1 ent)))
              (setq str (strcat str let))
            )
          )
          (if (= (setq hnd (entnext (cdr (assoc -1 ent)))) nil)
            (setq done T)
          )
        )
      )
      (setq pik (entsel "\nDS> Select Existing Text or Linear Object at Start Point: "))
      (if (/= pik nil)
        (progn
          (setq hnd (car pik))
          (setq ent (entget hnd))
          (setq axo (vlax-ename->vla-object hnd))
          (setq obj (cdr (assoc 0 ent)))
          (cond
            ((= obj "INSERT")
              (setq org hnd)
              (setq stp (cdr (assoc 10 ent)))
              (txtonobj_read)
              (setq hnd (handent hdl))
              (if (/= hnd nil)
                (progn
                  (setq ent (entget hnd))
                  (if (/= ent nil)
                    (progn
                      (setq axo (vlax-ename->vla-object hnd))
                      (setq hdl (cdr (assoc 5 ent)))
                      (setq osmode (getvar "OSMODE"))
                      (setvar "OSMODE" 512)
                      (dstp_marker stp)
                      (setq tmp (getpoint "\nDS> Starting Point: "))
                      (dstp_marker stp)
                      (if (/= tmp nil)
                        (setq stp (osnap tmp "_nea"))
                      )
                      (setvar "OSMODE" osmode)
                      (setq tmp (getstring (strcat "\nDS> Text Style <" sty ">: ")))
                      (if (/= tmp "")(setq sty tmp))
                      (setq tmp (getdist (strcat "\nDS> Text Height <" (rtos siz) ">: ")))
                      (if (/= tmp nil)(setq siz tmp))
                      (setq tmp (getdist (strcat "\nDS> Offset Distance <" (rtos ofs) ">: ")))
                      (if (/= tmp nil)(setq ofs tmp))
                      (setq tmp (getreal (strcat "\nDS> Spacing Factor <" (rtos spc) ">: ")))
                      (if (/= tmp nil)(setq spc tmp))
                      (if (= rev 0)
                        (progn
                          (initget "Y N")
                          (setq tmp (getkword "\nDS> Reverse Reading Y/<N>: "))
                          (if (/= tmp "Y")(setq rev 0)(setq rev 1))
                        )
                        (progn
                          (initget "Y N")
                          (setq tmp (getkword "\nDS> Reverse Reading <Y>/N: "))
                          (if (/= tmp "N")(setq rev 1)(setq rev 0))
                        )
                      )
                      (if (= gen 0)
                        (progn
                          (initget "T B")
                          (setq tmp (getkword "\nDS> Generate on <Top>/Bottom: "))
                          (if (/= tmp "B")(setq gen 0)(setq gen 1))
                        )
                        (progn
                          (initget "T B")
                          (setq tmp (getkword "\nDS> Generate on Top/<Bottom>: "))
                          (if (/= tmp "T")(setq gen 1)(setq gen 0))
                        )
                      )
                      (setq str (dstp_textedit str))
                      (setq str (dstp_subtext str "\r\n" "  "))
                      (if (/= str "")
                        (progn
                          (entdel org)
                          (setq cmdecho (getvar "CMDECHO"))
                          (setvar "CMDECHO" 0)
                          (command "_.UNDO" "_G")
                          (dstp_ucspush)
                          (princ "\nDS> Generating Text Along Object ...\rDS> Generating Text Along Object ...")
                          (txtonobj_make)
                          (princ " Done.")
                          (if (/= fst "")
                            (princ (strcat "\nDS> WARNING: The following fragment was not generated:\n" (chr 34) fst (chr 34)))
                          )
                          (dstp_ucspop)
                          (command "_.UNDO" "_E")
                          (setvar "CMDECHO" cmdecho)
                        )
                      )
                    )
                    (progn
                      (princ "\nDS> Original object appears missing!")
                      (setq res (dstp_clipbrdpoke str))
                      (if (/= res nil)
                        (princ "\nDS> Text contents copied to Windows Clipboard!")
                      )
                    )
                  )
                )
              )
            )
            ((or (= obj "ARC")(= obj "LINE")(= obj "ELLIPSE")(= obj "LWPOLYLINE")(= obj "POLYLINE")(= obj "SPLINE"))
              (if (= (vlax-curve-isPlanar axo))
                (progn
                  (setq hdl (cdr (assoc 5 ent)))
                  (setq stp (osnap (cadr pik) "_nea"))
                  (setq sty (getvar "TEXTSTYLE"))
                  (setq tmp (getstring (strcat "\nDS> Text Style <" sty ">: ")))
                  (if (/= tmp "")(setq sty tmp))
                  (setq siz (dstp_textsize))
                  (setq tmp (getdist (strcat "\nDS> Text Height <" (rtos siz) ">: ")))
                  (if (/= tmp nil)(setq siz tmp))
                  (setq ofs (* siz 0.25))
                  (setq tmp (getdist (strcat "\nDS> Offset Distance <" (rtos ofs) ">: ")))
                  (if (/= tmp nil)(setq ofs tmp))
                  (setq spc 0.30)
                  (setq tmp (getreal (strcat "\nDS> Spacing Factor <" (rtos spc) ">: ")))
                  (if (/= tmp nil)(setq spc tmp))
                  (initget "Y N")
                  (setq tmp (getkword "\nDS> Reverse Reading Y/<N>: "))
                  (if (/= tmp "Y")(setq rev 0)(setq rev 1))
                  (initget "T B")
                  (setq tmp (getkword "\nDS> Generate on <Top>/Bottom: "))
                  (if (/= tmp "B")(setq gen 0)(setq gen 1))
                  (setq str (dstp_textedit ""))
                  (setq str (dstp_subtext str "\r\n" "  "))
                  (if (/= str "")
                    (progn
                      (setq cmdecho (getvar "CMDECHO"))
                      (setvar "CMDECHO" 0)
                      (command "_.UNDO" "_G")
                      (dstp_ucspush)
                      (princ "\nDS> Generating Text Along Object ...\rDS> Generating Text Along Object ...")
                      (txtonobj_make)
                      (princ " Done.")
                      (if (/= fst "")
                        (princ (strcat "\nDS> WARNING: The following fragment was not generated:\n" (chr 34) fst (chr 34)))
                      )
                      (dstp_ucspop)
                      (command "_.UNDO" "_E")
                      (setvar "CMDECHO" cmdecho)
                    )
                  )
                )
                (princ "\nDS> NonPlanar Objects not Supported!")
              )
            )
            (t
              (princ "\nDS> Object Type not Supported!")
            )
          )
        )
      )
  (princ)
)

; --------------------------------------------------------------------------
;                     Break A Line Of Text into columns
; --------------------------------------------------------------------------

(defun c:LegTxtCol (/ ang chk cmdecho dis ent hnd itm lst num osmode pnt
                         rect spt sset str tmp tot)
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq osmode (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (setq sset (ssget "_I" '((0 . "TEXT"))))
      (if (= sset nil)
        (setq sset (ssget '((0 . "TEXT"))))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq num (sslength sset) itm 0)
      (if sset
        (progn
          (setq tmp (* (getvar "TEXTSIZE") 6.0))
          (setq chk (getdist (strcat "\nDS> Distance Between Columns <" (rtos tmp) ">: ")))
          (if (/= chk nil)(setq dis chk)(setq dis tmp))
          (princ "\nDS>")
          (while (< itm num)
            (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
            (setq hnd (ssname sset itm))
            (setq ent (entget hnd))
            (setq str (cdr (assoc 1 ent)))
            (setq lst (dstp_pdf2lst str " "))
            (setq rect (dstp_textrect ent))
            (setq spt (car rect))
            (setq ang (angle (car rect)(cadr rect)))
            (setq tot 0.0)
            (setq ent (subst (cons 1 ">")(assoc 1 ent) ent))
            (entmod ent)
            (foreach str lst
              (if (/= str "")
                (progn
                  (setq pnt (polar spt ang tot))
                  (command "_.COPY" hnd "" spt pnt)
                  (setq tmp (entget (entlast)))
                  (setq tmp (subst (cons 1 str)(assoc 1 tmp) tmp))
                  (entmod tmp)
                  (setq tot (+ tot dis))
                )
              )
            )
            (entdel hnd)
            (setq itm (1+ itm))
          )
        )
      )
      (princ ", Done.")
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "OSMODE" osmode)
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                      Text Acquire Properties w/Dialog
; --------------------------------------------------------------------------

(defun c:LegTxtPrp ( / bent bitm cmdecho dcl_id done doproc txtali
                         txtbnu txthgt txtobl txtrot txtsty txtwid
                         ent hnd itm num sset tmp)
  (defun txtacqpr_setflds ()
    (set_tile "txthgt" (itoa txthgt))
    (set_tile "txtwid" (itoa txtwid))
    (set_tile "txtrot" (itoa txtrot))
    (set_tile "txtobl" (itoa txtobl))
    (set_tile "txtsty" (itoa txtsty))
    (set_tile "txtali" (itoa txtali))
    (set_tile "txtbnu" (itoa txtbnu))
  )
  ;
  (defun txtacqpr_getflds ()
    (setq txthgt (atoi (get_tile "txthgt")))
    (setq txtwid (atoi (get_tile "txtwid")))
    (setq txtrot (atoi (get_tile "txtrot")))
    (setq txtobl (atoi (get_tile "txtobl")))
    (setq txtsty (atoi (get_tile "txtsty")))
    (setq txtali (atoi (get_tile "txtali")))
    (setq txtbnu (atoi (get_tile "txtbnu")))
  )
  ;
  (defun txtacqpr_doparms ()
    (if (< (setq dcl_id (load_dialog "UNSUPPORT.DCL")) 0) (exit))
    (if (not (new_dialog "txtacqpr" dcl_id)) (exit))
    (txtacqpr_setflds)
    (action_tile "cancel" "(setq doproc nil)(done_dialog 0)")
    (action_tile "accept" "(setq doproc T)(txtacqpr_getflds)(done_dialog 1)")
    (start_dialog)
    (princ)
    (unload_dialog dcl_id)
  )
  ;
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (setq doproc T)
  (setq txthgt 1)
  (setq txtwid 1)
  (setq txtrot 1)
  (setq txtobl 1)
  (setq txtsty 1)
  (setq txtali 1)
  (setq txtbnu 1)
  ;
  (setq done nil)
  (while (/= done T)
    (initget "S")
    (setq tmp (entsel "\nDS> Settings/Pick Source Text: "))
    (if (= tmp "S")
      (txtacqpr_doparms)
      (setq done T)
    )
  )  
  ;
  (if (and (= doproc T)(/= tmp nil))
    (progn
      (setq bitm (car tmp))
      (setq bent (entget bitm))
      (if (= "TEXT" (cdr (assoc 0 bent)))
        (progn
          (princ "\nDS> Select Target Text: ")
          (setq sset (ssget '((0 . "TEXT"))))
          (if sset
            (progn
              (setq itm 0)
              (setq num (sslength sset))
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                ;
                (if (= txthgt 1)
                  (setq ent (subst (cons 40 (cdr (assoc 40 bent)))(assoc 40 ent) ent))
                )
                (if (= txtwid 1)
                  (setq ent (subst (cons 41 (cdr (assoc 41 bent)))(assoc 41 ent) ent))
                )
                (if (= txtrot 1)
                  (setq ent (subst (cons 50 (cdr (assoc 50 bent)))(assoc 50 ent) ent))
                )
                (if (= txtobl 1)
                  (setq ent (subst (cons 51 (cdr (assoc 51 bent)))(assoc 51 ent) ent))
                )
                (if (= txtsty 1)
                  (setq ent (subst (cons 7 (cdr (assoc 7 bent)))(assoc 7 ent) ent))
                )
                (if (= txtbnu 1)
                  (setq ent (subst (cons 71 (cdr (assoc 71 bent)))(assoc 71 ent) ent))
                )
                (if (= txtali 1)
                  (progn
                    (if (or (> (cdr (assoc 72 ent)) 0)(> (cdr (assoc 73 ent)) 0))
                      (setq ent (subst (cons 10 (cdr (assoc 11 ent)))(assoc 10 ent) ent))
                      (setq ent (subst (cons 11 (cdr (assoc 10 ent)))(assoc 11 ent) ent))
                    )
                    (setq ent (subst (cons 72 (cdr (assoc 72 bent)))(assoc 72 ent) ent))
                    (setq ent (subst (cons 73 (cdr (assoc 73 bent)))(assoc 73 ent) ent))
                  )
                )
                ;
                (entmod ent)
                (setq itm (1+ itm))
              )
            )
          )
        )
      )
    )
  )
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                         Text Group Processes
; --------------------------------------------------------------------------

(defun c:LegTxtRom () (dstp_legtxtgrp "rm"))
(defun dstp_legtxtgrp (opt / cmdecho cp cr cs dec ent hnd itm lst nr ns num
                          nw oa p1 p3 pass pnts pre ra red sf sset suf tgf
                          tmp val)
  (setq sset (ssget "_I" '((0 . "TEXT"))))
  (if (= sset nil)
    (setq sset (ssget '((0 . "TEXT"))))
  )
  (if sset
    (progn
      (setq cmdecho (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq chk (dstp_ssremlok sset))
      (if (> (cadr chk) 0)
        (progn
          (setq sset (car chk))
          (sssetfirst sset sset)
          (princ (strcat "\nDS> " (itoa (cadr chk)) " Locked Object(s) Removed"))
        )
      )
      (cond 
        ((= opt "xh")
          (setq sf (getreal "\nDS> Scale Factor: "))
          (if (= sf nil)(exit))
        )
        ((= opt "sh")
          (setq ns (getreal "\nDS> New Text Size: "))
          (if (= ns nil)(exit))
        )
        ((= opt "sw")
          (setq nw (getreal "\nDS> New Width Factor: "))
          (if (= nw nil)(exit))
        )
        ((= opt "ra")
          (setq ra (getreal "\nDS> Absolute Rotation Angle: "))
          (if (= ra nil)(exit))
        )
        ((= opt "rm")
          (setq ra (getreal "\nDS> Rotation Angle <180.0>: "))
          (if (= ra nil)(setq ra 180.0))
        )
        ((= opt "rr")
          (setq ra (getreal "\nDS> Relative Rotation Angle: "))
          (if (= ra nil)(exit))
        )
        ((= opt "oa")
          (setq oa (getreal "\nDS> New Oblique Angle: "))
          (if (= oa nil)(exit))
        )
        ((= opt "ss")
          (setq ns (dstp_tablesel "Select Desired Style" (acad_strlsort (dstp_bldlst "STYLE")) "s" ""))
          (if (= ns nil)(exit))
        )
        ((= opt "ps")
          (setq chk (getstring (strcat "\nDS> Pad Characters <" (chr 34) " " (chr 34) ">") t))
          (if (/= chk "")(setq ps chk)(setq ps " "))
          (initget "Y N")
          (setq chk (getkword "\nDS> Pad Beginning/Ends Y/<N>: "))
          (if (= chk "Y")(setq pe T)(setq pe nil))
        )
        (t nil)
      )
      (setq itm 0)
      (setq num (sslength sset))
      (while (< itm num)
        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (setq hnd (ssname sset itm))
        (setq ent (entget hnd))
        (if (= "TEXT" (cdr (assoc 0 ent))) 
          (progn
            (cond 
              ((= opt "xh")
                (setq cs (cdr (assoc 40 ent)))
                (setq ns (* cs sf))
                (setq ent (subst (cons 40 ns)(assoc 40 ent) ent))
                (entmod ent)
              )
              ((= opt "sh")
                (setq ent (subst (cons 40 ns)(assoc 40 ent) ent))
                (entmod ent)
              )
              ((= opt "sw")
                (setq ent (subst (cons 41 nw)(assoc 41 ent) ent))
                (entmod ent)
              )
              ((= opt "ra")
                (setq nr (dstp_dtr ra))
                (setq ent (subst (cons 50 nr)(assoc 50 ent) ent))
                (entmod ent)
              )
              ((= opt "rm")
                (setq pnts (dstp_textrect ent))
                (setq p1 (nth 0 pnts))
                (setq p3 (nth 2 pnts))
                (setq cp (polar p1 (angle p1 p3) (/ (distance p1 p3) 2.0)))
                (command "_.ROTATE" hnd "" cp ra)
              )
              ((= opt "rr")
                (setq cr (cdr (assoc 50 ent)))
                (setq nr (- cr (dstp_dtr ra)))
                (setq ent (subst (cons 50 nr)(assoc 50 ent) ent))
                (entmod ent)
              )
              ((= opt "oa")
                (setq ent (subst (cons 51 (dstp_dtr oa))(assoc 51 ent) ent))
                (entmod ent)
              )
              ((= opt "ss")
                (setq ent (subst (cons 7 ns)(assoc 7 ent) ent))
                (entmod ent)
              )
              ((= opt "b0")
                (setq tgf (cdr (assoc 71 ent)))
                (if (= (boole 1 tgf 2) 2)
                  (progn
                    (setq tgf (- tgf 2))
                    (setq ent (subst (cons 71 tgf)(assoc 71 ent) ent))
                    (entmod ent)
                  )
                )
              )
              ((= opt "b1")
                (setq tgf (cdr (assoc 71 ent)))
                (if (/= (boole 1 tgf 2) 2)
                  (progn
                    (setq tgf (+ tgf 2))
                    (setq ent (subst (cons 71 tgf)(assoc 71 ent) ent))
                    (entmod ent)
                  )
                )
              )
              ((= opt "u0")
                (setq tgf (cdr (assoc 71 ent)))
                (if (= (boole 1 tgf 4) 4)
                  (progn
                    (setq tgf (- tgf 4))
                    (setq ent (subst (cons 71 tgf)(assoc 71 ent) ent))
                    (entmod ent)
                  )
                )
              )
              ((= opt "u1")
                (setq tgf (cdr (assoc 71 ent)))
                (if (/= (boole 1 tgf 4) 4)
                  (progn
                    (setq tgf (+ tgf 4))
                    (setq ent (subst (cons 71 tgf)(assoc 71 ent) ent))
                    (entmod ent)
                  )
                )
              )
              ((= opt "ps")
                (setq str (cdr (assoc 1 ent)))
                (if (= pe T)
                  (setq new ps)
                  (setq new "")
                )
                (setq ctr 1)
                (setq tot (strlen str))
                (repeat tot
                  (setq tmp (substr str ctr 1))
                  (if (< ctr tot)
                    (setq new (strcat new tmp ps))
                    (if (= pe T)
                      (setq new (strcat new tmp ps))
                      (setq new (strcat new tmp))
                    )
                  )
                  (setq ctr (1+ ctr))
                )
                (setq ent (subst (cons 1 new)(assoc 1 ent) ent))
                (entmod ent)
              )
              (t nil)
            )
          )
        )
        (setq itm (1+ itm))
      )
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (setvar "CMDECHO" cmdecho)
      (princ ", Done.")      
      (setq sset nil)
    )
  )
  (princ)
)

; ----------------------------------------------------------------------
;                          Text Value Copy
; ----------------------------------------------------------------------

(defun c:LegTxtCpy (/ bent bitm cmdecho ent hnd itm num sset)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (setq bitm (car (entsel "\nDS> Pick Source Text: ")))
  (if (/= bitm nil)
    (progn
      (setq bent (entget bitm))
      (if (= "TEXT" (cdr (assoc 0 bent))) 
        (progn
          (princ "\nDS> Select Target Text: ")
          (setq sset (ssget '((0 . "TEXT"))))
          (if sset
            (progn
              (setq itm 0)
              (setq num (sslength sset))
              (princ "\nDS>")
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq ent (subst (cons 1 (cdr (assoc 1 bent)))(assoc 1 ent) ent))
                (entmod ent)
                (setq itm (1+ itm))
              )
            )
          )
        )
      )
    )
  )
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                            Export Text to File
; --------------------------------------------------------------------------

(defun c:LegTxtExp ( / cds chk cin cmdecho cnt crd dis dmx ent fent fh
                         fhnd fn fnd hnd hub itm lhnd lst nlst num ord osmode
                         pnt pnt2d pos pt1 pt2 pt3 pt4 pt5 pt6 pts quo rec
                         slst spc sset str stv tmp txt xlst xset xst xvl ysrc
                         yst yvl)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  ;
  (setq sset (ssget "_I" '((-4 . "<OR")(0 . "TEXT")(0 . "MTEXT")(-4 . "OR>"))))
  (if (= sset nil)
    (setq sset (ssget '((-4 . "<OR")(0 . "TEXT")(0 . "MTEXT")(-4 . "OR>"))))
  )
  (if sset
    (progn
      (setq itm 0)
      (setq num (sslength sset))
      (setq fn (dstp_getfiles "Text Export File" (strcat (getvar "DWGPREFIX") (dstp_dwgname)) "csv;asc;txt" 1))
      (if (/= fn nil)
        (progn
          (initget "T A N")
          (setq tmp (strcase (getstring "\nDS> Columns/TopDown/Across/<Normal>: ")))
          (if (= tmp "")(setq ord "N")(setq ord tmp))
          (cond
            ((= ord "C")
              (setq tmp (getstring "\nDS> Separator between horizontal words <none>: " T))
              (setq spc tmp)
              (setq lst nil)
              (princ "\nDS> Preparing List ...\rDS> Preparing List ...")
              (while (< itm num)
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq str (cdr (assoc 1 ent)))
                (setq xvl (cadr (assoc 10 ent)))
                (setq yvl (caddr (assoc 10 ent)))
                (setq tmp (strcat "000000000000" (rtos (- 99999999.9 xvl) 2 4) "000000000000"))
                (setq pos (vl-string-search "." tmp))
                (setq xst (strcat (substr tmp (- pos 9) 10)(substr tmp (+ pos 2) 10)))
                (setq tmp (strcat "000000000000" (rtos yvl 2 4) "000000000000"))
                (setq pos (vl-string-search "." tmp))
                (setq yst (strcat (substr tmp (- pos 9) 10)(substr tmp (+ pos 2) 10)))
                (setq crd (strcat yst xst))
                (setq rec (list crd yvl str))
                (setq lst (cons rec lst))
                (setq itm (1+ itm))
              )
              (princ " Done.")
              ;
              (princ "\nDS> Sorting List ...\rDS> Sorting List ...")
              (setq lst (vl-sort lst (function (lambda (e1 e2)(> (car e1)(car e2))))))
              (princ " Done.")
              ;
              (princ "\nDS> Writing File ...\rDS> Writing File ...")
              (setq yvl (cadr (car lst)))
              (setq fh (open fn "w"))
              (foreach rec lst
                (setq chk (cadr rec))
                (setq str (caddr rec))
                (if (not (equal chk yvl 0.0001))
                  (progn
                    (princ "\n" fh)
                    (setq yvl chk)
                  )
                )
                (princ str fh)
                (princ spc fh)
              )
              (close fh)
              (princ " Done.")
              (setq lst nil)
            )
            ((= ord "N")
              (princ "\nDS>")
              (setq fh (open fn "w"))
              (while (< itm num)
                (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq stv (cdr (assoc 1 ent)))
                (princ (strcat stv "\n") fh)
                (setq itm (1+ itm))
              )
              (close fh)
              (princ ", Done.")
            )
            ((= ord "T")
              (setq nlst nil)
              (setq slst nil)
              (while (< itm num)
                (princ (strcat "\rDS> Evaluating Object " (itoa (1+ itm)) " of " (itoa num)))
                (setq hnd (ssname sset itm))
                (setq ent (entget hnd))
                (setq slst (append slst (list (list (cdr (assoc 10 ent)) (cdr (assoc 1 ent))))))
                (setq itm (1+ itm))
              )
              (if (> (length slst) 0)
                (while (> (length slst) 0)
                  (setq fnd nil)
                  (setq ysrc -9999999999.99)
                  (foreach rec slst
                    (if (> (cadr (car rec)) ysrc)
                      (progn
                        (setq fnd rec)
                        (setq ysrc (cadr (car rec)))
                      )
                    )
                  )
                  (if (/= fnd nil)
                    (progn
                      (setq slst (dstp_remove fnd slst))
                      (setq nlst (append nlst (list (cadr fnd))))
                    )
                  )
                )
              )
              (setq cnt 0)
              (princ "\nDS>")
              (setq fh (open fn "w"))
              (foreach rec nlst
                (princ (strcat "\rDS> Processing Object " (itoa (1+ cnt)) " of " (itoa num)))
                (princ (strcat rec "\n") fh)
                (setq cnt (+ cnt 1))
              )
              (close fh)
              (princ ", Done.")
            )
            ((= ord "A")
              (setq osmode (getvar "OSMODE"))
              (setvar "OSMODE" 0)
              (setq tmp (getstring "\nDS> Separator between horizontal words <none>: " T))
              ;(if (= tmp "")(setq spc "\t")(setq spc tmp))
              (setq spc tmp)
              (initget "Y N")
              (setq tmp (getkword "\nDS> Enclose text with quotation marks Y/<N>: "))
              (if (= tmp "Y")(setq quo T)(setq quo nil))
              ;
              (setq fh (open fn "w"))
              (if (/= fh nil)
                (progn
                  (princ "\nDS> Please Wait ...\rDS> Please Wait ...")
                  (setq chk (entget (ssname sset 0)))
                  (setq pts (dstp_textrect chk))
                  (setq pt1 (dstp_2dpoint (nth 0 pts)))
                  (setq pt2 (dstp_2dpoint (nth 1 pts)))
                  (setq pt3 (dstp_2dpoint (nth 2 pts)))
                  (setq pt4 (dstp_2dpoint (nth 3 pts)))
                  (setq pt5 (polar pt1 (angle pt1 pt4)(distance pt1 pt2)))
                  (setq hub (polar pt5 (angle pt2 pt5)(* (distance pt1 pt4) 4500.0)))
                  (setq dmx (* (distance pt1 pt4) 5000.0))
                  (princ (strcat "\rDS> " (itoa (sslength sset)) " Objects Remaining    "))
                  (while (> (sslength sset) 0)
                    (setq fhnd nil)
                    (setq num (sslength sset) itm 0)
                    (setq dis dmx)
                    (while (< itm num)
                      (setq hnd (ssname sset itm))
                      (setq ent (entget hnd))
                      (setq chk (distance hub (list (cadr (assoc 10 ent)) (caddr (assoc 10 ent)))))
                      (if (< chk dis)
                        (progn
                          (setq fhnd hnd)
                          (setq dis chk)
                        )
                      )
                      (setq itm (1+ itm))
                    )
                    ;
                    (if (/= fhnd nil)
                      (progn
                        (setq fent (entget fhnd))
                        (setq pts (dstp_textrect fent))
                        (setq pt1 (dstp_2dpoint (nth 0 pts)))
                        (setq pt2 (dstp_2dpoint (nth 1 pts)))
                        (setq pt3 (dstp_2dpoint (nth 2 pts)))
                        (setq pt4 (dstp_2dpoint (nth 3 pts)))
                        (setq pt5 (polar pt2 (angle pt1 pt2)(* (distance pt2 pt3) 0.05)))
                        (setq pt6 (polar pt3 (angle pt4 pt3)(* (distance pt2 pt3) 2000.0)))
                        (setq xset (ssget "_C" pt5 pt6 '((0 . "TEXT"))))
                        (if (member fhnd (dstp_ss2lst xset))
                          (setq xset (ssdel fhnd xset))
                        )
                        (command "_.LINE" pt5 pt6 "")
                        (setq lhnd (entlast))
                        (if xset
                          (progn
                            (setq str (cdr (assoc 1 fent)))
                            (if (= quo T)
                              (setq str (strcat (chr 34) str (chr 34)))
                            )
                            (setq pnt (cdr (assoc 10 fent)))
                            (setq pnt2d (dstp_2dpoint pnt))
                            (setq sset (ssdel fhnd sset))
                            ;
                            (setq xlst nil)
                            (setq num (sslength xset) itm 0)
                            (while (< itm num)
                              (setq hnd (ssname xset itm))
                              (setq ent (entget hnd))
                              (setq txt (cdr (assoc 1 ent)))
                              (setq cin (dstp_2dpoint (cdr (assoc 10 ent))))
                              (setq xlst (cons (list cin txt) xlst))
                              (if (ssmemb hnd sset)
                                (setq sset (ssdel hnd sset))
                              )
                              (setq itm (1+ itm))
                            )
                            ;
                            (while (> (length xlst) 0)
                              (setq fnd nil)
                              (setq dis 9999999999.99)
                              (foreach itm xlst
                                (setq pnt (nth 0 itm))
                                (setq cds (distance pnt2d pnt))
                                (if (< cds dis)
                                  (setq dis cds fnd itm)
                                )
                              )
                              (if (/= fnd nil)
                                (progn
                                  (setq xlst (dstp_remove fnd xlst))
                                  (setq txt (nth 1 fnd))
                                  (if (= quo T)
                                    (setq txt (strcat (chr 34) txt (chr 34)))
                                  )
                                  (setq str (strcat str spc txt))
                                  (setq fnd nil)
                                )
                              )
                            )
                            (princ (strcat str "\n") fh)
                          )
                        )
                        (entdel lhnd)
                      )
                    )
                    (princ (strcat "\rDS> " (itoa (sslength sset)) " Objects Remaining    "))
                  )
                  (setvar "OSMODE" osmode)
                  (close fh)
                  (princ "\rDS> 0 Objects Remaining, Done.      ")
                )
                (alert "Error Opening Output File!")
              )
            )
            (t nil)
          )
        )
      )
    )
  )
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                        Swap Strings of Text
; --------------------------------------------------------------------------

(defun c:LegTxtSwp ( / cmdecho tmp ent1 str1 ent2 str2)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (setq tmp (car (entsel "\nDS> Pick 1st String: ")))
  (setq ent1 (entget tmp))
  (if (= "TEXT" (cdr (assoc 0 ent1))) 
    (progn
      (setq str1 (cdr (assoc 1 ent1)))
      (setq tmp (car (entsel "\nDS> Pick 2nd String: ")))
      (if (/= tmp nil)
        (progn
          (setq ent2 (entget tmp))
          (if (or (/= ent2 nil) (/= "TEXT" (cdr (assoc 0 ent2))))
            (progn
              (setq str2 (cdr (assoc 1 ent2)))
              (setq ent1 (subst (cons 1 str2)(assoc 1 ent1) ent1))
              (setq ent2 (subst (cons 1 str1)(assoc 1 ent2) ent2))
              (entmod ent1)
              (entmod ent2)
            )
          )
        )
      )
    )
  )
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                       Trim entities around text
; --------------------------------------------------------------------------

(defun c:LegTxtTrm ( / avg bos box cmdecho def ent fac hnd itm los num
                        osmode p1 p10 p11 p12 p2 p3 p4 p5 p6 p7 p8 p9
                        plinewid rect ros sset sum tmp tos)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq osmode (getvar "OSMODE"))
  (setvar "OSMODE" 0)
  ;
  ; --- get selection set & process
  ;
  (setq sset (ssget "_I" '((0 . "TEXT"))))
  (if (= sset nil)
    (setq sset (ssget '((0 . "TEXT"))))
  )
  ;
  (setq num (sslength sset) itm 0)
  (if sset
    (progn
      (setq avg 0.0)
      (setq def (* 0.15 (dstp_textsize)))
      (setq tmp (getreal (strcat "\nDS> Left Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
      (if (/= tmp nil)(setq los tmp def tmp)(setq los def))
      (setq tmp (getreal (strcat "\nDS> Right Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
      (if (/= tmp nil)(setq ros tmp def tmp)(setq ros def))
      (setq tmp (getreal (strcat "\nDS> Top Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
      (if (/= tmp nil)(setq tos tmp def tmp)(setq tos def))
      (setq tmp (getreal (strcat "\nDS> Bottom Trim Offset <" (rtos def (getvar "LUNITS") 2) ">: ")))
      (if (/= tmp nil)(setq bos tmp def tmp)(setq bos def))
      ;
      (setq sum (+ los ros tos bos))
      (if (> sum 0.0)(setq avg (/ sum 4.0)))
      (if (> avg 0.0)
        (setq fac (/ avg 2.0))
        (setq fac (/ (dstp_textsize) 10.0))
      )
      (command "_.UNDO" "_G")
      (dstp_ucspush)
      (setq plinewid (getvar "PLINEWID"))
      (setvar "PLINEWID" 0.0)
      (princ "\nDS>")
      (while (< itm num)
        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (setq hnd (ssname sset itm))
        (setq ent (entget hnd))
        (if (= "TEXT" (cdr (assoc 0 ent))) 
          (progn
            (setq rect (dstp_textrect ent))
            (setq p1 (car rect))
            (setq p2 (cadr rect))
            (setq p3 (caddr rect))
            (setq p4 (cadddr rect))
            ;
            (setq p5 (polar p1 (angle p2 p1) los))
            (setq p5 (polar p5 (angle p4 p1) bos))
            (setq p6 (polar p2 (angle p1 p2) ros))
            (setq p6 (polar p6 (angle p3 p2) bos))
            (setq p7 (polar p3 (angle p4 p3) ros))
            (setq p7 (polar p7 (angle p2 p3) tos))
            (setq p8 (polar p4 (angle p3 p4) los))
            (setq p8 (polar p8 (angle p1 p4) tos))
            ;
            (setq p9 (polar p5 (angle p5 p6) fac))
            (setq p9 (polar p9 (angle p5 p8) fac))
            (setq p10 (polar p6 (angle p6 p5) fac))
            (setq p10 (polar p10 (angle p6 p7) fac))
            (setq p11 (polar p7 (angle p7 p8) fac))
            (setq p11 (polar p11 (angle p7 p6) fac))
            (setq p12 (polar p8 (angle p8 p7) fac))
            (setq p12 (polar p12 (angle p8 p5) fac))
            (command "_.PLINE" p5 p6 p7 p8 "_C")
            (setq box (entlast))
            ;
            (command "_.TRIM" box "")
            (repeat 2
              (command "_F" p9 p10 "")
              (command "_F" p10 p11 "")
              (command "_F" p11 p12 "")
              (command "_F" p12 p9 "")
            )
            (command "")
            ;
            (entdel box)
          )
        )
        (setq itm (1+ itm))
      )
      (setvar "PLINEWID" plinewid)
      (dstp_ucspop)
      (command "_.UNDO" "_E")
      (princ ", Done.")
    )
  )
  (setq sset nil)
  (setvar "CMDECHO" cmdecho)
  (setvar "OSMODE" osmode)
  (princ)
)

; --------------------------------------------------------------------------
;                             Image Make World File
; --------------------------------------------------------------------------

(defun c:LegWldMak ( / ang ck1 ck2 clst ent ext fh fn g10 g11 g12 g13 hgt
                         hnd hpp ifw img llc obj ov1 ov2 ov3 ov4 pass pnt
                         rox roy tmp ulc urc use wpp xcor xdim xhd ycor
                         ydif ydim)
  (if (= (dstp_rastersup) nil)
    (setq tmp (entsel "\nDS> Select TIF/JPG IMAGE to process: "))
    (setq tmp (entsel "\nDS> Select TIF/JPG/SID IMAGE to process: "))
  )
  (if (/= tmp nil)
    (progn
      (setq hnd (car tmp))
      (setq ent (entget hnd))
      (setq obj (cdr (assoc 0 ent)))
      (setq xhd (cdr (assoc 340 ent)))
      (if (= obj "IMAGE")
        (progn
          (setq g10 (cdr (assoc 10 ent)))
          (setq g11 (cdr (assoc 11 ent)))
          (setq g12 (cdr (assoc 12 ent)))
          (setq g13 (cdr (assoc 13 ent)))
          (setq ck1 (nth 1 g11))
          (setq ck2 (nth 0 g12))
          (setq rox (dstp_rtd (angle (list 0.0 0.0) g11)))
          (setq roy (dstp_rtd (angle (list 0.0 0.0) g12)))
          (setq img nil)
          (setq tmp (dictsearch (namedobjdict) "ACAD_IMAGE_DICT"))
          (foreach itm tmp
            (if (= (car itm) 350)
              (if (equal (cdr itm) xhd)
                (setq img (cdr (assoc 1 (entget (cdr itm)))))
              )
            )
          )
          (if (/= img nil)
            (progn
              (setq img (findfile img))
              (setq ext (strcase (substr img (- (strlen img) 2) 3)))
              (if (member ext (list "JPG" "TIF" "SID"))
                (progn
                  (setq pass nil)
                  (setq tmp (GetFileNameWithoutExtension img))
                  (cond
                    ((= ext "TIF")(setq use "tfw" pass T))
                    ((= ext "JPG")(setq use "jgw" pass T))
                    ((= ext "SID")(setq use "sdw" pass T))
                  )
                  (if (= pass T)
                    (progn
                      (setq ifw (strcat tmp "." use))
                      (setq fn (dstp_getfiles "Create World Raster File" ifw use 1))
                      (if (/= fn nil)
                        (progn
                          (if (and (equal ck1 0.0 0.0001)(equal ck2 0.0 0.0001))
                            (progn
                              (setq xcor (nth 0 g10)) ; horz
                              (setq ycor (nth 1 g10))
                              (setq xdim (nth 0 g11))
                              (setq ydim (nth 1 g12))
                              (setq hgt (nth 1 g13))
                              (setq ydif (* hgt ydim))
                              (setq ycor (+ ycor ydif))
                              (setq xcor (+ xcor (/ xdim 2.0))) ; adjust for 1/2 pixel
                              (setq ycor (- ycor (/ ydim 2.0)))
                              (setq fh (open fn "w"))
                              (princ (rtos xdim 2 16) fh)
                              (princ "\n" fh)
                              (princ "0.00000000" fh)
                              (princ "\n" fh)
                              (princ "0.00000000" fh)
                              (princ "\n" fh)
                              (princ (strcat "-" (rtos ydim 2 16)) fh)
                              (princ "\n" fh)
                              (princ (rtos xcor 2 16) fh)
                              (princ "\n" fh)
                              (princ (rtos ycor 2 16) fh)
                              (princ "\n" fh)
                              (close fh)
                            )
                            (progn
                              (setq clst (dstp_imcalrec hnd)) ; ll ul ur lr
                              (setq llc (nth 0 clst))
                              (setq ulc (nth 1 clst))
                              (setq urc (nth 2 clst))
                              (setq wpp (/ (distance ulc urc) (nth 0 g13)))
                              (setq hpp (/ (distance ulc llc) (nth 1 g13)))
                              (setq pnt (polar ulc (angle ulc urc)(/ wpp 2.0)))
                              (setq pnt (polar pnt (angle ulc llc)(/ hpp 2.0)))
                              (setq ang (angle ulc urc))
                              (setq ov1 (abs (nth 0 g11)))
                              (setq ov2 (abs (nth 1 g11)))
                              (setq ov3 (abs (nth 0 g12)))
                              (setq ov4 (abs (nth 1 g12)))
                              (cond
                                ((and (> ang 0.0)(< ang (/ pi 2.0))) ; ur
                                  (setq ov4 (- 0 ov4))
                                )
                                ((and (>= ang (/ pi 2.0))(< ang pi)) ; ul
                                  (setq ov1 (- 0 ov1))
                                )
                                ((and (>= ang pi)(< ang (+ pi (/ pi 2.0)))) ; ll
                                  (setq ov1 (- 0 ov1))
                                  (setq ov2 (- 0 ov2))
                                  (setq ov3 (- 0 ov3))
                                )
                                ((and (>= ang (+ pi (/ pi 2.0)))(< ang (* pi 2.0))) ; lr
                                  (setq ov2 (- 0 ov2))
                                  (setq ov3 (- 0 ov3))
                                  (setq ov4 (- 0 ov4))
                                )
                              )
                              (setq fh (open fn "w"))
                              (princ (rtos ov1 2 16) fh)
                              (princ "\n" fh)
                              (princ (rtos ov2 2 16) fh)
                              (princ "\n" fh)
                              (princ (rtos ov3 2 16) fh)
                              (princ "\n" fh)
                              (princ (rtos ov4 2 16) fh)
                              (princ "\n" fh)
                              (princ (rtos (nth 0 pnt) 2 16) fh)
                              (princ "\n" fh)
                              (princ (rtos (nth 1 pnt) 2 16) fh)
                              (princ "\n" fh)
                              (close fh)
                            )
                          )
                        )
                      )
                    )
                    (princ "\nDS> Selected image was not a TIF/JPG/SID")
                  )
                )
              )
            )
          )
        )
        (princ "\nDS> Select object was not an IMAGE!")
      )
    )
    (princ "\nDS> No object selected")
  )
  (princ)
)

; --------------------------------------------------------------------------
;                   Insert Multiple TIF/JPG's using TFW/JGW
; --------------------------------------------------------------------------

(defun c:LegWldIns ( / acadapp activedoc chk cmdecho ent fext fh filter
                         flst g11 g12 g13 hgt hnd ifil ins itm lst modelspace
                         n10 n11 n12 new nfc num path res root rot1 rot2 xan
                         xcor xdim xfc yan ycor ydif ydim yfc)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (if (= (dstp_rastersup) nil)
    (setq filter "All Supported Files|*.tfw;*.jgw|World TIFF Files (*.tfw)|*.tfw|World JPG Files (*.jgw)|*.jgw")
    (setq filter "All Supported Files|*.tfw;*.jgw;*.sdw|World TIFF Files (*.tfw)|*.tfw|World JPG Files (*.jgw)|*.jgw|World SID Files (*.sdw)|*.sdw")
  )
  (setq flst (dstp_getfilem "Select World Files" (dstp_folder) filter))
  (if (/= flst nil)
    (progn
      (if (> (length flst) 1)
        (setq flst (acad_strlsort flst))
      )
      (setq nfc 0)
      (princ "\nDS>")
      (setq num (length flst) itm 0)
      (foreach wfil flst
        (princ (strcat "\rDS> Processing Object " (itoa (1+ itm)) " of " (itoa num)))
        (setq root (strcat (vl-filename-directory wfil) "\\" (vl-filename-base wfil)))
        (setq fext (substr (strcase wfil) (- (strlen wfil) 2) 3))
        (cond
          ((= fext "TFW")(setq ifil (strcat root ".TIF")))
          ((= fext "JGW")(setq ifil (strcat root ".JPG")))
          ((= fext "SDW")(setq ifil (strcat root ".SID")))
        )
        (if (findfile ifil)
          (progn
            (setq fh (open wfil "r"))
            (setq xdim (atof (read-line fh)))
            (setq rot1 (atof (read-line fh)))
            (setq rot2 (atof (read-line fh)))
            (setq ydim (atof (read-line fh)))
            (setq xcor (atof (read-line fh)))
            (setq ycor (atof (read-line fh)))
            (close fh)
            (command "_.IMAGE" "_A" ifil "0,0" "1" "0")
            (setq hnd (entlast))
            (if (/= hnd nil)
              (progn
                (setq ent (entget hnd))
                (if (= (cdr (assoc 0 ent)) "IMAGE")
                  (progn
                    (if (and (equal rot1 0.0)(equal rot2 0.0))
                      (progn
                        (setq xdim (abs xdim))
                        (setq rot1 (abs rot1))
                        (setq rot2 (abs rot2))
                        (setq ydim (abs ydim))
                        (setq hgt (nth 2 (assoc 13 ent)))
                        (setq ydif (* hgt ydim))
                        (setq ycor (- ycor ydif))
                        (setq xcor (- xcor (/ xdim 2.0))) ; adjust for 1/2 pixel
                        (setq ycor (+ ycor (/ ydim 2.0)))
                        (setq n10 (list 10 xcor ycor 0.0))
                        (setq ent (subst n10 (assoc 10 ent) ent))
                        (setq n11 (list 11 xdim 0.0 0.0))
                        (setq ent (subst n11 (assoc 11 ent) ent))
                        (setq n12 (list 12 0.0 ydim 0.0))
                        (setq ent (subst n12 (assoc 12 ent) ent))
                        (entmod ent)
                      )
                      (progn
                        (setq g11 (list xdim rot1))
                        (if (> rot2 0.0)
                          (setq rot2 (- 0 rot2))
                          (setq rot2 (abs rot2))
                        )
                        (if (> ydim 0.0)
                          (setq ydim (- 0 ydim))
                          (setq ydim (abs ydim))
                        )
                        (setq g12 (list rot2 ydim))
                        (setq g13 (cdr (assoc 13 ent)))
                        (setq ins (list xcor ycor))
                        (setq xan (angle (list 0.0 0.0) g11))
                        (setq yan (+ (angle (list 0.0 0.0) g12) pi))
                        (setq xfc (distance (list 0.0 0.0) g11))
                        (setq yfc (distance (list 0.0 0.0) g12))
                        (setq hgt (* yfc (nth 1 g13)))
                        (setq ins (polar ins yan hgt))
                        (setq ins (polar ins (+ yan pi) (/ xfc 2.0)))
                        (setq ins (polar ins (+ xan pi) (/ yfc 2.0)))
                        (setq xcor (nth 0 ins))
                        (setq ycor (nth 1 ins))
                        (setq n10 (list 10 xcor ycor 0.0))
                        (setq ent (subst n10 (assoc 10 ent) ent))
                        (setq n11 (list 11 xdim rot1 0.0))
                        (setq ent (subst n11 (assoc 11 ent) ent))
                        (setq n12 (list 12 rot2 ydim 0.0))
                        (setq ent (subst n12 (assoc 12 ent) ent))
                        (entmod ent)
                      )
                    )
                  )
                )
              )
            )
          )
          (setq nfc (1+ nfc))
        )
        (setq itm (1+ itm))
      )
      (princ ", Done.")
      (if (> nfc 0)
        (princ (strcat "\nDS> (" (itoa nfc) ") Corresponding images were not found!"))
      )
    )
  )
  (dstp_ucspush)
  (command "_.UNDO" "_E")
  (setvar "CMDECHO" cmdecho)
  (princ)
)

; --------------------------------------------------------------------------
;                   XREF Dialog for Functions in XREF command
; --------------------------------------------------------------------------

(defun c:LegXrfMan (/ $value chmd cmdecho ctr datlst datsel dcl_id dianam
                         docancel dopass dstp_diasize fnd g70 itm itmsel lnk
                         nam rec redo sset tmp tot typ what_next wrkcnt
                         wrklst wrkstr)
  ;
  ; --- get list of xrefs
  ;
  (defun xrefcont_bldlst ()
    (setq datlst nil)
    (setq itm (tblnext "BLOCK" T))
    (while (/= itm nil)
      (setq g70 (cdr (assoc 70 itm)))
      (if (= (boole 1 g70 4) 4)
        (progn
          (setq lnk (cdr (assoc 1 itm)))
          (setq nam (cdr (assoc 2 itm)))
          (if (= (boole 1 g70 8) 8)
            (setq typ "Overlay")
            (setq typ "Attach")
          )
          (if (= (findfile lnk) nil)
            (setq fnd "N")
            (setq fnd "Y")
          )
          (setq datlst (append datlst (list (list nam lnk fnd typ))))
        )
      )
      (setq itm (tblnext "BLOCK"))
    )
  )
  ;
  ; --- update listbox
  ;
  (defun xrefcont_updlst ()
    (start_list "datlst")
    (foreach rec datlst
      (add_list (strcat (car rec) "\t" (cadr rec) "\t" (caddr rec) "\t" (cadddr rec)))
    )
    (end_list)
  )
  ;
  ; --- check current selection
  ;
  (defun xrefcont_chkcur ()
    (setq itmsel (dstp_pdf2lst datsel " "))
    (setq ctr 0)
    (setq wrklst nil)
    (setq wrkstr "")
    (if (> (length itmsel) 0)
      (progn
        (setq tot (length itmsel))
        (foreach chk itmsel
          (setq rec (nth (atoi chk) datlst))
          (setq wrklst (append wrklst (list rec)))
          (setq wrkstr (strcat wrkstr (car rec)))
          (setq ctr (1+ ctr))
          (if (< ctr tot)
            (setq wrkstr (strcat wrkstr ","))
          )
        )
        (setq dopass T)
      )
      (setq dopass nil)
    )
    (setq wrkcnt (length wrklst))
  )
  ;
  ; --- main routine
  ;
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (command "_.UNDO" "_G")
  (dstp_ucspush)
  (setq datlst nil)
  (setq redo T)
  (setq chmd nil)
  ;
  ; --- load and run dialog
  ;
  (if (= dstp_diasize 2)
    (setq dianam "xrefcont2")
    (setq dianam "xrefcont1")
  )
  (setq dcl_id (load_dialog "unsupport.dcl"))
  (setq what_next 9)
  (while (< 2 what_next)
    (if (not (new_dialog dianam dcl_id)) (exit))
    (if (= redo T)
      (progn
        (xrefcont_bldlst)
        (xrefcont_updlst)
        (setq redo nil)
      )
    )
    ;
    (action_tile "datlst" "(setq datsel $value)")
    (action_tile "attach" "(done_dialog 11)")
    (action_tile "bind" "(xrefcont_chkcur)(if (= dopass T)(done_dialog 12)(alert \"Nothing Selected to Bind !\"))")
    (action_tile "detach" "(xrefcont_chkcur)(if (= dopass T)(done_dialog 13)(alert \"Nothing Selected to Detach !\"))")
    (action_tile "path" "(xrefcont_chkcur)(if (= wrkcnt 1)(done_dialog 14)(alert \"Select a Single File to Change Path !\"))")
    (action_tile "reload" "(xrefcont_chkcur)(if (= dopass T)(done_dialog 15)(alert \"Nothing Selected to Reload !\"))")
    (action_tile "overlay" "(done_dialog 16)")
    (action_tile "accept" "(setq docancel nil)(done_dialog 2)")
    (action_tile "cancel" "(setq docancel T)(done_dialog 2)")
    (action_tile "save" "(savedata)")
    (action_tile "prnt" "(prntdata)")
    ;
    (setq what_next (start_dialog))
    (cond 
      ((= what_next 11)
        (setq tmp (dstp_getfiles "Select File to Attach" "" "dwg" 0))
        (if (/= tmp nil)
          (progn
            (setvar "CMDECHO" 1)
            (command "_.XREF" "_A" tmp)
            (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
              (command pause)
            )
            (setvar "CMDECHO" 0)
            (setq chmd T)
          )
        )
        (setq redo T)
      )
      ((= what_next 12)
        (command "_.XREF" "_B" wrkstr)
        (setq redo T)
        (setq chmd T)
      )
      ((= what_next 13)
        (command "_.XREF" "_D" wrkstr)
        (setq redo T)
        (setq chmd T)
      )
      ((= what_next 14)
        (setq rec (nth 0 wrklst))
        (setq nam (car rec))
        (setq lnk (cadr rec))
        (setq tmp (dstp_getfiles "Attachment Path & File" lnk "dwg" 0))
        (if (/= tmp nil)
          (progn
            (command "_.XREF" "_P" nam tmp)
            (setq chmd T)
          )
        )
        (setq redo T)
      )
      ((= what_next 15)
        (command "_.XREF" "_R" wrkstr)
        (setq redo T)
        (setq chmd T)
      )
      ((= what_next 16)
        (setq tmp (dstp_getfiles "Select File to Overlay" "" "dwg" 0))
        (if (/= tmp nil)
          (progn
            (setvar "CMDECHO" 1)
            (command "_.XREF" "_O" tmp)
            (while (eq 1 (logand 1 (getvar "CMDACTIVE")))
              (command pause)
            )
            (setvar "CMDECHO" 0)
            (setq chmd T)
          )
        )
        (setq redo T)
      )
      (t
        (setq redo T)
      )
    )
  )
  (unload_dialog dcl_id)
  ;
  (setq sset nil)
  (setq datlst nil)
  (dstp_ucspop)
  (command "_.UNDO" "_E")
  (if (= docancel T)
    (if (= chmd T)
      (command "_.UNDO" "_1")
    )
  )
  (setvar "CMDECHO" cmdecho)
  (princ)
)

(princ)
