using System;
using System.Text;
using System.Web.UI.WebControls;
using ComponentPro.Net;
using ComponentPro.Net.Mail;

public partial class _Default : System.Web.UI.Page
{
    void PopulateEnum()
    {
        ImapAuthenticationMethod[] arr = (ImapAuthenticationMethod[])Enum.GetValues(typeof(ImapAuthenticationMethod));

        for (int i = 0; i < arr.Length; i++)
        {
            ddlAuthentication.Items.Add(new ListItem(arr[i].ToString(), ((int)arr[i]).ToString()));
        }

        int index;
        if (int.TryParse(Request.Form["ddlAuthentication"], out index))
            ddlAuthentication.SelectedIndex = index;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        PopulateEnum();
    }
    protected void btnProcess_Click(object sender, EventArgs e)
    {
        // Create a new instance of the ImapClient class for retrieving mail messages.
        Imap client = new Imap();
            
        try
        {
            // Setup the directory for storing messages.
            string mailsPath = AppDomain.CurrentDomain.BaseDirectory + "Mails";
            if (!System.IO.Directory.Exists(mailsPath))
                System.IO.Directory.CreateDirectory(mailsPath);
            
            // Initialize the message string.
            StringBuilder sb = new StringBuilder();
            // Parse the IMAP port.
            int port = int.Parse(txtPort.Text);

            // Connect to the server.
            client.Connect(txtServer.Text, port, (SecurityMode)ddlSecurityMode.SelectedIndex);

            // Login to the server.
            ImapAuthenticationMethod ia = (ImapAuthenticationMethod)int.Parse(ddlAuthentication.SelectedValue);
            // Login to the IMAP server.
            client.Authenticate(txtUser.Text, txtPassword.Text, ia);

            // Selecting folder is needed.
            client.Select(txtFolder.Text);

            // Create a new instance of the BounceInspector class for detecting and filtering bounced messages.
            BounceInspector filter = new BounceInspector();
            // Delete hard bounce file?
            filter.AllowDelete = chkDelete.Checked;
            // Delete bard bounce in inbox as well?
            filter.AllowInboxDelete = chkDelete.Checked;
            // The maximum number of message to be downloaded.
            filter.MaxMessages = int.Parse(txtMessages.Text);
            // Process all messages.
            BounceResultCollection result = filter.ProcessMessages(client, txtFolder.Text, mailsPath);

            // Display processed emails.
            foreach (BounceResult r in result)
            {
                // If this is a detected bounce.
                if (r.Identified)
                {
                    // Add to the result text.
                    sb.AppendFormat("FileName: {0}<br>Subject: {1}<br>Address: {2}<br>Bounce Category: {3}<br>Bounce Type: {4}<br>Deleted: {5}<br>DSN Action: {6}<br>DSN Diagnostic Code: {7}<br><br>",
                                    System.IO.Path.GetFileName(r.FilePath),
                                    r.MailMessage.Subject,
                                    r.Addresses.Length > 0 ? r.Addresses[0] : string.Empty,
                                    r.BounceCategory.Name,
                                    r.BounceType.Name,
                                    r.FileDeleted,
                                    r.Dsn.Action,
                                    r.Dsn.DiagnosticCode);
                }
            }

            // Print out the result.
            sb.AppendFormat("{0} bounced message(s) found!", result.BounceCount);
            lblResult.Text = sb.ToString();
        }
        catch (Exception exc)
        {
            lblResult.Text = string.Format(null, "Exception: {0}", exc.Message);
        }
        finally
        {
            // Disconnect.
            client.Disconnect();
        }
    }
}