using System.Windows.Forms;
using ComponentPro.Net.Mail;

namespace ScanPop3Sample
{
    public partial class Errors : Form
    {
        public Errors()
        {
            InitializeComponent();
        }

        static string GetFileName(string fileName)
        {
            if (!string.IsNullOrEmpty(fileName))
                return System.IO.Path.GetFileName(fileName) + " - ";
            
            return fileName;
        }

        public void SetErrors(BounceResultCollection col)
        {
            listView.Items.Clear();

            int count = 0;
            foreach (BounceResult r in col)
            {
                if (r.Error != null)
                {
                    listView.Items.Add(GetFileName(r.FilePath) + r.Error.Message);

                    count++;
                    if (count > 100)
                    {
                        listView.Items.Add("Too many errors...");
                        break;
                    }
                }
            }
        }
    }
}