Imports ComponentPro.Net.Mail

Namespace ScanImapSample
	Partial Public Class CustomSignatures
		Inherits Form
		Private ReadOnly _signatures As List(Of SignatureInfo) ' A local list containing information of signatures.
		Private ReadOnly _filter As BounceInspector ' BounceInspector object.

		Public Sub New()
		End Sub

		Public Sub New(ByVal filter As BounceInspector, ByVal signatures As List(Of SignatureInfo))
			InitializeComponent()
			_filter = filter
			_signatures = signatures

			' Init the list control with the given signatures.
			For Each si As SignatureInfo In _signatures
				Dim item As New ListViewItem(New String() {si.RegexPattern, _filter.BounceCategories(si.CategoryCode).Name, _filter.BounceTypes(si.TypeCode).Name, si.Delete.ToString(), si.SignaturePart.ToString()})


				ltvCustomSignatures.Items.Add(item)
			Next si
		End Sub

		''' <summary>
		''' Handles the Add button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnAdd_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnAdd.Click
			' Create a new Signature information class.
			Dim dlg As New Signature(_filter, False)
			Dim r As DialogResult = dlg.ShowDialog()

			If r = System.Windows.Forms.DialogResult.OK Then
				Dim si As New SignatureInfo()
				si.CategoryCode = dlg.CategoryCode
				si.Delete = dlg.Delete
				si.RegexPattern = dlg.Pattern
				si.SignaturePart = dlg.Part
				si.TypeCode = dlg.TypeCode
				' Add a new bounce signature to the BounceInspector object.
				si.Index = _filter.AddBounceSignature(si.RegexPattern, si.CategoryCode, si.TypeCode, si.Delete, dlg.CheckFirst)

				' Also add it's info to the list control.
				Dim item As New ListViewItem(New String() {si.RegexPattern, _filter.BounceCategories(si.CategoryCode).Name, _filter.BounceTypes(si.TypeCode).Name, si.Delete.ToString(), si.SignaturePart.ToString()})


				' If this signature is marked as check first (highest position in the bouncefilter object's signature list).
				If dlg.CheckFirst Then
					_signatures.Insert(0, si)
					ltvCustomSignatures.Items.Insert(0, item)
				Else
					_signatures.Add(si)
					ltvCustomSignatures.Items.Add(item)
				End If
			End If
		End Sub

		''' <summary>
		''' Handles the Modify button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnModify_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnModify.Click
			' Show error when no item is selected.
			If ltvCustomSignatures.SelectedItems.Count = 0 Then
				MessageBox.Show("No signature selected", "BounceInspector", MessageBoxButtons.OK)
				Return
			End If

			Dim index As Integer = ltvCustomSignatures.SelectedItems(0).Index
			' Get signature info.
			Dim si As SignatureInfo = _signatures(index)

			Dim dlg As New Signature(_filter, True)
			dlg.CategoryCode = si.CategoryCode
			dlg.TypeCode = si.TypeCode
			dlg.Pattern = si.RegexPattern
			dlg.Delete = si.Delete
			dlg.Part = si.SignaturePart

			If dlg.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
				si.CategoryCode = dlg.CategoryCode
				si.Delete = dlg.Delete
				si.RegexPattern = dlg.Pattern
				si.SignaturePart = dlg.Part
				si.TypeCode = dlg.TypeCode

				' Update signature information (you can use this method to modify built-in signatures).
				_filter.ModifyBounceSignature(si.Index, si.RegexPattern, si.CategoryCode, si.TypeCode, si.Delete, si.SignaturePart)

				' Update the selected list item.
				ltvCustomSignatures.SelectedItems(0).SubItems(0).Text = si.RegexPattern
				ltvCustomSignatures.SelectedItems(0).SubItems(1).Text = _filter.BounceCategories(si.CategoryCode).Name
				ltvCustomSignatures.SelectedItems(0).SubItems(2).Text = _filter.BounceTypes(si.TypeCode).Name
				ltvCustomSignatures.SelectedItems(0).SubItems(3).Text = si.Delete.ToString()
				ltvCustomSignatures.SelectedItems(0).SubItems(4).Text = si.SignaturePart.ToString()
			End If
		End Sub

		''' <summary>
		''' Handles the Remove button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnRemove_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnRemove.Click
			' Show error when no item is selected.
			If ltvCustomSignatures.SelectedItems.Count = 0 Then
				MessageBox.Show("No signature selected", "BounceInspector", MessageBoxButtons.OK)
				Return
			End If

			Dim index As Integer = ltvCustomSignatures.SelectedItems(0).Index

			' Get signature info.
			Dim s As SignatureInfo = _signatures(index)

			' Remove the signature from the filter object.
			_filter.RemoveSignature(s.Index)

			' Remove the signature information from the local list as well.
			_signatures.RemoveAt(index)

			' Update other signatures' index
			For i As Integer = index To _signatures.Count - 1
				_signatures(i).Index -= 1
			Next i

			' Remove the selected list item.
			ltvCustomSignatures.Items.RemoveAt(index)
		End Sub
	End Class
End Namespace