Imports ComponentPro.Net.Mail
Imports System.IO

Namespace ScanImapSample
	Partial Public Class MessageViewer
		Inherits Form
		Private _msg As MailMessage
		Private ReadOnly _fileName As String

		Public Sub New()
			InitializeComponent()
		End Sub

		Public Sub New(ByVal fileName As String)
			InitializeComponent()

			_fileName = fileName
		End Sub

		''' <summary>
		''' Handles the form's Load event.
		''' </summary>
		''' <param name="e"></param>
		Protected Overrides Sub OnLoad(ByVal e As EventArgs)
			MyBase.OnLoad(e)

			' Disable the X button.
			Util.EnableCloseButton(Me, False)
		End Sub

		''' <summary>
		''' Handles the form's Shown event.
		''' </summary>
		''' <param name="e">The even arguments.</param>
		Protected Overrides Sub OnShown(ByVal e As EventArgs)
			MyBase.OnShown(e)

			Try
				_msg = New MailMessage(_fileName)

				' Fill from, to, cc.
				txtFrom.Text = _msg.From.ToString()
				txtTo.Text = _msg.To.ToString()
				txtCc.Text = _msg.Cc.ToString()

				' Fill subject.
				txtSubject.Text = _msg.Subject

				saveAsToolStripMenuItem.Enabled = True
				copyToolStripMenuItem.Enabled = True
				selectAllToolStripMenuItem.Enabled = True
				Util.EnableCloseButton(Me, True)

				' Fill the attachment list.
				If _msg.Attachments.Count > 0 Then
					For Each at As Attachment In _msg.Attachments
						cbxAttachment.Items.Add(at.FileName)
					Next at
				End If

				If cbxAttachment.Items.Count > 0 Then
					cbxAttachment.SelectedIndex = 0
					saveAttachmentsToolStripMenuItem.Enabled = True
				Else
					cbxAttachment.Enabled = False
					saveAttachmentsToolStripMenuItem.Enabled = False
				End If

				' Fill body plain text version.
				txtBody.Text = _msg.BodyText.Replace(vbLf, vbCrLf)
				' Fill body HTML version.
				txtHtml.Text = _msg.BodyHtml.Replace(vbLf, vbCrLf)

				Dim headers As HeaderCollection = _msg.Headers

				' Show all message header
				For i As Integer = 0 To headers.Count - 1
					Dim header As Header = headers(i)

					' add name column
					Dim item As New ListViewItem(header.Name)

					' add header raw content column
					item.SubItems.Add(header.Raw)

					' show unparsed (corrupted) headers in red				
					If header.Unparsable Then
						item.ForeColor = System.Drawing.Color.Red
					End If

					' add row to the ListView				
					lvwHeaders.Items.Add(item)
				Next i

				Dim rawData() As Byte
				Using reader As New FileStream(_fileName, FileMode.Open)
					rawData = New Byte(reader.Length - 1){}
					reader.Read(rawData, 0, rawData.Length)
				End Using

				' Fill raw message.
				Dim rawtext As String = System.Text.Encoding.Default.GetString(rawData, 0, Math.Min(rawData.Length, 500000))
				txtRawText.Text = rawtext
			Catch exc As Exception
				Util.ShowError(exc)

				Me.Close()
			End Try
		End Sub

		''' <summary>
		''' Shows Save as dialog and save the message to the specified file.
		''' </summary>
		Private Sub SaveMessageAs()
			Dim dlg As New SaveFileDialog()
			Try
				dlg.OverwritePrompt = True
				dlg.Filter = "Email files (*.eml)|*.eml|All files (*.*)|*.*"
				dlg.FilterIndex = 1
				dlg.Title = "Save the mail as"
				' Show the Save File As dialog.
				If dlg.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
					Return
				End If
			Catch
				MessageBox.Show(dlg.FileName & " is not an email file", "Error")
			End Try

			SaveMessageAs(dlg.FileName)
		End Sub

		''' <summary>
		''' Saves the current message as a file.
		''' </summary>
		''' <param name="fileName"></param>
		Private Sub SaveMessageAs(ByVal fileName As String)
			Try
				_msg.Save(fileName)
			Catch exc As Exception
				Util.ShowError(exc)
			End Try
		End Sub

		''' <summary>
		''' Saves attachments to a specific folder.
		''' </summary>
		Private Sub SaveAttachmentAs(ByVal folder As String)
			Try
				For Each att As Attachment In _msg.Attachments
					att.Save(Path.Combine(folder, att.FileName))
				Next att
			Catch exc As Exception
				Util.ShowError(exc)
			End Try
		End Sub

		''' <summary>
		''' Saves attachments to a specific folder. A browing folder dialog will be shown.
		''' </summary>
		Private Sub SaveAttachmentAs()
			Dim folderBrowserDialog As New FolderBrowserDialog()
			If folderBrowserDialog.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
				Return
			End If

			Dim path As String = folderBrowserDialog.SelectedPath
			SaveAttachmentAs(path)
		End Sub

		Private Sub selectAllToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles selectAllToolStripMenuItem.Click
			txtBody.SelectAll()
		End Sub

		Private Sub saveAsToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles saveAsToolStripMenuItem.Click
			SaveMessageAs()
		End Sub

		Private Sub saveAttachmentsToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles saveAttachmentsToolStripMenuItem.Click
			SaveAttachmentAs()
		End Sub

		Private Sub copyToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles copyToolStripMenuItem.Click
			txtBody.Copy()
		End Sub
	End Class
End Namespace