Imports System.ComponentModel
Imports System.Text
Imports ComponentPro.Net.Mail

Namespace ScanMessagesSample
	Partial Public Class Errors
		Inherits Form
		Public Sub New()
			InitializeComponent()
		End Sub

		Private Function GetFileName(ByVal fileName As String) As String
			If Not String.IsNullOrEmpty(fileName) Then
				Return System.IO.Path.GetFileName(fileName) & " - "
			Else
				Return fileName
			End If
		End Function

		Public Sub SetErrors(ByVal col As BounceResultCollection)
			listView.Items.Clear()

			Dim count As Integer = 0
			For Each r As BounceResult In col
				If r.Error IsNot Nothing Then
					listView.Items.Add(GetFileName(r.FilePath) & r.Error.Message)

					count += 1
					If count > 100 Then
						listView.Items.Add("Too many errors...")
						Exit For
					End If
				End If
			Next r
		End Sub
	End Class
End Namespace