Imports ComponentPro.Net

Namespace ScanPop3Sample
	Partial Public Class Settings
		Inherits Form
		Public Sub New()
			InitializeComponent()
			LoadConfigInternal()
		End Sub

		#Region "Configuration"

		Private Sub SaveConfig()
			' Save settings.
			Util.SaveProperty("ProxyServer", txtProxyHost.Text)
			Util.SaveProperty("ProxyPort", txtProxyPort.Text)
			Util.SaveProperty("ProxyUser", txtProxyUser.Text)
			Util.SaveProperty("ProxyPassword", txtProxyPassword.Text)
			Util.SaveProperty("ProxyDomain", txtProxyDomain.Text)
			Util.SaveProperty("ProxyType", cbxProxyType.SelectedIndex)
			Util.SaveProperty("ProxyMethod", cbxProxyMethod.SelectedIndex)
			Util.SaveProperty("Timeout", txtTimeout.Text)
		End Sub

		Public Shared Function LoadConfig() As ScanSettings
			' Load settings.
			Dim s As New ScanSettings()
			s.ProxyServer = CStr(Util.GetProperty("ProxyServer", String.Empty))
			s.ProxyPort = Util.GetIntProperty("ProxyPort", 1080)
			s.ProxyUser = CStr(Util.GetProperty("ProxyUser", String.Empty))
			s.ProxyPassword = CStr(Util.GetProperty("ProxyPassword", String.Empty))
			s.ProxyDomain = CStr(Util.GetProperty("ProxyDomain", String.Empty))
			s.ProxyType = CType(Util.GetIntProperty("ProxyType", 0), ProxyType)
			s.ProxyMethod = CType(Util.GetIntProperty("ProxyMethod", 0), ProxyHttpConnectAuthMethod)
			s.Timeout = Util.GetIntProperty("Timeout", 30)

			Return s
		End Function

		Private Sub LoadConfigInternal()
			Dim s As ScanSettings = LoadConfig()
			txtProxyHost.Text = s.ProxyServer
			txtProxyPort.Text = s.ProxyPort.ToString()
			txtProxyUser.Text = s.ProxyUser
			txtProxyPassword.Text = s.ProxyPassword
			txtProxyDomain.Text = s.ProxyDomain
			cbxProxyType.SelectedIndex = CInt(Fix(s.ProxyType))
			cbxProxyMethod.SelectedIndex = CInt(Fix(s.ProxyMethod))
			txtTimeout.Text = s.Timeout.ToString()
		End Sub

		#End Region

		Private Sub btnOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnOK.Click
			Dim proxyport As Integer
			Try
				proxyport = Integer.Parse(txtProxyPort.Text)
			Catch exc As Exception
				Util.ShowError(exc, "Invalid proxy port")
				Return
			End Try
			If proxyport < 0 OrElse proxyport > 65535 Then
				MessageBox.Show("Invalid port number", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
				Return
			End If

			Dim timeout As Integer
			Try
				timeout = Integer.Parse(txtTimeout.Text)
			Catch exc As Exception
				Util.ShowError(exc, "Invalid timeout")
				Return
			End Try
			If timeout < 1 Then
				MessageBox.Show("Invalid timeout, it must be greater than or equal to 1", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
				Return
			End If

			SaveConfig()
			Me.DialogResult = System.Windows.Forms.DialogResult.OK
		End Sub

		''' <summary>
		''' Handles the combo box proxy type's SelectedIndexChanged event.
		''' </summary>
		''' <param name="sender">The combo box.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cbxProxy_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles cbxProxyMethod.SelectedIndexChanged, cbxProxyType.SelectedIndexChanged
			Dim enable As Boolean = cbxProxyType.SelectedIndex > 0

			cbxProxyMethod.Enabled = cbxProxyType.SelectedIndex = CInt(Fix(ProxyType.HttpConnect)) ' Authentication method is available for HTTP Connect only.
			txtProxyDomain.Enabled = cbxProxyMethod.Enabled AndAlso cbxProxyMethod.SelectedIndex = CInt(Fix(ProxyHttpConnectAuthMethod.Ntlm)) ' Domain is available for NTLM authentication method only.
			txtProxyUser.Enabled = enable ' User name and password are ignored with SendToProxy proxy type. -  && cbxProxyType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyPassword.Enabled = enable ' && cbxProxyType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyHost.Enabled = enable ' Proxy host and port are not available in NoProxy type.
			txtProxyPort.Enabled = enable
		End Sub
	End Class
End Namespace