﻿Imports System.Text
Imports ComponentPro.Net.Mail

Namespace ScanMessages
	''' <summary>
	''' Interaction logic for Main.xaml
	''' </summary>
	Partial Public Class Main
		Inherits Window
		Public Sub New()
			InitializeComponent()
			txtPath.Text = DataDir
		End Sub

		Private _dataDir As String
		''' <summary>
		''' Gets the default data folder that stores Messages.
		''' </summary>
		Public ReadOnly Property DataDir() As String
			Get
				_dataDir = System.IO.Path.GetFullPath(AppDomain.CurrentDomain.BaseDirectory & "..\..\Data")
				If Not System.IO.Directory.Exists(_dataDir) Then
					_dataDir = AppDomain.CurrentDomain.BaseDirectory & "Data"
				End If

				Return _dataDir
			End Get
		End Property

		Private Sub btnBrowse_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
			' Open Folder Browser Dialog.
			Dim dlg As New System.Windows.Forms.FolderBrowserDialog()
			dlg.SelectedPath = txtPath.Text
			If dlg.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
				txtPath.Text = dlg.SelectedPath
			End If
		End Sub

		Private Sub btnScan_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
			Dim inspector As New BounceInspector()
			AddHandler inspector.Progress, AddressOf inspector_Progress

			ltvResult.Items.Clear()

			Try
				' Scan messages.
				Dim result As BounceResultCollection = inspector.ProcessMessages(txtPath.Text)

				Dim found As String = String.Format("{0}/{1} bounced e-mails found.", result.BounceCount, result.Count)
				If result.HasErrors Then
					found &= vbCrLf & "Completed with errors."
				End If

				If result.CancelledIndex <> -1 Then
					System.Windows.MessageBox.Show("Operation has been cancelled by user. " & found, "BounceInspector", MessageBoxButton.OK)
				Else
					System.Windows.MessageBox.Show(found, "BounceInspector", MessageBoxButton.OK)
				End If
			Catch exc As Exception
				ShowError(exc)
			End Try
		End Sub

		Private Sub inspector_Progress(ByVal sender As Object, ByVal e As ProgressEventArgs)
			Dispatcher.Invoke(New EventHandler(Of ProgressEventArgs)(AddressOf Filter_Progress), sender, e)
		End Sub

		Private Class CustomListItem
			Private privateFile As String
			Public Property File() As String
				Get
					Return privateFile
				End Get
				Set(ByVal value As String)
					privateFile = value
				End Set
			End Property
			Private privateSubject As String
			Public Property Subject() As String
				Get
					Return privateSubject
				End Get
				Set(ByVal value As String)
					privateSubject = value
				End Set
			End Property
			Private privateEmail As String
			Public Property Email() As String
				Get
					Return privateEmail
				End Get
				Set(ByVal value As String)
					privateEmail = value
				End Set
			End Property
			Private privateCategory As String
			Public Property Category() As String
				Get
					Return privateCategory
				End Get
				Set(ByVal value As String)
					privateCategory = value
				End Set
			End Property
			Private privateType As String
			Public Property Type() As String
				Get
					Return privateType
				End Get
				Set(ByVal value As String)
					privateType = value
				End Set
			End Property
			Private privateDSNAction As String
			Public Property DSNAction() As String
				Get
					Return privateDSNAction
				End Get
				Set(ByVal value As String)
					privateDSNAction = value
				End Set
			End Property
			Private privateDSNDiagnosticCode As String
			Public Property DSNDiagnosticCode() As String
				Get
					Return privateDSNDiagnosticCode
				End Get
				Set(ByVal value As String)
					privateDSNDiagnosticCode = value
				End Set
			End Property
		End Class

		''' <summary>
		''' Handles the BounceInspector's Progress event.
		''' </summary>
		''' <param name="sender">The BounceInspector object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub Filter_Progress(ByVal sender As Object, ByVal e As ProgressEventArgs)
			Try
				Dim r As BounceResult = e.Result

				If r.MailMessage Is Nothing Then
					Return
				End If

				If r.Identified Then
					Dim item As New CustomListItem()

					item.File = System.IO.Path.GetFileName(r.FilePath)
					item.Subject = r.MailMessage.Subject
					item.Email = r.Addresses(0)
					item.Category = r.BounceCategory.Name
					item.Type = r.BounceType.Name
					item.DSNAction = r.Dsn.Action.ToString()
					item.DSNDiagnosticCode = r.Dsn.DiagnosticCode

					ltvResult.Items.Add(item)
				End If
			Catch exc As Exception
                System.Windows.MessageBox.Show(exc.Message)
			End Try
		End Sub

		Public Shared Sub ShowError(ByVal exc As Exception)
			Dim str As String

			If exc.InnerException IsNot Nothing Then
				str = String.Format(Nothing, "An error occurred: {0}", exc.InnerException.Message)
			Else
				str = String.Format(Nothing, "An error occurred: {0}", exc.Message)
			End If

            System.Windows.MessageBox.Show(str, "Error")
		End Sub
	End Class
End Namespace
