using System;
using ComponentPro.Net;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void btnValidate_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                // Create a new instance of the EmailValidator class.
                EmailValidator sfbEmailValidator = new EmailValidator();

                // If the From domain text box value is not empty.
                if (txtFromDomain.Text.Length > 0)
                    sfbEmailValidator.SmtpHeloDomain = txtFromDomain.Text;

                // If the SmtpPort text box value is not empty.
                if (txtSmtpPort.Text.Length > 0)
                    sfbEmailValidator.SmtpPort = int.Parse(txtSmtpPort.Text);

                // If the SmtpMail text box value is not empty.
                if (txtSmtpMail.Text.Length > 0)
                    sfbEmailValidator.SmtpFromEmail = txtSmtpMail.Text;

                // If the DnsServer text box value is not empty.
                if (txtDnsServer.Text.Length > 0)
                    sfbEmailValidator.DnsServers.Add(txtDnsServer.Text);

                // Parse the validation level.
                sfbEmailValidator.ValidationLevel = (ValidationLevel)int.Parse(ddlValidationLevel.SelectedValue);

                // Validate the provided email.
                sfbEmailValidator.Validate(txtEmail.Text);
                
                // Show result.
                lblResult.Text = sfbEmailValidator.SmtpTranscript.Replace("\r\n", "<br>");
            }
            catch (Exception exc)
            {
                lblResult.Text = "An exception occurred: " + exc.Message;
            }
        }
    }
}