using System;
using System.Windows.Forms;

namespace EmailValidatorDemo
{
    public class IPAddressForm : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Panel panel;
        private System.Windows.Forms.TextBox txtIPa;
        private System.Windows.Forms.TextBox txtIPb;
        private System.Windows.Forms.TextBox txtIPc;
        private System.Windows.Forms.TextBox txtIPd;
        private System.Windows.Forms.Label lblIPDot1;
        private System.Windows.Forms.Label lblIPDot2;
        private System.Windows.Forms.Label lblIPDot3;
        private System.Windows.Forms.Button cmdOK;
        private System.Windows.Forms.Button cmdCancel;

        private readonly System.ComponentModel.Container components;
        private readonly string _addressToEdit = "";
        private System.Windows.Forms.Label lblHelp;
        private string _addressToReturn = "";

        public IPAddressForm(string addressToEdit)
        {
            _addressToEdit = addressToEdit;
            InitializeComponent();
        }

        public IPAddressForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Gets the IP address.
        /// </summary>
        public string Address
        {
            get
            {
                return _addressToReturn;
            }
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code

        private void InitializeComponent()
        {
            this.panel = new System.Windows.Forms.Panel();
            this.lblIPDot3 = new System.Windows.Forms.Label();
            this.lblIPDot2 = new System.Windows.Forms.Label();
            this.lblIPDot1 = new System.Windows.Forms.Label();
            this.txtIPd = new System.Windows.Forms.TextBox();
            this.txtIPc = new System.Windows.Forms.TextBox();
            this.txtIPb = new System.Windows.Forms.TextBox();
            this.txtIPa = new System.Windows.Forms.TextBox();
            this.cmdOK = new System.Windows.Forms.Button();
            this.cmdCancel = new System.Windows.Forms.Button();
            this.lblHelp = new System.Windows.Forms.Label();
            this.panel.SuspendLayout();
            this.SuspendLayout();
            // 
            // panel
            // 
            this.panel.BackColor = System.Drawing.SystemColors.Window;
            this.panel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.panel.Controls.Add(this.lblIPDot3);
            this.panel.Controls.Add(this.lblIPDot2);
            this.panel.Controls.Add(this.lblIPDot1);
            this.panel.Controls.Add(this.txtIPd);
            this.panel.Controls.Add(this.txtIPc);
            this.panel.Controls.Add(this.txtIPb);
            this.panel.Controls.Add(this.txtIPa);
            this.panel.Location = new System.Drawing.Point(11, 28);
            this.panel.Name = "panel";
            this.panel.Size = new System.Drawing.Size(152, 24);
            this.panel.TabIndex = 0;
            // 
            // lblIPDot3
            // 
            this.lblIPDot3.AutoSize = true;
            this.lblIPDot3.Location = new System.Drawing.Point(109, 4);
            this.lblIPDot3.Name = "lblIPDot3";
            this.lblIPDot3.Size = new System.Drawing.Size(10, 13);
            this.lblIPDot3.TabIndex = 6;
            this.lblIPDot3.Text = ".";
            // 
            // lblIPDot2
            // 
            this.lblIPDot2.AutoSize = true;
            this.lblIPDot2.Location = new System.Drawing.Point(72, 4);
            this.lblIPDot2.Name = "lblIPDot2";
            this.lblIPDot2.Size = new System.Drawing.Size(10, 13);
            this.lblIPDot2.TabIndex = 5;
            this.lblIPDot2.Text = ".";
            // 
            // lblIPDot1
            // 
            this.lblIPDot1.AutoSize = true;
            this.lblIPDot1.Location = new System.Drawing.Point(35, 4);
            this.lblIPDot1.Name = "lblIPDot1";
            this.lblIPDot1.Size = new System.Drawing.Size(10, 13);
            this.lblIPDot1.TabIndex = 4;
            this.lblIPDot1.Text = ".";
            // 
            // txtIPd
            // 
            this.txtIPd.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtIPd.Location = new System.Drawing.Point(119, 4);
            this.txtIPd.MaxLength = 3;
            this.txtIPd.Name = "txtIPd";
            this.txtIPd.Size = new System.Drawing.Size(24, 13);
            this.txtIPd.TabIndex = 3;
            this.txtIPd.Text = "255";
            this.txtIPd.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtIP_KeyUp);
            this.txtIPd.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtIP_KeyPress);
            this.txtIPd.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // txtIPc
            // 
            this.txtIPc.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtIPc.Location = new System.Drawing.Point(82, 4);
            this.txtIPc.MaxLength = 3;
            this.txtIPc.Name = "txtIPc";
            this.txtIPc.Size = new System.Drawing.Size(24, 13);
            this.txtIPc.TabIndex = 2;
            this.txtIPc.Text = "255";
            this.txtIPc.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtIP_KeyUp);
            this.txtIPc.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtIP_KeyPress);
            this.txtIPc.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // txtIPb
            // 
            this.txtIPb.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtIPb.Location = new System.Drawing.Point(45, 4);
            this.txtIPb.MaxLength = 3;
            this.txtIPb.Name = "txtIPb";
            this.txtIPb.Size = new System.Drawing.Size(24, 13);
            this.txtIPb.TabIndex = 1;
            this.txtIPb.Text = "255";
            this.txtIPb.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtIP_KeyUp);
            this.txtIPb.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtIP_KeyPress);
            this.txtIPb.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // txtIPa
            // 
            this.txtIPa.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtIPa.Location = new System.Drawing.Point(8, 4);
            this.txtIPa.MaxLength = 3;
            this.txtIPa.Name = "txtIPa";
            this.txtIPa.Size = new System.Drawing.Size(24, 13);
            this.txtIPa.TabIndex = 0;
            this.txtIPa.Text = "255";
            this.txtIPa.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtIP_KeyUp);
            this.txtIPa.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtIP_KeyPress);
            this.txtIPa.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // cmdOK
            // 
            this.cmdOK.Location = new System.Drawing.Point(21, 58);
            this.cmdOK.Name = "cmdOK";
            this.cmdOK.Size = new System.Drawing.Size(74, 23);
            this.cmdOK.TabIndex = 1;
            this.cmdOK.Text = "OK";
            this.cmdOK.Click += new System.EventHandler(this.cmdOK_Click);
            // 
            // cmdCancel
            // 
            this.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.cmdCancel.Location = new System.Drawing.Point(100, 58);
            this.cmdCancel.Name = "cmdCancel";
            this.cmdCancel.Size = new System.Drawing.Size(64, 23);
            this.cmdCancel.TabIndex = 2;
            this.cmdCancel.Text = "Cancel";
            // 
            // lblHelp
            // 
            this.lblHelp.AutoSize = true;
            this.lblHelp.Location = new System.Drawing.Point(8, 8);
            this.lblHelp.Name = "lblHelp";
            this.lblHelp.Size = new System.Drawing.Size(123, 13);
            this.lblHelp.TabIndex = 3;
            this.lblHelp.Text = "Please enter IP Address:";
            // 
            // IPAddressForm
            // 
            this.AcceptButton = this.cmdOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.cmdCancel;
            this.ClientSize = new System.Drawing.Size(172, 91);
            this.Controls.Add(this.lblHelp);
            this.Controls.Add(this.cmdCancel);
            this.Controls.Add(this.cmdOK);
            this.Controls.Add(this.panel);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "IPAddressForm";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "IP Address";
            this.Load += new System.EventHandler(this.IPEntryDialog_Load);
            this.panel.ResumeLayout(false);
            this.panel.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        /// <summary>
        /// Handles the ip text box's KeyPress event.
        /// </summary>
        /// <param name="sender">The ip textbox object.</param>
        /// <param name="e">The event arguments.</param>
        private void txtIP_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
        {
            TextBox box = (TextBox)sender;

            // Allow backspace
            if (e.KeyChar == 8)
                return;

            // Attempt to convert to decimal number, if failure, don't allow key to show
            int n;

            try
            {
                Convert.ToInt32(e.KeyChar.ToString());
            }
            catch (FormatException)
            {
                e.Handled = true;
                return;
            }

            string newNum = box.Text + e.KeyChar;
            if (newNum.Length > 3)
                newNum = e.KeyChar.ToString();

            try
            {
                n = Convert.ToInt32(newNum);
            }
            catch (FormatException)
            {
                n = -1;
            }

            int nMax = 255;
            int nMin = 0;
            if (box.Name == "txtIPa")
            {
                nMax = 223;
                nMin = 1;
            }

            // Validate the typed text.
            if (n > nMax)
            {
                MessageBox.Show(n + " is not a valid entry. Please specify a value between " + nMin + " and " + nMax, "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                box.Text = nMax.ToString();
                box.Focus();
            }
            else if (n < nMin)
            {
                MessageBox.Show(n + " is not a valid entry. Please specify a value between " + nMin + " and " + nMax, "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                txtIPa.Text = "1";
                txtIPa.Focus();
            }
        }

        /// <summary>
        /// Handles the IP textbox's KeyUp event.
        /// </summary>
        /// <param name="sender">The IP textbox object.</param>
        /// <param name="e">The event arguments.</param>
        private void txtIP_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
        {
            TextBox box = (TextBox)sender;

            // No longer than 3 characters.
            if (box.SelectionStart != 3)
                return;

            switch (box.Name)
            {
                case "txtIPa":
                    txtIPb.Focus();
                    break;
                case "txtIPb":
                    txtIPc.Focus();
                    break;
                case "txtIPc":
                    txtIPd.Focus();
                    break;
                case "txtIPd":
                    cmdOK.Focus();
                    break;
            }
        }

        /// <summary>
        /// Handles the textbox's Enter event.
        /// </summary>
        /// <param name="sender">The textbox object.</param>
        /// <param name="e">The event arguments.</param>
        private void TextBox_Enter(object sender, System.EventArgs e)
        {
            TextBox box = (TextBox)sender;
            box.SelectionStart = 0;
            box.SelectionLength = box.Text.Length;
        }

        /// <summary>
        /// Handles the OK button's Click event.
        /// </summary>
        /// <param name="sender">The button object.</param>
        /// <param name="e">The event arguments.</param>
        private void cmdOK_Click(object sender, System.EventArgs e)
        {
            // Build up an IP address string.
            string s = txtIPa.Text + "." + txtIPb.Text + "." + txtIPc.Text + "." + txtIPd.Text;
            try
            {   
                // Make sure all four IPa,b,c,d are correct.
                _addressToReturn = Convert.ToInt32(txtIPa.Text) + "." +
                                    Convert.ToInt32(txtIPb.Text) + "." +
                                    Convert.ToInt32(txtIPc.Text) + "." +
                                    Convert.ToInt32(txtIPd.Text);
                DialogResult = DialogResult.OK;
            }
            catch (FormatException)
            {
                MessageBox.Show("'" + s + "' is not a valid IP Address!", "Error");
            }
        }

        /// <summary>
        /// Handles the form's Load event.
        /// </summary>
        /// <param name="sender">The form object.</param>
        /// <param name="e">The event arguments.</param>
        private void IPEntryDialog_Load(object sender, System.EventArgs e)
        {
            // Load and fill in all text boxes.
            if (string.IsNullOrEmpty(_addressToEdit))
            {
                txtIPa.Text = txtIPb.Text = txtIPc.Text = txtIPd.Text = "";
                this.Text = "Add IP Address";
            }
            else
            {
                string[] parts = _addressToEdit.Split('.');

                if (parts.Length == 4)
                {
                    txtIPa.Text = parts[0];
                    txtIPb.Text = parts[1];
                    txtIPc.Text = parts[2];
                    txtIPd.Text = parts[3];
                }
                
                this.Text = "Edit IP Address";
            }
        }
    }
}