using System;
using System.Windows.Forms;
using ComponentPro.Net;
using ComponentPro.Net.Mail;

namespace MultipleThreads
{
    public partial class ProxySettings : Form
    {
        private readonly SettingInfo _info;

        public ProxySettings()
        {
            InitializeComponent();
        }

        public ProxySettings(SettingInfo s)
            : this()
        {
            _info = s;

            txtProxyHost.Text = s.ProxyServer;
            txtProxyPort.Text = s.ProxyPort.ToString();
            txtUserName.Text = s.ProxyUser;
            txtPassword.Text = s.ProxyPassword;
            txtDomain.Text = s.ProxyDomain;
            cbxType.SelectedIndex = (int)s.ProxyType;
            cbxMethod.SelectedIndex = (int)s.ProxyMethod;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            int theport = 0;
            if (txtProxyPort.Text.Length > 0)
                try
                {
                    int port;
                    port = int.Parse(txtProxyPort.Text);
                    if (port < 1 || port > 65535)
                    {
                        MessageBox.Show("Invalid port number, must be between 1 and 65535");
                        return;
                    }
                    theport = port;
                }
                catch (Exception exc)
                {
                    MessageBox.Show("Invalid port: " + exc.Message);
                    return;
                }

            if (txtPassword.Text.Length > 0 && txtUserName.Text.Length == 0)
            {
                MessageBox.Show("Please enter user name");
                return;
            }

            _info.ProxyServer = txtProxyHost.Text;
            _info.ProxyType = (ProxyType)cbxType.SelectedIndex;
            _info.ProxyMethod = (ProxyHttpConnectAuthMethod)cbxMethod.SelectedIndex;
            _info.ProxyUser = txtUserName.Text;
            _info.ProxyPassword = txtPassword.Text;
            _info.ProxyDomain = txtDomain.Text;
            _info.ProxyPort = theport;

            this.DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// Handles the combo box proxy type's SelectedIndexChanged event.
        /// </summary>
        /// <param name="sender">The combo box.</param>
        /// <param name="e">The event arguments.</param>
        private void cbx_SelectedIndexChanged(object sender, EventArgs e)
        {
            bool enable = cbxType.SelectedIndex > 0;

            cbxMethod.Enabled = cbxType.SelectedIndex == (int)ProxyType.HttpConnect; // Authentication method is available for HTTP Connect only.
            txtDomain.Enabled = cbxMethod.Enabled && cbxMethod.SelectedIndex == (int)ProxyHttpConnectAuthMethod.Ntlm; // Domain is available for NTLM authentication method only.
            txtUserName.Enabled = enable/* && cbxType.SelectedIndex != (int)ProxyType.SendToProxy*/; // User name and password are ignored with SendToProxy proxy type.
            txtPassword.Enabled = enable/* && cbxType.SelectedIndex != (int)ProxyType.SendToProxy*/;
            txtProxyHost.Enabled = enable; // Proxy host and port are not available in NoProxy type.
            txtProxyPort.Enabled = enable;
        }
    }
}