using System;
using ComponentPro.Net.Mail;

namespace MultipleThreads
{
    public class SettingInfo
    {
        #region Proxy

        string _proxyServer;
        public string ProxyServer
        {
            get { return _proxyServer; }
            set { _proxyServer = value; }
        }

        int _proxyPort;
        public int ProxyPort
        {
            get { return _proxyPort; }
            set { _proxyPort = value; }
        }

        string _proxyUser;
        public string ProxyUser
        {
            get { return _proxyUser; }
            set { _proxyUser = value; }
        }

        string _proxyPassword;
        public string ProxyPassword
        {
            get { return _proxyPassword; }
            set { _proxyPassword = value; }
        }

        string _proxyDomain;
        public string ProxyDomain
        {
            get { return _proxyDomain; }
            set { _proxyDomain = value; }
        }

        ProxyType _proxyType;
        public ProxyType ProxyType
        {
            get { return _proxyType; }
            set { _proxyType = value; }
        }

        ProxyHttpConnectAuthMethod _proxyMethod;
        public ProxyHttpConnectAuthMethod ProxyMethod
        {
            get { return _proxyMethod; }
            set { _proxyMethod = value; }
        }

        #endregion

        private string _emailListFile;
        public string EmailListFile
        {
            get { return _emailListFile; }
            set { _emailListFile = value; }
        }

        #region Methods

        /// <summary>
        /// Saves settings to the Registry.
        /// </summary>
        public void SaveConfig()
        {
            // Proxy Info.
            Util.SaveProperty("ProxyServer", ProxyServer);
            Util.SaveProperty("ProxyPort", ProxyPort);
            Util.SaveProperty("ProxyUser", ProxyUser);
            Util.SaveProperty("ProxyPassword", ProxyPassword);
            Util.SaveProperty("ProxyDomain", ProxyDomain);
            Util.SaveProperty("ProxyType", (int)ProxyType);
            Util.SaveProperty("ProxyMethod", (int)ProxyMethod);

            Util.SaveProperty("EmailListFile", EmailListFile);
        }

        /// <summary>
        /// Loads settings from the Registry.
        /// </summary>
        public static SettingInfo LoadConfig()
        {
            // Load Login information.
            SettingInfo s = new SettingInfo();

            // Proxy info.
            s.ProxyServer = (string)Util.GetProperty("ProxyServer", string.Empty);
            s.ProxyPort = Util.GetIntProperty("ProxyPort", 1080);
            s.ProxyUser = (string)Util.GetProperty("ProxyUser", string.Empty);
            s.ProxyPassword = (string)Util.GetProperty("ProxyPassword", string.Empty);
            s.ProxyDomain = (string)Util.GetProperty("ProxyDomain", string.Empty);
            s.ProxyType = (ProxyType)Util.GetIntProperty("ProxyType", 0);
            s.ProxyMethod = (ProxyHttpConnectAuthMethod)Util.GetIntProperty("ProxyMethod", 0);

            string dataDir = AppDomain.CurrentDomain.BaseDirectory + "..\\..\\Data";
            if (!System.IO.Directory.Exists(dataDir))
                dataDir = AppDomain.CurrentDomain.BaseDirectory + "Data";

            s.EmailListFile = (string)Util.GetProperty("EmailListFile", dataDir + "\\EmailList.txt");

            return s;
        }

        #endregion
    }
}