Imports ComponentPro.Net

Namespace EmailValidatorDemo
	Public Class SettingsDialog
		Inherits System.Windows.Forms.Form
		Private WithEvents cmdOK As System.Windows.Forms.Button
		Private cmdCancel As System.Windows.Forms.Button
		Private WithEvents txtMailFrom As System.Windows.Forms.TextBox
		Private lblMailFrom As System.Windows.Forms.Label
		Private lblDnsServer As System.Windows.Forms.Label
		Private lblValidationLevel As System.Windows.Forms.Label
		Private cboValidationLevel As System.Windows.Forms.ComboBox
		Private WithEvents txtBlackList As System.Windows.Forms.TextBox
		Private WithEvents txtWhiteList As System.Windows.Forms.TextBox
		Private lblWhiteList As System.Windows.Forms.Label
		Private lblBlackList As System.Windows.Forms.Label
		Private WithEvents cmdWhiteListBrowse As System.Windows.Forms.Button
		Private WithEvents cmdBlackListBrowse As System.Windows.Forms.Button
		Private WithEvents lbxDnsServers As System.Windows.Forms.ListBox
		Private WithEvents cmdDnsServerAdd As System.Windows.Forms.Button
		Private WithEvents cmdDnsServerEdit As System.Windows.Forms.Button
		Private WithEvents cmdDnsServerRemove As System.Windows.Forms.Button
		Private ReadOnly components As System.ComponentModel.Container = Nothing

		Private smtpSettings As GroupBox
		Private dnsSettings As GroupBox
		Private txtDnsTimeout As System.Windows.Forms.TextBox
		Private chkRandomDns As System.Windows.Forms.CheckBox
		Private lblDnsTimeout As System.Windows.Forms.Label
		Private lbMs As System.Windows.Forms.Label
		Private lbMs1 As System.Windows.Forms.Label
		Private lblSmtpTimeout As System.Windows.Forms.Label
		Private txtSmtpTimeout As System.Windows.Forms.TextBox
		Private lblSmtpPort As System.Windows.Forms.Label
		Private txtSmtpPort As System.Windows.Forms.TextBox
		Private lblFromDomain As System.Windows.Forms.Label
		Private txtFromDomain As System.Windows.Forms.TextBox
		Private blackwhiteLists As GroupBox
		Private general As GroupBox
		Private txtSyntaxPattern As System.Windows.Forms.TextBox
		Private lblEmailSyntaxPattern As System.Windows.Forms.Label
		Private chkCacheMXRecords As System.Windows.Forms.CheckBox
		Private lbMs2 As System.Windows.Forms.Label
		Private lblCacheTimeout As System.Windows.Forms.Label
		Private txtCacheTimeout As System.Windows.Forms.TextBox
		Private chkDeepCheck As System.Windows.Forms.CheckBox
		Private ReadOnly _validator As EmailValidator

		Public Sub New(ByVal validator As EmailValidator, ByVal whiteListFile As String, ByVal blackListFile As String)
			_validator = validator
			InitializeComponent()

			' Smtp
			txtMailFrom.Text = validator.SmtpFromEmail
			txtFromDomain.Text = validator.SmtpHeloDomain
			txtSmtpPort.Text = validator.SmtpPort.ToString()
			txtSmtpTimeout.Text = validator.SmtpTimeout.ToString()

			' Dns
			txtDnsTimeout.Text = validator.DnsTimeout.ToString()
			chkRandomDns.Checked = validator.UseRandomDnsServer
			For Each str As String In validator.DnsServers
				lbxDnsServers.Items.Add(str)
			Next str

			txtWhiteList.Text = whiteListFile
			txtBlackList.Text = blackListFile

			Select Case validator.ValidationLevel
				Case ValidationLevel.Syntax
					cboValidationLevel.SelectedIndex = 0

				Case ValidationLevel.Lists
					cboValidationLevel.SelectedIndex = 1

				Case ValidationLevel.MailExchangeRecords
					cboValidationLevel.SelectedIndex = 2

				Case ValidationLevel.SmtpConnection
					cboValidationLevel.SelectedIndex = 3

				Case ValidationLevel.Mailbox
					cboValidationLevel.SelectedIndex = 4
			End Select

			chkCacheMXRecords.Checked = validator.UseMailExchangeRecordCache
			chkDeepCheck.Checked = validator.DeepMailboxCheck
			txtSyntaxPattern.Text = validator.EmailSyntaxPattern
			txtCacheTimeout.Text = validator.MailExchangeRecordCacheTimeout.ToString()
		End Sub

		#Region "Properties"

		''' <summary>
		''' Gets the white list file.
		''' </summary>
		Public ReadOnly Property WhiteListFile() As String
			Get
				Return txtWhiteList.Text
			End Get
		End Property

		''' <summary>
		''' Gets the black list file.
		''' </summary>
		Public ReadOnly Property BlackListFile() As String
			Get
				Return txtBlackList.Text
			End Get
		End Property

		#End Region

		Protected Overrides Sub Dispose(ByVal disposing As Boolean)
			If disposing Then
				If components IsNot Nothing Then
					components.Dispose()
				End If
			End If
			MyBase.Dispose(disposing)
		End Sub

		#Region "Windows Form Designer generated code"
		''' <summary>
		''' Required method for Designer support - do not modify
		''' the contents of this method with the code editor.
		''' </summary>
		Private Sub InitializeComponent()
			Me.cmdOK = New System.Windows.Forms.Button()
			Me.cmdCancel = New System.Windows.Forms.Button()
			Me.txtMailFrom = New System.Windows.Forms.TextBox()
			Me.lblMailFrom = New System.Windows.Forms.Label()
			Me.lblDnsServer = New System.Windows.Forms.Label()
			Me.lblValidationLevel = New System.Windows.Forms.Label()
			Me.cboValidationLevel = New System.Windows.Forms.ComboBox()
			Me.txtBlackList = New System.Windows.Forms.TextBox()
			Me.txtWhiteList = New System.Windows.Forms.TextBox()
			Me.lblWhiteList = New System.Windows.Forms.Label()
			Me.lblBlackList = New System.Windows.Forms.Label()
			Me.cmdWhiteListBrowse = New System.Windows.Forms.Button()
			Me.cmdBlackListBrowse = New System.Windows.Forms.Button()
			Me.lbxDnsServers = New System.Windows.Forms.ListBox()
			Me.cmdDnsServerAdd = New System.Windows.Forms.Button()
			Me.cmdDnsServerEdit = New System.Windows.Forms.Button()
			Me.cmdDnsServerRemove = New System.Windows.Forms.Button()
			Me.smtpSettings = New System.Windows.Forms.GroupBox()
			Me.lbMs1 = New System.Windows.Forms.Label()
			Me.lblSmtpTimeout = New System.Windows.Forms.Label()
			Me.txtSmtpTimeout = New System.Windows.Forms.TextBox()
			Me.lblSmtpPort = New System.Windows.Forms.Label()
			Me.txtSmtpPort = New System.Windows.Forms.TextBox()
			Me.lblFromDomain = New System.Windows.Forms.Label()
			Me.txtFromDomain = New System.Windows.Forms.TextBox()
			Me.dnsSettings = New System.Windows.Forms.GroupBox()
			Me.lblDnsTimeout = New System.Windows.Forms.Label()
			Me.lbMs = New System.Windows.Forms.Label()
			Me.txtDnsTimeout = New System.Windows.Forms.TextBox()
			Me.chkRandomDns = New System.Windows.Forms.CheckBox()
			Me.blackwhiteLists = New System.Windows.Forms.GroupBox()
			Me.general = New System.Windows.Forms.GroupBox()
			Me.chkDeepCheck = New System.Windows.Forms.CheckBox()
			Me.lbMs2 = New System.Windows.Forms.Label()
			Me.lblCacheTimeout = New System.Windows.Forms.Label()
			Me.txtCacheTimeout = New System.Windows.Forms.TextBox()
			Me.chkCacheMXRecords = New System.Windows.Forms.CheckBox()
			Me.txtSyntaxPattern = New System.Windows.Forms.TextBox()
			Me.lblEmailSyntaxPattern = New System.Windows.Forms.Label()
			Me.smtpSettings.SuspendLayout()
			Me.dnsSettings.SuspendLayout()
			Me.blackwhiteLists.SuspendLayout()
			Me.general.SuspendLayout()
			Me.SuspendLayout()
			' 
			' cmdOK
			' 
			Me.cmdOK.Location = New System.Drawing.Point(443, 328)
			Me.cmdOK.Name = "cmdOK"
			Me.cmdOK.Size = New System.Drawing.Size(75, 23)
			Me.cmdOK.TabIndex = 30
			Me.cmdOK.Text = "OK"
'			Me.cmdOK.Click += New System.EventHandler(Me.cmdOK_Click)
			' 
			' cmdCancel
			' 
			Me.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel
			Me.cmdCancel.Location = New System.Drawing.Point(523, 328)
			Me.cmdCancel.Name = "cmdCancel"
			Me.cmdCancel.Size = New System.Drawing.Size(75, 23)
			Me.cmdCancel.TabIndex = 31
			Me.cmdCancel.Text = "Cancel"
			' 
			' txtMailFrom
			' 
			Me.txtMailFrom.Location = New System.Drawing.Point(88, 19)
			Me.txtMailFrom.Name = "txtMailFrom"
			Me.txtMailFrom.Size = New System.Drawing.Size(169, 21)
			Me.txtMailFrom.TabIndex = 0
'			Me.txtMailFrom.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' lblMailFrom
			' 
			Me.lblMailFrom.Location = New System.Drawing.Point(10, 22)
			Me.lblMailFrom.Name = "lblMailFrom"
			Me.lblMailFrom.Size = New System.Drawing.Size(55, 13)
			Me.lblMailFrom.TabIndex = 5
			Me.lblMailFrom.Text = "Mail From:"
			' 
			' lblDnsServer
			' 
			Me.lblDnsServer.Location = New System.Drawing.Point(6, 19)
			Me.lblDnsServer.Name = "lblDnsServer"
			Me.lblDnsServer.Size = New System.Drawing.Size(68, 13)
			Me.lblDnsServer.TabIndex = 6
			Me.lblDnsServer.Text = "Dns Servers:"
			' 
			' lblValidationLevel
			' 
			Me.lblValidationLevel.Location = New System.Drawing.Point(10, 16)
			Me.lblValidationLevel.Name = "lblValidationLevel"
			Me.lblValidationLevel.Size = New System.Drawing.Size(56, 26)
			Me.lblValidationLevel.TabIndex = 42
			Me.lblValidationLevel.Text = "Validation " & vbCrLf & "Level:"
			' 
			' cboValidationLevel
			' 
			Me.cboValidationLevel.DrawMode = System.Windows.Forms.DrawMode.Normal
			Me.cboValidationLevel.DroppedDown = False
			Me.cboValidationLevel.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
			Me.cboValidationLevel.FormatInfo = Nothing
			Me.cboValidationLevel.FormatString = ""
			Me.cboValidationLevel.FormattingEnabled = False
			Me.cboValidationLevel.Items.AddRange(New Object() { "Syntax", "Lists", "Mail Exchange Records", "Smtp Connection", "Mailbox"})
			Me.cboValidationLevel.Location = New System.Drawing.Point(88, 16)
			Me.cboValidationLevel.Name = "cboValidationLevel"
			Me.cboValidationLevel.Size = New System.Drawing.Size(169, 21)
			Me.cboValidationLevel.Sorted = False
			Me.cboValidationLevel.TabIndex = 15
			' 
			' txtBlackList
			' 
			Me.txtBlackList.Anchor = (CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles))
			Me.txtBlackList.Location = New System.Drawing.Point(88, 45)
			Me.txtBlackList.Name = "txtBlackList"
			Me.txtBlackList.Size = New System.Drawing.Size(427, 21)
			Me.txtBlackList.TabIndex = 13
'			Me.txtBlackList.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' txtWhiteList
			' 
			Me.txtWhiteList.Anchor = (CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Left) Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles))
			Me.txtWhiteList.Location = New System.Drawing.Point(88, 19)
			Me.txtWhiteList.Name = "txtWhiteList"
			Me.txtWhiteList.Size = New System.Drawing.Size(427, 21)
			Me.txtWhiteList.TabIndex = 11
'			Me.txtWhiteList.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' lblWhiteList
			' 
			Me.lblWhiteList.Location = New System.Drawing.Point(10, 23)
			Me.lblWhiteList.Name = "lblWhiteList"
			Me.lblWhiteList.Size = New System.Drawing.Size(54, 13)
			Me.lblWhiteList.TabIndex = 49
			Me.lblWhiteList.Text = "WhiteList:"
			' 
			' lblBlackList
			' 
			Me.lblBlackList.Location = New System.Drawing.Point(10, 48)
			Me.lblBlackList.Name = "lblBlackList"
			Me.lblBlackList.Size = New System.Drawing.Size(53, 13)
			Me.lblBlackList.TabIndex = 50
			Me.lblBlackList.Text = "BlackList:"
			' 
			' cmdWhiteListBrowse
			' 
			Me.cmdWhiteListBrowse.Anchor = (CType((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles))
			Me.cmdWhiteListBrowse.Location = New System.Drawing.Point(521, 19)
			Me.cmdWhiteListBrowse.Name = "cmdWhiteListBrowse"
			Me.cmdWhiteListBrowse.Size = New System.Drawing.Size(56, 20)
			Me.cmdWhiteListBrowse.TabIndex = 12
			Me.cmdWhiteListBrowse.Text = "Browse"
'			Me.cmdWhiteListBrowse.Click += New System.EventHandler(Me.cmdWhiteListBrowse_Click)
			' 
			' cmdBlackListBrowse
			' 
			Me.cmdBlackListBrowse.Anchor = (CType((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles))
			Me.cmdBlackListBrowse.Location = New System.Drawing.Point(521, 45)
			Me.cmdBlackListBrowse.Name = "cmdBlackListBrowse"
			Me.cmdBlackListBrowse.Size = New System.Drawing.Size(56, 20)
			Me.cmdBlackListBrowse.TabIndex = 14
			Me.cmdBlackListBrowse.Text = "Browse"
'			Me.cmdBlackListBrowse.Click += New System.EventHandler(Me.cmdBlackListBrowse_Click)
			' 
			' lbxDnsServers
			' 
			Me.lbxDnsServers.Location = New System.Drawing.Point(78, 19)
			Me.lbxDnsServers.Name = "lbxDnsServers"
			Me.lbxDnsServers.Size = New System.Drawing.Size(162, 69)
			Me.lbxDnsServers.TabIndex = 5
'			Me.lbxDnsServers.SelectedIndexChanged += New System.EventHandler(Me.lbxDnsServers_SelectedIndexChanged)
'			Me.lbxDnsServers.DoubleClick += New System.EventHandler(Me.lbxDnsServers_DoubleClick)
			' 
			' cmdDnsServerAdd
			' 
			Me.cmdDnsServerAdd.Location = New System.Drawing.Point(246, 19)
			Me.cmdDnsServerAdd.Name = "cmdDnsServerAdd"
			Me.cmdDnsServerAdd.Size = New System.Drawing.Size(56, 20)
			Me.cmdDnsServerAdd.TabIndex = 6
			Me.cmdDnsServerAdd.Text = "Add"
'			Me.cmdDnsServerAdd.Click += New System.EventHandler(Me.cmdDnsServerAdd_Click)
			' 
			' cmdDnsServerEdit
			' 
			Me.cmdDnsServerEdit.Location = New System.Drawing.Point(246, 41)
			Me.cmdDnsServerEdit.Name = "cmdDnsServerEdit"
			Me.cmdDnsServerEdit.Size = New System.Drawing.Size(56, 22)
			Me.cmdDnsServerEdit.TabIndex = 7
			Me.cmdDnsServerEdit.Text = "Edit"
'			Me.cmdDnsServerEdit.Click += New System.EventHandler(Me.cmdDnsServerEdit_Click)
			' 
			' cmdDnsServerRemove
			' 
			Me.cmdDnsServerRemove.Location = New System.Drawing.Point(246, 65)
			Me.cmdDnsServerRemove.Name = "cmdDnsServerRemove"
			Me.cmdDnsServerRemove.Size = New System.Drawing.Size(56, 23)
			Me.cmdDnsServerRemove.TabIndex = 8
			Me.cmdDnsServerRemove.Text = "Remove"
'			Me.cmdDnsServerRemove.Click += New System.EventHandler(Me.cmdDnsServerRemove_Click)
			' 
			' smtpSettings
			' 
			Me.smtpSettings.Controls.Add(Me.lbMs1)
			Me.smtpSettings.Controls.Add(Me.lblSmtpTimeout)
			Me.smtpSettings.Controls.Add(Me.txtSmtpTimeout)
			Me.smtpSettings.Controls.Add(Me.lblSmtpPort)
			Me.smtpSettings.Controls.Add(Me.txtSmtpPort)
			Me.smtpSettings.Controls.Add(Me.lblFromDomain)
			Me.smtpSettings.Controls.Add(Me.txtFromDomain)
			Me.smtpSettings.Controls.Add(Me.lblMailFrom)
			Me.smtpSettings.Controls.Add(Me.txtMailFrom)
			Me.smtpSettings.Location = New System.Drawing.Point(10, 6)
			Me.smtpSettings.Name = "smtpSettings"
			Me.smtpSettings.Size = New System.Drawing.Size(269, 131)
			Me.smtpSettings.TabIndex = 54
			Me.smtpSettings.TabStop = False
			Me.smtpSettings.Text = "Smtp Settings"
			' 
			' lbMs1
			' 
			Me.lbMs1.Location = New System.Drawing.Point(158, 99)
			Me.lbMs1.Name = "lbMs1"
			Me.lbMs1.Size = New System.Drawing.Size(20, 13)
			Me.lbMs1.TabIndex = 51
			Me.lbMs1.Text = "ms"
			' 
			' lblSmtpTimeout
			' 
			Me.lblSmtpTimeout.Location = New System.Drawing.Point(10, 99)
			Me.lblSmtpTimeout.Name = "lblSmtpTimeout"
			Me.lblSmtpTimeout.Size = New System.Drawing.Size(48, 13)
			Me.lblSmtpTimeout.TabIndex = 11
			Me.lblSmtpTimeout.Text = "Timeout:"
			' 
			' txtSmtpTimeout
			' 
			Me.txtSmtpTimeout.Location = New System.Drawing.Point(88, 96)
			Me.txtSmtpTimeout.Name = "txtSmtpTimeout"
			Me.txtSmtpTimeout.Size = New System.Drawing.Size(66, 21)
			Me.txtSmtpTimeout.TabIndex = 4
			' 
			' lblSmtpPort
			' 
			Me.lblSmtpPort.Location = New System.Drawing.Point(10, 73)
			Me.lblSmtpPort.Name = "lblSmtpPort"
			Me.lblSmtpPort.Size = New System.Drawing.Size(56, 13)
			Me.lblSmtpPort.TabIndex = 9
			Me.lblSmtpPort.Text = "Smtp Port:"
			' 
			' txtSmtpPort
			' 
			Me.txtSmtpPort.Location = New System.Drawing.Point(88, 70)
			Me.txtSmtpPort.Name = "txtSmtpPort"
			Me.txtSmtpPort.Size = New System.Drawing.Size(66, 21)
			Me.txtSmtpPort.TabIndex = 3
			Me.txtSmtpPort.Text = "25"
			' 
			' lblFromDomain
			' 
			Me.lblFromDomain.Location = New System.Drawing.Point(10, 48)
			Me.lblFromDomain.Name = "lblFromDomain"
			Me.lblFromDomain.Size = New System.Drawing.Size(72, 13)
			Me.lblFromDomain.TabIndex = 7
			Me.lblFromDomain.Text = "From Domain:"
			' 
			' txtFromDomain
			' 
			Me.txtFromDomain.Location = New System.Drawing.Point(88, 45)
			Me.txtFromDomain.Name = "txtFromDomain"
			Me.txtFromDomain.Size = New System.Drawing.Size(169, 21)
			Me.txtFromDomain.TabIndex = 2
			' 
			' dnsSettings
			' 
			Me.dnsSettings.Controls.Add(Me.lblDnsTimeout)
			Me.dnsSettings.Controls.Add(Me.lbMs)
			Me.dnsSettings.Controls.Add(Me.txtDnsTimeout)
			Me.dnsSettings.Controls.Add(Me.chkRandomDns)
			Me.dnsSettings.Controls.Add(Me.lbxDnsServers)
			Me.dnsSettings.Controls.Add(Me.cmdDnsServerAdd)
			Me.dnsSettings.Controls.Add(Me.lblDnsServer)
			Me.dnsSettings.Controls.Add(Me.cmdDnsServerEdit)
			Me.dnsSettings.Controls.Add(Me.cmdDnsServerRemove)
			Me.dnsSettings.Location = New System.Drawing.Point(285, 6)
			Me.dnsSettings.Name = "dnsSettings"
			Me.dnsSettings.Size = New System.Drawing.Size(313, 131)
			Me.dnsSettings.TabIndex = 55
			Me.dnsSettings.TabStop = False
			Me.dnsSettings.Text = "Dns Settings"
			' 
			' lblDnsTimeout
			' 
			Me.lblDnsTimeout.Location = New System.Drawing.Point(8, 101)
			Me.lblDnsTimeout.Name = "lblDnsTimeout"
			Me.lblDnsTimeout.Size = New System.Drawing.Size(70, 13)
			Me.lblDnsTimeout.TabIndex = 56
			Me.lblDnsTimeout.Text = "Dns Timeout:"
			' 
			' lbMs
			' 
			Me.lbMs.Location = New System.Drawing.Point(151, 101)
			Me.lbMs.Name = "lbMs"
			Me.lbMs.Size = New System.Drawing.Size(20, 13)
			Me.lbMs.TabIndex = 50
			Me.lbMs.Text = "ms"
			' 
			' txtDnsTimeout
			' 
			Me.txtDnsTimeout.Location = New System.Drawing.Point(78, 98)
			Me.txtDnsTimeout.Name = "txtDnsTimeout"
			Me.txtDnsTimeout.Size = New System.Drawing.Size(67, 21)
			Me.txtDnsTimeout.TabIndex = 9
			' 
			' chkRandomDns
			' 
			Me.chkRandomDns.Location = New System.Drawing.Point(197, 95)
			Me.chkRandomDns.Name = "chkRandomDns"
			Me.chkRandomDns.Size = New System.Drawing.Size(110, 26)
			Me.chkRandomDns.TabIndex = 10
			Me.chkRandomDns.Text = "Use Random Dns"
			' 
			' blackwhiteLists
			' 
			Me.blackwhiteLists.Controls.Add(Me.lblWhiteList)
			Me.blackwhiteLists.Controls.Add(Me.txtWhiteList)
			Me.blackwhiteLists.Controls.Add(Me.cmdWhiteListBrowse)
			Me.blackwhiteLists.Controls.Add(Me.lblBlackList)
			Me.blackwhiteLists.Controls.Add(Me.txtBlackList)
			Me.blackwhiteLists.Controls.Add(Me.cmdBlackListBrowse)
			Me.blackwhiteLists.Location = New System.Drawing.Point(10, 143)
			Me.blackwhiteLists.Name = "blackwhiteLists"
			Me.blackwhiteLists.Size = New System.Drawing.Size(588, 77)
			Me.blackwhiteLists.TabIndex = 56
			Me.blackwhiteLists.TabStop = False
			Me.blackwhiteLists.Text = "Black List and White List"
			' 
			' general
			' 
			Me.general.Controls.Add(Me.chkDeepCheck)
			Me.general.Controls.Add(Me.lbMs2)
			Me.general.Controls.Add(Me.lblCacheTimeout)
			Me.general.Controls.Add(Me.txtCacheTimeout)
			Me.general.Controls.Add(Me.chkCacheMXRecords)
			Me.general.Controls.Add(Me.txtSyntaxPattern)
			Me.general.Controls.Add(Me.lblEmailSyntaxPattern)
			Me.general.Controls.Add(Me.lblValidationLevel)
			Me.general.Controls.Add(Me.cboValidationLevel)
			Me.general.Location = New System.Drawing.Point(10, 226)
			Me.general.Name = "general"
			Me.general.Size = New System.Drawing.Size(588, 96)
			Me.general.TabIndex = 57
			Me.general.TabStop = False
			Me.general.Text = "General"
			' 
			' chkDeepCheck
			' 
			Me.chkDeepCheck.Location = New System.Drawing.Point(88, 66)
			Me.chkDeepCheck.Name = "chkDeepCheck"
			Me.chkDeepCheck.Size = New System.Drawing.Size(143, 26)
			Me.chkDeepCheck.TabIndex = 19
			Me.chkDeepCheck.Text = "Deeply Check Mailboxes"
			' 
			' lbMs2
			' 
			Me.lbMs2.Location = New System.Drawing.Point(426, 49)
			Me.lbMs2.Name = "lbMs2"
			Me.lbMs2.Size = New System.Drawing.Size(29, 13)
			Me.lbMs2.TabIndex = 57
			Me.lbMs2.Text = "secs"
			' 
			' lblCacheTimeout
			' 
			Me.lblCacheTimeout.Location = New System.Drawing.Point(281, 46)
			Me.lblCacheTimeout.Name = "lblCacheTimeout"
			Me.lblCacheTimeout.Size = New System.Drawing.Size(48, 26)
			Me.lblCacheTimeout.TabIndex = 59
			Me.lblCacheTimeout.Text = "Cache " & vbCrLf & "Timeout:"
			' 
			' txtCacheTimeout
			' 
			Me.txtCacheTimeout.Location = New System.Drawing.Point(353, 47)
			Me.txtCacheTimeout.Name = "txtCacheTimeout"
			Me.txtCacheTimeout.Size = New System.Drawing.Size(67, 21)
			Me.txtCacheTimeout.TabIndex = 18
			' 
			' chkCacheMXRecords
			' 
			Me.chkCacheMXRecords.Location = New System.Drawing.Point(88, 43)
			Me.chkCacheMXRecords.Name = "chkCacheMXRecords"
			Me.chkCacheMXRecords.Size = New System.Drawing.Size(173, 26)
			Me.chkCacheMXRecords.TabIndex = 17
			Me.chkCacheMXRecords.Text = "Cache Mail Exchange Records"
			' 
			' txtSyntaxPattern
			' 
			Me.txtSyntaxPattern.Location = New System.Drawing.Point(353, 16)
			Me.txtSyntaxPattern.Name = "txtSyntaxPattern"
			Me.txtSyntaxPattern.Size = New System.Drawing.Size(224, 21)
			Me.txtSyntaxPattern.TabIndex = 16
			' 
			' lblEmailSyntaxPattern
			' 
			Me.lblEmailSyntaxPattern.Location = New System.Drawing.Point(281, 14)
			Me.lblEmailSyntaxPattern.Name = "lblEmailSyntaxPattern"
			Me.lblEmailSyntaxPattern.Size = New System.Drawing.Size(67, 26)
			Me.lblEmailSyntaxPattern.TabIndex = 57
			Me.lblEmailSyntaxPattern.Text = "Email Syntax" & vbCrLf & "Pattern:"
			' 
			' SettingsDialog
			' 
			Me.AcceptButton = Me.cmdOK
			Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
			Me.CancelButton = Me.cmdCancel
			Me.ClientSize = New System.Drawing.Size(607, 362)
			Me.Controls.Add(Me.general)
			Me.Controls.Add(Me.blackwhiteLists)
			Me.Controls.Add(Me.dnsSettings)
			Me.Controls.Add(Me.smtpSettings)
			Me.Controls.Add(Me.cmdCancel)
			Me.Controls.Add(Me.cmdOK)
			Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
			Me.MaximizeBox = False
			Me.MinimizeBox = False
			Me.Name = "SettingsDialog"
			Me.ShowInTaskbar = False
			Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent
			Me.Text = "Validator Settings"
'			Me.Load += New System.EventHandler(Me.SettingsForm_Load)
			Me.smtpSettings.ResumeLayout(False)
			Me.smtpSettings.PerformLayout()
			Me.dnsSettings.ResumeLayout(False)
			Me.dnsSettings.PerformLayout()
			Me.blackwhiteLists.ResumeLayout(False)
			Me.blackwhiteLists.PerformLayout()
			Me.general.ResumeLayout(False)
			Me.general.PerformLayout()
			Me.ResumeLayout(False)

		End Sub
		#End Region

		''' <summary>
		''' Handles the OK button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cmdOK_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdOK.Click
			Dim msg As String

			' Set Smtp info.
			_validator.SmtpFromEmail = txtMailFrom.Text
			_validator.SmtpHeloDomain = txtFromDomain.Text
			Try
				_validator.SmtpPort = Integer.Parse(txtSmtpPort.Text)
				If _validator.SmtpPort < 0 OrElse _validator.SmtpPort > 65535 Then
					msg = "Invalid Smtp Port, it must be between 0 to 65535"
					txtSmtpPort.Focus()
					GoTo HasError
				End If
			Catch exc As FormatException
				msg = "Invalid Smtp Port: " & exc.Message
				txtSmtpPort.Focus()
				GoTo HasError
			End Try
			Try
				_validator.SmtpTimeout = Integer.Parse(txtSmtpTimeout.Text)
				If _validator.SmtpTimeout < 0 OrElse _validator.SmtpTimeout > 3000000 Then
					msg = "Invalid Smtp Timeout, it must be between 0 to 3000000"
					txtSmtpTimeout.Focus()
					GoTo HasError
				End If
			Catch exc As FormatException
				msg = "Invalid Smtp Timeout: " & exc.Message
				txtSmtpTimeout.Focus()
				GoTo HasError
			End Try

			' Set Dns info
			Try
				_validator.DnsTimeout = Integer.Parse(txtDnsTimeout.Text)
				If _validator.DnsTimeout < 0 OrElse _validator.DnsTimeout > 3000000 Then
					msg = "Invalid Dns Timeout, it must be between 0 to 3000000"
					txtDnsTimeout.Focus()
					GoTo HasError
				End If
			Catch exc As FormatException
				msg = "Invalid Dns Timeout: " & exc.Message
				txtDnsTimeout.Focus()
				GoTo HasError
			End Try

			_validator.UseRandomDnsServer = chkRandomDns.Checked
			_validator.DnsServers.Clear()
			For Each str As String In lbxDnsServers.Items
				_validator.DnsServers.Add(str)
			Next str

			Select Case cboValidationLevel.SelectedIndex
				Case 0
					_validator.ValidationLevel = ValidationLevel.Syntax

				Case 1
					_validator.ValidationLevel = ValidationLevel.Lists

				Case 2
					_validator.ValidationLevel = ValidationLevel.MailExchangeRecords

				Case 3
					_validator.ValidationLevel = ValidationLevel.SmtpConnection

				Case 4
					_validator.ValidationLevel = ValidationLevel.Mailbox
			End Select

			_validator.UseMailExchangeRecordCache = chkCacheMXRecords.Checked
			_validator.DeepMailboxCheck = chkDeepCheck.Checked
			_validator.EmailSyntaxPattern = txtSyntaxPattern.Text

			Try
				_validator.MailExchangeRecordCacheTimeout = Integer.Parse(txtCacheTimeout.Text)
				If _validator.MailExchangeRecordCacheTimeout < 0 OrElse _validator.MailExchangeRecordCacheTimeout > 3000000 Then
					msg = "Invalid MailExchangeRecordCacheTimeout, it must be between 0 to 3000000"
					txtCacheTimeout.Focus()
					GoTo HasError
				End If
			Catch exc As FormatException
				msg = "Invalid MailExchangeRecordCacheTimeout: " & exc.Message
				txtCacheTimeout.Focus()
				GoTo HasError
			End Try

			DialogResult = System.Windows.Forms.DialogResult.OK
			Return

		HasError:
			MessageBox.Show(msg, "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop)
			Return
		End Sub

		Private Sub TextBox_Enter(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtMailFrom.Enter, txtBlackList.Enter, txtWhiteList.Enter
			Dim box As System.Windows.Forms.TextBox = CType(sender, System.Windows.Forms.TextBox)
			box.SelectionStart = 0
			box.SelectionLength = box.Text.Length
		End Sub

		Private Sub SettingsForm_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
		End Sub

		Private Sub cmdDnsServerAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDnsServerAdd.Click
			Dim dlg As New IPAddressForm()
			If dlg.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
				Return
			End If

			For Each s As String In lbxDnsServers.Items
				If s = dlg.Address Then
					Return
				End If
			Next s

			lbxDnsServers.Items.Add(dlg.Address)
		End Sub

		Private Sub cmdDnsServerRemove_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDnsServerRemove.Click
			Dim index As Integer = lbxDnsServers.SelectedIndex
			If index < 0 Then
				Return
			End If

			lbxDnsServers.Items.RemoveAt(index)

			If lbxDnsServers.Items.Count = 0 Then
				Return
			End If

			If index = lbxDnsServers.Items.Count Then
				index -= 1
			End If

			lbxDnsServers.SelectedIndex = index
		End Sub

		Private Sub lbxDnsServers_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lbxDnsServers.SelectedIndexChanged
			Dim index As Integer = lbxDnsServers.SelectedIndex
			If index < 0 Then
				cmdDnsServerEdit.Enabled = False
				cmdDnsServerRemove.Enabled = cmdDnsServerEdit.Enabled
			Else
				cmdDnsServerEdit.Enabled = True
				cmdDnsServerRemove.Enabled = cmdDnsServerEdit.Enabled
			End If
		End Sub

		Private Sub cmdDnsServerEdit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDnsServerEdit.Click
			Dim objItem As Object = lbxDnsServers.SelectedItem
			Dim index As Integer = lbxDnsServers.SelectedIndex
			If index = -1 Then
				Return
			End If

			Dim dlg As New IPAddressForm(CStr(objItem))
			If dlg.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
				Return
			End If

			lbxDnsServers.Items(index) = dlg.Address
		End Sub

		Private Sub cmdWhiteListBrowse_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdWhiteListBrowse.Click
			Dim dlg As New OpenFileDialog()
			dlg.FileName = txtWhiteList.Text
			dlg.Filter = "List File (*.txt)|*.txt|All files (*.*)|*.*"
			dlg.FilterIndex = 1
			dlg.Title = "Select White List File"
			If dlg.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
				Return
			End If

			txtWhiteList.Text = dlg.FileName
		End Sub

		Private Sub cmdBlackListBrowse_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdBlackListBrowse.Click
			Dim dlg As New OpenFileDialog()
			dlg.FileName = txtBlackList.Text
			dlg.Filter = "List File (*.txt)|*.txt|All files (*.*)|*.*"
			dlg.FilterIndex = 1
			dlg.Title = "Select Black List File"
			If dlg.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
				Return
			End If

			txtBlackList.Text = dlg.FileName
		End Sub

		Private Sub lbxDnsServers_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lbxDnsServers.DoubleClick
			cmdDnsServerEdit_Click(sender, e)
		End Sub
	End Class
End Namespace