Imports ComponentPro.Net
Imports ComponentPro.Net.Mail

Namespace MultipleThreads
	Partial Public Class ProxySettings
		Inherits Form
		Private ReadOnly _info As SettingInfo

		Public Sub New()
			InitializeComponent()
		End Sub

		Public Sub New(ByVal s As SettingInfo)
			Me.New()
			_info = s

			txtProxyHost.Text = s.ProxyServer
			txtProxyPort.Text = s.ProxyPort.ToString()
			txtUserName.Text = s.ProxyUser
			txtPassword.Text = s.ProxyPassword
			txtDomain.Text = s.ProxyDomain
			cbxType.SelectedIndex = CInt(Fix(s.ProxyType))
			cbxMethod.SelectedIndex = CInt(Fix(s.ProxyMethod))
		End Sub

		Private Sub btnOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnOK.Click
			Dim theport As Integer = 0
			If txtProxyPort.Text.Length > 0 Then
				Try
					Dim port As Integer
					port = Integer.Parse(txtProxyPort.Text)
					If port < 1 OrElse port > 65535 Then
						MessageBox.Show("Invalid port number, must be between 1 and 65535")
						Return
					End If
					theport = port
				Catch exc As Exception
					MessageBox.Show("Invalid port: " & exc.Message)
					Return
				End Try
			End If

			If txtPassword.Text.Length > 0 AndAlso txtUserName.Text.Length = 0 Then
				MessageBox.Show("Please enter user name")
				Return
			End If

			_info.ProxyServer = txtProxyHost.Text
			_info.ProxyType = CType(cbxType.SelectedIndex, ProxyType)
			_info.ProxyMethod = CType(cbxMethod.SelectedIndex, ProxyHttpConnectAuthMethod)
			_info.ProxyUser = txtUserName.Text
			_info.ProxyPassword = txtPassword.Text
			_info.ProxyDomain = txtDomain.Text
			_info.ProxyPort = theport

			Me.DialogResult = System.Windows.Forms.DialogResult.OK
		End Sub

		''' <summary>
		''' Handles the combo box proxy type's SelectedIndexChanged event.
		''' </summary>
		''' <param name="sender">The combo box.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cbx_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles cbxMethod.SelectedIndexChanged, cbxType.SelectedIndexChanged
			Dim enable As Boolean = cbxType.SelectedIndex > 0

			cbxMethod.Enabled = cbxType.SelectedIndex = CInt(Fix(ProxyType.HttpConnect)) ' Authentication method is available for HTTP Connect only.
			txtDomain.Enabled = cbxMethod.Enabled AndAlso cbxMethod.SelectedIndex = CInt(Fix(ProxyHttpConnectAuthMethod.Ntlm)) ' Domain is available for NTLM authentication method only.
			txtUserName.Enabled = enable ' User name and password are ignored with SendToProxy proxy type. -  && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtPassword.Enabled = enable ' && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyHost.Enabled = enable ' Proxy host and port are not available in NoProxy type.
			txtProxyPort.Enabled = enable
		End Sub
	End Class
End Namespace