using System;
using System.Windows.Forms;
using ComponentPro.Net;

namespace Pop3Downloader
{
    public partial class ProxySettings : Form
    {
        private string _proxyServer;
        private string _userName;
        private string _password;
        private string _domain;
        private int _port;
        private ProxyHttpConnectAuthMethod _authenticationMethod;
        private ProxyType _type;

        public ProxySettings()
        {
            InitializeComponent();            
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (txtProxyPort.Text.Length > 0)
                try
                {
                    int serverport;
                    serverport = int.Parse(txtProxyPort.Text);
                    if (serverport < 1 || serverport > 65535)
                    {
                        MessageBox.Show("Invalid port number, must be between 1 and 65535");
                        return;
                    }
                    _port = serverport;
                }
                catch (Exception exc)
                {
                    MessageBox.Show("Invalid port: " + exc.Message);
                    return;
                }

            if (txtPassword.Text.Length > 0 && txtUserName.Text.Length == 0)
            {
                MessageBox.Show("Please enter user name");
                return;
            }

            _proxyServer = txtProxyHost.Text;
            _type = (ProxyType)cbxType.SelectedIndex;
            _authenticationMethod = (ProxyHttpConnectAuthMethod)cbxMethod.SelectedIndex;
            _userName = txtUserName.Text;
            _password = txtPassword.Text;
            _domain = txtDomain.Text;

            this.DialogResult = DialogResult.OK;
        }

        public string ProxyServer
        {
            get
            {
                return _proxyServer;
            }
            set
            {
                _proxyServer = value;
            }
        }

        public string UserName
        {
            get
            {
                return _userName;
            }
            set
            {
                _userName = value;
            }
        }

        public string Password
        {
            get
            {
                return _password;
            }
            set
            {
                _password = value;
            }
        }

        public string Domain
        {
            get
            {
                return _domain;
            }
            set
            {
                _domain = value;
            }
        }

        public int Port
        {
            get
            {
                return _port;
            }
            set
            {
                _port = value;
            }
        }

        public ProxyHttpConnectAuthMethod AuthenticationMethod
        {
            get
            {
                return _authenticationMethod;
            }
            set
            {
                _authenticationMethod = value;
            }
        }

        public ProxyType Type
        {
            get
            {
                return _type;
            }
            set
            {
                _type = value;
            }
        }

        private void ProxySettings_Load(object sender, EventArgs e)
        {
            txtUserName.Text = _userName;
            txtPassword.Text = _password;
            txtDomain.Text = _domain;
            txtProxyHost.Text = _proxyServer;
            if (_port > 0)
                txtProxyPort.Text = _port.ToString();
            cbxMethod.SelectedIndex = (int)_authenticationMethod;
            cbxType.SelectedIndex = (int)_type;
        }

        /// <summary>
        /// Handles the combo box proxy type's SelectedIndexChanged event.
        /// </summary>
        /// <param name="sender">The combo box.</param>
        /// <param name="e">The event arguments.</param>
        private void cbx_SelectedIndexChanged(object sender, EventArgs e)
        {
            bool enable = cbxType.SelectedIndex > 0;

            cbxMethod.Enabled = cbxType.SelectedIndex == (int)ProxyType.HttpConnect; // Authentication method is available for HTTP Connect only.
            txtDomain.Enabled = cbxMethod.Enabled && cbxMethod.SelectedIndex == (int)ProxyHttpConnectAuthMethod.Ntlm; // Domain is available for NTLM authentication method only.
            txtUserName.Enabled = enable/* && cbxType.SelectedIndex != (int)ProxyType.SendToProxy*/; // User name and password are ignored with SendToProxy proxy type.
            txtPassword.Enabled = enable/* && cbxType.SelectedIndex != (int)ProxyType.SendToProxy*/;
            txtProxyHost.Enabled = enable; // Proxy host and port are not available in NoProxy type.
            txtProxyPort.Enabled = enable;
        }
    }
}