using System.Windows.Forms;
using ComponentPro.Security.Certificates;

namespace Pop3Client.Security
{
    public partial class CertValidator : Form
    {
        private bool _showAddToTrustedList;
        public bool ShowAddToTrustedList
        {
            get { return _showAddToTrustedList; }
            set { _showAddToTrustedList = value; }
        }

        private bool _addToTrustedList;
        public bool AddToTrustedList
        {
            get { return _addToTrustedList; }
        }

        private bool _accepted;
        public bool Accepted
        {
            get { return _accepted; }
        }

        private X509Certificate _cert;
        public X509Certificate Certificate
        {
            get { return _cert; }
            set { _cert = value; }
        }

        private void btnTrusted_Click(object sender, System.EventArgs e)
        {
            _addToTrustedList = true;
            _accepted = true;
            this.Close();
        }

        private void btnCancel_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }

        private void btnOk_Click(object sender, System.EventArgs e)
        {
            _accepted = true;
            this.Close();
        }

        public CertValidator()
        {
            InitializeComponent();
        }

        protected override void OnLoad(System.EventArgs e)
        {
            base.OnLoad(e);

            lblIssuerText.Text = _cert.Issuer.OrganizationName;
            lblUnitText.Text = _cert.Issuer.UnitName;
            lblLocationText.Text = string.Format("Country Code: {0}, State: {1}, City: {2}", _cert.Issuer.CountryCode, _cert.Issuer.State, _cert.Issuer.City);
            lblCommonNameText.Text = _cert.Issuer.CommonName;

            lblOrganizationSubText.Text = _cert.Subject.OrganizationName;
            lblUnitSubText.Text = _cert.Subject.UnitName;
            lblLocationSubText.Text = string.Format("Country Code: {0}, State: {1}, City: {2}", _cert.Subject.CountryCode, _cert.Subject.State, _cert.Subject.City);
            lblCommonNameSubText.Text = _cert.Subject.CommonName;

            lblFromText.Text = _cert.EffectiveDate.ToString();
            lblToText.Text = _cert.ExpiryDate.ToString();
        }
    }
}