Imports ComponentPro.Net.Mail

Namespace ImapClient
	Partial Public Class ImapClient
		''' <summary>
		''' Handles the folder tree view's AfterLabelEdit event.
		''' </summary>
		''' <param name="sender">The folder tree view object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub treeView_AfterLabelEdit(ByVal sender As Object, ByVal e As NodeLabelEditEventArgs) Handles treeView.AfterLabelEdit
			' Return if not connected.
			If client.State <> MailClientState.Ready Then
				_editing = False
				Return
			End If

			' Name has not been changed.
			If e.Node Is Nothing OrElse String.IsNullOrEmpty(e.Label) Then
				If e.Node.Tag Is Nothing Then ' New node
					e.Node.Remove()
				End If
				_editing = False
				Return
			End If

			' Contain an invalid character?
			If e.Label.IndexOf("*"c) >= 0 Then
				MessageBox.Show("Invalid folder name", "IMAP Client Demo", MessageBoxButtons.OK, MessageBoxIcon.Stop)
				e.CancelEdit = True
				If e.Node.Tag Is Nothing Then ' New node
					e.Node.Remove()
				End If
				_editing = False
				Return
			End If

			' Make sure name is unique.
			For Each node As TreeNode In e.Node.Parent.Nodes
				If e.Label = node.Text Then
					If e.Node IsNot node Then
						e.Node.BeginEdit()
					End If
					_editing = False
					Return
				End If
			Next node

			' If this is a new folder.
			If e.Node.Tag Is Nothing Then
				Try
					EnableDialog(False)
					Dim folder As String
					If _currentFolder.Length = 0 Then
						folder = e.Label
					Else
						folder = (_currentFolder & "/" & e.Label)
					End If
					client.CreateFolder(folder)
					e.Node.Tag = folder
					client.Select(folder)
					_currentFolder = folder
					listView.Items.Clear() ' Clear items as it is a newly created folder and does not have any new messages.
					e.Node.Text = e.Label
				Catch exc As Exception
					e.CancelEdit = True
					Util.ShowError(exc)
					e.Node.Remove()
				Finally
					_editing = False
					EnableDialog(True)
				End Try
			Else ' Then rename
				Dim oldName As String = CStr(e.Node.Tag)
				Dim path As String
				Dim i As Integer = oldName.LastIndexOf("/")
				If i >= 0 Then
					path = oldName.Substring(0, i) & "/" & e.Label
				Else
					path = e.Label
				End If

				Try
					client.Select("INBOX")
					_currentFolder = "INBOX"
					client.RenameFolder(oldName, path)
					e.Node.Tag = path
					_currentFolder = path
					client.Select(_currentFolder)
					RefreshFolderList()
				Catch exc As Exception
					e.CancelEdit = True
					Util.ShowError(exc)
				Finally
					_editing = False
				End Try
			End If
		End Sub

		Private _editing As Boolean
		''' <summary>
		''' Handles the folder tree view's BeforeLabelEdit event.
		''' </summary>
		''' <param name="sender">The folder tree view object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub treeView_BeforeLabelEdit(ByVal sender As Object, ByVal e As NodeLabelEditEventArgs) Handles treeView.BeforeLabelEdit
			' Cannot rename the root node.
			If e.Node.Parent Is Nothing Then
				e.CancelEdit = True
			Else
				_editing = True
			End If
		End Sub

		''' <summary>
		''' Handles the folder tree view's MouseDown event.
		''' </summary>
		''' <param name="sender">The folder tree view object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub treeView_MouseDown(ByVal sender As Object, ByVal e As MouseEventArgs) Handles treeView.MouseDown
			' Show Context Menu.
			If e.Button = MouseButtons.Right Then
				' Set selected box to one at location of click
				If treeView.SelectedNode IsNot treeView.GetNodeAt(e.X, e.Y) Then
					treeView.SelectedNode = treeView.GetNodeAt(e.X, e.Y)
				End If

				'Show context menu
				'treeViewContextMenuStrip.Show();
			End If
		End Sub

		Private _noFireBeforeSelectEvent As Boolean
		''' <summary>
		''' Handles the folder tree view's BeforeSelect event.
		''' </summary>
		''' <param name="sender">The folder tree view object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub treeView_BeforeSelect(ByVal sender As Object, ByVal e As TreeViewCancelEventArgs) Handles treeView.BeforeSelect
			If _editing Then
				Return
			End If

			Try
				If Not _noFireBeforeSelectEvent Then
					If e.Node.Parent IsNot Nothing Then
						_currentFolder = CStr(e.Node.Tag)
						client.Select(_currentFolder)
						If e.Node.Checked Then
							RefreshMessageList()
						Else
							RefreshFolderList()
							e.Node.Checked = True
						End If
						deleteFolderContextMenuItem.Enabled = True
						renameContextMenuItem.Enabled = True
						pasteContextMenuItem.Enabled = _copyInfo IsNot Nothing AndAlso _copyInfo.Count > 0
						pasteMessagesTreeViewContextMenuItem.Enabled = _copyInfo IsNot Nothing AndAlso _copyInfo.Count > 0
						uploadLocalMessagesContextMenuItem.Enabled = True
						uploadMessageToolStripMenuItem.Enabled = True
					Else
						_currentFolder = String.Empty
						listView.Items.Clear()

						If Not e.Node.Checked Then
							client.Select("INBOX")
							RefreshFolderList()
							e.Node.Checked = True
						End If

						deleteFolderContextMenuItem.Enabled = False
						renameContextMenuItem.Enabled = False
						pasteContextMenuItem.Enabled = False
						pasteMessagesTreeViewContextMenuItem.Enabled = False
						uploadLocalMessagesContextMenuItem.Enabled = False
						uploadMessageToolStripMenuItem.Enabled = True

						listView_SelectedIndexChanged(Nothing, Nothing)
					End If
				End If
			Catch exc As Exception
				Util.ShowError(exc)
			End Try
		End Sub

		''' <summary>
		''' Handles the folder tree view's KeyDown event.
		''' </summary>
		''' <param name="sender">The folder tree view object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub treeView_KeyDown(ByVal sender As Object, ByVal e As KeyEventArgs) Handles treeView.KeyDown
			If e.KeyCode = Keys.F2 AndAlso treeView.SelectedNode.Parent IsNot Nothing Then
				treeView.SelectedNode.BeginEdit()
			End If
		End Sub
	End Class
End Namespace