Imports System.Collections

Namespace ImapClient
	Public Class ListViewItemDateSorter
		Implements IComparer
		Private ReadOnly _columnToSort As Integer
		Private ReadOnly _sortOrder As SortOrder

		Public Sub New(ByVal columnToSort As Integer, ByVal sortOrder As SortOrder)
			_columnToSort = columnToSort
			_sortOrder = sortOrder
		End Sub

		Public Function Compare(ByVal xobject As Object, ByVal yobject As Object) As Integer Implements IComparer.Compare
			Dim x As ListItemTagInfo
			Dim y As ListItemTagInfo

			x = CType(CType(xobject, ListViewItem).Tag, ListItemTagInfo)
			y = CType(CType(yobject, ListViewItem).Tag, ListItemTagInfo)

			If _sortOrder = SortOrder.Descending Then
				Return y.DateTime.CompareTo(x.DateTime)
			Else
				Return x.DateTime.CompareTo(y.DateTime)
			End If
		End Function
	End Class

	Public Class ListViewItemNameSorter
		Implements IComparer
		Private ReadOnly _columnToSort As Integer
		Private ReadOnly _sortOrder As SortOrder

		Public Sub New(ByVal columnToSort As Integer, ByVal sortOrder As SortOrder)
			_columnToSort = columnToSort
			_sortOrder = sortOrder
		End Sub

		Public Function Compare(ByVal xobject As Object, ByVal yobject As Object) As Integer Implements IComparer.Compare
			Dim x As ListViewItem = CType(xobject, ListViewItem)
			Dim y As ListViewItem = CType(yobject, ListViewItem)
			Dim xname, yname As String

			If _columnToSort = 0 Then
				xname = x.Text
				yname = y.Text
			Else
				xname = x.SubItems(_columnToSort).Text
				yname = y.SubItems(_columnToSort).Text
			End If

			Dim result As Integer = xname.CompareTo(yname)

			If _sortOrder = SortOrder.Descending Then
				result = -result
			End If

			Return result
		End Function
	End Class

	Public Class ListViewItemSizeSorter
		Implements IComparer
		Private ReadOnly _columnToSort As Integer
		Private ReadOnly _sortOrder As SortOrder

		Public Sub New(ByVal columnToSort As Integer, ByVal sortOrder As SortOrder)
			_columnToSort = columnToSort
			_sortOrder = sortOrder
		End Sub

		Public Function Compare(ByVal xobject As Object, ByVal yobject As Object) As Integer Implements IComparer.Compare
			Dim x As ListItemTagInfo
			Dim y As ListItemTagInfo

			x = CType(CType(xobject, ListViewItem).Tag, ListItemTagInfo)
			y = CType(CType(yobject, ListViewItem).Tag, ListItemTagInfo)

			If _sortOrder = SortOrder.Descending Then
				Return y.Length.CompareTo(x.Length)
			Else
				Return x.Length.CompareTo(y.Length)
			End If
		End Function
	End Class
End Namespace