Imports ComponentPro.Net
Imports ComponentPro.Net.Mail

Namespace ImapClient
	Partial Public Class Login
		Inherits Form
		Private ReadOnly _info As LoginInfo

		Public Sub New()
			InitializeComponent()

			Util.PopulateEnum(GetType(SecurityMode), cbxSec)
			Util.PopulateEnum(GetType(ImapAuthenticationMethod), cbxMethod)
		End Sub

		Public Sub New(ByVal info As LoginInfo)
			Me.New()
			_info = info

			txtCertificate.Text = info.Cert

			cbxSec.SelectedItem = info.SecurityMode

			If info.Timeout >= 1000 Then
				txtTimeout.Text = info.Timeout.ToString()
			End If

			txtServer.Text = info.Server
			If info.Port > 0 Then
				txtPort.Text = info.Port.ToString()
			End If
			txtUserName.Text = info.UserName
			txtPassword.Text = info.Password

			cbxMethod.SelectedItem = info.Method

			txtProxyUserName.Text = info.ProxyUserName
			txtProxyPassword.Text = info.ProxyPassword
			txtProxyDomain.Text = info.ProxyDomain
			txtProxyHost.Text = info.ProxyServer
			If info.ProxyPort > 0 Then
				txtProxyPort.Text = info.ProxyPort.ToString()
			End If
			cbxProxyMethod.SelectedIndex = CInt(Fix(info.ProxyAuthenticationMethod))
			cbxType.SelectedIndex = CInt(Fix(info.ProxyType))
		End Sub


		Private Sub btnOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnOK.Click
			_info.SecurityMode = CType(cbxSec.SelectedItem, SecurityMode)

			If String.IsNullOrEmpty(txtServer.Text) Then
				MessageBox.Show("Please enter server name", "Error")
				Return
			End If

			_info.Server = txtServer.Text

			Try
				_info.Timeout = Integer.Parse(txtTimeout.Text)
			Catch e1 As FormatException
				_info.Timeout = 60000
				MessageBox.Show("Invalid timeout", "Error")
				Return
			End Try

			Try
				Dim port As Integer = Integer.Parse(txtPort.Text)
				If port < 1 OrElse port > 65535 Then
					MessageBox.Show("Invalid port, port must be from 1->65535", "Error")
					Return
				End If
				_info.Port = port
			Catch e2 As FormatException
				MessageBox.Show("Invalid port, port must be from 1->65535", "Error")
				Return
			End Try

			If txtProxyPort.Text.Length > 0 Then
				Try
					Dim port As Integer
					port = Integer.Parse(txtProxyPort.Text)
					If port < 1 OrElse port > 65535 Then
						MessageBox.Show("Invalid port number, must be between 1 and 65535")
						Return
					End If
					_info.ProxyPort = port
				Catch exc As Exception
					MessageBox.Show("Invalid port: " & exc.Message)
					Return
				End Try
			End If

			If String.IsNullOrEmpty(txtUserName.Text) Then
				MessageBox.Show("Please enter user name")
				Return
			End If

			If String.IsNullOrEmpty(txtPassword.Text) Then
				MessageBox.Show("Please enter password")
				Return
			End If

			_info.UserName = txtUserName.Text
			_info.Password = txtPassword.Text

			_info.Method = CType(cbxMethod.SelectedItem, ImapAuthenticationMethod)
			_info.Cert = txtCertificate.Text

			_info.ProxyServer = txtProxyHost.Text
			_info.ProxyType = CType(cbxType.SelectedIndex, ProxyType)
			_info.ProxyAuthenticationMethod = CType(cbxProxyMethod.SelectedIndex, ProxyHttpConnectAuthMethod)
			_info.ProxyUserName = txtProxyUserName.Text
			_info.ProxyPassword = txtProxyPassword.Text
			_info.ProxyDomain = txtProxyDomain.Text

			Me.DialogResult = System.Windows.Forms.DialogResult.OK
		End Sub

		Private Sub btnCertBrowse_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnCertBrowse.Click
			Dim dlg As New OpenFileDialog()
			dlg.Title = "Select a certificate file"
			dlg.FileName = txtCertificate.Text
			dlg.Filter = "All files|*.*"
			dlg.FilterIndex = 1
			If dlg.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
				txtCertificate.Text = dlg.FileName
			End If
		End Sub

		''' <summary>
		''' Handles the combo box proxy type's SelectedIndexChanged event.
		''' </summary>
		''' <param name="sender">The combo box.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cbx_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles cbxProxyMethod.SelectedIndexChanged, cbxType.SelectedIndexChanged
			Dim enable As Boolean = cbxType.SelectedIndex > 0

			cbxProxyMethod.Enabled = cbxType.SelectedIndex = CInt(Fix(ProxyType.HttpConnect)) ' Authentication method is available for HTTP Connect only.
			txtProxyDomain.Enabled = cbxProxyMethod.Enabled AndAlso cbxProxyMethod.SelectedIndex = CInt(Fix(ProxyHttpConnectAuthMethod.Ntlm)) ' Domain is available for NTLM authentication method only.
			txtProxyUserName.Enabled = enable ' User name and password are ignored with SendToProxy proxy type. -  && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyPassword.Enabled = enable ' && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyHost.Enabled = enable ' Proxy host and port are not available in NoProxy type.
			txtProxyPort.Enabled = enable
		End Sub
	End Class
End Namespace