Imports ComponentPro.Net.Mail
Imports ComponentPro.Net

Namespace ImapClient
	Public Class LoginInfo
		Private _sec As SecurityMode
		Private _cert As String
		Private _tls As Boolean
		Private _ssl As Boolean
		Private _suites As Integer

		Private _server As String
		Private _port As Integer
		Private _userName As String
		Private _password As String
		Private _method As ImapAuthenticationMethod
		Private _timeout As Integer

		#Region "Proxy"

		Private _proxyServer As String
		Private _proxyUserName As String
		Private _proxyPassword As String
		Private _proxyDomain As String
		Private _proxyPort As Integer
		Private _proxyAuthenticationMethod As ProxyHttpConnectAuthMethod
		Private _proxyType As ProxyType

		#End Region

		#Region "Download Options"

		'private ImapMessageListOption _downloadOption = ImapMessageListOption.Envelope;

		#End Region

		Public Property SecurityMode() As SecurityMode
			Get
				Return _sec
			End Get
			Set(ByVal value As SecurityMode)
				_sec = value
			End Set
		End Property

		Public Property Cert() As String
			Get
				Return _cert
			End Get
			Set(ByVal value As String)
				_cert = value
			End Set
		End Property

		Public Property Tls() As Boolean
			Get
				Return _tls
			End Get
			Set(ByVal value As Boolean)
				_tls = value
			End Set
		End Property

		Public Property Ssl() As Boolean
			Get
				Return _ssl
			End Get
			Set(ByVal value As Boolean)
				_ssl = value
			End Set
		End Property

		Public Property Suites() As Integer
			Get
				Return _suites
			End Get
			Set(ByVal value As Integer)
				_suites = value
			End Set
		End Property


		Public Property Server() As String
			Get
				Return _server
			End Get
			Set(ByVal value As String)
				_server = value
			End Set
		End Property

		Public Property Port() As Integer
			Get
				Return _port
			End Get
			Set(ByVal value As Integer)
				_port = value
			End Set
		End Property

		Public Property UserName() As String
			Get
				Return _userName
			End Get
			Set(ByVal value As String)
				_userName = value
			End Set
		End Property

		Public Property Password() As String
			Get
				Return _password
			End Get
			Set(ByVal value As String)
				_password = value
			End Set
		End Property

		Public Property Method() As ImapAuthenticationMethod
			Get
				Return _method
			End Get
			Set(ByVal value As ImapAuthenticationMethod)
				_method = value
			End Set
		End Property

		Public Property Timeout() As Integer
			Get
				Return _timeout
			End Get
			Set(ByVal value As Integer)
				_timeout = value
			End Set
		End Property


		#Region "Proxy"

		Public Property ProxyServer() As String
			Get
				Return _proxyServer
			End Get
			Set(ByVal value As String)
				_proxyServer = value
			End Set
		End Property

		Public Property ProxyUserName() As String
			Get
				Return _proxyUserName
			End Get
			Set(ByVal value As String)
				_proxyUserName = value
			End Set
		End Property

		Public Property ProxyPassword() As String
			Get
				Return _proxyPassword
			End Get
			Set(ByVal value As String)
				_proxyPassword = value
			End Set
		End Property

		Public Property ProxyDomain() As String
			Get
				Return _proxyDomain
			End Get
			Set(ByVal value As String)
				_proxyDomain = value
			End Set
		End Property

		Public Property ProxyPort() As Integer
			Get
				Return _proxyPort
			End Get
			Set(ByVal value As Integer)
				_proxyPort = value
			End Set
		End Property

		Public Property ProxyAuthenticationMethod() As ProxyHttpConnectAuthMethod
			Get
				Return _proxyAuthenticationMethod
			End Get
			Set(ByVal value As ProxyHttpConnectAuthMethod)
				_proxyAuthenticationMethod = value
			End Set
		End Property

		Public Property ProxyType() As ProxyType
			Get
				Return _proxyType
			End Get
			Set(ByVal value As ProxyType)
				_proxyType = value
			End Set
		End Property

		#End Region

		#Region "Static Methods"

		Public Shared Function LoadConfig() As LoginInfo
			' Load Login Information.
			Dim s As New LoginInfo()

			s._sec = CType(Util.GetIntProperty("Security", 0), SecurityMode)
			s._cert = CStr(Util.GetProperty("Cert", String.Empty))
			s._tls = CStr(Util.GetProperty("Tls", "True")) = "True"
			s._ssl = CStr(Util.GetProperty("Ssl", "True")) = "True"
			s._suites = Util.GetIntProperty("Suites", 0)

			s._server = CStr(Util.GetProperty("Server", String.Empty))
			s._port = Util.GetIntProperty("Port", 143)
			s._userName = CStr(Util.GetProperty("UserName", String.Empty))
			s._password = CStr(Util.GetProperty("Password", String.Empty))
			s._method = CType(Util.GetIntProperty("Method", 0), ImapAuthenticationMethod)
			s._timeout = Util.GetIntProperty("Timeout", 60000)

'			#Region "Proxy"

			s._proxyServer = CStr(Util.GetProperty("ProxyServer", String.Empty))
			s._proxyUserName = CStr(Util.GetProperty("ProxyUserName", String.Empty))
			s._proxyPassword = CStr(Util.GetProperty("ProxyPassword", String.Empty))
			s._proxyDomain = CStr(Util.GetProperty("ProxyDomain", String.Empty))
			s._proxyPort = Util.GetIntProperty("ProxyPort", 1080)
			s._proxyAuthenticationMethod = CType(Util.GetIntProperty("ProxyAuthenticationMethod", 0), ProxyHttpConnectAuthMethod)
			s._proxyType = CType(Util.GetIntProperty("ProxyType", 0), ProxyType)

'			#End Region

			Return s
		End Function

		Public Sub SaveConfig()
			Util.SaveProperty("Security", CInt(Fix(_sec)))
			Util.SaveProperty("Cert", _cert)
			Util.SaveProperty("Tls", _tls)
			Util.SaveProperty("Ssl", _ssl)
			Util.SaveProperty("Suites", _suites)

			Util.SaveProperty("Server", _server)
			Util.SaveProperty("Port", _port)
			Util.SaveProperty("UserName", _userName)
			Util.SaveProperty("Password", _password)
			Util.SaveProperty("Method", _method)
			Util.SaveProperty("Timeout", _timeout)

'			#Region "Proxy"

			Util.SaveProperty("ProxyServer", _proxyServer)
			Util.SaveProperty("ProxyUserName", _proxyUserName)
			Util.SaveProperty("ProxyPassword", _proxyPassword)
			Util.SaveProperty("ProxyDomain", _proxyDomain)
			Util.SaveProperty("ProxyPort", _proxyPort)
			Util.SaveProperty("ProxyAuthenticationMethod", CInt(Fix(_proxyAuthenticationMethod)))
			Util.SaveProperty("ProxyType", CInt(Fix(_proxyType)))

'			#End Region
		End Sub

		#End Region
	End Class
End Namespace