Imports System.Collections

Namespace Pop3Samples
	''' <summary>
	''' Date time sorter.
	''' </summary>
	Public Class ListViewItemDateSorter
		Implements IComparer
		Private ReadOnly _columnToSort As Integer
		Private ReadOnly _sortOrder As SortOrder

		Public Sub New(ByVal columnToSort As Integer, ByVal sortOrder As SortOrder)
			_columnToSort = columnToSort
			_sortOrder = sortOrder
		End Sub

		Public Function Compare(ByVal xobject As Object, ByVal yobject As Object) As Integer Implements IComparer.Compare
			Dim result As Integer

			Dim x As ListViewItem
			Dim y As ListViewItem

			x = CType(xobject, ListViewItem)
			y = CType(yobject, ListViewItem)

			If _columnToSort = 0 Then
				result = Date.Compare(Convert.ToDateTime(x.Text), Convert.ToDateTime(y.Text))
			Else
				result = Date.Compare(Convert.ToDateTime(x.SubItems(_columnToSort).Text), Convert.ToDateTime(y.SubItems(_columnToSort).Text))
			End If

			If _sortOrder = SortOrder.Descending Then
				result = -result
			End If

			Return result
		End Function
	End Class

	''' <summary>
	''' Name sorter.
	''' </summary>
	Public Class ListViewItemNameSorter
		Implements IComparer
		Private ReadOnly _columnToSort As Integer
		Private ReadOnly _sortOrder As SortOrder

		Public Sub New(ByVal columnToSort As Integer, ByVal sortOrder As SortOrder)
			_columnToSort = columnToSort
			_sortOrder = sortOrder
		End Sub

		Public Function Compare(ByVal xobject As Object, ByVal yobject As Object) As Integer Implements IComparer.Compare
			Dim x As ListViewItem = CType(xobject, ListViewItem)
			Dim y As ListViewItem = CType(yobject, ListViewItem)
			Dim xname, yname As String

			If _columnToSort = 0 Then
				xname = x.Text
				yname = y.Text
			Else
				xname = x.SubItems(_columnToSort).Text
				yname = y.SubItems(_columnToSort).Text
			End If

			Dim result As Integer = xname.CompareTo(yname)

			If _sortOrder = SortOrder.Descending Then
				result = -result
			End If

			Return result
		End Function
	End Class

	''' <summary>
	''' Size sorter.
	''' </summary>
	Public Class ListViewItemSizeSorter
		Implements IComparer
		Private ReadOnly _columnToSort As Integer
		Private ReadOnly _sortOrder As SortOrder

		Public Sub New(ByVal columnToSort As Integer, ByVal sortOrder As SortOrder)
			_columnToSort = columnToSort
			_sortOrder = sortOrder
		End Sub

		Public Function Compare(ByVal xobject As Object, ByVal yobject As Object) As Integer Implements IComparer.Compare
			Dim result As Integer

			Dim x As ListViewItem
			Dim y As ListViewItem

			Dim xname As String
			Dim yname As String

			x = CType(xobject, ListViewItem)
			y = CType(yobject, ListViewItem)

			If _columnToSort = 0 Then
				xname = x.Text
				yname = y.Text
			Else
				xname = x.SubItems(_columnToSort).Text
				yname = y.SubItems(_columnToSort).Text
			End If

			If xname = "" Then
				xname = "-1"
			End If

			If yname = "" Then
				yname = "-1"
			End If

			result = Decimal.Compare(Convert.ToDecimal(xname), Convert.ToDecimal(yname))

			If _sortOrder.Equals(SortOrder.Descending) Then
				result = -result
			End If

			Return result
		End Function
	End Class
End Namespace