Imports System.Windows.Forms
Imports ComponentPro.Security.Certificates

Namespace Pop3Client.Security
	Partial Public Class CertValidator
		Inherits Form
		Private _showAddToTrustedList As Boolean
		Public Property ShowAddToTrustedList() As Boolean
			Get
				Return _showAddToTrustedList
			End Get
			Set(ByVal value As Boolean)
				_showAddToTrustedList = value
			End Set
		End Property

		Private _addToTrustedList As Boolean
		Public ReadOnly Property AddToTrustedList() As Boolean
			Get
				Return _addToTrustedList
			End Get
		End Property

		Private _accepted As Boolean
		Public ReadOnly Property Accepted() As Boolean
			Get
				Return _accepted
			End Get
		End Property

		Private _cert As X509Certificate
		Public Property Certificate() As X509Certificate
			Get
				Return _cert
			End Get
			Set(ByVal value As X509Certificate)
				_cert = value
			End Set
		End Property

		Private Sub btnTrusted_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnTrusted.Click
			_addToTrustedList = True
			_accepted = True
			Me.Close()
		End Sub

		Private Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
			Me.Close()
		End Sub

		Private Sub btnOk_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnOk.Click
			_accepted = True
			Me.Close()
		End Sub

		Public Sub New()
			InitializeComponent()
		End Sub

		Protected Overrides Sub OnLoad(ByVal e As System.EventArgs)
			MyBase.OnLoad(e)

			lblIssuerText.Text = _cert.Issuer.OrganizationName
			lblUnitText.Text = _cert.Issuer.UnitName
			lblLocationText.Text = String.Format("Country Code: {0}, State: {1}, City: {2}", _cert.Issuer.CountryCode, _cert.Issuer.State, _cert.Issuer.City)
			lblCommonNameText.Text = _cert.Issuer.CommonName

			lblOrganizationSubText.Text = _cert.Subject.OrganizationName
			lblUnitSubText.Text = _cert.Subject.UnitName
			lblLocationSubText.Text = String.Format("Country Code: {0}, State: {1}, City: {2}", _cert.Subject.CountryCode, _cert.Subject.State, _cert.Subject.City)
			lblCommonNameSubText.Text = _cert.Subject.CommonName

			lblFromText.Text = _cert.EffectiveDate.ToString()
			lblToText.Text = _cert.ExpiryDate.ToString()
		End Sub
	End Class
End Namespace