﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using ComponentPro.Net.Mail;
using ComponentPro.Net;

namespace SendMail
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Main : Window
    {
        public Main()
        {
            InitializeComponent();

            PopulateEnum(typeof(SecurityMode), cbxMode);
        }

        void PopulateEnum(Type enumType, ComboBox ddl)
        {
            Array arr = Enum.GetValues(enumType);

            foreach (object item in arr)
            {
                ddl.Items.Add(item);
            }
        }

        private void btnUpload_Click(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrEmpty(txtTo.Text))
            {
                MessageBox.Show("To email cannot be empty", "Error", MessageBoxButton.OK, MessageBoxImage.Stop);
                return;
            }

            int port;
            try
            {
                port = int.Parse(txtPort.Text);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Invalid Port. Error: " + exc.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Stop);
                return;
            }
            if (port < 0 || port > 65535)
            {
                MessageBox.Show("Invalid port number", "Error", MessageBoxButton.OK, MessageBoxImage.Stop);
                return;
            }

            if (txtServer.Text.Length == 0)
            {
                MessageBox.Show("Host name cannot be empty", "Error", MessageBoxButton.OK, MessageBoxImage.Stop);
                return;
            }                

            Smtp client = new Smtp();

            try
            {
                client.Connect(txtServer.Text, port, (ComponentPro.Net.SecurityMode)cbxMode.SelectedIndex);
                if (!string.IsNullOrEmpty(txtUsername.Text))
                {
                    client.Authenticate(txtUsername.Text, txtPassword.Text);
                }

                MailMessage msg = new MailMessage();
                msg.From = txtFrom.Text;
                msg.To = txtTo.Text;
                msg.Cc = txtCC.Text;
                msg.Bcc = txtBcc.Text;
                msg.Subject = txtSubject.Text;
                msg.BodyHtml = txtContent.Text;

                client.Send(msg);

                client.Disconnect();

                MessageBox.Show("Message has been sent successfully!", "Email sent", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error: " + ex.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Stop);
            }
        }
    }
}
