using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.Text;
using ComponentPro.Net.Mail;
using ComponentPro.Net;
using ComponentPro;

class OrderProduct
{
    private int _partId;
    private string _productName;
    private int _quantity;
    private float _price;

    public int PartId
    {
        get { return _partId; }
        set { _partId = value; }
    }

    public string ProductName
    {
        get { return _productName; }
        set { _productName = value; }
    }

    public int Quantity
    {
        get { return _quantity; }
        set { _quantity = value; }
    }

    public float Price
    {
        get { return _price; }
        set { _price = value; }
    }
}

/// <summary>
/// This class will be used as a data source of the email template to personalize an email content.
/// </summary>
class User
{
    private string _fullName;
    private string _emailAddress;
    private string _password;

    /// <summary>
    /// Gets the full name of the customer.
    /// </summary>
    public string FullName
    {
        get { return _fullName; }
        set { _fullName = value; }
    }

    /// <summary>
    /// Gets the email address of the customer.
    /// </summary>
    public string EmailAddress
    {
        get { return _emailAddress; }
        set { _emailAddress = value; }
    }

    /// <summary>
    /// Gets the password to login of the customer.
    /// </summary>
    public string Password
    {
        get { return _password; }
        set { _password = value; }
    }

    /// <summary>
    /// Returns a list of purchased products.
    /// </summary>
    /// <returns>The purchased products.</returns>
    public OrderProduct[] GetOrders()
    {
        // Assume that this customer has purchased three products.
        OrderProduct[] ops = new OrderProduct[3];

        ops[0] = new OrderProduct();
        ops[0].PartId = 1239;
        ops[0].Price = 104.09f;
        ops[0].ProductName = "Product A";
        ops[0].Quantity = 3;

        ops[1] = new OrderProduct();
        ops[1].PartId = 22;
        ops[1].Price = 134.09f;
        ops[1].ProductName = "Product B";
        ops[1].Quantity = 1;

        ops[2] = new OrderProduct();
        ops[2].PartId = 167;
        ops[2].Price = 14.7f;
        ops[2].ProductName = "Product C";
        ops[2].Quantity = 5;

        return ops;
    }
}

public partial class _Default : System.Web.UI.Page
{
    /// <summary>
    /// Handles the Send button's Click event.
    /// </summary>
    /// <param name="sender">The button object.</param>
    /// <param name="e">The event arguments.</param>
    protected void btnSend_Click(object sender, EventArgs e)
    {
        int port = int.Parse(txtPort.Text);

        Smtp client = new Smtp();

        try
        {
            // Create a new mail message object.
            MailMessage msg = new MailMessage();
            // Set from address and to address.
            msg.From.Add(txtFrom.Text);
            msg.To.Add(txtTo.Text);

            TemplateEngine dt = new TemplateEngine();
            // Create an user defined object.
            User u = new User();
            // Set some information.
            u.EmailAddress = "myemail@somedomain.com";
            u.FullName = "John Borders";
            u.Password = "123abc";

            // Assign variables.
            dt.SetValue("CompanyName", "My Company Name");
            dt.SetValue("User", u);
            dt.SetValue("OrderId", "1625DGHJ");

            // Load template from the subject text box.
            dt.LoadFromString(txtSubject.Text);
            // Run/personalize the email subject for this customer.
            msg.Subject = dt.Run();

            // Load template from the content text box.
            dt.LoadFromString(txtContent.Text);
            // Run/personalize the email content for this customer.
            string content = dt.Run();
            content = "<font face='Courier New' size='2'>" + content.Replace("\r\n", "<br>") + "</font>";
            msg.BodyHtml = content;

            // Connect to the server.
            client.Connect(txtServer.Text, port, (SecurityMode)ddlSecurityMode.SelectedIndex);

            if (txtUser.Text.Trim().Length > 0)
                // Login to the server.
                client.Authenticate(txtUser.Text, txtPassword.Text);

            // Send the personalized message.
            client.Send(msg);

            // Show the result.
            lblResult.Text = "Message has been sent!";
        }
        catch (Exception exc)
        {
            // Show error.
            lblResult.Text = string.Format(null, "Exception: {0}", exc.Message);
        }
        finally
        {
            // Disconnect.
            client.Disconnect();
        }
    }
}