Imports System.Configuration
Imports System.Web.Security
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts
Imports System.Web.UI.HtmlControls
Imports System.Text
Imports ComponentPro.Net.Mail
Imports ComponentPro.Net
Imports ComponentPro

Friend Class OrderProduct
	Private _partId As Integer
	Private _productName As String
	Private _quantity As Integer
	Private _price As Single

	Public Property PartId() As Integer
		Get
			Return _partId
		End Get
		Set(ByVal value As Integer)
			_partId = value
		End Set
	End Property

	Public Property ProductName() As String
		Get
			Return _productName
		End Get
		Set(ByVal value As String)
			_productName = value
		End Set
	End Property

	Public Property Quantity() As Integer
		Get
			Return _quantity
		End Get
		Set(ByVal value As Integer)
			_quantity = value
		End Set
	End Property

	Public Property Price() As Single
		Get
			Return _price
		End Get
		Set(ByVal value As Single)
			_price = value
		End Set
	End Property
End Class

''' <summary>
''' This class will be used as a data source of the email template to personalize an email content.
''' </summary>
Friend Class User
	Private _fullName As String
	Private _emailAddress As String
	Private _password As String

	''' <summary>
	''' Gets the full name of the customer.
	''' </summary>
	Public Property FullName() As String
		Get
			Return _fullName
		End Get
		Set(ByVal value As String)
			_fullName = value
		End Set
	End Property

	''' <summary>
	''' Gets the email address of the customer.
	''' </summary>
	Public Property EmailAddress() As String
		Get
			Return _emailAddress
		End Get
		Set(ByVal value As String)
			_emailAddress = value
		End Set
	End Property

	''' <summary>
	''' Gets the password to login of the customer.
	''' </summary>
	Public Property Password() As String
		Get
			Return _password
		End Get
		Set(ByVal value As String)
			_password = value
		End Set
	End Property

	''' <summary>
	''' Returns a list of purchased products.
	''' </summary>
	''' <returns>The purchased products.</returns>
	Public Function GetOrders() As OrderProduct()
		' Assume that this customer has purchased three products.
		Dim ops(2) As OrderProduct

		ops(0) = New OrderProduct()
		ops(0).PartId = 1239
		ops(0).Price = 104.09F
		ops(0).ProductName = "Product A"
		ops(0).Quantity = 3

		ops(1) = New OrderProduct()
		ops(1).PartId = 22
		ops(1).Price = 134.09F
		ops(1).ProductName = "Product B"
		ops(1).Quantity = 1

		ops(2) = New OrderProduct()
		ops(2).PartId = 167
		ops(2).Price = 14.7F
		ops(2).ProductName = "Product C"
		ops(2).Quantity = 5

		Return ops
	End Function
End Class

Partial Public Class _Default
	Inherits System.Web.UI.Page
	''' <summary>
	''' Handles the Send button's Click event.
	''' </summary>
	''' <param name="sender">The button object.</param>
	''' <param name="e">The event arguments.</param>
	Protected Sub btnSend_Click(ByVal sender As Object, ByVal e As EventArgs)
		Dim port As Integer = Integer.Parse(txtPort.Text)

		Dim client As New Smtp()

		Try
			' Create a new mail message object.
			Dim msg As New MailMessage()
			' Set from address and to address.
			msg.From.Add(txtFrom.Text)
			msg.To.Add(txtTo.Text)

			Dim dt As New TemplateEngine()
			' Create an user defined object.
			Dim u As New User()
			' Set some information.
			u.EmailAddress = "myemail@somedomain.com"
			u.FullName = "John Borders"
			u.Password = "123abc"

			' Assign variables.
			dt.SetValue("CompanyName", "My Company Name")
			dt.SetValue("User", u)
			dt.SetValue("OrderId", "1625DGHJ")

			' Load template from the subject text box.
			dt.LoadFromString(txtSubject.Text)
			' Run/personalize the email subject for this customer.
			msg.Subject = dt.Run()

			' Load template from the content text box.
			dt.LoadFromString(txtContent.Text)
			' Run/personalize the email content for this customer.
			Dim content As String = dt.Run()
			content = "<font face='Courier New' size='2'>" & content.Replace(vbCrLf, "<br>") & "</font>"
			msg.BodyHtml = content

			' Connect to the server.
			client.Connect(txtServer.Text, port, CType(ddlSecurityMode.SelectedIndex, SecurityMode))

			If txtUser.Text.Trim().Length > 0 Then
				' Login to the server.
				client.Authenticate(txtUser.Text, txtPassword.Text)
			End If

			' Send the personalized message.
			client.Send(msg)

			' Show the result.
			lblResult.Text = "Message has been sent!"
		Catch exc As Exception
			' Show error.
			lblResult.Text = String.Format(Nothing, "Exception: {0}", exc.Message)
		Finally
			' Disconnect.
			client.Disconnect()
		End Try
	End Sub
End Class