Imports System.ComponentModel
Imports System.Text
Imports System.IO
Imports ComponentPro
Imports ComponentPro.Net.Mail

Namespace Samples
	Partial Public Class OrderInvoice
		Inherits Form
		Private _exception As Boolean

		Public Sub New()
			Try
				InitializeComponent()
			Catch exc As ComponentPro.Licensing.TemplateEngine.UltimateLicenseException
				MessageBox.Show(exc.Message)
				_exception = True
				Return
			End Try

			cbxSec.SelectedIndex = 0
			cbxMethod.SelectedIndex = 0
		End Sub

		Protected Overrides Sub OnLoad(ByVal e As EventArgs)
			MyBase.OnLoad(e)
			If _exception Then
				Me.Close()
			End If
		End Sub

		Private Class OrderProduct
			Private _partId As Integer
			Private _productName As String
			Private _quantity As Integer
			Private _price As Single

			Public Property PartId() As Integer
				Get
					Return _partId
				End Get
				Set(ByVal value As Integer)
					_partId = value
				End Set
			End Property

			Public Property ProductName() As String
				Get
					Return _productName
				End Get
				Set(ByVal value As String)
					_productName = value
				End Set
			End Property

			Public Property Quantity() As Integer
				Get
					Return _quantity
				End Get
				Set(ByVal value As Integer)
					_quantity = value
				End Set
			End Property

			Public Property Price() As Single
				Get
					Return _price
				End Get
				Set(ByVal value As Single)
					_price = value
				End Set
			End Property
		End Class

		''' <summary>
		''' This class will be used as a data source of the email template to personalize an email content.
		''' </summary>
		Private Class User
			Private _fullName As String
			Private _emailAddress As String
			Private _password As String

			''' <summary>
			''' Gets the full name of the customer.
			''' </summary>
			Public Property FullName() As String
				Get
					Return _fullName
				End Get
				Set(ByVal value As String)
					_fullName = value
				End Set
			End Property

			''' <summary>
			''' Gets the email address of the customer.
			''' </summary>
			Public Property EmailAddress() As String
				Get
					Return _emailAddress
				End Get
				Set(ByVal value As String)
					_emailAddress = value
				End Set
			End Property

			''' <summary>
			''' Gets the password to login of the customer.
			''' </summary>
			Public Property Password() As String
				Get
					Return _password
				End Get
				Set(ByVal value As String)
					_password = value
				End Set
			End Property

			''' <summary>
			''' Returns a list of purchased products.
			''' </summary>
			''' <returns>The purchased products.</returns>
			Public Function GetOrders() As OrderProduct()
				' Assume that this customer has purchased three products.
				Dim ops(2) As OrderProduct

				ops(0) = New OrderProduct()
				ops(0).PartId = 1239
				ops(0).Price = 104.09F
				ops(0).ProductName = "Product A"
				ops(0).Quantity = 3

				ops(1) = New OrderProduct()
				ops(1).PartId = 22
				ops(1).Price = 134.09F
				ops(1).ProductName = "Product B"
				ops(1).Quantity = 1

				ops(2) = New OrderProduct()
				ops(2).PartId = 167
				ops(2).Price = 14.7F
				ops(2).ProductName = "Product C"
				ops(2).Quantity = 5

				Return ops
			End Function
		End Class

		''' <summary>
		''' Personalizes email subject and body.
		''' </summary>
		''' <param name="subject">The email subject template.</param>
		''' <param name="body">The email body template</param>
		Private Sub Generate(ByRef subject As String, ByRef body As String)
			' Load subject template.
			dt.LoadFromString(txtSubject.Text)

			' Create a user defined object.
			Dim u As New User()
			' Set some information.
			u.EmailAddress = "myemail@somedomain.com"
			u.FullName = "John Borders"
			u.Password = "123abc"

			' Assign variables.
			dt.SetValue("CompanyName", "My Company Name")
			dt.SetValue("User", u)
			dt.SetValue("OrderId", "1625DGHJ")

			' Personalize email's subject.
			subject = dt.Run()

			' Load content template.
			dt.LoadFromString(txtSource.Text)

			' Personalize email's body.            
			body = dt.Run()
		End Sub

		''' <summary>
		''' Handles the Preview button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnPreview_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnPreview.Click
			Try
				Dim subject As String = Nothing
				Dim content As String = Nothing

				' Personalize email subject and content.
				Generate(subject, content)
				' Show them.
				txtSubjectGen.Text = subject
				txtOutput.Text = content
			Catch exc As Exception
				MessageBox.Show("An error occurred: " & exc.Message)
			End Try
		End Sub

		''' <summary>
		''' Handles the send menu item's Click event.
		''' </summary>
		''' <param name="sender">The menu item.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub sendToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs)
			Try
				Dim port As Integer
				Try
					' Parse and validate SMTP port number.
					port = Integer.Parse(txtPort.Text)
					If port < 1 OrElse port > 65535 Then
						MessageBox.Show("Invalid port, port must be from 1->65535", "Error")
						Return
					End If
				Catch e1 As FormatException
					MessageBox.Show("Invalid port, port must be from 1->65535", "Error")
					Return
				End Try

				If txtFrom.Text.Length = 0 Then
					MessageBox.Show("Please enter From email", "Error")
					Return
				End If

				If txtServer.Text.Length = 0 Then
					MessageBox.Show("Please enter server address", "Error")
					Return
				End If

				If txtTo.Text.Length = 0 Then
					MessageBox.Show("Please enter recipient(s)", "Error")
					Return
				End If

				If txtSubject.Text.Length = 0 Then
					MessageBox.Show("Please enter subject", "Error")
					Return
				End If

				If txtSource.Text.Length = 0 Then
					MessageBox.Show("Please enter body", "Error")
					Return
				End If

				' Create a new mail object.
				Dim mail As New MailMessage()
				Dim subject As String = Nothing, content As String = Nothing
				' Personalize subject and content.
				Generate(subject, content)
				' Build the message.
				mail.Subject = subject
				mail.BodyHtml = content
				mail.From.Add(txtFrom.Text)
				mail.To.Add(txtTo.Text)
				mail.Cc.Add(txtCC.Text)

				' Connect to the Smtp server.
				smtpClient.Connect(txtServer.Text, port, CType(cbxSec.SelectedIndex, ComponentPro.Net.SecurityMode))
				If txtUserName.Text.Trim().Length > 0 Then
					' Login with the user name and password provided.
					smtpClient.Authenticate(txtUserName.Text, txtPassword.Text, CType(cbxMethod.SelectedIndex, SmtpAuthenticationMethod))
				End If
				' Send generated mail.
				smtpClient.Send(mail)

				MessageBox.Show("Message has been sent successfully!", "Message Sent", MessageBoxButtons.OK, MessageBoxIcon.Information)
			Catch exc As Exception
				MessageBox.Show("An error occurred: " & exc.Message)
			Finally
				' Close the connection.
				smtpClient.Disconnect()
			End Try
		End Sub

		''' <summary>
		''' Handles the Send button's Click event.
		''' </summary>
		''' <param name="sender">The menu item.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnSend_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnSend.Click
			sendToolStripMenuItem_Click(Nothing, Nothing)
		End Sub
	End Class
End Namespace