﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using ComponentPro;

namespace DynamicEmailContent
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            txtTemplate.Text = "Dear $User.FullName$,\r\n" +
                               "{%set orders=User.GetOrders() /}\r\n" +
                               "Thank you for your order of $orders.Length$ items, We believe you will be very satisfied with the quality of costume pieces included in each. It is this quality that makes our imaginative play apparel so unique.\r\n\r\n" +
                               "We created an account for you to track your orders. Here is the login information:\r\n" +
                               "Email: $User.EmailAddress$\r\n" +
                               "Password: $User.Password$\r\n\r\n" +
                               "Following is the details of your order (OrderId: $OrderId$):\r\n" +
                               "#   Part ID    Name            Quantity     Price(per unit)       Sub Total\r\n" +
                               "{%set Total=0.0 /}{%foreach orderproduct,i in orders%}{%set Total = Total + orderproduct.Price * orderproduct.Quantity/}\r\n" +
                               "{%rendertemplate orderproducttemplate item=orderproduct/}{$foreach%}\r\n" +
                               "												                                               Total: $PadLeft(Format(Total,\"$$#.##\"),11)$\r\n\r\n" +
                               "If you have any concern, please call us at 913-555-0115.\r\n\r\n" +
                               "Sincerely,\r\n\r\n" +
                               "$CompanyName$\r\n" +
                               "{%template orderproducttemplate%}$PadLeft(i,4)$$PadLeft(item.PartId, 7)$    $PadRight(item.ProductName, 15)$        $PadRight(item.Quantity, 5)$        $PadLeft(Format(item.Price,\"$$#.##\"), 7)$   $PadLeft(Format(item.Price*item.Quantity,\"$$#.##\"), 12)${$template%}";
        }

        private void btnGenerate_Click(object sender, RoutedEventArgs e)
        {
            TemplateEngine dt = new TemplateEngine();

            dt.LoadFromString(txtTemplate.Text);
            // Create an user defined object.
            User u = new User();
            u.EmailAddress = "myemail@somedomain.com";
            u.FullName = "John Borders";
            u.Password = "123abc";

            // Assign variables.
            dt.SetValue("CompanyName", "My Company Name");
            dt.SetValue("User", u);
            dt.SetValue("OrderId", "1625DGHJ");

            txtOutput.Text = dt.Run();
        }
    }
}
