using System;
using System.Windows.Forms;
using System.IO;

namespace LoadFromFile
{
    public partial class LoadFromFileMain : Form
    {
        private readonly bool _exception;

        public LoadFromFileMain()
        {
            try
            {
                InitializeComponent();
            }
            catch (ComponentPro.Licensing.TemplateEngine.UltimateLicenseException exc)
            {
                MessageBox.Show(exc.Message);
                _exception = true;
            }

            string dataDir = AppDomain.CurrentDomain.BaseDirectory + "..\\..\\Data";
            if (!System.IO.Directory.Exists(dataDir))
                dataDir = AppDomain.CurrentDomain.BaseDirectory + "Data";

            txtFile.Text = dataDir + "\\OrderInvoice.txt";
            LoadFile();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            if (_exception)
                this.Close();
        }

        private void openTemplateSourceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            btnBrowse_Click(null, null);
        }

        private void saveTemplateSourceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                StreamWriter sw = new StreamWriter(txtFile.Text);
                sw.Write(txtSource.Text);
                sw.Close();
            }
            catch (Exception exc)
            {
                MessageBox.Show(string.Format("Unable to save {0}, error: {1}", txtFile.Text, exc.Message), "Error");
            }
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            try
            {
                dlg.FileName = txtFile.Text;
                dlg.Filter = "Template File (*.txt)|*.txt|All files (*.*)|*.*";
                dlg.FilterIndex = 1;
                dlg.Title = "Select Template Source File";
                if (dlg.ShowDialog() != DialogResult.OK)
                    return;

                txtFile.Text = dlg.FileName;
                LoadFile();
            }
            catch (Exception exc)
            {
                MessageBox.Show(dlg.FileName + " is not a valid address list, error: " + exc.Message, "Error");
            }            
        }

        private void LoadFile()
        {
            try
            {
                StreamReader sr = new StreamReader(txtFile.Text);
                txtSource.Text = sr.ReadToEnd();
                sr.Close();
            }
            catch (Exception exc)
            {
                MessageBox.Show(string.Format("Unable to load {0}, error: {1}", txtFile.Text, exc.Message), "Error");
            }
        }

        class OrderProduct
        {
            private int _partId;
            private string _productName;
            private int _quantity;
            private float _price;

            public int PartId
            {
                get { return _partId; }
                set { _partId = value; }
            }

            public string ProductName
            {
                get { return _productName; }
                set { _productName = value; }
            }

            public int Quantity
            {
                get { return _quantity; }
                set { _quantity = value; }
            }

            public float Price
            {
                get { return _price; }
                set { _price = value; }
            }
        }

        class User
        {
            private string _fullName;
            private string _emailAddress;
            private string _password;

            public string FullName
            {
                get { return _fullName; }
                set { _fullName = value; }
            }

            public string EmailAddress
            {
                get { return _emailAddress; }
                set { _emailAddress = value; }
            }

            public string Password
            {
                get { return _password; }
                set { _password = value; }
            }

            public OrderProduct[] GetOrders()
            {
                OrderProduct[] ops = new OrderProduct[3];

                ops[0] = new OrderProduct();
                ops[0].PartId = 1239;
                ops[0].Price = 104.09f;
                ops[0].ProductName = "Product A";
                ops[0].Quantity = 3;

                ops[1] = new OrderProduct();
                ops[1].PartId = 22;
                ops[1].Price = 134.09f;
                ops[1].ProductName = "Product B";
                ops[1].Quantity = 1;

                ops[2] = new OrderProduct();
                ops[2].PartId = 167;
                ops[2].Price = 14.7f;
                ops[2].ProductName = "Product C";
                ops[2].Quantity = 5;

                return ops;
            }
        }

        private void btnRun_Click(object sender, EventArgs e)
        {
            try
            {
                dt.LoadFromString(txtSource.Text);
                dt.SetValue("CompanyName", "My Company Name");
                
                User u = new User();
                u.EmailAddress = "myemail@somedomain.com";
                u.FullName = "John Borders";
                u.Password = "123abc";
                dt.SetValue("User", u);
                dt.SetValue("OrderId", "1625DGHJ");

                txtOutput.Text = dt.Run();
            }
            catch (Exception exc)
            {
                MessageBox.Show("An error occurred: " + exc.Message);
            }
        }

        private void runToolStripMenuItem_Click(object sender, EventArgs e)
        {
            btnRun_Click(null, null);
        }
    }
}