using System;
using System.Windows.Forms;
using ComponentPro;

namespace NamespaceSample
{
    public static class MyTestClass
    {
        public static string TestString
        {
            get { return "Static String"; }
        }

        public static string GetStaticString(string s)
        {
            return string.Format("GetStaticString returns {0}", s);
        }

        public static string MyFormat(string message, params object[] parameters)
        {
            return string.Format(message, parameters);
        }
    }

    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            try
            {
                // In this string template source: variable c will be a char, s is an array of three characters.
                TemplateEngine ctl = new TemplateEngine();
                ctl.LoadFromString("{%set c='c'/}{%set s={'a','b','c'}/}$string.Format(\"{0} abc {1}\",1,2)$ -- $using(\"NamespaceSample,Namespace\")$$MyTestClass.TestString$ - $MyTestClass.GetStaticString(\"Test\")$ - $MyTestClass.MyFormat(\"My Format '{0}', '{1}'\", 1, 2)$");
                string s = ctl.Run();
                MessageBox.Show(s);
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        }
    }
}