Namespace AdvancedDemo
	Friend NotInheritable Class Util

		Private Sub New()
		End Sub

		Private Shared _samplesDir As String
		''' <summary>
		''' Gets the default samples folder.
		''' </summary>
		Public Shared ReadOnly Property SamplesDir() As String
			Get
				If _samplesDir Is Nothing Then
					_samplesDir = System.IO.Path.GetFullPath(AppDomain.CurrentDomain.BaseDirectory & "..\..\Samples")
					If Not System.IO.Directory.Exists(_samplesDir) Then
						_samplesDir = AppDomain.CurrentDomain.BaseDirectory & "Samples"
					End If
				End If

				Return _samplesDir
			End Get
		End Property

		Private Shared _outputDir As String
		''' <summary>
		''' Gets the default output folder.
		''' </summary>
		Public Shared ReadOnly Property OutputDir() As String
			Get
				If _outputDir Is Nothing Then
					_outputDir = System.IO.Path.GetDirectoryName(_samplesDir) & "\Output"
				End If

				Return _outputDir
			End Get
		End Property

		Private Shared _dataDir As String
		''' <summary>
		''' Gets the default data folder.
		''' </summary>
		Public Shared ReadOnly Property DataDir() As String
			Get
				If _dataDir Is Nothing Then
					_dataDir = System.IO.Path.GetDirectoryName(_samplesDir) & "\Data"
				End If

				Return _dataDir
			End Get
		End Property
	End Class
End Namespace