Imports ComponentPro

Namespace MethodAndPropertyRestriction
	Public NotInheritable Class MyTestClass

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestString() As String
			Get
				Return "Static String"
			End Get
		End Property

		Public Shared Function GetStaticString(ByVal s As String) As String
			Return String.Format("GetStaticString returns {0}", s)
		End Function
	End Class

	Public NotInheritable Class ClassRestricted

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestString() As String
			Get
				Return "Test String in a restricted class"
			End Get
		End Property
	End Class

	Public NotInheritable Class MethodAndProperty

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestStringRestricted() As String
			Get
				Return "Restricted String"
			End Get
		End Property

		Public Shared Function GetStaticStringRestricted(ByVal s As String) As String
			Return String.Format("GetStaticStringRestricted returns {0}", s)
		End Function

		Public Shared ReadOnly Property StaticStringAllowed() As String
			Get
				Return "StaticStringAllowed"
			End Get
		End Property
	End Class

	Friend NotInheritable Class Program

		Private Sub New()
		End Sub

		''' <summary>
		''' The main entry point for the application.
		''' </summary>
		<STAThread> _
		Shared Sub Main()
			Try
				Dim ctl As New TemplateEngine()
				ctl.LoadFromString("$using(""MethodAndPropertyRestriction,MethodAndPropertyRestriction"")$$MyTestClass.TestString$" & vbCrLf & "$MyTestClass.GetStaticString(""Test"")$" & vbCrLf & "$ClassRestricted.TestString$" & vbCrLf & "$MethodAndProperty.TestStringRestricted$" & vbCrLf & "$MethodAndProperty.GetStaticStringRestricted()$" & vbCrLf & "$MethodAndProperty.StaticStringAllowed$")
				ctl.RestrictedMethodList.Add("*.ClassRestricted.*")
				ctl.RestrictedPropertyList.Add("*.ClassRestricted.*")
				ctl.RestrictedMethodList.Add("*.MethodAndProperty.GetStaticString*")
				ctl.AllowedMethodList.Add("*.MethodAndProperty.GetStaticStringAllowed")
				ctl.RestrictedPropertyList.Add("*.TestStringRestricted")
				Dim s As String = ctl.Run()
				MessageBox.Show(s)
			Catch exc As Exception
				MessageBox.Show(exc.Message)
			End Try
		End Sub
	End Class
End Namespace