Imports ComponentPro

Namespace NamespaceSample
	Public NotInheritable Class MyTestClass

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestString() As String
			Get
				Return "Static String"
			End Get
		End Property

		Public Shared Function GetStaticString(ByVal s As String) As String
			Return String.Format("GetStaticString returns {0}", s)
		End Function

		Public Shared Function MyFormat(ByVal message As String, ParamArray ByVal parameters() As Object) As String
			Return String.Format(message, parameters)
		End Function
	End Class

	Friend NotInheritable Class Program

		Private Sub New()
		End Sub

		''' <summary>
		''' The main entry point for the application.
		''' </summary>
		<STAThread> _
		Shared Sub Main()
			Try
				' In this string template source: variable c will be a char, s is an array of three characters.
				Dim ctl As New TemplateEngine()
				ctl.LoadFromString("{%set c='c'/}{%set s={'a','b','c'}/}$string.Format(""{0} abc {1}"",1,2)$ -- $using(""NamespaceSample,Namespace"")$$MyTestClass.TestString$ - $MyTestClass.GetStaticString(""Test"")$ - $MyTestClass.MyFormat(""My Format '{0}', '{1}'"", 1, 2)$")
				Dim s As String = ctl.Run()
				MessageBox.Show(s)
			Catch exc As Exception
				MessageBox.Show(exc.Message)
			End Try
		End Sub
	End Class
End Namespace